*
* $Id: gpcalv.F,v 3.2 2002/12/05 10:17:41 pamela Exp $
*
* $Log: gpcalv.F,v $
* Revision 3.2  2002/12/05 10:17:41  pamela
* Update CAS and CALO geometries and positions. Makefile updated as well
*
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  3.00/00 14/11/2000  10.17.50  by  Emiliano Mocchiutti
*CMZ :  2.02/00 12/10/2000  18.19.42  by  Francesco Cafagna
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 21/10/99  14.46.25  by  Francesco Cafagna
*CMZ :  1.00/02 13/03/96  18.39.55  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   09/12/95
      SUBROUTINE GPCALV
************************************************************************
*                                                                      *
* Volumes definition for the silicon calorimeter                       *
* Called by: GPGEM                                                     *
* Author: Francesco Cafagna, 05/12/95 13.39.41                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gpkey.inc"
*
      INTEGER IROT,IVOLU,N,NMED
      REAL X,Y,Z
*
*  Define the CALB     volume
*
      NMED= MN2
      CALL GSVOLU('CALB','BOX ',NMED,CALB, 3,IVOLU)
*
*  Define the CALS     volume
*
      NMED= MAL
      CALL GSVOLU('CALS','BOX ',NMED,CALS, 3,IVOLU)
*
*  Define the CAPL     volume
*
      NMED= MN2
      CALL GSVOLU('CAPL','BOX ',NMED,CAPL, 3,IVOLU)
* F.V.&ML:
*
*  Define the CANS     volume
*
      NMED= MN2
      CALL GSVOLU('CANS','BOX ',NMED,CANS, 3,IVOLU)
* END  F.V.&ML.
*
*  Define the CAPD     volume
*
      NMED= MN2
      CALL GSVOLU('CAPD','BOX ',NMED,CAPD, 3,IVOLU)
*
*  Define the CASI     volume
*
      NMED= MSIC
      CALL GSVOLU('CASI','BOX ',NMED,CASI, 3,IVOLU)
*
*  Division in CASI
*
* ML:
C      CALL GSDVN ('CAST','CASI',NCASTR,1)
      CALL GSDVN ('CAST','CASI',NCASTR,2)
* END ML:
*
*  Define the CG10     volume
*
      NMED= MG10C
      CALL GSVOLU('C10C','BOX ',NMED,C10C, 3,IVOLU)
*
*  Define the CAAB     volume
*
      NMED= MW2
      CALL GSVOLU('CAAB','BOX ',NMED,CAAB, 3,IVOLU)
*EM:
*
*  Define the CAAD     volume
*
      NMED= MAL
      CALL GSVOLU('CAAD','BOX ',NMED,CAAD, 3,IVOLU)
*
*  Define the CAKA     volume
*
      NMED= MCER
      CALL GSVOLU('CAKA','BOX ',NMED,CAKA, 3,IVOLU)
*
*  Define the CAKP     volume
*
      NMED= MKAP
      CALL GSVOLU('CAKP','BOX ',NMED,CAKP, 3,IVOLU)
*
*  Define the CAGL     volume (Silicon glue)
*
      NMED= MSIC
      CALL GSVOLU('CAGL','BOX ',NMED,CAGL, 3,IVOLU)
*END EM.
*
* Positioning volumes CAKA, C10C, CAGL, CAKP into the mother CAPL and CAPD
* (Kaolite and G10 only for CAPD)
*
      N = 1
      X = 0.
      Y = 0.
*EM:
*F.V.&ML:
c      CALL GPVOLU(-2)
C      Z = -CAPL(3) + CAKA(3)
C      CALL GSPOS('CAKA',N,'CAPL',X,Y,Z,0,'ONLY')
      Z = -CANS(3) + CAKA(3)
      CALL GSPOS('CAKA',N,'CANS',X,Y,Z,0,'ONLY')
C      CALL GSPOS('CAKA',N,'CAPD',X,Y,Z,0,'ONLY')
      Z = Z + CAKA(3) + C10C(3)
C      CALL GSPOS('C10C',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('C10C',N,'CANS',X,Y,Z,0,'ONLY')
C      CALL GSPOS('C10C',N,'CAPD',X,Y,Z,0,'ONLY')
      Z = Z + C10C(3) + CAGL(3)
C      CALL GSPOS('CAGL',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('CAGL',N,'CANS',X,Y,Z,0,'ONLY')
      Z = Z + CAGL(3) + CAKP(3)
C      CALL GSPOS('CAKP',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('CAKP',N,'CANS',X,Y,Z,0,'ONLY')
* END F.V.&ML
*
* Positioning volume CASI into the mother CAPL
*
      N = 0
* F.V.&ML:
C      Z= Z + CAKP(3) + CASI(3)
      Z = -CAPL(3)+CASI(3)
* END F.V.&ML
      DO I=-1,1
         Y = I*(2.*CASI(2)+ DCASIY)
         DO II=-1,1
            N= N + 1
            X = II*(2.*CASI(1)+ DCASIX)
*
* Check if detector is excluded
*
            IF(.NOT.NOCASI(N))
     +           CALL GSPOS('CASI',N,'CAPL',X,Y,Z,0,'ONLY')
         ENDDO
      ENDDO
*END EM.
*F.V.&ML:
C commenting the original code with a 'C' per raw:
C*
C* Positioning volume CAPL and CAAB into the mother CALB
C*
C      X= 0.
C      Y= 0.
CC      Z= CALB(3) + CAPL(3)
C*EM:
C      Z= CALB(3) + CAPL(3) - DCASIZ/2.
C*END EM. (we have 0.15 cm from the top to the first Si)
C      N= 0
C      DO I=1,NCAPL
C*
C* X view, absorber and Y view on the other
C*
C         Z= Z - 2*CAPL(3)
C         N= N + 1
C*
C* Check if this plane is excluded
C*
C         IF(.NOT.NOCAPL(N))
C     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,0,'ONLY')
C         Z= Z - CAPL(3) - CAAB(3)
C*
C* Check if this absorber is excluded
C*
C         IF(.NOT.NOCAAB(I))
C     +        CALL GSPOS('CAAB',(I-1),'CALB',X,Y,Z,0,'ONLY')
C         Z= Z - CAAB(3) - CAPL(3)
C         N= N + 1
C*
C* Check if this detector is excluded
C*
C         IF(.NOT.NOCAPL(N))
C     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,3,'ONLY')
C      ENDDO
C end comments.
*
* Positioning volume CANS ,CAPL and CAAB into the mother CALB
*
      X= 0.
      Y= 0.
      Z= CALB(3) + CAPL(3) - DCASIZ/2.
*END EM. (we have 0.15 cm from the top to the first Si)
      N= 0
*
*	I DISPARI
      DO I=1,NCAPL,2
*
* X view, absorber and Y view on the other
*
	 X=0.10
	 Y=0.05
         Z= Z - 2*CAPL(3)
         N= N + 1
*
* Check if this plane is excluded
*
*
         IF(.NOT.NOCAPL(N))
     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,0,'ONLY')
*
         X = 0.
         Y = 0.
         Z= Z - CAPL(3) - CANS(3)
*
         CALL GSPOS('CANS',N,'CALB',X,Y,Z,0,'ONLY')
*
         Z= Z - CANS(3) - CAAB(3)
*
* Check if this absorber is excluded
*
*
         IF(.NOT.NOCAAB(I))
     +        CALL GSPOS('CAAB',(I-1),'CALB',X,Y,Z,0,'ONLY')
*
         Z = Z - CAAB(3)- CANS(3)
         N = N + 1
*     
         CALL GSPOS('CANS',N,'CALB',X,Y,Z,3,'ONLY')
         Z= Z - CANS(3) - CAPL(3)
         X=-0.05
         Y=0.10
*
* Check if this detector is excluded
*
         IF(.NOT.NOCAPL(N))
     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,3,'ONLY')
	 N=N+2
	 Z = Z -2*(2*CAPL(3)+2*CANS(3)+CAAB(3))
      ENDDO
*
*	I PARI
*
      X= 0.
      Y= 0.
      Z= CALB(3) + CAPL(3) - DCASIZ/2.
*END EM. (we have 0.15 cm from the top to the first Si)
      N= 2
*
*
      DO I=2,NCAPL,2
*
* X view, absorber and Y view on the other
*
         Z= Z - 2*CAPL(3)-2*(2*CAPL(3)+2*CANS(3)+CAAB(3))
         N= N + 1
*
* Check if this plane is excluded
         X= -0.10
         Y= -0.05
*
         IF(.NOT.NOCAPL(N))
     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,0,'ONLY')
	 X = 0.
	 Y = 0.
         Z = Z - CAPL(3) - CANS(3)
*
       	 CALL GSPOS('CANS',N,'CALB',X,Y,Z,0,'ONLY')
*
* Check if this absorber is excluded
*
         N = N + 1
         Z = Z - CANS(3) - CAAB(3)
*     
         IF(.NOT.NOCAAB(I))
     +        CALL GSPOS('CAAB',(I-1),'CALB',X,Y,Z,0,'ONLY')
*
	 Z= Z - CAAB(3) - CANS(3)
*
         CALL GSPOS('CANS',N,'CALB',X,Y,Z,3,'ONLY')
         Z= Z - CANS(3) - CAPL(3)
         X= 0.05
         Y= -0.10
*
*
* Check if this detector is excluded
*
         IF(.NOT.NOCAPL(N))
     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,3,'ONLY')
         N = N + 2
*
      ENDDO
*END F.V.&ML.
* F.V.&ML.:
* again we have to comment with a 'C' per raw:
C*
C* Positioning volume CAPD and CAAD into the mother CALB
C*
C      N= 0
C      DO I=1,NCAPLD
C         IF(I.EQ.1) THEN
C            Z= Z - CAPD(3) - CAPL(3)
C         ELSE
C            Z= Z - 2*CAPD(3)
C         ENDIF
C         N= N + 1
C         CALL GSPOS('CAPD',N,'CALB',X,Y,Z,0,'ONLY')
C         Z= Z - CAPD(3) - CAAD(3)
C         CALL GSPOS('CAAD',(I-1),'CALB',X,Y,Z,0,'ONLY')
C         Z= Z - CAAD(3) - CAPD(3)
C         N= N + 1
C         CALL GSPOS('CAPD',N,'CALB',X,Y,Z,3,'ONLY')
C      ENDDO
* end comments.
*END F.V.&ML.
*
* Put the shell around it
*
      X= 0.
      Y= 0.
      Z= CALS(3)-CALB(3)
      N= 1
      CALL GSPOS('CALB',N,'CALS',X,Y,Z,0,'ONLY')
*
      RETURN
      END
