*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 25/02/2000  19.34.00  by  Francesco Cafagna
*CMZ :  1.02/00 06/03/97  21.46.02  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.47.15  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   21/02/96
      SUBROUTINE GPUTOF(IACT,IS,ID,IPA,IT,DELOSS,TIME,PATH,
     +                  TRAPAR,NUMVOL,IMEC)
************************************************************************
*                                                                      *
* To collect and store the hit structure for TOF                       *
*                                                                      *
* Variables definition:                                                *
* IN:                                                                  *
*  IACT, integer specifing the action to be taken. It is the INWVOL    *
*        variable in GCTRAK common                                     *
*  IS    , set number                                                  *
*  ID    , detector number                                             *
*  IPA   , particle number                                             *
*  IT    , track number                                                *
*  DELOSS, energy loss in the step                                     *
*  TIME  , current time of flight in seconds                           *
*  PATH  , current track lenght                                        *
*  TRAPAR, track parameter, is the VECT vector in GCTRAK common        *
*  NUMVOL, integr array of numbers identifying the DETECTOR            *
*  IMEC  , integer indicating the LOSS mecanism position inside NMEC   *
*          vector, zero if not present                                 *
*                                                                      *
* Called by: GUSTEP                                                    *
* Author: Francesco Cafagna, 21/02/96 16.13.51                         *
*                                                                      *
************************************************************************
#include "gphit.inc"
#include "gcunit.inc"
#include "gpsed.inc"
*
      INTEGER IACT,IS,ID,IPA,IT,NUMVOL(20),IMEC,IDHIT
      REAL DELOSS,TIME,PATH,TRAPAR(7),VHIT(NHTOF)
      LOGICAL SAVE
*
* Track is inside a volume
*
      IF(IACT.EQ.0) THEN
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
*ML:
*            VHIT(7) = DELOSS + VHIT(7)
            VHIT(11) = DELOSS + VHIT(11)
*END ML.
         ENDIF
      ENDIF
*
* Entering a new volume or is a new track
*
      IF(IACT.EQ.1) THEN
         SAVE = .FALSE.
         CALL VZERO(VHIT,NHTOF)
         DO I=1,3
            VHIT(I) = TRAPAR(I)
         ENDDO
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
*ML:
            VHIT(11) = DELOSS
*            VHIT(7) = DELOSS
*END ML.
         ENDIF
         VHIT(8) = TIME
         VHIT(9) = PATH
         VHIT(10) = IPA
*ML:
*         VHIT(11) = TRAPAR(7)
         VHIT(7) = TRAPAR(7)
*END ML.
         IDHIT = -1
      ENDIF
*
* Track is exiting current volume
*
      IF(IACT.EQ.2) THEN
         DO I=1,3
            VHIT(I+3) = TRAPAR(I)
#if defined(GPAMELA_INTER)
* interactive case, we need the average position
            VHIT(I) = (VHIT(I) + VHIT(I+3) )/2.
#endif
         ENDDO
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
*ML:
*            VHIT(7) = DELOSS + VHIT(7)
            VHIT(11) = DELOSS +VHIT(11)
*END ML.
         ENDIF
         VHIT(8) = (TIME + VHIT(8))/2.
         VHIT(9) = PATH - VHIT(9)
*ML:
*         VHIT(11) = (TRAPAR(7) + VHIT(11))/2.
         VHIT(7) = (TRAPAR(7) + VHIT(7))/2.
*END ML.
*
* Store the hit
*
         IF(IDHIT.EQ.-1) THEN
*ML:
*            IF (SAVE) CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
*            IF (IDHIT.EQ.0) THEN
*               WRITE(CHMAIL,10000) IS,ID,IT
*               CALL GMAIL(1,0)
*            ENDIF
*         ELSE
*            WRITE(CHMAIL,10100) IS,ID,IT
*            CALL GMAIL(1,0)
*         ENDIF
            IF (SAVE) THEN
               IF(IS.EQ.ISS4) THEN
                  CALL GSCHIT(IS,ID,1,NUMVOL,VHIT,1,IDHIT)
               ELSE
                  CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
               ENDIF
            ENDIF
            IF (IDHIT.EQ.0) THEN
               WRITE(CHMAIL,10000) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
         ELSE
            WRITE(CHMAIL,10100) IS,ID,IT
            CALL GMAIL(1,0)
         ENDIF
*     END ML.
      ENDIF
*
* Track is exiting the set up
*
      IF(IACT.EQ.3) THEN
*
* Check if the hit have been previously stored or not
*
         IF(IDHIT.LT.0) THEN
            DO I=1,3
               VHIT(I+3) = TRAPAR(I)
#if defined(GPAMELA_INTER)
* interactive case, we need the average position
               VHIT(I) = (VHIT(I) + VHIT(I+3) )/2.
#endif
            ENDDO
            IF(IMEC.GT.0) THEN
               SAVE = .TRUE.
*ML:
*               VHIT(7) = DELOSS + VHIT(7)
               VHIT(11) = DELOSS + VHIT(11)
*END ML.
            ENDIF
            VHIT(8) = (TIME + VHIT(8))/2.
            VHIT(9) = PATH - VHIT(9)
*ML:
*            VHIT(11) = (TRAPAR(7) + VHIT(11))/2.
            VHIT(7) = (TRAPAR(7) + VHIT(7))/2.
*END ML.
*
* Store the hit
*
            IF(IDHIT.EQ.-1) THEN
*ML:
*            IF (SAVE) CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
*            IF (IDHIT.EQ.0) THEN
*               WRITE(CHMAIL,10200) IS,ID,IT
*               CALL GMAIL(1,0)
*            ENDIF
*         ELSE
*            WRITE(CHMAIL,10300) IS,ID,IT
*            CALL GMAIL(1,0)
*         ENDIF
               IF (SAVE) THEN
                  IF(IS.EQ.ISS4) THEN
                     CALL GSCHIT(IS,ID,1,NUMVOL,VHIT,1,IDHIT)
                  ELSE
                     CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
                  ENDIF
               ENDIF
               IF (IDHIT.EQ.0) THEN
                  WRITE(CHMAIL,10200) IS,ID,IT
                  CALL GMAIL(1,0)
               ENDIF
            ELSE
               WRITE(CHMAIL,10300) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
*END ML.
*               IF (SAVE) CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
*               IF (IDHIT.EQ.0) THEN
*                  WRITE(CHMAIL,10200) IS,ID,IT
*                  CALL GMAIL(1,0)
*               ENDIF
*            ELSE
*               WRITE(CHMAIL,10300) IS,ID,IT
*               CALL GMAIL(1,0)
*            ENDIF
         ENDIF
      ENDIF
10000 FORMAT(' GPUTOF error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10100 FORMAT(' GPUTOF error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10200 FORMAT(' GPUTOF error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10300 FORMAT(' GPUTOF error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
      RETURN
      END











