*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.17  by  Marialuigia Ambriola
*CMZ :  2.00/00 28/02/2000  13.36.53  by  Francesco Cafagna
*CMZ :  1.01/00 13/05/96  14.41.05  by  Francesco Cafagna
*CMZ :  1.00/02 19/03/96  17.11.16  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   23/02/96
      SUBROUTINE GPRHIT(CS,CD,IS,ID,NVOL,NH,NHM,NHS,IT,NDV,
     +                  ITA,NUM,VHIT,NHITS)
************************************************************************
*                                                                      *
* Generic routine to retrive hit structure                             *
* Variables definition:                                                *
* IN:                                                                  *
*                                                                      *
*  CD   , detector name;                                               *
*  IS   , set number;                                                  *
*  ID   , detector number;                                             *
*  NVOL , number of volumes;                                           *
*  NH   , number of hit;                                               *
*  NHM  , maximum number of hits to be retrived                        *
*  NHS  , hit number to start with to be retrived                      *
*  IT   , track number to be retrived. IT=-1, means all the tracks     *
*  NDV  , copy number identify the detector                            *
*                                                                      *
* OUT:                                                                 *
*                                                                      *
*  ITA  , 1D array of track number wich has produced the hit           *
*  NUM  , 2D array of copy number to identify the detector             *
*  VHIT , 2D array of hits                                             *
*  NHITS, number of hits retrived. Negative value if is greater than   *
*         NHITMAX                                                      *
*                                                                      *
* Called by: <USER>                                                    *
* Author: Francesco Cafagna, 23/02/96 14.14.38                         *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gcflag.inc"
*
      CHARACTER*4 CS,CD
      INTEGER IS,ID,NVOL,NH,NHM,NHS,IT,NDV,ITA,NUM,NHITS
      REAL VHIT
      DIMENSION ITA(NHM),NDV(NVOL),NUM(NVOL,NHM),VHIT(NH,NHM)
*
      IF (IT.EQ.-1) IT=0
      CALL VZERO(VHIT,NH*NHM)
      CALL VZERO(ITA ,NHM)
      CALL VZERO(NUM ,NVOL*NHM)
      NHITS = 0
      CALL GFHITS(CS,CD,NVOL,NH,NHM,IT,NDV,ITA,NUM,VHIT,NHITS)
*      CALL GPRSHT(CS,CD,NVOL,NH,NHM,NHS,IT,NDV,ITA,NUM,VHIT,NHITS)
*
* Check on the number of hits
*
      IF(NHITS.GT.NHM) THEN
         WRITE(CHMAIL,10000) CS,CD,NHITS,NHM,IDRUN,IDEVT
         CALL GMAIL(1,0)
         NHITS = - NHITS
      ENDIF
10000 FORMAT(' GPRHIT: More than NHMAX hits: SET=',A4,', DET=',A4,
     +       ',NHITS=',I5,', NHMAX=',I5,', RUN=',I5,', EVT=',I8)
      RETURN
      END
