*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 06/03/2000  13.07.03  by  Francesco Cafagna
*CMZ :  2.00/00 03/03/2000  15.39.05  by  Francesco Cafagna
*CMZU:  1.01/00 26/04/96  15.12.30  by  Paolo (The Magic) Papini
*-- Author :
      SUBROUTINE GUFLD(V,F)
************************************************************************
*                                                                      *
* To map Pamela magnetic field                                         *
* A bit of housekeeping: delete print statement etc. etc., by F. Caf.  *
*                                                                      *
* Variables definition:                                                *
* IN:                                                                  *
*  V , vector with coordinates in MARS                                 *
* OUT:                                                                 *
*  F , Magnetic field components along X, Y and Z                      *
*                                                                      *
* Called by: GHELIX, GRKUTA                                            *
* Author: Paolo Papini   16/02/96                                      *
*                                                                      *
************************************************************************
#include "gpfield.inc"
*
      INTEGER II,III
      REAL DISM,F0X,F0Y,F0Z,F1X,F1Y,F1Z,F2X,F2Y,F2Z,
     +     F3X,F3Y,F3Z
      REAL V(3),F(3),AV(3)
*
* Transform coordinates to Spectrometer frame
*
      CALL GPMASPE(V)
*
* Take just the absolute value for the coordinates
*
      DO I=1,3
         AV(I) = ABS( V(I) )
      ENDDO
      F(1)=0.
      F(2)=0.
      F(3)=0.
*
* Check if we are outside the map
*
      IF( (AV(1).GE.20).OR.(AV(2).GE.20).OR.(AV(3).GE.60.) )
     +    GOTO 10
      IV(1)=INT(AV(1)*2.)+1
      IV(2)=INT(AV(2)*2.)+1
      IV(3)=INT(AV(3)/2.)+1
      DO I1=0,1
         DO I2=0,1
            DO I3=0,1
               II=I1*4+I2*2+I3+1
               VV(II,1)=FLOAT(IV(1)+I1-1)*0.5
               VV(II,2)=FLOAT(IV(2)+I2-1)*0.5
               VV(II,3)=FLOAT(IV(3)+I3-1)*2.
               IVV(II,1)=IV(1)+I1
               IVV(II,2)=IV(2)+I2
               IVV(II,3)=IV(3)+I3
               DD(II)=(VV(II,1)-AV(1))**2 + (VV(II,2)-AV(2))**2 +
     +         (VV(II,3)-AV(3))**2
            ENDDO
         ENDDO
      ENDDO
* --- v0
      DISM=1.E9
      II=0
      DO I=1,8
         IF(DD(I).LT.DISM) THEN
            DISM=DD(I)
            II=I
         END IF
      END DO
      DO I=1,3
         V0(I)=VV(II,I)
      END DO
      F0X=FX(IVV(II,1),IVV(II,2),IVV(II,3))
      F0Y=FY(IVV(II,1),IVV(II,2),IVV(II,3))
      F0Z=FZ(IVV(II,1),IVV(II,2),IVV(II,3))
* --- v1
      V1(2)=V0(2)
      V1(3)=V0(3)
      IF(AV(1).GE.V0(1)) THEN
         III=IVV(II,1)+1
         V1(1)=V0(1)+0.5
      ELSE
         III=IVV(II,1)-1
         V1(1)=V0(1)-0.5
      END IF
      F1X=FX(III,IVV(II,2),IVV(II,3))
      F1Y=FY(III,IVV(II,2),IVV(II,3))
      F1Z=FZ(III,IVV(II,2),IVV(II,3))
* --- v2
      V2(1)=V0(1)
      V2(3)=V0(3)
      IF(AV(2).GE.V0(2)) THEN
         III=IVV(II,2)+1
         V2(2)=V0(2)+0.5
      ELSE
         III=IVV(II,2)-1
         V2(2)=V0(2)-0.5
      END IF
      F2X=FX(IVV(II,1),III,IVV(II,3))
      F2Y=FY(IVV(II,1),III,IVV(II,3))
      F2Z=FZ(IVV(II,1),III,IVV(II,3))
* --- v3
      V3(1)=V0(1)
      V3(2)=V0(2)
      IF(AV(3).GE.V0(3)) THEN
         III=IVV(II,3)+1
         V3(3)=V0(3)+2.
      ELSE
         III=IVV(II,3)-1
         V3(3)=V0(3)-2.
      END IF
      F3X=FX(IVV(II,1),IVV(II,2),III)
      F3Y=FY(IVV(II,1),IVV(II,2),III)
      F3Z=FZ(IVV(II,1),IVV(II,2),III)
* --- linear interpolation, magnetic field calculation
      CALL FLIN3(V0,V1,V2,V3,F0X,F1X,F2X,F3X,AV,F(1))
      CALL FLIN3(V0,V1,V2,V3,F0Y,F1Y,F2Y,F3Y,AV,F(2))
      CALL FLIN3(V0,V1,V2,V3,F0Z,F1Z,F2Z,F3Z,AV,F(3))
* --- mirroing
      IF(V(2).LT.0.) THEN
         F(1)=-1.*F(1)
         F(3)=-1.*F(3)
      END IF
      IF(V(1).LT.0.) F(1)=-1.*F(1)
      IF(V(3).LT.0.) F(3)=-1.*F(3)
*
* Transform coordinates back to MARS
*
   10 CALL GPSPEMA(V)
      RETURN
      END
