*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.05  by  Francesco Cafagna
*CMZ :  1.02/00 09/02/2000  13.11.57  by  Francesco Cafagna
*CMZ :  1.00/02 15/03/96  16.04.21  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   05/12/95
      SUBROUTINE GPTRDV
************************************************************************
*                                                                      *
* Volume definition for TRD                                            *
* Called by: GPGEO                                                     *
* Author: Francesco Cafagna, 05/12/95 17.25.32                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM,NAN
      REAL X,Y,Z
*
*  Define the TRDB     volume
*
      NMED=MN2
      CALL GSVOLU('TRDB','BOX ',NMED,TRDB, 3,IVOLU)
*
*  Define the TRAN     volume
*
      NMED=MAL
      CALL GSVOLU('TRAN','BOX ',NMED,TRAN, 3,IVOLU)
*
*  Define the TRAI     volume
*
      NMED=MN2
      CALL GSVOLU('TRAI','BOX ',NMED,TRAI, 3,IVOLU)
*
*  Define the TRBS     volumes
*
      NMED=MN2
      CALL GSVOLU('TRBS','BOX ',NMED,TRBS, 3,IVOLU)
*
*  Define the TRSO     volumes
*
      NMED=MKAP
      CALL GSVOLU('TRSO','TUBE',NMED,TRSO, 3,IVOLU)
*
*  Define the TRSI     volumes
*
      NMED=MXE
      CALL GSVOLU('TRSI','TUBE',NMED,TRSI, 3,IVOLU)
*
*  Define the TRRA     volumes
*
      NMED=MTRAD
      CALL GSVOLU('TRRA','BOX ',NMED,TRRA, 3,IVOLU)
*
*   Define the TRFR    volumes
*
      NMED=MCF
      CALL GSVOLU('TRFR','BOX ',NMED,TRFR, 3,IVOLU)
*
*   Define the TRFI    volumes
*
      NMED=MN2
      CALL GSVOLU('TRFI','BOX ',NMED,TRFI, 3,IVOLU)
*
*   Define the TRDT    volumes
*
      NMED=MAL
      CALL GSVOLU('TRDT','BOX ',NMED,TRDT, 3,IVOLU)
*
* Positioning volumes TRSI     into mothers TRSO
*
      N= 1
      X= 0.
      Y= 0.
      Z= 0.
*      CALL GSPOS('TRSI',N,'TRSO',X,Y,Z,0,'ONLY')
*Positioning volumes TRSO into mothers TRSI, because now TRSO is included in
*TRSI and TRSI is included in TRBS
      CALL GSPOS('TRSO',N,'TRSI',X,Y,Z,0,'ONLY')
*
*
* Positioning volumes TRSO     into mothers TRBS. Remember we have to put
* tubes one over each other
*
      Y=0.
      NUM = 0
      DO II=1,2
#if defined(GPAMELA_UNIX)
         Z= TRSO(2) * COS(30./180.*ACOS(-1.)) * (-1)**II
#endif
#if !defined(GPAMELA_UNIX)
         Z= TRSO(2) * COSD(30.) * (-1)**II
#endif
         DO I=1, 16
            NUM = NUM + 1
            X= -TRBS(1) + II*TRSO(2) + (I-1)*2.*TRSO(2)
*            CALL GSPOS('TRSO',NUM,'TRBS',X,Y,Z,2,'ONLY')
*now TRSI is into TRBS (I don't change TRSO(2) in TRSI(2) because they
*are equal and the velue of X does not change:
            CALL GSPOS('TRSI',NUM,'TRBS',X,Y,Z,2,'ONLY')
         ENDDO
      ENDDO
*
* Positioning volumes TRFI     into mothers TRFR
*
      N= 1
      X= 0.
      Y= 0.
      Z= 0.
      CALL GSPOS('TRFI',N,'TRFR',X,Y,Z,0,'ONLY')
*
* Positioning volumes TRAI     into mothers TRAN
*
      N= 1
      X= 0.
      Y= TRAN(2)-TRAI(2)
      Z= 0.
      CALL GSPOS('TRAI',N,'TRAN',X,Y,Z,0,'ONLY')
*
* Positioning volumes TRAI, TRFR, TRBS&TRRA     into the mother TRDB
*
      NAN = 0
      Z= -TRDB(3) + TRAN(3)
      DO I = 1,2
         X = (-1)**(I-1)*TRAN(1)+ (-1)**I*TRDB(1)
         Y = -TRAN(2)+ TRDB(2)
         NAN = NAN + 1
         CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,0,'ONLY')
         Y = +TRAN(2)- TRDB(2)
         NAN = NAN + 1
         CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,4,'ONLY')
      ENDDO
      Y= 0.
*      Z= -TRDB(3) + TRRA(3) + GAPTRD
      NUM = 0
      M=3
      Z = Z + TRAN(3)
      DO I=1,4
         X= 0.
         Z= Z + TRFR(3)
         CALL GSPOS('TRFR',I,'TRDB',X,Y,Z,0,'ONLY')
         Z= Z + TRFR(3) + TRBS(3)
         DO II=1, M
            NUM = NUM + 1
*shift of modules to have the right overlap:
            X= (II-1)*2.*TRBS(1) - ( M*TRBS(1) - TRBS(1) ) -
     +           (II-2)*TRSI(2)
*now there two different volumes interested at same time:
*            CALL GSPOS('TRBS',NUM,'TRDB',X,Y,Z,0,'ONLY')
            CALL GSPOS('TRBS',NUM,'TRDB',X,Y,Z,0,'MANY')
         ENDDO
         DO III = 1,2
            X = (-1)**(III-1)*TRAN(1)+ (-1)**III*TRDB(1)
            Y = -TRAN(2)+ TRDB(2)
            NAN = NAN + 1
            CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,0,'ONLY')
            Y = TRAN(2) - TRDB(2)
            NAN = NAN + 1
            CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,4,'ONLY')
         ENDDO
         X = 0.
         Y = 0.
         Z = Z + TRSO(2)*( 1 + COS(30./180.*ACOS(-1.))) + TRRA(3)
C #          Z= Z + 2*TRSO(2) + TRRA(3)
         CALL GSPOS('TRRA',I,'TRDB',X,Y,Z,0,'ONLY')
C #          Z= Z - (2*TRSO(2) + TRRA(3)) + TRBS(3)
         Z = Z - ( TRSO(2)*( 1 + COS(30./180.*ACOS(-1.))) + TRRA(3))
     +        + TRBS(3)
      ENDDO
      M=4
      DO I=1,5
         X= 0.
         Z= Z + TRFR(3)
         CALL GSPOS('TRFR',(I+4),'TRDB',X,Y,Z,0,'ONLY')
         Z= Z + TRFR(3) + TRBS(3)
         DO II=1, M
            NUM = NUM + 1
*shift of modules to have the right overlap:
            X= (II-1)*2.*TRBS(1) - ( M*TRBS(1) - TRBS(1) )
     +           + (3/2 -(II-1))*TRSI(2)
*now there two different volumes interested at same time:
*            CALL GSPOS('TRBS',NUM,'TRDB',X,Y,Z,0,'ONLY')
            CALL GSPOS('TRBS',NUM,'TRDB',X,Y,Z,0,'MANY')
         ENDDO
         DO III = 1,2
            X = (-1)**(III-1)*TRAN(1)+ (-1)**III*TRDB(1)
            Y = -TRAN(2)+ TRDB(2)
            NAN = NAN + 1
            CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,0,'ONLY')
            Y = TRAN(2) - TRDB(2)
            NAN = NAN + 1
            CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,4,'ONLY')
         ENDDO
         X= 0.
         Y= 0.
         Z = Z + TRSO(2)*( 1 + COS(30./180.*ACOS(-1.))) + TRRA(3)
C #          Z= Z + 2*TRSO(2) + TRRA(3)
         CALL GSPOS('TRRA',(I+4),'TRDB',X,Y,Z,0,'ONLY')
C #          Z= Z - (2*TRSO(2) + TRRA(3)) +TRBS(3)
         Z = Z - (TRSO(2)*( 1 + COS(30./180.*ACOS(-1.))) + TRRA(3) )
     +        + TRBS(3)
      ENDDO
*
* Positioning an extra radiator plane on top
*
      Z = Z - TRBS(3) + TRSO(2)*( 1 + COS(30./180.*ACOS(-1.)))
     +     + 3*TRRA(3)
      CALL GSPOS('TRRA',NUM,'TRDB',X,Y,Z,0,'ONLY')
      Z = Z + TRBS(3) -( TRSO(2)*( 1 + COS(30./180.*ACOS(-1.)))
     +     + 3*TRRA(3) )
*
* Positioning the TOP frame
*
      X = 0.
      Y = 0.
      Z = Z + TRFR(3)
      CALL GSPOS('TRFR',10,'TRDB',X,Y,Z,0,'ONLY')
*
* Positioning the angular pieces to hold the TOF. TRAN & TRDT
*
      Z = Z + TRFR(3) + TRAN(3)
      DO I = 1,2
         X = (-1)**(I-1)*TRAN(1)+ (-1)**I*TRDB(1)
         Y = -TRAN(2)+ TRDB(2)
         NAN = NAN + 1
         CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,0,'ONLY')
         Y = +TRAN(2)- TRDB(2)
         NAN = NAN + 1
         CALL GSPOS('TRAN',NAN,'TRDB',X,Y,Z,4,'ONLY')
      ENDDO
      Z = Z + TRAN(3) + TRDT(3)
      NDT = 0
      DO I = 1,2
         X = (-1)**(I-1)*(2*TRAN(1)-TRDT(1))+ (-1)**I*TRDB(1)
         Y = -(2*TRAN(2)-TRDT(2)) + TRDB(2)
         NDT = NDT + 1
         CALL GSPOS('TRDT',NDT,'TRDB',X,Y,Z,0,'ONLY')
         Y = +(2*TRAN(2)-TRDT(2)) - TRDB(2)
         NDT = NDT + 1
         CALL GSPOS('TRDT',NDT,'TRDB',X,Y,Z,0,'ONLY')
      ENDDO
      RETURN
      END
