*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 22/10/99  16.17.58  by  Francesco Cafagna
*CMZ :  1.01/00 21/05/96  17.33.38  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.08.24  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   23/02/96
      SUBROUTINE GPDCAS
************************************************************************
*                                                                      *
* To perform CAS digitization                                          *
*                                                                      *
* Called by: GUDIGI                                                    *
* Author: Francesco Cafagna, 23/02/96 12.50.38                         *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gpphit.inc"
      PARAMETER (NH=NHCAS,NHM=NHMCAS,NVOL=2)
#include "gprhit.inc"
#include "gpcas.inc"
#include "gpsed.inc"
*
      INTEGER IS,ID,NV,NVM
      CHARACTER*4 CSET
*
*
* Vector zeroed
*
      CALL VZERO(ICAS,NHM)
      CALL VZERO(XCAS,NHM)
      CALL VZERO(YCAS,NHM)
      CALL VZERO(ZCAS,NHM)
      CALL VZERO(XOCAS,NHM)
      CALL VZERO(YOCAS,NHM)
      CALL VZERO(ZOCAS,NHM)
      CALL VZERO(ERCAS,NHM)
      CALL VZERO(TIMECAS,NHM)
      CALL VZERO(PACAS,NHM)
      CALL VZERO(P0CAS,NHM)
      CALL VZERO(ICASPAR,NHM)
      CALL VZERO(NUMD ,NVOL)
*
      NV = NVOL
      NVM= NVMAX
      IS   = ISCAS
      ID   = IDCASX
      CSET = 'CAS '
      IT = -1
*
* Check on the volume level
*
      IF (NV.GT.NVM) THEN
         WRITE(CHMAIL,10000) CSET,CNSED(IS,ID),NVOL,NVMAX,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
      CALL VZERO(VHITS,NH*NHM)
      CALL VZERO(ITRA ,NHM)
      CALL VZERO(NUMBV,NVOL*NHM)
      NHITS = -1
      CALL GPRHIT(CSET,CNSED(IS,ID),IS,ID,NVOL,NH,NHM,1,
     +            IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*
* If there was a problem in GPRHIT then exit
*
      IF(NHITS.LT.0) THEN
         WRITE(CHMAIL,10100) CSET,CNSED(IS,ID),NHITS,NHM,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
*
* >>>>>>>>>>>>>>>>>>>>>> DIGI action
*
*
* Fill the CWN common
*
      NTHCAS = NHITS
      DO I=1,NHITS
         ICAS(I)  = NUMBV(NVCAS,I)
#if defined(GPAMELA_INTER)
         XINCAS(I)  = 2*VHITS(1,I)-VHITS(4,I)
         YINCAS(I)  = 2*VHITS(2,I)-VHITS(5,I)
         ZINCAS(I)  = 2*VHITS(3,I)-VHITS(6,I)
#endif
#if !defined(GPAMELA_INTER)
         XINCAS(I)  = VHITS(1,I)
         YINCAS(I)  = VHITS(2,I)
         ZINCAS(I)  = VHITS(3,I)
#endif
         XOUTCAS(I) = VHITS(4,I)
         YOUTCAS(I) = VHITS(5,I)
         ZOUTCAS(I) = VHITS(6,I)
         ERELCAS(I) = VHITS(7,I)
         TIMECAS(I)=  VHITS(8,I)
         PATHCAS(I) = VHITS(9,I)
         IPARCAS(I) = VHITS(10,I)
         P0CAS(I) = VHITS(11,I)
      ENDDO
*
* Next detector
*
      ID   = IDCASY
      CALL VZERO(VHITS,NH*NHM)
      CALL VZERO(ITRA ,NHM)
      CALL VZERO(NUMBV,NVOL*NHM)
      NHITS = -1
*
* Update the max number of hits to be retrived
*
      NNHM = NHM - NTHCAS
      IF(NNHM.LE.0) THEN
         WRITE(CHMAIL,10100) CSET,CNSED(IS,ID),NTHCAS,NHM,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
      CALL GPRHIT(CSET,CNSED(IS,ID),IS,ID,NVOL,NH,NNHM,1,
     +            IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*
* If there was a problem in GPRHIT then exit
*
      IF(NHITS.LT.0) THEN
         WRITE(CHMAIL,10200) CSET,CNSED(IS,ID),NHITS,NHM,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
*
* >>>>>>>>>>>>>>>>>>>>>> DIGI action
*
*
* Fill the CWN common
*
      DO I=1,NHITS
         NTHCAS = NTHCAS + 1
         ICAS(NTHCAS)  = 2 + NUMBV(NVCAS,I)
#if defined(GPAMELA_INTER)
         XINCAS(NTHCAS)  = 2*VHITS(1,I)-VHITS(4,I)
         YINCAS(NTHCAS)  = 2*VHITS(2,I)-VHITS(5,I)
         ZINCAS(NTHCAS)  = 2*VHITS(3,I)-VHITS(6,I)
#endif
#if !defined(GPAMELA_INTER)
         XINCAS(NTHCAS)  = VHITS(1,I)
         YINCAS(NTHCAS)  = VHITS(2,I)
         ZINCAS(NTHCAS)  = VHITS(3,I)
#endif
         XOUTCAS(NTHCAS) = VHITS(4,I)
         YOUTCAS(NTHCAS) = VHITS(5,I)
         ZOUTCAS(NTHCAS) = VHITS(6,I)
         ERELCAS(NTHCAS) = VHITS(7,I)
         TIMECAS(NTHCAS)=  VHITS(8,I)
         PATHCAS(NTHCAS) = VHITS(9,I)
         IPARCAS(NTHCAS) = VHITS(10,I)
         P0CAS(NTHCAS) = VHITS(11,I)
      ENDDO
*
10000  FORMAT(' GPDCAS: VOLUME level too big: SET=',A4,', DET=',A4,',
     +        NVOL=',I3,', NVMAX=',I3,', RUN=',I5,', EVT=',I8)
10100  FORMAT(' GPDCAS: Error in GPRHIT: SET=',A4,
     +        ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
10200  FORMAT(' GPDCAS: Error in GPRHIT: SET=',A4,
     +        ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
   10 RETURN
      END
