*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 01/03/2000  21.22.50  by  Francesco Cafagna
*CMZ :  1.02/00 20/03/97  16.40.46  by  Francesco Cafagna
*CMZ :  1.01/00 22/05/96  18.41.43  by  Francesco Cafagna
*CMZ :  1.00/03 30/04/96  18.14.54  by  Francesco Cafagna
*CMZ :  1.00/02 05/04/96  11.31.55  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   30/11/95
      SUBROUTINE GUKINE
************************************************************************
*                                                                      *
*             Read or Generates Kinematics for primary tracks          *
*                                                                      *
* Called by: GTRIG                                                     *
* Author: Francesco Cafagna, 30/11/95 17.50.45                         *
*                                                                      *
************************************************************************
#include "gcflag.inc"
#include "gckine.inc"
#include "gconst.inc"
#include "gpkine.inc"
#include "gpgene.inc"
#include "gpkey.inc"
#include "gpgeo.inc"
      REAL COSX,COSY,COSZ
*
*     -----------------------------------------------------------------
*
*     Generates random number between 0<X<1
*
      CALL VZERO(POS,5)
      CALL GRNDM(POS,5)
*    =========> Angles
*       POS(4) = TWOPI*POS(4)
*       POS(5) = PIBY2*POS(5)
* ---------->>>>>>> Max 90 degree in teta, 360 degree in phi; PIATTA IN COS^2
*ML:
*      PHI  = 360.*POS(4)*DEGRAD
*      THETA= ACOS(SQRT(1-POS(5)))
      PHI = ( PHMIN+POS(4)*(PHMAX-PHMIN) )*DEGRAD
      THETA = ( THMIN+POS(5)*(THMAX-THMIN) )*DEGRAD
*END ML.
      COSX = COS(PHI)*SIN(THETA)
      COSY = SIN(PHI)*SIN(THETA)
      COSZ = COS(THETA)
*    =========> Coordinates
#if defined(GPAMELA_INTER)||defined(GPAMELA_DEB)
* Case with interactive or debug version.
* You can choose a position inside PAMELA
      DO I=1,3
         VERTEX(I)=PKINE(I)
      END DO
#endif
#if !defined(GPAMELA_INTER)&&!defined(GPAMELA_DEB)
*
* Generation surface is 2 cm over the TOP TOF
* It is centered on PAMELA and 2.cm larger than TOF on each side
*
      VERTEX(1) = XDGEN*POS(1) + XGEN
      VERTEX(2) = YDGEN*POS(2) + YGEN
      VERTEX(3) = ZGEN
#endif
*    =========> Momentum (1GeV default )
#if defined(GPAMELA_INTER)||defined(GPAMELA_DEB)
      PTOT=0.
      DO I=1,3
         PXYZ(I)=PKINE(I+3)
         PTOT=PTOT+PXYZ(I)**2
      END DO
      IF(PTOT.EQ.0.) THEN
         PTOT=1.
      ELSE
         PTOT=SQRT(PTOT)
      ENDIF
#endif
#if !defined(GPAMELA_INTER)&!defined(GPAMELA_DEB)
      PTOT=PKINE(1)
      IF(PTOT.EQ.0.)PTOT=1.
      PXYZ(1) = PTOT*COSX
      PXYZ(2) = PTOT*COSY
      PXYZ(3) = - PTOT*COSZ
#endif
      P0 = PTOT
*    =========> Particle (User defined )
      IPA = IKINE
*
* Call USER routine
*
      CALL GPUKIN (1)
      X0 = VERTEX(1)
      Y0 = VERTEX(2)
      Z0 = VERTEX(3)
      CALL GSVERT (VERTEX, 0, 0, 0, 0, NVTX)
      CALL GSKINE (PXYZ,IPA, NVTX, 0, 0, NTRAK)
      CALL GPUKIN (2)
      IF(IDEBUG.EQ.1.AND.ISWIT(1).EQ.1) THEN
         CALL GPRINT('VERT',0)
         CALL GPRINT('KINE',0)
      ENDIF
      RETURN
      END
