*
* $Id$
*
* $Log$
*
*CMZ :  3.00/00 28/03/2001  20.04.41  by  Marialuigia Ambriola
*CMZ :  2.02/00 09/10/2000  15.33.16  by  Francesco Cafagna
*CMZ :  2.01/01 05/04/2000  16.38.43  by  Unknown
*CMZU:  2.01/00 04/04/2000  18.51.31  by  Unknown
*CMZ :  2.00/00 03/03/2000  15.39.05  by  Francesco Cafagna
*CMZ :  1.02/00 20/01/2000  17.45.30  by  Francesco Cafagna
*CMZ :  1.00/03 15/04/96  16.59.39  by  Francesco Cafagna
*CMZ :  1.00/02 15/03/96  17.47.37  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   20/12/95
      SUBROUTINE GPMED
************************************************************************
*                                                                      *
* Material definition for PAMELA                                       *
* Please note that the EPSILGP variable is set depending on the volume   *
* thickness. This is why you will find Two kind of silicon.            *
* The material parameter sign has been turned negative to let GEANT    *
* calculate them automatically besides the AUTO = 0 have been required *
*                                                                      *
* Called by: UGINIT                                                    *
* Author: Francesco Cafagna, 05/12/95 13.21.27                         *
*                                                                      *
************************************************************************
#include "gpkey.inc"
#include "gpmed.inc"
#include "gppmat.inc"
#include "gpmat.inc"
#include "gpgeo.inc"
#include "gcunit.inc"
*
      REAL TMAXFDREF,STEMAXREF,DEEMAXREF,STMINREF,UWBUF(NWMMAT)
*ML:
      REAL EPSILREF
*END ML.
      INTEGER NJUNK
      NJUNK = 0
      TMAXFDREF = TMAXFDGP
      STEMAXREF = STEMAXGP
      DEEMAXREF = DEEMAXGP
      STMINREF  = STMINGP
      EPSILREF  = EPSILGP
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      IF(ADEEMAX) DEEMAXGP = -DEEMAXGP
      IF(ASTMIN)  STMINGP  = -STMINGP
C
C Al, not sensitive.
C
      NJUNK = NJUNK+1
      MAL = NJUNK
      ISVOLGP = -1
*ML:
      IF(TPAL(1).GT.0.) THEN
         TMAXFDGP = TPAL(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPAL','TPAL'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAL(2).GT.0.) THEN
         STEMAXGP=TPAL(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPAL','TPAL'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAL(3).GT.0.) THEN
         DEEMAXGP=TPAL(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPAL','TPAL'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAL(4).GT.0.) THEN
         STMINGP=TPAL(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPAL','TPAL'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAL(5).GT.0.) THEN
         EPSILGP=TPAL(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPAL','TPAL'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*ABS(SHEL(2)-SHEL(1))
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*ABS(SHEL(2)-SHEL(1))
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MAL,'ALUMINIUM         $' ,9, ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
C
C G10, not sensitive
C
      NJUNK = NJUNK+1
      MG10 = NJUNK
      ISVOLGP = -1
*ML:
      IF(TG10(1).GT.0.) THEN
         TMAXFDGP = TG10(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TG10','TG10'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TG10(2).GT.0.) THEN
         STEMAXGP=TG10(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TG10','TG10'
            CALL GMAIL(1,0)
         ENDIF
      ELSEIF(.NOT.BSTEMAX) THEN
         STEMAXGP = 0.15
         IF(ASTEMAX) STEMAXGP = -STEMAXGP
      ENDIF
      IF(TG10(3).GT.0.) THEN
         DEEMAXGP=TG10(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TG10','TG10'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TG10(4).GT.0.) THEN
         STMINGP=TG10(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TG10','TG10'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TG10(5).GT.0.) THEN
         EPSILGP=TG10(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TG10','TG10'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*CG10(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*CG10(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*      IF(VSTEMAX.GT.0) THEN
*         STEMAXGP = VSTEMAX
*      ELSE
*         STEMAXGP = 0.15
*      ENDIF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
*END ML.
      CALL GSTMED(MG10,'G10               $',NMG10, ISVOLGP,FFIELD,
     +FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
*      STEMAXGP = STEMAXREF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
*      TMAXFDGP=TMAXFDREF
*END ML.
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
C
C N2, gas, not sensitive, epsil =10 microns
C
      NJUNK = NJUNK+1
      MN2 = NJUNK
      ISVOLGP = -1
*ML:
      IF(TPN2(1).GT.0.) THEN
         TMAXFDGP = TPN2(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPN2','TPN2'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPN2(2).GT.0.) THEN
         STEMAXGP=TPN2(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPN2','TPN2'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPN2(3).GT.0.) THEN
         DEEMAXGP=TPN2(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPN2','TPN2'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPN2(4).GT.0.) THEN
         STMINGP=TPN2(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPN2','TPN2'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPN2(5).GT.0.) THEN
         EPSILGP=TPN2(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPN2','TPN2'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MN2,'N2 GAS             $',NMN2, ISVOLGP,FFIELD,
     +FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C W, not sensitive, parameter updated following M. MAsini & M.P.De Pascale
C
      NJUNK = NJUNK+1
      MW = NJUNK
      ISVOLGP = -1
*ML:
      IF(TPW(1).GT.0.) THEN
         TMAXFDGP = TPW(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPW','TPW'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPW(2).GT.0.) THEN
         STEMAXGP=TPW(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPW','TPW'
            CALL GMAIL(1,0)
         ENDIF
      ELSEIF(.NOT.BSTEMAX) THEN
         STEMAXGP=0.05
         IF(ASTEMAX) STEMAXGP = -STEMAXGP
      ENDIF
      IF(TPW(3).GT.0.) THEN
         DEEMAXGP=TPW(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPW','TPW'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPW(4).GT.0.) THEN
         STMINGP=TPW(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPW','TPW'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPW(5).GT.0.) THEN
         EPSILGP=TPW(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPW','TPW'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*CAAB(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*CAAB(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*      IF(VSTEMAX.GT.0) THEN
*         STEMAXGP = VSTEMAX
*      ELSE
*         STEMAXGP = 0.05
*      ENDIF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
*END ML.
      CALL GSTMED(MW,'TUNGSTEN           $',12, ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      STEMAXGP = STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Fe, not sensitive.
C
      NJUNK = NJUNK+1
      MMAG = NJUNK
      ISVOLGP = -1
*ML:
      IF(TPFE(1).GT.0.) THEN
         TMAXFDGP = TPFE(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPFE','TPFE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPFE(2).GT.0.) THEN
         STEMAXGP=TPFE(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPFE','TPFE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPFE(3).GT.0.) THEN
         DEEMAXGP=TPFE(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPFE','TPFE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPFE(4).GT.0.) THEN
         STMINGP=TPFE(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPFE','TPFE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPFE(5).GT.0.) THEN
         EPSILGP=TPFE(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPFE','TPFE'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*MGPL(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*MGPL(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MMAG,'IRON               $',10,ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Kapton, not sensitive volume. Using scintillator for the moment
C
      NJUNK = NJUNK+1
      MKAP = NJUNK
*ML:
*      ISVOLGP = -1
      ISVOLGP = 1
*END ML.
*ML:
      IF(TPKA(1).GT.0.) THEN
         TMAXFDGP = TPKA(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPKA','TPKA'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPKA(2).GT.0.) THEN
         STEMAXGP=TPKA(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPKA','TPKA'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPKA(3).GT.0.) THEN
         DEEMAXGP=TPKA(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPKA','TPKA'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPKA(4).GT.0.) THEN
         STMINGP=TPKA(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPKA','TPKA'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPKA(5).GT.0.) THEN
         EPSILGP=TPKA(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPKA','TPKA'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*ABS(TRSO(2)-TRSO(1))
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*ABS(TRSO(2)-TRSO(1))
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MKAP,'KAPTON             $',NMSCIN,ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C TRD radiator, not sensitive volume.
C
      NJUNK = NJUNK+1
      MTRAD = NJUNK
      ISVOLGP = -1
*ML:
      IF(TRAD(1).GT.0.) THEN
         TMAXFDGP = TRAD(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TRAD','TRAD'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TRAD(2).GT.0.) THEN
         STEMAXGP=TRAD(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TRAD','TRAD'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TRAD(3).GT.0.) THEN
         DEEMAXGP=TRAD(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TRAD','TRAD'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TRAD(4).GT.0.) THEN
         STMINGP=TRAD(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TRAD','TRAD'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TRAD(5).GT.0.) THEN
         EPSILGP=TRAD(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TRAD','TRAD'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*TRRA(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*TRRA(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MTRAD,'TRD RADIATOR       $',NMTRAD,ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C ROACELL, not sensitive volume. Using scintillator for the moment
C
      NJUNK = NJUNK+1
      MROA = NJUNK
      ISVOLGP = -1
*ML:
      IF(TPRO(1).GT.0.) THEN
         TMAXFDGP = TPRO(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPRO','TPRO'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPRO(2).GT.0.) THEN
         STEMAXGP=TPRO(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPRO','TPRO'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPRO(3).GT.0.) THEN
         DEEMAXGP=TPRO(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPRO','TPRO'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPRO(4).GT.0.) THEN
         STMINGP=TPRO(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPRO','TPRO'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPRO(5).GT.0.) THEN
         EPSILGP=TPRO(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPRO','TPRO'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MROA,'ROACELL            $',NMSCIN,ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Carbon fiber, not sensitive volume. Using scintillator for the moment
C
      NJUNK = NJUNK+1
      MCF = NJUNK
      ISVOLGP = -1
*ML:
      IF(TPCF(1).GT.0.) THEN
         TMAXFDGP = TPCF(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPCF','TPCF'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPCF(2).GT.0.) THEN
         STEMAXGP=TPCF(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPCF','TPCF'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPCF(3).GT.0.) THEN
         DEEMAXGP=TPCF(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPCF','TPCF'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPCF(4).GT.0.) THEN
         STMINGP=TPCF(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPCF','TPCF'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPCF(5).GT.0.) THEN
         EPSILGP=TPCF(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPCF','TPCF'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*TRCP(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*TRCP(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MCF,'CARBON FIBER       $',NMSCIN,ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Plastic scint., sensitive volume, CATB is the reference volume to calculate
C EPSILGP
C
      NJUNK = NJUNK+1
      MSCIN = NJUNK
      ISVOLGP = 1
*ML:
      IF(TPSC(1).GT.0.) THEN
         TMAXFDGP = TPSC(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPSC','TPSC'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPSC(2).GT.0.) THEN
         STEMAXGP=TPSC(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPSC','TPSC'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPSC(3).GT.0.) THEN
         DEEMAXGP=TPSC(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPSC','TPSC'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPSC(4).GT.0.) THEN
         STMINGP=TPSC(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPSC','TPSC'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPSC(5).GT.0.) THEN
         EPSILGP=TPSC(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPSC','TPSC'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*CATB(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*CATB(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MSCIN,'SCINTILLATOR       $',NMSCIN,ISVOLGP,FFIELD,
     +FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Silicon, sensitive volume. Si calorimeter material.
C
      NJUNK = NJUNK+1
      MSIC = NJUNK
      ISVOLGP = 1
*ML:
      IF(TSCA(1).GT.0.) THEN
         TMAXFDGP = TSCA(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TSCA','TSCA'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TSCA(2).GT.0.) THEN
         STEMAXGP=TSCA(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TSCA','TSCA'
            CALL GMAIL(1,0)
         ENDIF
      ELSEIF(.NOT.BSTEMAX) THEN
C         STEMAXGP = 0.15
         STEMAXGP = 100.
         IF(ASTEMAX) STEMAXGP = -STEMAXGP
      ENDIF
      IF(TSCA(3).GT.0.) THEN
         DEEMAXGP=TSCA(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TSCA','TSCA'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TSCA(4).GT.0.) THEN
         STMINGP=TSCA(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TSCA','TSCA'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TSCA(5).GT.0.) THEN
         EPSILGP=TSCA(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TSCA','TSCA'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*CASI(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*CASI(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*      IF(VSTEMAX.GT.0) THEN
*         STEMAXGP = VSTEMAX
*      ELSE
*         STEMAXGP = 0.15
*      ENDIF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
*END ML.
      UWBUF(1) = D2SICA
*ML:
*END ML.
      CALL GSTMED(MSIC,'SICALO             $',NMSICA,ISVOLGP,FFIELD,
     +FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,UWBUF,1)
*ML:
      STEMAXGP = STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Silicon, sensitive volume. Si Tracker material.
C
      NJUNK = NJUNK+1
      MSIT = NJUNK
      ISVOLGP = 1
*ML:
*      PRINT*,'STAMPO TSTR',TSTR(1),TSTR(2),TSTR(3),TSTR(4),TSTR(5)
      IF(TSTR(1).GT.0.) THEN
         TMAXFDGP = TSTR(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TSTR','TSTR'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TSTR(2).GT.0.) THEN
         STEMAXGP=TSTR(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TSTR','TSTR'
            CALL GMAIL(1,0)
         ENDIF
      ELSEIF(.NOT.BSTEMAX) THEN
         STEMAXGP = 0.015
         IF(ASTEMAX) STEMAXGP = -STEMAXGP
      ENDIF
      IF(TSTR(3).GT.0.) THEN
         DEEMAXGP=TSTR(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TSTR','TSTR'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TSTR(4).GT.0.) THEN
         STMINGP=TSTR(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TSTR','TSTR'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TSTR(5).GT.0.) THEN
         EPSILGP=TSTR(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TSTR','TSTR'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*TSPA(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*TSPA(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*      IF(VSTEMAX.GT.0) THEN
*         STEMAXGP = VSTEMAX
*      ELSE
*         STEMAXGP = 0.015
*      ENDIF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
*END ML.
      UWBUF(1) = D2SITR
*ML:
*      PRINT*,'SI TRACKER',TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP
*END ML.
      CALL GSTMED(MSIT,'SITRACKER          $',NMSITR,ISVOLGP,FFIELD,
     +FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,UWBUF,1)
*ML:
      STEMAXGP = STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Xenon, sensitive volume.
C
      NJUNK = NJUNK+1
      MXE = NJUNK
      ISVOLGP = 1
*ML:
      IF(TPXE(1).GT.0.) THEN
         TMAXFDGP = TPXE(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPXE','TPXE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPXE(2).GT.0.) THEN
         STEMAXGP=TPXE(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPXE','TPXE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPXE(3).GT.0.) THEN
         DEEMAXGP=TPXE(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPXE','TPXE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPXE(4).GT.0.) THEN
         STMINGP=TPXE(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPXE','TPXE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPXE(5).GT.0.) THEN
         EPSILGP=TPXE(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPXE','TPXE'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*ABS(TRSI(2)-TRSI(1))
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*ABS(TRSI(2)-TRSI(1))
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MXE,'XENON              $',NMXE,ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
C
C Aerogel, sensitive volume. Using scintillator for the moment
C
      NJUNK = NJUNK+1
      MAER = NJUNK
      ISVOLGP = 1
*ML:
      IF(TPAE(1).GT.0.) THEN
         TMAXFDGP = TPAE(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPAE','TPAE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAE(2).GT.0.) THEN
         STEMAXGP=TPAE(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPAE','TPAE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAE(3).GT.0.) THEN
         DEEMAXGP=TPAE(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPAE','TPAE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAE(4).GT.0.) THEN
         STMINGP=TPAE(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPAE','TPAE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPAE(5).GT.0.) THEN
         EPSILGP=TPAE(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPAE','TPAE'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*END ML.
      CALL GSTMED(MAER,'AEROGEL            $',NMAER,ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
*ML:
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END ML.
*EM:
C
C W, not sensitive, parameter updated following Mirko
C
      NJUNK = NJUNK+1
      MW2 = NJUNK
      ISVOLGP = -1
      IF(TPW2(1).GT.0.) THEN
         TMAXFDGP = TPW2(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPW2','TPW2'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPW2(2).GT.0.) THEN
         STEMAXGP=TPW2(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPW2','TPW2'
            CALL GMAIL(1,0)
         ENDIF
      ELSEIF(.NOT.BSTEMAX) THEN
         STEMAXGP=100.
         IF(ASTEMAX) STEMAXGP = -STEMAXGP
      ENDIF
      IF(TPW2(3).GT.0.) THEN
         DEEMAXGP=TPW2(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPW2','TPW2'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPW2(4).GT.0.) THEN
         STMINGP=TPW2(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPW2','TPW2'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPW2(5).GT.0.) THEN
         EPSILGP=TPW2(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPW2','TPW2'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*CAAB(3)
      ENDIF
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*CAAB(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*      IF(VSTEMAX.GT.0) THEN
*         STEMAXGP = VSTEMAX
*      ELSE
*C         STEMAXGP = 0.05
*         STEMAXGP = 100.
*      ENDIF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      CALL GSTMED(MW2,'TUNGA              $',NMWCAL, ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
      STEMAXGP = STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
C
C KAOLINITE, not sensitive, parameter updated following Mirko
C
      NJUNK = NJUNK+1
      MCER = NJUNK
      ISVOLGP = -1
      IF(TPCE(1).GT.0.) THEN
         TMAXFDGP = TPCE(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','TPCE','TPCE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPCE(2).GT.0.) THEN
         STEMAXGP=TPCE(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','TPCE','TPCE'
            CALL GMAIL(1,0)
         ENDIF
      ELSEIF(.NOT.BSTEMAX) THEN
         STEMAXGP=100.
         IF(ASTEMAX) STEMAXGP = -STEMAXGP
      ENDIF
      IF(TPCE(3).GT.0.) THEN
         DEEMAXGP=TPCE(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','TPCE','TPCE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPCE(4).GT.0.) THEN
         STMINGP=TPCE(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','TPCE','TPCE'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(TPCE(5).GT.0.) THEN
         EPSILGP=TPCE(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','TPCE','TPCE'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*CAKA(3)
      ENDIF
C
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*CAKA(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*      IF(VSTEMAX.GT.0) THEN
*         STEMAXGP = VSTEMAX
*      ELSE
*         STEMAXGP = 100.
*      ENDIF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      CALL GSTMED(MCER,'KAOLINITE          $',NMCERA, ISVOLGP,FFIELD,
     + FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
      STEMAXGP = STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
C
C G10C for calorimeter , not sensitive
C
      NJUNK = NJUNK+1
      MG10C = NJUNK
      ISVOLGP = -1
      IF(T10C(1).GT.0.) THEN
         TMAXFDGP = T10C(1)
         IF(BTMAXFD) THEN
            WRITE(CHMAIL,10000) 'TMAX','T10C','T10C'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(T10C(2).GT.0.) THEN
         STEMAXGP=T10C(2)
         IF(BSTEMAX) THEN
            WRITE(CHMAIL,10000) 'STMA','T10C','T10C'
            CALL GMAIL(1,0)
         ENDIF
      ELSEIF(.NOT.BSTEMAX) THEN
         STEMAXGP=100.
         IF(ASTEMAX) STEMAXGP = -STEMAXGP
      ENDIF
      IF(T10C(3).GT.0.) THEN
         DEEMAXGP=T10C(3)
         IF(BDEEMAX) THEN
            WRITE(CHMAIL,10000) 'DEEM','T10C','T10C'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(T10C(4).GT.0.) THEN
         STMINGP=T10C(4)
         IF(BSTMIN) THEN
            WRITE(CHMAIL,10000) 'STMI','T10C','T10C'
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
      IF(T10C(5).GT.0.) THEN
         EPSILGP=T10C(5)
         IF(BEPSIL) THEN
            WRITE(CHMAIL,10000) 'EPSI','T10C','T10C'
         ENDIF
      ELSEIF(.NOT.BEPSIL.OR.AEPSIL) THEN
         EPSILGP = 0.01*2.*C10C(3)
      ENDIF
*
*      IF(VEPSIL.GT.0) THEN
*         EPSILGP = VEPSIL
*      ELSE
*         EPSILGP = 0.01*2.*C10C(3)
*      ENDIF
*      IF(AEPSIL) EPSILGP = -EPSILGP
*      IF(VSTEMAX.GT.0) THEN
*         STEMAXGP = VSTEMAX
*      ELSE
*         STEMAXGP = 0.15
*      ENDIF
*      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      CALL GSTMED(MG10C,'G10C              $',NMG10C, ISVOLGP,FFIELD,
     +FIELDMGP,TMAXFDGP,STEMAXGP,DEEMAXGP,EPSILGP,STMINGP,0,0)
      STEMAXGP = STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      TMAXFDGP=TMAXFDREF
      IF(ATMAXFD) TMAXFDGP = -TMAXFDGP
      STEMAXGP=STEMAXREF
      IF(ASTEMAX) STEMAXGP = -STEMAXGP
      DEEMAXGP=DEEMAXREF
      IF(ADEEMAX) DEEMAXGP = - DEEMAXGP
      STMINGP=STMINREF
      IF(ASTMIN) STMINGP = -STMINGP
      EPSILGP=EPSILREF
*END EM.
C
C User action
C
      CALL GPUMED
C
*ML:
10000 FORMAT('Error in GPMED: data cards ',A4,' and ',A4,
     +    ' enabled at the same time. ',A4,' has been considered.')
*END ML.
      RETURN
      END
