*
* $Id: gukine.F,v 3.7 2010/04/23 10:01:53 pam-fi Exp $
*
* $Log: gukine.F,v $
* Revision 3.7  2010/04/23 10:01:53  pam-fi
*  new possibility to read kinematics from file
*
* Revision 3.6  2008/01/30 16:02:26  pamela
* Adding some missing include files
* ----------------------------------------------------------------------
*
* Revision 3.5  2008/01/29 18:25:15  pamela
* Review of the shell and TOF geometries. New materials around the shell
* added to simulate the insulation.
*
* Revision 3.4  2007/10/02 17:58:30  cafagna
* Power law spectra introduced
*
* Revision 3.3  2006/11/30 12:28:39  cafagna
* CARD geometry updated. New S1 "table", legs included, added. Top magnetic screen has been added as well.
*
* Revision 3.2  2006/04/10 11:07:42  cafagna
* GEN data card updated, ZDGEN added
*
* Revision 3.1.1.1  2002/07/11 16:02:00  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 01/03/2000  21.22.50  by  Francesco Cafagna
*CMZ :  1.02/00 20/03/97  16.40.46  by  Francesco Cafagna
*CMZ :  1.01/00 22/05/96  18.41.43  by  Francesco Cafagna
*CMZ :  1.00/03 30/04/96  18.14.54  by  Francesco Cafagna
*CMZ :  1.00/02 05/04/96  11.31.55  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   30/11/95
      SUBROUTINE GUKINE
************************************************************************
*                                                                      *
*             Read or Generates Kinematics for primary tracks          *
*                                                                      *
* Called by: GTRIG                                                     *
* Author: Francesco Cafagna, 30/11/95 17.50.45                         *
*                                                                      *
************************************************************************
#include "gcflag.inc"
#include "gckine.inc"
#include "gconst.inc"
#include "gpkine.inc"
#include "gpgene.inc"
#include "gpkey.inc"
#include "gpgeo.inc"
#include "gpstripspe.inc" 


      REAL COSX,COSY,COSZ
      REAL ALPHA,KPOW
      REAL X2,X3,Y2,Y3
      REAL s2_xmax,s2_ymax,s2_z
      REAL s3_xmax,s3_ymax,s3_z
      REAL FACT2,FACT3,xc,xph
      logical trkgood
      integer posgood
      CHARACTER*20 CHNPAR
      
      CHARACTER*20 FILEN
      INTEGER PRO
      LOGICAL FIRSTCALL
      SAVE FIRSTCALL            
      DATA FIRSTCALL/.TRUE./      
      DATA badva1/ntotva1*1/
      INTEGER IB(12)
*
*     -----------------------------------------------------------------
*
*     Generates random number between 0<X<1
*
      CALL VZERO(POS,6)
      CALL GRNDM(POS,6)
*    =========> Angles
*       POS(4) = TWOPI*POS(4)
*       POS(5) = PIBY2*POS(5)
* ---------->>>>>>> Max 90 degree in teta, 360 degree in phi; PIATTA IN COS^2
*ML:
*      PHI  = 360.*POS(4)*DEGRAD
*      THETA= ACOS(SQRT(1-POS(5)))
      PHI = ( PHMIN+POS(4)*(PHMAX-PHMIN) )*DEGRAD
      IF(COS2G) THEN
         THETA = ACOS(SQRT(COS(THMIN*DEGRAD)**2
     +        -POS(5)*(COS(THMIN*DEGRAD)**2-COS(THMAX*DEGRAD)**2 )))
      ELSE
         THETA = ( THMIN+POS(5)*(THMAX-THMIN) )*DEGRAD
      ENDIF
*END ML.
      COSX = COS(PHI)*SIN(THETA)
      COSY = SIN(PHI)*SIN(THETA)
      COSZ = COS(THETA)
*    =========> Coordinates
#if defined(GPAMELA_INTER)||defined(GPAMELA_DEB)
* Case with interactive or debug version.
* You can choose a position inside PAMELA
      DO I=1,3
         VERTEX(I)=PKINE(I)
      END DO
#endif
#if !defined(GPAMELA_INTER)&&!defined(GPAMELA_DEB)
*
* Generation surface is 2 cm over the TOP TOF
* It is centered on PAMELA and 2.cm larger than TOF on each side
*
      VERTEX(1) = XDGEN*POS(1) + XGEN
      VERTEX(2) = YDGEN*POS(2) + YGEN
      VERTEX(3) = ZDGEN*POS(3) + ZGEN
#endif
*    =========> Momentum (1GeV default )
#if defined(GPAMELA_INTER)||defined(GPAMELA_DEB)
      PTOT=0.
      DO I=1,3
         PXYZ(I)=PKINE(I+3)
         PTOT=PTOT+PXYZ(I)**2
      END DO
      IF(PTOT.EQ.0.) THEN
         PTOT=1.
      ELSE
         PTOT=SQRT(PTOT)
      ENDIF
#endif
#if !defined(GPAMELA_INTER)&!defined(GPAMELA_DEB)
      PTOT=PKINE(1)
      IF(PTOT.EQ.0.)PTOT=1.
#endif
*
* Generation according to power law spectrum:
      IF(PLAW(1).NE.-1111.)THEN
         ALPHA=1.+PLAW(1)       !integral spectral index
         IF(ALPHA.NE.0.)THEN
*     random extraction
*     PLAW(2)!min kin energy/momentum
*     PLAW(3)!max kin energy/momentum
            IF(PLAW(2).EQ.0.)PLAW(2)=0.1E-09
            KPOW=(POS(6)*((PLAW(3)**ALPHA)-
     +           (PLAW(2)**ALPHA))+
     +           (PLAW(2)**ALPHA))**(1./ALPHA)
         ELSE
            KPOW=EXP(LOG(PLAW(2))+POS(6)*(LOG(PLAW(3))-LOG(PLAW(2))))
         ENDIF
*
         IF(PLAW(4).LT.0.)THEN
*     Extract the constants describing the particle IKINE
*     from the data structure JPART
            CALL GFPART (IKINE,CHNPAR,ITRTYP,AMASS,CHARGE,
     +           TLIFE,UB,NWB)
*     converting (total) kinetic energy into momentum
            PTOT=SQRT(KPOW**2+2.*AMASS*KPOW)
         ELSE
*     total momentum      
            PTOT=KPOW
         ENDIF


         trkGood = .FALSE.
         theta = 999.
         phi = 0.
         s2_xmax=7.8
         s2_ymax=6.0
c     s2_z=73.489
         s2_z=74.77
         s3_xmax=8.0
         s3_ymax=6.0
c     s3_z=25.3159
         s3_z=27.17
         
         x0 = XDGEN*POS(1) + XGEN
         y0 = YDGEN*POS(2) + YGEN
         z0 = ZDGEN*POS(3) + ZGEN
         
         posGood = 0
         
         do while ( trkgood.neqv..true. ) 
            theta=999.
c            theta = 0.02         !!!
            do while (theta.ge.0.82) 
c            do while (theta.ge.0.05) 
               CALL GRNDM(xc,1)
               xcos = sqrt( xc )
               theta = acos(xcos)
            enddo
            CALL GRNDM(xph,1)
            phi = xph*2.*3.14159265
c            phi = 3.14159265/2.    !!!
            fact2 = (s2_z-z0)/cos(theta)
            x2 = x0 + abs(fact2) *  sin(theta) * cos(phi)
            y2 = y0 + abs(fact2) *  sin(theta) * sin(phi)
            fact3 = (s3_z-z0)/cos(theta)
            x3 = x0 + abs(fact3) *  sin(theta) * cos(phi)
            y3 = y0 + abs(fact3) *  sin(theta) * sin(phi)
c            x2 = x0 + abs(fact2) *  sin(theta) * sin(phi)
c            y2 = y0 + abs(fact2) *  sin(theta) * cos(phi)
c            act3 = (s3_z-z0)/cos(theta)
c            x3 = x0 + abs(fact3) *  sin(theta) * sin(phi)
c            y3 = y0 + abs(fact3) *  sin(theta) * cos(phi)
            
            if ( Abs(x2).le.Abs(s2_xmax).and.Abs(y2).le.Abs(s2_ymax)
     +           .and.
     +           Abs(x3).le.Abs(s3_xmax).and.Abs(y3).le.Abs(s3_ymax)) 
     +           then
               trkGood = .TRUE.
c               print *,' qua '
            endif
c            print *,' x0 ',x0,' y0 ',y0
c            print *,' phi ',phi,' theta ',theta
c            print *,' fact2 ',fact2,' act3 ',act3
c            print *,'x2 ',x2,' x3 ',x3,' y2 ',y2,' y3 ',y3
            
            posGood = posgood+1
            
            if ( posGood.ge.100 ) then
               CALL VZERO(POS,6)
               CALL GRNDM(POS,6)
               x0 = XDGEN*POS(1) + XGEN
               y0 = YDGEN*POS(2) + YGEN
               z0 = ZDGEN*POS(3) + ZGEN
               posGood = 0
            endif
         enddo
         VERTEX(1) = X0
         VERTEX(2) = Y0
         VERTEX(3) = Z0
         
         
         COSX = COS(PHI)*SIN(THETA)
         COSY = SIN(PHI)*SIN(THETA)
         COSZ = COS(THETA)
         
         
      ENDIF
*     end power law



*
#if !defined(GPAMELA_INTER)&!defined(GPAMELA_DEB)
      PXYZ(1) = PTOT*COSX
      PXYZ(2) = PTOT*COSY
      PXYZ(3) = - PTOT*COSZ
#endif
      P0 = PTOT
*    =========> Particle (User defined )
      IPA = IKINE



*
* --- from file ---
*
      IF(IKINE.LT.0) THEN
 201    FORMAT('GPKine',I3,'.dat')
        PRO=-IKINE
        WRITE(FILEN,201)PRO

        IF(FIRSTCALL) THEN
           FIRSTCALL = .FALSE.

           OPEN(88,FILE=FILEN,STATUS='OLD',IOSTAT=iostat)
           IF(iostat.NE.0)THEN
             PRINT*,filen,': *** Error opening file ***'
             RETURN
           ENDIF
	   PRINT*,' *** opened file ***',FILEN
         ENDIF 
            
         READ(88,*,IOSTAT=iostat)
     $           IPA,VERTEX(1), VERTEX(2), VERTEX(3),
     $           PXYZ(1), PXYZ(2), PXYZ(3),
     $           IB(1),IB(2),IB(3),IB(4),IB(5),IB(6),IB(7),
     $           IB(8),IB(9),IB(10),IB(11),IB(12)
         IF(iostat.NE.0)THEN
           PRINT*,FILEN,': *** Error reading file ***'
           RETURN
         ENDIF
C decompress the bad va1 integers
         DO II=1,12
 	   DO JL=1,3
	    DO IV=1,8
	      IVA1=(JL-1)*8+IV
  	      BADVA1(II,JL,IV)=JBIT( IB(II) , IVA1 )
            ENDDO
	   ENDDO 
	 ENDDO

C

C
         P0=SQRT( PXYZ(1)**2+PXYZ(2)**2+PXYZ(3)**2 )
C
         THETA = ACOS(-PXYZ(3)/P0)
         PHI=ATAN2(-PXYZ(2),-PXYZ(1))
C
C
      ENDIF

*
* Call USER routine
*
      CALL GPUKIN (1)
      X0 = VERTEX(1)
      Y0 = VERTEX(2)
      Z0 = VERTEX(3)
      CALL GSVERT (VERTEX, 0, 0, 0, 0, NVTX)
      CALL GSKINE (PXYZ,IPA, NVTX, 0, 0, NTRAK)
      CALL GPUKIN (2)
      IF(IDEBUG.EQ.1.AND.ISWIT(1).EQ.1) THEN
         CALL GPRINT('VERT',0)
         CALL GPRINT('KINE',0)
      ENDIF
      RETURN
      END
