#ifndef PBLOCKDESC_H
#define PBLOCKDESC_H

#include <string>
#include <vector>

using std::string;
using std::vector;
using std::cout;
using std::endl;


// The Block Descriptor. A simple map to store block name, 
// total number of bytes and number of variables in the block  

struct pBlockDesc {
  pBlockDesc(const string s="", const int &nb=0, const int & nv=0, 
	     const int & nm=0):
    name(s), nbyte(nb), nvar(nv), nmult(nm) {};
  string name;
  int nbyte;
  int nvar;
  int nmult;
};

typedef vector<pBlockDesc> pBlockMap;

// Implements a service to return char arrays and poointer to be used to 
// store block as read from the hbook file
class pBlockPointer {

public:
  pBlockPointer():_pbuf(0) {}; 

  char* BuffAddress(){ return _pbuf;}
  char* BuffAddressR(){ return _pbr;}
  char* BlockAddress(const std::string& s);
  char* BlockAddressR(const std::string& s);
  //  char* BlockAddress(char *s);
  char* CreatePbuf();
  // Returns the number of blocks founds 
  int  Blocks(){return _pblockmap.size();}
  int  TotBufSize();
  int& CountByte(const std::string& s);
  int& CountVar(const std::string& s);
  int  BlockInd(const std::string& s);
  int  BlockByte(const std::string& s){
      return (*GetBlockDesc(s)).nbyte;};
  int  BlockVar(const std::string& s){
      return (*GetBlockDesc(s)).nvar;}
  int  BlockMult(const std::string& s){
      return (*GetBlockDesc(s)).nmult;}
  int& SetMult(const std::string& s);

  char * BuffReorder();
  pBlockDesc* GetBlockDesc(const std::string& s);
  pBlockMap* GetBlockMap(){return &_pblockmap;}


  void Print();

private:
  char *_pbuf;
  char *_pbr;
  pBlockMap _pblockmap;
};


#endif //PBLOCKDESC_H
