#ifndef PHIT_H
#define PHIT_H

#include <vector>
#include "pHitID.h"


class pHit {

public:

  pHit(  const float & xin=0, const float &yin=0,const float &zin=0,
	 const float & erel=0,const float & p0=0, const int &ipart=0,
	 pHitID *hid=0):
    _xin(xin), _yin(yin), _zin(zin), _erel(erel), _p0(p0), _ipart(ipart)
  { 
    SetHitID(hid);
  } 

  void SetHitID(pHitID * hid){_hid=hid;}
  void SetXin(const float & x){_xin=x;}
  void SetYin(const float & x){_yin=x;}
  void SetZin(const float & x){_zin=x;}
  void SetErel(const float & x){_erel=x;}
  void SetP0(const float & x){_p0=x;}
  void SetIpart(const int & i){_ipart=i;}

  pHitID* GetHitID() const { return _hid;}
  float GetXin() const {return _xin;}
  float GetYin() const {return _yin;}
  float GetZin() const {return _zin;}
  float GetErel() const {return _erel;}
  float GetP0() const {return _p0;}
  int GetIpart()const {return _ipart;}

  virtual void Print() const =0;

private:
  float _xin,_yin,_zin;
  float _erel;
  float _p0;
  int _ipart;
  pHitID *_hid;
  
};

typedef std::vector<pHit*> pHitColl;

#endif //PHIT_H
