#ifndef PHEADER_H
#define PHEADER_H

#include <vector>
#include <string>
#include "pHeaderID.h"

using std::string;

class pHeader {

public:

  pHeader( const string &name="", const int & type=0, const int &run=0, 
	   const int & event=0, pHeaderID *heaid=0):
    _name(name), _type(type), _run(run), _event(event)
  { 
    SetHeaderID(heaid);
  } 

  void SetHeader(const pHeader &ph) {
    SetHeader(ph); 
  }

  void SetHeader(const pHeader *ph) {
    SetHeaderID(ph->GetHitID()); 
    SetType(ph->_type);
    SetRun(ph->_run);
    SetEvent(ph->_event);
    SetName(ph->_name);
  }

  void SetHeaderID(pHeaderID * heaid){_heaid=heaid;}
  void SetType(const int & x){_type=x;}
  void SetRun(const int & x){_run=x;}
  void SetEvent(const int & x){_event=x;}
  void SetName(const string & x) {_name=x;}

  pHeaderID* GetHitID() const { return _heaid;}
  int GetType() const {return _type;}
  int GetRun() const {return _run;}
  int GetEvent() const {return _event;}
  string GetName() const {return _name;}

  virtual void Print() const =0;

private:
  string _name;
  int _type,_run,_event;
  pHeaderID *_heaid;
  
};

typedef std::vector<pHeader*> pHeaColl;
typedef map<string,pHeader*> pHeaMap;

#endif //PHEADER_H
