#ifndef PEVENT_H
#define PEVENT_H

#include <vector>
#include <functional>
#include <string>
#include "pDetector.h"
#include "pHit.h"
#include "pHeader.h"
#include "pPhitMgr.h"
#include "pPdetMgr.h"
#include "pPheaMgr.h"

using std::string;

class pEvent {
public:

  pEvent( ){ 
      _pphitmgr = pPhitMgr::Get(); 
      _ppdetmgr = pPdetMgr::Get(); 
      _ppheamgr = pPheaMgr::Get(); 
  }

  void AddDetector(const string &name, pDetector *pd){
    _pdetmap[name]=pd;
  }

  void AddDetector(const string &name){
     _pdetmap[name]=_ppdetmgr->GetpDet(name);
  }

  void AddHit(const string &name, const char *c){
    _pdetmap[name]->
      AddHit(_pphitmgr->GetpHit(name,c));
  }

  void AddHit(const string &name, pHit *ph){
    _pdetmap[name]->
      AddHit(ph);
  }

//   void AddHeader(const string &name, const int &type, const char *c){
//     _pheamap[name]->
//       AddHeader(_ppheamgr->GetpHea(name,c));
//   }

  void AddHeader(const string &name, pHeader *ph){
    _pheader->SetHeader(ph);
  }
  

  void Print(){
    _pheader->Print();
    for(pDetMap::iterator i=_pdetmap.begin(); i!=_pdetmap.end();++i){
      (*i->second).Print();
    }
  }
  
  
 private:

  pDetMap _pdetmap;
  pHeader *_pheader;
  pPhitMgr *_pphitmgr;
  pPdetMgr *_ppdetmgr;
  pPheaMgr *_ppheamgr;
};

#endif //PEVENT_H
