#include <string>
#include <iostream>
#include "pUtils.h"
#include "pPdetMgr.h"
#include "pCal.h"
#include "pTof.h"
#include "pCas.h"
#include "pCat.h"

// Just a counter        012345678901234567890123456789012345678901234567890123456789
#define DETECTOR_NAMES "cat  cal  cali tof  cas  card s4   nd   trd  spe  "
#define CATPOS 0
#define CALPOS 5
#define CALIPOS 10
#define TOFPOS 15
#define CASPOS 20
#define CARDPOS 25
#define S4POS 30
#define NDPOS 35
#define TRDPOS 40
#define SPEPOS 45

using std::string;
using std::cout;
using std::endl;
using pUtils::ToLower;

pPdetMgr * pPdetMgr::_pdetmgr = 0;

pPdetMgr * pPdetMgr::Get(){
  if(_pdetmgr==0) {
    _pdetmgr = new pPdetMgr();
  }
  return _pdetmgr;
}

pDetector* pPdetMgr::GetpDet(const string &s)
{
  string temp=DETECTOR_NAMES;
  string::size_type spos=temp.find(ToLower(s));

  switch(spos){
//   case CATPOS:
//     return new pCat();
//   case CALPOS:
//     return new pCal();
//   case CALIPOS:
//     return 0;
//   case TOFPOS:
//     return new pTof();
//   case CASPOS:
//     return new pCas();
//   case CARDPOS:
//     return 0;
//   case S4POS:
//     return 0;
//   case NDPOS:
//     return 0;
//   case TRDPOS:
//     return 0;
//   case SPEPOS:
//     return 0;
  case string::npos:
    cout << " pPdetMgr : Detector = " << s << " not found ";
    return 0;
  default:
    cout << " pPdetMgr : Detector = " << s << " not found ";
    return new pDetector(ToLower(s));
//     return 0;
  }

}


