#ifndef PTOFHIT_H
#define PTOFHIT_H
#include <iostream>
#include "pHit.h"
#include "pTofID.h"
#include "TObject.h"

using std::cout;
using std::endl;

class pTofHit: public pHit {

public:

  pTofHit(){};
  pTofHit(const char *c){
   int *temp = (int*) c;
   SetHitID( new pTofID(c ));
   temp++;
   temp++;
   SetIpart( *temp++ ); 
   SetXin( *((float*)temp) );
   temp++;
   SetYin( *((float*)temp) );
   temp++;
   SetZin( *((float*)temp) );
   temp++;
   SetXout( *((float*)temp) );
   temp++;
   SetYout( *((float*)temp) );
   temp++;
   SetZout( *((float*)temp) );
   temp++;
   SetErel( *((float*)temp) );
   temp++;
   SetTime( *((float*)temp) );
   temp++;
   SetPath( *((float*)temp) );
   temp++;
   SetP0( *((float*)temp) );
  }

  void SetXout(const float & x){_xout=x;}
  void SetYout(const float & x){_yout=x;}
  void SetZout(const float & x){_zout=x;}
  void SetTime(const float & x){_time=x;}
  void SetPath(const float & x){_path=x;}

  float GetXout() const {return _xout;}
  float GetYout() const {return _yout;}
  float GetZout() const {return _zout;}
  float GetTime() const {return _time;}
  float GetPath() const {return _path;}

  void Print() const {
    cout <<  "pTofHit : " << endl; 
    GetHitID()->Print() ;
    cout <<  "          Ipart = " << GetIpart() << endl;
    cout <<  "          xin,yin,zin = " 
	 << GetXin() <<", "
	 << GetYin() <<", "
	 << GetZin() << endl;
    cout <<  "          xout,yout,zout = " 
	 << GetXout() <<", "
	 << GetYout() <<", "
	 << GetZout() << endl;

    cout <<  "          erel, time, path, p0= " 
	 << GetErel() << ", "
	 << GetTime() << ", "
	 << GetPath() << ", "
	 << GetP0() << endl;
  }

private:  
  float _xout,_yout,_zout;
  float _time,_path;
public:
  ClassDef(pTofHit,1);

};

#endif //PTOFHIT_H

