#ifndef PHIT_H
#define PHIT_H

#include <vector>
#include "pHitID.h"
#include "TObject.h"

class pHit :public TObject {

public:

  pHit() {
     _xin=_yin=_zin=_erel=_p0=0.;
     _ipart=0;
     SetHitID(0);

  };

  pHit(  const float & xin, const float &yin,const float &zin,
	 const float & erel,const float & p0, const int &ipart,
	 pHitID *hid):
    _xin(xin), _yin(yin), _zin(zin), _erel(erel), _p0(p0), _ipart(ipart)
  { 
    SetHitID(hid);
  } 

  virtual ~pHit(){};
  void SetHitID(pHitID * hid){_hid=hid;}
  void SetXin(const float & x){_xin=x;}
  void SetYin(const float & x){_yin=x;}
  void SetZin(const float & x){_zin=x;}
  void SetErel(const float & x){_erel=x;}
  void SetP0(const float & x){_p0=x;}
  void SetIpart(const int & i){_ipart=i;}

  pHitID* GetHitID() const { return _hid;}
  float GetXin() const {return _xin;}
  float GetYin() const {return _yin;}
  float GetZin() const {return _zin;}
  float GetErel() const {return _erel;}
  float GetP0() const {return _p0;}
  int GetIpart()const {return _ipart;}

  virtual void Print() const =0;


private:
  float _xin,_yin,_zin;
  float _erel;
  float _p0;
  int _ipart;
  pHitID *_hid;

public:
  //#ifndef __GNUC__
  ClassDef(pHit,1);
  //#endif
};

typedef std::vector<pHit*> pHitColl;

#endif //PHIT_H

