#ifndef PDETECTOR_H
#define PDETECTOR_H
#include <string>
#include <iostream>
#include <map>
#include "pHit.h"
#include "TObject.h"

using std::cout;
using std::endl;
using std::string;
using std::map;

class pDetector : public TObject {

public:


  pDetector(const string & s=0, pHit *p=0): _name(s) 
  {
    if(p!=0)AddHit(p);
  };

  virtual ~pDetector(){};

  void AddHit(pHit *p){_hits.push_back(p); Print();} 
//   void AddHit(const char *c){
//       _hits.push_back(pUtil::GetpHit(_name,c));
//   }
  void Print() const {
    cout << " pDetector: " << GetDetName() << endl;
    cout << " pHit stored: " << endl;
    for( pHitColl::const_iterator p=_hits.begin(); p!= _hits.end();++p)
      (*p)->Print();
  }

  pHit* GetHit(const int n) {return _hits[n];}
  pHitColl* GetHitColl() {return &_hits;}
  string GetDetName() const {return _name;}
  void SetDetName(const string & s){_name=s;}
  
private:
  string _name;
  pHitColl _hits;

 public:

  //#ifndef __GNUC__
  ClassDef(pDetector,1);
  //#endif
};

typedef map<string,pDetector*> pDetMap;

#endif //PDETECTOR_H

