// Author: Rene Brun   20/09/96
/////////////////////////////////////////////////////////////////////////
//      Program to convert an HBOOK file into a ROOT file
//                      Author: Rene Brun
//
//  This program is invoked via:
//     h2root hbook_file_name root_file_name  compress tolower
//  if the second parameter root_file_name is missing the name will be
//  automatically generated from the hbook file name. Example:
//       h2root test.hbook
//     is identical to
//       h2root test.hbook test.root
//  if compress is missing (or = 1)the ROOT file will be compressed
//  if compress = 0 the ROOT file will not be compressed.
//  if tolower is missing (or = 1) ntuple column names are converted to lower case
//                but the first character is converted to upper case.
//  if tolower = 2 same as tolower=1 except that the first character is also
//                convertex to lower case
/////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <string>
#include <ctype.h>
#include <sstream>
#include <iostream>

#include "Riostream.h"
#include "TFile.h"
#include "TDirectory.h"
#include "TTree.h"
#include "TLeafI.h"
#include "TH1.h"
#include "TH2.h"
#include "TProfile.h"
#include "TGraph.h"
#include "TMath.h"
//#include "../gpevent.h"
#include "pBlockPointer.h"
#include "pEvent.h"

int Error;   //to be removed soon

//  Define the names of the Fortran common blocks for the different OSs

#ifndef WIN32
#define PAWC_SIZE 5000000
#  define pawc pawc_
#  define quest quest_
#  define hcbits hcbits_
#  define hcbook hcbook_
#  define rzcl rzcl_
int pawc[PAWC_SIZE];
int quest[100];
int hcbits[37];
int hcbook[51];
int rzcl[11];
#else
// on windows /pawc/ must have the same length as in libPacklib.a !!
#define PAWC_SIZE 2000000
#  define pawc   PAWC
#  define quest  QUEST
#  define hcbits HCBITS
#  define hcbook HCBOOK
#  define rzcl   RZCL
extern "C" int pawc[PAWC_SIZE];
extern "C" int quest[100];
extern "C" int hcbits[37];
extern "C" int hcbook[51];
extern "C" int rzcl[11];
#endif

int *iq, *lq;
float *q;
char idname[128];
int nentries;
char chtitl[128];
int ncx,ncy,nwt,idb;
int lcont, lcid, lcdir;
float xmin,xmax,ymin,ymax;
const Int_t kMIN1 = 7;
const Int_t kMAX1 = 8;

#if defined __linux
//On linux Fortran wants this, so we give to it!
int xargv=0;
int xargc=0;
void MAIN__() {}
#endif

//  Define the names of the Fortran subroutine and functions for the different OSs

#ifndef WIN32
# define hlimit  hlimit_
# define hropen  hropen_
# define hrin    hrin_
# define hnoent  hnoent_
# define hgive   hgive_
# define hgiven  hgiven_
# define hprntu  hprntu_
# define hgnpar  hgnpar_
# define hgnf    hgnf_
# define hgnt    hgnt_
# define hgntb   hgntb_
# define rzink   rzink_
# define hdcofl  hdcofl_
# define hmaxim  hmaxim_
# define hminim  hminim_
# define hdelet  hdelet_
# define hntvar2 hntvar2_
# define hbname  hbname_
# define hbnamc  hbnamc_
# define hbnam   hbnam_
# define hi      hi_
# define hie     hie_
# define hif     hif_
# define hij     hij_
# define hix     hix_
# define hijxy   hijxy_
# define hije    hije_
# define hcdir   hcdir_
# define zitoh   zitoh_
# define uhtoc   uhtoc_

# define type_of_call
# define DEFCHAR  const char*
# define PASSCHAR(string) string
#else
# define hlimit  HLIMIT
# define hropen  HROPEN
# define hrin    HRIN
# define hnoent  HNOENT
# define hgive   HGIVE
# define hgiven  HGIVEN
# define hprntu  HPRNTU
# define hgnpar  HGNPAR
# define hgnf    HGNF
# define hgnt    HGNT
# define rzink   RZINK
# define hdcofl  HDCOFL
# define hmaxim  HMAXIM
# define hminim  HMINIM
# define hdelet  HDELET
# define hntvar2 HNTVAR2
# define hbname  HBNAME
# define hbnamc  HBNAMC
# define hbnam   HBNAM
# define hi      HI
# define hie     HIE
# define hif     HIF
# define hij     HIJ
# define hix     HIX
# define hijxy   HIJXY
# define hije    HIJE
# define hcdir   HCDIR
# define zitoh   ZITOH
# define uhtoc   UHTOC
# define type_of_call  _stdcall
# define DEFCHAR  const char*, const int
# define PASSCHAR(string) string, strlen(string)
#endif

extern "C" void  type_of_call hlimit(const int&);
#ifndef WIN32
extern "C" void  type_of_call hropen(const int&,DEFCHAR,DEFCHAR,DEFCHAR,
                        const int&,const int&,const int,const int,const int);
#else
extern "C" void  type_of_call hropen(const int&,DEFCHAR,DEFCHAR,DEFCHAR,
                        const int&,const int&);
#endif

extern "C" void  type_of_call hrin(const int&,const int&,const int&);
extern "C" void  type_of_call hnoent(const int&,const int&);
#ifndef WIN32
extern "C" void  type_of_call hgive(const int&,DEFCHAR,const int&,const float&,const float&,
   const int&,const float&,const float&,const int&,const int&,const int);
#else
extern "C" void  type_of_call hgive(const int&,DEFCHAR,const int&,const float&,const float&,
   const int&,const float&,const float&,const int&,const int&);
#endif

#ifndef WIN32
extern "C" void  type_of_call hgiven(const int&,DEFCHAR,const int&,DEFCHAR,
   const float&,const float&,const int,const int);
#else
extern "C" void  type_of_call hgiven(const int&,DEFCHAR,const int&,DEFCHAR,
   const float&,const float&);
#endif

#ifndef WIN32
extern "C" void  type_of_call hntvar2(const int&,const int&,DEFCHAR,DEFCHAR,DEFCHAR,int&,int&,int&,int&,int&,const int,const int, const int);
#else
extern "C" void  type_of_call hntvar2(const int&,const int&,DEFCHAR,DEFCHAR,DEFCHAR,int&,int&,int&,int&,int&);
#endif

#ifndef WIN32
extern "C" void  type_of_call hbnam(const int&,DEFCHAR,const int&,DEFCHAR,const int&,const int, const int);
#else
extern "C" void  type_of_call hbnam(const int&,DEFCHAR,const int&,DEFCHAR,const int&);
#endif

extern "C" void  type_of_call hprntu(const int&);
extern "C" void  type_of_call hgnpar(const int&,const char *,const int);
extern "C" void  type_of_call hgnf(const int&,const int&,const float&,const int&);
extern "C" void  type_of_call hgnt(const int&,const int&,const int&);
extern "C" void  type_of_call hgntb(const int&,DEFCHAR,const int&,const int&);
extern "C" void  type_of_call rzink(const int&,const int&,const char *,const int);
extern "C" void  type_of_call hdcofl();
extern "C" void  type_of_call hmaxim(const int&,const float&);
extern "C" void  type_of_call hminim(const int&,const float&);
extern "C" void  type_of_call hdelet(const int&);
extern "C" float type_of_call hi(const int&,const int&);
extern "C" float type_of_call hie(const int&,const int&);
extern "C" float type_of_call hif(const int&,const int&);
extern "C" float type_of_call hij(const int&,const int&,const int&);
extern "C" void  type_of_call hix(const int&,const int&,const float&);
extern "C" void  type_of_call hijxy(const int&,const int&,const int&,const float&,const float&);
extern "C" float type_of_call hije(const int&,const int&,const int&);
#ifndef WIN32
extern "C" void  type_of_call hcdir(DEFCHAR,DEFCHAR ,const int,const int);
#else
extern "C" void  type_of_call hcdir(DEFCHAR,DEFCHAR);
#endif

extern "C" void  type_of_call zitoh(const int&,const int&,const int&);
#ifndef WIN32
extern "C" void  type_of_call uhtoc(const int&,const int&,DEFCHAR,int&,const int);
#else
extern "C" void  type_of_call uhtoc(const int&,const int&,DEFCHAR,int&);
#endif

extern void convert_directory(const char*);
extern void convert_1d(Int_t id);
extern void convert_2d(Int_t id);
extern void convert_profile(Int_t id);
extern void convert_cwn(Int_t id);
extern void convert_rwn(Int_t id);
extern void convert_psam(const char*, TTree *, pEvent *);

Int_t golower  = 1;
Int_t bufsize  = 64000;
Int_t optcwn = 1;



int main(int argc, char **argv)
{
  if (argc < 2) {
     printf("******Error in invoking h2root\n");
     printf("===>  h2root file.hbook  file.root [compress] [tolower] [lrecl] [bufsize] [optcwn] \n");
     printf("      if file.root is not given  it will be = file.root\n");
     printf("      compress = 1 by default (use 0 for no compression)\n");
     printf("      tolower  = 1 by default (use 0 to keep case of column names)\n");
     printf("      lrecl =0 by default (must be specified if >8092)\n");
     printf("      bufsize = 8000 by default (branch buffer size)\n");
     printf("      for cwn ntuple only: optcwn  = 1 (default)  1-byte int -> char, 2-byte int -> short, (use 0 to keep 4-byte int) \n");
     return 1;
  }
  lq = &pawc[9];
  iq = &pawc[17];
  void *qq = iq;
   q = (float*)qq;
  char *file_in=argv[1];
  char *file_out;
  Int_t compress = 1;
  int ier=0, record_size=0;
  if (argc > 7) {
    optcwn = atoi(argv[7]);
  }
  if (argc > 6) {
    bufsize = atoi(argv[6]);
  }
  if (argc > 5) {
    record_size = atoi(argv[5]);
  }
  if (argc > 4) {
    golower = atoi(argv[4]);
  }
  if (argc > 3) {
    compress = atoi(argv[3]);
  }
  if (argc > 2) {
    file_out=argv[2];
  } else {
    file_out= new char[2000];
    strcpy(file_out,file_in);
    char *dot = strrchr(file_out,'.');
    if (dot) strcpy(dot+1,"root");
    else     strcat(file_out,".root");
  }

#if defined(_HIUX_SOURCE) && !defined(__GNUC__)
  hf_fint((char *)NULL);
#endif


  int pawc_size = PAWC_SIZE;
  hlimit(pawc_size);

  int lun = 10;
#ifndef WIN32
  hropen(lun,PASSCHAR("example"),PASSCHAR(file_in),PASSCHAR("p"),record_size,ier,7,strlen(file_in),1);
#else
  hropen(lun,PASSCHAR("example"),PASSCHAR(file_in),PASSCHAR("p"),record_size,ier);
#endif

  if (ier) printf (" Error on hropen was %d \n", ier);
  if (quest[0]) {
     printf("Error cannot open input file: %s\n",file_in);
     return 1;
  }

  char root_file_title[2000];
  sprintf(root_file_title,"HBOOK file: %s converted to ROOT",file_in);  
  TFile* hfile=new TFile(file_out,"RECREATE",root_file_title,compress);

  // Create global GPAMELA event

  pEvent *myevent=new pEvent();
  // Create ROOT tree and assign a Branch to the event
  TTree* gptree=new TTree("gptree","GPAMELA tree");
  gptree->Branch("pEvent_br","pEvent",&myevent,16000,0);  

  if (!hfile) {
     printf("Error: can't open output file: %s \n",file_out);
     return 1;
  }
  

  convert_psam("//example",gptree,myevent);
  //  convert_directory("//example");

  hfile->Write();
  hfile->ls();
  hfile->Close();
  delete hfile;
  return(0);
}

void convert_psam(const char *dir, TTree *gptree, pEvent* myevent){
  int nsub,itype,isize,ielem,ierr;
  const int kNchar=9;
  printf(" Converting directory %s\n",dir);
  Int_t id=20;
  Int_t nvar;
  float rmin[1000], rmax[1000];
  int i999 = 999;
  char * chtag_out;

  Int_t bufpos = 0;
  Int_t isachar = 0;
  Int_t isabool = 0;
  char fullname[1024];
  char name[512];
  char block[512];
  char oldblock[512];
  Int_t nbits = 0;
  strcpy(oldblock,"OLDBLOCK");
  Int_t oldischar = -1;
  string blockname;
  char *bigbuf = new char[2500000];
  //  Long_t add= (Long_t)&bigbuf[0];
  char *t=bigbuf;



  std::istringstream *test;

  hrin(id,i999,0);
  if (quest[0]) {
    printf("Error cannot read ID = %d\n",id);
    return;
    //    break;
  }
  if (id > 0) sprintf(idname,"h%d",id);
  else        sprintf(idname,"h_%d",-id);
  hnoent(id,nentries);
  printf(" Converting CWN with ID= %d, nentries = %d\n",id,nentries);
  nvar=0;

  hgiven(id,chtitl,nvar,PASSCHAR(""),rmin[0],rmax[0],80,0);
  chtag_out = new char[nvar*kNchar+1];
  hgiven(id,chtitl,nvar,chtag_out,rmin[0],rmax[0],80,kNchar);

  //  my_pointer m;

  pBlockPointer m;
  for( int i=0;i<nvar;++i) {
    hntvar2(id,i+1,PASSCHAR(name),PASSCHAR(fullname),
	    PASSCHAR(block),nsub,itype,isize,nbits,ielem,
	    512,1024,512);
    // std::cout << strlen(block) << " i: " << i << std::endl;
    test= new std::istringstream(block);
    *test >> blockname;
    m.CountByte(blockname)+=(ielem*isize);
    m.CountVar(blockname)++;
    m.SetMult(blockname)=ielem;
    //    std::cout << blockname << std::endl;
    delete test;
  }
//   std::cout << " Block found : " << m.Blocks() << " Size :" << m.TotBufSize() 
// 	    << std::endl;
  m.Print();
  for(pBlockMap::const_iterator p=(m.GetBlockMap())->begin(); 
      p!=(m.GetBlockMap())->end(); ++p){
    std::cout << p->name << ": "<< p->nbyte << '\n';
    if(p->name!="GENERAL" && p->name!="CALI" 
       && p->name!="TRD" && p->name!= "SPE")
      myevent->AddDetector(p->name);
  }
  myevent->Print();
  t=m.CreatePbuf();
  hbnam(id,PASSCHAR(" "),(int) *t,PASSCHAR("$CLEAR"),0,1,6);

  // Now is time to register all the blocks to the hbook routine
  Int_t ischar=0;
  for(pBlockMap::const_iterator p=(m.GetBlockMap())->begin(); 
      p!=(m.GetBlockMap())->end(); ++p){

    if(p->name!="GENERAL" && p->name!="CALI" && p->name!="CAL" 
       && p->name!="TRD" && p->name!= "SPE"){
      std::cout << p->name.c_str() << ": "<< p->nbyte << '\n';
      hbnam(id,PASSCHAR(p->name.c_str()),
	    (Long_t) m.BlockAddress(p->name.c_str()),
	    PASSCHAR("$SET"),ischar,
	    strlen( p->name.c_str() ),4);
    }
  }
  char * junk;
  for(int i=0;i<nentries;++i){
    hgnt(id,i+1,ierr);
    junk=m.BuffAddress();
    junk=m.BuffReorder();
    std::cout << junk << std::dec << 
      ", " << ierr << std::endl;
    for(pBlockMap::const_iterator p=(m.GetBlockMap())->begin(); 
	p!=(m.GetBlockMap())->end(); ++p){

      if(p->name!="GENERAL" && p->name!="CALI" && p->name!="CAL" 
	 && p->name!="TRD" && p->name!= "SPE" ){
	std::cout << p->name.c_str() << ": "<< p->nbyte << '\n';
        int nhit= *(int *) m.BlockAddressR(p->name.c_str());
	char * cc= m.BlockAddressR(p->name.c_str());
	cc=cc+4;
	int nb= (m.BlockVar(p->name.c_str())-1)*4;
	std::cout << " nhit : "<< nhit << endl;
	for (int i=0; i<nhit;++i) {
	  myevent->AddHit(p->name.c_str(),cc);
	  cc+=nb;
	}
      }
      gptree->Fill();
    }
  }
  myevent->Print();
}
//____________________________________________________________________________
