#include <string>
#include <iostream>
#include "pUtils.h"
#include "pPheaMgr.h"
#include "pGenHeader.h"

#define HEADER_NAMES "general "
#define GENPOS 0

using std::string;
using std::cout;
using std::endl;
using pUtils::ToLower;

pPheaMgr * pPheaMgr::_pheamgr = 0;


pPheaMgr * pPheaMgr::Get(){
  if(_pheamgr==0) {
    _pheamgr = new pPheaMgr();
  }
  return _pheamgr;
}

pHeader* pPheaMgr::GetpHea(const string &s, const char *c)
{
  string temp=HEADER_NAMES;
  string::size_type spos=temp.find(ToLower(s));

  switch(spos){
  case GENPOS:
    return new pGenHeader(c);
  case string::npos:
    cout << " pPheaMgr : Header = " << s << " not found ";
    return 0;
  default:
    cout << " pPheaMgr : Header = " << s << " not found ";
    return 0;
  }
}


