#include <physics/anticounter/AnticounterEvent.h>
#include <PscuHeader.h>
#include <EventHeader.h>

#include <fstream>

#include <TCanvas.h>
#include <TLatex.h>
#include <TLegend.h>
#include <TLine.h>
#include <TTree.h>
#include <TStyle.h>
#include <TObjString.h>

#include <utils/yodaUtility.h>

#define DEBUG 0
#define VERSION 1.2
/*
* Anticounter physics quicklook
* Plots a brief status report of the anticounter detectors
* see document "Anticounter Quicklook Software" on www.particle.kth.se/~pearce/flight_ac_docs
* for more details
*
* author  Petter Hofverberg
* version 1.0
*
* author  Maurizio Nagni
* version 1.1
* Adapted for compilation and unique file YODA upacking
*
*
* author Petter Hofverberg
* version 1.2
* added a dummy version of the quicklook (-mode 0, default mode)
*/
using namespace std;

int AcQLOOK(TString base,int fromevent=0, int toevent=0, TString outDir = "./", TString format = "jpg", int fullversion=0){

  //Int_t    	tmpSize;
  ofstream 	outputFile;
  stringstream 	oss;
  
  pamela::anticounter::AnticounterEvent *ace 	  = 0;
  pamela::EventHeader 			*eh 	  = 0;
  pamela::PscuHeader 			*ph 	  = 0;  
  TFile					*rootFile = new TFile(base);
  
  if (rootFile->IsZombie())
    exit(-1);
  TString fileName = ((TObjString*)base.Tokenize("\/")->Last())->GetString();
  TString filePath = base;
  filePath.ReplaceAll(fileName, "");
  fileName.ReplaceAll(".root", "");

  //Takes the tree of the header file
  TTree *tr = (TTree*)rootFile->Get("Physics");

  tr->SetBranchAddress("Anticounter", &ace);
  tr->SetBranchAddress("Header", &eh);

  
  TString *mtitel = new TString[16];
  mtitel[0]="CARD 4";
  mtitel[1]="CAT 2";
  mtitel[2]="CAS 1";
  mtitel[3]="NC";
  mtitel[4]="CARD 2";
  mtitel[5]="CAT 4";
  mtitel[6]="CAS 4";
  mtitel[7]="NC";
  mtitel[8]="CARD 3";
  mtitel[9]="CAT 3";
  mtitel[10]="CAS 3";
  mtitel[11]="NC";
  mtitel[12]="CARD 1";
  mtitel[13]="CAT 1";
  mtitel[14]="CAS 2";
  mtitel[15]="NC";

  TString *etitel = new TString[16];
  etitel[0]="CARD 4";
  etitel[1]="CAT 2";
  etitel[2]="CAS 1";
  etitel[3]="NC";
  etitel[4]="CARD 2";
  etitel[5]="CAT 4";
  etitel[6]="CAS 4";
  etitel[7]="NC";
  etitel[8]="CARD 3";
  etitel[9]="CAT 3";
  etitel[10]="CAS 3";
  etitel[11]="NC";
  etitel[12]="CARD 1";
  etitel[13]="CAT 1";
  etitel[14]="CAS 2";
  etitel[15]="NC";

  //Long64_t
  int nevents    = tr->GetEntries();

  //tr->Scan("Pscu.Counter");
  if(DEBUG)
    printf("Number of events: %d\n",nevents);

  int antal=nevents;
  
  /******************Book histograms**********************************************/
  if(DEBUG)
    printf("Book histograms\n");

  TH1D *nmbhitpmtCAS = new TH1D("nmbhitpmtCAS","Hit PMTs CAS",8,0.5,8.5);
  nmbhitpmtCAS->GetXaxis()->SetTitle("Number of hits");
  //nmbhitpmtCAS->GetYaxis()->SetTitle("")
  TH1D *nmbhitpmtCAT = new TH1D("nmbhitpmtCAT","Hit PMTs CAT",8,0.5,8.5);
  TH1D *nmbhitpmtCARD = new TH1D("nmbhitpmtCARD","Hit PMTs CARD",8,0.5,8.5);

   //MAIN
  TH1D *counter1_m       = new TH1D("counter1_m","Counter register CARD 4",75,1.,150.);
  counter1_m->GetXaxis()->SetTitle("rate [Hz]");
  counter1_m->GetYaxis()->SetTitle("Events");
  //counter1_m->SetBit(TH1D::kCanRebin);
  TH1D *counter2_m       = new TH1D("counter2_m","Counter register CAT 2",75,1.,150.);
  counter2_m->GetXaxis()->SetTitle("rate [Hz]");
  counter2_m->GetYaxis()->SetTitle("Events");
  TH1D *counter3_m       = new TH1D("counter3_m","Counter register CAS 1",75,1.,150.);
  TH1D *counter4_m       = new TH1D("counter4_m","Counter register NC",75,1.,150.);
  TH1D *counter5_m       = new TH1D("counter5_m","Counter register CARD 2",75,1.,150.);
  //counter5_m->SetBit(TH1D::kCanRebin);
  TH1D *counter6_m       = new TH1D("counter6_m","Counter register CAT 4",75,1.,150.);
  TH1D *counter7_m       = new TH1D("counter7_m","Counter register CAS 4",75,1.,150.);
  TH1D *counter8_m       = new TH1D("counter8_m","Counter register NC",75,1.,150.);
  TH1D *counter9_m       = new TH1D("counter9_m","Counter register CARD 3",75,1.,150.);
  TH1D *counter10_m      = new TH1D("counter10_m","Counter register CAT 3",75,1.,150.);
  TH1D *counter11_m      = new TH1D("counter11_m","Counter register CAS 3",75,1.,150.);
  TH1D *counter12_m      = new TH1D("counter12_m","Counter register NC",75,1.,150.);
  TH1D *counter13_m      = new TH1D("counter13_m","Counter register CARD 1",75,1.,150.);
  TH1D *counter14_m      = new TH1D("counter14_m","Counter register CAT 1",75,1.,150.);
  TH1D *counter15_m      = new TH1D("counter15_m","Counter register CAS 2",75,1.,150.);
  TH1D *counter16_m      = new TH1D("counter16_m","Counter register NC",75,1.,150.);

  //EXTRA
  TH1D *counter1_e       = new TH1D("counter1_e","Counter register CARD 4",75,1.,150.);
  TH1D *counter2_e       = new TH1D("counter2_e","Counter register CAT 2",75,1.,150.);
  TH1D *counter3_e       = new TH1D("counter3_e","Counter register CAS 1",75,1.,150.);
  TH1D *counter4_e       = new TH1D("counter4_e","Counter register NC",75,1.,150.);
  TH1D *counter5_e       = new TH1D("counter5_e","Counter register CARD 2",75,1.,150.);
  TH1D *counter6_e       = new TH1D("counter6_e","Counter register CAT 4",75,1.,150.);
  TH1D *counter7_e       = new TH1D("counter7_e","Counter register CAS 4",75,1.,150.);
  TH1D *counter8_e       = new TH1D("counter8_e","Counter register NC",75,1.,150.);
  TH1D *counter9_e       = new TH1D("counter9_e","Counter register CARD 3",75,1.,150.);
  TH1D *counter10_e      = new TH1D("counter10_e","Counter register CAT 3",75,1.,150.);
  TH1D *counter11_e      = new TH1D("counter11_e","Counter register CAS 3",75,1.,150.);
  TH1D *counter12_e      = new TH1D("counter12_e","Counter register NC",75,1.,150.);
  TH1D *counter13_e      = new TH1D("counter13_e","Counter register CARD 1",75,1.,150.);
  TH1D *counter14_e      = new TH1D("counter14_e","Counter register CAT 1",75,1.,150.);
  TH1D *counter15_e      = new TH1D("counter15_e","Counter register CAS 2",75,1.,150.);
  TH1D *counter16_e      = new TH1D("counter16_e","Counter register NC",75,1.,150.);
  
  //MAIN
  TH1D *shift1_m       = new TH1D("shift1_m","Shift register CARD 4",16,0.,16.);
  shift1_m->GetXaxis()->SetTitle("Bin");
  shift1_m->GetYaxis()->SetTitle("Content");
  TH1D *shift2_m       = new TH1D("shift2_m","Shift register CAT 2",16,0.,16.);
  shift2_m->GetXaxis()->SetTitle("Bin");
  shift2_m->GetYaxis()->SetTitle("Content");
  TH1D *shift3_m       = new TH1D("shift3_m","Shift register CAS 1",16,0.,16.);
  shift3_m->GetXaxis()->SetTitle("Bin");
  shift3_m->GetYaxis()->SetTitle("Content");
  TH1D *shift4_m       = new TH1D("shift4_m","Shift register NC",16,0.,16.);
  shift4_m->GetXaxis()->SetTitle("Bin");
  shift4_m->GetYaxis()->SetTitle("Content");
  TH1D *shift5_m       = new TH1D("shift5_m","Shift register CARD 2",16,0.,16.);
  shift5_m->GetXaxis()->SetTitle("Bin");
  shift5_m->GetYaxis()->SetTitle("Content");
  TH1D *shift6_m       = new TH1D("shift6_m","Shift register CAT 4",16,0.,16.);
  shift6_m->GetXaxis()->SetTitle("Bin");
  shift6_m->GetYaxis()->SetTitle("Content");
  TH1D *shift7_m       = new TH1D("shift7_m","Shift register CAS 4",16,0.,16.);
  shift7_m->GetXaxis()->SetTitle("Bin");
  shift7_m->GetYaxis()->SetTitle("Content");
  TH1D *shift8_m       = new TH1D("shift8_m","Shift register NC",16,0.,16.);
  shift8_m->GetXaxis()->SetTitle("Bin");
  shift8_m->GetYaxis()->SetTitle("Content");
  TH1D *shift9_m       = new TH1D("shift9_m","Shift register CARD 3",16,0.,16.);
  shift9_m->GetXaxis()->SetTitle("Bin");
  shift9_m->GetYaxis()->SetTitle("Content");
  TH1D *shift10_m      = new TH1D("shift10_m","Shift register CAT 3",16,0.,16.);
  shift10_m->GetXaxis()->SetTitle("Bin");
  shift10_m->GetYaxis()->SetTitle("Content");
  TH1D *shift11_m      = new TH1D("shift11_m","Shift register CAS 3",16,0.,16.);
  shift11_m->GetXaxis()->SetTitle("Bin");
  shift11_m->GetYaxis()->SetTitle("Content");
  TH1D *shift12_m      = new TH1D("shift12_m","Shift register NC",16,0.,16.);
  shift12_m->GetXaxis()->SetTitle("Bin");
  shift12_m->GetYaxis()->SetTitle("Content");
  TH1D *shift13_m      = new TH1D("shift13_m","Shift register CARD 1",16,0.,16.);
  shift13_m->GetXaxis()->SetTitle("Bin");
  shift13_m->GetYaxis()->SetTitle("Content");
  TH1D *shift14_m      = new TH1D("shift14_m","Shift register CAT 1",16,0.,16.);
  shift14_m->GetXaxis()->SetTitle("Bin");
  shift14_m->GetYaxis()->SetTitle("Content");
  TH1D *shift15_m      = new TH1D("shift15_m","Shift register CAS 2",16,0.,16.);
  shift15_m->GetXaxis()->SetTitle("Bin");
  shift15_m->GetYaxis()->SetTitle("Content");
  TH1D *shift16_m      = new TH1D("shift16_m","Shift register NC",16,0.,16.);
  shift16_m->GetXaxis()->SetTitle("Bin");
  shift16_m->GetYaxis()->SetTitle("Content");

  //EXTRA
  TH1D *shift1_e       = new TH1D("shift1_e","Shift register 1",16,0.,16.);
  shift1_e->GetXaxis()->SetTitle("Bin");
  shift1_e->GetYaxis()->SetTitle("Content");
  TH1D *shift2_e       = new TH1D("shift2_e","Shift register 2",16,0.,16.);
  shift2_e->GetXaxis()->SetTitle("Bin");
  shift2_e->GetYaxis()->SetTitle("Content");
  TH1D *shift3_e       = new TH1D("shift3_e","Shift register 3",16,0.,16.);
  shift3_e->GetXaxis()->SetTitle("Bin");
  shift3_e->GetYaxis()->SetTitle("Content");
  TH1D *shift4_e       = new TH1D("shift4_e","Shift register 4",16,0.,16.);
  shift4_e->GetXaxis()->SetTitle("Bin");
  shift4_e->GetYaxis()->SetTitle("Content");
  TH1D *shift5_e       = new TH1D("shift5_e","Shift register 5",16,0.,16.);
  shift5_e->GetXaxis()->SetTitle("Bin");
  shift5_e->GetYaxis()->SetTitle("Content");
  TH1D *shift6_e       = new TH1D("shift6_e","Shift register 6",16,0.,16.);
  shift6_e->GetXaxis()->SetTitle("Bin");
  shift6_e->GetYaxis()->SetTitle("Content");
  TH1D *shift7_e       = new TH1D("shift7_e","Shift register 7",16,0.,16.);
  shift7_e->GetXaxis()->SetTitle("Bin");
  shift7_e->GetYaxis()->SetTitle("Content");
  TH1D *shift8_e       = new TH1D("shift8_e","Shift register 8",16,0.,16.);
  shift8_e->GetXaxis()->SetTitle("Bin");
  shift8_e->GetYaxis()->SetTitle("Content");
  TH1D *shift9_e       = new TH1D("shift9_e","Shift register 9",16,0.,16.);
  shift9_e->GetXaxis()->SetTitle("Bin");
  shift9_e->GetYaxis()->SetTitle("Content");
  TH1D *shift10_e      = new TH1D("shift10_e","Shift register 10",16,0.,16.);
  shift10_e->GetXaxis()->SetTitle("Bin");
  shift10_e->GetYaxis()->SetTitle("Content");
  TH1D *shift11_e      = new TH1D("shift11_e","Shift register 11",16,0.,16.);
  shift11_e->GetXaxis()->SetTitle("Bin");
  shift11_e->GetYaxis()->SetTitle("Content");
  TH1D *shift12_e      = new TH1D("shift12_e","Shift register 12",16,0.,16.);
  shift12_e->GetXaxis()->SetTitle("Bin");
  shift12_e->GetYaxis()->SetTitle("Content");
  TH1D *shift13_e      = new TH1D("shift13_e","Shift register 13",16,0.,16.);
  shift13_e->GetXaxis()->SetTitle("Bin");
  shift13_e->GetYaxis()->SetTitle("Content");
  TH1D *shift14_e      = new TH1D("shift14_e","Shift register 14",16,0.,16.);
  shift14_e->GetXaxis()->SetTitle("Bin");
  shift14_e->GetYaxis()->SetTitle("Content");
  TH1D *shift15_e      = new TH1D("shift15_e","Shift register 15",16,0.,16.);
  shift15_e->GetXaxis()->SetTitle("Bin");
  shift15_e->GetYaxis()->SetTitle("Content");
  TH1D *shift16_e      = new TH1D("shift16_e","Shift register 16",16,0.,16.);
  shift16_e->GetXaxis()->SetTitle("Bin");
  shift16_e->GetYaxis()->SetTitle("Content");
  

  
  //MAIN
  TH1D *head_m         = new TH1D("head_m","Status and Headers",10,0.,10.);
  head_m->GetXaxis()->SetBinLabel(1,"Event CRC M");
  head_m->GetXaxis()->SetBinLabel(2,"Headers M");
  head_m->GetXaxis()->SetBinLabel(3,"CRC M");
  head_m->GetXaxis()->SetBinLabel(4,"Dsp M");
  head_m->GetXaxis()->SetBinLabel(5,"Reg M");
  head_m->GetXaxis()->SetBinLabel(6,"Event CRC E");
  head_m->GetXaxis()->SetBinLabel(7,"Headers E");
  head_m->GetXaxis()->SetBinLabel(8,"CRC E");
  head_m->GetXaxis()->SetBinLabel(9,"Dsp E");
  head_m->GetXaxis()->SetBinLabel(10,"Reg E");
  head_m->GetYaxis()->SetTitle("Errors");
  head_m->SetMinimum(0);

  TH1D *hitmap_m       = new TH1D("hitmap_m","Hitmap",16,0.,16.);
  hitmap_m->GetXaxis()->SetBinLabel(1,mtitel[0]);
  hitmap_m->GetXaxis()->SetBinLabel(2,mtitel[1]);
  hitmap_m->GetXaxis()->SetBinLabel(3,mtitel[2]);
  hitmap_m->GetXaxis()->SetBinLabel(4,mtitel[3]);
  hitmap_m->GetXaxis()->SetBinLabel(5,mtitel[4]);
  hitmap_m->GetXaxis()->SetBinLabel(6,mtitel[5]);
  hitmap_m->GetXaxis()->SetBinLabel(7,mtitel[6]);
  hitmap_m->GetXaxis()->SetBinLabel(8,mtitel[7]);
  hitmap_m->GetXaxis()->SetBinLabel(9,mtitel[8]);
  hitmap_m->GetXaxis()->SetBinLabel(10,mtitel[9]);
  hitmap_m->GetXaxis()->SetBinLabel(11,mtitel[10]);
  hitmap_m->GetXaxis()->SetBinLabel(12,mtitel[11]);
  hitmap_m->GetXaxis()->SetBinLabel(13,mtitel[12]);
  hitmap_m->GetXaxis()->SetBinLabel(14,mtitel[13]);
  hitmap_m->GetXaxis()->SetBinLabel(15,mtitel[14]);
  hitmap_m->GetXaxis()->SetBinLabel(16,mtitel[15]);
  hitmap_m->GetYaxis()->SetTitle("Hits");

  TH1D *pmtstatus_m = new TH1D("pmtstatus_m","Coincidence errors MAIN",16,0.,16.);
  pmtstatus_m->GetXaxis()->SetBinLabel(1,mtitel[0]);
  pmtstatus_m->GetXaxis()->SetBinLabel(2,mtitel[1]);
  pmtstatus_m->GetXaxis()->SetBinLabel(3,mtitel[2]);
  pmtstatus_m->GetXaxis()->SetBinLabel(4,mtitel[3]);
  pmtstatus_m->GetXaxis()->SetBinLabel(5,mtitel[4]);
  pmtstatus_m->GetXaxis()->SetBinLabel(6,mtitel[5]);
  pmtstatus_m->GetXaxis()->SetBinLabel(7,mtitel[6]);
  pmtstatus_m->GetXaxis()->SetBinLabel(8,mtitel[7]);
  pmtstatus_m->GetXaxis()->SetBinLabel(9,mtitel[8]);
  pmtstatus_m->GetXaxis()->SetBinLabel(10,mtitel[9]);
  pmtstatus_m->GetXaxis()->SetBinLabel(11,mtitel[10]);
  pmtstatus_m->GetXaxis()->SetBinLabel(12,mtitel[11]);
  pmtstatus_m->GetXaxis()->SetBinLabel(13,mtitel[12]);
  pmtstatus_m->GetXaxis()->SetBinLabel(14,mtitel[13]);
  pmtstatus_m->GetXaxis()->SetBinLabel(15,mtitel[14]);
  pmtstatus_m->GetXaxis()->SetBinLabel(16,mtitel[15]);
  pmtstatus_m->GetYaxis()->SetTitle("Errors");

  //if(fromevent==0 && toevent==0)
    TH1D *trigg_m        = new TH1D("trigg_m","Trigger dev",antal,0.,antal);
    /*if(toevent>0 && fromevent>0)
    TH1D *trigg_m        = new TH1D("trigg_m","Trigger dev",toevent-fromevent,fromevent,toevent);
  if(toevent==0 && fromevent>0)
  TH1D *trigg_m        = new TH1D("trigg_m","Trigger dev",1,fromevent,fromevent+1);*/
  //trigg_m->SetMinimum(0);
  trigg_m->GetYaxis()->SetTitle("Triggers");
  trigg_m->GetXaxis()->SetTitle("Event number");

  TH1D *timebtrigg_m     = new TH1D("timebtrigg_m","Time between triggers",100,0.,5.);
  //timebtrigg_m->SetBit(TH1D::kCanRebin);
  timebtrigg_m->GetYaxis()->SetTitle("Events");
  timebtrigg_m->GetXaxis()->SetTitle("Time [s]");

  //if(fromevent==0 && toevent==0){
    TH1D *crc_m          = new TH1D("crc_m","crc MAIN",antal,0.,antal);
    TH1D *headerr_m      = new TH1D("headerr_m","headerr_m",antal,0.,antal);
    TH1D *crcerr_m       = new TH1D("crcerr_m","crcerr_m",antal,0.,antal);
    TH1D *dsperr_m       = new TH1D("dsperr_m","dsperr_m",antal,0.,antal);
    TH1D *regerr_m       = new TH1D("regerr_m","regerr_m",antal,0.,antal);
    //}
    /*
  if(toevent>0 && fromevent>0){
    TH1D *crc_m          = new TH1D("crc_m","crc MAIN",toevent-fromevent,fromevent,toevent);
    TH1D *headerr_m      = new TH1D("headerr_m","headerr_m",toevent-fromevent,fromevent,toevent);
    TH1D *crcerr_m       = new TH1D("crcerr_m","crcerr_m",toevent-fromevent,fromevent,toevent);
    TH1D *dsperr_m       = new TH1D("dsperr_m","dsperr_m",toevent-fromevent,fromevent,toevent);
    TH1D *regerr_m       = new TH1D("regerr_m","regerr_m",toevent-fromevent,fromevent,toevent);
  }
  if(toevent==0 && fromevent>0){
    TH1D *crc_m          = new TH1D("crc_m","crc MAIN",1,fromevent,fromevent+1);
    TH1D *headerr_m      = new TH1D("headerr_m","headerr_m",1,fromevent,fromevent+1);
    TH1D *crcerr_m       = new TH1D("crcerr_m","crcerr_m",1,fromevent,fromevent+1);
    TH1D *dsperr_m       = new TH1D("dsperr_m","dsperr_m",1,fromevent,fromevent+1);
    TH1D *regerr_m       = new TH1D("regerr_m","regerr_m",1,fromevent,fromevent+1);
    }*/

  TH1D *dtrigg_m       = new TH1D("dtrigg_m","Trigger increment",10,0.,10.);
  dtrigg_m->GetYaxis()->SetTitle("Events");
  dtrigg_m->GetXaxis()->SetTitle("Trigger increment");

  TH1D *timebtrigg_e     = new TH1D("timebtrigg_e","Time between triggers EXTRA",100,0.,5.);
  //timebtrigg_e->SetBit(TH1D::kCanRebin);
  timebtrigg_e->GetYaxis()->SetTitle("Events");
  timebtrigg_e->GetXaxis()->SetTitle("Time [s]");


  // if(fromevent==0 && toevent==0){
    TH1D *crc_e          = new TH1D("crc_e","crc EXTRA",antal,0.,antal);
    TH1D *headerr_e      = new TH1D("headerr_e","headerr_e",antal,0.,antal);
    TH1D *crcerr_e       = new TH1D("crcerr_e","crcerr_e",antal,0.,antal);
    TH1D *dsperr_e       = new TH1D("dsperr_e","dsperr_e",antal,0.,antal);
    TH1D *regerr_e       = new TH1D("regerr_e","regerr_e",antal,0.,antal);
    //}
    /*
  if(toevent>0 && fromevent>0){
    TH1D *crc_e          = new TH1D("crc_e","crc EXTRA",toevent-fromevent,fromevent,toevent);
    TH1D *headerr_e      = new TH1D("headerr_e","headerr_e",toevent-fromevent,fromevent,toevent);
    TH1D *crcerr_e       = new TH1D("crcerr_e","crcerr_e",toevent-fromevent,fromevent,toevent);
    TH1D *dsperr_e       = new TH1D("dsperr_e","dsperr_e",toevent-fromevent,fromevent,toevent);
    TH1D *regerr_e       = new TH1D("regerr_e","regerr_e",toevent-fromevent,fromevent,toevent);
  }
  if(toevent==0 && fromevent>0){
    TH1D *crc_e          = new TH1D("crc_e","crc EXTRA",1,fromevent,fromevent+1);
    TH1D *headerr_e      = new TH1D("headerr_e","headerr_e",1,fromevent,fromevent+1);
    TH1D *crcerr_e       = new TH1D("crcerr_e","crcerr_e",1,fromevent,fromevent+1);
    TH1D *dsperr_e       = new TH1D("dsperr_e","dsperr_e",1,fromevent,fromevent+1);
    TH1D *regerr_e       = new TH1D("regerr_e","regerr_e",1,fromevent,fromevent+1);
    }*/
    //if(fromevent==0 && toevent==0){
    TH1D *T_right_m = new TH1D("T_right_m","Temperature MAIN",antal,0.,antal);
    TH1D *T_actel_m = new TH1D("T_actel_m","Temperature MAIN",antal,0.,antal);
    TH1D *T_dsp_m = new TH1D("T_dsp_m","Temperature MAIN",antal,0.,antal);
    TH1D *T_left_m = new TH1D("T_left_m","Temperature MAIN",antal,0.,antal);
  //}
    /*
  if(fromevent>0 && toevent>0){
    TH1D *T_right_m = new TH1D("T_right_m","Temperature MAIN",toevent-fromevent,fromevent,toevent);
    TH1D *T_actel_m = new TH1D("T_actel_m","Temperature MAIN",toevent-fromevent,fromevent,toevent);
    TH1D *T_dsp_m = new TH1D("T_dsp_m","Temperature MAIN",toevent-fromevent,fromevent,toevent);
    TH1D *T_left_m = new TH1D("T_left_m","Temperature MAIN",toevent-fromevent,fromevent,toevent);
  }
  if(fromevent>0 && toevent==0){
    TH1D *T_right_m = new TH1D("T_right_m","Temperature MAIN",1,fromevent,fromevent+1);
    TH1D *T_actel_m = new TH1D("T_actel_m","Temperature MAIN",1,fromevent,fromevent+1);
    TH1D *T_dsp_m = new TH1D("T_dsp_m","Temperature MAIN",1,fromevent,fromevent+1);
    TH1D *T_left_m = new TH1D("T_left_m","Temperature MAIN",1,fromevent,fromevent+1);
  }
    */
  T_right_m->GetXaxis()->SetTitle("Event number");
  T_right_m->GetYaxis()->SetTitle("Temp [C]");
  T_right_m->SetMinimum(10);
  T_right_m->SetMaximum(50);
  //T_actel_m->SetMinimum(0);
  //T_actel_m->SetMaximum(700);
  //T_dsp_m->SetMinimum(0);
  //T_dsp_m->SetMaximum(700);
  //T_left_m->SetMinimum(0);
  //T_left_m->SetMaximum(700);

  //if(fromevent==0 && toevent==0){
    TH1D *T_right_e = new TH1D("T_right_e","Temperature EXTRA",antal,0.,antal);
    TH1D *T_actel_e = new TH1D("T_actel_e","Temperature EXTRA",antal,0.,antal);
    TH1D *T_dsp_e = new TH1D("T_dsp_e","Temperature EXTRA",antal,0.,antal);
    TH1D *T_left_e = new TH1D("T_left_e","Temperature EXTRA",antal,0.,antal);
    //}
    /*
  if(fromevent>0 && toevent>0){
    TH1D *T_right_e = new TH1D("T_right_e","Temperature EXTRA",toevent-fromevent,fromevent,toevent);
    TH1D *T_actel_e = new TH1D("T_actel_e","Temperature EXTRA",toevent-fromevent,fromevent,toevent);
    TH1D *T_dsp_e = new TH1D("T_dsp_e","Temperature EXTRA",toevent-fromevent,fromevent,toevent);
    TH1D *T_left_e = new TH1D("T_left_e","Temperature EXTRA",toevent-fromevent,fromevent,toevent);
  }
  if(fromevent>0 && toevent==0){
    TH1D *T_right_e = new TH1D("T_right_e","Temperature EXTRA",1,fromevent,fromevent+1);
    TH1D *T_actel_e = new TH1D("T_actel_e","Temperature EXTRA",1,fromevent,fromevent+1);
    TH1D *T_dsp_e = new TH1D("T_dsp_e","Temperature EXTRA",1,fromevent,fromevent+1);
    TH1D *T_left_e = new TH1D("T_left_e","Temperature EXTRA",1,fromevent,fromevent+1);
  }
    */
  T_right_e->GetXaxis()->SetTitle("Event number");
  T_right_e->GetYaxis()->SetTitle("Temp [C]");
  T_right_e->SetMinimum(10);
  T_right_e->SetMaximum(50);

  //EXTRA
  TH1D *head_e         = new TH1D("head_e","Status and Headers",10,0.,10.);
  head_e->GetXaxis()->SetBinLabel(1,"CRC event M");
  head_e->GetXaxis()->SetBinLabel(2,"Headers M");
  head_e->GetXaxis()->SetBinLabel(3,"CRC M");
  head_e->GetXaxis()->SetBinLabel(4,"Dsp M");
  head_e->GetXaxis()->SetBinLabel(5,"Reg M");
  head_e->GetXaxis()->SetBinLabel(6,"CRC event E");
  head_e->GetXaxis()->SetBinLabel(7,"Headers E");
  head_e->GetXaxis()->SetBinLabel(8,"CRC E");
  head_e->GetXaxis()->SetBinLabel(9,"Dsp E");
  head_e->GetXaxis()->SetBinLabel(10,"Reg E");
  head_e->GetYaxis()->SetTitle("Errors");
  head_e->SetMinimum(0);

  /* INTE
  TH1D *head_e         = new TH1D("head_e","Status and Headers",9,0.,9.);
  head_e->GetXaxis()->SetBinLabel(1,"Status");
  head_e->GetXaxis()->SetBinLabel(2,"Reg 0");
  head_e->GetXaxis()->SetBinLabel(3,"Reg 1");
  head_e->GetXaxis()->SetBinLabel(4,"Reg 2");
  head_e->GetXaxis()->SetBinLabel(5,"Reg 3");
  head_e->GetXaxis()->SetBinLabel(6,"Reg 4");
  head_e->GetXaxis()->SetBinLabel(7,"Reg 5");
  head_e->GetXaxis()->SetBinLabel(8,"Head 1");
  head_e->GetXaxis()->SetBinLabel(9,"Head 2");
  head_e->GetYaxis()->SetTitle("Errors");
  */
  
  TH1D *hitmap_e       = new TH1D("hitmap_e","Hitmap EXTRA",16,0.,16.);
  hitmap_e->GetXaxis()->SetBinLabel(1,etitel[0]);
  hitmap_e->GetXaxis()->SetBinLabel(2,etitel[1]);
  hitmap_e->GetXaxis()->SetBinLabel(3,etitel[2]);
  hitmap_e->GetXaxis()->SetBinLabel(4,etitel[3]);
  hitmap_e->GetXaxis()->SetBinLabel(5,etitel[4]);
  hitmap_e->GetXaxis()->SetBinLabel(6,etitel[5]);
  hitmap_e->GetXaxis()->SetBinLabel(7,etitel[6]);
  hitmap_e->GetXaxis()->SetBinLabel(8,etitel[7]);
  hitmap_e->GetXaxis()->SetBinLabel(9,etitel[8]);
  hitmap_e->GetXaxis()->SetBinLabel(10,etitel[9]);
  hitmap_e->GetXaxis()->SetBinLabel(11,etitel[10]);
  hitmap_e->GetXaxis()->SetBinLabel(12,etitel[11]);
  hitmap_e->GetXaxis()->SetBinLabel(13,etitel[12]);
  hitmap_e->GetXaxis()->SetBinLabel(14,etitel[13]);
  hitmap_e->GetXaxis()->SetBinLabel(15,etitel[14]);
  hitmap_e->GetXaxis()->SetBinLabel(16,etitel[15]);
  hitmap_e->GetYaxis()->SetTitle("Hits");
  
  TH1D *pmtstatus_e = new TH1D("pmtstatus_e","Coincidence errors EXTRA",16,0.,16.);
  pmtstatus_e->GetXaxis()->SetBinLabel(1,mtitel[0]);
  pmtstatus_e->GetXaxis()->SetBinLabel(2,mtitel[1]);
  pmtstatus_e->GetXaxis()->SetBinLabel(3,mtitel[2]);
  pmtstatus_e->GetXaxis()->SetBinLabel(4,mtitel[3]);
  pmtstatus_e->GetXaxis()->SetBinLabel(5,mtitel[4]);
  pmtstatus_e->GetXaxis()->SetBinLabel(6,mtitel[5]);
  pmtstatus_e->GetXaxis()->SetBinLabel(7,mtitel[6]);
  pmtstatus_e->GetXaxis()->SetBinLabel(8,mtitel[7]);
  pmtstatus_e->GetXaxis()->SetBinLabel(9,mtitel[8]);
  pmtstatus_e->GetXaxis()->SetBinLabel(10,mtitel[9]);
  pmtstatus_e->GetXaxis()->SetBinLabel(11,mtitel[10]);
  pmtstatus_e->GetXaxis()->SetBinLabel(12,mtitel[11]);
  pmtstatus_e->GetXaxis()->SetBinLabel(13,mtitel[12]);
  pmtstatus_e->GetXaxis()->SetBinLabel(14,mtitel[13]);
  pmtstatus_e->GetXaxis()->SetBinLabel(15,mtitel[14]);
  pmtstatus_e->GetXaxis()->SetBinLabel(16,mtitel[15]);
  pmtstatus_e->GetYaxis()->SetTitle("Errors");

  //if(fromevent==0 && toevent==0)
    TH1D *trigg_e        = new TH1D("trigg_e","Triggers EXTRA",antal,0.,antal);
    //if(fromevent>0 && toevent>0)
    //TH1D *trigg_e        = new TH1D("trigg_e","Triggers EXTRA",toevent-fromevent,fromevent,toevent);
    // if(fromevent>0 && toevent==0)
    //TH1D *trigg_e        = new TH1D("trigg_e","Triggers EXTRA",1,fromevent,fromevent+1);
  trigg_e->GetYaxis()->SetTitle("Triggers");
  trigg_e->GetXaxis()->SetTitle("Event number");
  TH1D *dtrigg_e       = new TH1D("dtrigg_e","Trigger increment EXTRA",10,0.,10.);
  dtrigg_e->GetYaxis()->SetTitle("Events");
  dtrigg_e->GetXaxis()->SetTitle("Trigger increment");
 
 
   
  /********************************************************************************/
  
  //Long64_t nevents    = tr->GetEntries();
  //Int_t    mintime    = tr->GetMinimum("Pscu.OrbitalTime");
  //Int_t    maxtime    = tr->GetMaximum("Pscu.OrbitalTime");
  //Int_t    nbintime   = (maxtime-mintime)/1000;
  char *error;
  error=" this is a very long line of characters as workaround   ";
  
  /*******************Declarations*****************/
  if(DEBUG)
    printf("Declarate variables\n");
  //cout << "Events: " << nevents << endl;
  //const Int_t size = nevents;
  //cout << "entries: " << size << endl;
  //printf("nentries %d\n",size);
  Double_t cputime;
  UShort_t cnt = 1;
  //unsigned int CRCcheck[2];
  //unsigned int wordbuf[2][63];
  
  int totevents=0;
  int crcevents[2];
  crcevents[0]=0;
  crcevents[1]=0;

  UShort_t CRCcheck[2];
  UShort_t Status[2];
  UShort_t Reg[2][6];
  UShort_t Header[2][2];
  UShort_t Hitmap[2];
  UShort_t Trigger[2];
  Short_t Trigg_old[2]={-1,-1};
  UShort_t Temp[2][4];

  UShort_t timeLSB[2];
  UShort_t timeMSB[2];
  Double_t time[2];
  Double_t tid1[2];
  Double_t tid2[2];
  Double_t tid3[2];

  Int_t Counter[2][16];
  Int_t Counter1[2][16];
  Int_t Counter2[2][16];
  Int_t Counter3[2][16];
  Double_t rate[2][16];
  Double_t rate10[2][16];
  Int_t rate10cnt[2][16];
  Int_t cntmltp=10;

  UShort_t Shift[2][16];
  int tmp;
  int vec[2][16][16];
  //UShort_t pack[2][16];
  int hitsCAS,hitsCAT,hitsCARD;


  //UShort_t timeLSB[2];
  //UShort_t timeMSB[2];
  //Double_t time[2];
  //Double_t tid1[2];
  //Double_t tid2[2];
  //Double_t tid3[2];

  //Double_t hits_x[size],hits_y_m[size],hits_y_e[size];
  
  /*************************************************/
 
 
  //
  // run over each event and take out some variables
  //
  if ( fromevent > toevent && toevent ){
    printf("It must be fromevent < toevent \n");
    return -1;
  };
  
  
  if ( fromevent > nevents || fromevent < 0 ) {
    //printf("You can choose fromevent between 0 (all) and %d \n",nevents);
    return -1;
  };
  
  if ( toevent > nevents || toevent < 0 ) {
    //printf("You can choose toevent between 0 (all) and %d \n",nevents);
    return -1;
  };
  int minevent,maxevent;
  if ( fromevent == 0 ) {
    minevent = 0;
    maxevent = nevents;
  } else {
    minevent = fromevent - 1;
    if ( toevent > 0 ){
      maxevent = toevent;
    } else {
      maxevent = fromevent;
    };
  };

  //strange bug, this line have to be here...
  //CRC=crc(CRC,0x0);

  //int what=0;

  if(DEBUG)
    printf("Zero variables\n");

  for(Int_t b=0;b<2;b++){
    for(Int_t a=0;a<16;a++){
      rate10[b][a]=0;
      rate10cnt[b][a]=0;
    }
  }
  //Go through all events and update histograms and plots
  //for (Int_t i = 0; i < nevents; i++){
  if(fullversion)
    {
      if(DEBUG)
	printf("Start looping over events (FULL VERSION)\n");
      for (Int_t i = minevent; i < maxevent; i++){
	//printf("1");
	//printf("%d%c",100*(i-minevent)/(maxevent-minevent),37);
	//printf("2");
	//fflush(stdout);
	ph = eh->GetPscuHeader();
	cputime = ph->GetOrbitalTime();    
	if(DEBUG)
	  printf("Processing event %d\n",i);
	tr->GetEntry(i);
	
	totevents=totevents+1;
	
	//CRC check
	CRCcheck[0]=ace->CRCcheck[0];
	CRCcheck[1]=ace->CRCcheck[1];
	if(CRCcheck[0]==0)
	  {
	    head_m->Fill(0.0);
	    crcevents[0]++;
	  }
	if(CRCcheck[1]==0)
	  {
	    head_e->Fill(5.0);
	    crcevents[1]++;
	  }
	
	if(DEBUG)
	  printf("Fetch parameters\n");
	//fetch parameters
	for(Int_t b = 0; b<2; b++){
	  for(Int_t j = 0; j < 16; j++){
	    Shift[b][j] = ace->shift[b][j];
	  }
	}
	
	cnt=1;
	for(Int_t b = 0; b < 2; b++){ //card
	  for(Int_t k = 0; k < 16; k++){ //shift register
	    for(Int_t l = 0; l < 16; l++){ //bin
	      tmp = ((Shift[b][k] & cnt) > 0 ? 1 : 0);
	      vec[b][k][l]=tmp;
	      cnt=cnt<<1;
	    }
	    cnt=1;
	  }
	}
	
	
	//fetch parameters
	for(int b = 0; b<2; b++){
	  //cout << ace->status << endl;
	  timeLSB[b] = ace->clock[b][0];
	  timeMSB[b] = ace->clock[b][1];
	  
	  Status[b] = ace->status[b];
	  for(Int_t j = 0; j < 6; j++)
	    Reg[b][j] = ace->regist[b][j];
	  Header[b][0] = ace->header[b][0];
	  Header[b][1] = ace->header[b][1];
	  Hitmap[b] = ace->hitmap[b];
	  
	  Trigger[b] = ace->trigg[b];
	  Temp[b][0] = ((ace->temp[b][0]) & 0x00FF);
	  Temp[b][1] = ((ace->temp[b][0]) & 0xFF00)/256;
	  Temp[b][2] = ((ace->temp[b][1]) & 0x00FF);
	  Temp[b][3] = ((ace->temp[b][1]) & 0xFF00)/256;
	  for(Int_t j = 0; j < 16; j++)	
	    Counter[b][j] = ace->counters[b][j];
	  
	  
	}
   
	hitsCAS=hitsCAT=hitsCARD=0;
	for(int b=0;b<2;b++)
	  {
	    if((Hitmap[b] & 0x0001) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x0002) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x0004) > 0) hitsCAS++;
	    if((Hitmap[b] & 0x0010) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x0020) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x0040) > 0) hitsCAS++;
	    if((Hitmap[b] & 0x0100) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x0200) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x0400) > 0) hitsCAS++;
	    if((Hitmap[b] & 0x1000) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x2000) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x4000) > 0) hitsCAS++;
	  }
	cnt=1;
	//check that both PMTs have seen events, and if not, increment histogram with 1.
	/*
	  if((ace->CRCcheck[0])==1 && (ace->CRCcheck[1])==1){

	  //hits_x[i-minevent] = cputime;
	  //hits_y_m[i-minevent] = ace->trigg[0];
	  //hits_y_e[i-minevent] = ace->trigg[1];
	  
	  for(int j=0;j<16;j++){
	  if((Hitmap[0] & cnt) > 0){
	  //cout << "E" << endl;
	  if((Hitmap[1] & cnt) == 0){
	  pmtstatus_e->Fill(j,1.);
	  //cout << "E filled" << endl;
	  }
	  }
	  if((Hitmap[1] & cnt) > 0){
	  //cout << "M" << endl;
	  if((Hitmap[0] & cnt) == 0){
	  pmtstatus_m->Fill(j,1.);
	  //cout << "M filled" << endl;
	  }
	  }
	  cnt=cnt<<1;
	  }
	  }
	*/
	cnt=1;
    
	
	//tempL=hex>>8;
	//tempR=hex-(tempL<<8);
	if(DEBUG)
	  printf("Calc time b events\n");
	//time between events (tid3[b])
	for(Int_t b = 0; b<2; b++){
	  time[b]=(timeMSB[b]*(pow(2,16))+timeLSB[b]);
	  
	  if(i==minevent)
	    tid1[b]=time[b];
	  else{
	    tid2[b]=tid1[b];
	    tid1[b]=time[b];
	  }
	  if(tid1[b]<tid2[b])
	    tid2[b]=tid2[b]-4294967294;
	  
	  tid3[b]=(tid1[b]-tid2[b])/(25*1000000);
	  //printf("%f\n",tid3[b]);
	}
	
	
	//number of counts between events Counter3[b][j] -> rate[b][j]
	for(Int_t b=0;b<2;b++){
	  for(Int_t j = 0; j < 16; j++){
	    if(i==minevent)
	      Counter1[b][j]=Counter[b][j];
	    else{
	      Counter2[b][j]=Counter1[b][j];
	      Counter1[b][j]=Counter[b][j];
	    }
	    Counter3[b][j]=Counter1[b][j]-Counter2[b][j];
	    if(Counter3[b][j]<0)
	      Counter3[b][j]=Counter3[b][j]+65535;
	    if(tid3[b]>0){
	      rate[b][j]=Counter3[b][j]/tid3[b];
	      rate10[b][j]=rate10[b][j]+rate[b][j];
	      rate10cnt[b][j]=rate10cnt[b][j]+1;
	    }
	  }
	}
	
	
	//fill histograms MAIN
	if(DEBUG)
	  printf("Fill histogram MAIN\n");
	
	if(CRCcheck[0]==CRCcheck[1]==1)
	  {
	    nmbhitpmtCAS->Fill(hitsCAS,1);
	    nmbhitpmtCAT->Fill(hitsCAT,1);
	    nmbhitpmtCARD->Fill(hitsCARD,1);
	  }
	if(CRCcheck[0]==1)
	  {
	    for(Int_t j = 0; j < 16; j++){
	      shift1_m->Fill(j,vec[0][j][0]);
	      shift2_m->Fill(j,vec[0][j][1]);
	      shift3_m->Fill(j,vec[0][j][2]);
	      shift4_m->Fill(j,vec[0][j][3]);
	      shift5_m->Fill(j,vec[0][j][4]);
	      shift6_m->Fill(j,vec[0][j][5]);
	      shift7_m->Fill(j,vec[0][j][6]);
	      shift8_m->Fill(j,vec[0][j][7]);
	      shift9_m->Fill(j,vec[0][j][8]);
	      shift10_m->Fill(j,vec[0][j][9]);
	      shift11_m->Fill(j,vec[0][j][10]);
	      shift12_m->Fill(j,vec[0][j][11]);
	      shift13_m->Fill(j,vec[0][j][12]);
	      shift14_m->Fill(j,vec[0][j][13]);
	      shift15_m->Fill(j,vec[0][j][14]);
	      shift16_m->Fill(j,vec[0][j][15]);
	    }
	  }
	
	//fill histograms EXTRA
	if(DEBUG)
	  printf("Fill histogram EXTRA\n");
	if(CRCcheck[1]==1)
	  {
	    for(Int_t j = 0; j < 16; j++){
	      shift1_e->Fill(j,vec[1][j][0]);
	      shift2_e->Fill(j,vec[1][j][1]);
	      shift3_e->Fill(j,vec[1][j][2]);
	      shift4_e->Fill(j,vec[1][j][3]);
	      shift5_e->Fill(j,vec[1][j][4]);
	      shift6_e->Fill(j,vec[1][j][5]);
	      shift7_e->Fill(j,vec[1][j][6]);
	      shift8_e->Fill(j,vec[1][j][7]);
	      shift9_e->Fill(j,vec[1][j][8]);
	      shift10_e->Fill(j,vec[1][j][9]);
	      shift11_e->Fill(j,vec[1][j][10]);
	      shift12_e->Fill(j,vec[1][j][11]);
	      shift13_e->Fill(j,vec[1][j][12]);
	      shift14_e->Fill(j,vec[1][j][13]);
	      shift15_e->Fill(j,vec[1][j][14]);
	      shift16_e->Fill(j,vec[1][j][15]);
	    }
	  }
	


	
	if(((ace->CRCcheck[0])==1) && (ace->CRC[0]!=0)){
	  if((Header[0][0] != 0xACAC) || (Header[0][1] != 0xAC11)){
	    head_m->Fill(1.,1);
	    headerr_m->Fill(i,Trigger[0]);}
	  if((Status[0] & 0x8000) < 0x8000){
	    head_m->Fill(2.,1);
	    crcerr_m->Fill(i,Trigger[0]);}
	  if((Status[0] & 0x4000) < 0x4000){
	    head_m->Fill(3.,1);
	    dsperr_m->Fill(i,Trigger[0]);}
	  if((Status[0] & 0x01FF) < 0x01FF){
	    head_m->Fill(4.,1);
	    regerr_m->Fill(i,Trigger[0]);}
	  T_right_m->Fill(i,Temp[0][0]*2.8-273.);
	  T_actel_m->Fill(i,Temp[0][1]*2.8-273.);
	  T_dsp_m->Fill(i,Temp[0][2]*2.8-273.);
	  T_left_m->Fill(i,Temp[0][3]*2.8-273.);
	  trigg_m->Fill(i,Trigger[0]);
	  dtrigg_m->Fill(Trigger[0]-Trigg_old[0],Trigg_old[0] == -1 ? 0 : 1);
	  Trigg_old[0]=Trigger[0];
	  timebtrigg_m->Fill(tid3[0],1.); 
	  
	  
	  if(DEBUG)
	    printf("Calculate rates\n");
	  if(i!=minevent){
	    //fill histograms MAIN
	    if(rate10cnt[0][0]==cntmltp){
	      counter1_m->Fill(rate10[0][0]/10.,1);
	      //printf("rate :%d\n",rate10[0][0]);
	      rate10cnt[0][0]=0;
	      rate10[0][0]=0;
	    }
	    if(rate10cnt[0][1]==cntmltp){
	      counter2_m->Fill(rate10[0][1]/10.,1);
	      rate10cnt[0][1]=0;
	      rate10[0][1]=0;
	    }
	    if(rate10cnt[0][2]==cntmltp){
	      counter3_m->Fill(rate10[0][2]/10.,1);
	      rate10cnt[0][2]=0;
	      rate10[0][2]=0;
	    }
	    if(rate10cnt[0][3]==cntmltp){
	      counter4_m->Fill(rate10[0][3]/10.,1);
	      rate10cnt[0][3]=0;
	      rate10[0][3]=0;
	    }
	    if(rate10cnt[0][4]==cntmltp){
	      counter5_m->Fill(rate10[0][4]/10.,1);
	      rate10cnt[0][4]=0;
	      rate10[0][4]=0;
	    }
	    if(rate10cnt[0][5]==cntmltp){
	      counter6_m->Fill(rate10[0][5]/10.,1);
	      rate10cnt[0][5]=0;
	      rate10[0][5]=0;
	    }
	    if(rate10cnt[0][6]==cntmltp){
	      counter7_m->Fill(rate10[0][6]/10.,1);
	      rate10cnt[0][6]=0;
	      rate10[0][6]=0;
	    }
	    if(rate10cnt[0][7]==cntmltp){	
	      counter8_m->Fill(rate10[0][7]/10.,1);
	      rate10cnt[0][7]=0;
	      rate10[0][7]=0;
	    }
	    if(rate10cnt[0][8]==cntmltp){
	      counter9_m->Fill(rate10[0][8]/10.,1);
	      rate10cnt[0][8]=0;
	      rate10[0][8]=0;
	    }
	    if(rate10cnt[0][9]==cntmltp){
	      counter10_m->Fill(rate10[0][9]/10.,1);
	      rate10cnt[0][9]=0;
	      rate10[0][9]=0;
	    }
	    if(rate10cnt[0][10]==cntmltp){
	      counter11_m->Fill(rate10[0][10]/10.,1);
	      rate10cnt[0][10]=0;
	      rate10[0][10]=0;
	    }
	    if(rate10cnt[0][11]==cntmltp){
	      counter12_m->Fill(rate10[0][11]/10.,1);
	      rate10cnt[0][11]=0;
	      rate10[0][11]=0;
	    }
	    if(rate10cnt[0][12]==cntmltp){
	      counter13_m->Fill(rate10[0][12]/10.,1);
	      rate10cnt[0][12]=0;
	      rate10[0][12]=0;
	    }
	    if(rate10cnt[0][13]==cntmltp){
	      counter14_m->Fill(rate10[0][13]/10.,1);
	      rate10cnt[0][13]=0;
	      rate10[0][13]=0;
	    }
	    if(rate10cnt[0][14]==cntmltp){
	      counter15_m->Fill(rate10[0][14]/10.,1);
	      rate10cnt[0][14]=0;
	      rate10[0][14]=0;
	    }
	    if(rate10cnt[0][15]==cntmltp){
	      counter16_m->Fill(rate10[0][15]/10,1);
	      rate10cnt[0][15]=0;
	      rate10[0][15]=0;
	    }
	    
	  }
	}
	//fill histograms EXTRA
	if(((ace->CRCcheck[1])==1) && (ace->CRC[1]!=0)){
	  if((Header[1][0] != 0xACAC) || (Header[1][1] != 0xAC22)){
	    head_e->Fill(6.,1);
	    headerr_e->Fill(i,Trigger[1]);
	    //headerr_e->Fill(i,testtrigg);
	    //cout << "i: " << i << " Trigger: " << Trigger[1] << endl;
	  }
	  if((Status[1] & 0x8000) < 0x8000){
	    head_e->Fill(7.,1);
	    crcerr_e->Fill(i,Trigger[1]);}
	  if((Status[1] & 0x4000) < 0x4000){
	    head_e->Fill(8.,1);
	    dsperr_e->Fill(i,Trigger[1]);}
	  if((Status[1] & 0x01FF) < 0x01FF){
	    head_e->Fill(9.,1);
	    regerr_e->Fill(i,Trigger[1]);}
	  T_right_e->Fill(i,Temp[1][0]*2.8-273.);
	  T_actel_e->Fill(i,Temp[1][1]*2.8-273.);
	  T_dsp_e->Fill(i,Temp[1][2]*2.8-273.);
	  T_left_e->Fill(i,Temp[1][3]*2.8-273.);
	  trigg_e->Fill(i,Trigger[1]);
	  dtrigg_e->Fill(Trigger[1]-Trigg_old[1],Trigg_old[1] == -1 ? 0 : 1);
	  Trigg_old[1]=Trigger[1];
	  timebtrigg_e->Fill(tid3[1],1.); 
	  
	  if(i!=minevent){
	    //fill histograms EXTRA
	    if(rate10cnt[1][0]==cntmltp){
	      counter1_e->Fill(rate10[1][0]/10.,1);
	      //printf("rate :%d\n",rate10[1][0]);
	      rate10cnt[1][0]=0;
	      rate10[1][0]=0;
	    }
	    if(rate10cnt[1][1]==cntmltp){
	      counter2_e->Fill(rate10[1][1]/10.,1);
	      rate10cnt[1][1]=0;
	      rate10[1][1]=0;
	    }
	    if(rate10cnt[1][2]==cntmltp){
	      counter3_e->Fill(rate10[1][2]/10.,1);
	      rate10cnt[1][2]=0;
	      rate10[1][2]=0;
	    }
	    if(rate10cnt[1][3]==cntmltp){
	      counter4_e->Fill(rate10[1][3]/10.,1);
	      rate10cnt[1][3]=0;
	      rate10[1][3]=0;
	    }
	    if(rate10cnt[1][4]==cntmltp){
	      counter5_e->Fill(rate10[1][4]/10.,1);
	      rate10cnt[1][4]=0;
	      rate10[1][4]=0;
	    }
	    if(rate10cnt[1][5]==cntmltp){
	      counter6_e->Fill(rate10[1][5]/10.,1);
	      rate10cnt[1][5]=0;
	      rate10[1][5]=0;
	    }
	    if(rate10cnt[1][6]==cntmltp){
	      counter7_e->Fill(rate10[1][6]/10.,1);
	      rate10cnt[1][6]=0;
	      rate10[1][6]=0;
	    }
	    if(rate10cnt[1][7]==cntmltp){	
	      counter8_e->Fill(rate10[1][7]/10.,1);
	      rate10cnt[1][7]=0;
	      rate10[1][7]=0;
	    }
	    if(rate10cnt[1][8]==cntmltp){
	      counter9_e->Fill(rate10[1][8]/10.,1);
	      rate10cnt[1][8]=0;
	      rate10[1][8]=0;
	    }
	    if(rate10cnt[1][9]==cntmltp){
	      counter10_e->Fill(rate10[1][9]/10.,1);
	      rate10cnt[1][9]=0;
	      rate10[1][9]=0;
	    }
	    if(rate10cnt[1][10]==cntmltp){
	      counter11_e->Fill(rate10[1][10]/10.,1);
	      rate10cnt[1][10]=0;
	      rate10[1][10]=0;
	    }
	    if(rate10cnt[1][11]==cntmltp){
	      counter12_e->Fill(rate10[1][11]/10.,1);
	      rate10cnt[1][11]=0;
	      rate10[1][11]=0;
	    }
	    if(rate10cnt[1][12]==cntmltp){
	      counter13_e->Fill(rate10[1][12]/10.,1);
	      rate10cnt[1][12]=0;
	      rate10[1][12]=0;
	    }
	    if(rate10cnt[1][13]==cntmltp){
	      counter14_e->Fill(rate10[1][13]/10.,1);
	      rate10cnt[1][13]=0;
	      rate10[1][13]=0;
	    }
	    if(rate10cnt[1][14]==cntmltp){
	      counter15_e->Fill(rate10[1][14]/10.,1);
	      rate10cnt[1][14]=0;
	      rate10[1][14]=0;
	    }
	    if(rate10cnt[1][15]==cntmltp){
	      counter16_e->Fill(rate10[1][15]/10,1);
	      rate10cnt[1][15]=0;
	      rate10[1][15]=0;
	    }
	  }
	}
	cnt=1;
	for(Int_t j = 0; j < 16; j++){
	  if((ace->CRCcheck[0])==1)
	    hitmap_m->Fill(j,(Hitmap[0] & cnt)>0 ? 1 : 0);
	  if((ace->CRCcheck[1])==1)
	    hitmap_e->Fill(j,(Hitmap[1] & cnt)>0 ? 1 : 0);
	  cnt=cnt<<1;
	}
	
	cnt=1;
	/*
	  if((100*(i-minevent)/(maxevent-minevent))<10.)
	  printf("%c%c",8,8);
	  else
	  printf("%c%c%c",8,8,8);
	*/
      }
    }
  
   if(!fullversion)
    {
      if(DEBUG)
	printf("Start looping over events (DUMMY VERSION)\n");
      for (Int_t i = minevent; i < maxevent; i++){
	//printf("1");
	//printf("%d%c",100*(i-minevent)/(maxevent-minevent),37);
	//printf("2");
	//fflush(stdout);
	ph = eh->GetPscuHeader();
	cputime = ph->GetOrbitalTime();    
	if(DEBUG)
	  printf("Processing event %d\n",i);
	tr->GetEntry(i);

	totevents=totevents+1;
	
	//CRC check
	CRCcheck[0]=ace->CRCcheck[0];
	CRCcheck[1]=ace->CRCcheck[1];
	if(CRCcheck[0]==0)
	  {
	    head_m->Fill(0.0);
	    crcevents[0]++;
	  }
	if(CRCcheck[1]==0)
	  {
	    head_e->Fill(5.0);
	    crcevents[1]++;
	  }
    
	//fetch parameters
	for(int b = 0; b<2; b++){
	  Status[b] = ace->status[b];
	  for(Int_t j = 0; j < 6; j++)
	    Reg[b][j] = ace->regist[b][j];
	  Header[b][0] = ace->header[b][0];
	  Header[b][1] = ace->header[b][1];
	  Hitmap[b] = ace->hitmap[b];
	}
   
	hitsCAS=hitsCAT=hitsCARD=0;
	for(int b=0;b<2;b++)
	  {
	    if((Hitmap[b] & 0x0001) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x0002) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x0004) > 0) hitsCAS++;
	    if((Hitmap[b] & 0x0010) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x0020) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x0040) > 0) hitsCAS++;
	    if((Hitmap[b] & 0x0100) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x0200) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x0400) > 0) hitsCAS++;
	    if((Hitmap[b] & 0x1000) > 0) hitsCARD++;
	    if((Hitmap[b] & 0x2000) > 0) hitsCAT++;
	    if((Hitmap[b] & 0x4000) > 0) hitsCAS++;
	  }

	if(((ace->CRCcheck[0])==1) && (ace->CRC[0]!=0)){
	  if((Header[0][0] != 0xACAC) || (Header[0][1] != 0xAC11)){
	    head_m->Fill(1.,1);
	    headerr_m->Fill(i,Trigger[0]);}
	  if((Status[0] & 0x8000) < 0x8000){
	    head_m->Fill(2.,1);
	    crcerr_m->Fill(i,Trigger[0]);}
	  if((Status[0] & 0x4000) < 0x4000){
	    head_m->Fill(3.,1);
	    dsperr_m->Fill(i,Trigger[0]);}
	  if((Status[0] & 0x01FF) < 0x01FF){
	    head_m->Fill(4.,1);
	    regerr_m->Fill(i,Trigger[0]);}
	}

	//fill histograms EXTRA
	if(((ace->CRCcheck[1])==1) && (ace->CRC[1]!=0)){
	  if((Header[1][0] != 0xACAC) || (Header[1][1] != 0xAC22)){
	    head_e->Fill(6.,1);
	    headerr_e->Fill(i,Trigger[1]);
	    //headerr_e->Fill(i,testtrigg);
	    //cout << "i: " << i << " Trigger: " << Trigger[1] << endl;
	  }
	  if((Status[1] & 0x8000) < 0x8000){
	    head_e->Fill(7.,1);
	    crcerr_e->Fill(i,Trigger[1]);}
	  if((Status[1] & 0x4000) < 0x4000){
	    head_e->Fill(8.,1);
	    dsperr_e->Fill(i,Trigger[1]);}
	  if((Status[1] & 0x01FF) < 0x01FF){
	    head_e->Fill(9.,1);
	    regerr_e->Fill(i,Trigger[1]);}
 
	  cnt=1;
	  for(Int_t j = 0; j < 16; j++){
	    if((ace->CRCcheck[0])==1)
	      hitmap_m->Fill(j,(Hitmap[0] & cnt)>0 ? 1 : 0);
	    if((ace->CRCcheck[1])==1)
	      hitmap_e->Fill(j,(Hitmap[1] & cnt)>0 ? 1 : 0);
	    cnt=cnt<<1;
	  }
	  
	  cnt=1;
	}
      }
    }

  //printf("%d%c\n",100,37);
  //fflush(stdout);
  //printf("\n********* QLOOK SHORT INFO **********\n\n");
  //printf("Events: %d\nCrc Main %d\nCrc Extra: %d\n",totevents,crcevents[0],crcevents[1]);
  //printf("Calibrations: %d\n",nCalibs);
  //printf("\n**************************************\n");
  //printf("\nOpening canvases...\n");
  //cout << "hits: " << what << endl;
  //Draw histograms
  //gStyle->SetPalette(1);

  if(DEBUG)
    printf("Start plotting\n");

  /***************************************** PLOTTING *****************************************/
  
  //Variables
  TCanvas *Canv_report1,*Canv_report2,*Canv_report3,*Canv_report4;
  TLatex *t;
  TPad *pd1,*pd2,*pd3,*pd4,*pd5,*pd6,*pd7,*pd8,*pd9,*pd10,*pd11,*pd12;
  TLine *linje;
  TLegend *leg_m,*leg_e,*leg1_m;
  Int_t i;
  Double_t max1,max2;
  char *namn = "KKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKKK";
  int mposition = 80;
  int eposition = 80;
  char *figsave = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
  char *mystring = "DDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD";
  //char *tmpchar = "JJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJJ";
  TBox *b1,*b2,*b3,*b4,*b5;
  gStyle->SetOptDate(0); 
  TString *merr = new TString[5];
  merr[0]="Event CRC";
  merr[1]="Headers";
  merr[2]="CRC";
  merr[3]="Dsp";
  merr[4]="Reg";

  if(!fullversion)
    {
      Canv_report1 = new TCanvas("QL Report Sheet 1","QL Report Sheet 1", 1280, 1024); //base
      Canv_report1->Range(0,0,100,100);
      //Canv_report1->Divide(2,2);
      Canv_report1->Draw();
      b1 = new TBox(10,84.5,90,85.5);
      b2 = new TBox(49.5,95,50.5,5);
      b1->SetFillColor(1);
      b2->SetFillColor(1);
      b1->Draw();
      b2->Draw();
      

      t=new TLatex();
      t->SetTextFont(40);
      t->SetTextColor(1);
      t->SetTextAlign(12);
      t->SetTextSize(0.04);
      namn = "AntiCounter MAIN card";
      t->DrawLatex(10,90,namn);
      t->SetTextColor(1);
      namn = "AntiCounter EXTRA card";
      t->DrawLatex(58,90,namn);
      t->SetTextSize(0.025);
      //Canv_report1->cd(1);
      for(i=1;i<17;i++)
	{
	  if(i!=4 && i!=8 && i!=12 && i!=16 && hitmap_m->GetBinContent(i)==0){
	    mystring = Form("%s channel empty",mtitel[i-1].Data());  
	    t->SetTextColor(2);
	    t->DrawLatex(15,mposition,mystring);
	    mposition -= 4;
	  }
	  if(i!=4 && i!=8 && i!=12 && i!=16 && hitmap_e->GetBinContent(i)==0){
	    mystring = Form("%s channel empty",etitel[i-1].Data()); 
	    t->SetTextColor(2);
	    t->DrawLatex(65,eposition,mystring);
	    eposition -= 4;
	  }
	}
      for(i=0;i<5;i++)
	{
	  if(head_m->GetBinContent(i+1)>0){
	    mposition -= 4;
	    mystring = Form("%d %s errors",(int)head_m->GetBinContent(i+1),merr[i].Data());
	    t->SetTextColor(2); 
	    t->DrawLatex(15,mposition,mystring);
	  }
	  if(head_e->GetBinContent(i+5+1)>0){
	    eposition -= 4;
	    mystring = Form("%d %s errors",(int)head_e->GetBinContent(i+5+1),merr[i].Data());
	    t->SetTextColor(2); 
	    t->DrawLatex(65,eposition,mystring);
	  }
	}
      //if no errors
      if(mposition==80)
	{
	  namn = "AC main working";
	  t->SetTextSize(0.035);
	  t->SetTextColor(1); 
	  t->DrawLatex(15,50,namn);
	}
      if(eposition==80)
	{
	  namn = "AC extra working";
	  t->SetTextSize(0.035);
	  t->SetTextColor(1); 
	  t->DrawLatex(65,50,namn);
	}
      if(mposition!=80 || eposition!=80)
	{
	  namn = "AC malfunction";
	  t->SetTextSize(0.035);
          t->SetTextColor(1);
          t->DrawLatex(41.5,97.3,namn);
	  b3 = new TBox(10,96,40,98.5);
	  b4 = new TBox(10,1.5,90,4);
	  b5 = new TBox(60,96,90,98.5);
	  b3->SetFillColor(2);
	  b4->SetFillColor(2);
	  b5->SetFillColor(2);
	  b3->Draw();
	  b4->Draw();
	  b5->Draw();
	}
      //head_m->Draw();
      //head_e->Draw("SAME");
      //Canv_report1->cd(3);
      //hitmap_m->SetStats(kFALSE);
      //hitmap_m->Draw();
      //Canv_report1->cd(4);
      //hitmap_e->SetStats(kFALSE);
      //hitmap_e->Draw();
      
    }
  if(fullversion)
    {
      //Anticounter report sheet 1
      Canv_report1 = new TCanvas("QL Report Sheet 1","QL Report Sheet 1", 1280, 1024); //base
      Canv_report1->Range(0,0,100,100);
      //tsf = (TSystemFile*)AcList->First();
      
      //sprintf(error,"File: %s ",tsf->GetName());
      //printf("A3\n");
      t=new TLatex();
      t->SetTextFont(32);
      t->SetTextColor(1);
      t->SetTextAlign(12);
      t->SetTextSize(0.015);
      //t->DrawLatex(2.,99.,error);
      t->SetTextSize(0.02);
      namn = "MAIN";
      t->DrawLatex(82,99,namn);
      t->SetTextColor(2);
      namn="EXTRA";
      t->DrawLatex(89,99,namn);
      t->SetTextColor(1);
      pd1 = new TPad("pd1","This is pad1",0.02,0.02,0.49,0.49,17); //lower left
      pd2 = new TPad("pd2","This is pad2",0.51,0.02,0.98,0.49,17); //lower right
      //pd3 = new TPad("pd3","This is pad3",0.51,0.51,0.98,0.74,17); //upper-lower right
      pd4 = new TPad("pd4","This is pad4",0.02,0.51,0.49,0.98,17); //upper left
      //pd5 = new TPad("pd5","This is pad5",0.51,0.25,0.98,0.49,17); //lower-upper right
      pd3 = new TPad("pd3","This is pad3",0.51,0.51,0.98,0.98,17); //upper right
      
      Canv_report1->cd();
       //pd1->Range(0,0,100,100);
       //pd2->Range(0,0,100,100);
       //pd3->Range(0,0,100,100);
       //pd4->Range(0,0,100,100); 
       //pd5->Range(0,0,100,100);
       //pd6->Range(0,0,100,100);
      pd1->Draw();
      pd2->Draw();
      pd3->Draw();
      pd4->Draw();
      //pd5->Draw();
      //pd6->Draw();
      
      pd3->cd(); //upper right
      if(head_m->GetMaximum()>head_e->GetMaximum())
	head_m->SetMaximum(1.1*head_m->GetMaximum());
      else
	head_m->SetMaximum(1.1*head_e->GetMaximum());
      head_m->SetLineColor(1);
      head_m->SetStats(kFALSE);
      head_m->Draw();
      head_e->SetLineColor(2);
      head_e->Draw("SAME");
      linje = new TLine(50,0,0,100);
      linje->SetLineColor(1);
      linje->Draw("SAME");
      
      
      //pmtstatus_m->SetLineColor(1);
      //pmtstatus_m->Draw();
      //hitmap_e->SetLineColor(2);
      //hitmap_e->Draw("SAME");
      
      pd4->cd(); //lower right
      hitmap_m->SetLineColor(1);
      hitmap_m->SetStats(kFALSE);
      hitmap_m->Draw();

      //pd5->cd(); //lower-upper right
      hitmap_e->SetLineColor(2);
      hitmap_e->SetStats(kFALSE);
      hitmap_e->Draw("SAME");
      
      pd1->cd();
      T_right_m->SetLineColor(1);
      T_right_m->SetStats(kFALSE);
      T_right_m->Draw();
      T_actel_m->SetLineColor(2);
      T_actel_m->Draw("SAME");
      T_dsp_m->SetLineColor(3);
      T_dsp_m->Draw("SAME");
      T_left_m->SetLineColor(4);
      T_left_m->Draw("SAME");
      
      leg_m = new TLegend(0.78,0.63,0.9,0.8);
      leg_m->AddEntry(T_right_m,"Right","l");
      leg_m->AddEntry(T_actel_m,"Actel","l");
      leg_m->AddEntry(T_dsp_m,"Dsp","l");
      leg_m->AddEntry(T_left_m,"Left","l");
      leg_m->Draw();
      
      
      //pd2->cd();
      //pmtstatus_e->SetLineColor(1);
      //pmtstatus_e->Draw(); 
      //TGraph *gr1 = new TGraph(antal,hits_x,hits_y_m);
      //gr1->Draw("AC*");
      
      pd2->cd();
      T_right_e->SetLineColor(1);
      T_right_e->SetStats(kFALSE);
      T_right_e->Draw();
      T_actel_e->SetLineColor(2);
      T_actel_e->Draw("SAME");
      T_dsp_e->SetLineColor(3);
      T_dsp_e->Draw("SAME");
      T_left_e->SetLineColor(4);
      T_left_e->Draw("SAME");
      
      leg_e = new TLegend(0.78,0.63,0.9,0.8);
      leg_e->AddEntry(T_right_e,"Right","l");
      leg_e->AddEntry(T_actel_e,"Actel","l");
      leg_e->AddEntry(T_dsp_e,"Dsp","l");
      leg_e->AddEntry(T_left_e,"Left","l");
      leg_e->Draw();
      
      //pd6->cd(); //upper-upper right
      //hitmap_m->SetLineColor(1);
      //hitmap_m->Draw();
      
      /*
	TA INTE MED
	pd4->cd();
	T_right_m->SetLineColor(1);
	T_right_m->Draw();
	T_actel_m->SetLineColor(1);
	T_actel_m->Draw("SAME");
	//T_dsp_m->SetLineColor(1);
	//T_dsp_m->Draw("SAME");
	T_left_m->SetLineColor(1);
	T_left_m->Draw("SAME");
	T_right_e->SetLineColor(2);
	T_right_e->Draw("SAME");
	T_actel_e->SetLineColor(2);
	T_actel_e->Draw("SAME");
	//T_dsp_e->SetLineColor(2);
	//T_dsp_e->Draw("SAME");
	T_left_e->SetLineColor(2);
	T_left_e->Draw("SAME");
      */
      //Canv_report1->Update();
      
      //report sheet 2
      //ps->NewPage();
      Canv_report2 = new TCanvas("QL Report Sheet 2","QL Report Sheet 2", 1280, 1024); 
      Canv_report2->Range(0,0,100,100);
      //tsf = (TSystemFile*)AcList->First();
      //sprintf(error,"File: %s ",tsf->GetName());
      //TLatex *t=new TLatex();
      t->SetTextFont(32);
      t->SetTextColor(1);
      t->SetTextAlign(12);
      t->SetTextSize(0.015);
      //t->DrawLatex(2.,99.,error);
      t->SetTextSize(0.02);
      namn="MAIN";
      t->DrawLatex(82,99,namn);
      t->SetTextColor(2);
      namn="EXTRA";
      t->DrawLatex(89,99,namn);
      t->SetTextColor(1);
      //TPad *pd1,*pd2,*pd3,*pd4,*pd5,*pd6,*pd7;
      pd1 = new TPad("pd1","This is pad1",0.02,0.51,0.49,0.98,17);
      pd2 = new TPad("pd2","This is pad2",0.51,0.51,0.98,0.98,17);
      pd3 = new TPad("pd3","This is pad3",0.02,0.02,0.49,0.49,17);
      pd4 = new TPad("pd4","This is pad4",0.51,0.02,0.74,0.24,17); //down-left
      pd5 = new TPad("pd5","This is pad5",0.76,0.02,0.98,0.24,17); //down-right
      pd6 = new TPad("pd6","This is pad6",0.51,0.24,0.74,0.49,17); //up-left
      pd7 = new TPad("pd7","This is pad7",0.76,0.24,0.98,0.49,17); //up-right
      Canv_report2->cd();
       //pd1->Range(0,0,100,100);
       //pd2->Range(0,0,100,100);
       //pd3->Range(0,0,100,100);
       //pd4->Range(0,0,100,100);       
       //pd5->Range(0,0,100,100);
       //pd6->Range(0,0,100,100);
       //pd7->Range(0,0,100,100);  
      pd1->Draw();
      pd2->Draw();
      pd3->Draw();
      pd4->Draw();
      pd5->Draw();
      pd6->Draw();
      pd7->Draw();
      
      max1 = trigg_m->GetMaximum();
      max2 = trigg_e->GetMaximum();
      if(max1>max2)
	trigg_m->SetMaximum(1.03*max1);
      else
	trigg_m->SetMaximum(1.03*max2);
      
      pd1->cd(); //lower left
      trigg_m->SetLineColor(1);
      trigg_m->SetStats(kFALSE);
      trigg_m->Draw();
      
      crc_m->SetMarkerStyle(22);
      crc_m->SetMarkerSize(1.);
      crc_m->SetMarkerColor(9);
      crc_m->Draw("SAMEP");
      
      headerr_m->SetMarkerStyle(5);
      headerr_m->SetMarkerSize(1.);
      headerr_m->SetMarkerColor(9);
      headerr_m->Draw("SAMEP");
      
      crcerr_m->SetMarkerStyle(2);
      crcerr_m->SetMarkerSize(1.);
      crcerr_m->SetMarkerColor(9);
      crcerr_m->Draw("SAMEP");
      
      dsperr_m->SetMarkerStyle(7);
      dsperr_m->SetMarkerSize(1.);
      dsperr_m->SetMarkerColor(9);
      dsperr_m->Draw("SAMEP");
      
      regerr_m->SetMarkerStyle(4);
      regerr_m->SetMarkerSize(1.);
      regerr_m->SetMarkerColor(9);
      regerr_m->Draw("SAMEP");
      
      leg1_m = new TLegend(0.7,0.5,0.87,0.7);
      leg1_m->AddEntry(crc_m,"CRC","p");
      leg1_m->AddEntry(headerr_m,"Headers","p");
      leg1_m->AddEntry(crcerr_m,"Cmd CRC","p");
      leg1_m->AddEntry(dsperr_m,"Dsp","p");
      leg1_m->AddEntry(regerr_m,"Reg","p");
      leg1_m->SetHeader("ERRORS");
      leg1_m->Draw();
      
      //Canv_report1->Update();
      
      trigg_e->SetLineColor(2);
      //trigg_e->SetMaximum(1.03*trigg_e->GetMaximum());
      trigg_e->SetStats(kFALSE);
      trigg_e->Draw("SAME");
      
      //TGaxis *axis = new TGaxis(gPad->GetUxmax(),gPad->GetUymin(),gPad->GetUxmax(),gPad->GetUymax(),0,rightmax,510,"+L");
      //axis->SetLineColor(2);
      //axis->Draw();
      
      crc_e->SetMarkerStyle(22);
      crc_e->SetMarkerSize(1.);
      crc_e->SetMarkerColor(9);
      crc_e->Draw("SAMEP");
      
      headerr_e->SetMarkerStyle(5);
      headerr_e->SetMarkerSize(1.);
      headerr_e->SetMarkerColor(9);
      headerr_e->Draw("SAMEP");
      
      crcerr_e->SetMarkerStyle(2);
      crcerr_e->SetMarkerSize(1.);
      crcerr_e->SetMarkerColor(9);
      crcerr_e->Draw("SAMEP");
      
      dsperr_e->SetMarkerStyle(7);
      dsperr_e->SetMarkerSize(1.);
      dsperr_e->SetMarkerColor(9);
      dsperr_e->Draw("SAMEP");
      
      regerr_e->SetMarkerStyle(4);
      regerr_e->SetMarkerSize(1.);
      regerr_e->SetMarkerColor(9);
      regerr_e->Draw("SAMEP");
      /*
	TLegend *leg1_e = new TLegend(0.7,0.5,0.87,0.7);
	leg1_e->AddEntry(crc_e,"CRC","p");
	leg1_e->AddEntry(headerr_e,"Headers","p");
	leg1_e->AddEntry(crcerr_e,"Cmd CRC","p");
	leg1_e->AddEntry(dsperr_e,"Dsp","p");
	leg1_e->AddEntry(regerr_e,"Reg","p");
	leg1_e->SetHeader("Errors EXTRA");
	leg1_e->Draw();
      */
      /*
	pd4->cd(); //upper left
	int max1 = head_m->GetMaximum();
	int max2 = head_e->GetMaximum();
	if(max1>max2)
	head_m->SetMaximum(1.1*max1);
	else
	head_m->SetMaximum(1.1*max2);
	
	head_m->SetLineColor(1);
	head_m->Draw();
	head_e->SetLineColor(2);
	head_e->Draw("SAME");
      */
      /*
	pd3->cd(); //upper right
	if(head_m->GetMaximum()>head_e->GetMaximum())
	head_m->SetMaximum(1.1*head_m->GetMaximum());
	else
	head_m->SetMaximum(1.1*head_e->GetMaximum());
	head_m->SetLineColor(1);
	head_m->SetStats(kFALSE);
	head_m->Draw();
	head_e->SetLineColor(2);
	head_e->Draw("SAME");
	TLine *linje = new TLine(50,0,0,100);
	linje->SetLineColor(1);
	linje->Draw("SAME");
      */
      
      pd2->cd();
      pd2->SetLogy(1);
      dtrigg_m->SetLineColor(1);
      dtrigg_m->SetStats(kFALSE);
      dtrigg_m->Draw();
      dtrigg_e->SetLineColor(2);
      dtrigg_e->SetStats(kFALSE);
      dtrigg_e->Draw("SAME");
  
      pd3->cd();
      pd3->SetLogy(1);
      timebtrigg_m->SetLineColor(1);
      //timebtrigg_m->SetStats(kFALSE);
      timebtrigg_m->Draw();
      timebtrigg_e->SetLineColor(2);
      timebtrigg_e->SetMarkerStyle(2);
      timebtrigg_e->SetMarkerSize(1.);
      timebtrigg_e->SetMarkerColor(2);
      //timebtrigg_e->SetPolyMarker(2)
      timebtrigg_e->SetStats(kFALSE);
      timebtrigg_e->Draw("PSAME");
      
      pd4->cd();
      pd4->SetLogy(1);
      nmbhitpmtCAS->SetLineColor(1);
      nmbhitpmtCAS->SetStats(kFALSE);
      nmbhitpmtCAS->Draw();
      
      pd7->cd();
      pd5->SetLogy(1);
      nmbhitpmtCAT->SetLineColor(1);
      nmbhitpmtCAT->SetStats(kFALSE);
      nmbhitpmtCAT->Draw();
      
      pd6->cd();
      pd6->SetLogy(1);
      nmbhitpmtCARD->SetLineColor(1);
      nmbhitpmtCARD->SetStats(kFALSE);
      nmbhitpmtCARD->Draw();
      
      
      /*
	TLegend *hitpmt = new TLegend(0.7,0.5,0.87,0.7);
	hitpmt->AddEntry(nmbhitpmtCAS,"CAS","L");
	hitpmt->AddEntry(nmbhitpmtCAT,"CAT","L");
	hitpmt->AddEntry(nmbhitpmtCARD,"CARD","L");
	hitpmt->SetHeader("Detector");
	hitpmt->Draw();
      */
      //pd4->SetLogy(1);
      //timebtrigg_e->SetLineColor(2);
      //timebtrigg_e->SetStats(kFALSE);
      //timebtrigg_e->Draw();
      
 
      //report sheet 3
   //report sheet 1
  Canv_report3 = new TCanvas("QL Report Sheet 3","QL Report Sheet 3", 1280, 1024); 
   //TCanvas *Counter_report1 = new TCanvas("COUNTER Report sheet", "COUNTER Report sheet", 1280, 1024);
  Canv_report3->Range(0,0,100,100);
  //tsf = (TSystemFile*) AcList->First();
  //sprintf(error,"File: %s ",tsf->GetName());
  //TLatex *t=new TLatex();
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextAlign(12);
  t->SetTextSize(0.015);
  //t->DrawLatex(2.,99.,error);
  //char *namn;
  //TLatex *t2 = new TLatex();
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextAlign(12);
  t->SetTextSize(0.035);

  namn="Singles Counters";
  t->DrawLatex(40.,95,namn);
  namn="CAS";
  t->DrawLatex(4.,95.,namn);
  namn="CAT";
  t->DrawLatex(4.,65.,namn);
  namn="CARD";
  t->DrawLatex(4.,34.,namn);
  
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextAlign(12);
  t->SetTextSize(0.02);
  namn="MAIN";
  t->DrawLatex(85,98,namn);
  t->SetTextColor(2);
  namn="EXTRA";
  t->DrawLatex(85,95,namn);
  //TPad *pd1,*pd2,*pd3,*pd4,*pd5,*pd6,*pd7,*pd8,*pd9,*pd10,*pd11,*pd12;
  pd1 = new TPad("pd1","This is pad1",0.,0.68,0.25,.92);
  pd2 = new TPad("pd2","This is pad2",0.25,0.68,0.5,.92);
  pd3 = new TPad("pd3","This is pad3",0.5,0.68,0.75,.92);
  pd4 = new TPad("pd4","This is pad4",0.75,0.68,1.0,.92);
  pd5 = new TPad("pd5","This is pad5",0.,0.37,0.25,0.62);
  pd6 = new TPad("pd6","This is pad6",0.25,0.37,.5,0.62);
  pd7 = new TPad("pd7","This is pad7",0.5,0.37,0.75,0.62);
  pd8 = new TPad("pd8","This is pad8",0.75,0.37,1.0,0.62);
  pd9 = new TPad("pd9","This is pad9",0.0,0.06,0.25,0.31);
  pd10 = new TPad("pd10","This is pad10",0.25,0.06,.5,0.31);
  pd11 = new TPad("pd11","This is pad11",0.5,0.06,0.75,0.31);
  pd12 = new TPad("pd12","This is pad12",0.75,0.06,1.,0.31);
  //pd13 = new TPad("pd13","This is pad13",0.,0.0,0.25,0.25);
  //pd14 = new TPad("pd14","This is pad14",0.25,0.0,.5,0.25);
  //pd15 = new TPad("pd15","This is pad15",0.5,0.0,0.75,0.25);
  //pd16 = new TPad("pd16","This is pad16",0.75,0.0,1.0,0.25);
  Canv_report3->cd();
  //pd1->Range(0,0,100,100);
  //pd2->Range(0,0,100,100);
  //pd3->Range(0,0,100,100);
  //pd4->Range(0,0,100,100);       
  //pd5->Range(0,0,100,100);
  //pd6->Range(0,0,100,100);
  //pd7->Range(0,0,100,100);
  //pd8->Range(0,0,100,100); 
  //pd9->Range(0,0,100,100);
  //pd10->Range(0,0,100,100);
  //pd11->Range(0,0,100,100);
  //pd12->Range(0,0,100,100); 
  //pd13->Range(0,0,100,100);
  //pd14->Range(0,0,100,100);
  //pd15->Range(0,0,100,100);
  //pd16->Range(0,0,100,100); 
  pd1->Draw();
  pd2->Draw();
  pd3->Draw();
  pd4->Draw();
  pd5->Draw();
  pd6->Draw();
  pd7->Draw();
  pd8->Draw();
  pd9->Draw();
  pd10->Draw();
  pd11->Draw();
  pd12->Draw();
  //pd13->Draw();
  //pd14->Draw();
  //pd15->Draw();
  //pd16->Draw();
  pd1->cd();
  counter3_m->SetLineColor(1);
  counter3_m->Draw();
  counter3_e->SetLineColor(2);
  counter3_e->Draw("SAME");
  pd2->cd();
  counter15_m->SetLineColor(1);
  counter15_m->Draw();
  counter15_e->SetLineColor(2);
  counter15_e->Draw("SAME");
  pd3->cd();
  counter11_m->SetLineColor(1);
  counter11_m->Draw();
  counter11_e->SetLineColor(2);
  counter11_e->Draw("SAME");
  pd4->cd();
  counter7_m->SetLineColor(1);
  counter7_m->Draw();
  counter7_e->SetLineColor(2);
  counter7_e->Draw("SAME");
  pd5->cd();
  counter14_m->SetLineColor(1);
  counter14_m->Draw();
  counter14_e->SetLineColor(2);
  counter14_e->Draw("SAME");
  pd6->cd();
  counter2_m->SetLineColor(1);
  counter2_m->Draw();
  counter2_e->SetLineColor(2);
  counter2_e->Draw("SAME");
  pd7->cd();
  counter3_m->SetLineColor(1);
  counter10_m->Draw();
  counter10_e->SetLineColor(2);
  counter10_e->Draw("SAME");
  pd8->cd();
  counter6_m->SetLineColor(1);
  counter6_m->Draw();
  counter6_e->SetLineColor(2);
  counter6_e->Draw("SAME");
  pd9->cd();
  counter13_m->SetLineColor(1);
  counter13_m->Draw();
  counter13_e->SetLineColor(2);
  counter13_e->Draw("SAME");
  pd10->cd();
  counter5_m->SetLineColor(1);
  counter5_m->Draw();
  counter5_e->SetLineColor(2);
  counter5_e->Draw("SAME");
  pd11->cd();
  counter9_m->SetLineColor(1);
  counter9_m->Draw();
  counter9_e->SetLineColor(2);
  counter9_e->Draw("SAME");
  pd12->cd();
  counter1_m->SetLineColor(1);
  counter1_m->Draw();
  counter1_e->SetLineColor(2);
  counter1_e->Draw("SAME");

   //report sheet 4
  Canv_report4 = new TCanvas("QL Report sheet 4", "QL Report sheet 4", 1280, 1024);
  Canv_report4->Range(0,0,100,100);
  //tsf = (TSystemFile*)AcList->First();
  //sprintf(error,"File: %s ",tsf->GetName());
  //TLatex *t=new TLatex();
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextAlign(12);
  t->SetTextSize(0.015);
  //t->DrawLatex(2.,99.,error);
  //char *namn;
  //TLatex *t2 = new TLatex();
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextAlign(12);
  t->SetTextSize(0.035);
  
  namn="CAS";
  t->DrawLatex(4.,94.,namn);
  namn="CAT";
  t->DrawLatex(4.,65.,namn);
  namn="CARD";
  t->DrawLatex(4.,34.,namn);
  namn="Shift register content";
  t->DrawLatex(39.,95,namn);
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextAlign(12);
  t->SetTextSize(0.02);
  namn="MAIN";
  t->DrawLatex(85,98,namn);
  t->SetTextColor(2);
  namn="EXTRA";
  t->DrawLatex(85,95,namn);

  //TPad *pd1,*pd2,*pd3,*pd4,*pd5,*pd6,*pd7,*pd8,*pd9,*pd10,*pd11,*pd12;
  pd1 = new TPad("pd1","This is pad1",0.,0.68,0.25,.92);
  pd2 = new TPad("pd2","This is pad2",0.25,0.68,0.5,.92);
  pd3 = new TPad("pd3","This is pad3",0.5,0.68,0.75,.92);
  pd4 = new TPad("pd4","This is pad4",0.75,0.68,1.0,.92);
  pd5 = new TPad("pd5","This is pad5",0.,0.37,0.25,0.62);
  pd6 = new TPad("pd6","This is pad6",0.25,0.37,.5,0.62);
  pd7 = new TPad("pd7","This is pad7",0.5,0.37,0.75,0.62);
  pd8 = new TPad("pd8","This is pad8",0.75,0.37,1.0,0.62);
  pd9 = new TPad("pd9","This is pad9",0.0,0.06,0.25,0.31);
  pd10 = new TPad("pd10","This is pad10",0.25,0.06,.5,0.31);
  pd11 = new TPad("pd11","This is pad11",0.5,0.06,0.75,0.31);
  pd12 = new TPad("pd12","This is pad12",0.75,0.06,1.,0.31);
  //pd13 = new TPad("pd13","This is pad13",0.,0.0,0.25,0.25);
  //pd14 = new TPad("pd14","This is pad14",0.25,0.0,.5,0.25);
  //pd15 = new TPad("pd15","This is pad15",0.5,0.0,0.75,0.25);
  //pd16 = new TPad("pd16","This is pad16",0.75,0.0,1.0,0.25);
  Canv_report4->cd();
  //pd1->Range(0,0,100,100);
  pd1->SetLogy(1);
  //pd2->Range(0,0,100,100);
  pd2->SetLogy(1);
  //pd3->Range(0,0,100,100);
  pd3->SetLogy(1);
  // pd4->Range(0,0,100,100);    
  pd4->SetLogy(1);
  //pd5->Range(0,0,100,100);
  pd5->SetLogy(1);
  //pd6->Range(0,0,100,100);
  pd6->SetLogy(1);
  //pd7->Range(0,0,100,100);
  pd7->SetLogy(1);
  //pd8->Range(0,0,100,100); 
  pd8->SetLogy(1);
  //pd9->Range(0,0,100,100);
  pd9->SetLogy(1);
  //pd10->Range(0,0,100,100);
  pd10->SetLogy(1);
  //pd11->Range(0,0,100,100);
  pd11->SetLogy(1);
  //pd12->Range(0,0,100,100);
  pd12->SetLogy(1);
  //pd13->Range(0,0,100,100);
  //pd14->Range(0,0,100,100);
  //pd15->Range(0,0,100,100);
  //pd16->Range(0,0,100,100); 
  pd1->Draw();
  pd2->Draw();
  pd3->Draw();
  pd4->Draw();
  pd5->Draw();
  pd6->Draw();
  pd7->Draw();
  pd8->Draw();
  pd9->Draw();
  pd10->Draw();
  pd11->Draw();
  pd12->Draw();
  //pd13->Draw();
  //pd14->Draw();
  //pd15->Draw();
  //pd16->Draw();
  pd1->cd();
  shift3_m->SetLineColor(1);
  shift3_m->Draw();
  shift3_e->SetLineColor(2);
  shift3_e->Draw("SAME");
  pd2->cd();
  shift15_m->SetLineColor(1);
  shift15_m->Draw();
  shift15_e->SetLineColor(2);
  shift15_e->Draw("SAME");
  pd3->cd();
  shift11_m->SetLineColor(1);
  shift11_m->Draw();
  shift11_e->SetLineColor(2);
  shift11_e->Draw("SAME");
  pd4->cd();
  shift7_m->SetLineColor(1);
  shift7_m->Draw();
  shift7_e->SetLineColor(2);
  shift7_e->Draw("SAME");
  pd5->cd();
  shift14_m->SetLineColor(1);
  shift14_m->Draw();
  shift14_e->SetLineColor(2);
  shift14_e->Draw("SAME");
  pd6->cd();
  shift2_m->SetLineColor(1);
  shift2_m->Draw();
  shift2_e->SetLineColor(2);
  shift2_e->Draw("SAME");
  pd7->cd();
  shift3_m->SetLineColor(1);
  shift10_m->Draw();
  shift10_e->SetLineColor(2);
  shift10_e->Draw("SAME");
  pd8->cd();
  shift6_m->SetLineColor(1);
  shift6_m->Draw();
  shift6_e->SetLineColor(2);
  shift6_e->Draw("SAME");
  pd9->cd();
  shift13_m->SetLineColor(1);
  shift13_m->Draw();
  shift13_e->SetLineColor(2);
  shift13_e->Draw("SAME");
  pd10->cd();
  shift5_m->SetLineColor(1);
  shift5_m->Draw();
  shift5_e->SetLineColor(2);
  shift5_e->Draw("SAME");
  pd11->cd();
  shift9_m->SetLineColor(1);
  shift9_m->Draw();
  shift9_e->SetLineColor(2);
  shift9_e->Draw("SAME");
  pd12->cd();
  shift1_m->SetLineColor(1);
  shift1_m->Draw();
  shift1_e->SetLineColor(2);
  shift1_e->Draw("SAME");
    }//if(fullversion)


  //Name the file
  //const string fil = (const char*)fileName;
  
  //Int_t posiz = fil.find("dw_");
  //if ( posiz == -1 ) posiz = fil.find("DW_");
  //Int_t posiz2 = posiz+13;
  //TString file2;
  //stringcopy(file2,base,posiz,posiz2);
  //
  //const char *figrec = file2;
  
  //string *outdir = new string(outDir);
  //string *Format = new string(format);
  //char *figsave = 0;
   if(fullversion)
    {
      figsave = Form("%s/AcQLOOK1_%s.%s",outDir.Data(),fileName.Data(),format.Data());  
      Canv_report1->SaveAs(figsave);
      figsave = Form("%s/AcQLOOK2_%s.%s",outDir.Data(),fileName.Data(),format.Data());            
      Canv_report2->SaveAs(figsave);
      figsave = Form("%s/AcQLOOK3_%s.%s",outDir.Data(),fileName.Data(),format.Data());            
      Canv_report3->SaveAs(figsave);
      figsave = Form("%s/AcQLOOK4_%s.%s",outDir.Data(),fileName.Data(),format.Data());            
      Canv_report4->SaveAs(figsave);
    }
    if(!fullversion)
    {
      figsave = Form("%s/AcQLOOK_%s.%s",outDir.Data(),fileName.Data(),format.Data());  
      Canv_report1->SaveAs(figsave);
    }

    //Delete variables
    //delete Canv_report1,Canv_report2,Canv_report3,Canv_report4;
    //delete t;
    //delete pd1,pd2,pd3,pd4,pd5,pd6,pd7,pd8,pd9,pd10,pd11,pd12;
    //delete linje;
    //delete leg_m,leg_e,leg1_m;

    //delete nmbhitpmtCAS,nmbhitpmtCAT,nmbhitpmtCARD;
    //delete counter1_m,counter2_m,counter3_m,counter4_m,counter5_m,counter6_m,counter7_m,counter8_m,counter9_m,counter10_m,counter11_m,counter12_m,counter13_m,counter14_m,counter15_m,counter16_m;
    //delete counter1_e,counter2_e,counter3_e,counter4_e,counter5_e,counter6_e,counter7_e,counter8_e,counter9_e,counter10_e,counter11_e,counter12_e,counter13_e,counter14_e,counter15_e,counter16_e;
    //delete shift1_m,shift2_m,shift3_m,shift4_m,shift5_m,shift6_m,shift7_m,shift8_m,shift9_m,shift10_m,shift11_m,shift12_m,shift13_m,shift14_m,shift15_m,shift16_m;
    //delete shift1_e,shift2_e,shift3_e,shift4_e,shift5_e,shift6_e,shift7_e,shift8_e,shift9_e,shift10_e,shift11_e,shift12_e,shift13_e,shift14_e,shift15_e,shift16_e;
    //delete head_m,head_e,hitmap_m,hitmap_e;
    //delete pmtstatus_m,pmtstatus_e;
    //delete trigg_m,trigg_e,timebtrigg_m,timebtrigg_e,dtrigg_m,dtrigg_e;
    //delete crc_m,headerr_m,crcerr_m,dsperr_m,regerr_m;
    //delete crc_e,headerr_e,crcerr_e,dsperr_e,regerr_e;
    //delete T_right_m,T_actel_m,T_dsp_m,T_left_m;
    //delete T_right_e,T_actel_e,T_dsp_e,T_left_e;
    //delete rootFile;
    //delete mtitel,etitel;

  return 0;

}

int main(int argc, char* argv[]){
    TString outDir     	= ".";
    TString format     	= "jpg";
    int from     	= 0;
    int to		= 0;
    int mode            = 0;
    
 if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  

  if (!strcmp(argv[1], "--help")){
        printf( "Usage: AcQLOOK FILE [OPTION] \n");
        printf( "\t --help           Print this help and exit \n");
        printf( "\t -outDir[path]    Path where to put the output [default ./] \n");
        printf( "\t -format[path]    Set the format for the output file [default  'jpg']\n");
        printf( "\t -from #          Set the starting event  [default 0]\n");
        printf( "\t -to #            Set the last event  [default 0]\n");
	printf( "\t -mode #          advanced (1) or dummy (0) mode [default 0]\n");
        exit(1);
  }

  if (!strcmp(argv[1], "-v")){
    printf("Version %.2f\n",VERSION);
    exit(1);
  }

  for (int i = 2; i < argc; i++){
    if (!strcmp(argv[i], "-outDir")){
        if (++i >= argc){
            printf( "-outDir needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } else {
            outDir = argv[i];
        }
    }

    if (!strcmp(argv[i], "-format")) {
    	if (++i >= argc){
            printf( "-format needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } else {
        	format = argv[i];
        	continue;
        }
    }
    
    if (!strcmp(argv[i], "-mode")) {
      if (++i >= argc){
        printf( "-mode needs arguments. \n");
        printf( "Try '--help' for more information. \n");
        exit(1);
      } else {
        mode = atoi(argv[i]);
        continue;
      }
    }


    if (!strcmp(argv[i], "-to")) {
    	if (++i >= argc){
            printf( "-to needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } 
        if (isdigit(*argv[i]) && (atoi(argv[i]) > 0)) {
            to = atoi(argv[i]);
        } else {
            cerr << "-to needs a integer value. \n";
            cout << "Try '--help' for more information. \n";
            exit(1);
        }
    }
    
    if (!strcmp(argv[i], "-from")) {
    	if (++i >= argc){
            printf( "-from needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } 
        if (isdigit(*argv[i]) && (atoi(argv[i]) > 0)) {
            to = atoi(argv[i]);
        } else {
            cerr << "-from needs a integer value. \n";
            cout << "Try '--help' for more information. \n";
            exit(1);
        }
    }
    
  }
    AcQLOOK(argv[1], from, to, outDir, format,mode);
}
