#include <Calib1_Ac1Event.h>
#include <Calib1_Ac2Event.h>
#include <Calib2_Ac1Event.h>
#include <Calib2_Ac2Event.h>  
#include <PscuHeader.h>
#include <EventHeader.h>

#include <fstream>

#include <TCanvas.h>
#include <TLatex.h>
#include <TLegend.h>
#include <TLine.h>
#include <TTree.h>
#include <TStyle.h>
#include <TObjString.h>

#include <yodaUtility.h>
#define DEBUG 0


using namespace std;

/*
* Anticounter calibration quicklook
* Plots calibration curves done with LEDs and the extra calibration with random triggers
*
* author  Petter Hofverberg
* version 1.0
*
*/


void AcCALIB(TString base, Int_t nCal1 = 0, TString outDir = "./", TString format = "ps"){
  Int_t    	tmpSize;
  ofstream 	outputFile;
  stringstream 	oss;
  
  pamela::Calib2_Ac1Event 	*ace1 		= 0;
  pamela::Calib2_Ac2Event 	*ace2 		= 0;
  pamela::EventHeader 		*eh 		= 0;
  pamela::PscuHeader 		*ph 		= 0;  
  TFile				*rootFile 	= new TFile(base);
  
  if (rootFile->IsZombie()) printf("The %s file does not exist", base.Data());
  TString fileName = ((TObjString*)base.Tokenize('\/')->Last())->GetString();
  TString filePath = base;
  filePath.ReplaceAll(fileName, "");
  fileName.ReplaceAll(".root", "");

  //Takes the tree of the header file
  TTree *tr = (TTree*)rootFile->Get("Calib2_Ac1");
  tr->AddFriend("Calib2_Ac2");

  tr->SetBranchAddress("Calib2_Ac1", &ace1);
  tr->SetBranchAddress("Calib2_Ac2", &ace2);
  tr->SetBranchAddress("Header", &eh);
  Long64_t nevents    = tr->GetEntries();

  //cout << "Events: " << nevents << endl;
  /******************Book histograms**********************************************/

  TString *mtitel = new TString[16];
  mtitel[0]="CARD 4";
  mtitel[1]="CAT 2";
  mtitel[2]="CAS 1";
  mtitel[3]="NC";
  mtitel[4]="CARD 2";
  mtitel[5]="CAT 4";
  mtitel[6]="CAS 4";
  mtitel[7]="NC";
  mtitel[8]="CARD 3";
  mtitel[9]="CAT 3";
  mtitel[10]="CAS 3";
  mtitel[11]="NC";
  mtitel[12]="CARD 1";
  mtitel[13]="CAT 1";
  mtitel[14]="CAS 2";
  mtitel[15]="NC";

  TString *etitel = new TString[16];
  etitel[0]="CARD 4";
  etitel[1]="CAT 2";
  etitel[2]="CAS 1";
  etitel[3]="NC";
  etitel[4]="CARD 2";
  etitel[5]="CAT 4";
  etitel[6]="CAS 4";
  etitel[7]="NC";
  etitel[8]="CARD 3";
  etitel[9]="CAT 3";
  etitel[10]="CAS 3";
  etitel[11]="NC";
  etitel[12]="CARD 1";
  etitel[13]="CAT 1";
  etitel[14]="CAS 2";
  etitel[15]="NC";
  
  TH1D *DAC1_m = new TH1D("DAC values after curve 1 MAIN","DAC values after curve 1 MAIN",16,0,16);
  DAC1_m->GetXaxis()->SetBinLabel(1,mtitel[0]);
  DAC1_m->GetXaxis()->SetBinLabel(2,mtitel[1]);
  DAC1_m->GetXaxis()->SetBinLabel(3,mtitel[2]);
  DAC1_m->GetXaxis()->SetBinLabel(4,mtitel[3]);
  DAC1_m->GetXaxis()->SetBinLabel(5,mtitel[4]);
  DAC1_m->GetXaxis()->SetBinLabel(6,mtitel[5]);
  DAC1_m->GetXaxis()->SetBinLabel(7,mtitel[6]);
  DAC1_m->GetXaxis()->SetBinLabel(8,mtitel[7]);
  DAC1_m->GetXaxis()->SetBinLabel(9,mtitel[8]);
  DAC1_m->GetXaxis()->SetBinLabel(10,mtitel[9]);
  DAC1_m->GetXaxis()->SetBinLabel(11,mtitel[10]);
  DAC1_m->GetXaxis()->SetBinLabel(12,mtitel[11]);
  DAC1_m->GetXaxis()->SetBinLabel(13,mtitel[12]);
  DAC1_m->GetXaxis()->SetBinLabel(14,mtitel[13]);
  DAC1_m->GetXaxis()->SetBinLabel(15,mtitel[14]);
  DAC1_m->GetXaxis()->SetBinLabel(16,mtitel[15]);
  DAC1_m->GetYaxis()->SetTitle("Steps");

  TH1D *DAC2_m = new TH1D("DAC values after curve 2 MAIN","DAC values after curve 2 MAIN",16,0,16);
  DAC2_m->GetXaxis()->SetBinLabel(1,mtitel[0]);
  DAC2_m->GetXaxis()->SetBinLabel(2,mtitel[1]);
  DAC2_m->GetXaxis()->SetBinLabel(3,mtitel[2]);
  DAC2_m->GetXaxis()->SetBinLabel(4,mtitel[3]);
  DAC2_m->GetXaxis()->SetBinLabel(5,mtitel[4]);
  DAC2_m->GetXaxis()->SetBinLabel(6,mtitel[5]);
  DAC2_m->GetXaxis()->SetBinLabel(7,mtitel[6]);
  DAC2_m->GetXaxis()->SetBinLabel(8,mtitel[7]);
  DAC2_m->GetXaxis()->SetBinLabel(9,mtitel[8]);
  DAC2_m->GetXaxis()->SetBinLabel(10,mtitel[9]);
  DAC2_m->GetXaxis()->SetBinLabel(11,mtitel[10]);
  DAC2_m->GetXaxis()->SetBinLabel(12,mtitel[11]);
  DAC2_m->GetXaxis()->SetBinLabel(13,mtitel[12]);
  DAC2_m->GetXaxis()->SetBinLabel(14,mtitel[13]);
  DAC2_m->GetXaxis()->SetBinLabel(15,mtitel[14]);
  DAC2_m->GetXaxis()->SetBinLabel(16,mtitel[15]);
  DAC2_m->GetYaxis()->SetTitle("Steps");

  TH1D *DAC1_e = new TH1D("DAC values after curve 1 EXTRA","DAC values after curve 1 EXTRA",16,0,16);
  DAC1_e->GetXaxis()->SetBinLabel(1,mtitel[0]);
  DAC1_e->GetXaxis()->SetBinLabel(2,mtitel[1]);
  DAC1_e->GetXaxis()->SetBinLabel(3,mtitel[2]);
  DAC1_e->GetXaxis()->SetBinLabel(4,mtitel[3]);
  DAC1_e->GetXaxis()->SetBinLabel(5,mtitel[4]);
  DAC1_e->GetXaxis()->SetBinLabel(6,mtitel[5]);
  DAC1_e->GetXaxis()->SetBinLabel(7,mtitel[6]);
  DAC1_e->GetXaxis()->SetBinLabel(8,mtitel[7]);
  DAC1_e->GetXaxis()->SetBinLabel(9,mtitel[8]);
  DAC1_e->GetXaxis()->SetBinLabel(10,mtitel[9]);
  DAC1_e->GetXaxis()->SetBinLabel(11,mtitel[10]);
  DAC1_e->GetXaxis()->SetBinLabel(12,mtitel[11]);
  DAC1_e->GetXaxis()->SetBinLabel(13,mtitel[12]);
  DAC1_e->GetXaxis()->SetBinLabel(14,mtitel[13]);
  DAC1_e->GetXaxis()->SetBinLabel(15,mtitel[14]);
  DAC1_e->GetXaxis()->SetBinLabel(16,mtitel[15]);
  DAC1_e->GetYaxis()->SetTitle("Steps");

  TH1D *DAC2_e = new TH1D("DAC values after curve 2 EXTRA","DAC values after curve 2 EXTRA",16,0,16);
  DAC2_e->GetXaxis()->SetBinLabel(1,mtitel[0]);
  DAC2_e->GetXaxis()->SetBinLabel(2,mtitel[1]);
  DAC2_e->GetXaxis()->SetBinLabel(3,mtitel[2]);
  DAC2_e->GetXaxis()->SetBinLabel(4,mtitel[3]);
  DAC2_e->GetXaxis()->SetBinLabel(5,mtitel[4]);
  DAC2_e->GetXaxis()->SetBinLabel(6,mtitel[5]);
  DAC2_e->GetXaxis()->SetBinLabel(7,mtitel[6]);
  DAC2_e->GetXaxis()->SetBinLabel(8,mtitel[7]);
  DAC2_e->GetXaxis()->SetBinLabel(9,mtitel[8]);
  DAC2_e->GetXaxis()->SetBinLabel(10,mtitel[9]);
  DAC2_e->GetXaxis()->SetBinLabel(11,mtitel[10]);
  DAC2_e->GetXaxis()->SetBinLabel(12,mtitel[11]);
  DAC2_e->GetXaxis()->SetBinLabel(13,mtitel[12]);
  DAC2_e->GetXaxis()->SetBinLabel(14,mtitel[13]);
  DAC2_e->GetXaxis()->SetBinLabel(15,mtitel[14]);
  DAC2_e->GetXaxis()->SetBinLabel(16,mtitel[15]);
  DAC2_e->GetYaxis()->SetTitle("Steps");

  TH1D *DAC1_m2 = new TH1D("DAC values after curve 1 MAIN 2","DAC values after curve 1 MAIN 2",16,0,16);
  TH1D *DAC2_m2 = new TH1D("DAC values after curve 2 MAIN 2","DAC values after curve 2 MAIN 2",16,0,16);
  TH1D *DAC1_e2 = new TH1D("DAC values after curve 1 EXTRA 2","DAC values after curve 1 EXTRA 2",16,0,16);
  TH1D *DAC2_e2 = new TH1D("DAC values after curve 2 EXTRA 2","DAC values after curve 2 EXTRA 2",16,0,16);

  TH1D *Calo_trigg_m  = new TH1D("Calo_trigg_hits_m","Hits in each channel at Calorimeter triggers MAIN",17,0.,17.);
  Calo_trigg_m->GetXaxis()->SetBinLabel(1,"#triggers");
  Calo_trigg_m->GetXaxis()->SetBinLabel(2,mtitel[0]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(3,mtitel[1]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(4,mtitel[2]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(5,mtitel[3]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(6,mtitel[4]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(7,mtitel[5]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(8,mtitel[6]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(9,mtitel[7]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(10,mtitel[8]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(11,mtitel[9]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(12,mtitel[10]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(13,mtitel[11]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(14,mtitel[12]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(15,mtitel[13]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(16,mtitel[14]);
  Calo_trigg_m->GetXaxis()->SetBinLabel(17,mtitel[15]);
  Calo_trigg_m->GetYaxis()->SetTitle("Hits");
  

  TH1D *Calo_trigg_e  = new TH1D("Calo_trigg_hits_e","Hits in each channel at Calorimeter triggers EXTRA",17,0.,17.);
  Calo_trigg_e->GetXaxis()->SetBinLabel(1,"#triggers");
  Calo_trigg_e->GetXaxis()->SetBinLabel(2,etitel[0]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(3,etitel[1]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(4,etitel[2]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(5,etitel[3]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(6,etitel[4]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(7,etitel[5]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(8,etitel[6]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(9,etitel[7]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(10,etitel[8]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(11,etitel[9]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(12,etitel[10]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(13,etitel[11]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(14,etitel[12]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(15,etitel[13]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(16,etitel[14]);
  Calo_trigg_e->GetXaxis()->SetBinLabel(17,etitel[15]);
  Calo_trigg_e->GetYaxis()->SetTitle("Hits");

  TH1D *Calo_trigg_m2  = new TH1D("Calo_trigg_hits_m2","Hits in each channel at Calorimeter triggers MAIN",17,0.,17.);
  Calo_trigg_m2->GetXaxis()->SetTitle("Channel");
  Calo_trigg_m2->GetYaxis()->SetTitle("Hits");
  
  TH1D *Calo_trigg_e2  = new TH1D("Calo_trigg_hits_e2","Hits in each channel at Calorimeter triggers EXTRA",17,0.,17.);
  Calo_trigg_e2->GetXaxis()->SetTitle("Event");
  Calo_trigg_e2->GetYaxis()->SetTitle("Channel");
  
  //for(Int_t k = 0; k < nevents; k++){

   
  //l = new TLine(.056,.056,0.,6000.);
  //l.SetLineColor(2);
  //l->Draw();
  
  //create histograms
  //MAIN board
  TH1D *CAS1M = new TH1D("CAS1 (MAIN), PMT 124","CAS1 (MAIN), PMT124",256,0.,1.);
  CAS1M->GetXaxis()->SetTitle("DAC [V]");
  CAS1M->GetYaxis()->SetTitle("Events");
  TH1D *CAS2M = new TH1D("CAS2 (EXTRA), PMT 137","CAS2 (EXTRA), PMT137",256,0.,1.);
  CAS2M->GetXaxis()->SetTitle("DAC [V]");
  CAS2M->GetYaxis()->SetTitle("Events");
  TH1D *CAS3M = new TH1D("CAS3 (MAIN), PMT 109","CAS3 (MAIN), PMT109",256,0.,1.);
  CAS3M->GetXaxis()->SetTitle("DAC [V]");
  CAS3M->GetYaxis()->SetTitle("Events");
  TH1D *CAS4M = new TH1D("CAS4 (EXTRA), PMT 122","CAS4 (EXTRA), PMT122",256,0.,1.);
  CAS4M->GetXaxis()->SetTitle("DAC [V]");
  CAS4M->GetYaxis()->SetTitle("Events");

  TH1D *CARD1M = new TH1D("CARD1 (MAIN), PMT 065","CARD1 (MAIN), PMT065",256,0.,1.);
  CARD1M->GetXaxis()->SetTitle("DAC [V]");
  CARD1M->GetYaxis()->SetTitle("Events");
  TH1D *CARD2M = new TH1D("CARD2 (MAIN), PMT 059","CARD2 (MAIN), PMT059",256,0.,1.);
  CARD2M->GetXaxis()->SetTitle("DAC [V]");
  CARD2M->GetYaxis()->SetTitle("Events");
  TH1D *CARD3M = new TH1D("CARD3 (EXTRA), PMT 053","CARD3 (EXTRA), PMT053",256,0.,1.);
  CARD3M->GetXaxis()->SetTitle("DAC [V]");
  CARD3M->GetYaxis()->SetTitle("Events");
  TH1D *CARD4M = new TH1D("CARD4 (EXTRA), PMT 055","CARD4 (EXTRA), PMT055",256,0.,1.);
  CARD4M->GetXaxis()->SetTitle("DAC [V]");
  CARD4M->GetYaxis()->SetTitle("Events");

  TH1D *CAT1M = new TH1D("CAT1 (MAIN), PMT 134","CAT1 (MAIN), PMT134",256,0.,1.);
  CAT1M->GetXaxis()->SetTitle("DAC [V]");
  CAT1M->GetYaxis()->SetTitle("Events");
  TH1D *CAT2M = new TH1D("CAT2 (MAIN), PMT 136","CAT2 (MAIN), PMT136",256,0.,1.);
  CAT2M->GetXaxis()->SetTitle("DAC [V]");
  CAT2M->GetYaxis()->SetTitle("Events");
  TH1D *CAT3M = new TH1D("CAT3 (MAIN), PMT 101","CAT3 (MAIN), PMT101",256,0.,1.);
  CAT3M->GetXaxis()->SetTitle("DAC [V]");
  CAT3M->GetYaxis()->SetTitle("Events");
  TH1D *CAT4M = new TH1D("CAT4 (MAIN), PMT 132","CAT4 (MAIN), PMT132",256,0.,1.);
  CAT4M->GetXaxis()->SetTitle("DAC [V]");
  CAT4M->GetYaxis()->SetTitle("Events");

   //EXTRA board
  TH1D *CAS1E = new TH1D("CAS1 (MAIN), PMT 135","CAS1 (MAIN), PMT135",256,0.,1.);
  CAS1E->GetXaxis()->SetTitle("DAC [V]");
  CAS1E->GetYaxis()->SetTitle("Events");
  TH1D *CAS2E = new TH1D("CAS2 (EXTRA), PMT 105","CAS2 (EXTRA), PMT105",256,0.,1.);
  CAS2E->GetXaxis()->SetTitle("DAC [V]");
  CAS2E->GetYaxis()->SetTitle("Events");
  TH1D *CAS3E = new TH1D("CAS3 (MAIN), PMT 161","CAS3 (MAIN), PMT161",256,0.,1.);
  CAS3E->GetXaxis()->SetTitle("DAC [V]");
  CAS3E->GetYaxis()->SetTitle("Events");
  TH1D *CAS4E = new TH1D("CAS4 (EXTRA), PMT 160","CAS4 (EXTRA), PMT160",256,0.,1.);
  CAS4E->GetXaxis()->SetTitle("DAC [V]");
  CAS4E->GetYaxis()->SetTitle("Events");

  TH1D *CARD1E = new TH1D("CARD1 (MAIN), PMT 063","CARD1 (MAIN), PMT063",256,0.,1.);
  CARD1E->GetXaxis()->SetTitle("DAC [V]");
  CARD1E->GetYaxis()->SetTitle("Events");
  TH1D *CARD2E = new TH1D("CARD2 (MAIN), PMT 037","CARD2 (MAIN), PMT037",256,0.,1.);
  CARD2E->GetXaxis()->SetTitle("DAC [V]");
  CARD2E->GetYaxis()->SetTitle("Events");
  TH1D *CARD3E = new TH1D("CARD3 (EXTRA), PMT 062","CARD3 (EXTRA), PMT062",256,0.,1.);
  CARD3E->GetXaxis()->SetTitle("DAC [V]");
  CARD3E->GetYaxis()->SetTitle("Events");
  TH1D *CARD4E = new TH1D("CARD4 (EXTRA), PMT 057","CARD4 (EXTRA), PMT057",256,0.,1.);
  CARD4E->GetXaxis()->SetTitle("DAC [V]");
  CARD4E->GetYaxis()->SetTitle("Events");

  TH1D *CAT1E = new TH1D("CAT1 (MAIN), PMT 100","CAT1 (MAIN), PMT100",256,0.,1.);
  CAT1E->GetXaxis()->SetTitle("DAC [V]");
  CAT1E->GetYaxis()->SetTitle("Events");
  TH1D *CAT2E = new TH1D("CAT2 (MAIN), PMT 103","CAT2 (MAIN), PMT103",256,0.,1.);
  CAT2E->GetXaxis()->SetTitle("DAC [V]");
  CAT2E->GetYaxis()->SetTitle("Events");
  TH1D *CAT3E = new TH1D("CAT3 (MAIN), PMT 139","CAT3 (MAIN), PMT139",256,0.,1.);
  CAT3E->GetXaxis()->SetTitle("DAC [V]");
  CAT3E->GetYaxis()->SetTitle("Events");
  TH1D *CAT4E = new TH1D("CAT4 (MAIN), PMT 097","CAT4 (MAIN), PMT097",256,0.,1.);
  CAT4E->GetXaxis()->SetTitle("DAC [V]");
  CAT4E->GetYaxis()->SetTitle("Events");
  

  //Long64_t nevents    = tr->GetEntries();
  Double_t    mintime    = tr->GetMinimum("Pscu.OrbitalTime");
  Double_t    maxtime    = tr->GetMaximum("Pscu.OrbitalTime");
  Double_t    nbintime   = (maxtime-mintime)/1000.;

  /*******************Declarations*****************/

  const Int_t size = nevents;
  Double_t time;
  UShort_t cnt = 1;

  UShort_t Curve1[2][4096];
  UShort_t Curve2[2][4096];
  UShort_t hitmap_tr[2][16];
  UShort_t n_tr[2];
  UShort_t DAC1[2][8];
  UShort_t DAC2[2][8];
  
  /*************************************************/

  //Go through all events and update histograms and plots
  //for (Int_t i = 0; i < nevents; i++){
  //for (Int_t i = 0; i < 1; i++){
  Int_t i = 0;
  ph = eh->GetPscuHeader();
  time = ph->GetOrbitalTime();
  tr->GetEntry(nCal1);
  
  for(Int_t j = 0; j < 16; j++)
    hitmap_tr[0][j] = ace1->hitmap_tr[j];
  for(Int_t j = 0; j < 4096; j++){
    Curve1[0][j] = ace1->curve1[j];
    Curve2[0][j] = ace1->curve2[j];
  }
  for(Int_t j = 0;j<8;j++){
    DAC1[0][j] = ace1->DAC1[j];
    DAC2[0][j] = ace1->DAC1[j];
    DAC1[1][j] = ace2->DAC1[j];
    DAC2[1][j] = ace2->DAC1[j];
  }
  n_tr[0] = ace1->n_tr;
	    
  
  for(Int_t j = 0; j < 16; j++)
    hitmap_tr[1][j] = ace2->hitmap_tr[j];
  for(Int_t j = 0; j < 4096; j++){
    Curve1[1][j] = ace2->curve1[j];
    Curve2[1][j] = ace2->curve2[j];
  }
  n_tr[1] = ace2->n_tr;
  Calo_trigg_m->Fill(0.001,n_tr[0]);
  Calo_trigg_e->Fill(0.001,n_tr[1]);
  for(Int_t j = 0; j < 16; j++){
    Calo_trigg_m->Fill(j+1,hitmap_tr[0][j]);
    Calo_trigg_e->Fill(j+1,hitmap_tr[1][j]);
  }
  
  for(Int_t j = 0; j < 8; j++){
    DAC1_m->Fill(j*2,(DAC1[0][0] & 0x00FF));
    DAC1_m->Fill(j*2+1,(DAC1[0][0] & 0xFF00)/256);
    DAC2_m->Fill(j*2,(DAC2[0][0] & 0x00FF));
    DAC2_m->Fill(j*2+1,(DAC2[0][0] & 0xFF00)/256);
    DAC1_e->Fill(j*2,(DAC1[1][0] & 0x00FF));
    DAC1_e->Fill(j*2+1,(DAC1[1][0] & 0xFF00)/256);
    DAC2_e->Fill(j*2,(DAC2[1][0] & 0x00FF));
    DAC2_e->Fill(j*2+1,(DAC2[1][0] & 0xFF00)/256);
  }
  for(Int_t j=0;j<256;j++){
    CAS1M->Fill(j/256.,Curve1[0][j*16+2]);
    CAS2M->Fill(j/256.,Curve2[0][j*16+14]);
    CAS3M->Fill(j/256.,Curve1[0][j*16+10]);
    CAS4M->Fill(j/256.,Curve2[0][j*16+6]);
    
    CARD1M->Fill(j/256.,Curve1[0][j*16+12]);
    CARD2M->Fill(j/256.,Curve1[0][j*16+4]);
    CARD3M->Fill(j/256.,Curve2[0][j*16+8]);
    CARD4M->Fill(j/256.,Curve2[0][j*16]);
    
    CAT1M->Fill(j/256.,Curve1[0][j*16+13]);
    CAT2M->Fill(j/256.,Curve1[0][j*16+1]);
    CAT3M->Fill(j/256.,Curve1[0][j*16+9]);
    CAT4M->Fill(j/256.,Curve1[0][j*16+5]);
    
    CAS1E->Fill(j/256.,Curve1[1][j*16+2]);
    CAS2E->Fill(j/256.,Curve2[1][j*16+14]);
    CAS3E->Fill(j/256.,Curve1[1][j*16+10]);
    CAS4E->Fill(j/256.,Curve2[1][j*16+6]);
    
    CARD1E->Fill(j/256.,Curve1[1][j*16+12]);
    CARD2E->Fill(j/256.,Curve1[1][j*16+4]);
    CARD3E->Fill(j/256.,Curve2[1][j*16+8]);
    CARD4E->Fill(j/256.,Curve2[1][j*16]);
    
    CAT1E->Fill(j/256.,Curve1[1][j*16+13]);
    CAT2E->Fill(j/256.,Curve1[1][j*16+1]);
    CAT3E->Fill(j/256.,Curve1[1][j*16+9]);
    CAT4E->Fill(j/256.,Curve1[1][j*16+5]);
  }


     
    //Draw histograms
    gStyle->SetOptDate(0);     
    
    //report sheet 2
    TCanvas *Canv_report1 = new TCanvas("Report sheet 1", "Report sheet 1", 1280, 1024);
    Canv_report1->Range(0,0,100,100);
    
    char *namn;
    TLatex *t = new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextAlign(12);
    t->SetTextSize(0.035);
    namn="Calibration by the MAIN board";
    t->DrawLatex(35.,95.,namn);
    
    t->SetTextSize(0.015);
    //t->DrawLatex(75.,98.,mytsf->GetName());
    t->DrawLatex(75.,98.,base.Data());
    
    t->SetTextColor(1);
    t->SetTextSize(0.035);
    namn="CAS";
    t->DrawLatex(3.,94.,namn);
    namn="CARD";
    t->DrawLatex(3.,65.,namn);
    namn="CAT";
    t->DrawLatex(3.,34.,namn);
    TPad *pd1,*pd2,*pd3,*pd4,*pd5,*pd6,*pd7,*pd8,*pd9,*pd10,*pd11,*pd12;
    pd1 = new TPad("pd1","This is pad1",0.,0.68,0.25,.92);
    pd2 = new TPad("pd2","This is pad2",0.25,0.68,0.5,.92);
    pd3 = new TPad("pd3","This is pad3",0.5,0.68,0.75,.92);
    pd4 = new TPad("pd4","This is pad4",0.75,0.68,1.0,.92);
    pd5 = new TPad("pd5","This is pad5",0.,0.37,0.25,0.62);
    pd6 = new TPad("pd6","This is pad6",0.25,0.37,.5,0.62);
    pd7 = new TPad("pd7","This is pad7",0.5,0.37,0.75,0.62);
    pd8 = new TPad("pd8","This is pad8",0.75,0.37,1.0,0.62);
    pd9 = new TPad("pd9","This is pad9",0.0,0.06,0.25,0.31);
    pd10 = new TPad("pd10","This is pad10",0.25,0.06,.5,0.31);
    pd11 = new TPad("pd11","This is pad11",0.5,0.06,0.75,0.31);
    pd12 = new TPad("pd12","This is pad12",0.75,0.06,1.,0.31);
    Canv_report1->cd();
    pd1->Range(0,0,100,100);
    pd2->Range(0,0,100,100);
    pd3->Range(0,0,100,100);
    pd4->Range(0,0,100,100);       
    pd5->Range(0,0,100,100);
    pd6->Range(0,0,100,100);
    pd7->Range(0,0,100,100);
    pd8->Range(0,0,100,100); 
    pd9->Range(0,0,100,100);
    pd10->Range(0,0,100,100);
    pd11->Range(0,0,100,100);
    pd12->Range(0,0,100,100); 
    //pd13->Range(0,0,100,100);
    //pd14->Range(0,0,100,100);
    //pd15->Range(0,0,100,100);
    //pd16->Range(0,0,100,100); 
    pd1->Draw();
    pd2->Draw();
    pd3->Draw();
    pd4->Draw();
    pd5->Draw();
    pd6->Draw();
    pd7->Draw();
    pd8->Draw();
    pd9->Draw();
    pd10->Draw();
    pd11->Draw();
    pd12->Draw();
    
    pd1->cd();
    CAS1M->SetLineColor(1);
    CAS1M->Draw();
    //CAS1E->SetLineColor(2);
    //CAS1E->Draw("SAME");
    pd2->cd();
    CAS2M->SetLineColor(1);
    CAS2M->Draw();
    //CAS2E->SetLineColor(2);
    //CAS2E->Draw("SAME");
    pd3->cd();
    CAS3M->SetLineColor(1);
    CAS3M->Draw();
    //CAS3E->SetLineColor(2);
    //CAS3E->Draw("SAME");
    pd4->cd();
    CAS4M->SetLineColor(1);
    CAS4M->Draw();
    //CAS4E->SetLineColor(2);
    //CAS4E->Draw("SAME");

    pd5->cd();
    CARD1M->SetLineColor(1);
    CARD1M->Draw();
    //CARD1E->SetLineColor(2);
    //CARD1E->Draw("SAME");
    pd6->cd();
    CARD2M->SetLineColor(1);
    CARD2M->Draw();
    //CARD2E->SetLineColor(2);
    //CARD2E->Draw("SAME");
    pd7->cd();
    CARD3M->SetLineColor(1);
    CARD3M->Draw();
    //CARD3E->SetLineColor(2);
    //CARD3E->Draw("SAME");
    pd8->cd();
    CARD4M->SetLineColor(1);
    CARD4M->Draw();
    //CARD4E->SetLineColor(2);
    //CARD4E->Draw("SAME");
    
    pd9->cd();
    CAT1M->SetLineColor(1);
    CAT1M->Draw();
    //CAT1E->SetLineColor(2);
    //CAT1E->Draw("SAME");
    pd10->cd();
    CAT2M->SetLineColor(1);
    CAT2M->Draw();
    //CAT2E->SetLineColor(2);
    //CAT2E->Draw("SAME");
    pd11->cd();
    CAT3M->SetLineColor(1);
    CAT3M->Draw();
    //CAT3E->SetLineColor(2);
    //CAT3E->Draw("SAME");
    pd12->cd();
    CAT4M->SetLineColor(1);
    CAT4M->Draw();
    //CAT4E->SetLineColor(2);
    //CAT4E->Draw("SAME");


        
    TCanvas *Canv_report2 = new TCanvas("Report sheet 2", "Report sheet 2", 1280, 1024);
    Canv_report2->Range(0,0,100,100);
    
    /*tsf = (TSystemFile*)AcList->First();
    sprintf(error,"File: %s ",tsf->GetName());
    TLatex *t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextAlign(12);
    t->SetTextSize(0.015);
    t->DrawLatex(2.,99.,error);
    char *namn;
    TLatex *t2 = new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextAlign(12);
    t->SetTextSize(0.035);
    namn="CAS";
    t->DrawLatex(48.,94.,namn);
    namn="CAT";
    t->DrawLatex(48.,65.,namn);
    namn="CARD";
    t->DrawLatex(48.,34.,namn);
    */
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextAlign(12);
    t->SetTextSize(0.035);
    namn="Calibration by the EXTRA board";
    t->DrawLatex(35.,95.,namn);

    t->SetTextSize(0.015);
    t->DrawLatex(75.,98.,base.Data());
  
    t->SetTextColor(1);
    t->SetTextSize(0.035);

    namn="CAS";
    t->DrawLatex(3.,94.,namn);
    namn="CARD";
    t->DrawLatex(3.,65.,namn);
    namn="CAT";
    t->DrawLatex(3.,34.,namn);
  
    pd1 = new TPad("pd1","This is pad1",0.,0.68,0.25,.92);
    pd2 = new TPad("pd2","This is pad2",0.25,0.68,0.5,.92);
    pd3 = new TPad("pd3","This is pad3",0.5,0.68,0.75,.92);
    pd4 = new TPad("pd4","This is pad4",0.75,0.68,1.0,.92);
    pd5 = new TPad("pd5","This is pad5",0.,0.37,0.25,0.62);
    pd6 = new TPad("pd6","This is pad6",0.25,0.37,.5,0.62);
    pd7 = new TPad("pd7","This is pad7",0.5,0.37,0.75,0.62);
    pd8 = new TPad("pd8","This is pad8",0.75,0.37,1.0,0.62);
    pd9 = new TPad("pd9","This is pad9",0.0,0.06,0.25,0.31);
    pd10 = new TPad("pd10","This is pad10",0.25,0.06,.5,0.31);
    pd11 = new TPad("pd11","This is pad11",0.5,0.06,0.75,0.31);
    pd12 = new TPad("pd12","This is pad12",0.75,0.06,1.,0.31);
    Canv_report2->cd();
    pd1->Range(0,0,100,100);
    pd2->Range(0,0,100,100);
    pd3->Range(0,0,100,100);
    pd4->Range(0,0,100,100);       
    pd5->Range(0,0,100,100);
    pd6->Range(0,0,100,100);
    pd7->Range(0,0,100,100);
    pd8->Range(0,0,100,100); 
    pd9->Range(0,0,100,100);
    pd10->Range(0,0,100,100);
    pd11->Range(0,0,100,100);
    pd12->Range(0,0,100,100); 
    //pd13->Range(0,0,100,100);
    //pd14->Range(0,0,100,100);
    //pd15->Range(0,0,100,100);
    //pd16->Range(0,0,100,100); 
    pd1->Draw();
    pd2->Draw();
    pd3->Draw();
    pd4->Draw();
    pd5->Draw();
    pd6->Draw();
    pd7->Draw();
    pd8->Draw();
    pd9->Draw();
    pd10->Draw();
    pd11->Draw();
    pd12->Draw();
    
    pd1->cd();
    //CAS1M->SetLineColor(1);
    //CAS1M->Draw();
    CAS1E->SetLineColor(1);
    CAS1E->Draw();
    pd2->cd();
    //CAS2M->SetLineColor(1);
    //CAS2M->Draw();
    CAS2E->SetLineColor(1);
    CAS2E->Draw();
    pd3->cd();
    //CAS3M->SetLineColor(1);
    //CAS3M->Draw();
    CAS3E->SetLineColor(1);
    CAS3E->Draw();
    pd4->cd();
    //CAS4M->SetLineColor(1);
    //CAS4M->Draw();
    CAS4E->SetLineColor(1);
    CAS4E->Draw();

    pd5->cd();
    //CARD1M->SetLineColor(1);
    //CARD1M->Draw();
    CARD1E->SetLineColor(1);
    CARD1E->Draw();
    pd6->cd();
    //CARD2M->SetLineColor(1);
    //CARD2M->Draw();
    CARD2E->SetLineColor(1);
    CARD2E->Draw();
    pd7->cd();
    //CARD3M->SetLineColor(1);
    //CARD3M->Draw();
    CARD3E->SetLineColor(1);
    CARD3E->Draw();
    pd8->cd();
    //CARD4M->SetLineColor(1);
    //CARD4M->Draw();
    CARD4E->SetLineColor(1);
    CARD4E->Draw();
    
    pd9->cd();
    //CAT1M->SetLineColor(1);
    //CAT1M->Draw();
    CAT1E->SetLineColor(1);
    CAT1E->Draw();
    pd10->cd();
    //CAT2M->SetLineColor(1);
    //CAT2M->Draw();
    CAT2E->SetLineColor(1);
    CAT2E->Draw();
    pd11->cd();
    //CAT3M->SetLineColor(1);
    //CAT3M->Draw();
    CAT3E->SetLineColor(1);
    CAT3E->Draw();
    pd12->cd();
    //CAT4M->SetLineColor(1);
    //CAT4M->Draw();
    CAT4E->SetLineColor(1);
    CAT4E->Draw();

    TCanvas *Canv_report3 = new TCanvas("Report sheet 3","Report sheet 3", 1280, 1024); 
    Canv_report3->Range(0,0,100,100);
    
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextAlign(12);
    t->SetTextSize(0.035);
    namn="AC Calibration Quick Look";
    t->DrawLatex(35.,95.,namn);

    t->SetTextSize(0.015);
    t->SetTextColor(1);
    t->DrawLatex(75.,98.,base.Data());

    t->SetTextSize(0.035);

    pd1 = new TPad("pd1","This is pad1",0.52,0.51,0.98,0.92,17);
    pd1->SetLogy(1);
    pd2 = new TPad("pd2","This is pad2",0.52,0.03,0.98,0.48,17);
    pd2->SetLogy(1);
    pd3 = new TPad("pd3","This is pad3",0.02,0.73,0.48,0.92,17);
    pd4 = new TPad("pd4","This is pad4",0.02,0.50,0.48,0.69,17);
    pd5 = new TPad("pd5","This is pad5",0.02,0.27,0.48,0.46,17);
    pd6 = new TPad("pd6","This is pad6",0.02,0.04,0.48,0.23,17);
    Canv_report3->cd();
    pd1->Range(0,0,100,100);
    pd2->Range(0,0,100,100);
    pd3->Range(0,0,100,100);
    pd4->Range(0,0,100,100); 
    pd5->Range(0,0,100,100);
    pd6->Range(0,0,100,100); 
    pd1->Draw();
    pd2->Draw();
    pd3->Draw();
    pd4->Draw();
    pd5->Draw();
    pd6->Draw();

    pd1->cd();
    Calo_trigg_m->SetLineColor(1);
    Calo_trigg_m->SetStats(kFALSE);
    Calo_trigg_m->Draw();
    
    //pd2->cd(); 
    //Calo_trigg_e->Draw();
    pd2->cd();
    Calo_trigg_e->SetLineColor(1);
    Calo_trigg_e->SetStats(kFALSE);
    Calo_trigg_e->Draw();
    

    pd3->cd();
    DAC1_m->SetMinimum(0);
    DAC1_m->SetMaximum(260);
    DAC1_m->SetStats(kFALSE);
    DAC1_m->Draw();

    pd4->cd();
    DAC2_m->SetMinimum(0);
    DAC2_m->SetMaximum(260);
    DAC2_m->SetStats(kFALSE);
    DAC2_m->Draw();

    pd5->cd();
    DAC1_e->SetMinimum(0);
    DAC1_e->SetMaximum(260);
    DAC1_e->SetStats(kFALSE);
    DAC1_e->Draw();

    pd6->cd();
    DAC2_e->SetMinimum(0);
    DAC2_e->SetMaximum(260);
    DAC2_e->SetStats(kFALSE);
    DAC2_e->Draw();

    Canv_report3->Update();
    
    const string fil = (const char*)base;
    Int_t posiz = fil.find("dw_");
    if ( posiz == -1 ) posiz = fil.find("DW_");
    Int_t posiz2 = posiz+13;
    TString file2;
    //stringcopy(file2,base,posiz,posiz2);
    //
    const char *figrec = file2;
  
    //string *outdir = new string(outDir);
    //string *Format = new string(format);
    char *figsave = 0;
    figsave = Form("%s/AcCALIB1_%s.%s",outDir.Data(),figrec,format.Data());
    Canv_report1->SaveAs(figsave);
    figsave = Form("%s/AcCALIB2_%s.%s",outDir.Data(),figrec,format.Data());            
    Canv_report2->SaveAs(figsave);
    figsave = Form("%s/AcCALIB3_%s.%s",outDir.Data(),figrec,format.Data());            
    Canv_report3->SaveAs(figsave);
   



    
    /*
    TString *file[17];
    file = "dw_000000_000.dat";
    file = getFilename(base);    
    char *figrec = 0;
    figrec = "dw_000000_000";
    memcpy(figrec, file, 13);                    
    char *outdir;
    outdir = outDir;
    char *figsave = 0;
    figsave = Form("%sAcCALIB1_%s.eps",outdir,figrec);            
    Canv_report1->SaveAs(figsave);
    figsave = Form("%sAcCALIB2_%s.eps",outdir,figrec);            
    Canv_report2->SaveAs(figsave);
    figsave = Form("%sAcCALIB3_%s.eps",outdir,figrec);            
    Canv_report3->SaveAs(figsave);
    */

}


TString* getFilename(TString filename){
  TString *errS = new TString("err");
  string *file = new string(filename); //kan bugga, var char *file f�ut 
  TString *file3 = new TString("dw_000000_000.dat"); //13
  //file3 = "dw_000000_000.dat";
    string *fil = new string(filename);
    Int_t posiz = fil->find("dw_");
    if ( posiz == -1 ) posiz = fil->find("DW_");
    if ( posiz == -1 ) return errS;
    memcpy(file3, file+posiz, 13);
    return file3;
};

void PrintFigure(TString *file[17], TString outDir, TString figty, TCanvas& figure) {
    char *figrec = 0;
    figrec = "dw_000000_000";
    memcpy(figrec, file, 13);		    
    //char *ty;
    string *ty = new string(figty);
    //char *outdir;
    string *outdir = new string(outDir);
    char *figsave = 0;
    figsave = Form("%s/%s_%s.gif",outdir->c_str(),ty->c_str(),figrec);	    
    figure.SaveAs(figsave);
    return;
}


void stringcopy(TString& s1, const TString& s2, Int_t from=0, Int_t to=0){    
    if ( to == 0 ){
	Int_t t2length = s2.Length();
	s1 = "";
	to = t2length;
    };
    for (Int_t i = from; i<to; i++){
	s1.Append(s2[i],1);
    };
}


int main(int argc, char* argv[]){
    TString outDir     	= ".";
    TString format     	= "jpg";
    int nCal     	= 0;

    
 if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  

  if (!strcmp(argv[1], "--help")){
        printf( "Usage: AcCalib FILE [OPTION] \n");
        printf( "\t --help           Print this help and exit \n");
        printf( "\t -outDir[path]    Path where to put the output [default ./] \n");
        printf( "\t -format[path]    Set the format for the output file [default  'jpg']\n");
        printf( "\t -from #          Set the starting event  [default 0]\n");
        printf( "\t -to #            Set the last event  [default 0]\n");
        exit(1);
  }

  for (int i = 2; i < argc; i++){
    if (!strcmp(argv[i], "-outDir")){
        if (++i >= argc){
            printf( "-outDir needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } else {
            outDir = argv[i];
        }
    }

    if (!strcmp(argv[i], "-format")) {
    	if (++i >= argc){
            printf( "-format needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } else {
        	format = argv[i];
        	continue;
        }
    }
    
    if (!strcmp(argv[i], "-nCal1")) {
    	if (++i >= argc){
            printf( "-nCal1 needs arguments. \n");
            printf( "Try '--help' for more information. \n");
            exit(1);
        } 
        if (isdigit(*argv[i]) && (atoi(argv[i]) > 0)) {
            nCal = atoi(argv[i]);
        } else {
            cerr << "-nCal1 needs a integer value. \n";
            cout << "Try '--help' for more information. \n";
            exit(1);
        }
    }
    
  }
    AcCALIB(argv[1], nCal, outDir, format);
}
