*************************************************************************
*     
*     Subroutine read_B.f
*     
*     it calls the subroutines which read the magnetic field maps for
*     the PAMELA spectrometer
*     
*     needs:
*     - ./read_B_inner.f inner map reading subroutine
*     - ./read_B_outer.f outer map reading subroutine
*     
*     to be called before ./inter_B.f (interpolation subroutine)
*     
*************************************************************************

      function readb2maps(idata_dir)
c      subroutine read_B(idata_dir)
      include './common_B_inner.for'
      include './common_B_outer.for'
      CHARACTER*250 idata_dir
      integer lastnb2
c      integer lung
      REAL PFX(3),FX,DFX     !Bx field component coordinates in m, value and error in T
      REAL PFY(3),FY,DFY
      REAL PFZ(3),FZ,DFZ
      INTEGER INDEX(3)          !point index
      COMMON /ntplvars/ INDEX,PFX,FX,DFX,PFY,FY,DFY,PFZ,FZ,DFZ      
c      save/ntplvars/
c
c      parameter(NWPAWC=8500000)
      integer nwpawc
      parameter(NWPAWC=200000)
      common/pawc/hmem(NWPAWC)
c      save/pawc/
      common/quest/iquest(100)
c      save/quest/
c
c      IQUEST(10) = 65000        
      call hlimit(nwpawc)
c     
      readb2maps=0
      lastnb2 = length(idata_dir)+1
c     call the subroutine which reads the maps of the measurements taken
c     inside the magnetic cavity
      call read_B_inner(idata_dir(1:lastnb2))

c     call the subroutine which reads the maps of the measurements taken
c     outside the magnetic cavity
      call read_B_outer(idata_dir(1:lastnb2))        

c      call resizepawc
c
      return
      end

      include './read_B_inner.for'
      include './read_B_outer.for' 

      
      integer function length(str)
c     return the string length without the blanks characters

      implicit integer (k-l)
      character *(*) str    
      
      lmax=len(str)      
       
c     search the last non blank character
      do i = 1, lmax
         if( str(i:i).eq.'.' )then
            length=i
            return
         endif
      enddo

      length=lmax

      return
      end     
      

c      function resizepawc
c      parameter(NWPAWC=80)
c      common/pawc/hmem(NWPAWC)
c      common/quest/iquest(1)

c
c      call hlimit(nwpawc)
c      return
c      end
