//-------------------------------------------------------------------------------------------------------------------------------------------------------
//
//   EventViewer.c      version 8.00  (2005-11-24)
//
//   Shows PAMELA events - Emiliano Mocchiutti
//
//-------------------------------------------------------------------------------------------------------------------------------------------------------
//
//   The only input needed is the path to the directory ("filename") created by YODA for the data file you want to analyze.
//
//   Standard use:
//
//   root[0] .L ShowEvent.c
//   root[1] ShowEvent("/home/dati/filesFromYoda/DW_050112_00600/");
//
//   For further informations use:
//
//   root[3] ShowEvent();
//
//   or
//
//   root[4] ShowEvent("help");
//  
//-------------------------------------------------------------------------------------------------------------------------------------------------------
//
//   Changelog:
//
//   7.03 - 8.00 (2005-11-24): many changes to compile the macro. The code is still very redundant and heavy but some bugs were fixed and now it should be more stable.
//                             Do not require anymore the AcFunctions.h header, a clone has been written (aclev1class.h).
//
//   7.02 - 7.03 (2005-10-14): load library containing CalorimeterLevel1 class definition.
//
//   7.01 - 7.02 (2005-10-12): changed neutron detector color scale to a more realistic one.
//
//   7.00 - 7.01 (2005-10-10): simplyfied input (less parameters), added support for TOF level1 data.
//
//   6.05 - 7.00 (2005-09-21): changes to work with tracker software version 2.00.
//
//   6.04 - 6.05 (2005-08-03): changes to fix bugs related to 64 bit arch.
//
//   6.03 - 6.04 (2005-07-22): small bug in signal visualization in TOF S11 fixed.
//
//   6.02 - 6.03 (2005-07-19): use clone routines of yodaUtility.c that can be found in CaloFunctions.h and don't load anymore yodaUtility.c
//
//   6.01 - 6.02 (2005-07-12): small changes due to correction for the compilation of CaloFunctions.h.
//
//   6.00 - 6.01 (2005-07-07): AC, now it reads LEVEL1 output (hit are shown with different colour if they are not in time with trigger). Some AC related small bugs fixed.
//                             Added synchronization routines between "YODA" output and tracker output (I am assuming that everything comes out from YODA is synchronized).
//
//   5.21 - 6.00 (2005-07-06): Now it can read tracker rootples generated by the GroundDataConvert software. Some minor bugs related to tracker visualization fixed.
//                             Notice that tracker data are not synchronized yet to the "YODA" data.
//
//   5.20 - 5.21 (2005-06-29): Added some options in the interactive menu (B/W toggling, track in S4/ND toggling). Created a new include file with structures for the
//                             event viewer, changed the WhatToDO routine, now renamed in WhatToDoEV. Bug: cannot run program twice when showing track without quitting 
//                             ROOT, fixed. Changed "CALO" to "Calorimeter" and "TRK" to "Tracker" in verbose infos mode. Bug: don't show trigger configuration on the text
//                             output when no infos are shown on the figure, fixed. Increased the width of the track line.
//
//   5.19 - 5.20 (2005-06-28): Bug: S4 z dimension is wrong! corrected. New filename and changes needed to upgrade to the new software architecture.
//
//   5.18 - 5.19 (2005-06-16): Bug: S4/PULSER flag is not always correct since sometimes the trigger is given by S4 but the flag is not set. Fixed (?) with a 
//                             workaround, to be checked that is the best we can do.
//
//   5.17 - 5.18 (2005-06-14): Added black and white visualization (use input variable "BW" as flag). Wrong position of S4 in level0 visualization, fixed. Saved PS files do not
//                             contain the TOF information from TDC position, fixed.
//
//   5.16 - 5.17 (2005-06-08): S4 level0 and level1 splitted. Level0 shows the patterntrig variable (NB: NOT ALWAYS CORRECT!!), Level1 shows calibrated info from S4.
//
//   5.15 - 5.16 (2005-06-07): Unload libraries when exiting and change back to the starting directory. Check if the file is older than 050515_007.
//
//   5.14 - 5.15 (2005-05-17): Crashes if ADC to MIP calorimeter conversion value is zero, fixed.
//
//   5.13 - 5.14 (2005-05-13): Force level0 visualization also for the calorimeter.
//
//   5.12 - 5.13 (2005-05-10): Calorimeter Z dimension is WRONG!!! fixed.
//
//   5.11 - 5.12 (2005-05-02): OBT is On Board Time and not Orbital Time!
//
//   5.10 - 5.11 (2005-04-19): Bug fixed in the new subroutine ShowTOFL1 and changed to the old behaviour the calorimeter calibration search (it could took long time
//                             to find a good calibration with the new method expecially in the case of a directory with a single file).
//
//   5.09 - 5.10 (2005-04-18): Added ShowTOFL1 subroutine to show TOF informations instead of trigger infos. Still it possible to see trigger infos forcing level0 data.
//
//   5.08 - 5.09 (2005-04-11): Changes in the CaloShowL0 subroutine: do not calibrate more than once if there is a jump in OBT.
//
//   5.07 - 5.08 (2005-04-07): Changes in the CaloShowL0 subroutine. Changed tree name of level1 and adc2mip calorimeter data.
//
//   5.06 - 5.07 (2005-04-05): Bug in the rigidity and chi2 report in the figure, fixed.
//
//   5.05 - 5.06 (2005-03-30): Small changes in the whattodo behaviour.
//
//   5.04 - 5.05 (2005-03-23): Introduced the input variable FORCELEV to force the data level to load. For now it is possible only to force level0 data
//                             reading of calorimeter and tracker. News: the selection file name now can be anyone and must be used as input if you want
//                             to select events. Hence the "selection" integer input has become the string "selfile".
//
//   5.03 - 5.04 (2005-03-18): Small changes in the print out.
//
//   5.02 - 5.03 (2005-03-17): Cannot go backward in selection mode, fixed. Change in ShowS4 the S4 calibration parameter.
//                             New: now it is possible to jump to a certain event number and not only to progressive number.
//
//   5.01 - 5.02 (2005-03-16): Pulser information is now printed in the INFOS and S4 MIP signal (first order calibration) is represented with colours 
//                             (same palette as for calorimeter).
//
//   5.00 - 5.01 (2005-03-14): Information text size increased.
//
//   4.11 - 5.00 (2005-03-11): Track visualization offset bug fixed. Reload magnetic field maps if back to the first event, fixed.
//                             Added some comments in the code. Added level2 tracker data to filter.c.
//
//   4.10 - 4.11 (2005-03-10): Tracker LEVEL1 visualization implemented. Changed the tracker directory from "magnet" to "tracker". Show LEVEL1 information 
//                             even if LEVEL2 data are not present.
//
//   4.09 - 4.10 (2005-03-08): Read the calorimeter calibration file if trying to generate level 1 data.
//
//   4.08 - 4.09 (2005-03-03): S4 always shown as hit, fixed.
//
//   4.07 - 4.08 (2005-02-25): In filter mode added a progress viewer. CAS1 plane view was filled with full red colour instead of pinkish colour, fixed.
//
//   4.06 - 4.07 (2005-02-25): crashes when exiting on empty files. Fixed.
//
//   4.05 - 4.06 (2005-02-24): Changed order of input variables.
//
//   4.04 - 4.05 (2005-02-24): Changed variable definition from C/C++ style to ROOT style (int->Int_t).
//
//   4.03 - 4.04 (2005-02-23): Added the "selection" input variable. If set greater than zero the program will look for
//                             events satisfying the condition in the filter.c program. Notice that running in this configuration
//                             will not let you to go backward with events.
//
//   4.02 - 4.03 (2005-02-23): Sometimes the calorimeter was repeating an event to infinity. Fixed.
//
//   4.01 - 4.02 (2005-02-22): ROOT 4.03/02 version bug fixed (calorimeter only). 
//
//   4.00 - 4.01 (2005-02-18): Calorimeter compress/full raw mode visualization didn't work. Fixed. Neutron detector data format changed, fixed accordingly.
//
//   3.04 - 4.00 (2005-02-14): Small changes in the calorimeter x/y view and in the tracker plane view geometries. 
//                             Added the track visualization code once you have tracker LEVEL2 data.
//
//   3.03 - 3.04 (2005-02-10): Show not only the YODA number (progressive number) but also the EVENT NUMBER from the packet header! 
//
//   3.02 - 3.03 (2005-02-08): TOF scintillators divided into A and B PMTs. Upper triangles are A PMT, lower triangles are B PMTs. S4 readout implemented:
//                             the information comes from the trigger board and the energy level is drawn out as LEVEL0 information. Some bugs in the 
//                             scintillators order fixed. Changed color of shadow hit in the tracker Y-view; added small black dot on tracker ladders to 
//                             indicate the detectors edges.
//
//   3.01 - 3.02 (2005-02-04): Tracker hit shown in the plane view. CAS shown in the plane view. Level0 TOF information shown in the scintillators.
//                             Bug for which it is not possible to see only the last event, fixed.
//
//   3.00 - 3.01 (2005-01-31): AC CARD view from above added. Printing bug fixed, now it calls for the WhatToDo routine in CaloFunctions.h.
//
//   2.01 - 3.00 (2005-01-21): Major changes in the program philosophy: now it will check first for higher order LEVEL data and it will use low level data
//                             only as last resurce.
//
//   2.00 - 2.01 (2005-01-18): AC cat changed, added PMTs, AC hits out of triggers are shown now in a different colour. Added "go backward" capability.
//
//   1.01 - 2.00 (2005-01-14): many changes, some cleanup of the code, detectors are in scale.
//
//   1.00 - 1.01 (2004-12-15): Include also yodaUtility.c .
//
#include <math.h>
#include <stdio.h>
//
#include <fstream>
#include <sstream>
#include <iostream>
#include <iomanip>
//
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TLine.h>
#include <TPolyLine.h>
#include <TChain.h>
#include <TApplication.h>
#include <TVirtualX.h>
#include <TGClient.h>
#include <TGWindow.h>
#include <TEllipse.h>
#include <TArrow.h>
#include <TStyle.h>
//
#include <trklev1struct.h>
//
#if !defined (__CINT__)				
#include <event/PamelaRun.h>
#include <event/physics/calorimeter/CalorimeterEvent.h>
#include <event/physics/trigger/TriggerEvent.h>
#include <event/physics/tof/TofEvent.h>
#include <event/physics/tracker/TrackerEvent.h>
#include <event/physics/anticounter/AnticounterEvent.h>
#include <event/physics/neutronDetector/NeutronEvent.h>
#include <event/physics/S4/S4Event.h>
#include <event/CalibCalPedEvent.h>
#include <event/CalibTrk1Event.h>
#include <event/CalibTrk2Event.h>
#include <caloclasses.h>
extern const char *pathtocalibration();
extern void creadB(const char []);
extern void projectlev1(Trklev1 &);
extern void ctrack(int, Double_t [], Double_t [], Double_t [], Double_t [], int &);
#endif
//
//
#include <CaloFunctions.h>
#include <eventviewer.h>
//
#include <ctrkstruct.h>
#include <ctrkinclude.h>
#include <ctofstruct.h>
#include <ctofinclude.h>
#include <aclev1class.h>
//

void unload1(){
#if defined (__CINT__)  
    char *pam_lib=gSystem->Getenv("PAM_LIB");
    stringstream libload1;
    libload1.str("");
    libload1 << pam_lib << "/libptlevel1_C";
    gSystem->Unload(libload1.str().c_str());
    char *pam_lib=gSystem->Getenv("PAM_LIB");
    stringstream libload1;
    libload1.str("");
    libload1 << pam_lib << "/libptlevel1";
    gSystem->Unload(libload1.str().c_str());    
#endif
}

void unload2(){
#if defined (__CINT__)  
	char *pam_lib=gSystem->Getenv("PAM_LIB");
	stringstream libload;
	libload.str("");
	libload << pam_lib << "/libreadb2maps_C";
	gSystem->Unload(libload.str().c_str());
	libload.str("");
	char *pam_lib=gSystem->Getenv("PAM_LIB");
	libload << pam_lib << "/libreadb2maps";
	gSystem->Unload(libload.str().c_str());
	libload.str("");
	char *pam_lib=gSystem->Getenv("PAM_LIB");
	libload << pam_lib << "/libtrack_C";
	gSystem->Unload(libload.str().c_str());
	stringstream libload;
	libload.str("");
	char *pam_lib=gSystem->Getenv("PAM_LIB");
	libload << pam_lib << "/libtrack";
	gSystem->Unload(libload.str().c_str());
#endif
}
//**********************************************************************************
//                           LEVEL0        SUBROUTINES                            //
//**********************************************************************************

void ShowCaloRAW(Int_t i, TTree *otr, Variables & var){

    pamela::calorimeter::CalorimeterEvent *de = 0;
    otr->SetBranchAddress("Calorimeter.Event", &de);
    if ( !var.nosig ) otr->GetEntry(i);

    //
    // Book the histograms:
    //
    //
    stringstream delex;
    delex.str("");
    delex << "x-view event " << (i+1);
    stringstream deley;
    deley.str("");
    deley << "y-view event " << (i+1);
    gDirectory->Delete(delex.str().c_str());
    gDirectory->Delete(deley.str().c_str());
    TH2F *Xview = new TH2F(delex.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
    TH2F *Yview = new TH2F(deley.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
    Xview->GetYaxis()->SetLabelColor(10); 
    Yview->GetYaxis()->SetLabelColor(10); 
    //
    // figures:
    //
    Int_t bgcolor = 10;
    TPad *pd1 = new TPad("calox","This is pad1",var.xxvc-0.154*var.sfx,var.yxvc-0.3645*var.sfy,var.xxvc+0.154*var.sfx,var.yxvc-0.1200*var.sfy,bgcolor);
    TPad *pd2 = new TPad("caloy","This is pad2",var.xyvc-0.154*var.sfx,var.yyvc-0.3645*var.sfy,var.xyvc+0.154*var.sfx,var.yyvc-0.1200*var.sfy,bgcolor);

    pd1->SetFillStyle(4000);
    pd1->SetFillColor(0);
    pd1->SetFrameFillStyle(4000);
    pd2->SetFillStyle(4000);
    pd2->SetFillColor(0);
    pd2->SetFrameFillStyle(4000);

    TLatex *t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.03);
    t->SetTextAlign(12);
    pd1->Range(0.,0.,1.,1.);
    pd2->Range(0.,0.,1.,1.);
    pd1->SetTicks();
    pd2->SetTicks();
    pd1->Draw();
    pd2->Draw();
    
    pd1->cd();	   
    gStyle->SetOptStat(0);
    Xview->GetYaxis()->SetTitleOffset(0.5);
    Xview->SetFillColor(bgcolor);	    
    Xview->Fill(1.,1.,1.);	    
    Xview->Draw("box");
    pd1->Update();
    pd2->cd();
    gStyle->SetOptStat(0);
    Yview->GetYaxis()->SetTitleOffset(0.5);	
    Yview->SetFillColor(bgcolor);	    
    Yview->Fill(1.,1.,1.);	    
    Yview->Draw("box");
    pd2->Update();

    //
    // run over views and planes
    //
    stringstream xevent;
    stringstream yevent;
    for (Int_t m = 0; m < 22; m++){
	for (Int_t l = 0; l < 2; l++){
	    //
	    // determine the section number
	    //
	    Int_t se = 5;
	    if ( !l && m%2 == 0 ){
		se = 3;
	    };
	    if ( !l && m%2 != 0 ){
		se = 2;
	    };
	    if ( l && m%2 == 0 ){
		se = 1;
	    };
	    if ( l && m%2 != 0 ){
		se = 0;
	    };
	    //
	    // determine what kind of event we are going to analyze
	    //
	    bool isCOMP = 0;
	    bool isFULL = 0;
	    if ( de->stwerr[se] & (1 << 16) ) isCOMP = 1; 
	    if ( de->stwerr[se] & (1 << 17) ) isFULL = 1; 
	    //
	    // run over strips
	    //
	    if ( isCOMP || isFULL ) {
		for (Int_t n = 0; n < 96; n++){
		    if ( de->dexyc[l][m][n] > 0. && !var.nosig ){
			xevent.str("");
			yevent.str("");
			xevent << "x-view event " << n;
			xevent << " " << m;
			xevent << " " << l;
			yevent << "y-view event " << n;
			yevent << " " << m;
			yevent << " " << l;
			gDirectory->Delete(xevent.str().c_str());
			gDirectory->Delete(yevent.str().c_str());
			TH2F *Xview = new TH2F(xevent.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
			TH2F *Yview = new TH2F(yevent.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
			Int_t colo = 38;
			Xview->SetFillColor(colo);
			Yview->SetFillColor(colo);
			if ( l == 0 ) {
			    Xview->Fill(n,21-m,1.);
			    pd1->cd();				    
			Xview->Draw("box same");
			};				    
			if ( l == 1 ) {			    
			    Yview->Fill(95-n,21-m,1.);
			    pd2->cd();
			    Yview->Draw("box same");
			};
		    };		    		
		};
	    };
	};
    };
    pd1->Update();
    pd2->Update();
    var.qtot=0;
    var.nstrip=0;
}

void ShowND(Int_t evno, TTree *otr, Variables & var){
    Int_t        tmpSize;    
    Int_t yUpperTrig = 0;
    Int_t yUpperBk = 0;
    Int_t yBottomBk = 0;
    pamela::neutron::NeutronEvent  *ne = 0;
    pamela::neutron::NeutronRecord *nr = 0;
    otr->SetBranchAddress("Neutron.Event", &ne);
    //
    if ( !var.nosig ) otr->GetEntry(evno);
    //
    tmpSize = ne->Records->GetEntries();
    for (Int_t j = 0; j < tmpSize; j++){
	nr = (pamela::neutron::NeutronRecord*)ne->Records->At(j);	
	yUpperTrig        += (int)nr->trigPhysics;
	yUpperBk          += (int)nr->upperBack;
	yBottomBk         += (int)nr->bottomBack;
    }
    
    var.trup = yUpperTrig;
    var.bkup = yUpperBk;
    var.bkbo = yBottomBk;

    if ( var.nosig ){
	yUpperTrig = 0;
	yUpperBk = 0;
	yBottomBk = 0;
    }
    Int_t ucolo = 10;
    if  ( var.bw ){
	if ( yUpperTrig == 1 ){	    
	    ucolo = 17;
	}
	if ( yUpperTrig == 2 ){
	    ucolo = 15;
	}
	if ( yUpperTrig > 2 && yUpperTrig < 7 ){
	    ucolo = 14;
	}
	if ( yUpperTrig > 6 && yUpperTrig < 15 ){
	    ucolo = 13;
	}
	if ( yUpperTrig >= 14 ){
	    ucolo = 12;
	};
    } else {
	if ( yUpperTrig == 1 ){	    
	    ucolo = 38;
	}
	if ( yUpperTrig == 2 ){
	    ucolo = 4;
	}
	if ( yUpperTrig > 2 && yUpperTrig < 7 ){
	    ucolo = 3;
	}
	if ( yUpperTrig > 6 && yUpperTrig < 15 ){
	    ucolo = 2;
	}
	if ( yUpperTrig >= 14 ){
	    ucolo = 6;
	};
    };
    //
    // figures:
    //
    if ( true ){
	Float_t xc1[5]={ -0.300, 0.300, 0.300, -0.300, -0.300 };
	Float_t yc1[5]={ -0.47-0.04,  -0.47-0.04, -0.47+2.*0.075-0.04, -0.47+2.*0.075-0.04, -0.47-0.04};
	//
	// Upper X-view
	//
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= var.xxvc + xc1[i]*var.nds4;
	    yc[i] = var.yxvc + yc1[i]*var.sfy;
	};
	TPolyLine *fnd2x = new TPolyLine(5,xc,yc);
	fnd2x->SetLineColor(1);
	fnd2x->SetFillColor(ucolo);
	fnd2x->SetLineWidth(1);
	fnd2x->Draw("f");
	fnd2x->Draw();
    };
    if ( true ){  
	Float_t xc1[5]={ -0.275, 0.275, 0.275, -0.275, -0.275 };
	Float_t yc1[5]={ -0.47-0.04-0.075,  -0.47-0.04-0.075, -0.47+0.075-0.04, -0.47+0.075-0.04, -0.47-0.04-0.075};
	//
	// Upper Y-view
	//
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= var.xyvc + xc1[i]*var.nds4;
	    yc[i] = var.yyvc + (yc1[i]+0.075)*var.sfy;
	};
	TPolyLine *fnd2y = new TPolyLine(5,xc,yc);
	fnd2y->SetLineColor(1);
	fnd2y->SetFillColor(ucolo);
	fnd2y->SetLineWidth(1);
	fnd2y->Draw("f");
	fnd2y->Draw();
    };
}

void ShowTRKL0(Int_t evno, TTree *otr, Variables & var){
    //
    pamela::tracker::TrackerEvent *trk = 0;    
    otr->SetBranchAddress("Tracker.Event", &trk);    
    if ( !var.nosig ) otr->GetEntry(evno);    
    //
    //  a matrix of pads for each view x and y
    //
    TPad *trkpad[12];
    for (Int_t n = 0; n<12; n++){
	stringstream spd;
        spd.str("");
	spd << "pd1" << n;
	gDirectory->Delete(spd.str().c_str());
        spd.str("");
	spd << "pd2" << n;
	gDirectory->Delete(spd.str().c_str());
        spd.str("");
	spd << "pd3" << n;
	gDirectory->Delete(spd.str().c_str());
        spd.str("");
	spd << "pd4" << n;
	gDirectory->Delete(spd.str().c_str());
        spd.str("");
	spd << "pd5" << n;
	gDirectory->Delete(spd.str().c_str());
        spd.str("");
	spd << "pd6" << n;
	gDirectory->Delete(spd.str().c_str());
        spd.str("");
	stringstream sbd;
	sbd.str("");
	Int_t magcol = 0;
	TPad *mag1 = 0;
	TPad *mag2 = 0;
	if ( n%2 ) {
	    Float_t posx = var.xxvc;
    	    Float_t posy = var.yxvc + (0.29 - 0.089*((n/2.)-1.))*var.sfy;
	    spd.str("");
	    sbd.str("");
	    spd << "pd1" << n;
	    sbd << "bd1" << n;
	    trkpad[n] = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-0.081*var.sfx,posy,posx+0.081*var.sfx,posy+0.089*var.sfy,10);
	    trkpad[n]->SetFillStyle(4000);
	    trkpad[n]->SetFillColor(0);
	    trkpad[n]->SetFrameFillStyle(4000);	    
	    trkpad[n]->Draw();
	    if ( n != 1 ) {
		if ( var.bw ) {
		    magcol = 1;
		} else {
		    magcol = 45;
		};
		spd.str("");
		sbd.str("");
		spd << "pd2" << n;
		sbd << "bd2" << n;
	    	mag1 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-(0.039+0.081)*var.sfx,posy+0.004*var.sfy,posx-0.081*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag1->SetFillStyle(3001);
		mag1->Draw();
		spd.str("");
		sbd.str("");
		spd << "pd3" << n;
		sbd << "bd3" << n;
	    	mag2 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx+0.081*var.sfx,posy+0.004*var.sfy,posx+(0.081+0.039)*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag2->SetFillStyle(3001);
	    	mag2->Draw();
	    };
	} else {
	    Float_t posx = var.xyvc;
	    Float_t posy = var.yyvc + (0.29 - 0.089 * (((n+1.)/2.)-1.))*var.sfy;
	    spd.str("");
	    sbd.str("");
	    spd << "pd4" << n;
	    sbd << "bd4" << n;
	    trkpad[n] = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-0.07*var.sfx,posy,posx+0.07*var.sfx,posy+0.089*var.sfy,10);
	    trkpad[n]->SetFillStyle(4000);
	    trkpad[n]->SetFillColor(0);
	    trkpad[n]->SetFrameFillStyle(4000);
	    trkpad[n]->Draw();
	    if ( n != 0 ) {
		if ( var.bw ) {
		    magcol = 1;
		} else {
		    magcol = 45;
		};
		spd.str("");
		sbd.str("");
		spd << "pd5" << n;
		sbd << "bd5" << n;
	     	mag1 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-(0.048+0.066)*var.sfx,posy+0.004*var.sfy,posx-0.066*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag1->SetFillStyle(3001);
	    	mag1->Draw();
		spd.str("");
		sbd.str("");
		spd << "pd6" << n;
		sbd << "bd6" << n;
	     	mag2 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx+0.066*var.sfx,posy+0.004*var.sfy,posx+(0.066+0.048)*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag2->SetFillStyle(3001);
	    	mag2->Draw();
	    };
	};
    };
    TPad *trplv;
    gDirectory->Delete("trkplv");
    trplv = new TPad("trkplv","trkplv",var.xcat-0.066*var.sfx,var.ycat-0.081*var.sfy,var.xcat+0.066*var.sfx,var.ycat+0.081*var.sfy,10);
    trplv->SetFillStyle(4000);
    trplv->SetFillColor(0);
    trplv->SetFrameFillStyle(4000);
    trplv->Draw();
    //
    Int_t sigcol1 = 17;
    Int_t sigcol2 = 15;
    Int_t linecol = 13;
    if ( var.bw ) {
	sigcol1 = 17;
	sigcol2 = 15;
	linecol = 13;
    } else {
	sigcol1 = 32;
	sigcol2 = 38;
	linecol = 42;
    };
    TLine *linea = 0;
    TLine *linea1x = 0;
    TLine *linea2x = 0;
    TLine *linea1y = 0;
    Float_t x = 0.;
    for (Int_t l = 0; l<12; l++){	
	trkpad[l]->cd();
	if ( l%2 ) { 
	    trkpad[l]->Range(0.,0.,3100.,1.);
	    linea = new TLine(0.,0.01,3100.,0.01);
	    linea1x = new TLine(1033.,0.01,1033,0.030);	    
	    linea2x = new TLine(2066.,0.01,2066,0.030);	    
	} else {
	    trkpad[l]->Range(0.,0.,2076.,1.);
	    linea = new TLine(0.,0.01,2076.,0.01);
	    linea1y = new TLine(1038.,0.01,1038,0.030);	    
	};
	linea->SetLineWidth(2);
	linea->SetLineColor(linecol);
	linea->Draw();
	if ( l%2 ) { 
	    linea1x->SetLineWidth(1);
	    linea1x->SetLineColor(1);
	    linea1x->Draw();
	    linea2x->SetLineWidth(1);
	    linea2x->SetLineColor(1);
	    linea2x->Draw();
	} else {
	    linea1y->SetLineWidth(1);
	    linea1y->SetLineColor(1);
	    linea1y->Draw();
	};
	//
    	Int_t planeno = trk->DSPnumber[l]-1;	
	if ( planeno < 0 || planeno > 11 ) planeno = 0;
  	if ( planeno >= 0 && !var.nosig ) {
    	    if ( (planeno+1)%2 ){
		trkpad[planeno]->cd();
		trkpad[planeno]->Range(0.,0.,2076.,1.);
		for (Int_t m = 0; m<3; m++){
		    if ( trk->signcluster[l][m] != 0. ){
			if ( planeno == 10 ) {
			    x = 1024 - trk->addrcluster[l][m];
			} else {
			    x = trk->addrcluster[l][m];
			};
			linea = new TLine(14.+x,0.01,14.+x,0.3);
			linea->SetLineWidth(2);
			linea->SetLineColor(sigcol1); 
			linea->Draw();			
			x += 1024.;			
			linea = new TLine(14.+x,0.01,14.+x,0.3);
			linea->SetLineWidth(2);
			linea->SetLineColor(sigcol2);
			linea->Draw();
			var.ncly++;
		    };
		};
	    } else {
		trkpad[planeno]->cd();
		trkpad[planeno]->Range(0.,0.,3100.,1.);
		for (Int_t m = 0; m<3; m++){
		    if ( trk->signcluster[l][m] != 0. ){
			x = trk->addrcluster[l][m] + 1024. * m;
			linea = new TLine(14.+x,0.01,14.+x,0.3);
			linea->SetLineWidth(2);
			linea->SetLineColor(sigcol2);
			linea->Draw();
			var.nclx++;
		    };
		};
	    };
	};    
    };
    //
    // Show track in the plane view!
    //
    Float_t xh[6];
    Float_t yh1[6];
    Float_t yh2[6];    
    Float_t mag[6];
    for (Int_t l = 0; l<6; l++ ){
	xh[l] = 0.;
	yh1[l] = 0.;
	yh2[l] = 0.;
	mag[l] = 0.;
    };
    Int_t ncro = 0;
    //
    for (Int_t l = 0; l<12; l++ ){	
	Float_t xsig = 0.;
	Float_t ysig = 0.;
    	Int_t planeno = trk->DSPnumber[l]-1;	
	for (Int_t e = 0; e<12;e++){
	    Int_t planeno2 = trk->DSPnumber[e]-1;
	    if ( planeno == planeno2-1 ){		
		if ( planeno < 0 || planeno > 11 ) planeno = 0;
		if ( planeno >= 0 && !var.nosig ) {	
		    mag[ncro] = ((float)planeno+1.)/5.;
		    if ( (planeno+1)%2 ){
			for (Int_t m = 0; m<3; m++){			    
			    if ( trk->signcluster[l][m] != 0. ){
				if ( planeno == 10 ) {
				    x = 1024 - trk->addrcluster[l][m];
				} else {
				    x = trk->addrcluster[l][m];
				};
				x += 1024.;			
				if ( trk->signcluster[l][m]> ysig  ){
				    ysig = trk->signcluster[l][m];
				    yh1[ncro] = x-1024.;
				    yh2[ncro] = x;
				};
			    };
			};
			for (Int_t m = 0; m<3; m++){
			    if ( trk->signcluster[e][m] != 0. ){
				x = trk->addrcluster[e][m] + 1024. * m;
				if ( trk->signcluster[e][m]> xsig && !( planeno == 0 && x > 2800) ){
				    xsig = trk->signcluster[e][m];
				    xh[ncro] = x;
				};
			    };
			};
		    } else {
			for (Int_t m = 0; m<3; m++){
			    if ( trk->signcluster[l][m] != 0. ){
				x = trk->addrcluster[l][m] + 1024. * m;
				if ( trk->signcluster[l][m]> xsig && !( planeno == 0 && x > 2800) ){
				    xsig = trk->signcluster[l][m];
				    xh[ncro] = x;
				};
			    };
			};
			if ( (planeno+1)%2 ){
			    for (Int_t m = 0; m<3; m++){
				if ( trk->signcluster[e][m] != 0. ){
				    if ( planeno == 10 ) {
					x = 1024 - trk->addrcluster[e][m];
				    } else {
					x = trk->addrcluster[e][m];
				    };
				    x += 1024.;			
				    if ( trk->signcluster[e][m]> ysig  ){
					ysig = trk->signcluster[e][m];
					yh1[ncro] = x-1024.;
					yh2[ncro] = x;
				    };
				};
			    };
			};
		    };
		    if ( ysig > 0. && xsig > 0. ) {
			ncro++;
		    };
		};    
	    };
	};
    };
    //
    // Draw crosses
    //
    if ( ncro ) {
	trplv->cd();
	trplv->Range(0.,0.,2076.,3100.);
	for ( Int_t i = 0; i<ncro; i++){
	    //
	    Float_t cdx = (55./mag[i])*var.sfx;
	    Float_t cdy = (55./mag[i])*var.sfy;
	    Float_t lwx = (1.9)*var.sfy;
	    Float_t lwy = (1.9)*var.sfx;
	    //
	    linea = new TLine(yh1[i]-lwx/2.,xh[i]-cdy,yh1[i]-lwx/2.,xh[i]+cdy);
	    linea->SetLineWidth((int)lwx);
	    linea->SetLineColor(sigcol1);
	    linea->Draw();
	    linea = new TLine(yh1[i]-cdx,xh[i]-lwy/2.,yh1[i]+cdx,xh[i]-lwy/2.);
	    linea->SetLineWidth((int)lwy);
	    linea->SetLineColor(sigcol1);
	    linea->Draw();
	    //
	    linea = new TLine(yh2[i]-lwx/2.,xh[i]-cdy,yh2[i]-lwx/2.,xh[i]+cdy);
	    linea->SetLineWidth((int)lwx);
	    linea->SetLineColor(sigcol2);
	    linea->Draw();
	    linea = new TLine(yh2[i]-cdy,xh[i]-lwy/2.,yh2[i]+cdx,xh[i]-lwy/2.);
	    linea->SetLineWidth((int)lwy);
	    linea->SetLineColor(sigcol2);
	    linea->Draw();
	};
    };
}

void ShowAC(Int_t i, TTree *otr, Variables & var, Int_t lev){
    //
    Int_t hitmapA = 0;
    Int_t hitmapB = 0;
    Int_t hitstatusA = 0;
    Int_t hitstatusB = 0;
    if ( lev == 0 ){
	pamela::anticounter::AnticounterEvent  *ace = 0;
	otr->SetBranchAddress("Anticounter.Event", &ace);
	if ( !var.nosig ) otr->GetEntry(i);
	hitmapA = ace->hitmap[0];
	hitmapB = ace->hitmap[1];
	if ( lev == 0 ){
	    hitstatusA = 65535;
	    hitstatusB = 65535;
	} else {
	    hitstatusA = ace->status[0];
	    hitstatusB = ace->status[1];
	};
    };
    if ( lev == 1 ){
	AnticounterLevel1 *ace1 = new AnticounterLevel1();
	otr->SetBranchAddress("AcLevel1.Event", &ace1);
	if ( !var.nosig ) otr->GetEntry(i);
	hitmapA = ace1->hitmap[0];
	hitmapB = ace1->hitmap[1];
	if ( lev == 0 ){
	    hitstatusA = 65535;
	    hitstatusB = 65535;
	} else {
	    hitstatusA = ace1->hitstatus[0];
	    hitstatusB = ace1->hitstatus[1];
	};
    };
    //
    if ( var.nosig ){
	hitmapA = 0;
	hitmapB = 0;	
	hitstatusA = 0;
	hitstatusB = 0;	
    };
    //
    Float_t cas1 = 0.;
    Float_t cas2 = 0.;
    Float_t cas3 = 0.;
    Float_t cas4 = 0.;
    Float_t cas1b = 0.;
    Float_t cas2b = 0.;
    Float_t cas3b = 0.;
    Float_t cas4b = 0.;
    //
    Float_t cat1 = 0.;
    Float_t cat2 = 0.;
    Float_t cat3 = 0.;
    Float_t cat4 = 0.;
    Float_t cat1b = 0.;
    Float_t cat2b = 0.;
    Float_t cat3b = 0.;
    Float_t cat4b = 0.;
    //
    Float_t card1 = 0.;
    Float_t card2 = 0.;
    Float_t card3 = 0.;
    Float_t card4 = 0.;
    Float_t card1b = 0.;
    Float_t card2b = 0.;
    Float_t card3b = 0.;
    Float_t card4b = 0.;
    //
    Float_t intime = -0.25;
    Float_t outtime = -0.375;
    if ( var.bw ){
	intime = -0.25;
	outtime = -0.375;
    } else {
	intime = 1.;
	outtime = -4.;
    };
    //
    // main board
    //
    if ( hitmapA & (1<<0) ) {
	card4 = intime;
	if ( !(hitstatusA & (1<<0)) ) card4 = outtime ;
	var.hcard++;
    }
    if ( hitmapA & (1<<1) ) {
	cat2 = intime;
	if ( !(hitstatusA & (1<<1)) ) cat2 = outtime ;
	var.hcat++;
    }
    if ( hitmapA & (1<<2) ) {
	cas1 = intime;
	if ( !(hitstatusA & (1<<2)) ) cas1 = outtime ;
	var.hcas++;
    }
    //
    if ( hitmapA & (1<<4) ) {
	card2 = intime;
	if ( !(hitstatusA & (1<<4)) ) card2 = outtime ;
	var.hcard++;
    }
    if ( hitmapA & (1<<5) ) {
	cat4 = intime;
	if ( !(hitstatusA & (1<<5)) ) cat4 = outtime ;
	var.hcat++;
    }
    if ( hitmapA & (1<<6) ) {
	cas4 = intime;
	if ( !(hitstatusA & (1<<6)) ) cas4 = outtime ;
	var.hcas++;
    }
    //
    if ( hitmapA & (1<<8) ) {
	card3 = intime;
	if ( !(hitstatusA & (1<<8)) ) card3 = outtime ;
	var.hcard++;
    }
    if ( hitmapA & (1<<9) ) {
	cat3 = intime;
	if ( !(hitstatusA & (1<<9)) ) cat3 = outtime ;
	var.hcat++;
    }
    if ( hitmapA & (1<<10) ) {
	cas3 = intime;
	if ( !(hitstatusA & (1<<10)) ) cas3 = outtime ;
	var.hcas++;
    }
    //
    if ( hitmapA & (1<<12) ) {
	card1 = intime;
	if ( !(hitstatusA & (1<<12)) ) card1 = outtime ;
	var.hcard++;
    }
    if ( hitmapA & (1<<13) ) { 
	cat1 = intime;
	if ( !(hitstatusA & (1<<13)) ) cat1 = outtime ;
	var.hcat++;
    }
    if ( hitmapA & (1<<14) ) { 
	cas2 = intime;
	if ( !(hitstatusA & (1<<14)) ) cas2 = outtime ;
	var.hcas++;
    }
	    
    //
    // extra board
    //
    if ( hitmapB & (1<<0) ) {
	card4b = intime;
	if ( !(hitstatusB & (1<<0)) ) card4b = outtime ;
	var.hcard++;
    }
    if ( hitmapB & (1<<1) ) {
	cat2b = intime; 
	if ( !(hitstatusB & (1<<1)) ) cat2b = outtime ;
	var.hcat++;
    }
    if ( hitmapB & (1<<2) ) {
	cas1b = intime;
	if ( !(hitstatusB & (1<<2)) ) cas1b = outtime;
	var.hcas++;
    }
    //
    if ( hitmapB & (1<<4) ) {
	card2b = intime;
	if ( !(hitstatusB & (1<<4)) ) card2b = outtime ;
	var.hcard++;
    }
    if ( hitmapB & (1<<5) ) {
	cat4b = intime;
	if ( !(hitstatusB & (1<<5)) ) cat4b = outtime ;
	var.hcat++;
    }
    if ( hitmapB & (1<<6) ) {
	cas4b = intime;
	if ( !(hitstatusB & (1<<6)) ) cas4b = outtime ;
	var.hcas++;
    }
    //
    if ( hitmapB & (1<<8) ) {
	card3b = intime;
	if ( !(hitstatusB & (1<<8)) ) card3b = outtime ;
	var.hcard++;
    }
    if ( hitmapB & (1<<9) ) { 
	cat3b = intime;
	if ( !(hitstatusB & (1<<9)) ) cat3b = outtime ;
	var.hcat++;
    }
    if ( hitmapB & (1<<10) ) { 
	cas3b = intime;
	if ( !(hitstatusB & (1<<10)) ) cas3b = outtime ;
	var.hcas++;
    }
    //
    if ( hitmapB & (1<<12) ) { 
	card1b = intime;	
	if ( !(hitstatusB & (1<<12)) ) card1b = outtime ;
	var.hcard++;
    }
    if ( hitmapB & (1<<13) ) {
	cat1b = intime;
	if ( !(hitstatusB & (1<<13)) ) cat1b = outtime ;
	var.hcat++;
    }
    if ( hitmapB & (1<<14) ) {
	cas2b = intime;
	if ( !(hitstatusB & (1<<14)) ) cas2b = outtime ;
	var.hcas++;
    };
    Int_t colo = 0;
    //
    // CAS height and width
    //
    Float_t csh = 0.194*var.sfy;
    Float_t csw = 0.008*var.sfx;
    Float_t ctw = 0.008;

    //
    // CAS2 -0.039-0.081   |TRX     TRY
    //
    if ( true ){
	Float_t xofs = var.xxvc -(0.039+0.081+0.0273)*var.sfx;
	Float_t yofs = var.yxvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
	Double_t y[4] = {yofs-csh,yofs-csh,yofs+csh,yofs-csh};
	TPolyLine *fcas2 = new TPolyLine(4,x,y);
	fcas2->SetLineColor(1);
	colo = (int)(10. - cas2 * 8.);
	fcas2->SetFillColor(colo);
	fcas2->SetLineWidth(1);
	fcas2->Draw("f");
	fcas2->Draw();
    };
    if ( true ){
	Float_t xofs = var.xxvc -(0.039 +0.081 +0.0273)*var.sfx;
	Float_t yofs = var.yxvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
	Double_t y[4] = {yofs+csh,yofs-csh,yofs+csh,yofs+csh};
	TPolyLine *fcas2b = new TPolyLine(4,x,y);
	fcas2b->SetLineColor(1);
	colo = (int)(10. - cas2b * 8.);
	fcas2b->SetFillColor(colo);
	fcas2b->SetLineWidth(1);
	fcas2b->Draw("f");
	fcas2b->Draw();
    };
    //
    // CAS1 -0.039+0.081  TRX|  TRY
    //
    if ( true ){
	Float_t xofs = var.xxvc + (0.039 +0.081+0.0273)*var.sfx +csw;
	Float_t yofs = var.yxvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
	Double_t y[4] = {yofs-csh,yofs+csh,yofs-csh,yofs-csh};
	TPolyLine *fcas1 = new TPolyLine(4,x,y);
	fcas1->SetLineColor(1);
	colo = (int)(10. - cas1 * 8.);
	fcas1->SetFillColor(colo);
	fcas1->SetLineWidth(1);
	fcas1->Draw("f");
	fcas1->Draw();
    };
    if ( true ){
	Float_t xofs = var.xxvc + (0.039 +0.081+0.0273)*var.sfx +csw;
	Float_t yofs = var.yxvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
	Double_t y[4] = {yofs+csh,yofs+csh,yofs-csh,yofs+csh};
	TPolyLine *fcas1b = new TPolyLine(4,x,y);
	fcas1b->SetLineColor(1);
	colo = (int)(10. - cas1b * 8.);
	fcas1b->SetFillColor(colo);
	fcas1b->SetLineWidth(1);
	fcas1b->Draw("f");
	fcas1b->Draw();
    };
    //
    // CAS4 -0.039-0.081  TRX   |TRY
    //
    if ( true ){
	Float_t xofs = var.xyvc - (0.048 +0.066 +0.0273)*var.sfx;
	Float_t yofs = var.yyvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
	Double_t y[4] = {yofs-csh,yofs-csh,yofs+csh,yofs-csh};
	TPolyLine *fcas4 = new TPolyLine(4,x,y);
	fcas4->SetLineColor(1);
	colo = (int)(10. - cas4 * 8.);
	fcas4->SetFillColor(colo);
	fcas4->SetLineWidth(1);
	fcas4->Draw("f");
	fcas4->Draw();
    };
    if ( true ){
	Float_t xofs = var.xyvc - (0.048 +0.066 +0.0273)*var.sfx;
	Float_t yofs = var.yyvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
	Double_t y[4] = {yofs+csh,yofs-csh,yofs+csh,yofs+csh};
	TPolyLine *fcas4b = new TPolyLine(4,x,y);
	fcas4b->SetLineColor(1);
	colo = (int)(10. - cas4b * 8.);
	fcas4b->SetFillColor(colo);
	fcas4b->SetLineWidth(1);
	fcas4b->Draw("f");
	fcas4b->Draw();
    };

    //
    // CAS3 -0.039+0.081   TRX   TRY| 
    //
    if ( true ){
	Float_t xofs = var.xyvc + (0.048 +0.066+0.0273)*var.sfx +csw;
	Float_t yofs = var.yyvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
	Double_t y[4] = {yofs-csh,yofs+csh,yofs-csh,yofs-csh};
	TPolyLine *fcas3 = new TPolyLine(4,x,y);
	fcas3->SetLineColor(1);
	colo = (int)(10. - cas3 * 8.);
	fcas3->SetFillColor(colo);
	fcas3->SetLineWidth(1);
	fcas3->Draw("f");
	fcas3->Draw();
    };
    if ( true ){
	Float_t xofs = var.xyvc + (0.048 +0.066+0.0273)*var.sfx +csw;
	Float_t yofs = var.yyvc + 0.09*var.sfy ;
	Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
	Double_t y[4] = {yofs+csh,yofs+csh,yofs-csh,yofs+csh};
	TPolyLine *fcas3b = new TPolyLine(4,x,y);
	fcas3b->SetLineColor(1);
	colo = (int)(10. - cas3b * 8.);
	fcas3b->SetFillColor(colo);
	fcas3b->SetLineWidth(1);
	fcas3b->Draw("f");
	fcas3b->Draw();
    };

    //
    // CAT coordinate system
    //
    Float_t xcat = var.xcat;
    Float_t ycat = var.ycat;
    Float_t pmt1 = 0.0356;    
    Float_t pmt2 = 0.038;    
    Float_t xpmt1 = -0.149*var.sfx;
    Float_t ypmt1 = 0.251*var.sfy;
    Float_t apmt1 = atan((11.*var.sfy)/(14.*var.sfx));
    Float_t xpmt2 = -0.257*var.sfx;
    Float_t ypmt2 = 0.158*var.sfy;
    Float_t apmt2 = atan((11.*var.sfx)/(15.*var.sfy));
    //
    Int_t cattime = 13;
    Int_t catnoti = 12;
    if ( var.bw ){
	cattime = 13;
	catnoti = 12;
    } else {
	cattime = 2;
	catnoti = 42;
    };
    //
    if ( true ){
	// PMTs
	Float_t xc1[5]={ 0., 0.014*var.sfx, 0.014*var.sfx-var.sfx*var.sfx*pmt1*cos(apmt1), -var.sfx*var.sfx*pmt1*cos(apmt1), 0.};
	Float_t yc1[5]={ 0., 0.011*var.sfy, 0.011*var.sfy+var.sfy*var.sfy*pmt1*sin(apmt1), var.sfy*var.sfy*pmt1*sin(apmt1), 0.};
	Float_t xc2[5]={ 0., 0.011*var.sfx, 0.011*var.sfx-pmt2*var.sfx*var.sfx*cos(apmt2), -pmt2*var.sfx*var.sfx*cos(apmt2), 0.};
	Float_t yc2[5]={ 0., 0.015*var.sfy, 0.015*var.sfy+var.sfy*pmt2*var.sfy*sin(apmt2), var.sfy*pmt2*var.sfy*sin(apmt2), 0.};
	// SCINTs
	Float_t xcc1[10]={-0.149, -0.090165, -0.090165, -0.149, -0.242, -0.257, -0.212,   -0.257,   -0.242,   -0.149};
	Float_t ycc1[10]={ 0.169,  0.108165, -0.108165, -0.169, -0.169, -0.158, 0.,   0.158,    0.169,    0.169};
	Float_t xcc2[10]={-0.149,   -0.149,   -0.138,     0., 0.138, 0.149, 0.149, 0.090165,   -0.090165,   -0.149};
	Float_t ycc2[10]={ 0.169,    0.251,    0.265,  0.220, 0.265, 0.251, 0.169, 0.108165,    0.108165,    0.169};   
	//
	// CAT sections
	//
	if ( true ){
	    Float_t xofs = var.xxvc -0.108165*var.sfx;
	    Float_t yofs = var.yxvc + 0.3725*var.sfy ;
	    Double_t xx[5] = {xofs,xofs-0.112*var.sfx,xofs-0.112*var.sfx,xofs,xofs};
	    Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
	    TPolyLine *fcat3 = new TPolyLine(5,xx,yy);
	    fcat3->SetLineColor(1);
	    if ( cat3 != 0. || cat3b != 0. ){
		if ( cat3 > 0 || cat3b > 0 || cat3 == -0.25 || cat3b == -0.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    } else {
		colo = 10;
	    };
	    fcat3->SetFillColor(colo);
	    fcat3->SetLineWidth(1);
	    fcat3->Draw("f");
	    fcat3->Draw();
	};
	if ( true ){
	    Float_t xofs = var.xxvc +0.108165*var.sfx;
	    Float_t yofs = var.yxvc + 0.3725 *var.sfy;
	    Double_t xx[5] = {xofs,xofs+0.112*var.sfx,xofs+0.112*var.sfx,xofs,xofs};
	    Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
	    TPolyLine *fcat4 = new TPolyLine(5,xx,yy);
	    fcat4->SetLineColor(1);
	    if ( cat4 != 0. || cat4b != 0. ){
		if ( cat4 > 0 || cat4b > 0 || cat4 == -.25 || cat4b == -.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    } else {
		colo = 10;
	    };
	    fcat4->SetFillColor(colo);
	    fcat4->SetLineWidth(1);
	    fcat4->Draw("f");
	    fcat4->Draw();
	};
	if ( true ){
	    Float_t xofs = var.xyvc + 0.090165*var.sfx;
	    Float_t yofs = var.yyvc + 0.3725*var.sfy ;
	    Double_t xx[5] = {xofs,xofs+0.122*var.sfx,xofs+0.122*var.sfx,xofs,xofs};
	    Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
	    TPolyLine *fcat1 = new TPolyLine(5,xx,yy);
	    fcat1->SetLineColor(1);
	    if ( cat1 != 0. || cat1b != 0. ){
		if ( cat1 > 0 || cat1b > 0 || cat1 ==-.25 || cat1b ==-.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    } else {
		colo = 10;
	    };
	    fcat1->SetFillColor(colo);
	    fcat1->SetLineWidth(1);
	    fcat1->Draw("f");
	    fcat1->Draw();
	};
	if ( true ){
	    Float_t xofs = var.xyvc - 0.090165*var.sfx;
	    Float_t yofs = var.yyvc + 0.3725*var.sfy ;
	    Double_t xx[5] = {xofs,xofs-0.122*var.sfx,xofs-0.122*var.sfx,xofs,xofs};
	    Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
	    TPolyLine *fcat2 = new TPolyLine(5,xx,yy);
	    fcat2->SetLineColor(1);
	    if ( cat2 != 0. || cat2b != 0. ){
		if ( cat2 > 0 || cat2b > 0 || cat2 ==-.25 || cat2b ==-.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    } else {
		colo = 10;
	    };
	    fcat2->SetFillColor(colo);
	    fcat2->SetLineWidth(1);
	    fcat2->Draw("f");
	    fcat2->Draw();
	};
	//
	// CAT1
	//
	Float_t xcc[10];     
	Float_t ycc[10];
	if ( true ){
	    for (Int_t i = 0; i<10 ; i++) {
		xcc[i]= xcat - xcc1[i]*var.sfx;
		ycc[i] = ycat + ycc1[i]*var.sfy;
	    };
	    TPolyLine *fcat1 = new TPolyLine(10,xcc,ycc);
	    fcat1->SetLineColor(1);
	    colo = 10;
	    if ( cat1 != 0. || cat1b != 0. ) {
		if ( cat1 > 0 || cat1b > 0 || cat1 ==-.25 || cat1b ==-.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    };
	    fcat1->SetFillColor(colo);
	    fcat1->SetLineWidth(1);
	    fcat1->Draw("f");
	    fcat1->Draw();
	};
	//
	// CAT2
	//
	if ( true ){
	    for (Int_t i = 0; i<10 ; i++) {
		xcc[i]= xcat + xcc1[i]*var.sfx;
		ycc[i] = ycat + ycc1[i]*var.sfy;
	    };
	    TPolyLine *fcat2 = new TPolyLine(10,xcc,ycc);
	    fcat2->SetLineColor(1);
	    colo = 10;
	    if ( cat2 != 0. || cat2b != 0. ) {
		if ( cat2 > 0 || cat2b > 0 || cat2 ==-.25 || cat2b ==-.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    };
	    fcat2->SetFillColor(colo);
	    fcat2->SetLineWidth(1);
	    fcat2->Draw("f");
	    fcat2->Draw();
	};
	//
	// CAT3
	//
	if ( true ){
	    for (Int_t i = 0; i<10 ; i++) {
		xcc[i]= xcat + xcc2[i]*var.sfx;
		ycc[i] = ycat - ycc2[i]*var.sfy;
	    };
	    TPolyLine *fcat3 = new TPolyLine(10,xcc,ycc);
	    fcat3->SetLineColor(1);
	    colo = 10;
	    if ( cat3 != 0. || cat3b != 0. ) {
		if ( cat3 > 0 || cat3b > 0 || cat3 == -.25  || cat3b ==-.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    }; 
	    fcat3->SetFillColor(colo);
	    fcat3->SetLineWidth(1);
	    fcat3->Draw("f");
	    fcat3->Draw();
	};
	//
	// CAT4
	//
	if ( true ){
	    for (Int_t i = 0; i<10 ; i++) {
		xcc[i]= xcat + xcc2[i]*var.sfx;
		ycc[i] = ycat + ycc2[i]*var.sfy;
	    };
	    TPolyLine *fcat4 = new TPolyLine(10,xcc,ycc);
	    fcat4->SetLineColor(1);
	    colo = 10;
	    if ( cat4 != 0. || cat4b != 0. ) {
		if ( cat4 > 0 || cat4b > 0 || cat4 == -.25  || cat4b ==-.25 ){
		    colo = cattime;
		} else {
		    colo = catnoti;
		};
	    }; 
	    fcat4->SetFillColor(colo);
	    fcat4->SetLineWidth(1);
	    fcat4->Draw("f");
	    fcat4->Draw();
	};
	//
	// CAT1  PMTs
	//
	Float_t xc[5];     
	Float_t yc[5];
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat - xpmt2 - xc1[i];
		yc[i] = ycat + ypmt2 + yc1[i];
	    };
	    TPolyLine *fcat1 = new TPolyLine(5,xc,yc);
	    fcat1->SetLineColor(1);
	    colo = (int)(10. - cat1 * 8.);
	    fcat1->SetFillColor(colo);
	    fcat1->SetLineWidth(1);
	    fcat1->Draw("f");
	    fcat1->Draw();
	};
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat - xpmt2 - xc1[i];
		yc[i] = ycat - ypmt2 - yc1[i];
	    };
	    TPolyLine *fcat1b = new TPolyLine(5,xc,yc);
	    fcat1b->SetLineColor(1);
	    colo =  (int)(10. - cat1b * 8.);
	    fcat1b->SetFillColor(colo);
	    fcat1b->SetLineWidth(1);
	    fcat1b->Draw("f");
	    fcat1b->Draw();
	};
	//
	// CAT2  PMTs
	//
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat + xpmt2 + xc1[i];
		yc[i] = ycat + ypmt2 + yc1[i];
	    };
	    TPolyLine *fcat2 = new TPolyLine(5,xc,yc);
	    fcat2->SetLineColor(1);
	    colo =  (int)(10. - cat2 * 8.);
	    fcat2->SetFillColor(colo);
	    fcat2->SetLineWidth(1);
	    fcat2->Draw("f");
	    fcat2->Draw();
	};
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat + xpmt2 + xc1[i];
		yc[i] = ycat - ypmt2 - yc1[i];
	    };
	    TPolyLine *fcat2b = new TPolyLine(5,xc,yc);
	    fcat2b->SetLineColor(1);
	    colo = (int)(10. - cat2b * 8.);
	    fcat2b->SetFillColor(colo);
	    fcat2b->SetLineWidth(1);
	    fcat2b->Draw("f");
	    fcat2b->Draw();
	};
	//
	// CAT3  PMTs
	//
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat + xpmt1 + xc2[i];
		yc[i] = ycat - ypmt1 - yc2[i];
	    };
	    TPolyLine *fcat3b = new TPolyLine(5,xc,yc);
	    fcat3b->SetLineColor(1);
	    colo = (int)(10. - cat3b * 8.);
	    fcat3b->SetFillColor(colo);
	    fcat3b->SetLineWidth(1);
	    fcat3b->Draw("f");
	    fcat3b->Draw();
	};
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat - xpmt1 - xc2[i];
		yc[i] = ycat - ypmt1 - yc2[i];
	    };
	    TPolyLine *fcat3 = new TPolyLine(5,xc,yc);
	    fcat3->SetLineColor(1);
	    colo = (int)(10. - cat3 * 8.);
	    fcat3->SetFillColor(colo);
	    fcat3->SetLineWidth(1);
	    fcat3->Draw("f");
	    fcat3->Draw();
	};
	//
	// CAT4  PMTs
	//
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat + xpmt1 + xc2[i];
		yc[i] = ycat + ypmt1 + yc2[i];
	    };
	    TPolyLine *fcat4b = new TPolyLine(5,xc,yc);
	    fcat4b->SetLineColor(1);
	    colo = (int)(10. - cat4b * 8.);
	    fcat4b->SetFillColor(colo);
	    fcat4b->SetLineWidth(1);
	    fcat4b->Draw("f");
	    fcat4b->Draw();
	};
	if ( true ){
	    for (Int_t i = 0; i<5 ; i++) {
		xc[i]= xcat - xpmt1 - xc2[i];
		yc[i] = ycat + ypmt1 + yc2[i];
	    };
	    TPolyLine *fcat4 = new TPolyLine(5,xc,yc);
	    fcat4->SetLineColor(1);
	    colo = (int)(10. - cat4 * 8.);
	    fcat4->SetFillColor(colo);
	    fcat4->SetLineWidth(1);
	    fcat4->Draw("f");
	    fcat4->Draw();
	};
    };
    if ( true ){
	//
	// CAS plane view:
	//
	Float_t xofs = -0.025;
	Float_t yofs = 0.039 +0.081+0.0273;
	Float_t csy = 0.33/2.;
	Float_t pmofs = 0.004;
	Float_t csw2 = 0.008;
	Float_t xc1[5] = { xofs-csy, xofs-csy, xofs+csy, xofs+csy, xofs-csy};
	Float_t yc1[5] = { yofs,     yofs+csw2, yofs+csw2, yofs,     yofs};

	Float_t xc2[5] = { xofs-csy-csw2, xofs-csy-csw2, xofs-csy, xofs-csy, xofs-csy-csw2};
	Float_t yc2[5] = { yofs+pmofs,     yofs+pmofs+csw2, yofs+pmofs+csw2, yofs+pmofs,     yofs+pmofs};
	Float_t xc3[5] = { xofs-csy-csw2, xofs-csy-csw2, xofs-csy, xofs-csy, xofs-csy-csw2};
	Float_t yc3[5] = { yofs+pmofs,     yofs+pmofs-csw2, yofs+pmofs-csw2, yofs+pmofs,     yofs+pmofs};

	//
	// CAS1 
	//
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc1[i]*var.sfx;
	    yc[i] = ycat + yc1[i]*var.sfy;
	};
	TPolyLine *pcass1 = new TPolyLine(5,xc,yc);
	pcass1->SetLineColor(1);
	colo = 10;
	if ( cas1 != 0. || cas1b != 0. ) {
	    if ( cas1 > 0 || cas1b > 0 || cas1 ==-.25  || cas1b ==-.25){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	if ( colo != 10 ) pcass1->SetFillStyle(3001);    
	pcass1->SetFillColor(colo);
	pcass1->SetLineWidth(1); 
	pcass1->SetLineStyle(2);
	pcass1->Draw("f");
	pcass1->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc2[i]*var.sfx;
	    yc[i] = ycat + yc2[i]*var.sfy;
	};
	TPolyLine *pcasp1b = new TPolyLine(5,xc,yc);
	pcasp1b->SetLineColor(1);
	colo = (int)(10. - cas1b * 8.);
	if ( colo != 10 ) pcasp1b->SetFillStyle(3001);    
	pcasp1b->SetFillColor(colo);
	pcasp1b->SetLineWidth(1);
	pcasp1b->SetLineStyle(2);
	pcasp1b->Draw("f");
	pcasp1b->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc3[i]*var.sfx;
	    yc[i] = ycat + yc3[i]*var.sfy;
	};
	TPolyLine *pcasp1 = new TPolyLine(5,xc,yc);
	pcasp1->SetLineColor(1);
	colo = (int)(10. - cas1 * 8.);
	if ( colo != 10 ) pcasp1->SetFillStyle(3001);    
	pcasp1->SetFillColor(colo);
	pcasp1->SetLineWidth(1);
	pcasp1->SetLineStyle(2);
	pcasp1->Draw("f");
	pcasp1->Draw();
	//
	// CAS2
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc1[i]*var.sfx;
	    yc[i] = ycat - yc1[i]*var.sfy;
	};
	TPolyLine *pcass2 = new TPolyLine(5,xc,yc);
	pcass2->SetLineColor(1);
	colo = 10;
	if ( cas2 != 0. || cas2b != 0. ) {
	    if ( cas2 > 0 || cas2b > 0 || cas2 ==-.25 || cas2b ==-.25 ){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	if ( colo != 10 ) pcass2->SetFillStyle(3001);    
	pcass2->SetFillColor(colo);
	pcass2->SetLineWidth(1); 
	pcass2->SetLineStyle(2);
	pcass2->Draw("f");
	pcass2->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc2[i]*var.sfx;
	    yc[i] = ycat - yc2[i]*var.sfy;
	};
	TPolyLine *pcasp2b = new TPolyLine(5,xc,yc);
	pcasp2b->SetLineColor(1);
	colo = (int)(10. - cas2b * 8.);
	if ( colo != 10 ) pcasp2b->SetFillStyle(3001);    
	pcasp2b->SetFillColor(colo);
	pcasp2b->SetLineWidth(1);
	pcasp2b->SetLineStyle(2);
	pcasp2b->Draw("f");
	pcasp2b->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc3[i]*var.sfx;
	    yc[i] = ycat - yc3[i]*var.sfy;
	};
	TPolyLine *pcasp2 = new TPolyLine(5,xc,yc);
	pcasp2->SetLineColor(1);
	colo = (int)(10. - cas2 * 8.);
	pcasp2->SetFillColor(colo);
	if ( colo != 10 ) pcasp2->SetFillStyle(3001);    
	pcasp2->SetLineWidth(1);
	pcasp2->SetLineStyle(2);
	pcasp2->Draw("f");
	pcasp2->Draw();

    };
    if ( true ){
	Float_t xofs = 0.048 +0.066+0.0273;
	Float_t yofs = 0.02;
	Float_t csy = 0.33/2.;
	Float_t pmofs = 0.004;
	Float_t csw2 = 0.008;
	Float_t xc1[5] = { xofs,     xofs+csw2, xofs+csw2, xofs,     xofs};
	Float_t yc1[5] = { yofs-csy, yofs-csy, yofs+csy, yofs+csy, yofs-csy};
	Float_t xc2[5] = { xofs+pmofs,     xofs+pmofs+csw2, xofs+pmofs+csw2, xofs+pmofs,     xofs+pmofs};
	Float_t yc2[5] = { yofs+csy+csw2, yofs+csy+csw2, yofs+csy, yofs+csy, yofs+csy+csw2};    
	Float_t xc3[5] = { xofs+pmofs,     xofs+pmofs-csw2, xofs+pmofs-csw2, xofs+pmofs,     xofs+pmofs};
	Float_t yc3[5] = { yofs+csy+csw2, yofs+csy+csw2, yofs+csy, yofs+csy, yofs+csy+csw2};
	//
	// CAS3
	//
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc1[i]*var.sfx;
	    yc[i] = ycat + yc1[i]*var.sfy;
	};
	TPolyLine *pcass3 = new TPolyLine(5,xc,yc);
	pcass3->SetLineColor(1);
	colo = 10;
	if ( cas3 != 0. || cas3b != 0. ) {
	    if ( cas3 > 0 || cas3b > 0 ||  cas3 ==-.25 || cas3b ==-.25){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	if ( colo != 10 ) pcass3->SetFillStyle(3001);    
	pcass3->SetFillColor(colo);
	pcass3->SetLineWidth(1); 
	pcass3->SetLineStyle(2);
	pcass3->Draw("f");
	pcass3->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc2[i]*var.sfx;
	    yc[i] = ycat + yc2[i]*var.sfy;
	};
	TPolyLine *pcasp3b = new TPolyLine(5,xc,yc);
	pcasp3b->SetLineColor(1);
	colo = (int)(10. - cas3b * 8.);
	if ( colo != 10 ) pcasp3b->SetFillStyle(3001);    
	pcasp3b->SetFillColor(colo);
	pcasp3b->SetLineWidth(1);
	pcasp3b->SetLineStyle(2);
	pcasp3b->Draw("f");
	pcasp3b->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc3[i]*var.sfx;
	    yc[i] = ycat + yc3[i]*var.sfy;
	};
	TPolyLine *pcasp3 = new TPolyLine(5,xc,yc);
	pcasp3->SetLineColor(1);
	colo = (int)(10. - cas3 * 8.);
	pcasp3->SetFillColor(colo); 
	if ( colo != 10 ) pcasp3->SetFillStyle(3001);    
	pcasp3->SetLineWidth(1);
	pcasp3->SetLineStyle(2);
	pcasp3->Draw("f");
	pcasp3->Draw();
	//
	// CAS4
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc1[i]*var.sfx;
	    yc[i] = ycat - yc1[i]*var.sfy;
	};
	TPolyLine *pcass4 = new TPolyLine(5,xc,yc);
	pcass4->SetLineColor(1);
	colo = 10;
	if ( cas4 != 0. || cas4b != 0. ) {
	    if ( cas4 > 0 || cas4b > 0 ||  cas4 ==-.25 || cas4b ==-.25 ){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	pcass4->SetFillColor(colo);
	if ( colo != 10 ) pcass4->SetFillStyle(3001);    
	pcass4->SetLineWidth(1); 
	pcass4->SetLineStyle(2);
	pcass4->Draw("f");
	pcass4->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc2[i]*var.sfx;
	    yc[i] = ycat - yc2[i]*var.sfy;
	};
	TPolyLine *pcasp4 = new TPolyLine(5,xc,yc);
	pcasp4->SetLineColor(1);
	colo = (int)(10. - cas4 * 8.);
	pcasp4->SetFillColor(colo);
	if ( colo != 10 ) pcasp4->SetFillStyle(3001);    
	pcasp4->SetLineWidth(1);
	pcasp4->SetLineStyle(2);
	pcasp4->Draw("f");
	pcasp4->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc3[i]*var.sfx;
	    yc[i] = ycat - yc3[i]*var.sfy;
	};
	TPolyLine *pcasp4b = new TPolyLine(5,xc,yc);
	pcasp4b->SetLineColor(1);
	colo = (int)(10. - cas4b * 8.);
	pcasp4b->SetFillColor(colo);
	if ( colo != 10 ) pcasp4b->SetFillStyle(3001);    
	pcasp4b->SetLineWidth(1);
	pcasp4b->SetLineStyle(2);
	pcasp4b->Draw("f");
	pcasp4b->Draw();
    };
    Float_t alfa = 1.2020334;
    Float_t lcrd = 0.1815/2.;
    Float_t wcrd = 0.008;
    if ( true ){
	//
	// CARD plane view:
	//
	Float_t xc1[5] = { -0.090165, -0.090165, -0.082165, -0.082165, -0.090165};
	Float_t yc1[5] = { -0.100, 0.092, 0.092, -0.100, -0.100};
	Float_t xc2[5] = { -0.094165, -0.094165, -0.086165, -0.086165, -0.094165};
	Float_t yc2[5] = { 0.092, 0.100, 0.100, 0.092, 0.092};
	Float_t xc3[5] = { -0.086165, -0.086165, -0.078165, -0.078165, -0.086165};
	Float_t yc3[5] = { 0.092, 0.100, 0.100, 0.092, 0.092};
	//
	// CARD1 
	//
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc1[i]*var.sfx;
	    yc[i] = ycat + yc1[i]*var.sfy;
	};
	TPolyLine *pcars1 = new TPolyLine(5,xc,yc);
	pcars1->SetLineColor(1);
	colo = 10;
	if ( card1 != 0. || card1b != 0. ) {
	    if ( card1 > 0 || card1b > 0 || card1 ==-.25  || card1b ==-.25 ){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	pcars1->SetFillColor(colo);
	pcars1->SetLineWidth(1);
	pcars1->Draw("f");
	pcars1->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + xc2[i]*var.sfx;
	    yc[i] = ycat + yc2[i]*var.sfy;
	};
	TPolyLine *pcarp1b = new TPolyLine(5,xc,yc);
	pcarp1b->SetLineColor(1);
	colo = (int)(10. - card1b * 8.);
	pcarp1b->SetFillColor(colo);
	pcarp1b->SetLineWidth(1);
	pcarp1b->Draw("f");
	pcarp1b->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]		= xcat + xc3[i]*var.sfx;
	    yc[i] 		= ycat + yc3[i]*var.sfy;
	};
	TPolyLine 	*pcarp1 = new TPolyLine(5,xc,yc);
	pcarp1->SetLineColor(1);
	colo 		= (int)(10. - card1 * 8.);
	pcarp1->SetFillColor(colo);
	pcarp1->SetLineWidth(1);
	pcarp1->Draw("f");
	pcarp1->Draw();
	//
	// CARD4
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc1[i]*var.sfx;
	    yc[i] = ycat - yc1[i]*var.sfy;
	};
	TPolyLine *pcars4 = new TPolyLine(5,xc,yc);
	pcars4->SetLineColor(1);
	colo = 10;
	if ( card4 != 0. || card4b != 0. ) {
	    if ( card4 > 0 || card4b > 0 ||  card4 ==-.25 || card4b ==-.25){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	pcars4->SetFillColor(colo);
	pcars4->SetLineWidth(1);
	pcars4->Draw("f");
	pcars4->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc2[i]*var.sfx;
	    yc[i] = ycat - yc2[i]*var.sfy;
	};
	TPolyLine *pcarp4b = new TPolyLine(5,xc,yc);
	pcarp4b->SetLineColor(1);
	colo = (int)(10. - card4b * 8.);
	pcarp4b->SetFillColor(colo);
	pcarp4b->SetLineWidth(1);
	pcarp4b->Draw("f");
	pcarp4b->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - xc3[i]*var.sfx;
	    yc[i] = ycat - yc3[i]*var.sfy;
	};
	TPolyLine *pcarp4 = new TPolyLine(5,xc,yc);
	pcarp4->SetLineColor(1);
	colo = (int)(10. - card4 * 8.);
	pcarp4->SetFillColor(colo);
	pcarp4->SetLineWidth(1);
	pcarp4->Draw("f");
	pcarp4->Draw();
    };
    if ( true ){
	Float_t xc1[5] = { -0.074, 0.074, 0.074, -0.074, -0.074};
	Float_t yc1[5] = {  0.108165, 0.108165, 0.100165, 0.100165, 0.108165};
	Float_t xc2[5] = { 0.074, 0.082, 0.082, 0.074, 0.074};
	Float_t yc2[5] = { 0.112165, 0.112165, 0.104165, 0.104165, 0.112165};
	Float_t xc3[5] = { 0.074, 0.082, 0.082, 0.074, 0.074};
	Float_t yc3[5] = { 0.104165, 0.104165, 0.096165, 0.096165, 0.104165};
	//
	// CARD2
	//
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - (xc1[i]-0.0025)*var.sfx;
	    yc[i] = ycat - yc1[i]*var.sfy;
	};
	TPolyLine *pcars2 = new TPolyLine(5,xc,yc);
	pcars2->SetLineColor(1);
	colo = 10;
	if ( card2 != 0. || card2b != 0.) {
	    if ( card2 > 0 || card2b > 0 ||  card2 ==-.25 || card2b ==-.25 ){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	pcars2->SetFillColor(colo);
	pcars2->SetLineWidth(1);
	pcars2->Draw("f");
	pcars2->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - (xc2[i]-0.0025)*var.sfx;
	    yc[i] = ycat - yc2[i]*var.sfy;
	};
	TPolyLine *pcarp2 = new TPolyLine(5,xc,yc);
	pcarp2->SetLineColor(1);
	colo = (int)(10. - card2 * 8.);
	pcarp2->SetFillColor(colo);
	pcarp2->SetLineWidth(1);
	pcarp2->Draw("f");
	pcarp2->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat - (xc3[i]-0.0025)*var.sfx;
	    yc[i] = ycat - yc3[i]*var.sfy;
	};
	TPolyLine *pcarp2b = new TPolyLine(5,xc,yc);
	pcarp2b->SetLineColor(1);
	colo = (int)(10. - card2b * 8.);
	pcarp2b->SetFillColor(colo);
	pcarp2b->SetLineWidth(1);
	pcarp2b->Draw("f");
	pcarp2b->Draw();
	//
	// CARD3
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + (xc1[i]-0.0025)*var.sfx;
	    yc[i] = ycat + yc1[i]*var.sfy;
	};
	TPolyLine *pcars3 = new TPolyLine(5,xc,yc);
	pcars3->SetLineColor(1);
	colo = 10;
	if ( card3 != 0. || card3b != 0. ) {
	    if ( card3 > 0 || card3b > 0 ||  card3==-.25 || card3b ==-.25){
		colo = cattime;
	    } else {
		colo = catnoti;
	    };
	}; 
	pcars3->SetFillColor(colo);
	pcars3->SetLineWidth(1);
	pcars3->Draw("f");
	pcars3->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + (xc2[i]-0.0025)*var.sfx;
	    yc[i] = ycat + yc2[i]*var.sfy;
	};
	TPolyLine *pcarp3 = new TPolyLine(5,xc,yc);
	pcarp3->SetLineColor(1);
	colo = (int)(10. - card3 * 8.);
	pcarp3->SetFillColor(colo);
	pcarp3->SetLineWidth(1);
	pcarp3->Draw("f");
	pcarp3->Draw();
	//
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xcat + (xc3[i]-0.0025)*var.sfx;
	    yc[i] = ycat + yc3[i]*var.sfy;
	};
	TPolyLine *pcarp3b = new TPolyLine(5,xc,yc);
	pcarp3b->SetLineColor(1);
	colo = (int)(10. - card3b * 8.);
	pcarp3b->SetFillColor(colo);
	pcarp3b->SetLineWidth(1);
	pcarp3b->Draw("f");
	pcarp3b->Draw();

	//
	// CARD - X-view
	//
	Float_t cardcx = 0.143168*var.sfx;
	Float_t cardcy = 0.1475*var.sfy;
	Float_t acrdx[4] = {-lcrd*cos(alfa), lcrd*cos(alfa), -lcrd*cos(alfa)+wcrd*sin(alfa), -lcrd*cos(alfa)};
	Float_t acrdy[4] = {-lcrd*sin(alfa), lcrd*sin(alfa), -lcrd*sin(alfa)-wcrd*cos(alfa), -lcrd*sin(alfa)};
	Float_t bcrdx[4] = { lcrd*cos(alfa), lcrd*cos(alfa)+wcrd*sin(alfa), -lcrd*cos(alfa)+wcrd*sin(alfa), lcrd*cos(alfa)};
	Float_t bcrdy[4] = { lcrd*sin(alfa), lcrd*sin(alfa)-wcrd*cos(alfa), -lcrd*sin(alfa)-wcrd*cos(alfa), lcrd*sin(alfa)};

	//
	// CARD3  X/  Y
	//
	Float_t xcc[4];     
	Float_t ycc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = cardcx + var.xxvc + acrdx[i]*var.sfx;
	    ycc[i] = cardcy + var.yxvc + (0.36 + acrdy[i])*var.sfy;
	};
	TPolyLine *fcard3 = new TPolyLine(4,xcc,ycc);
	fcard3->SetLineColor(1);
	colo = (int)(10. - card3 * 8.);
	fcard3->SetFillColor(colo);
	fcard3->SetLineWidth(1);
	fcard3->Draw("f");
	fcard3->Draw();
	//
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = cardcx + var.xxvc + bcrdx[i]*var.sfx;
	    ycc[i] = cardcy + var.yxvc + (0.36 + bcrdy[i])*var.sfy;
	};
	TPolyLine *fcard3b = new TPolyLine(4,xcc,ycc);
	fcard3b->SetLineColor(1);
	colo = (int)(10. - card3b * 8.);
	fcard3b->SetFillColor(colo);
	fcard3b->SetLineWidth(1);
	fcard3b->Draw("f");
	fcard3b->Draw();

	//
	// CARD2  \X  Y
	//
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = -cardcx + var.xxvc - acrdx[i]*var.sfx;
	    ycc[i] = cardcy + var.yxvc + (0.36 + acrdy[i])*var.sfy;
	};
	TPolyLine *fcard2 = new TPolyLine(4,xcc,ycc);
	fcard2->SetLineColor(1);
	colo = (int)(10. - card2 * 8.);
	fcard2->SetFillColor(colo);
	fcard2->SetLineWidth(1);
	fcard2->Draw("f");
	fcard2->Draw();
	//
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = -cardcx  + var.xxvc - bcrdx[i]*var.sfx;
	    ycc[i] = cardcy  + var.yxvc + (0.36 + bcrdy[i])*var.sfy;
	};
	TPolyLine *fcard2b = new TPolyLine(4,xcc,ycc);
	fcard2b->SetLineColor(1);
	colo = (int)(10. - card2b * 8.);
	fcard2b->SetFillColor(colo);
	fcard2b->SetLineWidth(1);
	fcard2b->Draw("f");
	fcard2b->Draw();
    };

    if ( true ){
	Float_t acrdx[4] = {-lcrd*cos(alfa), lcrd*cos(alfa), -lcrd*cos(alfa)+wcrd*sin(alfa), -lcrd*cos(alfa)};
	Float_t acrdy[4] = {-lcrd*sin(alfa), lcrd*sin(alfa), -lcrd*sin(alfa)-wcrd*cos(alfa), -lcrd*sin(alfa)};
	Float_t bcrdx[4] = { lcrd*cos(alfa), lcrd*cos(alfa)+wcrd*sin(alfa), -lcrd*cos(alfa)+wcrd*sin(alfa), lcrd*cos(alfa)};
	Float_t bcrdy[4] = { lcrd*sin(alfa), lcrd*sin(alfa)-wcrd*cos(alfa), -lcrd*sin(alfa)-wcrd*cos(alfa), lcrd*sin(alfa)};
	//
	// CARD - Y-view
	//
	Float_t cardcx = 0.12*var.sfx;
	Float_t cardcy = 0.1475*var.sfy;
	//
	// CARD4  X  Y/
	//
	Float_t xcc[4];     
	Float_t ycc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = cardcx + var.xyvc + acrdx[i]*var.sfx;
	    ycc[i] = cardcy + var.yyvc + (0.36 + acrdy[i])*var.sfy;
	};
	TPolyLine *fcard4 = new TPolyLine(4,xcc,ycc);
	fcard4->SetLineColor(1);
	colo = (int)(10. - card4 * 8.);
	fcard4->SetFillColor(colo);
	fcard4->SetLineWidth(1);
	fcard4->Draw("f");
	fcard4->Draw();
	//
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = cardcx + var.xyvc + bcrdx[i]*var.sfx;
	    ycc[i] = cardcy + var.yyvc + (0.36 + bcrdy[i])*var.sfy;
	};
	TPolyLine *fcard4b = new TPolyLine(4,xcc,ycc);
	fcard4b->SetLineColor(1);
	colo = (int)(10. - card4b * 8.);
	fcard4b->SetFillColor(colo);
	fcard4b->SetLineWidth(1);
	fcard4b->Draw("f");
	fcard4b->Draw();

	//
	// CARD1  X  \Y
	//
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = -cardcx + var.xyvc - acrdx[i]*var.sfx;
	    ycc[i] = cardcy  + var.yyvc + (0.36 + acrdy[i])*var.sfy;
	};
	TPolyLine *fcard1 = new TPolyLine(4,xcc,ycc);
	fcard1->SetLineColor(1);
	colo = (int)(10. - card1 * 8.);
	fcard1->SetFillColor(colo);
	fcard1->SetLineWidth(1);
	fcard1->Draw("f");
	fcard1->Draw();
	//
	for (Int_t i = 0; i<4 ; i++) {
	    xcc[i] = -cardcx + var.xyvc - bcrdx[i]*var.sfx;
	    ycc[i] = cardcy + var.yyvc + (0.36 + bcrdy[i])*var.sfy;
	};
	TPolyLine *fcard1b = new TPolyLine(4,xcc,ycc);
	fcard1b->SetLineColor(1);
	colo = (int)(10. - card1b * 8.);
	fcard1b->SetFillColor(colo);
	fcard1b->SetLineWidth(1);
	fcard1b->Draw("f");
	fcard1b->Draw();
    };
}

void ShowTOF(Int_t j, TTree *otr, Variables & var){
    //
    // get the trigger infos
    //
    pamela::trigger::TriggerEvent  *trigger = 0;
    otr->SetBranchAddress("Trigger.Event", &trigger);
    if ( !var.nosig ) otr->GetEntry(j);
    //

    //
    // on day these variables will contain the MIP value for each paddle
    //
    Float_t ms11a[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12a[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21a[2] = {0.,0.};
    Float_t ms22a[2] = {0.,0.};
    Float_t ms31a[3] = {0.,0.,0.};
    Float_t ms32a[3] = {0.,0.,0.};
    Float_t ms11b[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12b[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21b[2] = {0.,0.};
    Float_t ms22b[2] = {0.,0.};
    Float_t ms31b[3] = {0.,0.,0.};
    Float_t ms32b[3] = {0.,0.,0.};
    //
    // TDC info for each PMT
    //
    Float_t mt11[2][8];
    Float_t mt12[2][6];
    Float_t mt21[2][2];
    Float_t mt22[2][2];
    Float_t mt31[2][3];
    Float_t mt32[2][3];
    //
    Int_t S3 = 0;
    Int_t S2 = 0;
    Int_t S12 = 0;
    Int_t S11 = 0;
    if ( !var.nosig ) {
	S3 = trigger->patterntrig[2];
	S2 = trigger->patterntrig[3];
	S12 = trigger->patterntrig[4];
	S11 = trigger->patterntrig[5];
    };
    //
    for ( Int_t i = 0; i<8; i++ ) {
	if ( S11 & (1<<i) ){ 
	    ms11a[i] = 1.;
	}
	if ( S11 & (1<<(i+8) ) ){ 
	    ms11b[i] = 1.;
	}
    };
    for ( Int_t i = 0; i<6; i++ ) {
	if ( S12 & (1<<i) ) {
	    ms12a[i] = 1.;
	}
	if ( S12 & (1<<(i+6)) ) {
	    ms12b[i] = 1.;
	}
    };
    Int_t ii = 2;
    for ( Int_t i = 0; i<2; i++ ) {
	ii--;
	if ( S2 & (1<<i) ) {
	    ms21a[ii] = 1.;
	}
	if ( S2 & (1<<(i+2)) ) {
	    ms21b[ii] = 1.;
	}
    };
    for ( Int_t i = 4; i<6; i++ ) {
	if ( S2 & (1<<i) ) {
	    ms22a[i-4] = 1.;
	}
	if ( S2 & (1<<(i+2)) ) {
	    ms22b[i-4] = 1.;
	}
    };
    for ( Int_t i = 0; i<3; i++ ) {
	if ( S3 & (1<<i) ) {
	    ms31a[i] = 1.;
	}
	if ( S3 & (1<<(i+3)) ) {
	    ms31b[i] = 1.;
	}
    };
    for ( Int_t i = 6; i<9; i++ ) {
	if ( S3 & (1<<i) ) {
	    ms32a[i-6] = 1.;
	}
	if ( S3 & (1<<(i+3)) ) {
	    ms32b[i-6] = 1.;
	}
    };
    //
    Int_t colo;
    Int_t ocolo;
    Float_t xs2x = var.xxvc;
    Float_t ys2x = var.yxvc + 0.36*var.sfy;
    Float_t xs2y = var.xyvc;
    Float_t ys2y = var.yyvc + 0.36*var.sfy;
    Float_t ws2 = 0.005;
    Float_t ws13 = 0.007;
    Int_t noadc = 12;
    if ( var.bw ){
	noadc=12;
    } else {
	noadc=41;
    };
    //
    // S11  X-view
    //
    // A     
    Float_t s11p = 0.051;
    ocolo = 10;
    TPolyLine *ftof11xa[8];
    for ( Int_t j=0; j<8; j++){
	Float_t xc1[4]={ (s11p*j),       (s11p*j),               s11p*(j+1),     (s11p*j)};
	Float_t yc1[4]={ 0.,                       ws13,     ws13,    0.};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2x + (-0.204+xc1[i])*var.sfx;
	    yc[i] = ys2x + (0.295+yc1[i])*var.sfy;
	};
	ftof11xa[j] = new TPolyLine(4,xc,yc);
	ftof11xa[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms11a[j],colo);	
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt11[0][j] == 4095. ) colo = noadc;
	//
	ftof11xa[j]->SetFillColor(colo);
	ftof11xa[j]->SetLineWidth(1);
	ftof11xa[j]->Draw("f");
	ftof11xa[j]->Draw();
    };
    // B
    s11p = 0.051;
    TPolyLine *ftof11xb[8];
    for ( Int_t j=0; j<8; j++){
	Float_t xc1[4]={ (s11p*j),       s11p*(j+1),               s11p*(j+1),     (s11p*j)};
	Float_t yc1[4]={ 0.,         0.,                ws13,      0.};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2x + (-0.204+xc1[i])*var.sfx;
	    yc[i] = ys2x + (0.295+yc1[i])*var.sfy;
	};
	ftof11xb[j] = new TPolyLine(4,xc,yc);
	ftof11xb[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms11b[j],colo);	
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt11[1][j] == 4095. ) colo = noadc;
	//
	ftof11xb[j]->SetFillColor(colo);
	ftof11xb[j]->SetLineWidth(1);
	ftof11xb[j]->Draw("f");
	ftof11xb[j]->Draw();
    };

    //
    // S11  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.165,       0.165,               0.165,     -0.165,    -0.165};
	Float_t nyc1[5]={ 0.,         0.,                ws13,    ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof11y = new TPolyLine(5,nxc,nyc);
	ftof11y->SetLineColor(1);
	ftof11y->SetFillColor(ocolo);
	ftof11y->SetLineWidth(1);
	ftof11y->Draw("f");
	ftof11y->Draw();
    };
    
    //
    // S12  Y-view
    //
    // A
    Float_t s12p = 0.055;
    ocolo = 10;
    TPolyLine *ftof12ya[6];
    for ( Int_t j=0; j<6; j++){
	Float_t xc1[4]={ (s12p*j),       s12p*(j),               s12p*(j+1),     (s12p*j)};
	Float_t yc1[4]={      -ws13,     0.,  0., -ws13};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2y + (-0.165+xc1[i])*var.sfx;
	    yc[i] = ys2y + (0.295+yc1[i])*var.sfy;
	};
	ftof12ya[j] = new TPolyLine(4,xc,yc);
	ftof12ya[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms12a[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt12[0][j] == 4095. ) colo = noadc;
	//
	ftof12ya[j]->SetFillColor(colo);
	ftof12ya[j]->SetLineWidth(1);
	ftof12ya[j]->Draw("f");
	ftof12ya[j]->Draw();
    };
    // B
    s12p = 0.055;
    TPolyLine *ftof12yb[6];
    for ( Int_t j=0; j<6; j++){
	Float_t xc1[4]={ (s12p*j),       s12p*(j+1),               s12p*(j+1),     (s12p*j)};
	Float_t yc1[4]={ -ws13,     -ws13,    0., -ws13};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2y + (-0.165+xc1[i])*var.sfx;
	    yc[i] = ys2y + (0.295+yc1[i])*var.sfy;
	};
	ftof12yb[j] = new TPolyLine(4,xc,yc);
	ftof12yb[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms12b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt12[1][j] == 4095. ) colo = noadc;
	//
	ftof12yb[j]->SetFillColor(colo);
	ftof12yb[j]->SetLineWidth(1);
	ftof12yb[j]->Draw("f");
	ftof12yb[j]->Draw();
    };
    //
    // S12  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.204,       0.204,               0.204,     -0.204,    -0.204};
	Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof12x = new TPolyLine(5,nxc,nyc);
	ftof12x->SetLineColor(1);
	ftof12x->SetFillColor(ocolo);
	ftof12x->SetLineWidth(1);
	ftof12x->Draw("f");
	ftof12x->Draw();
    };

    //
    // S21  Y-view
    //
    // A 
    Float_t s21p = 0.075;
    ocolo = 10;
    TPolyLine *ftof21ya[2];
    for ( Int_t j=0; j<2; j++){
	Float_t xc1[4]={ s21p*(j-1),       s21p*(j-1),               s21p*j,     s21p*(j-1)};
	Float_t yc1[4]={ 0.,                ws2,     ws2,    0.};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2y + xc1[i]*var.sfx;
	    yc[i] = ys2y + yc1[i]*var.sfy;
	};
	ftof21ya[j] = new TPolyLine(4,xc,yc);
	ftof21ya[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms21a[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt21[0][j] == 4095. ) colo = noadc;
	//
	ftof21ya[j]->SetFillColor(colo);
	ftof21ya[j]->SetLineWidth(1);
	ftof21ya[j]->Draw("f");
	ftof21ya[j]->Draw();
    };
    // B
    s21p = 0.075;
    TPolyLine *ftof21yb[2];
    for ( Int_t j=0; j<2; j++){
	Float_t xc1[4]={ s21p*(j-1),       s21p*j,               s21p*j,     s21p*(j-1)};
	Float_t yc1[4]={ 0.,         0.,                ws2,         0.};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2y + xc1[i]*var.sfx;
	    yc[i] = ys2y + yc1[i]*var.sfy;
	};
	ftof21yb[j] = new TPolyLine(4,xc,yc);
	ftof21yb[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms21b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt21[1][j] == 4095. ) colo = noadc;
	//
	ftof21yb[j]->SetFillColor(colo);
	ftof21yb[j]->SetLineWidth(1);
	ftof21yb[j]->Draw("f");
	ftof21yb[j]->Draw();
    };
    //
    // S21  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
	Float_t nyc1[5]={ 0.,         0.,                ws2,    ws2,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + nyc1[i]*var.sfy;
	};
	TPolyLine *ftof21x = new TPolyLine(5,nxc,nyc);
	ftof21x->SetLineColor(1);
	ftof21x->SetFillColor(ocolo);
	ftof21x->SetLineWidth(1);
	ftof21x->Draw("f");
	ftof21x->Draw();
    };
    //
    // S22  X-view
    //
    // A 
    Float_t s22p = 0.090;
    ocolo = 10;
    TPolyLine *ftof22xa[2];
    for ( Int_t j=0; j<2; j++){
	Float_t xc1[4]={ s22p*(j-1),       s22p*(j-1),               s22p*j,     s22p*(j-1)};
	Float_t yc1[4]={                -ws2,   0., 0.,  -ws2};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2x + xc1[i]*var.sfx;
	    yc[i] = ys2x + yc1[i]*var.sfy;
	};
	ftof22xa[j] = new TPolyLine(4,xc,yc);
	ftof22xa[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms22a[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt22[0][j] == 4095. ) colo = noadc;
	//
	ftof22xa[j]->SetFillColor(colo);
	ftof22xa[j]->SetLineWidth(1);
	ftof22xa[j]->Draw("f");
	ftof22xa[j]->Draw();
    };
    // B 
    s22p = 0.090;
    TPolyLine *ftof22xb[2];
    for ( Int_t j=0; j<2; j++){
	Float_t xc1[4]={ s22p*(j-1),       s22p*j,               s22p*j,     s22p*(j-1)};
	Float_t yc1[4]={ -ws2,     -ws2,    0., -ws2};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2x + xc1[i]*var.sfx;
	    yc[i] = ys2x + yc1[i]*var.sfy;
	};
	ftof22xb[j] = new TPolyLine(4,xc,yc);
	ftof22xb[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms22b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt22[1][j] == 4095. ) colo = noadc;
	//
	ftof22xb[j]->SetFillColor(colo);
	ftof22xb[j]->SetLineWidth(1);
	ftof22xb[j]->Draw("f");
	ftof22xb[j]->Draw();
    };
    //
    // S22  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
	Float_t nyc1[5]={ 0.,         0.,                -ws2,    -ws2,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + nyc1[i]*var.sfy;
	};
	TPolyLine *ftof22y = new TPolyLine(5,nxc,nyc);
	ftof22y->SetLineColor(1);
	ftof22y->SetFillColor(ocolo);
	ftof22y->SetLineWidth(1);
	ftof22y->Draw("f");
	ftof22y->Draw();
    };

    //
    // S31  X-view
    //
    // A 
    Float_t s31p = 0.060;
    ocolo = 10;
    TPolyLine *ftof31xa[3];
    for ( Int_t j=0; j<3; j++){
	Float_t xc1[4]={ (s31p*j),       (s31p*j),               s31p*(j+1),       (s31p*j)};
	Float_t yc1[4]={ 0.,                       ws13,     ws13,    0.};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2x + (-0.090+xc1[i])*var.sfx;
	    yc[i] = ys2x + (-0.488+yc1[i])*var.sfy;
	};
	ftof31xa[j] = new TPolyLine(4,xc,yc);
	ftof31xa[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms31a[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt31[0][j] == 4095. ) colo = noadc;
	//
	ftof31xa[j]->SetFillColor(colo);
	ftof31xa[j]->SetLineWidth(1);
	ftof31xa[j]->Draw("f");
	ftof31xa[j]->Draw();
    };
    // B 
    s31p = 0.060;
    TPolyLine *ftof31xb[3];
    for ( Int_t j=0; j<3; j++){
	Float_t xc1[4]={ (s31p*j),       s31p*(j+1),               s31p*(j+1),     (s31p*j)};
	Float_t yc1[4]={ 0.,                        0.,     ws13,    0.};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2x + (-0.090+xc1[i])*var.sfx;
	    yc[i] = ys2x + (-0.488+yc1[i])*var.sfy;
	};
	ftof31xb[j] = new TPolyLine(4,xc,yc);
	ftof31xb[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms31b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt31[1][j] == 4095. ) colo = noadc;
	//
	ftof31xb[j]->SetFillColor(colo);
	ftof31xb[j]->SetLineWidth(1);
	ftof31xb[j]->Draw("f");
	ftof31xb[j]->Draw();
    };
    //
    // S31  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
	Float_t nyc1[5]={ 0.,         0.,                 ws13,    ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof31y = new TPolyLine(5,nxc,nyc);
	ftof31y->SetLineColor(1);
	ftof31y->SetFillColor(ocolo);
	ftof31y->SetLineWidth(1);
	ftof31y->Draw("f");
	ftof31y->Draw();
    };
    //
    // S32  Y-view
    //
    Float_t s32p = 0.050;
    ocolo = 10;
    TPolyLine *ftof32ya[3];
    for ( Int_t j=0; j<3; j++){
	Float_t xc1[4]={ (s32p*j),       (s32p*j),               s32p*(j+1),     (s32p*j)};
	Float_t yc1[4]={     -ws13,     0.,    0., -ws13};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2y + (-0.075+xc1[i])*var.sfx;
	    yc[i] = ys2y + (-0.488+yc1[i])*var.sfy;
	};
	ftof32ya[j] = new TPolyLine(4,xc,yc);
	ftof32ya[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms32a[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt32[0][j] == 4095. ) colo = noadc;
	//
	ftof32ya[j]->SetFillColor(colo);
	ftof32ya[j]->SetLineWidth(1);
	ftof32ya[j]->Draw("f");
	ftof32ya[j]->Draw();
    };
    s32p = 0.050;
    TPolyLine *ftof32yb[3];
    for ( Int_t j=0; j<3; j++){
	Float_t xc1[4]={ (s32p*j),       s32p*(j+1),               s32p*(j+1),     (s32p*j)};
	Float_t yc1[4]={ -ws13,   -ws13,    0., -ws13};
	Float_t xc[4];     
	Float_t yc[4];
	for (Int_t i = 0; i<4 ; i++) {
	    xc[i]= xs2y + (-0.075+xc1[i])*var.sfx;
	    yc[i] = ys2y + (-0.488+yc1[i])*var.sfy;
	};
	ftof32yb[j] = new TPolyLine(4,xc,yc);
	ftof32yb[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms32b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	if ( mt32[1][j] == 4095. ) colo = noadc;
	//
	ftof32yb[j]->SetFillColor(colo);
	ftof32yb[j]->SetLineWidth(1);
	ftof32yb[j]->Draw("f");
	ftof32yb[j]->Draw();
    };
    //
    // S32  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
	Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof32x = new TPolyLine(5,nxc,nyc);
	ftof32x->SetLineColor(1);
	ftof32x->SetFillColor(ocolo);
	ftof32x->SetLineWidth(1);
	ftof32x->Draw("f");
	ftof32x->Draw();
    };
}

void ShowS4L0(Int_t i, TTree *otr, Variables & var){

    pamela::trigger::TriggerEvent  *trigger = 0;
    otr->SetBranchAddress("Trigger.Event", &trigger);
    if ( !var.nosig ) otr->GetEntry(i);

    Float_t ms4[3] = {0.,0.,0.};
    Int_t S4 = 0;
    if ( !var.nosig ) {
	S4 = trigger->patterntrig[1];
    };
    //
    for ( Int_t i = 0; i<3; i++ ) {
	if ( S4 & (1<<0) ) ms4[i] = 1.;
    };
    //    
    Int_t colo;
    Float_t xs4x = var.xxvc;
    Float_t ys4x = var.yxvc - 0.3250*var.sfy; //25
    Float_t xs4y = var.xyvc;
    Float_t ys4y = var.yyvc - 0.3250*var.sfy;
    Float_t ws4 = 0.010;

    //
    // Y-view
    //
    Float_t s4p = 0.1606667;
    Int_t ocolo = 0;
    TPolyLine *fs4y[3];
    for ( Int_t j=0; j<3; j++){
	Float_t xc1[5]={ (s4p*j),       s4p*(j+1),               s4p*(j+1),     (s4p*j),    (s4p*j)};
	Float_t yc1[5]={ 0.,         0.,               ws4,     ws4,    0.};
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xs4y + (-0.241+xc1[i])*var.nds4;
	    yc[i] = ys4y + (yc1[i]-0.03)*var.sfy;
	};
	fs4y[j] = new TPolyLine(5,xc,yc);
	fs4y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms4[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	fs4y[j]->SetFillColor(colo);
	fs4y[j]->SetLineWidth(1);
	fs4y[j]->Draw("f");
	fs4y[j]->Draw();
    };
    //
    // X-view
    //
    Float_t xc1[5]={ -0.241,       0.241,               0.241,     -0.241,    -0.241};
    Float_t yc1[5]={ 0.,         0.,                ws4,    ws4,    0.};
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xs4x + xc1[i]*var.nds4;
	yc[i] = ys4x + (yc1[i]-0.03)*var.sfy;
    };
    TPolyLine *fs4x = new TPolyLine(5,xc,yc);
    fs4x->SetLineColor(1);
    fs4x->SetFillColor(ocolo);
    fs4x->SetLineWidth(1);
    fs4x->Draw("f");
    fs4x->Draw();
}

//**********************************************************************************
//                           LEVEL1        SUBROUTINES                            //
//**********************************************************************************

void ShowS4L1(Int_t i, TTree *otr, Variables & var){

    pamela::S4::S4Event  *s4 = 0;
    otr->SetBranchAddress("S4.Event", &s4);
    if ( !var.nosig ) otr->GetEntry(i);

    Float_t ms4[3] = {0.,0.,0.};
    Int_t data = 0;
    if ( !var.nosig ) {
	data = s4->S4_DATA;
    };
    //
    Float_t calibdata;
    if ( !s4->unpackError && data > 31 ){
	calibdata = ((Float_t)data - 32.) * 0.5;
    } else {
	calibdata = 0.;
    };
    var.s4sig = calibdata;
    //
    for ( Int_t j = 0; j<3; j++ ) {	    
	ms4[j] = calibdata;
    };    
    Int_t colo;
    Float_t xs4x = var.xxvc;
    Float_t ys4x = var.yxvc - 0.3250*var.sfy;
    Float_t xs4y = var.xyvc;
    Float_t ys4y = var.yyvc - 0.3250*var.sfy;
    Float_t ws4 = 0.010;
    //
    // Y-view
    //
    Float_t s4p = 0.1606667;
    Int_t ocolo = 0;
    TPolyLine *fs4y[3];
    for ( Int_t j=0; j<3; j++){
	Float_t xc1[5]={ (s4p*j),       s4p*(j+1),               s4p*(j+1),     (s4p*j),    (s4p*j)};
	Float_t yc1[5]={ 0.,         0.,               ws4,     ws4,    0.};
	Float_t xc[5];     
	Float_t yc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    xc[i]= xs4y + (-0.241+xc1[i])*var.nds4;
	    yc[i] = ys4y + (yc1[i]-0.03)*var.sfy;
	};
	fs4y[j] = new TPolyLine(5,xc,yc);
	fs4y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms4[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	fs4y[j]->SetFillColor(colo);
	fs4y[j]->SetLineWidth(1);
	fs4y[j]->Draw("f");
	fs4y[j]->Draw();
    };
    //
    // X-view
    //
    Float_t xc1[5]={ -0.241,       0.241,               0.241,     -0.241,    -0.241};
    Float_t yc1[5]={ 0.,         0.,                ws4,    ws4,    0.};
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xs4x + xc1[i]*var.nds4;
	yc[i] = ys4x + (yc1[i]-0.03)*var.sfy;
    };
    TPolyLine *fs4x = new TPolyLine(5,xc,yc);
    fs4x->SetLineColor(1);
    fs4x->SetFillColor(ocolo);
    fs4x->SetLineWidth(1);
    fs4x->Draw("f");
    fs4x->Draw();
}

void ShowCaloL1(Int_t i, TTree *otr, Variables & var){
    //
    CalorimeterLevel1 *calo = new CalorimeterLevel1();
    otr->SetBranchAddress("CaloLevel1.Event", &calo);
    if ( !var.nosig ) otr->GetEntry(i);
    //
    // Book the histograms:
    //
    //
    stringstream xview;
    stringstream yview;
    xview.str("");
    yview.str("");
    xview << "x-view event " << (i+1);
    yview << "y-view event " << (i+1);
    gDirectory->Delete(xview.str().c_str());
    gDirectory->Delete(yview.str().c_str());
    TH2F *Xview = new TH2F(xview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
    TH2F *Yview = new TH2F(yview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
    Xview->GetYaxis()->SetLabelColor(10); 
    Yview->GetYaxis()->SetLabelColor(10); 
    //
    // figures:
    //
    Int_t bgcolor = 10;
    TPad *pd1 = new TPad("calox","This is pad1",var.xxvc-0.154*var.sfx,var.yxvc-0.3645*var.sfy,var.xxvc+0.154*var.sfx,var.yxvc-0.1200*var.sfy,bgcolor);
    TPad *pd2 = new TPad("caloy","This is pad2",var.xyvc-0.154*var.sfx,var.yyvc-0.3645*var.sfy,var.xyvc+0.154*var.sfx,var.yyvc-0.1200*var.sfy,bgcolor);

    pd1->SetFillStyle(4000);
    pd1->SetFillColor(0);
    pd1->SetFrameFillStyle(4000);
    pd2->SetFillStyle(4000);
    pd2->SetFillColor(0);
    pd2->SetFrameFillStyle(4000);

    TLatex *t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.03);
    t->SetTextAlign(12);
    pd1->Range(0.,0.,1.,1.);
    pd2->Range(0.,0.,1.,1.);
    pd1->SetTicks();
    pd2->SetTicks();
    pd1->Draw();
    pd2->Draw();
    
    pd1->cd();	   
    gStyle->SetOptStat(0);
    Xview->GetYaxis()->SetTitleOffset(0.5);
    Xview->SetFillColor(bgcolor);	    
    Xview->Fill(1.,1.,1.);	    
    Xview->Draw("box");
    pd1->Update();
    pd2->cd();
    gStyle->SetOptStat(0);
    Yview->GetYaxis()->SetTitleOffset(0.5);	
    Yview->SetFillColor(bgcolor);	    
    Yview->Fill(1.,1.,1.);	    
    Yview->Draw("box");
    pd2->Update();

    //
    // run over views and planes
    //
    stringstream xvev;
    stringstream yvev;    
    for (Int_t m = 0; m < 22; m++){
	for (Int_t l = 0; l < 2; l++){
	    for (Int_t n = 0; n < 96; n++){		    
		if ( calo->estrip[l][m][n] > 0.7 ) {
		    //
		    // OK, now in estrip we have the energy deposit in MIP of all the strips for this event (at the end of loops of course)
		    //
		    //		    if ( l == 0 && m == 21 ) printf(" xpos n=%i calo bottom: %f \n",n,(n*2.44-117.12)/10.);
		    Int_t colo;
		    if ( var.bw ){
			colo = -1;
		    } else {
			colo = 1;
		    };
		    ColorMIP(calo->estrip[l][m][n],colo);
		    if ( l == 0 && !var.nosig ) {
			xvev.str("");
			xvev << "x-view event " << n;
			xvev << " " << m;
			xvev << " " << l;
			gDirectory->Delete(xvev.str().c_str());
			TH2F *Xview = new TH2F(xvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
			Xview->SetFillColor(colo);
			Xview->Fill(n,21-m,1.);
			pd1->cd();				    
			Xview->Draw("box same");
		    };				    
		    if ( l == 1 && !var.nosig ) {			    
			yvev.str("");
			yvev << "y-view event " << n;
			yvev << " " << m;
			yvev << " " << l;
			gDirectory->Delete(yvev.str().c_str());
			TH2F *Yview = new TH2F(yvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);		  
			Yview->SetFillColor(colo);
			Yview->Fill(95-n,21-m,1.);
			pd2->cd();
			Yview->Draw("box same");
		    };
		};		    		
	    };
	};
    };
    pd1->Update();
    pd2->Update();
    var.qtot=(int)calo->qtot;
    var.nstrip=(int)calo->nstrip;
}

void ShowTRKL1(Int_t evno, TTree *ttr1, Variables & var){
    //
    Int_t syncro = 1;
    Int_t itr = evno;
    Int_t trnevents = ttr1->GetEntries();
    Int_t nodata = 0;
    Int_t pktnum = 0;
    Int_t obt = 0;
 trkcalosync: struct Tracklev1 trk;
    struct CTracklev1 ev2;
    settrklev1(ttr1,trk);
    if ( itr >= trnevents ){
	printf(" WARNING: no more tracker level1 data.\n");
	nodata = 1;
	goto goon;
    };
    if ( !var.nosig ) ttr1->GetEntry(itr);
    accesstrklev1(trk,ev2);
    pktnum = var.headc;
    obt = var.etime;
    if ( pktnum != ev2.pkt_num1 || obt != ev2.obt1 ){
	if ( pktnum > ev2.pkt_num1 || obt > ev2.obt1 ){
	    itr++;
	    if ( syncro ) printf(" WARNING: lost sync! try to recover... \n");
	    syncro = 0;		
	    goto trkcalosync;
	};
	if ( pktnum < ev2.pkt_num1 || obt < ev2.obt1 ){
	    printf(" WARNING: no tracker level2 data. \n");
	    nodata = 1;
	    goto goon;
	};
    };
    //
    if ( !syncro ) printf(" ...synchronization recovered! \n"); 
    syncro = 1;
    //
 goon: struct Trklev1 ev;
    ev.good1 = (Bool_t)ev2.good1;
    ev.nev1 = ev2.nev1;
    ev.pkt_type1 = ev2.pkt_type1;
    ev.pkt_num1 = ev2.pkt_num1;
    ev.obt1 = ev2.obt1;
    ev.which_calib1 = ev2.which_calib1;
    ev.nclstr1 = ev2.nclstr1;
    ev.totcllength = ev2.totcllength;
    for ( Int_t ii = 0 ; ii<8500; ii++){
	ev.clsignal[ii] = ev2.clsignal[ii];
    };
    for ( Int_t ii = 0 ; ii<500  ; ii++){
	ev.view[ii] = (Int_t)ev2.view[ii];
	ev.ladder[ii] = (Int_t)ev2.ladder[ii];
	ev.maxs[ii] = (Int_t)ev2.maxs[ii];
	ev.mult[ii] = (Int_t)ev2.mult[ii];
	ev.dedx[ii] = (Float_t)ev2.dedx[ii];
	ev.indstart[ii] = (Int_t)ev2.indstart[ii];
	ev.indmax[ii] = (Int_t)ev2.indmax[ii];
    };
    for ( Int_t ii = 0 ; ii<12 ; ii++){
    	for ( Int_t ij = 0 ; ij<24 ; ij++){	
	    ev.cnev[ij][ii] = ev2.cnev[ii][ij];
	};
    };       
    for ( Int_t ii = 0 ; ii<12 ; ii++){
    	for ( Int_t ij = 0 ; ij<3072 ; ij++){	
    	    ev.sigma_matrix[ij][ii] = var.DSPsig_par[ii][ij];
    	};
    };
    //
    // find the cluster, position and signal with the external fortran routine. We must pass the common.
    //
    if ( !nodata ){
	projectlev1(ev);
    } else {
	ev.nclstr1 = 0;
    };
    //
    //  a matrix of pads for each view x and y
    //
    TPad *trkpad[12];
    Int_t magcol = 0;
    TPad *mag1 = 0;
    TPad *mag2 = 0;
    for (Int_t n = 0; n<12; n++){
	stringstream spd;
	spd.str("");
	spd << "pd1" << n;
	gDirectory->Delete(spd.str().c_str());
	spd.str("");
	spd << "pd2" << n;
	gDirectory->Delete(spd.str().c_str());
	spd.str("");
	spd << "pd3" << n;
	gDirectory->Delete(spd.str().c_str());
	spd.str("");
	spd << "pd4" << n;
	gDirectory->Delete(spd.str().c_str());
	spd.str("");
	spd << "pd5" << n;
	gDirectory->Delete(spd.str().c_str());
	spd.str("");
	spd << "pd6" << n;
	gDirectory->Delete(spd.str().c_str());
	stringstream bpd;
	bpd.str("");
	if ( n%2 ) {	    
	    Float_t posx = var.xxvc;
    	    Float_t posy = var.yxvc + (0.29 - 0.089*((n/2.)-1.))*var.sfy;
	    spd.str("");
	    spd << "pd1" << n;
	    bpd.str("");
	    bpd << "bd1" << n;
	    trkpad[n] = new TPad(spd.str().c_str(),bpd.str().c_str(),posx-0.081*var.sfx,posy,posx+0.081*var.sfx,posy+0.089*var.sfy,10);
	    trkpad[n]->SetFillStyle(4000);
	    trkpad[n]->SetFillColor(0);
	    trkpad[n]->SetFrameFillStyle(4000);	    
	    trkpad[n]->Draw();
	    if ( n != 1 ) {
		if ( var.bw ) {
		    magcol = 1;
		} else {
		    magcol = 45;
		};
		spd.str("");
		spd << "pd2" << n;
		bpd.str("");
		bpd << "bd2" << n;
	    	mag1 = new TPad(spd.str().c_str(),bpd.str().c_str(),posx-(0.039+0.081)*var.sfx,posy+0.004*var.sfy,posx-0.081*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag1->SetFillStyle(3001);
		mag1->Draw();
		spd.str("");
		spd << "pd3" << n;
		bpd.str("");
		bpd << "bd3" << n;
	    	mag2 = new TPad(spd.str().c_str(),bpd.str().c_str(),posx+0.081*var.sfx,posy+0.004*var.sfy,posx+(0.081+0.039)*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag2->SetFillStyle(3001);
	    	mag2->Draw();
	    };
	} else {
	    Float_t posx = var.xyvc;
	    Float_t posy = var.yyvc + (0.29 - 0.089 * (((n+1.)/2.)-1.))*var.sfy;
	    spd.str("");
	    spd << "pd4" << n;
	    bpd.str("");
	    bpd << "bd4" << n;
	    trkpad[n] = new TPad(spd.str().c_str(),bpd.str().c_str(),posx-0.07*var.sfx,posy,posx+0.07*var.sfx,posy+0.089*var.sfy,10);
	    trkpad[n]->SetFillStyle(4000);
	    trkpad[n]->SetFillColor(0);
	    trkpad[n]->SetFrameFillStyle(4000);
	    trkpad[n]->Draw();
	    if ( n != 0 ) {
		if ( var.bw ) {
		    magcol = 1;
		} else {
		    magcol = 45;
		};
		spd.str("");
		spd << "pd5" << n;
		bpd.str("");
		bpd << "bd5" << n;
	     	mag1 = new TPad(spd.str().c_str(),bpd.str().c_str(),posx-(0.048+0.066)*var.sfx,posy+0.004*var.sfy,posx-0.066*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag1->SetFillStyle(3001);
	    	mag1->Draw();
		spd.str("");
		spd << "pd6" << n;
		bpd.str("");
		bpd << "bd6" << n;
	     	mag2 = new TPad(spd.str().c_str(),bpd.str().c_str(),posx+0.066*var.sfx,posy+0.004*var.sfy,posx+(0.066+0.048)*var.sfx,posy+0.088*var.sfy,magcol);
		if ( var.bw ) mag2->SetFillStyle(3001);
	    	mag2->Draw();
	    };
	};
    };
    TPad *trplv;
    gDirectory->Delete("trkplv");
    trplv = new TPad("trkplv","trkplv",var.xcat-0.07*var.sfx,var.ycat-0.081*var.sfy,var.xcat+0.07*var.sfx,var.ycat+0.081*var.sfy,10);
    trplv->SetFillStyle(4000);
    trplv->SetFillColor(0);
    trplv->SetFrameFillStyle(4000);
    trplv->Draw();
    Int_t sigcol1 = 17;
    Int_t sigcol2 = 15;
    Int_t linecol = 13;   
    if ( var.bw ) {
	sigcol1 = 17;
	sigcol2 = 15;
	linecol = 13;
    } else {
	sigcol1 = 32;
	sigcol2 = 38;
	linecol = 42;
    };
    //
    TLine *linea = 0;
    TLine *linea1x = 0;
    TLine *linea2x = 0;
    TLine *linea1y = 0;
    for (Int_t l = 0; l<12; l++){	
	trkpad[l]->cd();
	if ( l%2 ) { 
	    trkpad[l]->Range(-8.1,0.,8.1,1000.);			
	    linea = new TLine(-8.1,10.,8.1,10.);
	    linea1x = new TLine(-2.7,10.,-2.7,30.);	    
	    linea2x = new TLine(2.7,10.,2.7,30.);	    
	} else {
	    trkpad[l]->Range(-7.05,0.,7.05,1000.);
	    linea = new TLine(-7.05,10.,7.05,10.);
	    linea1y = new TLine(0.,10.,0.,30.);	    
	};
	linea->SetLineWidth(4);
	linea->SetLineColor(linecol);
	linea->Draw();
	if ( l%2 ) { 
	    linea1x->SetLineWidth(1);
	    linea1x->SetLineColor(1);
	    linea1x->Draw();
	    linea2x->SetLineWidth(1);
	    linea2x->SetLineColor(1);
	    linea2x->Draw();
	} else {
	    linea1y->SetLineWidth(1);
	    linea1y->SetLineColor(1);
	    linea1y->Draw();
	};
	//
    };
    Int_t planeno = 0;
    if ( !var.nosig ){	
	planeno = 0;
	Float_t x = 0.;
	Float_t y = 0.;
	for (Int_t l = 0; l<ev.nclstr1; l++){
	    for (Int_t m = 0; m<2; m++){	    
		if ( ev.clz[l][m] != 0. ){
		    if ( ev.clz[l][m] > 20. ) planeno = 1 - m;
		    if ( ev.clz[l][m] < 20. && ev.clz[l][m] > 10. ) planeno = 3 - m;
		    if ( ev.clz[l][m] < 10. && ev.clz[l][m] > 0.  ) planeno = 5 - m;
		    if ( ev.clz[l][m] < 0. && ev.clz[l][m] > -10. ) planeno = 7 - m;
		    if ( ev.clz[l][m] <-10. && ev.clz[l][m] >-20. ) planeno = 9 - m;
		    if ( ev.clz[l][m] < -20. ) planeno = 11 - m;
		    //
		    if ( (planeno+1)%2 ){
			trkpad[planeno]->cd();
			trkpad[planeno]->Range(-7.05,0.,7.05,1000.);
			if ( ev.cls[l][m] != 0. ){
			    x = ev.clp[l][1];
			    y = ev.cls[l][m];
			    linea = new TLine(x,0.,x,y);
			    linea->SetLineWidth(3);
			    linea->SetLineColor(sigcol1); 
			    linea->Draw();			
			    //
			    x = ev.clp[l][2];
			    linea = new TLine(x,0.,x,y);
			    linea->SetLineWidth(3);
			    linea->SetLineColor(sigcol2);
			    linea->Draw();
			    var.ncly++;
			};
		    } else {
			trkpad[planeno]->cd();
			trkpad[planeno]->Range(-8.1,0.,8.1,1000.);			
			if ( ev.cls[l][m] != 0. ){
			    x = ev.clp[l][0];
			    y = ev.cls[l][m];
			    linea = new TLine(x,0.,x,y);
			    linea->SetLineWidth(3);
			    linea->SetLineColor(sigcol2);
			    linea->Draw();
			    var.nclx++;
			};
		    };
		};    
	    };
	};
    };
    //
    // Show track in the plane view!
    //
    Float_t xh[6];
    Float_t yh1[6];
    Float_t yh2[6];    
    Float_t mag[6];
    Float_t xsig[6];
    Float_t ysig[6];
    Int_t mask[6];
    for (Int_t l = 0; l<6; l++ ){
	xh[l] = 0.;
	yh1[l] = 0.;
	yh2[l] = 0.;
	mag[l] = 0.;
	xsig[l] = 0.;
	ysig[l] = 0.;
	mask[l] = 0;
    };
    Int_t ncro = 0;
    //
    //    return;
    //
    for (Int_t l = 0; l<ev.nclstr1; l++){
	for (Int_t m = 0; m<2; m++){	    
	    if ( ev.clz[l][m] != 0. ){
		if ( ev.clz[l][m] > 20. ) {
		    planeno = 1 - m;
		    ncro = 0;
		};
		if ( ev.clz[l][m] < 20. && ev.clz[l][m] > 10. ) {
		    planeno = 3 - m;
		    ncro = 1;
		};
		if ( ev.clz[l][m] < 10. && ev.clz[l][m] > 0.  ) { 
		    planeno = 5 - m;
		    ncro = 2;
		};
		if ( ev.clz[l][m] < 0. && ev.clz[l][m] > -10. ) {
		    planeno = 7 - m;
		    ncro = 3;
		};
		if ( ev.clz[l][m] <-10. && ev.clz[l][m] >-20. ) {
		    planeno = 9 - m;
		    ncro = 4;
		};
		if ( ev.clz[l][m] < -20. ) {
		    planeno = 11 - m;
		    ncro = 5;
		}
		//
		mag[ncro] = ((float)planeno+1.)/5.;
		if ( (planeno+1)%2 ){
		    if ( ev.cls[l][m] > ysig[ncro] ){			
			ysig[ncro] = ev.cls[l][m];
			yh1[ncro] = ev.clp[l][1];
			yh2[ncro] = ev.clp[l][2];
		    };
		} else {
		    if ( ev.cls[l][m] > xsig[ncro] ){			
			xsig[ncro] = ev.cls[l][m];
			xh[ncro] = ev.clp[l][0];
		    };
		};
		if ( ysig[ncro] > 0. && xsig[ncro] > 0. ) {
		    mask[ncro] = 1;
		};		
	    };
	};
    };
    //
    // Draw crosses
    //
    trplv->cd();
    trplv->Range(-7.05,-8.1,7.05,8.1);
    for ( Int_t i = 0; i<6; i++){
	if ( mask[i] ){
	    //
	    Float_t cdx = (0.55/mag[i])*var.sfx;
	    Float_t cdy = (0.55/mag[i])*var.sfy;
	    Float_t lwx = (0.019)*var.sfy;
	    Float_t lwy = (0.019)*var.sfx;
	    //
	    linea = new TLine(yh1[i]-lwx/2.,xh[i]-cdy,yh1[i]-lwx/2.,xh[i]+cdy);
	    linea->SetLineWidth((int)lwx);
	    linea->SetLineColor(sigcol1);
	    linea->Draw();
	    linea = new TLine(yh1[i]-cdx,xh[i]-lwy/2.,yh1[i]+cdx,xh[i]-lwy/2.);
	    linea->SetLineWidth((int)lwy);
	    linea->SetLineColor(sigcol1);
	    linea->Draw();
	    //
	    linea = new TLine(yh2[i]-lwx/2.,xh[i]-cdy,yh2[i]-lwx/2.,xh[i]+cdy);
	    linea->SetLineWidth((int)lwx);
	    linea->SetLineColor(sigcol2);
	    linea->Draw();
	    linea = new TLine(yh2[i]-cdy,xh[i]-lwy/2.,yh2[i]+cdx,xh[i]-lwy/2.);
	    linea->SetLineWidth((int)lwy);
	    linea->SetLineColor(sigcol2);
	    linea->Draw();
	};
    };
}

void ShowTOFGENL1(Int_t j, TTree *otr, Variables & var){
    //
    // the channels MAP:
    //
    Int_t ch11a[8] = { 3, 3, 3, 3, 0, 0, 1, 1};
    Int_t hb11a[8] = { 0, 2, 4, 6, 9, 11, 1, 3};
    Int_t ch11b[8] = { 1, 1, 1, 1, 0, 0, 0, 0};
    Int_t hb11b[8] = { 5, 7, 11, 9, 7, 5, 3, 1};
    
    Int_t ch12a[6] = { 2, 2, 2, 2, 2, 2};
    Int_t hb12a[6] = { 1, 3, 5, 7, 9, 11};
    Int_t ch12b[6] = { 3, 3, 3, 3, 3, 3};
    Int_t hb12b[6] = { 11, 9, 7, 5, 3, 1};
    
    Int_t ch21a[2] = { 0, 0};
    Int_t hb21a[2] = { 0, 4};
    Int_t ch21b[2] = { 1, 0};
    Int_t hb21b[2] = { 8, 6};
    
    Int_t ch22a[2] = { 0, 0};
    Int_t hb22a[2] = { 2, 8};
    Int_t ch22b[2] = { 1, 0};
    Int_t hb22b[2] = { 10, 10};
    
    Int_t ch31a[3] = { 1, 2, 2};
    Int_t hb31a[3] = { 6, 8, 10};
    Int_t ch31b[3] = { 1, 1, 1};
    Int_t hb31b[3] = { 4, 2, 0};
    
    Int_t ch32a[3] = { 2, 2, 3};
    Int_t hb32a[3] = { 0, 4, 8};
    Int_t ch32b[3] = { 2, 2, 3};
    Int_t hb32b[3] = { 2, 6, 10};
    
    //
    pamela::tof::TofEvent  *tof = 0;
    otr->SetBranchAddress("Tof.Event", &tof);
    if ( !var.nosig ) otr->GetEntry(j);
    //
    // ADC values
    //
    Float_t ms11a[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12a[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21a[2] = {0.,0.};
    Float_t ms22a[2] = {0.,0.};
    Float_t ms31a[3] = {0.,0.,0.};
    Float_t ms32a[3] = {0.,0.,0.};
    Float_t ms11b[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12b[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21b[2] = {0.,0.};
    Float_t ms22b[2] = {0.,0.};
    Float_t ms31b[3] = {0.,0.,0.};
    Float_t ms32b[3] = {0.,0.,0.};
    //
    Float_t xp11[8];
    Float_t A11[8] = {-19.,-9.6,-25.7,-13.1,-30.9,-21.1,-11.7,-15.9};
    Float_t B11[8] = {-2.6,-2.6,-2.3,-2.4,-2.4,-2.8,-2.75,-2.5};
    Float_t E11[8] = {2.6,2.6,2.6,2.6,2.6,2.6,2.6,2.6};
    Float_t xp12[6];
    Float_t A12[6] = {11.6,16.6,5.9,-22.2,-18.0,-14.2};
    Float_t B12[6] = {-2.309,-2.424,-1.958,-2.092,-2.241,-2.144};
    Float_t E12[6] = {2.6,2.6,2.6,2.6,2.6,2.6};
    Float_t xp21[2];
    Float_t A21[2] = {12.5, 21.7};
    Float_t B21[2] = {-1.492,-1.519};
    Float_t E21[2] = {2.2,2.2};
    Float_t xp22[2];
    Float_t A22[2] = {-27.0, -45.8};
    Float_t B22[2] = {-1.897,-1.477};
    Float_t E22[2] = {2.9,2.9};
    Float_t xp31[3];
    Float_t A31[3] = {-25.1, -41.4, -33.9};
    Float_t B31[3] = {-3.374,-3.793,-3.495};
    Float_t E31[3] = {1.2,1.2,1.2};
    Float_t xp32[3];
    Float_t A32[3] = {1.3, 3.9, -22.0};
    Float_t B32[3] = {-3.134,-3.526,-3.417};
    Float_t E32[3] = {2.3,2.3,2.3};
    //
    // TDC info for each PMT
    //
    Float_t mt11[2][8];
    Float_t mt12[2][6];
    Float_t mt21[2][2];
    Float_t mt22[2][2];
    Float_t mt31[2][3];
    Float_t mt32[2][3];
    Int_t noadc = 12;
    if ( var.bw ){
	noadc = 12;
    } else {
	noadc = 41;
    };
    //
    Int_t ii = 0;
    if ( var.nosig ) goto draw; 
    for ( Int_t i = 0; i<8; i++ ) {
	mt11[0][i] = tof->tdc[ch11a[i]][hb11a[i]];
	mt11[1][i] = tof->tdc[ch11b[i]][hb11b[i]];
	ms11a[i] = tof->adc[ch11a[i]][hb11a[i]];
	ms11b[i] = tof->adc[ch11b[i]][hb11b[i]];
	xp11[i] = ( -A11[i] + (mt11[0][i]-mt11[1][i]) / 2. ) / B11[i] ;
	if ( ms11a[i] == 4095. ) {
	    ms11a[i] = 0.;
	} else {
	    ms11a[i] = 1.;
	};
	if ( ms11b[i] == 4095. ) {
	    ms11b[i] = 0.;
	} else {
	    ms11b[i] = 1.;
	};
    };
    for ( Int_t i = 0; i<6; i++ ) {
	mt12[0][i] = tof->tdc[ch12a[i]][hb12a[i]];
	mt12[1][i] = tof->tdc[ch12b[i]][hb12b[i]];
	ms12a[i] = tof->adc[ch12a[i]][hb12a[i]];
	ms12b[i] = tof->adc[ch12b[i]][hb12b[i]];
	xp12[i] = ( -A12[i] + (mt12[0][i]-mt12[1][i]) / 2. ) / B12[i] ;
	if ( ms12a[i] == 4095. ){
	    ms12a[i] = 0.;
	} else {
	    ms12a[i] = 1.;
	};
	if ( ms12b[i] == 4095. ){
	    ms12b[i] = 0.;
	} else {
	    ms12b[i] = 1.;
	};
    };    
    ii = 2;
    for ( Int_t i = 0; i<2; i++ ) {
	ii--;
	mt21[0][ii] = tof->tdc[ch21a[i]][hb21a[i]];
	mt21[1][ii] = tof->tdc[ch21b[i]][hb21b[i]];
	ms21a[ii] = tof->adc[ch21a[i]][hb21a[i]];
	ms21b[ii] = tof->adc[ch21b[i]][hb21b[i]];
	xp21[ii] = ( -A21[ii] + (mt21[0][ii]-mt21[1][ii]) / 2. ) / B21[ii] ;
	if ( ms21a[ii] == 4095. ){
	    ms21a[ii] = 0.;
	} else {
	    ms21a[ii] = 1.;
	};
	if ( ms21b[ii] == 4095. ){
	    ms21b[ii] = 0.;
	} else {
	    ms21b[ii] = 1.;
	};
    };
    for ( Int_t i = 0; i<2; i++ ) {
	mt22[0][i] = tof->tdc[ch22a[i]][hb22a[i]];
	mt22[1][i] = tof->tdc[ch22b[i]][hb22b[i]];
	ms22a[i] = tof->adc[ch22a[i]][hb22a[i]];
	ms22b[i] = tof->adc[ch22b[i]][hb22b[i]];
	xp22[i] = ( -A22[i] + (mt22[0][i]-mt22[1][i]) / 2. ) / B22[i] ;
	if ( ms22a[i] == 4095. ){
	    ms22a[i] = 0.;
	} else {
	    ms22a[i] = 1.;
	};
	if ( ms22b[i] == 4095. ){
	    ms22b[i] = 0.;
	} else {
	    ms22b[i] = 1.;
	};
    };
    for ( Int_t i = 0; i<3; i++ ) {
	mt31[0][i] = tof->tdc[ch31a[i]][hb31a[i]];
	mt31[1][i] = tof->tdc[ch31b[i]][hb31b[i]];
	ms31a[i] = tof->adc[ch31a[i]][hb31a[i]];
	ms31b[i] = tof->adc[ch31b[i]][hb31b[i]];
	xp31[i] = ( -A31[i] + (mt31[0][i]-mt31[1][i]) / 2. ) / B31[i] ;
	if ( ms31a[i] == 4095. ){
	    ms31a[i] = 0.;
	} else {
	    ms31a[i] = 1.;
	};
	if ( ms31b[i] == 4095. ){
	    ms31b[i] = 0.;
	} else {
	    ms31b[i] = 1.;
	};
    };
    for ( Int_t i = 0; i<3; i++ ) {
	mt32[0][i] = tof->tdc[ch32a[i]][hb32a[i]];
	mt32[1][i] = tof->tdc[ch32b[i]][hb32b[i]];
	ms32a[i] = tof->adc[ch32a[i]][hb32a[i]];
	ms32b[i] = tof->adc[ch32b[i]][hb32b[i]];
	xp32[i] = ( -A32[i] + (mt32[0][i]-mt32[1][i]) / 2. ) / B32[i] ;
	if ( ms32a[i] == 4095. ){
	    ms32a[i] = 0.;
	} else {
	    ms32a[i] = 1.;
	};
	if ( ms32b[i] == 4095. ){
	    ms32b[i] = 0.;
	} else {
	    ms32b[i] = 1.;
	};
    };
    //
 draw: Int_t colo = 0;
    Int_t ocolo = 0;
    Float_t xs2x = var.xxvc;
    Float_t ys2x = var.yxvc + 0.36*var.sfy;
    Float_t xs2y = var.xyvc;
    Float_t ys2y = var.yyvc + 0.36*var.sfy;
    Float_t ws2 = 0.005;
    Float_t ws13 = 0.007;
    //
    // S11  X-view
    //
    Float_t s11p = 0.051;
    ocolo = 10;
    TPolyLine *ftof11x[8];
    for ( Int_t j=0; j<8; j++){
	Float_t nxc1[5]={ (s11p*j),       (s11p*j),               s11p*(j+1),     s11p*(j+1), (s11p*j)};
	Float_t nyc1[5]={ 0.,                       ws13,     ws13,   0.,  0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + (-0.204+nxc1[i])*var.sfx;
	    nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
	};
	ftof11x[j] = new TPolyLine(5,nxc,nyc);
	ftof11x[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms11a[j]+ms11b[j],colo);	
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof11x[j]->SetFillColor(colo);
	ftof11x[j]->SetLineWidth(1);
	ftof11x[j]->Draw("f");
	ftof11x[j]->Draw();
    };
    //
    // S11  Y-view
    //
    Float_t nxc1[5]={ -0.165,       0.165,               0.165,     -0.165,    -0.165};
    Float_t nyc1[5]={ 0.,         0.,                ws13,    ws13,    0.};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + nxc1[i]*var.sfx;
	nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
    };
    TPolyLine *ftof11y = new TPolyLine(5,nxc,nyc);
    ftof11y->SetFillStyle(4000);
    ftof11y->SetFillColor(0);
    ftof11y->SetLineColor(1);
    ftof11y->SetLineWidth(1);
    ftof11y->Draw("f");
    ftof11y->Draw();
    TPolyLine *sftof11[8];
    for ( Int_t j=0; j<8; j++){
	if ( (mt11[0][j]<4095. || mt11[1][j]<4095.) && !var.nosig ){
	    if ( ocolo == 10 ) ocolo = noadc;
	    Float_t lowp = (xp11[j]-E11[j])/100.;
	    Float_t higp = (xp11[j]+E11[j])/100.;
	    if ( lowp < -0.164 ) lowp = -0.164;
	    if ( higp > 0.164 ) higp = 0.164;
	    if ( lowp < higp ){
		Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		Float_t nyc1[5]={ 0.0015,         0.0015,                ws13-0.0015,    ws13-0.0015,    0.0015};
		Float_t nxc[5];     
		Float_t nyc[5];
		for (Int_t i = 0; i<5 ; i++) {
		    nxc[i]= xs2y + nxc1[i]*var.sfx;
		    nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
		};
		sftof11[j] = new TPolyLine(5,nxc,nyc);
		sftof11[j]->SetLineColor(ocolo);
		sftof11[j]->SetFillColor(ocolo);
		sftof11[j]->SetLineWidth(1);
		sftof11[j]->Draw("f");
		sftof11[j]->Draw();
	    };
	};
    };

    //
    // S12  Y-view
    //
    Float_t s12p = 0.055;
    ocolo = 10;
    TPolyLine *ftof12y[6];
    for ( Int_t j=0; j<6; j++){
	Float_t nxc1[5]={ (s12p*j),       (s12p*j),               s12p*(j+1), s12p*(j+1),    (s12p*j)};
	Float_t nyc1[5]={      -ws13,     0.,  0., -ws13, -ws13};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + (-0.165+nxc1[i])*var.sfx;
	    nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
	};
	ftof12y[j] = new TPolyLine(5,nxc,nyc);
	ftof12y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms12a[j]+ms12b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof12y[j]->SetFillColor(colo);
	ftof12y[j]->SetLineWidth(1);
	ftof12y[j]->Draw("f");
	ftof12y[j]->Draw();
    };
    //
    // S12  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.204,       0.204,               0.204,     -0.204,    -0.204};
	Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof12x = new TPolyLine(5,nxc,nyc);
	ftof12x->SetLineColor(1);
	ftof12x->SetFillStyle(4000);
	ftof12x->SetFillColor(0);    
	ftof12x->SetLineWidth(1);
	ftof12x->Draw("f");
	ftof12x->Draw();
	TPolyLine *sftof12[6];
	for ( Int_t j=0; j<6; j++){
	    if ( (mt12[0][j]<4095. || mt12[1][j]<4095.) && !var.nosig  ){
		if ( ocolo == 10 ) ocolo = noadc;
		Float_t lowp = (xp12[j]-E12[j])/100.;
		Float_t higp = (xp12[j]+E12[j])/100.;
		if ( lowp < -0.203 ) lowp = -0.203;
		if ( higp > 0.203 ) higp = 0.203;
		if ( lowp < higp ){
		    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		    Float_t nyc1[5]={ -0.0015,         -0.0015,                -ws13+0.0015,    -ws13+0.0015,    -0.0015};
		    Float_t nxc[5];     
		    Float_t nyc[5];
		    for (Int_t i = 0; i<5 ; i++) {
			nxc[i]= xs2x + nxc1[i]*var.sfx;
			nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
		    };
		    sftof12[j] = new TPolyLine(5,nxc,nyc);
		    sftof12[j]->SetLineColor(ocolo);
		    sftof12[j]->SetFillColor(ocolo);
		    sftof12[j]->SetLineWidth(1);
		    sftof12[j]->Draw("f");
		    sftof12[j]->Draw();
		};
	    };
	};
    };
    //

    //
    // S21  Y-view
    //
    Float_t s21p = 0.075;
    ocolo = 10;
    TPolyLine *ftof21y[2];
    for ( Int_t j=0; j<2; j++){
	Float_t nxc1[5]={ s21p*(j-1),       s21p*(j-1),               s21p*j,s21p*j,     s21p*(j-1)};
	Float_t nyc1[5]={ 0.,                ws2,     ws2,  0.,  0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + nyc1[i]*var.sfy;
	};
	ftof21y[j] = new TPolyLine(5,nxc,nyc);
	ftof21y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms21a[j]+ms21b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof21y[j]->SetFillColor(colo);
	ftof21y[j]->SetLineWidth(1);
	ftof21y[j]->Draw("f");
	ftof21y[j]->Draw();
    };
    //
    // S21  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
	Float_t nyc1[5]={ 0.,         0.,                ws2,    ws2,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + nyc1[i]*var.sfy;
	};
	TPolyLine *ftof21x = new TPolyLine(5,nxc,nyc);
	ftof21x->SetLineColor(1);
	ftof21x->SetFillStyle(4000);
	ftof21x->SetFillColor(0);
	ftof21x->SetLineWidth(1);
	ftof21x->Draw("f");
	ftof21x->Draw();
	TPolyLine *sftof21[2];
	for ( Int_t j=0; j<2; j++){
	    if ( (mt21[0][j]<4095. || mt21[1][j]<4095.) && !var.nosig ){
		if ( ocolo == 10 ) ocolo = noadc;
		Float_t lowp = (xp21[j]-E21[j])/100.;
		Float_t higp = (xp21[j]+E21[j])/100.;
		if ( lowp < -0.089 ) lowp = -0.089;
		if ( higp > 0.089 ) higp = 0.089;
		if ( lowp < higp ){
		    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		    Float_t nyc1[5]={ 0.0015,         0.0015,                ws2-0.0015,    ws2-0.0015,    0.};
		    Float_t nxc[5];     
		    Float_t nyc[5];
		    for (Int_t i = 0; i<5 ; i++) {
			nxc[i]= xs2x + nxc1[i]*var.sfx;
			nyc[i] = ys2x + nyc1[i]*var.sfy;
		    };
		    sftof21[j] = new TPolyLine(5,nxc,nyc);
		    sftof21[j]->SetLineColor(ocolo);
		    sftof21[j]->SetFillColor(ocolo);
		    sftof21[j]->SetLineWidth(1);
		    sftof21[j]->Draw("f");
		    sftof21[j]->Draw();
		};
	    };
	};
    };
    //

    //
    // S22  X-view
    //
    Float_t s22p = 0.090;
    ocolo = 10;
    TPolyLine *ftof22x[2];
    for ( Int_t j=0; j<2; j++){
	Float_t nxc1[5]={ s22p*(j-1),       s22p*(j-1),               s22p*j, s22p*j,     s22p*(j-1)};
	Float_t nyc1[5]={                -ws2,   0., 0.,  -ws2,  -ws2};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + nyc1[i]*var.sfy;
	};
	ftof22x[j] = new TPolyLine(5,nxc,nyc);
	ftof22x[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms22a[j]+ms22b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof22x[j]->SetFillColor(colo);
	ftof22x[j]->SetLineWidth(1);
	ftof22x[j]->Draw("f");
	ftof22x[j]->Draw();
    };
    //
    // S22  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
	Float_t nyc1[5]={ 0.,         0.,                -ws2,    -ws2,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + nyc1[i]*var.sfy;
	};
	TPolyLine *ftof22y = new TPolyLine(5,nxc,nyc);
	ftof22y->SetLineColor(1);
	ftof22y->SetFillStyle(4000);
	ftof22y->SetFillColor(0);
	ftof22y->SetLineWidth(1);
	ftof22y->Draw("f");
	ftof22y->Draw();
	TPolyLine *sftof22[2];
	for ( Int_t j=0; j<2; j++){
	    if ( (mt22[0][j]<4095. || mt22[1][j]<4095.) && !var.nosig ){
		if ( ocolo == 10 ) ocolo = noadc;
		Float_t lowp = (xp22[j]-E22[j])/100.;
		Float_t higp = (xp22[j]+E22[j])/100.;
		if ( lowp < -0.074 ) lowp = -0.074;
		if ( higp > 0.074 ) higp = 0.074;
		if ( lowp < higp ){
		    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		    Float_t nyc1[5]={ -0.0015,         -0.0015,                -ws2+0.0015,    -ws2+0.0015,    -0.0015};
		    Float_t nxc[5];     
		    Float_t nyc[5];
		    for (Int_t i = 0; i<5 ; i++) {
			nxc[i]= xs2y + nxc1[i]*var.sfx;
			nyc[i] = ys2y + nyc1[i]*var.sfy;
		    };
		    sftof22[j] = new TPolyLine(5,nxc,nyc);
		    sftof22[j]->SetLineColor(ocolo);
		    sftof22[j]->SetFillColor(ocolo);
		    sftof22[j]->SetLineWidth(1);
		    sftof22[j]->Draw("f");
		    sftof22[j]->Draw();
		};
	    };
	};
    };
    //

    //
    // S31  X-view
    //
    Float_t s31p = 0.060;
    ocolo = 10;
    TPolyLine *ftof31x[3];
    for ( Int_t j=0; j<3; j++){
	Float_t nxc1[5]={ (s31p*j),       (s31p*j),               s31p*(j+1), s31p*(j+1),       (s31p*j)};
	Float_t nyc1[5]={ 0.,                       ws13,     ws13,    0.,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + (-0.090+nxc1[i])*var.sfx;
	    nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
	};
	ftof31x[j] = new TPolyLine(5,nxc,nyc);
	ftof31x[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms31a[j]+ms31b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof31x[j]->SetFillColor(colo);
	ftof31x[j]->SetLineWidth(1);
	ftof31x[j]->Draw("f");
	ftof31x[j]->Draw();
    };
    //
    // S31  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
	Float_t nyc1[5]={ 0.,         0.,                 ws13,    ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof31y = new TPolyLine(5,nxc,nyc);
	ftof31y->SetLineColor(1);
	ftof31y->SetFillStyle(4000);
	ftof31y->SetFillColor(0);
	ftof31y->SetLineWidth(1);
	ftof31y->Draw("f");
	ftof31y->Draw();
	TPolyLine *sftof31[3];
	for ( Int_t j=0; j<3; j++){
	    if ( (mt31[0][j]<4095. || mt31[1][j]<4095.) &&  !var.nosig){
		if ( ocolo == 10 ) ocolo = noadc;
		Float_t lowp = (xp31[j]-E31[j])/100.;
		Float_t higp = (xp31[j]+E31[j])/100.;
		if ( lowp < -0.074 ) lowp = -0.074;
		if ( higp > 0.074 ) higp = 0.074;
		if ( lowp < higp ){
		    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		    Float_t nyc1[5]={ 0.0015,         0.0015,                ws13-0.0015,    ws13-0.0015,    0.0015};
		    Float_t nxc[5];     
		    Float_t nyc[5];
		    for (Int_t i = 0; i<5 ; i++) {
			nxc[i]= xs2y + nxc1[i]*var.sfx;
			nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
		    };
		    sftof31[j] = new TPolyLine(5,nxc,nyc);
		    sftof31[j]->SetLineColor(ocolo);
		    sftof31[j]->SetFillColor(ocolo);
		    sftof31[j]->SetLineWidth(1);
		    sftof31[j]->Draw("f");
		    sftof31[j]->Draw();
		};
	    };
	};
    };
    //

    //
    // S32  Y-view
    //
    Float_t s32p = 0.050;
    ocolo = 10;
    TPolyLine *ftof32y[3];
    for ( Int_t j=0; j<3; j++){
	Float_t nxc1[5]={ (s32p*j),       (s32p*j),               s32p*(j+1),s32p*(j+1),     (s32p*j)};
	Float_t nyc1[5]={     -ws13,     0.,    0., -ws13, -ws13};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + (-0.075+nxc1[i])*var.sfx;
	    nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
	};
	ftof32y[j] = new TPolyLine(5,nxc,nyc);
	ftof32y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorMIP(ms32a[j]+ms32b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof32y[j]->SetFillColor(colo);
	ftof32y[j]->SetLineWidth(1);
	ftof32y[j]->Draw("f");
	ftof32y[j]->Draw();
    };
    //
    // S32  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
	Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof32x = new TPolyLine(5,nxc,nyc);
	ftof32x->SetLineColor(1);
	ftof32x->SetLineWidth(1);
	ftof32x->SetFillStyle(4000);
	ftof32x->SetFillColor(0);
	ftof32x->Draw("f");
	ftof32x->Draw();
	TPolyLine *sftof32[3];
	for ( Int_t j=0; j<3; j++){
	    if ( (mt32[0][j]<4095. || mt32[1][j]<4095.) && !var.nosig ){
		if ( ocolo == 10 ) ocolo = noadc;
		Float_t lowp = (xp32[j]-E32[j])/100.;
		Float_t higp = (xp32[j]+E32[j])/100.;
		if ( lowp < -0.089 ) lowp = -0.089;
		if ( higp > 0.089 ) higp = 0.089;
		if ( lowp < higp ){
		    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		    Float_t nyc1[5]={ -0.0015,         -0.0015,                -ws13+0.0015,    -ws13+0.0015,    -0.0015};
		    Float_t nxc[5];     
		    Float_t nyc[5];
		    for (Int_t i = 0; i<5 ; i++) {
			nxc[i]= xs2x + nxc1[i]*var.sfx;
			nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
		    };
		    sftof32[j] = new TPolyLine(5,nxc,nyc);
		    sftof32[j]->SetLineColor(ocolo);
		    sftof32[j]->SetFillColor(ocolo);
		    sftof32[j]->SetLineWidth(1);
		    sftof32[j]->Draw("f");
		    sftof32[j]->Draw();
		};
	    };
	};
    };
    //
}

void ShowTOFL1(Int_t j, TTree *toftr, Variables & var){
    //
    for (Int_t i=0 ; i<5; i++){
	var.beta[i] = 0.;
    };
    //
    struct Toflev1 ntof;
    settoflev1(toftr,ntof);
    //
    Int_t syncro = 1;
    Int_t itr = j;
    Int_t trnevents = toftr->GetEntries();
    Int_t pktnum = 0;
    Int_t obt = 0;
 trkcalosync: if ( itr >= trnevents ){
	printf(" WARNING: no more tof level1 data.\n");
	return;
    };
    if ( !var.nosig ) toftr->GetEntry(itr);
    pktnum = var.headc;
    obt = var.etime;
    if ( pktnum != ntof.pkt_num || obt != ntof.obt ){
	if ( pktnum > ntof.pkt_num || obt > ntof.obt ){
	    itr++;
	    if ( syncro ) printf(" WARNING: lost sync! try to recover... \n");
	    syncro = 0;		
	    goto trkcalosync;
	};
	if ( pktnum < ntof.pkt_num || obt < ntof.obt ){
	    printf(" WARNING: no tof level1 data. \n");
	    return;
	};
    };
    //
    if ( !syncro ) printf(" ...synchronization recovered! \n"); 	   
    syncro = 1;
    //
    if ( !var.nosig ) {
	for (Int_t i=0 ; i<5; i++){
	    if ( ntof.beta[i] < 100.) var.beta[i] = ntof.beta[i];
	};
    };
    struct CToflev1 tof;
    accesstoflev1(ntof,tof);
    //
    // the channels MAP:
    //
    Int_t ch11a[8] = { 3, 3, 3, 3, 0, 0, 1, 1};
    Int_t hb11a[8] = { 0, 2, 4, 6, 9, 11, 1, 3};
    Int_t ch11b[8] = { 1, 1, 1, 1, 0, 0, 0, 0};
    Int_t hb11b[8] = { 5, 7, 11, 9, 7, 5, 3, 1};
    
    Int_t ch12a[6] = { 2, 2, 2, 2, 2, 2};
    Int_t hb12a[6] = { 1, 3, 5, 7, 9, 11};
    Int_t ch12b[6] = { 3, 3, 3, 3, 3, 3};
    Int_t hb12b[6] = { 11, 9, 7, 5, 3, 1};
    
    Int_t ch21a[2] = { 0, 0};
    Int_t hb21a[2] = { 0, 4};
    Int_t ch21b[2] = { 1, 0};
    Int_t hb21b[2] = { 8, 6};
    
    Int_t ch22a[2] = { 0, 0};
    Int_t hb22a[2] = { 2, 8};
    Int_t ch22b[2] = { 1, 0};
    Int_t hb22b[2] = { 10, 10};
    
    Int_t ch31a[3] = { 1, 2, 2};
    Int_t hb31a[3] = { 6, 8, 10};
    Int_t ch31b[3] = { 1, 1, 1};
    Int_t hb31b[3] = { 4, 2, 0};
    
    Int_t ch32a[3] = { 2, 2, 3};
    Int_t hb32a[3] = { 0, 4, 8};
    Int_t ch32b[3] = { 2, 2, 3};
    Int_t hb32b[3] = { 2, 6, 10};

    //
    Float_t E11 = 2.6;
    Float_t E12 = 2.6;
    Float_t E21 = 2.2;
    Float_t E22 = 2.9;
    Float_t E31 = 1.2;
    Float_t E32 = 2.3;
    
    //
    // ADC values
    //
    Float_t ms11a[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12a[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21a[2] = {0.,0.};
    Float_t ms22a[2] = {0.,0.};
    Float_t ms31a[3] = {0.,0.,0.};
    Float_t ms32a[3] = {0.,0.,0.};
    Float_t ms11b[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12b[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21b[2] = {0.,0.};
    Float_t ms22b[2] = {0.,0.};
    Float_t ms31b[3] = {0.,0.,0.};
    Float_t ms32b[3] = {0.,0.,0.};
    //
    Float_t xp11 = 0.;
    Float_t xp12 = 0.;
    Float_t xp21 = 0.;
    Float_t xp22 = 0.;
    Float_t xp31 = 0.;
    Float_t xp32 = 0.;
    //
    Int_t noadc = 12;
    if ( var.bw ){
	noadc = 12;
    } else {
	noadc = 41;
    };
    //
    Int_t ii = 2;
    //
    if ( var.nosig ) goto draw; 
    xp11 = tof.ytof[0];
    for ( Int_t i = 0; i<8; i++ ) {
	if ( tof.adc_c[ch11a[i]][hb11a[i]] < 1000. ){
	    ms11a[i] = tof.adc_c[ch11a[i]][hb11a[i]]/2.;
	};	
	if ( tof.adc_c[ch11b[i]][hb11b[i]] < 1000. ){
	    ms11b[i] = tof.adc_c[ch11b[i]][hb11b[i]]/2.;
	};
    };
    xp12 = tof.xtof[0];
    for ( Int_t i = 0; i<6; i++ ) {
	if ( tof.adc_c[ch12a[i]][hb12a[i]] < 1000. ) ms12a[i] = tof.adc_c[ch12a[i]][hb12a[i]]/2.;
	if ( tof.adc_c[ch12b[i]][hb12b[i]] < 1000. ) ms12b[i] = tof.adc_c[ch12b[i]][hb12b[i]]/2.;
    };    
    xp21 = tof.xtof[1];
    ii = 2;
    for ( Int_t i = 0; i<2; i++ ) {
	ii--;
	if ( tof.adc_c[ch21a[i]][hb21a[i]] < 1000. ) ms21a[ii] = tof.adc_c[ch21a[i]][hb21a[i]]/2.;
	if ( tof.adc_c[ch21b[i]][hb21b[i]] < 1000. ) ms21b[ii] = tof.adc_c[ch21b[i]][hb21b[i]]/2.;
    };
    xp22 = tof.ytof[1];
    for ( Int_t i = 0; i<2; i++ ) {
	if ( tof.adc_c[ch22a[i]][hb22a[i]] < 1000. ) ms22a[i] = tof.adc_c[ch22a[i]][hb22a[i]]/2.;
	if ( tof.adc_c[ch22b[i]][hb22b[i]] < 1000. ) ms22b[i] = tof.adc_c[ch22b[i]][hb22b[i]]/2.;
    };
    xp31 = tof.ytof[2];
    for ( Int_t i = 0; i<3; i++ ) {
	if ( tof.adc_c[ch31a[i]][hb31a[i]] < 1000. ) ms31a[i] = tof.adc_c[ch31a[i]][hb31a[i]]/2.;
	if ( tof.adc_c[ch31b[i]][hb31b[i]] < 1000. ) ms31b[i] = tof.adc_c[ch31b[i]][hb31b[i]]/2.;
    };
    xp32 = tof.xtof[2];
    for ( Int_t i = 0; i<3; i++ ) {
	if ( tof.adc_c[ch32a[i]][hb32a[i]] < 1000. ) ms32a[i] = tof.adc_c[ch32a[i]][hb32a[i]]/2.;
	if ( tof.adc_c[ch32b[i]][hb32b[i]] < 1000. ) ms32b[i] = tof.adc_c[ch32b[i]][hb32b[i]]/2.;
    };
    //
 draw:
    //
    Int_t colo;
    Int_t ocolo;
    Float_t xs2x = var.xxvc;
    Float_t ys2x = var.yxvc + 0.36*var.sfy;
    Float_t xs2y = var.xyvc;
    Float_t ys2y = var.yyvc + 0.36*var.sfy;
    Float_t ws2 = 0.005;
    Float_t ws13 = 0.007;
    //
    // S11  X-view
    //
    Float_t s11p = 0.051;
    ocolo = 10;
    TPolyLine *ftof11x[8];
    for ( Int_t j=0; j<8; j++){
	Float_t nxc1[5]={ (s11p*j),       (s11p*j),               s11p*(j+1),     s11p*(j+1), (s11p*j)};
	Float_t nyc1[5]={ 0.,                       ws13,     ws13,   0.,  0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + (-0.204+nxc1[i])*var.sfx;
	    nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
	};
	ftof11x[j] = new TPolyLine(5,nxc,nyc);
	ftof11x[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorTOFMIP(ms11a[j]+ms11b[j],colo);	
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof11x[j]->SetFillColor(colo);
	ftof11x[j]->SetLineWidth(1);
	ftof11x[j]->Draw("f");
	ftof11x[j]->Draw();
    };
    //
    // S11  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.165,       0.165,               0.165,     -0.165,    -0.165};
	Float_t nyc1[5]={ 0.,         0.,                ws13,    ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof11y = new TPolyLine(5,nxc,nyc);
	ftof11y->SetFillStyle(4000);
	ftof11y->SetFillColor(0);
	ftof11y->SetLineColor(1);
	ftof11y->SetLineWidth(1);
	ftof11y->Draw("f");
	ftof11y->Draw();
	TPolyLine *sftof11;
	if ( !var.nosig ){
	    if ( ocolo == 10 ) ocolo = noadc;
	    Float_t lowp = (xp11-E11)/100.;
	    Float_t higp = (xp11+E11)/100.;
	    if ( lowp < -0.164 ) lowp = -0.164;
	    if ( higp > 0.164 ) higp = 0.164;
	    if ( lowp < higp ){
		Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		Float_t nyc1[5]={ 0.0015,         0.0015,                ws13-0.0015,    ws13-0.0015,    0.0015};
		Float_t nxc[5];     
		Float_t nyc[5];
		for (Int_t i = 0; i<5 ; i++) {
		    nxc[i]= xs2y + nxc1[i]*var.sfx;
		    nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
		};
		sftof11 = new TPolyLine(5,nxc,nyc);
		sftof11->SetLineColor(ocolo);
		sftof11->SetFillColor(ocolo);
		sftof11->SetLineWidth(1);
		sftof11->Draw("f");
		sftof11->Draw();
	    };
	};
    };

    //
    // S12  Y-view
    //
    Float_t s12p = 0.055;
    ocolo = 10;
    TPolyLine *ftof12y[6];
    for ( Int_t j=0; j<6; j++){
	Float_t nxc1[5]={ (s12p*j),       (s12p*j),               s12p*(j+1), s12p*(j+1),    (s12p*j)};
	Float_t nyc1[5]={      -ws13,     0.,  0., -ws13, -ws13};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + (-0.165+nxc1[i])*var.sfx;
	    nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
	};
	ftof12y[j] = new TPolyLine(5,nxc,nyc);
	ftof12y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorTOFMIP(ms12a[j]+ms12b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof12y[j]->SetFillColor(colo);
	ftof12y[j]->SetLineWidth(1);
	ftof12y[j]->Draw("f");
	ftof12y[j]->Draw();
    };
    //
    // S12  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.204,       0.204,               0.204,     -0.204,    -0.204};
	Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof12x = new TPolyLine(5,nxc,nyc);
	ftof12x->SetLineColor(1);
	ftof12x->SetFillStyle(4000);
	ftof12x->SetFillColor(0);    
	ftof12x->SetLineWidth(1);
	ftof12x->Draw("f");
	ftof12x->Draw();
	TPolyLine *sftof12;
	if (  !var.nosig  ){
	    if ( ocolo == 10 ) ocolo = noadc;
	    Float_t lowp = (xp12-E12)/100.;
	    Float_t higp = (xp12+E12)/100.;
	    if ( lowp < -0.203 ) lowp = -0.203;
	    if ( higp > 0.203 ) higp = 0.203;
	    if ( lowp < higp ){
		Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		Float_t nyc1[5]={ -0.0015,         -0.0015,                -ws13+0.0015,    -ws13+0.0015,    -0.0015};
		Float_t nxc[5];     
		Float_t nyc[5];
		for (Int_t i = 0; i<5 ; i++) {
		    nxc[i]= xs2x + nxc1[i]*var.sfx;
		    nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
		};
		sftof12 = new TPolyLine(5,nxc,nyc);
		sftof12->SetLineColor(ocolo);
		sftof12->SetFillColor(ocolo);
		sftof12->SetLineWidth(1);
		sftof12->Draw("f");
		sftof12->Draw();
	    };
	};
    };
    //

    //
    // S21  Y-view
    //
    Float_t s21p = 0.075;
    ocolo = 10;
    TPolyLine *ftof21y[2];
    for ( Int_t j=0; j<2; j++){
	Float_t nxc1[5]={ s21p*(j-1),       s21p*(j-1),               s21p*j,s21p*j,     s21p*(j-1)};
	Float_t nyc1[5]={ 0.,                ws2,     ws2,  0.,  0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + nyc1[i]*var.sfy;
	};
	ftof21y[j] = new TPolyLine(5,nxc,nyc);
	ftof21y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorTOFMIP(ms21a[j]+ms21b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof21y[j]->SetFillColor(colo);
	ftof21y[j]->SetLineWidth(1);
	ftof21y[j]->Draw("f");
	ftof21y[j]->Draw();
    };
    //
    // S21  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
	Float_t nyc1[5]={ 0.,         0.,                ws2,    ws2,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (0.0+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof21x = new TPolyLine(5,nxc,nyc);
	ftof21x->SetLineColor(1);
	ftof21x->SetFillStyle(4000);
	ftof21x->SetFillColor(0);
	ftof21x->SetLineWidth(1);
	ftof21x->Draw("f");
	ftof21x->Draw();
	TPolyLine *sftof21;
	if ( !var.nosig ){
	    if ( ocolo == 10 ) ocolo = noadc;
	    Float_t lowp = (xp21-E21)/100.;
	    Float_t higp = (xp21+E21)/100.;
	    if ( lowp < -0.089 ) lowp = -0.089;
	    if ( higp > 0.089 ) higp = 0.089;
	    if ( lowp < higp ){
		Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		Float_t nyc1[5]={ 0.0015,         0.0015,                ws2-0.0015,    ws2-0.0015,    0.};
		Float_t nxc[5];     
		Float_t nyc[5];
		for (Int_t i = 0; i<5 ; i++) {
		    nxc[i]= xs2x + nxc1[i]*var.sfx;
		    nyc[i] = ys2x + (0.0+nyc1[i])*var.sfy;
		};
		sftof21 = new TPolyLine(5,nxc,nyc);
		sftof21->SetLineColor(ocolo);
		sftof21->SetFillColor(ocolo);
		sftof21->SetLineWidth(1);
		sftof21->Draw("f");
		sftof21->Draw();
	    };
	};
    };
    //

    //
    // S22  X-view
    //
    Float_t s22p = 0.090;
    ocolo = 10;
    TPolyLine *ftof22x[2];
    for ( Int_t j=0; j<2; j++){
	Float_t nxc1[5]={ s22p*(j-1),       s22p*(j-1),               s22p*j, s22p*j,     s22p*(j-1)};
	Float_t nyc1[5]={                -ws2,   0., 0.,  -ws2,  -ws2};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (0.0+nyc1[i])*var.sfy;
	};
	ftof22x[j] = new TPolyLine(5,nxc,nyc);
	ftof22x[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorTOFMIP(ms22a[j]+ms22b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof22x[j]->SetFillColor(colo);
	ftof22x[j]->SetLineWidth(1);
	ftof22x[j]->Draw("f");
	ftof22x[j]->Draw();
    };
    //
    // S22  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
	Float_t nyc1[5]={ 0.,         0.,                -ws2,    -ws2,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + (0.0+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof22y = new TPolyLine(5,nxc,nyc);
	ftof22y->SetLineColor(1);
	ftof22y->SetFillStyle(4000);
	ftof22y->SetFillColor(0);
	ftof22y->SetLineWidth(1);
	ftof22y->Draw("f");
	ftof22y->Draw();
	TPolyLine *sftof22;
	if ( !var.nosig ){
	    if ( ocolo == 10 ) ocolo = noadc;
	    Float_t lowp = (xp22-E22)/100.;
	    Float_t higp = (xp22+E22)/100.;
	    if ( lowp < -0.074 ) lowp = -0.074;
	    if ( higp > 0.074 ) higp = 0.074;
	    if ( lowp < higp ){
		Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		Float_t nyc1[5]={ -0.0015,         -0.0015,                -ws2+0.0015,    -ws2+0.0015,    -0.0015};
		Float_t nxc[5];     
		Float_t nyc[5];
		for (Int_t i = 0; i<5 ; i++) {
		    nxc[i]= xs2y + nxc1[i]*var.sfx;
		    nyc[i] = ys2y + (0.0+nyc1[i])*var.sfy;
		};
		sftof22 = new TPolyLine(5,nxc,nyc);
		sftof22->SetLineColor(ocolo);
		sftof22->SetFillColor(ocolo);
		sftof22->SetLineWidth(1);
		sftof22->Draw("f");
		sftof22->Draw();
	    };
	};
    };
    //

    //
    // S31  X-view
    //
    Float_t s31p = 0.060;
    ocolo = 10;
    TPolyLine *ftof31x[3];
    for ( Int_t j=0; j<3; j++){
	Float_t nxc1[5]={ (s31p*j),       (s31p*j),               s31p*(j+1), s31p*(j+1),       (s31p*j)};
	Float_t nyc1[5]={ 0.,                       ws13,     ws13,    0.,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + (-0.090+nxc1[i])*var.sfx;
	    nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
	};
	ftof31x[j] = new TPolyLine(5,nxc,nyc);
	ftof31x[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorTOFMIP(ms31a[j]+ms31b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof31x[j]->SetFillColor(colo);
	ftof31x[j]->SetLineWidth(1);
	ftof31x[j]->Draw("f");
	ftof31x[j]->Draw();
    };
    //
    // S31  Y-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
	Float_t nyc1[5]={ 0.,         0.,                 ws13,    ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof31y = new TPolyLine(5,nxc,nyc);
	ftof31y->SetLineColor(1);
	ftof31y->SetFillStyle(4000);
	ftof31y->SetFillColor(0);
	ftof31y->SetLineWidth(1);
	ftof31y->Draw("f");
	ftof31y->Draw();
	TPolyLine *sftof31;
	if ( !var.nosig ){
	    if ( ocolo == 10 ) ocolo = noadc;
	    Float_t lowp = (xp31-E31)/100.;
	    Float_t higp = (xp31+E31)/100.;
	    if ( lowp < -0.074 ) lowp = -0.074;
	    if ( higp > 0.074 ) higp = 0.074;
	    if ( lowp < higp ){
		Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		Float_t nyc1[5]={ 0.0015,         0.0015,                ws13-0.0015,    ws13-0.0015,    0.0015};
		Float_t nxc[5];     
		Float_t nyc[5];
		for (Int_t i = 0; i<5 ; i++) {
		    nxc[i]= xs2y + nxc1[i]*var.sfx;
		    nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
		};
		sftof31 = new TPolyLine(5,nxc,nyc);
		sftof31->SetLineColor(ocolo);
		sftof31->SetFillColor(ocolo);
		sftof31->SetLineWidth(1);
		sftof31->Draw("f");
		sftof31->Draw();	    
	    };
	};
    };
    //

    //
    // S32  Y-view
    //
    Float_t s32p = 0.050;
    ocolo = 10;
    TPolyLine *ftof32y[3];
    for ( Int_t j=0; j<3; j++){
	Float_t nxc1[5]={ (s32p*j),       (s32p*j),               s32p*(j+1),s32p*(j+1),     (s32p*j)};
	Float_t nyc1[5]={     -ws13,     0.,    0., -ws13, -ws13};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + (-0.075+nxc1[i])*var.sfx;
	    nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
	};
	ftof32y[j] = new TPolyLine(5,nxc,nyc);
	ftof32y[j]->SetLineColor(1);
	if ( var.bw ){
	    colo = -1;
	} else {
	    colo = 1;
	};
	ColorTOFMIP(ms32a[j]+ms32b[j],colo);
	//
	if ( colo != 10 ) ocolo = colo;
	//
	ftof32y[j]->SetFillColor(colo);
	ftof32y[j]->SetLineWidth(1);
	ftof32y[j]->Draw("f");
	ftof32y[j]->Draw();
    };
    //
    // S32  X-view
    //
    if ( true ){
	Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
	Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
	Float_t nxc[5];     
	Float_t nyc[5];
	for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2x + nxc1[i]*var.sfx;
	    nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
	};
	TPolyLine *ftof32x = new TPolyLine(5,nxc,nyc);
	ftof32x->SetLineColor(1);
	ftof32x->SetLineWidth(1);
	ftof32x->SetFillStyle(4000);
	ftof32x->SetFillColor(0);
	ftof32x->Draw("f");
	ftof32x->Draw();
	TPolyLine *sftof32;
	if ( !var.nosig ){
	    if ( ocolo == 10 ) ocolo = noadc;
	    Float_t lowp = (xp32-E32)/100.;
	    Float_t higp = (xp32+E32)/100.;
	    if ( lowp < -0.089 ) lowp = -0.089;
	    if ( higp > 0.089 ) higp = 0.089;
	    if ( lowp < higp ){
		Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
		Float_t nyc1[5]={ -0.0015,         -0.0015,                -ws13+0.0015,    -ws13+0.0015,    -0.0015};
		Float_t nxc[5];     
		Float_t nyc[5];
		for (Int_t i = 0; i<5 ; i++) {
		    nxc[i]= xs2x + nxc1[i]*var.sfx;
		    nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
		};
		sftof32 = new TPolyLine(5,nxc,nyc);
		sftof32->SetLineColor(ocolo);
		sftof32->SetFillColor(ocolo);
		sftof32->SetLineWidth(1);
		sftof32->Draw("f");
		sftof32->Draw();
	    };
	};
    };
    //
}

//**********************************************************************************
//                           LEVEL2        SUBROUTINES                            //
//**********************************************************************************

void ShowTRACK(Int_t evno, TTree *ttr, Variables & var){
    //
    var.rig = 0.;
    var.chi2 = 0.;
    struct Tracklev2 trk;
    settrklev2(ttr,trk);
    //
    Int_t trcol = 10;
    Int_t syncro = 1;
    Int_t itr = evno;
    Int_t trnevents = ttr->GetEntries();
    Int_t pktnum = 0;
    Int_t obt = 0;
 trkcalosync: if ( itr >= trnevents ){
	printf(" WARNING: no more tracker level2 data.\n");
	return;
    };
    if ( !var.nosig ) ttr->GetEntry(itr);
    pktnum = var.headc;
    obt = var.etime;
    if ( pktnum != trk.pkt_num || obt != trk.obt ){
	if ( pktnum > trk.pkt_num || obt > trk.obt ){
	    itr++;
	    if ( syncro ) printf(" WARNING: lost sync! try to recover... \n");
	    syncro = 0;		
	    goto trkcalosync;
	};
	if ( pktnum < trk.pkt_num || obt < trk.obt ){
	    printf(" WARNING: no tracker level2 data. \n");
	    return;
	};
    };
    //
    if ( !syncro ) printf(" ...synchronization recovered! \n"); 	   
    //
    if ( trk.ntrk > 0 ){
	Int_t l = 0;
	Int_t tobeinc = 0;
	while ( l<trk.ntrk ) {
	    //
	    Int_t npoint = 100;
	    Double_t zin[100];
	    Double_t xout[100];
	    Double_t yout[100];
	    Double_t al_p[5];
	    Int_t ifail = 0;
	    //
	    Float_t tx[100];
	    Float_t ty[100];
	    Float_t ptx1[50];
	    Float_t pty1[50];
	    Float_t ptx2[50];
	    Float_t pty2[50];
	    Float_t tx1[15];
	    Float_t ty1[15];
	    Float_t tzx[100];
	    Float_t tzy[100];
	    Float_t tzx1[15];
	    Float_t tzy1[15];
	    //
	    // if there is track ambiguity in y choose the track with the smaller chi2
	    //
	    if ( trk.image[l] != 0 ){
	    	Float_t chiA = trk.chi2[l];
	    	Float_t chiB = trk.chi2[trk.image[l]-1];
		if ( chiA > chiB ) {
		    l = trk.image[l]-1;
		    tobeinc = 2;
		};
		tobeinc = 1;
	    };
	    for ( Int_t e = 0; e < 100 ; e++) {
		xout[e] = 0.;
		yout[e] = 0.;
		//
		tx[e] = 0.;
		ty[e] = 0.;
		tzx[e] = 0.;
		tzy[e] = 0.;
		if ( e < 50 ){
		    ptx1[e] = 0.;
		    pty1[e] = 0.;
		    ptx2[e] = 0.;
		    pty2[e] = 0.;
		    if ( e < 15 ){
			tx1[e] = 0.;
			ty1[e] = 0.;
			tzx1[e] = 0.;
			tzy1[e] = 0.;			
		    };
		};
		//
		if ( e < 5 ) {
		    al_p[e] = (Double_t)trk.al[l][e];
		};
		zin[e] = 60. - (124./99.)*(float)e;
	    };
	    //
	    zin[85] = -45.5;
	    //
	    ctrack(npoint,zin,xout,yout,al_p,ifail);	
	    //
	    //
	    if ( !ifail ){
		if ( l == 0 || ( l == 1 && tobeinc ==2 ) ){
		    if ( trk.al[l][4] != 0. ) {
			var.rig = 1./trk.al[l][4];
			var.chi2 = trk.chi2[l];
		    } else {
			var.rig = 0.;
			var.chi2 = 0.;
		    };
		};
		//
		for ( Int_t e = 0; e < npoint ; e++) {
		    tx[e] = ((float)xout[e]/100.)*var.sfx + var.xxvc;
		    ty[e] = ((float)yout[e]/100.)*var.sfx + var.xyvc;
		    //		    printf("tx %i %f \n",e,tx[e]);
		    //printf("xout %i %f \n",e,xout[e]);
		    if ( e < 50 ) {
			ptx1[e] = ((float)yout[e]/100.)*var.sfx + var.xcat;
			pty1[e] = ((float)xout[e]/100.)*var.sfy + var.ycat;
		    } else {
		    	ptx2[e-50] = ((float)yout[e]/100.)*var.sfx + var.xcat;
		    	pty2[e-50] = ((float)xout[e]/100.)*var.sfy + var.ycat;
		    };
		    if ( e > 84 ) {
		    	tx1[e-85] = ((float)xout[e]/100.)*var.nds4 + var.xxvc;
		    	ty1[e-85] = ((float)yout[e]/100.)*var.nds4 + var.xyvc;	
		    	tzx1[e-85] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yxvc;
		    	tzy1[e-85] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yyvc;
		    };
		    tzx[e] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yxvc;		    
		    tzy[e] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yyvc;
		};
		//
		// From S1 to CALO
		//
		if ( var.bw ){
		    trcol = 17-l;
			} else {
		    trcol = 50-l;
		};
		TPolyLine *trackx = new TPolyLine(86,tx,tzx);
		trackx->SetLineColor(trcol);
		trackx->SetLineWidth(1);
		trackx->Draw();
		TPolyLine *tracky = new TPolyLine(86,ty,tzy);
		tracky->SetLineColor(trcol);
		tracky->SetLineWidth(1);
		tracky->Draw();
		//
		// ND and S4
		//
		if ( var.tracknds4 ){
		    TPolyLine *trackx1 = new TPolyLine(15,tx1,tzx1);
		    trackx1->SetLineColor(trcol);
		    trackx1->SetLineWidth(1);
		    trackx1->Draw();
		    TPolyLine *tracky1 = new TPolyLine(15,ty1,tzy1);
		    tracky1->SetLineColor(trcol);
		    tracky1->SetLineWidth(1);
		    tracky1->Draw();
		};
		//
		// Plane View
		//
		TPolyLine *trackp1 = new TPolyLine(50,ptx1,pty1);
		trackp1->SetLineColor(trcol);
		trackp1->SetLineWidth(1);
		trackp1->Draw();
		//printf("sto stapando trk ntrk %i image %i trcol %i \n",trk.ntrk,trk.image[l],trcol);
		TPolyLine *trackp2 = new TPolyLine(50,ptx2,pty2);
		trackp2->SetLineColor(trcol);
		trackp2->SetLineWidth(1);
		trackp2->SetLineStyle(3);
		trackp2->Draw();
	    } else {
		printf(" WARNING: failed in determining the track! \n");
	    };
	    l++;
	    if ( tobeinc ) {
		l++;
		tobeinc = 0;
	    };
	};
    };
}

//**********************************************************************************
//                           OTHER         SUBROUTINES                            **
//**********************************************************************************

void ShowCaloL0(TString filename, Int_t i, Calib & calib, Int_t b[4], Float_t mip[2][22][96], TTree *otr, Variables & var){
    struct Evento evento;
    Int_t tot0 = 0;
    Int_t tot1 = 0;
    Int_t tot2 = 0;
    Int_t nstrip = 0;
    Float_t qtot = 0.;
    pamela::calorimeter::CalorimeterEvent *de = 0;
    otr->SetBranchAddress("Calorimeter.Event", &de);
    if ( !var.nosig ) otr->GetEntry(i);
    //
    // Define variables
    // 
    Int_t etime = var.etime;
    Float_t estrip[2][22][96], ener, basel,sdexy[2][22][96],sdexyc[2][22][96];
    Int_t badstrip = 0;
    qtot = 0.;
    nstrip = 0;
    //
    // Book the histograms:
    //
    //
    stringstream xvev;
    stringstream yvev;
    xvev.str("");
    yvev.str("");
    xvev << "x-view event " << (i+1);
    yvev << "y-view event " << (i+1);
    gDirectory->Delete(xvev.str().c_str());
    gDirectory->Delete(yvev.str().c_str());
    TH2F *Xview = new TH2F(xvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
    TH2F *Yview = new TH2F(yvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
    Xview->GetYaxis()->SetLabelColor(10); 
    Yview->GetYaxis()->SetLabelColor(10); 
    //
    // figures:
    //
    Int_t bgcolor = 10;
    TPad *pd1 = new TPad("calox","This is pad1",var.xxvc-0.154*var.sfx,var.yxvc-0.3645*var.sfy,var.xxvc+0.154*var.sfx,var.yxvc-0.1200*var.sfy,bgcolor);
    TPad *pd2 = new TPad("caloy","This is pad2",var.xyvc-0.154*var.sfx,var.yyvc-0.3645*var.sfy,var.xyvc+0.154*var.sfx,var.yyvc-0.1200*var.sfy,bgcolor);

    pd1->SetFillStyle(4000);
    pd1->SetFillColor(0);
    pd1->SetFrameFillStyle(4000);
    pd2->SetFillStyle(4000);
    pd2->SetFillColor(0);
    pd2->SetFrameFillStyle(4000);

    TLatex *t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.03);
    t->SetTextAlign(12);
    pd1->Range(0.,0.,1.,1.);
    pd2->Range(0.,0.,1.,1.);
    pd1->SetTicks();
    pd2->SetTicks();
    pd1->Draw();
    pd2->Draw();
    
    pd1->cd();	   
    gStyle->SetOptStat(0);
    Xview->GetYaxis()->SetTitleOffset(0.5);
    Xview->SetFillColor(bgcolor);	    
    Xview->Fill(1.,1.,1.);	    
    Xview->Draw("box");
    pd1->Update();
    pd2->cd();
    gStyle->SetOptStat(0);
    Yview->GetYaxis()->SetTitleOffset(0.5);	
    Yview->SetFillColor(bgcolor);	    
    Yview->Fill(1.,1.,1.);	    
    Yview->Draw("box");
    pd2->Update();
    //
    // for each event check that the calibration we are using are still within calibration limits, if not call the next calibration
    //
    for (Int_t s = 0; s < 4; s++){
	if ( calib.ttime[s][b[s]+1] && calib.time[s][b[s]] ){
	    while ( etime > calib.time[s][b[s]] && calib.time[s][b[s]] != 0 ){				
		printf(" CALORIMETER: \n" );
		printf(" - Section %i, event at time %i while old calibration time limit at %i. Use new calibration at time %i -\n",s,etime,calib.time[s][b[s]],calib.ttime[s][b[s]+1]);
		printf(" END CALORIMETER. \n\n" );
		b[s]++;
		CaloPede(filename,s,calib.ttime[s][b[s]],calib);
	    };
	};
    };
    //
    // do whatever you want with data
    //
    evento.iev = de->iev;
    //
    // run over views and planes
    //
    stringstream xve;
    stringstream yve;
    for (Int_t l = 0; l < 2; l++){
	for (Int_t m = 0; m < 22; m++){
	    //
	    // determine the section number
	    //
	    Int_t se = 5;
	    if (l == 0 && m%2 == 0) se = 3;
	    if (l == 0 && m%2 != 0) se = 2;
	    if (l == 1 && m%2 == 0) se = 1;
	    if (l == 1 && m%2 != 0) se = 0;		
	    //
	    // determine what kind of event we are going to analyze
	    //
	    bool isCOMP = 0;
	    bool isFULL = 0;
	    bool isRAW = 0;
	    if ( de->stwerr[se] & (1 << 16) ) isCOMP = 1; 
	    if ( de->stwerr[se] & (1 << 17) ) isFULL = 1; 
	    if ( de->stwerr[se] & (1 << 3) ) isRAW = 1; 
	    //
	    // save the prevoius energy deposit and calibration in sbase, sdexy, sdexyc
	    //
	    Int_t pre = -1; 
	    if ( isRAW ){
		for (Int_t nn = 0; nn < 96; nn++){		    
		    if ( nn%16 == 0 ) pre++;		    
		    evento.base[l][m][pre] = calib.calbase[l][m][pre];
		    sdexy[l][m][nn] = evento.dexy[l][m][nn];
		    evento.dexy[l][m][nn] = de->dexy[l][m][nn] ; 
		    sdexyc[l][m][nn] = evento.dexyc[l][m][nn];
		    evento.dexyc[l][m][nn] = de->dexyc[l][m][nn] ; 
		};
	    };
	    //
	    // run over strips
	    //
	    Int_t done = 0;
	    Int_t rdone = 0;
	    Int_t fdone = 0;	    
	    pre = -1;
	    for (Int_t n =0 ; n < 96; n++){		    
		if ( n%16 == 0 ) {
		    pre++;
		    done = 0;
		    rdone = 0;
		    fdone = 0;
		};	
		// 
		// baseline check and calculation
		//
		if ( !isRAW ) {
		    //
		    // if it isn't raw and we haven't checked yet, check that the baseline is fine, if not calculate it with a relaxed algorithm.
		    //
		    if ( !done ){
			evento.base[l][m][pre] = de->base[l][m][pre] ;   
			evento.dexyc[l][m][n] = de->dexyc[l][m][n] ; 
		    };
		} else {
		    //
		    // if it is a raw event and we haven't checked yet, calculate the baseline. Then check that the baseline is fine,
		    // if not calculate it with relaxed algorithm.
		    //
		    if ( !rdone ){
			CaloFindBaseRaw(calib,evento,l,m,pre);
			tot1++;
			rdone = 1;			
		    };
		};					    
		//
		// no suitable new baseline, use old ones
		//
		if ( !done && (evento.base[l][m][pre] == 31000. || evento.base[l][m][pre] == 0.) ){
		    tot0++;
		    evento.base[l][m][pre] = calib.sbase[l][m][pre];
		    Int_t upnn = n+16;
		    if ( upnn > 96 ) upnn = 96;
		    for ( Int_t nn = n; nn<upnn; nn++ ){
			evento.dexyc[l][m][nn] = de->dexyc[l][m][nn] ;
		    };
		    CaloCompressData(calib,evento,l,m,pre);
		    done = 1;			
		};
		//
		// if here we don't have a valid baseline we will skip the event.
		//
		if ( evento.base[l][m][pre] == 31000. ) tot2++;
		//
		// CALIBRATION ALGORITHM
		// 
		basel = evento.base[l][m][pre];		    
		ener = evento.dexyc[l][m][n];
		estrip[l][m][n] = 0.;
		if ( basel>0 && basel < 30000. && ener > 0. ){
		    estrip[l][m][n] = (ener - calib.calped[l][m][n] - basel)/mip[l][m][n] ;
		    //
		    // OK, now in estrip we have the energy deposit in MIP of all the strips for this event (at the end of loops of course)
		    //
		    xve.str("");
		    yve.str("");
		    xve << "x-view event " << n;
		    xve << " " << m;
		    xve << " " << l;
		    yve << "y-view event " << n;
		    yve << " " << m;
		    yve << " " << l;
		    gDirectory->Delete(xve.str().c_str());
		    gDirectory->Delete(yve.str().c_str());
		    TH2F *Xview = new TH2F(xve.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
		    TH2F *Yview = new TH2F(yve.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
		    if ( estrip[l][m][n] > 0.7 && !var.nosig ){
			Int_t colo;
			if ( var.bw ){
			    colo = -1;
			} else {
			    colo = 1;
			};
			ColorMIP(estrip[l][m][n],colo);
			Xview->SetFillColor(colo);
			Yview->SetFillColor(colo);
			if ( l == 0 ) {
			    Xview->Fill(n,21-m,1.);
			    pd1->cd();				    
			    Xview->Draw("box same");
			};				    
			if ( l == 1 ) {			    
			    Yview->Fill(95-n,21-m,1.);
			    pd2->cd();
			    Yview->Draw("box same");
			};
		    };			
		    if ( estrip[l][m][n] > 0.7 && calib.calgood[l][m][n] != 0  ) badstrip++;
		    if ( estrip[l][m][n] > 0.7 && calib.calgood[l][m][n] == 0 ) {			    
			qtot += estrip[l][m][n];
			nstrip++;
		    };
		};		    	
		calib.sbase[l][m][pre] = evento.base[l][m][pre];
	    };		
	};
    };
    pd1->Update();
    pd2->Update();
    var.qtot=(int)qtot;
    var.nstrip=nstrip;
}


void ShowPalette(Int_t bw){
    Float_t xp = 0.33;
    Float_t yp = 0.02;
    Float_t xw = 0.35;
    Float_t yh = 0.19;
    Double_t xx[5] = {xp, xp+xw, xp+xw, xp, xp};
    Double_t yy[5] = {yp, yp, yp+yh, yp+yh, yp};
    TPolyLine *fpale = new TPolyLine(5,xx,yy);
    fpale->SetLineColor(1);
    fpale->SetLineWidth(1);
    fpale->Draw();   
    TLatex *txt=new TLatex();
    txt->SetTextSize(0.01);
    txt->DrawLatex(xp+0.005,yp+yh-0.015,"PALETTE");
    txt->DrawLatex(xp+0.005,yp+yh-0.04,"TOF, CALO, S4 [MIP]:");
    Float_t xwc = (xp+0.01)/6.;
    Float_t yhc = 0.03;    
    Int_t colo = 0;
    Float_t yc = 0.135;
    TPolyLine *fc1[6];
    if ( bw ){
	for ( Int_t j=0; j<6; j++){
	    Float_t xc = 0.335+(j*xwc);
	    Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	    Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	    fc1[j] = new TPolyLine(5,xx,yy);
	    fc1[j]->SetLineColor(1);
	    if ( j == 0 ) {
		colo = 10;
	    };
	    if ( j == 1 ) {
		colo = 17;
	    };
	    if ( j == 2 ) {
		colo = 15;
	    };
	    if ( j == 3 ) {
		colo = 14;
	    };
	    if ( j == 4 ) {
		colo = 13;
	    };
	    if ( j == 5 ) {
		colo = 12;
	    };
	    fc1[j]->SetFillColor(colo);
	    fc1[j]->SetLineWidth(1);
	    fc1[j]->Draw("f");
	    fc1[j]->Draw();
	    if ( j == 0 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"0");
	    };
	    if ( j == 1 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"0 - 2");
	    };
	    if ( j == 2 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"2 - 10");
	    };
	    if ( j == 3 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"10 - 100");
	    };
	    if ( j == 4 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"100 - 500");
	    };
	    if ( j == 5 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"> 500");
	    };
	};
	
	txt->DrawLatex(xp+0.005,yp+yh-0.095,"ND [neutrons]:");
	Float_t yc = 0.08;
	TPolyLine *fc2[6];
	for ( Int_t j=0; j<6; j++){
	    Float_t xc = 0.335+(j*xwc);
	    Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	    Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	    fc2[j] = new TPolyLine(5,xx,yy);
	    fc2[j]->SetLineColor(1);
	    if ( j == 0 ) {
		colo = 10;
	    };
	    if ( j == 1 ) {
		colo = 17;
	    };
	    if ( j == 2 ) {
		colo = 15;
	    };
	    if ( j == 3 ) {
		colo = 14;
	    };
	    if ( j == 4 ) {
		colo = 13;
	    };
	    if ( j == 5 ) {
		colo = 12;
	    };
	    fc2[j]->SetFillColor(colo);
	    fc2[j]->SetLineWidth(1);
	    fc2[j]->Draw("f");
	    fc2[j]->Draw();
	    if ( j == 0 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"0");
	    };
	    if ( j == 1 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 1 ");
	    };
	    if ( j == 2 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 2 ");
	    };
	    if ( j == 3 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 3 - 6 ");
	    };
	    if ( j == 4 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 7 - 14 ");
	    };
	    if ( j == 5 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"> 14");
	    };
	};
	//	
	txt->DrawLatex(xp+0.005,yp+yh-0.15,"AC:");
	yc = 0.025;
	TPolyLine *fc3[3];
	for ( Int_t j=0; j<3; j++){
	    Float_t xc = 0.335+(j*xwc);
	    Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	    Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	    fc3[j] = new TPolyLine(5,xx,yy);
	    fc3[j]->SetLineColor(1);
	    if ( j == 0 ) {
		colo = 10;
	    };
	    if ( j == 1 ) {
		colo = 13;
	    };
	    if ( j == 2 ) {
		colo = 12;
	    };
	    fc3[j]->SetFillColor(colo);
	    fc3[j]->SetLineWidth(1);
	    fc3[j]->Draw("f");
	    fc3[j]->Draw();
	    if ( j == 0 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," NOT HIT ");
	    };
	    if ( j == 1 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," HIT trigger");
	    };
	    if ( j == 2 ) {
		txt->SetTextSize(0.0095);
		txt->DrawLatex(xc+0.001,yc+0.011," HIT background");
		txt->SetTextSize(0.01);
	    };
	};
    } else {
	for ( Int_t j=0; j<6; j++){
	    Float_t xc = 0.335+(j*xwc);
	    Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	    Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	    fc1[j] = new TPolyLine(5,xx,yy);
	    fc1[j]->SetLineColor(1);
	    if ( j == 0 ) {
		colo = 10;
	    };
	    if ( j == 1 ) {
		colo = 38;
	    };
	    if ( j == 2 ) {
		colo = 4;
	    };
	    if ( j == 3 ) {
		colo = 3;
	    };
	    if ( j == 4 ) {
		colo = 2;
	    };
	    if ( j == 5 ) {
		colo = 6;
	    };
	    fc1[j]->SetFillColor(colo);
	    fc1[j]->SetLineWidth(1);
	    fc1[j]->Draw("f");
	    fc1[j]->Draw();
	    if ( j == 0 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"0");
	    };
	    if ( j == 1 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"0 - 2");
	    };
	    if ( j == 2 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"2 - 10");
	    };
	    if ( j == 3 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"10 - 100");
	    };
	    if ( j == 4 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"100 - 500");
	    };
	    if ( j == 5 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"> 500");
	    };
	};
	
	txt->DrawLatex(xp+0.005,yp+yh-0.095,"ND [neutrons]:");
	Float_t yc = 0.08;
	TPolyLine *fc2[6];
	for ( Int_t j=0; j<6; j++){
	    Float_t xc = 0.335+(j*xwc);
	    Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	    Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	    fc2[j] = new TPolyLine(5,xx,yy);
	    fc2[j]->SetLineColor(1);
	    if ( j == 0 ) {
		colo = 10;
	    };
	    if ( j == 1 ) {
		colo = 38;
	    };
	    if ( j == 2 ) {
		colo = 4;
	    };
	    if ( j == 3 ) {
		colo = 3;
	    };
	    if ( j == 4 ) {
		colo = 2;
	    };
	    if ( j == 5 ) {
		colo = 6;
	    };
	    fc2[j]->SetFillColor(colo);
	    fc2[j]->SetLineWidth(1);
	    fc2[j]->Draw("f");
	    fc2[j]->Draw();
	    if ( j == 0 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"0");
	    };
	    if ( j == 1 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 1 ");
	    };
	    if ( j == 2 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 2 ");
	    };
	    if ( j == 3 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 3 - 6 ");
	    };
	    if ( j == 4 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," 7 - 14 ");
	    };
	    if ( j == 5 ) {
		txt->DrawLatex(xc+0.005,yc+0.01,"> 14");
	    };
	};
	//
	txt->DrawLatex(xp+0.005,yp+yh-0.15,"AC:");
	yc = 0.025;
	TPolyLine *fc3[3];
	for ( Int_t j=0; j<3; j++){
	    Float_t xc = 0.335+(j*xwc);
	    Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	    Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	    fc3[j] = new TPolyLine(5,xx,yy);
	    fc3[j]->SetLineColor(1);
	    if ( j == 0 ) {
		colo = 10;
	    };
	    if ( j == 1 ) {
		colo = 2;
	    };
	    if ( j == 2 ) {
		colo = 42;
	    };
	    fc3[j]->SetFillColor(colo);
	    fc3[j]->SetLineWidth(1);
	    fc3[j]->Draw("f");
	    fc3[j]->Draw();
	    if ( j == 0 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," NOT HIT ");
	    };
	    if ( j == 1 ) {
		txt->DrawLatex(xc+0.005,yc+0.01," HIT trigger");
	    };
	    if ( j == 2 ) {
		txt->SetTextSize(0.0095);
		txt->DrawLatex(xc+0.001,yc+0.011," HIT background");
		txt->SetTextSize(0.01);
	    };
	};
    };
}

void DrawX(Float_t cx, Float_t cy, Float_t si, Variables & var){
    if ( true ){
	Float_t x[2] = {-si*var.sfx,si*var.sfx};
	Float_t y[2] = {-si*var.sfy,si*var.sfy};
	Float_t xb[2];
	Float_t yb[2];
	for (Int_t i = 0; i<2 ; i++){
	    xb[i] = x[i]+cx;
	    yb[i] = y[i]+cy;	    
	};
	TLine *x2 = new TLine(xb[0],yb[0],xb[1],yb[1]);
	x2->SetLineColor(1);
	x2->SetLineWidth(1);
	x2->Draw();
    };
    if ( true ){
	Float_t x[2] = {-si*var.sfx,si*var.sfx};
	Float_t y[2] = {si*var.sfy,-si*var.sfy};
	Float_t xa[2];
	Float_t ya[2];
	for (Int_t i = 0; i<2 ; i++){
	    xa[i] = x[i]+cx;
	    ya[i] = y[i]+cy;	    
	};
	TLine *x1 = new TLine(xa[0],ya[0],xa[1],ya[1]);
	x1->SetLineColor(1);
	x1->SetLineWidth(1);
	x1->Draw();
    };
}
//
//
//
void ShowHelp(){
    char input[256];
    printf("\n USE:\n\n The only input needed is the path to the directory (\"filename\") created by YODA\n for the data file you want to analyze.\n Standard use:\n  root[0] .L ShowEvent.c\n  root[1] ShowEvent(\"/home/dati/filesFromYoda/DW_050112_00600/\");\n \n\n\n\n\n\n");
    printf("Press <enter> to continue\n");
    cin.getline(input,256);
    printf(" FEATURES:\n\n  ShowEvent(TString filename, Int_t fromevent = 0, Int_t toevent = 0,\n             TString selfile = \"\", Int_t FORCELEVEL = -1,\n            Int_t ctrlword = 509, Int_t BW=0, TString outDir = \"\",\n            TString calcalibfile = \"\")\n  Input variables\n   *  fromevent = the first event to be shown (0 means \"show all\")\n");
    printf("   *  toevent = the last event to be shown (NB: if fromevent differs from zero\n                and toevent is equal zero only one event will be shown,\n                number \"fromevent\")\n\n\n\n");
    printf("Press <enter> to continue\n");
    cin.getline(input,256);
    printf("   *  ctrword is an integer which can be used as a mask to customize the figure:\n           ctrword bit:    10    9    8    7     6    5     4    3      2     1   \n      detector   : special TOF   AC  TRK  CALO   S4    ND  infos names legenda\n      Examples:\n           ctrword = 509 = 0111111101 : all detectors+infos are printed(DEFAULT)\n           ctrword = 511 = 0111111111 : show all\n           ctrword = 505 = 0111111001 : don't print infos on figure\n           ctrword = 507 = 0111111011 : show detector names+legenda (no infos)\n           ctrword = 8   = 0000001000 : show only ND\n           ctrword = 1019 = 1111111011 : show all but infos without signals\n\n");
    printf("Press <enter> to continue\n");
    cin.getline(input,256);
    printf("\n\n      When the \"special\" bit is set NO SIGNAL will be shown in the detectors.\n      It can be used to draw a draft of the PAMELA apparatus without any event.\n ");
    printf("   *  selfile = selection file. Can be used to select events.\n                Default is \"\" that is no selection applied.\n");
    printf("   *  FORCELEVEL = to force a certain level visualization.\n                   For the moment only level0 can be forced.\n");
    printf("   *  BW = 0 flag to display black and white figures.\n             Default is 0, colours, set it to 1 to have BW visualization.\n");
    printf("   *  outDir = directory where to place figures (if you want to print them).\n               Default is \"filename\".\n\n");
    printf("Press <enter> to continue\n");
    cin.getline(input,256);
    printf("   *  calcalibfile = the calorimeter needs a calibration to display events. If a\n                     calibration is not in the file you want to analylze put \n                      here the path to a directory created by YODA for a data \n                     file with calorimeter calibration. Default is \"filename\".\n");
    printf("\n\n For further informations read the README.ShowEvent file.\n");
    return;
}

//
// MAIN ROUTINE
//
void ShowEvent(TString filename="help", TString selfile="", Int_t ctrlword = 509, Int_t FORCELEV = -1, Int_t fromevent = 0, Int_t toevent = 0, TString outDir = ""){
    gROOT->GetListOfCanvases()->Delete();
    gDirectory->GetList()->Delete();
    TString calcalibfile = "";
    TString startingdir = gSystem->WorkingDirectory();
    const char* startingdir2 = gSystem->WorkingDirectory();
    TString path;
    stringcopy(path,startingdir2);
    Int_t BW = 0;
#if defined (__CINT__)	
    emicheckLib();
    const char *pamlib=gSystem->Getenv("PAM_LIB");
    stringstream lolib;
    lolib.str("");
    lolib << pamlib << "/EVpathtoc_c.so";
    gSystem->Load(lolib.str().c_str());
    //
    if (!TClassTable::GetDict("CalorimeterLevel1")){
	const char *pamlib2 = gSystem->ExpandPathName("$PAM_LIB");
	stringstream liblo;
	liblo.str("");
	liblo << pamlib2 << "/caloclasses_h.so";
	gSystem->Load(liblo.str().c_str());
    }
#endif
#if !defined (__CINT__)	
    TApplication app("app",0,0);
#endif
    const char *pam_calib = pathtocalibration();
    stringstream calfile;
    calfile.str("");
    calfile << pam_calib << "/CaloADC2MIP.root";
    struct Levels level;
    //
    const char *name= filename;
    if ( filename == "" || !strcmp(name,"help") ){
	ShowHelp();
	return;
    };
    //
    //
    //
    if ( FORCELEV != -1 ) printf("\n WARNING: FORCING LEVEL%i DATA \n\n",FORCELEV);
    //
    // LOAD SELECTION FILE
    //
    Int_t selection = 0;
    if ( selfile == ""  ){
	selection = 0;
    } else {
#if !defined (__CINT__)
	//
	// if running the compiled program we must load header files for the selection macros!
	//
	gROOT->Reset();
	stringstream paminc;
	paminc.str("");
	const char *testinc = gSystem->Getenv("PAM_INC");	
	if ( testinc == "" ){
	    const char *pam_calib = pathtocalibration();
	    paminc << pam_calib << "../include/";
	} else {
	    paminc << testinc;
	};
	stringstream carica;
	carica.str("");
	carica << paminc.str().c_str() << "/eventviewer.h";
	gROOT->LoadMacro(carica.str().c_str());
	carica.str("");
	carica << paminc.str().c_str() << "/trklev1struct.h";
	gROOT->LoadMacro(carica.str().c_str());
	carica.str("");
	carica << paminc.str().c_str() << "/ctrkstruct.h";
	gROOT->LoadMacro(carica.str().c_str());
	carica.str("");
	carica << paminc.str().c_str() << "/ctrkinclude.h";
	gROOT->LoadMacro(carica.str().c_str());
	carica.str("");
	carica << paminc.str().c_str() << "/ctofstruct.h";
	gROOT->LoadMacro(carica.str().c_str());
	carica.str("");
	carica << paminc.str().c_str() << "/ctofinclude.h";
	gROOT->LoadMacro(carica.str().c_str());
#endif
	//
	// load the selection macro
	//
	selection = gROOT->LoadMacro(selfile);
	if ( selection ){
	    printf("\n\n ERROR! cannot read the selection file you give me as input! \n");
	    selection = 0;
	    printf("\n WARNING! no selection file loaded! \n\n");
	} else {
	    printf("\n\n Selection file loaded \n\n The first event will be shown anyway. \n\n");			    
	    selection = 1;
	};
    };
    //
    //
    //  LOAD FILES
    //
    Int_t SHOWDEC = 0;
    Int_t TOF = 0;
    Int_t AC = 0;
    Int_t TRK = 0;
    Int_t CALO = 0;
    Int_t S4 = 0;
    Int_t ND = 0;
    Int_t INFOS = 0;
    Int_t VINFOS = 0;
    Int_t PALETTE = 0;
    //
    if ( ctrlword & (1<<0) ) { 
	PALETTE = 1;
	printf("Show Palette\n");
    };
    if ( BW ) printf(" --> Black and White visualization! \n");
    if ( ctrlword & (1<<1) ) { 
	VINFOS = 1;
	printf("Show Verbose Text Informations\n");
    };
    if ( ctrlword & (1<<2) ) { 
	INFOS = 1;
	printf("Show Text Informations\n");
    };
    if ( ctrlword & (1<<3) ) {
	ND = 1;
    };
    if ( ctrlword & (1<<4) ) {
	S4 = 1;
    };
    if ( ctrlword & (1<<5) ) { 
	CALO = 1;
    };
    if ( ctrlword & (1<<6) ) {
	TRK = 1;
    };
    if ( ctrlword & (1<<7) ) {
	AC = 1;
    };
    if ( ctrlword & (1<<8) ) {
	TOF = 1;
    };
    if ( ctrlword & (1<<9) ) {
	SHOWDEC = 1;
        fromevent = 1;
	toevent = 1;
	printf("\n ** WARNING! YOU HAVE CHOSEN TO SHOW ONLY DETECTORS AND NO SIGNALS! **\n\n");
	gSystem->Exec("sleep 5"); 
    };
    //
    TString fififile =  getFilename(filename);
    const char *file = fififile;
    //
    Int_t trk1noev = 0;
    Int_t trk2noev = 0;
    Int_t tofnoev = 0;
    // open files
    TFile       *headerFile = 0;
    TFile       *triggerFile = 0;
    TFile       *caloFile = 0;
    TFile       *trackerFile = 0;
    TFile       *trackerFile2 = 0;
    TFile       *neutronFile = 0;
    TFile       *acFile = 0;
    TFile       *s4File = 0;
    TFile       *tofFile = 0;
    TFile       *tofFileL1 = 0;
    TTree       *toftr = 0;
    //
    headerFile = emigetFile(filename, "Physics", "Header");
    if ( !headerFile ){
	printf("ERROR: no Header file, exiting...\n");
	return;
    };
    TTree *otr = (TTree*)headerFile->Get("Pscu");
    printf("Get the Header informations\n");
    //
    triggerFile = emigetFile(filename, "Trigger");
    if ( !triggerFile ){
	printf("ERROR: no Trigger file, exiting...\n");
	return;
    };
    otr->AddFriend("Trigger", triggerFile);
    printf("Get the Trigger informations\n");
    //
    TTree *ttr = 0;
    TTree *ttr1 = 0;
    Int_t STRACK = 0;
    Int_t TRKLEV = 0;
    Int_t ACLEV = 0;
    TFile *trackhead = 0;
    TFile *trackcalibFile1 = 0;
    TTree *ctrk = 0;
    TFile *trackcalibFile2 = 0;
    TFile *trackerFile2b = 0;
    if ( TRK ) {
	if ( FORCELEV == 0 ){
	    trackerFile2 = emigetFile(filename, "Tracker");
	    if ( !trackerFile2 ){
		printf("WARNING: no Tracker file! \n");
		TRK = 0;
	    } else {
		otr->AddFriend("Tracker", trackerFile2);
		printf("Show the Tracker detector, LEVEL0 data \n");
		TRKLEV = 0;
	    };
	} else {
	    trackerFile = emigetFile(filename, "Physics.Level2", "Tracker");
	    if ( !trackerFile ){
		//
		trackhead = emigetFile(filename, "CalibTrk1", "Header");
		ctrk = (TTree*)trackhead->Get("Pscu");
		//
		trackerFile = emigetFile(filename, "Physics.Level1", "Tracker");
		trackcalibFile1 = emigetFile(filename, "CalibTrk1");
		trackcalibFile2 = emigetFile(filename, "CalibTrk2");
		//
		if ( !trackerFile || !trackcalibFile1 || !trackcalibFile2 || !trackhead ){
		    trackerFile = emigetFile(filename, "Tracker");
		    if ( !trackerFile ){
			printf("WARNING: no Tracker file! \n");
			TRK = 0;
		    } else {
			otr->AddFriend("Tracker", trackerFile);
			printf("Show the Tracker detector, LEVEL0 data \n");
			TRKLEV = 0;
		    };
		} else {
		    ttr1 = (TTree*)trackerFile->Get("TrkLevel1");
		    ctrk->AddFriend("CalibTrk1", trackcalibFile1);		
		    ctrk->AddFriend("CalibTrk2", trackcalibFile2);		
		    printf("Show the Tracker detector, LEVEL1 data \n");
		    TRKLEV = 1;	       
		    trk1noev = ttr1->GetEntries();
		};
	    } else {
		ttr = (TTree*)trackerFile->Get("TrkLevel2");
		trk2noev = ttr->GetEntries();
		printf("Get the track informations (LEVEL2 Tracker data!)\n");
		STRACK = 1;
		//
		trackhead = emigetFile(filename, "CalibTrk2", "Header");
		ctrk = (TTree*)trackhead->Get("Pscu");
		//
		trackerFile2b = emigetFile(filename, "Physics.Level1", "Tracker");
		trackcalibFile1 = emigetFile(filename, "CalibTrk1");
		trackcalibFile2 = emigetFile(filename, "CalibTrk2");
		//
		if ( !trackerFile2b || !trackcalibFile1 || !trackcalibFile2 || !trackhead ){
		    printf(" WARNING: no LEVEL1 Tracker data, load LEVEL0 data \n");		
		    trackerFile2b = emigetFile(filename, "Tracker");
		    if ( !trackerFile2b ){
			printf("WARNING: no Tracker file! \n");
			TRK = 0;
		    } else {
			otr->AddFriend("Tracker", trackerFile2b);
			printf("Show the Tracker detector, LEVEL0 data \n");
			TRKLEV = 0;
		    };
		} else {
		    ttr1 = (TTree*)trackerFile2b->Get("TrkLevel1");
		    ctrk->AddFriend("CalibTrk1", trackcalibFile1);		
		    ctrk->AddFriend("CalibTrk2", trackcalibFile2);		
		    printf("Show the Tracker detector, LEVEL1 data \n");
		    TRKLEV = 1;	       
		    trk1noev = ttr1->GetEntries();
		};
	    };
	};
    };
    //
    Int_t CALOLEV = 0;
    if ( CALO ) {
	if ( FORCELEV == 0 ){
	    caloFile = emigetFile(filename, "Calorimeter");
	    if ( !caloFile ){
		printf("WARNING: no calorimeter file! \n");
		CALO = 0;
	    } else {
		otr->AddFriend("Calorimeter", caloFile);
		printf("Show the Calorimeter detector, LEVEL0 data \n");
	    };
	    CALOLEV = -1;
	} else {
	    caloFile = emigetFile(filename, "Physics.Level1", "Calorimeter");
	    if ( !caloFile ){
		caloFile = emigetFile(filename, "Calorimeter");
		if ( !caloFile ){
		    printf("WARNING: no calorimeter file! \n");
		    CALO = 0;
		} else {
		    otr->AddFriend("Calorimeter", caloFile);
		    printf("Show the Calorimeter detector, try to generate LEVEL1 data \n");
		};
		CALOLEV = 0;
	    } else {
		otr->AddFriend("CaloLevel1", caloFile);
		printf("Show the Calorimeter detector, LEVEL1 data \n");
		CALOLEV = 1;		
	    };
	};
    };
    //
    if ( ND ) {
	neutronFile = emigetFile(filename, "Neutron");
	if ( !neutronFile ){
	    printf("WARNING: no neutron detector file! \n");
	    ND = 0;
	} else {
	    otr->AddFriend("Neutron", neutronFile);
	    printf("Show the Neutron detector, LEVEL0 data \n");
	};
    };
    //
    if ( AC ) {
	if ( FORCELEV == 0 ){
	    acFile = emigetFile(filename, "Anticounter");
	    if ( !acFile ){
		printf("WARNING: no AC file! \n");
		AC = 0;
	    } else {
		otr->AddFriend("Anticounter", acFile);
		printf("Show the Anticoincidence detector, LEVEL 0 data\n");				
		ACLEV = 0;
	    };
	} else {
	    acFile = emigetFile(filename, "Physics.Level1", "Anticounter");
	    if ( !acFile ){
		acFile = emigetFile(filename, "Anticounter");
		if ( !acFile ){
		    printf("WARNING: no AC file! \n");
		    AC = 0;
		} else {
		    otr->AddFriend("Anticounter", acFile);
		    printf("Show the Anticoincidence detector, LEVEL 0 data\n");				
		    ACLEV = 0;
		};
	    } else {
		otr->AddFriend("AcLevel1", acFile);
		printf("Show the Anticoincidence detector, LEVEL 1 data\n");		
		ACLEV = 1;
	    };
	};
    };
    Int_t S4LEV = 0;
    if ( S4 ) {
	s4File = emigetFile(filename, "S4");
	if ( !s4File ){
	    printf("WARNING: no S4 file! \n");
	    S4 = 0;
	} else {
	    otr->AddFriend("S4", s4File);
	    if ( FORCELEV != 0 ){
		printf("Show the S4 detector, try to generate LEVEL1 data \n");
		S4LEV = 1;
	    } else {
		printf("Show the S4 detector, LEVEL0 data \n");
		S4LEV = 0;
	    };
	};
    };
    //
    Int_t TOFLEV = 0;   
    if ( TOF ) {
	if ( FORCELEV != 0 ){
	    tofFileL1 = emigetFile(filename, "Physics.Level1","TofTrigger");
	    if ( !tofFileL1 ){	
		tofFile = emigetFile(filename, "Tof");
		if ( !tofFile ){	
		    printf("WARNING: no TOF file! \n");
		    printf("Show the Time of Flight detector, LEVEL0 (trigger board) data\n");
		    //	    TOF = 0;
		    TOFLEV = 0;
		} else {
		    otr->AddFriend("Tof", tofFile);
		    printf("Show the Time of Flight, try to generate LEVEL1 data \n");
		    TOFLEV = 10;
		};
	    } else {
		 toftr = (TTree*)tofFileL1->Get("TofLevel1");
		 printf("Show the Time of Flight, LEVEL1 data \n");
		 TOFLEV = 1;	       
		 tofnoev = toftr->GetEntries();
	    };	    
	} else {
	    printf("Show the Time of Flight detector, LEVEL0 data\n");
	    TOFLEV = 0;
	};
    };
    //    
    printf("\n");
    //
    pamela::PscuHeader *ph = 0;
    pamela::EventHeader *eh = 0;
    pamela::trigger::TriggerEvent  *trig = 0;
    Long64_t nevents    = otr->GetEntries();
    //
    printf(" The file contains %i physics events \n",(int)nevents);
    //
    if (nevents<=0) {
	headerFile->Close();
	triggerFile->Close();
	if ( TRK ) trackerFile->Close();
	if ( CALO )caloFile->Close();
	if ( ND ) neutronFile->Close();
	if ( AC ) acFile->Close();
	if ( TOF ) tofFile->Close();
	if ( S4 ) s4File->Close();
	printf("The file is empty, exiting...\n");
	return;
    }
    //
    //  Define some variables
    //
    Int_t OBT = 0;
    Int_t DOBT = 0;
    Int_t ifout = 0;
    Int_t OOBT = 0;
    //
    if ( calcalibfile == "" ) calcalibfile = filename;
    if ( outDir == "" ) outDir = filename;
    //
    struct Variables var;
    //
    if ( SHOWDEC ){
	var.nosig = 1;
    } else {
	var.nosig = 0;
    };
    //
    // here windows dimension (based on the computer screen size) and position and dimension of figures
    //
    Int_t  xw, yw;
    UInt_t ww, hw;
    gVirtualX->GetWindowSize(gClient->GetRoot()->GetId(),xw,yw,ww,hw);
    Float_t winx = (float)ww*0.95;
    Float_t winy = (float)hw*0.95;
    Float_t winrap = winx/winy;
    var.bw = 0;
    if ( BW ) var.bw = 1;
    var.xxvc = 0.17;
    var.yxvc = 0.44;
    var.xyvc = 0.83;
    var.yyvc = 0.44;
    //    
    var.sfx = 0.82/winrap;
    var.sfy = 0.82;
    //
    var.nds4 = 0.4;
    //var.nds4 = 0.85/winrap;
    var.xcat = 0.5;
    var.ycat = 0.74;
    //
    var.tracknds4 = 1;
    //
    //  READ the CALORIMETER ADC to MIP conversion table (if trying to generate level1 data)
    //
    Float_t mip[2][22][96];
    Int_t okcalo = 0;
    TTree *ctree = 0;
    TFile *chfile;
    CalorimeterCalibration *ccalo = 0;
    Long64_t cnevents = 0;
    if ( !CALOLEV && CALO ){
	chfile = new TFile(calfile.str().c_str(),"READ","Calorimeter CALIBRATION data");
	if ( chfile->IsZombie() ){
	    printf(" WARNING: no calorimeter calibration file! \n Using 26 as conversion factor for all strips. \n");
	    okcalo = 0;
	} else {
	    okcalo = 1;
	    ctree = (TTree*)chfile->Get("CaloADC");  
	    ctree->SetBranchAddress("Event", &ccalo);    
	    //
	    cnevents = ctree->GetEntries();
	    ctree->GetEntry(cnevents-1);
	};
	//
	if ( okcalo ) {
	    for (Int_t m = 0; m < 2 ; m++ ){
		for (Int_t k = 0; k < 22; k++ ){
		    for (Int_t l = 0; l < 96; l++ ){
			if ( (ccalo->fp[1][m][k][l] > 20. && ccalo->fp[1][m][k][l] < 32.) || ccalo->mask[m][k][l] == 1. ) {
			    if ( ccalo->mip[m][k][l] != 0. ){
				mip[m][k][l] = ccalo->mip[m][k][l];
			    } else {
				mip[m][k][l] = 26. ;
			    };
			} else {
			    mip[m][k][l] = 26. ;
			};
		    };	   
		};
	    };
	} else {
	    for (Int_t m = 0; m < 2 ; m++ ){
		for (Int_t k = 0; k < 22; k++ ){
		    for (Int_t l = 0; l < 96; l++ ){
			mip[m][k][l] = 26. ;
		    };
		};
	    };
	};
	chfile->Close();
    };
    //
    //  Check that given input are inside the boundary conditions 
    //
	if ( fromevent > toevent && toevent ){
	printf("It must be fromevent < toevent \n");
	return;
    };
    if ( fromevent > nevents+1 || fromevent < 0 ) {
	printf("You can choose fromevent between 0 (all) and %i \n",(int)nevents+1);
	return;
    };
    if ( toevent > nevents+1 || toevent < 0 ) {
	printf("You can choose toevent between 0 (all) and %i \n",(int)nevents+1);
	return;
    };
    Int_t minevent = 0;
    Int_t maxevent = nevents - 1;
    if ( fromevent == 0 ) {
	minevent = 0;
	maxevent = nevents - 1;
    } else {
	minevent = fromevent - 1;
	if ( toevent > 0 ){
	    maxevent = toevent-1;
	} else {	   
	    maxevent = fromevent-1;
	};
    };
    //
    //  book the canvas
    //
    TCanvas *figure = new TCanvas("PAMELA event viewer", "PAMELA event viewer",(int)winx,(int)winy);
    TLatex *text=new TLatex();
    stringstream testo;
    stringstream testo2;
    stringstream testo3;
    figure->Range(0.,0.,1.,1.);
    gStyle->SetOptDate(0); 
    gStyle->SetOptStat(0);
    gStyle->SetLabelSize(0);
    gStyle->SetNdivisions(1,"X");
    gStyle->SetNdivisions(1,"Y");	
    //
    stringstream libload;
    Int_t doflag = 1;
    Int_t thefirst = 1;
    Int_t trackdone1 = 0;
    Int_t trackdone2 = 0;
    Int_t seldone = 0;
    Float_t headc = 0.;
    Float_t headcold = 0.;
    Int_t i = minevent;
    Int_t OK = 0;
    Int_t jumpto = 0;
    //
    otr->SetBranchAddress("Header", &eh);
    otr->GetEntry(maxevent);
    ph = eh->GetPscuHeader();
    Int_t lastevno = (int)ph->GetCounter();
    otr->GetEntry(minevent);
    ph = eh->GetPscuHeader();
    Int_t firstevno = (int)ph->GetCounter();
    struct Calib calib;
    Int_t b[4];
    Int_t si = 0;
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //  MAIN LOOP STARTS HERE: run over all the events
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    while ( i < maxevent+1 ){
	//
	// clear canvas and variables
	//
	var.beta[0] = 0.;
	var.beta[1] = 0.;
	var.beta[2] = 0.;
	var.beta[3] = 0.;
	var.beta[4] = 0.;
	var.s4sig = 0.;
	var.nstrip = 0;
	var.qtot = 0;
	var.nclx = 0;
	var.ncly = 0;
	var.trup = 0;
	var.bkup = 0;
	var.bkbo = 0;
	var.hcas = 0;
	var.hcat = 0;
	var.hcard = 0;
	//
	// call the filter to select events (if filter file is given)
	//
	if ( jumpto ){
	    otr->SetBranchAddress("Header", &eh);
	    otr->GetEntry(i);
	    ph = eh->GetPscuHeader();
	    Int_t cjumpto = (int)ph->GetCounter();
	    if ( cjumpto == jumpto ) jumpto = 0;
	    if ( jumpto && i == maxevent ) {
		i = si;
		printf(" WARNING: NO EVENT WITH EVENT NUMBER %i \n",jumpto);
		jumpto = 0;
	    };
	};
	//
	OK = 0;
	if ( !selection || ( i == minevent && !seldone) ){
	    OK = 1;
	    seldone = 1;
	} else {
	    OK = 0;
#if defined (__CINT__)
	    OK = filter(i,otr,ttr,level);
#endif
#if !defined (__CINT__)
	    stringstream cintcom;
	    cintcom.str("");
	    cintcom << "Int_t *i = (Int_t*)0x" << hex;
	    cintcom << &i;
	    gROOT->ProcessLine(cintcom.str().c_str());
	    gROOT->ProcessLine("Int_t a = *i;");
	    cintcom.str("");
	    cintcom << "TTree *otr = (TTree*)0x" << hex;
	    cintcom << otr;
	    gROOT->ProcessLine(cintcom.str().c_str());
	    cintcom.str("");
	    cintcom << "TTree *ttr = (TTree*)0x" << hex;
	    cintcom << ttr;
	    gROOT->ProcessLine(cintcom.str().c_str());
	    cintcom.str("");
	    cintcom << "struct Levels &level = (struct Levels &)0x" << hex;
	    cintcom << &level;
	    gROOT->ProcessLine(cintcom.str().c_str());
	    OK = gApplication->ProcessLine("filter((Int_t)a,(TTree *)otr,(TTree *)ttr,(Levels &)level);");
#endif
	    seldone = 1;
	    printf("Scanning data: %d%c done",100*(i-minevent)/(maxevent-minevent),37);
	    fflush(stdout);
	};
	//
	// if the event is selected go on
	//
	if ( OK && !jumpto ) {
	    printf("\n");
	    figure->Clear();
	    figure->SetFillColor(10);
	    figure->cd();
	    //
	    // Get Orbital Time information and header event number
	    //
	    otr->SetBranchAddress("Header", &eh);
	    if ( !var.nosig) otr->GetEntry(i);
	    ph = eh->GetPscuHeader();
	    headcold = headc;
	    headc = ph->GetCounter();
	    var.headc = (int)ph->GetCounter();
	    OBT = ph->GetOrbitalTime();
	    DOBT = OBT - OOBT;
	    OOBT = OBT;
	    if ( i == minevent || DOBT < 0 || (headc-headcold-1)!=0 ) DOBT = 0;
	    var.etime = OBT;
	    //	    
	    // who gave the trigger?
	    //
	    otr->SetBranchAddress("Trigger.Event", &trig);
	    if ( !var.nosig) otr->GetEntry(i);
	    Int_t calotrig = 0;
	    if ( trig->patterntrig[0] ) calotrig = 1;
	    Int_t toftrig = 0;
	    if ( trig->patterntrig[2] || trig->patterntrig[3] || trig->patterntrig[4] || trig->patterntrig[5] ) toftrig = 1;
	    Int_t s4pulser = 0;
	    if ( trig->patterntrig[1] & (1<<0) ) s4pulser = 1;
	    //
	    // TOF and calorimeter when giving a trigger will always set this flag since the time window of the signal is greater than 100 ns.
	    // S4 sometimes could not set the flag even if the trigger is given. This is a workaround to fix this "bug":
	    //
	    if ( !calotrig && !toftrig ) s4pulser = 1;
	    //
	    Int_t trigconf = trig->trigconf;
	    stringstream trc;
	    trc.str("");
	    if ( trigconf & (1<<0) ) trc << "TOF1"; 
	    if ( trigconf & (1<<1) ) trc << " TOF2"; 
	    if ( trigconf & (1<<2) ) trc << " TOF3";
	    if ( trigconf & (1<<3) ) trc << " TOF4";
	    if ( trigconf & (1<<4) ) trc << " TOF5";
	    if ( trigconf & (1<<5) ) trc << " TOF6";
	    if ( trigconf & (1<<6) ) trc << " TOF7";
	    if ( trigconf & (1<<7) ) trc << " S4";
	    if ( trigconf & (1<<8) ) trc << " CALO";
	    if ( trigconf & (1<<9) ) trc << " CALIB_ON";
	    TString trcs(trc.str().c_str());
	    //
	    // show TOF
	    //
	    if ( TOF ){
		figure->cd();	
		if ( TOFLEV == 0 ){
		    ShowTOF(i,otr,var);
		    level.tof = 0;
		};
		if ( TOFLEV == 10 ){
		    ShowTOFGENL1(i,otr,var);
		    level.tof = 0;
		};
		if ( TOFLEV == 1 ){
		    ShowTOFL1(i,toftr,var);
		    level.tof = 1;
		};
	    };
	    //
	    // show anticounters
	    //
	    if ( AC ){
		figure->cd();	
		if ( ACLEV == 0 ){
		    ShowAC(i,otr,var,0);		
		    level.ac = 0;
		};
		if ( ACLEV == 1 ){
		    ShowAC(i,otr,var,1);		
		    level.ac = 1;
		};
	    };
	    //
	    // show S4
	    //
	    if ( S4 ){
		figure->cd();	
		if ( S4LEV == 0 ){
		    ShowS4L0(i,otr,var);		
		    level.s4 = 0;
		};
		if ( S4LEV == 1 ){
		    ShowS4L1(i,otr,var);		
		    level.s4 = 1;
		};
	    };
	    //
	    //
	    // show neutron detector
	    //
	    if ( ND ){
		figure->cd();	
		ShowND(i,otr,var);
		level.nd = 0;
	    };
	    //
	    // show tracker
	    //
	    if ( TRK ){
		//
		// if we have level2 data show the track
		//
		if ( STRACK == 1 ) {		
		    if ( i == minevent && !trackdone1 ) {
			//
			// Load tracker libraries to read the magnetic field and compute the paritcle trajectory
			//
			trackdone1 = 1;
#if defined (__CINT__)				
			printf("\n\n TRACKER: loading shared libraries...\n");
			const char *pam_lib=gSystem->Getenv("PAM_LIB");
			libload.str("");
			libload << pam_lib << "/libtrack";
			gSystem->Load(libload.str().c_str());
			libload.str("");
			libload << pam_lib << "/libtrack_C";
			gSystem->Load(libload.str().c_str());
			libload.str("");
			libload << pam_lib << "/libreadb2maps";
			gSystem->Load(libload.str().c_str());
			libload.str("");
			libload << pam_lib << "/libreadb2maps_C";
			gSystem->Load(libload.str().c_str());
			libload.str("");
			printf(" ...done!\n\n");
#endif
			//
			// Read the magnetic field map (two files), here it goes the path AND name of one of them.
			//
			printf("\n\n TRACKER: loading the magnetic field maps...\n\n\n");			
			const char *pam_calib = pathtocalibration();
			stringstream bdir;
			bdir.str("");
			bdir << pam_calib << ".";
			creadB(bdir.str().c_str());
			//
			printf(" ...done! \n");
		    };
		    level.track2 = 1;
		    figure->cd();	
		    ShowTRACK(i,ttr,var);
		};
		//
		// show level1 data 
		//
		figure->cd();	
		if ( TRKLEV == 1 ) {
		    if ( i == minevent && !trackdone2 ) {
			trackdone2 = 1;
#if defined (__CINT__)	
			printf("\n\n TRACKER: loading level1 libraries...\n");
			const char *pam_lib=gSystem->Getenv("PAM_LIB");
			printf("\n Opening libptlev1.so \n");
			libload.str("");
			libload << pam_lib << "/libptlevel1";
			gSystem->Load(libload.str().c_str());			
			libload.str("");
			printf("\n Opening libptlev1_C.so \n\n");
			libload.str("");
			libload << pam_lib << "/libptlevel1_C";
			gSystem->Load(libload.str().c_str());
			libload.str("");
			printf(" ...done! \n\n");
#endif
			//
			pamela::CalibTrk1Event *te1 = 0;
			ctrk->SetBranchAddress("CalibTrk1.Event", &te1);
			if ( ctrk->GetEntries() > 0 ){
			    ctrk->GetEntry(0);
			    for ( Int_t ii = 0 ; ii<6 ; ii++){
				for ( Int_t ij = 0 ; ij<3072 ; ij++){	
				    var.DSPsig_par[ii][ij] = te1->DSPsig_par[ii][ij];
				};
			    };
			    pamela::CalibTrk2Event *te2 = 0;
			    ctrk->SetBranchAddress("CalibTrk2.Event", &te2);
			    ctrk->GetEntry(0);
			    for ( Int_t ii = 6 ; ii<12 ; ii++){
				for ( Int_t ij = 0 ; ij<3072 ; ij++){	
				    var.DSPsig_par[ii][ij] = te2->DSPsig_par[ii-6][ij];
				};
			    };
			} else {
			    for ( Int_t ii = 0 ; ii<12 ; ii++){
				for ( Int_t ij = 0 ; ij<3072 ; ij++){	
				    if ( ii > 5 ) var.DSPsig_par[ii][ij] = 8.;
				    if ( ii < 6 ) var.DSPsig_par[ii][ij] = 3.;
				};
			    };
			};
		    };
		    ShowTRKL1(i,ttr1,var);
		};
		//
		// if everything fails, show at least level0 data
		//
		if ( TRKLEV == 0 ) ShowTRKL0(i,otr,var);
		figure->Modified();
		figure->Update();
		level.track = TRKLEV;
	    };
	    //
	    // show calorimeter
	    //	
	    if ( CALO ){	    
		figure->cd();	
		//
		// if we have LEVEL1 data
		//
		if ( CALOLEV == 1 ) ShowCaloL1(i,otr,var);	
		// 
		// if we have only LEVEL0 data try to generate event by event LEVEL1 data
		// 
		if ( CALOLEV == 0 ) {
		    if ( !thefirst ) { 
			ShowCaloL0(calcalibfile,i,calib,b,mip,otr,var);	    
		    } else {
			printf("\n\n CALORIMETER: looking for calibration data...\n");
			thefirst = 0;
			Calo1stcalib(calcalibfile,calib,b);
			//
			// check calibration
			//
			Int_t calibex = 0;
			Int_t stop = 0;
			for (Int_t s=0; s<4;s++){
			    if ( b[s] > 4 ) b[s] = 0;
			    stop = 0;
			    for (Int_t d = 0; d<48; d++){
				if ( calib.ttime[s][d] != 0 ) calibex++;
				if ( calib.time[s][0] != 0 ){
				    if ( calib.time[s][d+1] == 0 ) {
					if ( !stop ){
					    stop = 1;
					};
				    };
				};
			    };
			};
			printf(" ...done! \n\n\n");
			if ( calibex < 1 ) {
			    printf(" No calorimeter calibrations! Switching to raw mode visualitation \n Only COMPRESS and FULL mode acquisition are supported \n\n");
			    CALOLEV = -1;
			} else {
			    ShowCaloL0(calcalibfile,i,calib,b,mip,otr,var);	    
			};
		    };
		};
		//
		// if everything fail, show level0 data
		//
		if ( CALOLEV == -1 ) {
		    ShowCaloRAW(i,otr,var);
		};
		if ( var.nosig ){
		    var.qtot = 0;
		    var.nstrip = 0;
		};
		level.calo = CALOLEV;
	    };
	    figure->cd();
	    //
	    // SHOW INFOS
	    //
	    if ( INFOS ){
		figure->cd();
		text->SetTextAngle(0);
		text->SetTextFont(32);
		text->SetTextColor(1);
		text->SetTextSize(0.025); // 0.02
		text->SetTextAlign(12);
		Float_t txthi = 0.47;
		testo.str("");
		testo << "File: " << file;
		testo << " - Event number: " << (int)headc;
		text->DrawLatex(0.33,txthi,testo.str().c_str());
		txthi -= 0.03;
		testo.str("");
		testo << "Progressive number: " << (i+1);
		if ( s4pulser ){
		    testo << "   - S4 trigger - ";
		};
		if ( calotrig ){
		    testo << "   - CALO trigger - ";
		};
		text->DrawLatex(0.33,txthi,testo.str().c_str());
		txthi -= 0.03;
		testo2.str("");
		testo2 << "On Board Time: " << (int)OBT;
		if ( DOBT > 0 ) {		    
		    testo2 << " (delta: " << (int)DOBT;
		    testo2 << ")";
		};
		testo2 << " [ms]";
		text->DrawLatex(0.33,txthi,testo2.str().c_str());
		txthi -= 0.03;
		text->SetTextSize(0.020); // 0.015
		const char *trc2 = trcs;
		testo3.str("");
		testo3 << "TRIGGER: " << trc2;
		text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
		txthi -= 0.03;
		testo3.str("");
		testo3 << "AC: CARD hit = " << var.hcard;
		testo3 << "  CAT hit = " << var.hcat;
		testo3 << "  CAS hit = " << var.hcas;
		text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
		txthi -= 0.03;
		testo3.str("");
		if ( STRACK ){
		    testo3 << "TRK:  RIG = " << setprecision(3) << var.rig;
		    testo3 << " [GV] CHI2 = " << setprecision(3) << var.chi2;
		} else {
		    testo3 << "TRK:  NCLX = "<< var.nclx;
		    testo3 << "  NCLY = "<<var.ncly;
		};
		text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
		txthi -= 0.03;
		testo3.str("");
		testo3 << "CALO: NSTRIP = " << var.nstrip;
		testo3 << "  QTOT = "<<var.qtot << " [MIP]";
		text->DrawLatex(0.33,txthi,testo3.str().c_str());
		txthi -= 0.03;
		testo3.str("");
		testo3 << "S4: " << setprecision(2);
		testo3 << var.s4sig << " [MIP]   TOF: #beta(1,...,5) = (";
		testo3 << setprecision(3) << var.beta[0];
		testo3 << ",";
		testo3 << setprecision(3) << var.beta[1];
		testo3 << ","; 		
		testo3 << setprecision(3) << var.beta[2];
		testo3 << ",";
		testo3 << setprecision(3) << var.beta[3];
		testo3 << ",";
		testo3 << setprecision(3) << var.beta[4];
		testo3 << ")";
		text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
		txthi -= 0.03;
		testo3.str("");
		testo3 << "ND: Trigger: neutrons = " << var.trup;
		testo3 << "  - Background: upper = " << var.bkup;
		testo3 << " lower = " << var.bkbo;
		text->DrawLatex(0.33,txthi,testo3.str().c_str());
		txthi -= 0.03;
		text->SetTextSize(0.01);
		text->DrawLatex(var.xxvc-0.025*var.sfx,var.yxvc-0.519*var.sfy,"CPU SIDE");
		text->SetTextAngle(90);
		text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc+0.075*var.sfy,"CPU SIDE");
		text->DrawLatex(var.xyvc-0.17*var.sfx,var.yyvc+0.075*var.sfy,"VME SIDE");
		if ( AC || TRK ){
		    text->SetTextAngle(90);
		    text->DrawLatex(var.xcat-0.235*var.sfx,var.ycat-0.025*var.sfy,"VME SIDE");
		    text->DrawLatex(var.xcat+0.235*var.sfx,var.ycat-0.025*var.sfy,"CPU SIDE");
		    //
		    text->SetTextAngle(0);
		    text->SetTextSize(0.015);	    
		    TEllipse *elli = new TEllipse(var.xcat+0.219*var.sfx,var.ycat-0.249*var.sfy,0.003,0.003);
		    elli->Draw();
		    text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.261*var.sfy,"z");
		    TArrow *arr;
		    arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.22*var.sfx,var.ycat-0.21*var.sfy);
		    arr->SetArrowSize(0.005);
		    arr->Draw();
		    text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.21*var.sfy,"x");
		    arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.18*var.sfx,var.ycat-0.25*var.sfy);
		    arr->SetArrowSize(0.005);
		    arr->Draw();
		    text->DrawLatex(var.xcat+0.18*var.sfx,var.ycat-0.261*var.sfy,"y");
		    text->SetTextSize(0.01);
		};
		//
		// coordinates systems and x/y view labels
		//
		figure->cd();
		text->SetTextAngle(0);
		text->SetTextFont(32);
		text->SetTextColor(1);	
		text->SetTextAlign(12);
		text->SetTextSize(0.01);
		text->DrawLatex(var.xxvc-0.025*var.sfx,var.yxvc+0.67*var.sfy,"X VIEW");
		text->DrawLatex(var.xyvc-0.025*var.sfx,var.yyvc+0.67*var.sfy,"Y VIEW");
		//
		text->SetTextSize(0.015);	    
		text->SetTextFont(2);
		DrawX(var.xxvc-0.23*var.sfx,var.yxvc-0.508*var.sfy,0.005,var);
		text->SetTextFont(32);
		text->DrawLatex(var.xxvc-0.246*var.sfx,var.yxvc-0.508*var.sfy,"y");
		TArrow *arr;
		arr = new TArrow(var.xxvc-0.23*var.sfx,var.yxvc-0.508*var.sfy,var.xxvc-0.19*var.sfx,var.yxvc-0.508*var.sfy);
		arr->SetArrowSize(0.005);
		arr->Draw();
		text->DrawLatex(var.xxvc-0.19*var.sfx,var.yxvc-0.515*var.sfy,"x");
		arr = new TArrow(var.xxvc-0.23*var.sfx,var.yxvc-0.508*var.sfy,var.xxvc-0.23*var.sfx,var.yxvc-0.468*var.sfy);
		arr->SetArrowSize(0.005);
		arr->Draw();
		text->DrawLatex(var.xxvc-0.246*var.sfx,var.yxvc-0.468*var.sfy,"z");
		//
		text->SetTextSize(0.015);	    
		text->SetTextFont(2);
		DrawX(var.xyvc+0.22*var.sfx,var.yyvc-0.508*var.sfy,0.005,var);
		text->SetTextFont(32);
		text->DrawLatex(var.xyvc+0.23*var.sfx,var.yyvc-0.508*var.sfy,"x");
		arr = new TArrow(var.xyvc+0.22*var.sfx,var.yyvc-0.508*var.sfy,var.xyvc+0.18*var.sfx,var.yyvc-0.508*var.sfy);
		arr->SetArrowSize(0.005);
		arr->Draw();
		text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc-0.511*var.sfy,"y");
		arr = new TArrow(var.xyvc+0.22*var.sfx,var.yyvc-0.508*var.sfy,var.xyvc+0.22*var.sfx,var.yyvc-0.468*var.sfy);
		arr->SetArrowSize(0.005);
		arr->Draw();
		text->DrawLatex(var.xyvc+0.23*var.sfx,var.yyvc-0.468*var.sfy,"z");	    
		text->SetTextSize(0.01);
	    };
	    //
	    // SHOW PALETTE
	    //
	    if ( PALETTE ) ShowPalette(var.bw);
	    //
	    // SHOW VERBOSE INFOS
	    //
	    if ( VINFOS ){
		figure->cd();
		text->SetTextAngle(0);
		text->SetTextFont(32);
		text->SetTextColor(1);
		text->SetTextSize(0.01);
		text->SetTextAlign(12);
		if ( AC ){
		    //
		    // Plane view
		    //
		    text->SetTextAngle(90);
		    text->DrawLatex(var.xcat+0.1*var.sfx,var.ycat-0.015*var.sfy,"CARD4");
		    text->SetTextAngle(-90);
		    text->DrawLatex(var.xcat-0.1*var.sfx,var.ycat+0.015*var.sfy,"CARD1");
		    text->SetTextAngle(0);
		    text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat-0.116*var.sfy,"CARD2");
		    text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat+0.116*var.sfy,"CARD3");		
		    text->SetTextAngle(90);
		    text->DrawLatex(var.xcat+0.13*var.sfx,var.ycat-0.015*var.sfy,"CAS3");
		    text->SetTextAngle(-90);
		    text->DrawLatex(var.xcat-0.13*var.sfx,var.ycat+0.015*var.sfy,"CAS4");
		    text->SetTextAngle(0);
		    text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat-0.140*var.sfy,"CAS2");
		    text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat+0.140*var.sfy,"CAS1");	       
		    text->DrawLatex(var.xcat+0.17*var.sfx,var.ycat,"CAT1");
		    text->DrawLatex(var.xcat-0.2*var.sfx,var.ycat,"CAT2");
		    text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat-0.198*var.sfy,"CAT3");
		    text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat+0.198*var.sfy,"CAT4");
		    //
		    // X and Y views
		    //
		    text->DrawLatex(var.xxvc-0.192*var.sfx,var.yxvc-0.08*var.sfy,"CAS2");
		    text->DrawLatex(var.xxvc+0.17*var.sfx,var.yxvc-0.08*var.sfy,"CAS1");
		    text->DrawLatex(var.xyvc-0.192*var.sfx,var.yyvc-0.08*var.sfy,"CAS4");
		    text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc-0.08*var.sfy,"CAS3");
		    text->DrawLatex(var.xxvc-0.192*var.sfx,var.yxvc+0.48*var.sfy,"CARD2");
		    text->DrawLatex(var.xxvc+0.155*var.sfx,var.yxvc+0.48*var.sfy,"CARD3");
		    text->DrawLatex(var.xyvc-0.170*var.sfx,var.yyvc+0.48*var.sfy,"CARD1");
		    text->DrawLatex(var.xyvc+0.13*var.sfx,var.yyvc+0.48*var.sfy,"CARD4");
		    text->DrawLatex(var.xxvc-0.192*var.sfx,var.yxvc+0.39*var.sfy,"CAT3");
		    text->DrawLatex(var.xxvc+0.155*var.sfx,var.yxvc+0.39*var.sfy,"CAT4");
		    text->DrawLatex(var.xyvc-0.170*var.sfx,var.yyvc+0.39*var.sfy,"CAT2");
		    text->DrawLatex(var.xyvc+0.13*var.sfx,var.yyvc+0.39*var.sfy,"CAT1");
		};
		if  ( CALO ){
		    text->SetTextSize(0.020);
		    text->SetTextAngle(90);
		    text->DrawLatex(var.xxvc-0.22*var.sfx,var.yxvc-0.290*var.sfy,"Calorimeter");		
		    text->DrawLatex(var.xyvc+0.22*var.sfx,var.yyvc-0.290*var.sfy,"Calorimeter");		
		    text->SetTextSize(0.01);
		    text->SetTextAngle(0);
		};
		if  ( TRK ){
		    text->SetTextSize(0.020);
		    text->SetTextAngle(90);
		    text->DrawLatex(var.xxvc-0.22*var.sfx,var.yxvc+0.080*var.sfy,"Tracker");		
		    text->DrawLatex(var.xyvc+0.22*var.sfx,var.yyvc+0.080*var.sfy,"Tracker");		
		    text->SetTextSize(0.01);
		    text->SetTextAngle(0);
		};
		if  ( ND ){
		    text->SetTextSize(0.020);
		    text->SetTextAngle(90);
		    text->DrawLatex(var.xxvc-0.22*var.sfx,var.yxvc-0.430*var.sfy,"ND");		
		    text->DrawLatex(var.xyvc+0.22*var.sfx,var.yyvc-0.430*var.sfy,"ND");		
		    text->SetTextSize(0.01);
		    text->SetTextAngle(0);
		};
		if  ( TOF ){
		    text->SetTextSize(0.020);
		    text->DrawLatex(var.xxvc-0.24*var.sfx,var.yxvc-0.130*var.sfy,"S3");		
		    text->DrawLatex(var.xxvc-0.24*var.sfx,var.yxvc+0.350*var.sfy,"S2");		
		    text->DrawLatex(var.xxvc-0.24*var.sfx,var.yxvc+0.653*var.sfy,"S1");		
		    text->DrawLatex(var.xyvc+0.21*var.sfx,var.yyvc-0.130*var.sfy,"S3");		
		    text->DrawLatex(var.xyvc+0.21*var.sfx,var.yyvc+0.350*var.sfy,"S2");		
		    text->DrawLatex(var.xyvc+0.21*var.sfx,var.yyvc+0.653*var.sfy,"S1");		
		    text->SetTextSize(0.01);
		};
		if  ( S4 ){
		    text->SetTextSize(0.020);
		    text->DrawLatex(var.xxvc-0.24*var.sfx,var.yxvc-0.350*var.sfy,"S4");		
		    text->DrawLatex(var.xyvc+0.21*var.sfx,var.yyvc-0.350*var.sfy,"S4");		
		    text->SetTextSize(0.01);
		};
		if ( !INFOS ){
		    text->SetTextSize(0.01);
		    text->DrawLatex(var.xxvc-0.025*var.sfx,var.yxvc-0.520*var.sfy,"CPU SIDE");
		    text->SetTextAngle(90);
		    text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc+0.075*var.sfy,"CPU SIDE");
		    text->DrawLatex(var.xyvc-0.17*var.sfx,var.yyvc+0.075*var.sfy,"VME SIDE");
		    if ( AC || TRK ){
			text->SetTextAngle(90);
			text->DrawLatex(var.xcat-0.235*var.sfx,var.ycat-0.025*var.sfy,"VME SIDE");
			text->DrawLatex(var.xcat+0.235*var.sfx,var.ycat-0.025*var.sfy,"CPU SIDE");
			//
			text->SetTextAngle(0);
			text->SetTextSize(0.015);	    
			TEllipse *elli = new TEllipse(var.xcat+0.219*var.sfx,var.ycat-0.249*var.sfy,0.003,0.003);
			elli->Draw();
			text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.261*var.sfy,"z");
			TArrow *arr;
			arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.22*var.sfx,var.ycat-0.21*var.sfy);
			arr->SetArrowSize(0.005);
			arr->Draw();
			text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.21*var.sfy,"x");
			arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.18*var.sfx,var.ycat-0.25*var.sfy);
			arr->SetArrowSize(0.005);
			arr->Draw();
			text->DrawLatex(var.xcat+0.18*var.sfx,var.ycat-0.261*var.sfy,"y");
			text->SetTextSize(0.01);
		    };
		    //
		    // coordinates systems and x/y view labels
		    //
		    figure->cd();
		    text->SetTextAngle(0);
		    text->SetTextFont(32);
		    text->SetTextColor(1);	
		    text->SetTextAlign(12);
		    text->SetTextSize(0.01);
		    text->DrawLatex(var.xxvc-0.025*var.sfx,var.yxvc+0.67*var.sfy,"X VIEW");
		    text->DrawLatex(var.xyvc-0.025*var.sfx,var.yyvc+0.67*var.sfy,"Y VIEW");
		    //
		    text->SetTextSize(0.015);	    
		    text->SetTextFont(2);
		    DrawX(var.xxvc-0.23*var.sfx,var.yxvc-0.508*var.sfy,0.005,var);
		    text->SetTextFont(32);
		    text->DrawLatex(var.xxvc-0.246*var.sfx,var.yxvc-0.508*var.sfy,"y");
		    TArrow *arr;
		    arr = new TArrow(var.xxvc-0.23*var.sfx,var.yxvc-0.508*var.sfy,var.xxvc-0.19*var.sfx,var.yxvc-0.508*var.sfy);
		    arr->SetArrowSize(0.005);
		    arr->Draw();
		    text->DrawLatex(var.xxvc-0.19*var.sfx,var.yxvc-0.515*var.sfy,"x");
		    arr = new TArrow(var.xxvc-0.23*var.sfx,var.yxvc-0.508*var.sfy,var.xxvc-0.23*var.sfx,var.yxvc-0.468*var.sfy);
		    arr->SetArrowSize(0.005);
		    arr->Draw();
		    text->DrawLatex(var.xxvc-0.246*var.sfx,var.yxvc-0.468*var.sfy,"z");
		    //
		    text->SetTextSize(0.015);	    
		    text->SetTextFont(2);
		    DrawX(var.xyvc+0.22*var.sfx,var.yyvc-0.508*var.sfy,0.005,var);
		    text->SetTextFont(32);
		    text->DrawLatex(var.xyvc+0.23*var.sfx,var.yyvc-0.508*var.sfy,"x");
		    arr = new TArrow(var.xyvc+0.22*var.sfx,var.yyvc-0.508*var.sfy,var.xyvc+0.18*var.sfx,var.yyvc-0.508*var.sfy);
		    arr->SetArrowSize(0.005);
		    arr->Draw();
		    text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc-0.511*var.sfy,"y");
		    arr = new TArrow(var.xyvc+0.22*var.sfx,var.yyvc-0.508*var.sfy,var.xyvc+0.22*var.sfx,var.yyvc-0.468*var.sfy);
		    arr->SetArrowSize(0.005);
		    arr->Draw();
		    text->DrawLatex(var.xyvc+0.23*var.sfx,var.yyvc-0.468*var.sfy,"z");	    
		    text->SetTextSize(0.01);
		};
	    };
	    //
	    // update figure
	    //
	    figure->Modified();
	    figure->Update();
	    figure->cd();
	    //
	    // print infos on terminal
	    //
	    printf(" File: %s \n",name);	
	    if ( !s4pulser && !calotrig ){
		printf(" Event number: %i  - Progressive number: %i \n",(int)headc,i+1);
	    };
	    if ( s4pulser ){
		printf(" Event number: %i  - Progressive number: %i   - S4 trigger -\n",(int)headc,i+1);
	    };
	    if ( calotrig ){
		printf(" Event number: %i  - Progressive number: %i   - CALO trigger -\n",(int)headc,i+1);
	    };
	    printf(" On Board Time: %i (delta %i) [ms]\n",OBT,DOBT);
	    const char *trc2 = trcs;
	    printf(" TRIGGER: %s \n",trc2);	
	    printf(" AC: CARD hit = %i  CAT hit = %i  CAS hit = %i \n",var.hcard,var.hcat,var.hcas);	
	    if ( STRACK ){
		printf(" TRK:  NCLX = %i  NCLY = %i RIG = %f [GV] CHI2 = %f \n",var.nclx,var.ncly,var.rig,var.chi2);	
	    } else {
		printf(" TRK:  NCLX = %i  NCLY = %i \n ",var.nclx,var.ncly);	
	    };
	    printf(" CALO: NSTRIP = %i  QTOT = %i [MIP]\n",var.nstrip,var.qtot);	
	    printf(" S4: %.2f [MIP]   TOF: beta(1,...,5) = (%.2f,%.2f,%.2f,%.2f,%.2f) \n",var.s4sig,var.beta[0],var.beta[1],var.beta[2],var.beta[3],var.beta[4]);	
	    printf(" ND: Trigger: neutrons = %i - Background: upper = %i lower = %i \n",var.trup,var.bkup,var.bkbo);	
	    //
	    // Interact with user: do you want to continue, go backward, exit or print the figure?
	    //
	    printf("\n\n\n\n\n\n\n\n\n\n");
	    if ( i != maxevent ) { 
		si = i;
		doflag = 1;
		jumpto = 0;
		TString figty = "ev";
		var.i = i;
		var.doflag = doflag;
		var.jumpto = jumpto;
		var.nevents = nevents;
		var.lastevno = lastevno;
		var.firstevno = firstevno;
		Int_t ifout = WhatToDoEV(var,file,outDir,figty,*figure);
		i = var.i;
		doflag = var.doflag;
		jumpto = var.jumpto;
		if ( i != si ) OOBT = 1000000000;
		if ( maxevent < i+1 ) {
		    maxevent = nevents;
		    printf("WARNING: you have chosen an event number out of the starting range.\n         Range extended to %i\n\n",maxevent);		
		};
		if ( ifout ) goto theend;
	    } else {
		printf("\n\n");    
	    };
	};
	if ( doflag == 2 && i == 0 ) {
	    printf("\n WARNING: Cannot go backward! Going forward. \n");
	    doflag = 1;
	};
	if ( doflag == 2 && i>0 ) i--;
	if ( doflag == 1 ) i++;
	//
	// if in selection mode, print out a event progress bar:
	//
	if ( !selection || i == minevent ){
	    // do nothing
	} else {
	    if ( (maxevent-minevent) != 0 ){
		if((100*(i-minevent)/(maxevent-minevent))<10.){
		    printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8);
		} else {
		    printf("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c",8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8);
		};   
	    };
	};

    };
    //
    // END OF THE MAIN LOOP AND OF THE MAIN PROGRAM
    //
    printf("\n");    
 theend: if ( !ifout ) printf("\nFinished, exiting... \n\n");    
#if defined (__CINT__)  
    gSystem->ChangeDirectory(path);
   if ( trackdone2 ){
	unload1();
    };
    if ( trackdone1 ){
	unload2();
    };
#endif
    printf(" ...done! \n\n");
    return;
}
