 typedef struct Levels {
     Int_t calo;
     Int_t calol2;
     Int_t tof;
     Int_t track;
     Int_t track2;
     Int_t s4;
     Int_t ac;
     Int_t nd;
 } level;

typedef struct Variables {
    Float_t sfx;  // scale factor x
    Float_t sfy;  // scale factor y
    Float_t xxvc; // x coordinate of the x-view
    Float_t yxvc; // y coordinate of the x-view
    Float_t xyvc; // x coordinate of the y-view
    Float_t yyvc; // y coordinate of the y-view
    Float_t xcat; // x coordinate of the cat view
    Float_t ycat; // y coordinate of the cat view
    Float_t nds4; // scaling factor for ND and S4
    Float_t rig;  // rigidity from the tracker (track number 1)
    Float_t chi2; // chi2 of the fitted track (track number 1)
    Float_t sbase[2][22][96]; // calorimeter old baselines
    Float_t DSPsig_par[12][3072]; //tracker sigma calibration data
    Float_t s4sig; // S4 calibrated signal
    Float_t beta[5]; // TOF beta infos    
    Int_t   bw; // black and white flag
    Int_t   nosig; // flag to show only detectors and no signals
    Int_t   etime; // time of the event (OBT)
    Int_t   headc; // event number 
    Int_t   nstrip; // strip hit, info from CALO
    Int_t   qtot; // total energy (MIP), info from CALO
    Int_t   nclx; // number of cluster in the x view, info from TRK
    Int_t   ncly; // number of cluster in the y view, info from TRK
    Int_t   trup; // number of neutron upper half, info from ND
    Int_t   bkup; // number of background neutron upper half, info from ND 
    Int_t   bkbo; // number of background neutron lower half, info from ND  
    Int_t   hcas; // number of hit in cas, info from AC
    Int_t   hcat; // number of hit in cat, info from AC
    Int_t   hcard;// number of hit in card, info from AC    
    Int_t tracknds4; // flag to display the track in ND and S4
    Int_t i; // event number
    Int_t doflag; //going forward or backward?
    Int_t jumpto; // event number to jump to
    Int_t lastevno; // last event number
    Int_t firstevno; // first event number
    Long64_t nevents; // number of events in the ntuple    
} var;

Int_t WhatToDoEV(Variables & var, const char *file, TString outDir, TString figty, TCanvas &figure) {
    char *bw;
    if ( var.bw ){
	bw = "bw";
    } else {
	bw = "";
    };
    var.jumpto = 0;
    stringstream input;
    stringstream input2;
    stringstream input3;
    char    tellme[256];
    char    tellme2[256];
    char    tellme3[256];
    stringstream out;
    out.str("x");
    input2.str("zzzzzzzzzzzzzz");
    input3.str("z");
    input << out.str().c_str();    
    stringstream stc;
    stringstream stc2;
    while ( !strcmp(input.str().c_str(),out.str().c_str()) ) {
	printf("\nPress <enter> to continue, b<enter> to go backward, j<enter> to jump,\np<enter> to save the figure, o<enter> for more options, q<enter> to quit: \n");
	cin.getline(tellme,256);
	//
	input.str("");
	input << tellme;
	out << "y";
	//
	stc.str("o");
	//
	if ( !strcmp(input.str().c_str(),stc.str().c_str()) ) {
	    stringstream input4;	    
	    char    tellme4[256];
	    stringstream out4;
	    out4.str("a");
	    input4 << out4.str().c_str(); 
	    while ( !strcmp(input4.str().c_str(),out4.str().c_str()) ) {
		printf("\nPress <enter> to go back to previous menu, c<enter> to toggle B/W visualization,\nt<enter> to toggle track visualization in S4 and ND: \n");
		cin.getline(tellme4,256);
		input4.str("");
		input4 << tellme4;
		out4.str("1");
		out.str("");
		out << input.str().c_str(); 
		//
		stc2.str("c");
		if ( !strcmp(input4.str().c_str(),stc2.str().c_str()) ) {
		    if ( !var.bw ){
			printf("\n --> B/W visualization\n");
			var.bw = 1;
		    } else {
			printf("\n --> colour visualization\n");
			var.bw = 0;
		    };
		    var.i--;
		    out.str("1");
		};
		//
		stc2.str("t");
		if ( !strcmp(input4.str().c_str(),stc2.str().c_str()) ) {
		    if ( !var.tracknds4 ){
			printf("\n --> track visualization in S4 and ND\n");
			var.tracknds4 = 1;
		    } else {
			printf("\n --> no track visualization in S4 and ND\n");
			var.tracknds4 = 0;
		    };
		    var.i--;
		    out.str("1");
		};		
	    };
	};
	//
	stc.str("b");
	//
	if ( !strcmp(input.str().c_str(),stc.str().c_str()) ) {
	    if ( var.i > 0  ) {
		printf("WARNING: going backward!\n\n");
		var.doflag = 2;
	    } else {
		printf("This is the first event, you can't go backward! \n");
		out.str("");
		out << input.str().c_str(); 
	    };
	};
	//
	stc.str("j");
	//
	if ( !strcmp(input.str().c_str(),stc.str().c_str()) ) {	
	    printf("\n Do you want to jump to a progressive number [p] or to an event number [e]?  ");
	    cin.getline(tellme3,256);
	    input3.str("");
	    input3 << tellme3;	
	    //
	    stc2.str("p");
	    if ( !strcmp(input3.str().c_str(),stc2.str().c_str()) ) {
		printf("\n Enter the progressive number you want to jump to: ");
		cin.getline(tellme2,256);
		input2.str("");
		input2 << tellme2;
		Int_t j;
		j = atoi(input2.str().c_str());
		if ( j < 1 || j > var.nevents+1 ) {
		    printf("\n You can choose between 1 and %i \n",(int)var.nevents+1);
		    out.str("");
		    out << input.str().c_str(); 
		} else { 
		    printf("\n Jumping to progressive number %i\n\n",j);
		    var.i = j-2;
		};
	    };
	    //
	    stc2.str("e");
	    if ( !strcmp(input3.str().c_str(),stc2.str().c_str()) ) {
		printf("\n Enter the event number you want to jump to: ");
		cin.getline(tellme2,256);
		input2.str("");
		input2 << tellme2;
		Int_t j;
		j = atoi(input2.str().c_str());
		if ( j < var.firstevno || j > var.lastevno ) {
		    printf("\n You can choose between %i and %i \n",var.firstevno,var.lastevno);
		    out.str("");
		    out << input.str().c_str(); 
		} else { 
		    printf("\n Jumping to event number %i\n\n",j);
		    var.jumpto = j;
		    var.i = -1;
		};
	    };
	    //
	    stc.str("p");
	    stc2.str("e");
	    if ( strcmp(input3.str().c_str(),stc2.str().c_str()) && strcmp(input3.str().c_str(),stc.str().c_str()) ) {
		printf(" You must type or \"p\" or \"e\"\n");
		out.str("");
		out << input.str().c_str(); 
	    };
	};
	//
	stc.str("q");
	stc2.str(".q");
	//
	if ( !strcmp(input.str().c_str(),stc.str().c_str()) || !strcmp(input.str().c_str(),stc2.str().c_str()) ) {	
	    printf("Exiting...\n");
	    return(1);
	};	    
	//
	stc.str("p");
	//
	if ( !strcmp(input.str().c_str(),stc.str().c_str()) ) {	
	    printf("Enter a file extension recognized by ROOT (ps, eps, gif,...):\n");
	    cin.getline(tellme2,256);
	    input2.str("");
	    input2 << tellme2;
	    out.str("");
	    out << input.str().c_str();
	    //
	    TString filename = file;
	    const string fil = (const char*)filename;
	    Int_t posiz = fil.find("dw_");
	    if ( posiz == -1 ) posiz = fil.find("DW_");
	    Int_t posiz2 = posiz+13;
	    TString file2;
	    stringcopy(file2,filename,posiz,posiz2);
	    const char *figrec = file2;
	    const char *outdir = outDir;
	    stringstream figsave;    
	    const char *ty = figty;
	    figsave.str("");
	    figsave << outdir << "/";
	    figsave << ty << "_";
	    figsave << (var.i+1) << "_";
	    figsave << figrec;
	    figsave << bw << ".";
	    figsave << input2.str().c_str();
	    figure.SaveAs(figsave.str().c_str());
	    printf("\n");	
	};	    
    };	    
    return(0);
}
