//
// EventViewer.cc -- standalone program to call the EventViewer macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/11/07)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TSystem.h>
#include <caloclasses.h>
#include <iostream>
//
extern void ShowEvent(TString, TString, Int_t, Int_t, Int_t, Int_t, TString);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name;
  TString selfile;
  TString outdir;
  int dl;
  int figlay;  
  if ( numinp < 6 ){
    if ( numinp > 1 ){
      if ( !strcmp(inps[1],"--version") ){
	info();
	return(0);
      };
      if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") ){
	printf("\nUsage:\n\n EventViewer file selection_file figure_layout data_level output_dir \n");
	printf("\n - file             must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
	printf(  " - selection_file   selection file, empty if no selection is required \n");
	printf(  " - figure_layout    10 bit integer to control the figure layout. Each bit \n");
	printf(  "                    set to 1 activate the visualization of a detector or  \n");
	printf(  "                    a part of the figure. This is the association scheme: \n");
	printf(  "                  10    9    8    7     6    5     4    3      2     1  \n");
	printf(  "               special TOF  AC   TRK   CALO S4    ND   infos  names legenda \n");
	printf(  "                    The default value is 509 = 0111111101 that is all detectors\n");
	printf(  "                    and infos are shown, names are hidden. \n");
	printf(  "                    When the \"special\" bit is set NO SIGNAL will be shown in \n");
	printf(  "                    the detectors. It can be used to draw a draft of the PAMELA\n");
	printf(  "                    apparatus without any event.\n");
	printf(  "                    Other examples: \n");
	printf(  "                    505 = 0111111001 : don't print infos on figure \n");
	printf(  "                    507 = 0111111011 : show detector names+legenda (no infos) \n");
	printf(  "                    8   = 0000001000 : show only ND. \n");
	printf(  " - data_level       by default the program will try to display the highest level\n");
	printf(  "                    data available. This flag force the level0 visualization\n");
	printf(  "                    when it is set to 0. Default value is -1. \n");
	printf(  " - outDir           directory where to save figures\n");
	printf("\nExamples: \n\nEventViewer /home/pamela/filesfromyoda/dw_050301_00100/ \"\" 509 -1 /home/pamela/\n");
	printf(                "EventViewer /home/pamela/filesfromyoda/dw_050301_00100/ muselection.c 509 -1 \"\"\n\n");
	return(0);
      };
    };
    printf("\n Welcome to the PAMELA event viewer! \n\n");
    //
    printf("\n You must provide the following input parameters: \n\n");
    //
    char input[256];
    //
    printf(" Path to YODA unpacked directory: \n ");
    cin.getline(input,256);
    name = (TString)input;
    printf(" Selection file to use?: \n ");
    cin.getline(input,256);
    if ( !strcmp(input,"") ){
      selfile = "";
    } else {
      selfile = (TString)input;
    };
    printf(" Figure layout (default 509)?: \n ");
    cin.getline(input,256);
    if ( !strcmp(input,"") ){
      figlay = 509;
    } else {
      figlay = atoi(input);
    };
    printf(" Data level (default -1 = as high as possible)?: \n ");
    cin.getline(input,256);
    if ( !strcmp(input,"0") ){
      dl = 0;
    } else {
      dl = -1;
    };
    printf(" Output directory: \n ");
    cin.getline(input,256);
    outdir = (TString)input;
    //
  } else {
    printf("\n Welcome to  the PAMELA event viewer! \n\n");
    name = (TString)inps[1];
    selfile = (TString)inps[2];
    figlay = atoi(inps[3]);
    dl = atoi(inps[4]);
    outdir = (TString)inps[5];
  };
  //
  ShowEvent(name,selfile,figlay,dl,0,0,outdir);
  //
  return(0);
}
