*************************************************************************
*     
*     Common common_B_outer.f
*     
*     to be included in:
*     - ../magnet/read_B_outer.f
*     - ../magnet/inter_B.f
*     - ../magnet/inter_B_outer.f
*     
*************************************************************************

c      implicit double precision (a-h,o-z)


c     number of measures along X, Y and Z axes
      parameter (nox=13, noy=13, noz=4) 

c     coordinates in m of the edges of the volume in which the field
c     is interpolated according to the inner maps
c     UPPER VOLUME
      double precision edgeuxmin,edgeuxmax,edgeuymin,edgeuymax,
     &     edgeuzmin,edgeuzmax,edgelxmin,edgelxmax,edgelymin,
     &     edgelymax,edgelzmin,edgelzmax
      parameter (edgeuxmin=-0.18)
      parameter (edgeuxmax=0.18)
      parameter (edgeuymin=-0.18)
      parameter (edgeuymax=0.18)
      parameter (edgeuzmin=0.28)
      parameter (edgeuzmax=0.37)
c     LOWER VOLUME
      parameter (edgelxmin=edgeuxmin)
      parameter (edgelxmax=edgeuxmax)
      parameter (edgelymin=edgeuymin)
      parameter (edgelymax=edgeuymax)
      parameter (edgelzmin=-0.37)
      parameter (edgelzmax=-0.28)

************
c     MAGNETIC-FIELD MAP
      double precision pox(nox,3),poy(noy,3),poz(noz,3) !coordinates of measure points:
c     e.g. py1(ny,1) = Y coordinates of Bx (=1) component of magnetic field

      double precision bo(nox,noy,noz,3)     !magnetic field values:
c     e.g. b1(nx,ny,nz,2) = By (=2) component of magnetic field measured in (nx, ny, nz)

      double precision poxmax(3),poxmin(3),
     &     poymax(3),poymin(3),pozmax(3),pozmin(3) 
c     grid edges

      common/interpolationo/pox,poy,poz,bo
     &     ,poxmax,poxmin,poymax,poymin,pozmax,pozmin
      save/interpolationo/
