#include <math.h>
#include <stdio.h>
//
#include <iostream>
#include <iomanip>
#include <fstream>
#if (__GNUC__ == 3) && (__GNUC_MINOR__ == 2)
char* operator+( std::streampos&, char* );
#endif
//
#include <TObjectTable.h>
#include <TGClient.h>
#include <TGButton.h>
#include <TGComboBox.h>
#include <TGLabel.h>
#include <TGTextEntry.h>
#include <TGFrame.h>
#include <TGButtonGroup.h>
#include <TGProgressBar.h>
#include <TGMsgBox.h>
#include <TGComboBox.h>
//
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TLine.h>
#include <TPolyLine.h>
#include <TChain.h>
#include <TApplication.h>
#include <TVirtualX.h>
#include <TGClient.h>
#include <TGWindow.h>
#include <TEllipse.h>
#include <TArrow.h>
#include <TStyle.h>
#include <TStreamerElement.h>
#include <TRealData.h>
//
#include <PamelaRun.h>
#include <physics/calorimeter/CalorimeterEvent.h>
#include <physics/trigger/TriggerEvent.h>
#include <physics/tof/TofEvent.h>
#include <physics/tracker/TrackerEvent.h>
#include <physics/anticounter/AnticounterEvent.h>
#include <physics/neutronDetector/NeutronEvent.h>
#include <physics/S4/S4Event.h>
#include <CalibCalPedEvent.h>
#include <CalibTrk1Event.h>
#include <CalibTrk2Event.h>
//
#include <FEVpathtoc.h>
//
#include <PamLevel2.h>
//
#include <FEVpamevcontrol.h>
#include <FEVdetector.h>
#include <FEventViewer.h>
#include <feventvstruct.h>
#include <color.h>
//
extern Bool_t existfile(TString);
extern Bool_t NODB;
//

using namespace std;

FEVdetector::FEVdetector(TString filename, TString selfile, Int_t &mainctrlword, TCanvas &figure){
  var.thefilename = filename.Data();
  var.thefilter = selfile.Data();
  ctrlword = &mainctrlword;
  thefigure = &figure;
  checkctrlword();
  var.selex = false;
  var.showall = false;

  var.showsi = false;
  var.shownd = false;
  var.shows4 = false;
  var.showorb = false;
  var.showtof = false;
  var.showtrg = false;
  var.showtrk = false;
  var.showcal = false;
  var.showrun = false;
  var.showac = false;
}

void FEVdetector::Reset(){
  L2 = NULL;
}

void FEVdetector::checkctrlword(){
  var.SHOWDEC = 0;
  var.TOF = 0;
  var.AC = 0;
  var.RUN = 1;
  var.TRK = 0;
  var.ORB = 1;
  var.TRG = 1;
  var.CALO = 0;
  var.CALOT = 0;
  var.S4 = 0;
  var.ND = 0;
  var.INFOS = 0;
  var.VINFOS = 0;
  var.PALETTE = 0;
  var.PATTRIG = 1;
  if ( *ctrlword & (1<<0) ) { 
    var.PALETTE = 1;
  };
  if ( *ctrlword & (1<<1) ) { 
    var.VINFOS = 1;
  };
  if ( *ctrlword & (1<<2) ) { 
    var.INFOS = 1;
  };
  if ( *ctrlword & (1<<3) ) {
    var.ND = 1;
  };
  if ( *ctrlword & (1<<4) ) {
    var.S4 = 1;
  };
  if ( *ctrlword & (1<<5) ) { 
    var.CALO = 1;
  };
  if ( *ctrlword & (1<<6) ) {
    var.TRK = 1;
  };
  if ( *ctrlword & (1<<7) ) {
    var.AC = 1;
  };
  if ( *ctrlword & (1<<8) ) {
    var.TOF = 1;
  };
  if ( *ctrlword & (1<<9) ) { 
    var.PATTRIG = 1;
  };
}

void FEVdetector::SetDDEC(TString de){
  ddec=de;
};

void FEVdetector::GetWindow(){
  //
  if ( level.file == 2 ){
    //    printf("0qui\n");
    L2->GetEntry(minevent);
  } else {
    otr->GetEntry(minevent);
  }
  if ( level.file < 2 ){
    ph = eh->GetPscuHeader();
    firstevno = (int)ph->Counter;
  } else {
    if ( var.ORB ){
      firstevno = L2->GetOrbitalInfo()->pkt_num; 
    } else {
      firstevno = 0;
    };
  };
  //
  if ( level.file == 2 ){
    //    printf("1qui\n");
    L2->GetEntry(maxevent);
  } else {
    otr->GetEntry(maxevent);
  }
  //
  if ( level.file < 2 ){
    ph = eh->GetPscuHeader();
    lastevno = (int)ph->Counter;
  } else {
    if ( var.ORB ){
      lastevno = L2->GetOrbitalInfo()->pkt_num; 
    } else {
      lastevno = 0;
    };
  };
  //
}

void FEVdetector::ClearVariables(){
  var.beta[0] = 0.;
  var.beta[1] = 0.;
  var.beta[2] = 0.;
  var.beta[3] = 0.;
  var.beta[4] = 0.;
  var.s4sig = 0.;
  var.nstrip = 0;
  var.qtot = 0;
  var.nclx = 0;
  var.ncly = 0;
  var.trup = 0;
  var.bkup = 0;
  var.bkbo = 0;
  var.hcas = 0;
  var.hcat = 0;
  var.hcard = 0;
}

void FEVdetector::GetEntry(Int_t i){
  thisentry = i;  
  if ( level.file == 2 ){
    //    L2->Clear();
    //    printf("qui\n");
    L2->GetEntry(i);
    if ( var.showall ){
      ShowInfo("RunInfo");
      ShowInfo("SoftInfo");
      ShowInfo("OrbitalInfo");
      ShowInfo("TrigLevel2");
      ShowInfo("ToFLevel2");
      ShowInfo("TrkLevel2");
      ShowInfo("AcLevel2");
      ShowInfo("CaloLevel2");
      ShowInfo("CaloLevel1");
      ShowInfo("S4Level2");
      ShowInfo("NDLevel2");
    } else {
      if ( var.showrun ) ShowInfo("RunInfo");
      if ( var.showsi ) ShowInfo("SoftInfo");
      if ( var.showorb ) ShowInfo("OrbitalInfo");
      if ( var.showtrg ) ShowInfo("TrigLevel2");
      if ( var.showtof ) ShowInfo("ToFLevel2");
      if ( var.showtrk ) ShowInfo("TrkLevel2");
      if ( var.showac ) ShowInfo("AcLevel2");
      if ( var.showcal ) ShowInfo("CaloLevel2");
      if ( var.showcal ) ShowInfo("CaloLevel1");
      if ( var.shows4 ) ShowInfo("S4Level2");
      if ( var.shownd ) ShowInfo("NDLevel2");
    };
  } else {
    otr->GetEntry(i);
    if ( var.showall ){
      ShowInfo("Pscu");
      ShowInfo("Trigger");
      ShowInfo("Tof");
      ShowInfo("Tracker");
      ShowInfo("Anticounter");
      ShowInfo("Calorimeter");
      ShowInfo("S4");
      ShowInfo("Neutron");
    } else {
      if ( var.showorb ) ShowInfo("Pscu");
      if ( var.showtrg ) ShowInfo("Trigger");
      if ( var.showtof ) ShowInfo("Tof");
      if ( var.showtrk ) ShowInfo("Tracker");
      if ( var.showac ) ShowInfo("Anticounter");
      if ( var.showcal ) ShowInfo("Calorimeter");
      if ( var.shows4 ) ShowInfo("S4");
      if ( var.shownd ) ShowInfo("Neutron");
    };
  };
}

void FEVdetector::SetEntry(Int_t i){
  thisentry = i;
}

int FEVdetector::GetCounter(){
  if ( level.file < 2 ){
    ph = eh->GetPscuHeader();
    return((int)ph->Counter);
  } else {
    //    return(thisentry); // to be changed as soon as we will have pkt_counter in the level2 file!
    return((int)L2->GetOrbitalInfo()->pkt_num); // to be changed as soon as we will have pkt_counter in the level2 file!
  };
}

void FEVdetector::SetGUIPtr(PAMevcontrol &mainpamgui){
  pamgui = &mainpamgui;
}

void FEVdetector::DrawX(Float_t cx, Float_t cy, Float_t si, Variables & var){
  Float_t x[2] = {-si*var.sfx,si*var.sfx};
  Float_t y[2] = {-si*var.sfy,si*var.sfy};
  Float_t xb[2];
  Float_t yb[2];
  for (Int_t i = 0; i<2 ; i++){
    xb[i] = x[i]+cx;
    yb[i] = y[i]+cy;	    
  };
  TLine *x2 = new TLine(xb[0],yb[0],xb[1],yb[1]);
  x2->SetLineColor(1);
  x2->SetLineWidth(1);
  x2->Draw();
  //
  Float_t nx[2] = {-si*var.sfx,si*var.sfx};
  Float_t ny[2] = {si*var.sfy,-si*var.sfy};
  Float_t xa[2];
  Float_t ya[2];
  for (Int_t i = 0; i<2 ; i++){
    xa[i] = nx[i]+cx;
    ya[i] = ny[i]+cy;	    
  };
  TLine *x1 = new TLine(xa[0],ya[0],xa[1],ya[1]);
  x1->SetLineColor(1);
  x1->SetLineWidth(1);
  x1->Draw();
}

void FEVdetector::ColorMIP(Float_t mip, int& colo){
  if ( colo > 0 ){
    colo = 10;
    if ( mip > 0.7  ) colo = 38;
    if ( mip > 2.   ) colo = 4;    
    if ( mip > 10.  ) colo = 3;
    if ( mip > 100. ) colo = 2;
    if ( mip > 500. ) colo = 6;
  } else {
    colo = 10;
    if ( mip > 0.7  ) colo = 17;
    if ( mip > 2.   ) colo = 15;    
    if ( mip > 10.  ) colo = 14;
    if ( mip > 100. ) colo = 13;
    if ( mip > 500. ) colo = 12;
  };
}		

void FEVdetector::ColorTOFMIP(Float_t mip, int& colo){
  if ( colo > 0 ){
    colo = 10;
    if ( mip > 0.   ) colo = 38;
    if ( mip > 2.   ) colo = 4;    
    if ( mip > 10.  ) colo = 3;
    if ( mip > 100. ) colo = 2;
    if ( mip > 500. ) colo = 6;
  } else {
    colo = 10;
    if ( mip > 0.   ) colo = 17;
    if ( mip > 2.   ) colo = 15;    
    if ( mip > 10.  ) colo = 14;
    if ( mip > 100. ) colo = 13;
    if ( mip > 500. ) colo = 12;
  };
}

void FEVdetector::ColorTRKMIP(Float_t mip, int& colo, Int_t img){
  if ( !img ){
    if ( colo > 0 ){
      colo = 10;
      if ( mip > 0.   ) colo = 38;
      if ( mip > 2.   ) colo = 4;    
      if ( mip > 10.  ) colo = 3;
      if ( mip > 100. ) colo = 2;
      if ( mip > 500. ) colo = 6;
    } else {
      colo = 10;
      if ( mip > 0.   ) colo = 17;
      if ( mip > 2.   ) colo = 15;    
      if ( mip > 10.  ) colo = 14;
      if ( mip > 100. ) colo = 13;
      if ( mip > 500. ) colo = 12;
    };
  } else {
    if ( colo > 0 ){
      colo = 10;
      if ( mip > 0.   ) colo = 41;
      if ( mip > 2.   ) colo = 42;    
      if ( mip > 10.  ) colo = 43;
      if ( mip > 100. ) colo = 44;
      if ( mip > 500. ) colo = 45;
    } else {
      colo = 10;
      if ( mip > 0.   ) colo = 17;
      if ( mip > 2.   ) colo = 15;    
      if ( mip > 10.  ) colo = 14;
      if ( mip > 100. ) colo = 13;
      if ( mip > 500. ) colo = 12;
    };
  };
}

void FEVdetector::ShowInfo(TString detector){
  //
  TBranch *b1 = 0;
  //  TBranch *b3 = 0;
  TObjArray *branch_array = 0;
  //  TObjArray *leaf_array = 0;		
  //
  if ( !strcmp(detector.Data(),"RunInfo") || !strcmp(detector.Data(),"SoftInfo") ){
    if ( L2->GetRunTree() ) b1 = L2->GetRunTree()->FindBranch(detector.Data());
  } else {
    b1 = otr->FindBranch(detector.Data());
  };
  //
  if ( !b1 ) return;
  //
  Int_t dlen = 10;
  //
  char o[200000];
  char zz[200000];
  char col[13];
  char col2[13];
  //
  setcolor(col,RESET, GREEN, WHITE);
  sprintf(o,"%s======> EVENT:%i\n",col, thisentry);
  sprintf(zz,"======> EVENT:%i\n", thisentry);
  //
  setcolor(col,RESET, RED, WHITE);
  sprintf(o,"%s%sBranch %s\n",o,col,b1->GetName());
  sprintf(zz,"%sBranch %s\n",zz,b1->GetName());
  setcolor(col,RESET, BLACK, WHITE);
  sprintf(o,"%s%s",o,col);
  //
  branch_array = b1->GetListOfBranches();
  //
  Int_t j = 0;
  //
  for(Int_t l=0;l<(branch_array->GetLast()+1);l++){
    //
    TBranchElement *tb = (TBranchElement*)branch_array->At(l);
    Int_t type = tb->GetType();
    Int_t atype = tb->GetStreamerType() - 20;
    //    Int_t len = (tb->GetInfo()->GetLengths())[tb->GetID()];
    Int_t len = tb->GetInfo()->GetLength(tb->GetID());
    Int_t length = min(len,dlen);
    //
    //        printf("Branches : type is %i type is %i tb getname %s  slen %i slength %i\n",atype,type,tb->GetName(),len,length);
    switch (type){
    case 0: 
      //      
      // IS A VARIABLE
      //
      //
      // NAME
      //
      setcolor(col,RESET, BLUE, WHITE);
      setcolor(col2,RESET, BLACK, WHITE);
      sprintf(o,"%s%s %-15s%s =",o,col,((TBranch*)branch_array->At(l))->GetName(),col2);
      sprintf(zz,"%s %-15s =",zz,((TBranch*)branch_array->At(l))->GetName());
      //
      j = 0;
      //
      // VALUES 
      //
      //
      // Integer
      //
      if ( atype == 3 || atype == -17 ){
	while ( j < length ){
	  if ( j < length -1 ){
	    sprintf(o,"%s %i ,",o,(Int_t)tb->GetValue(j,0));
	    sprintf(zz,"%s %i ,",zz,(Int_t)tb->GetValue(j,0));
	  } else {
	    sprintf(o,"%s %i",o,(Int_t)tb->GetValue(j,0));
	    sprintf(zz,"%s %i",zz,(Int_t)tb->GetValue(j,0));
	  };
	  j++;
	};
      };
      //
      // Unsigned integer
      //
      if ( atype == -7 || atype == 13 || atype == -9 || atype == -8 || atype == 12 ){
	while ( j < length ){
	  if ( j < length -1 ){
	    sprintf(o,"%s %u ,",o,(UInt_t)tb->GetValue(j,0));
	    sprintf(zz,"%s %u ,",zz,(UInt_t)tb->GetValue(j,0));
	  } else {
	    sprintf(o,"%s %u",o,(UInt_t)tb->GetValue(j,0));
	    sprintf(zz,"%s %u",zz,(UInt_t)tb->GetValue(j,0));
	  };
	  j++;
	};
      };
      //
      // Float
      //
      if ( atype == -15 || atype == 5 ){
	while ( j < length ){
	  if ( j < length -1 ){
	    sprintf(o,"%s %f ,",o,tb->GetValue(j,0));
	    sprintf(zz,"%s %f ,",zz,tb->GetValue(j,0));
	  } else {
	    sprintf(o,"%s %f",o,tb->GetValue(j,0));
	    sprintf(zz,"%s %f",zz,tb->GetValue(j,0));
	  };
	  j++;
	};
      };
      //
      // Strings
      //
      if ( atype == 45 ){
	// 	TObjArray *cl = (TObjArray*)(tb->GetInfo()->GetOffsets())[tb->GetID()];//tb->GetValuePointer();
	//	TString *stringa = (TString*)(*cl)[0];	
	//	TBranchElement *utb = (TBranchElement*)tb->GetBranchCount();
	//	TString** stringa = (TString*)(&tb->GetValuePointer());
	//TStreamerElement *tste = (TStreamerElement*)tb->GetInfo()->GetCurrentElement();

	//	char *ladd;
	//	ladd = tb->GetValuePointer()
	//	TString *stringa = (TString*)((tste->GetOffset()));
	//	TString& mstr = *stringa;
	//	printf(" la mia stringa %s \n",mstr.Data());
	//	printf(" offset %i \n",(Int_t)utb->GetValue(0,0));
	//	int pointer = (tb->GetInfo()->GetOffsets())[tb->GetID()];
	//	TString *stringa = (TString*)(tb->GetInfo()->GetOffsets())[tb->GetID()];
// 	TString *stringa = (TString*)tb->GetAddress();
// 	printf(" address 0x%X \n",tb->GetAddress());
// 	printf(" pointer 0x%X \n",tb->GetValuePointer());
// 	printf(" object  0x%X \n",tb->GetObject());
// 	printf("stringa %s lung %i\n",stringa.Data(),stringa.Length());
	//	TLeaf *striglia = tb->FindLeaf(tb->GetName());
// 	if ( striglia ){
// 	  char *pointer = (char *)striglia->GetValuePointer();
// 	  TString *pr= (TString*)pointer;
// 	  printf("ciao %s \n",pr->Data());
// 	};
	sprintf(o,"%s TString - not implemented yet -",o);
	sprintf(zz,"%s TString - not implemented yet -",zz);
      };
      //
      // TArray
      //
      if ( atype == 42 ){
	//
// 	TObjArray *cl = (TObjArray*)tb->GetObject();
// 	//
// 	TClass *myc = cl->IsA();
// 	//
// 	printf("qui \n");
// 	//
// 	// determine offset to fetch data
// 	//
// 	int thisoffset = 0;
// 	TRealData *rd = myc->GetRealData(tb->GetName());
// 	if ( rd ){
// 	  thisoffset = rd->GetThisOffset();
// 	};
// 	Int_t niente = 0;
// 	TStreamerElement *tste = tb->GetInfo()->GetStreamerElement(rd->GetName(),niente);
// 	printf(" typename %s \n",tste->GetTypeName());
// 	//
// 	// TArrayI
// 	//
// 	if ( !strcmp(tste->GetTypeName(),"TArrayI") ){
// 	  //
// 	  printf("qua \n");
// 	  char *pointer = (char*)cl->At(0);
// 	  //	  char *pu = thisoffset + pointer;
// 	  int pu = (int)tste->GetTObjectOffset();
// 	  TArrayI arr = (TArrayI)*pu;
// 	  //	  TArrayI arr = (TArrayI)(thisoffset);
// 	  //TArrayI *arr = (TArrayI*)pu;
// 	  //TArraI arr = (TArrayI)
// 	  Int_t jj=0;
// 	  j=0;
// 	  printf("quii \n");
// 	  Int_t arlen = min(arr.GetSize(),dlen);
// 	  //
// 	  printf("que \n");
// 	  setcolor(col,RESET, BLUE, WHITE);
// 	  setcolor(col2,RESET, BLACK, WHITE);
// 	  sprintf(o,"%s%s %s[%i]%s = ",o,col,tb->GetName(),arr.GetSize(),col2);
// 	  //
// 	  //	  while ( j < tb->GetNdata() ){
// 	  //
// 	  printf("quo \n");
// 	  //	    pointer = (char*)cl->UncheckedAt(j);
// 	  //	    pu = pointer + thisoffset;
// 	  //	    arr = (TArrayI*)(thisoffset);
// 	  //
// 	  while ( jj < arlen ){
// 	    if ( jj < arlen-1 ){
// 	      sprintf(o,"%s %i ,",o,arr.At(jj));
// 	    } else {
// 	      sprintf(o,"%s %i",o,arr.At(jj));
// 	    };
// 	    jj++;
// 	  };
// 	    //	    if ( j < tb->GetNdata() -1 ) sprintf(o,"%s ,",o);
// 	    //	    j++;
// 	    //	  };
// 	};
// 	//
// 	// TArrayF
// 	//
// 	if ( !strcmp(tste->GetTypeName(),"TArrayF") ){
// 	  //
// 	  char *pointer = (char*)cl->UncheckedAt(0);
// 	  char *pu = pointer + thisoffset;
// 	  TArrayF *arr = (TArrayF*)(pu);
// 	  Int_t jj=0;
// 	  Int_t arlen = min(arr->GetSize(),dlen);
// 	  //
// 	  setcolor(col,RESET, BLUE, WHITE);
// 	  setcolor(col2,RESET, BLACK, WHITE);
// 	  sprintf(o,"%s%s %s[%i]%s = ",o,col,tb->GetName(),arr->GetSize(),col2);
// 	  //
// 	  while ( j < tb->GetNdata() ){
// 	    //
// 	    pointer = (char*)cl->UncheckedAt(j);
// 	    pu = pointer + thisoffset;
// 	    arr = (TArrayF*)(pu);
// 	    //
// 	    while ( jj < arlen ){
// 	      if ( jj < arlen-1 ){
// 		sprintf(o,"%s %f ,",o,arr->At(jj));
// 	      } else {
// 		sprintf(o,"%s %f",o,arr->At(jj));
// 	      };
// 	      jj++;
// 	    };
// 	    if ( j < tb->GetNdata() -1 ) sprintf(o,"%s ,",o);
// 	    j++;
// 	  };
// 	};
// 	sprintf(o,"%s\n",o);
	//	
	sprintf(o,"%s TArray - not implemented yet -",o);
	sprintf(zz,"%s TArray - not implemented yet -",zz);
	//
      };
      //
      sprintf(o,"%s\n",o);
      sprintf(zz,"%s\n",zz);
      break;
    case 3: 
      //
      // IS A TCLONESARRAY
      // 
      setcolor(col,RESET, BLUE, WHITE);
      setcolor(col2,RESET, BLACK, WHITE);
      sprintf(o,"%s%s %-15s%s = %d\n",o,col,tb->GetName(), col2, tb->GetNdata());
      sprintf(zz,"%s %-15s = %d\n",zz,tb->GetName(), tb->GetNdata());

      //
      if ( tb->GetNdata() ){
	//
	TClonesArray *cl = (TClonesArray*)tb->GetObject();
	//
	TClass *myc = cl->GetClass();
	//
	TList *lme = myc->GetListOfDataMembers();
	TIter next(lme);
	TBranchElement *tb2 = 0;
	//
	while ( (tb2 = (TBranchElement*)next()) ){
	  //
	  const char *name = tb2->GetName();
	  TBranch *foglia = tb->FindBranch(name);
	  if ( foglia ){
	    //
	    TBranchElement *stb = (TBranchElement*)tb->FindBranch(name);
	    Int_t stype = stb->GetType();
	    Int_t satype = stb->GetStreamerType() - 20;
            //	    Int_t slen = (stb->GetInfo()->GetLengths())[stb->GetID()];
	    Int_t slen = stb->GetInfo()->GetLength(stb->GetID());
	    Int_t slength = min(slen,dlen);
	    //	    printf("SubBranches : atype is %i type is %i tb getname %s  slen %i slength %i\n",satype,stype,stb->GetName(),slen,slength);
	    switch (stype){
	    case 31: 
	      //      
	      // IS A VARIABLE
	      //
	      //
	      // NAME
	      //
	      j = 0;
	      //
	      // VALUES 
	      //
	      if ( satype == 41 || satype == 44){
		//
		// skip TRef
		//
		break;
	      };
	      //
	      // Integer
	      //
	      if ( satype == -17 || satype == -9 ){
		//
		setcolor(col,RESET, BLUE, WHITE);
		setcolor(col2,RESET, BLACK, WHITE);
		sprintf(o,"%s%s %-15s%s = ",o,col,foglia->GetName(),col2);
		sprintf(zz,"%s %-15s = ",zz,foglia->GetName());
		while ( j < cl->GetEntriesFast() ){
		  if ( j < cl->GetEntriesFast() -1 ){
		    sprintf(o,"%s %i ,",o,(Int_t)stb->GetValue(j,slength));
		    sprintf(zz,"%s %i ,",zz,(Int_t)stb->GetValue(j,slength));
		  } else {
		    sprintf(o,"%s %i",o,(Int_t)stb->GetValue(j,slength));
		    sprintf(zz,"%s %i",zz,(Int_t)stb->GetValue(j,slength));
		  };
		  j++;
		};
	      };
	      //
	      // Float
	      //
	      if ( satype == -15 ){
		//
		setcolor(col,RESET, BLUE, WHITE);
		setcolor(col2,RESET, BLACK, WHITE);
		sprintf(o,"%s%s %-15s%s = ",o,col,foglia->GetName(),col2);
		sprintf(zz,"%s %-15s = ",zz,foglia->GetName());
		while ( j < cl->GetEntriesFast() ){
		  if ( j < cl->GetEntriesFast() -1 ){
		    sprintf(o,"%s %f ,",o,stb->GetValue(j,slength));
		    sprintf(zz,"%s %f ,",zz,stb->GetValue(j,slength));
		  } else {
		    sprintf(o,"%s %f",o,stb->GetValue(j,slength));
		    sprintf(zz,"%s %f",zz,stb->GetValue(j,slength));
		  };
		  j++;
		};
	      };
	      //
	      // Array of float
	      //
	      if ( satype == 5 ){
		//
		setcolor(col,RESET, BLUE, WHITE);
		setcolor(col2,RESET, BLACK, WHITE);
		sprintf(o,"%s%s %-15s%s = ",o,col,foglia->GetName(),col2);
		sprintf(zz,"%s %-15s = ",zz,foglia->GetName());
		Bool_t bold = true;
		while ( j < tb->GetNdata() ){
		  if ( bold ){
		    setcolor(col,RESET, BLACK, WHITE);
		    sprintf(o,"%s%s",o,col);
		  } else {
		    setcolor(col,BOLD, BLACK, WHITE);
		    sprintf(o,"%s%s",o,col);		    
		  };
		  Int_t jj = 0;		  
		  while ( jj < slength ){		    
		    if ( jj < slength-1 ){
		      sprintf(o,"%s %f ,",o,stb->GetValue(j,jj,true));
		      sprintf(zz,"%s %f ,",zz,stb->GetValue(j,jj,true));
		    } else {
		      sprintf(o,"%s %f",o,stb->GetValue(j,jj,true));
		      sprintf(zz,"%s %f",zz,stb->GetValue(j,jj,true));
		    };
		    jj++;
		  };
		  if ( j < tb->GetNdata() -1 ) sprintf(o,"%s ,",o);
		  if ( j < tb->GetNdata() -1 ) sprintf(zz,"%s ,",zz);
		  if ( !bold ){
		    bold = true;
		  } else {
		    bold = false;
		  };
		  j++;
		};
		if ( bold ){
		  setcolor(col,RESET, BLACK, WHITE);
		  sprintf(o,"%s%s",o,col);
		};
	      };
	      //
	      // Array of integers
	      //
	      if ( satype == 3 ){
		//
		setcolor(col,RESET, BLUE, WHITE);
		setcolor(col2,RESET, BLACK, WHITE);
		sprintf(o,"%s%s %-15s%s = ",o,col,foglia->GetName(),col2);
		sprintf(zz,"%s %-15s = ",zz,foglia->GetName());
		while ( j < tb->GetNdata() ){
		  Int_t jj = 0;
		  while ( jj < slength ){
		    if ( jj < slength-1 ){
		      sprintf(o,"%s %i ,",o,(Int_t)stb->GetValue(j,jj,true));
		      sprintf(zz,"%s %i ,",zz,(Int_t)stb->GetValue(j,jj,true));
		    } else {
		      sprintf(o,"%s %i",o,(Int_t)stb->GetValue(j,jj,true));
		      sprintf(zz,"%s %i",zz,(Int_t)stb->GetValue(j,jj,true));
		    };
		    jj++;
		  };
		  if ( j < tb->GetNdata() -1 ) sprintf(o,"%s ,",o);
		  if ( j < tb->GetNdata() -1 ) sprintf(zz,"%s ,",zz);
		  j++;
		};
	      };

	      //
	      // TArray
	      //
	      if ( satype == 42 ){
		//
		// determine offset to fetch data
		//
		int thisoffset = 0;
		TRealData *rd = myc->GetRealData(foglia->GetName());
		if ( rd ){
		  thisoffset = rd->GetThisOffset();
		};
		Int_t niente = 0;
		TStreamerElement *tste = stb->GetInfo()->GetStreamerElement(rd->GetName(),niente);
		//
		// TArrayI
		//
		if ( !strcmp(tste->GetTypeName(),"TArrayI") ){
		  //
		  char *pointer = (char*)cl->UncheckedAt(0);
		  char *pu = pointer + thisoffset;
		  TArrayI *arr = (TArrayI*)(pu);
		  Int_t jj=0;
		  Int_t arlen = min(arr->GetSize(),dlen);
		  //
		  setcolor(col,RESET, BLUE, WHITE);
		  setcolor(col2,RESET, BLACK, WHITE);
		  sprintf(o,"%s%s %s[%i]%s = ",o,col,foglia->GetName(),arr->GetSize(),col2);
		  sprintf(zz,"%s %s[%i] = ",zz,foglia->GetName(),arr->GetSize());
		  //
		  while ( j < tb->GetNdata() ){
		    //
		    pointer = (char*)cl->UncheckedAt(j);
		    pu = pointer + thisoffset;
		    arr = (TArrayI*)(pu);
		    //
		    while ( jj < arlen ){
		      if ( jj < arlen-1 ){
			sprintf(o,"%s %i ,",o,arr->At(jj));
			sprintf(zz,"%s %i ,",zz,arr->At(jj));
		      } else {
			sprintf(o,"%s %i",o,arr->At(jj));
			sprintf(zz,"%s %i",zz,arr->At(jj));
		      };
		      jj++;
		    };
		    if ( j < tb->GetNdata() -1 ) sprintf(o,"%s ,",o);
		    if ( j < tb->GetNdata() -1 ) sprintf(zz,"%s ,",zz);
		    j++;
		  };
		};
		//
		// TArrayF
		//
		if ( !strcmp(tste->GetTypeName(),"TArrayF") ){
		  //
		  char *pointer = (char*)cl->UncheckedAt(0);
		  char *pu = pointer + thisoffset;
		  TArrayF *arr = (TArrayF*)(pu);
		  Int_t jj=0;
		  Int_t arlen = min(arr->GetSize(),dlen);
		  //
		  setcolor(col,RESET, BLUE, WHITE);
		  setcolor(col2,RESET, BLACK, WHITE);
		  sprintf(o,"%s%s %s[%i]%s = ",o,col,foglia->GetName(),arr->GetSize(),col2);
		  sprintf(zz,"%s %s[%i] = ",zz,foglia->GetName(),arr->GetSize());
		  //
		  while ( j < tb->GetNdata() ){
		    //
		    pointer = (char*)cl->UncheckedAt(j);
		    pu = pointer + thisoffset;
		    arr = (TArrayF*)(pu);
		    //
		    while ( jj < arlen ){
		      if ( jj < arlen-1 ){
			sprintf(o,"%s %f ,",o,arr->At(jj));
			sprintf(zz,"%s %f ,",zz,arr->At(jj));
		      } else {
			sprintf(o,"%s %f",o,arr->At(jj));
			sprintf(zz,"%s %f",zz,arr->At(jj));
		      };
		      jj++;
		    };
		    if ( j < tb->GetNdata() -1 ) sprintf(o,"%s ,",o);
		    if ( j < tb->GetNdata() -1 ) sprintf(zz,"%s ,",zz);
		    j++;
		  };
		};
	      };
	      sprintf(o,"%s\n",o);
	      sprintf(zz,"%s\n",zz);
	      break;	    
	    };
	  };
	};
      };
      break;
    };
  };  
  printf("%s\n",o);
  pamgui->DIALOG(4,zz);
};


void FEVdetector::GetGeneralInfo(){
  //
  // Get Orbital Time information and header event number
  //
  if ( level.file < 2 ){
    ph = eh->GetPscuHeader();
    headcold = headc;
    headc = ph->Counter;
    var.headc = (int)ph->Counter;
    OBT = (UInt_t)ph->OrbitalTime;
    DOBT = OBT - OOBT;
    OOBT = OBT;
    if ( thisentry == minevent || DOBT < 0 || (headc-headcold-1)!=0 ) DOBT = 0;
    var.etime = OBT;
    //	    
    // who gave the trigger?
    //
    calotrig = 0;
    if ( trigger->patterntrig[0] ) calotrig = 1;
    toftrig = 0;
    if ( trigger->patterntrig[2] || trigger->patterntrig[3] || trigger->patterntrig[4] || trigger->patterntrig[5] ) toftrig = 1;
    s4pulser = 0;
    if ( trigger->patterntrig[1] & (1<<0) ) s4pulser = 1;
    //
    // TOF and calorimeter when giving a trigger will always set this flag since the time window of the signal is greater than 100 ns.
    // S4 sometimes could not set the flag even if the trigger is given. This is a workaround to fix this "bug":
    //
    if ( !calotrig && !toftrig ) s4pulser = 1;
    //
    Int_t trigconf = trigger->trigconf;
    stringstream trc;
    trc.str("");
    if ( trigconf & (1<<0) ) trc << "TOF1"; 
    if ( trigconf & (1<<1) ) trc << " TOF2"; 
    if ( trigconf & (1<<2) ) trc << " TOF3";
    if ( trigconf & (1<<3) ) trc << " TOF4";
    if ( trigconf & (1<<4) ) trc << " TOF5";
    if ( trigconf & (1<<5) ) trc << " TOF6";
    if ( trigconf & (1<<6) ) trc << " TOF7";
    if ( trigconf & (1<<7) ) trc << " S4";
    if ( trigconf & (1<<8) ) trc << " CALO";
    if ( trigconf & (1<<9) ) trc << " CALIB_ON";
    trcs = (TString)trc.str().c_str();
  } else {
    headcold = headc;
    if ( var.RUN ){
      var.idrun = L2->GetRunInfo()->ID;
      var.idroot = L2->GetRunInfo()->ID_ROOT_L0;
      var.EVF = L2->GetRunInfo()->EV_FROM;
    };
    if ( var.ORB ){
      headc = L2->GetOrbitalInfo()->pkt_num; 
      OBT = L2->GetOrbitalInfo()->OBT; 
      DOBT = OBT - OOBT;
      OOBT = OBT;
      if ( thisentry == minevent || DOBT < 0 || (headc-headcold-1)!=0 ) DOBT = 0;
      var.etime = OBT;
    } else {
      var.etime = 0;
    };
    //	    
    // who gave the trigger?
    //
    Int_t trigconf = 0;
    if ( var.TRG ){
      calotrig = 0;
      if ( L2->GetTrigLevel2()->patterntrig[0] ) calotrig = 1;
      toftrig = 0;
      if ( L2->GetTrigLevel2()->patterntrig[2] || L2->GetTrigLevel2()->patterntrig[3] || L2->GetTrigLevel2()->patterntrig[4] || L2->GetTrigLevel2()->patterntrig[5] ) toftrig = 1;
      s4pulser = 0;
      if ( L2->GetTrigLevel2()->patterntrig[1] & (1<<0) ) s4pulser = 1;
      //
      // TOF and calorimeter when giving a trigger will always set this flag since the time window of the signal is greater than 100 ns.
      // S4 sometimes could not set the flag even if the trigger is given. This is a workaround to fix this "bug":
      //
      if ( !calotrig && !toftrig ) s4pulser = 1;
      //
      trigconf = L2->GetTrigLevel2()->trigconf;
    } else {
      trigconf = 0;
    }
    stringstream trc;
    trc.str("");
    if ( trigconf & (1<<0) ) trc << "TOF1"; 
    if ( trigconf & (1<<1) ) trc << " TOF2"; 
    if ( trigconf & (1<<2) ) trc << " TOF3";
    if ( trigconf & (1<<3) ) trc << " TOF4";
    if ( trigconf & (1<<4) ) trc << " TOF5";
    if ( trigconf & (1<<5) ) trc << " TOF6";
    if ( trigconf & (1<<6) ) trc << " TOF7";
    if ( trigconf & (1<<7) ) trc << " S4";
    if ( trigconf & (1<<8) ) trc << " CALO";
    if ( trigconf & (1<<9) ) trc << " CALIB_ON";
    trcs = (TString)trc.str().c_str();
  };
}


int FEVdetector::SelectEvent(){
  //
  //
  //
  Int_t isOK = 1;
  Bool_t insel = var.selex;
  Bool_t ispktnum = false;
  //
  if ( var.doflag == 3 ){
    thisentry = si;
    var.jumpto = 0;
    var.jumpen = false;
    insel = false;
  };
  //
  if ( var.jumpto ){
    ispktnum = true;
    isOK = 0;
    Int_t cjumpto = GetCounter();
    if ( cjumpto == var.jumpto ){
      var.jumpto = 0;
      var.jumpen = false;
      isOK = 1;
    };
    if ( var.jumpto && (thisentry == maxevent || thisentry == si) ) {
      if ( var.jumpen && thisentry == maxevent ) {
	thisentry = -1;
	var.jumpen = false;
	} else {
	var.jumpen = false;
	thisentry = si;
	printf(" WARNING: NO EVENT WITH PACKET NUMBER %i \n",var.jumpto);
	stringstream dialog;
	dialog.str("");
	dialog << " No event with packet number ";
	dialog << var.jumpto;
	pamgui->DIALOG(1,dialog.str().c_str());
	var.jumpto = 0;
	isOK = 1;
      };
    };
  };
  if ( insel && !ispktnum ){
    isOK = 0;
    //
    // check if we have reached the first or last event
    //
    if ( thisentry == minevent || thisentry == maxevent ){
      isOK = 1;
      if ( thisentry == minevent && var.doflag==2 ) pamgui->DIALOG(1," Stop searching, first event reached ");
      if ( thisentry == maxevent && var.doflag==1 ) pamgui->DIALOG(1," Stop searching, last event reached ");
    } else {
      //
      // if level = -1 determine higher level variables and store them in structure "var"
      //
      if ( level.file == -1 ){
	thefigure->cd();
	ShowS4(false);
	thefigure->cd();
	ShowTRK(false);
	thefigure->cd();
	ShowCalo(false);
      };
      //
      // here we pass to the interpreter pointer to the L2 pointer or the data tree and the structure of other variables
      //
      stringstream cintcom;
      //
      if ( level.file == 2 ){
	cintcom.str("");
	cintcom << "PamLevel2 *L2 = (PamLevel2*)" << hex; //con const e l2 funziona
	cintcom << L2;
	gROOT->ProcessLine(cintcom.str().c_str());
	//	printf(" comando: %s \n",cintcom.str().c_str());
      } else {
	cintcom.str("");
	cintcom << "TTree *otr = (TTree*)" << hex;
	cintcom << otr;
	gROOT->ProcessLine(cintcom.str().c_str());
	//
	cintcom.str("");
	cintcom << "struct Variables &var = (struct Variables &)" << hex;
	cintcom << &var;
	gROOT->ProcessLine(cintcom.str().c_str());
      };
      //
      // call the selection routine for the correct level
      //
      if ( level.file ==  0 ) isOK = gApplication->ProcessLine("filter((TTree *)otr,0,(Variables &)var);");
      //
      if ( level.file == -1 ) isOK = gApplication->ProcessLine("filter((TTree *)otr,-1,(Variables &)var);");
      //
      //      if ( level.file ==  2 ) isOK = gApplication->ProcessLine("filter((PamLevel2 *)L2,2);");
      if ( level.file ==  2 ) isOK = gApplication->ProcessLine("filter();");
      //
      // progress bar in text window
      //
      printf("Scanning data: %d%c done",100*(thisentry-minevent)/(maxevent-minevent),37);
      fflush(stdout);
    };
  };
  //
  return(isOK);
  //
}

TChain* FEVdetector::Load(TString file){
  //
  //  file = &mainfile;
  //
  if ( level.file == 2 ){
    //
    //    printf(" %s \n",ddec.Data());
    if ( !L2 ){
      L2 = new PamLevel2("",file.Data(),ddec.Data()); 
      if ( NODB ) L2->NoDBconnections();
      otr = L2->GetPamTree();
      //      printf(" l2 constructor\n");
      //      printf(" abst %u obt %u qtot %f \n",L2->GetOrbitalInfo()->absTime,L2->GetOrbitalInfo()->OBT,L2->GetCaloLevel2()->qtot);    
    } else {
      //
      //      printf(" l2 already exist \n");
      otr = L2->GetPamTree(gSystem->DirName(file.Data()),file.Data(),ddec.Data()); 
      L2->GetRunTree(gSystem->DirName(file.Data()),file.Data()); 
      //
    };
    //
    //
    if ( !otr ) return(0);
    //
    //    otr->CanDeleteRefs(true);
    //    if ( runtree ) runtree->CanDeleteRefs(true);
    //
  } else {
    //
    // load calorimeter ADC2MIP conversion file
    //
    const char *pam_calib = pathtocalibration();
    stringstream calfile;
    calfile.str("");
    calfile << pam_calib << "/cal-param/FCaloADC2MIP.dat";
    //
    FILE *f = 0;
    printf("\n Using ADC to MIP conversion file: \n %s \n",calfile.str().c_str());
    f = fopen(calfile.str().c_str(),"rb");
    if ( !f ){
      printf(" CALORIMETER - ERROR: no ADC to MIP file! using 26.0 for all strips\n");
      for (Int_t m = 0; m < 2 ; m++ ){
	for (Int_t k = 0; k < 22; k++ ){
	  for (Int_t l = 0; l < 96; l++ ){
	    mip[m][k][l] = 26.;
	  };
	};
      };
    } else {
      //
      for (Int_t m = 0; m < 2 ; m++ ){
	for (Int_t k = 0; k < 22; k++ ){
	  for (Int_t l = 0; l < 96; l++ ){
	    fread(&mip[m][k][l],sizeof(mip[m][k][l]),1,f);
	  };
	};
      };
      fclose(f);
    };
    //
    // if not level2 file we must look for at least one calorimeter calibration
    //   
    Calo1stcalib();
    //
  };
  //
  //
  // Load level0 file if the case
  //
  if ( level.file == 0 || level.file == -1 ){
    //
    trigger = new pamela::trigger::TriggerEvent();
    eh = new pamela::EventHeader();
    ph = new pamela::PscuHeader();
    de = new pamela::calorimeter::CalorimeterEvent();
    trk = new pamela::tracker::TrackerEvent();
    ne = new pamela::neutron::NeutronEvent();
    ace = new pamela::anticounter::AnticounterEvent();
    s4 = new pamela::S4::S4Event();
    tof = new pamela::tof::TofEvent();
    //
    otr = new TChain("Physics");
    otr->Add(file.Data(),-1);
    otr->SetBranchAddress("Trigger", &trigger); 
    otr->SetBranchAddress("Header", &eh); 
  };
  //
  if ( var.TRK ) {
    if ( level.file == 0 || level.file == -1 ){
      printf("Show the Tracker detector, LEVEL0 data \n");
      otr->SetBranchAddress("Tracker", &trk);    
    };
    if ( level.file == 2 ){
      printf("Show the Tracker detector, LEVEL1 data \n");
      printf("Get the track informations (LEVEL2 Tracker data)\n");
    };
  };
  //
  if ( var.CALO ) {
    if ( level.file == 0 ){
      printf("Show the Calorimeter detector, LEVEL0 data \n");
      otr->SetBranchAddress("Calorimeter", &de); 
    };
    if ( level.file == -1 ){
      otr->SetBranchAddress("Calorimeter", &de); 
      printf("Show the Calorimeter detector, rough calibration of data \n");
    };
    if ( level.file == 2 ){
      printf("Show the Calorimeter detector, LEVEL2 data \n");
    };
  };
  //
  if ( var.ND ) {
    if ( level.file == 0 || level.file == -1 ){
      printf("Show the Neutron Detector, LEVEL0 data \n");
      otr->SetBranchAddress("Neutron", &ne);    
    };
    if ( level.file == 2 ){
      printf("Show the Neutron Detector, LEVEL2 data \n");
    };
  };
  //
  if ( var.AC ) {
    if ( level.file == 0 || level.file == -1 ){
      printf("Show the Anticounters detector, LEVEL0 data \n");
      otr->SetBranchAddress("Anticounter", &ace);    
    };
    if ( level.file == 2 ){
      printf("Show the Anticounter Detector, LEVEL2 data \n");
    };
  };
  //
  if ( var.S4 ) {
    if ( level.file == 0 ){
      printf("Show the S4 detector, LEVEL0 data \n");
    };
    if ( level.file == -1 ){
      otr->SetBranchAddress("S4", &s4); 
      printf("Show the S4 detector, rough calibration of data \n");
    };
    if ( level.file == 2 ){
      printf("Show the S4 detector, LEVEL2 data \n");
    };
  };  
  //
  if ( var.TOF ) {
    if ( level.file == 0 ){
      printf("Show the Time of Flight detector, LEVEL0 data \n");
    };
    if ( level.file == -1 ){
      otr->SetBranchAddress("Tof", &tof);
      printf("Show the Time of Flight detector, rough calibration of data \n");
    };
    if ( level.file == 2 ){
      printf("Show the Time of Flight detector, LEVEL2 data \n");
    };
  };
  //
  if ( !otr ){
    return(0);
  };
  //
  return otr;
  //    
}

bool bit(int decimal, char pos)
{
  return( (decimal>>pos)%2 );
}
//
// THE PATTERN TRIGGER
//
void FEVdetector::ShowTRG(){
  //
  if ( level.file != 2 ) return;
  //
  if ( !var.TRG ) return;
  //
  int S11[8];
  S11[0] = 0;
  S11[1] = 0;
  S11[2] = 0;
  S11[3] = 0;
  S11[4] = 0;
  S11[5] = 0;
  S11[6] = 0;
  S11[7] = 0;

  int S12[6];
  S12[0] = 0;
  S12[1] = 0;
  S12[2] = 0;
  S12[3] = 0;
  S12[4] = 0;
  S12[5] = 0;

  int S21[2];
  S21[0] = 0;
  S21[1] = 0;

  int S22[2];
  S22[0] = 0;
  S22[1] = 0;

  int S31[3];
  S31[0] = 0;
  S31[1] = 0;
  S31[2] = 0;

  int S32[3];
  S32[0] = 0;
  S32[1] = 0;
  S32[2] = 0;

  //S3
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],0) ) S31[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],1) ) S31[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],2) ) S31[2]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],3) ) S31[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],4) ) S31[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],5) ) S31[2]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],6) ) S32[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],7) ) S32[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],8) ) S32[2]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],9) ) S32[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],10) ) S32[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[2],11) ) S32[2]++;
  //S2
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],0) ) S21[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],1) ) S21[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],2) ) S21[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],3) ) S21[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],4) ) S22[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],5) ) S22[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],6) ) S22[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[3],7) ) S22[1]++;
  //S12
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],0) ) S12[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],1) ) S12[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],2) ) S12[2]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],3) ) S12[3]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],4) ) S12[4]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],5) ) S12[5]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],6) ) S12[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],7) ) S12[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],8) ) S12[2]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],9) ) S12[3]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],10) ) S12[4]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[4],11) ) S12[5]++;
  //S11
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],0) ) S11[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],1) ) S11[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],2) ) S11[2]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],3) ) S11[3]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],4) ) S11[4]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],5) ) S11[5]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],6) ) S11[6]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],7) ) S11[7]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],8) ) S11[0]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],9) ) S11[1]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],10) ) S11[2]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],11) ) S11[3]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],12) ) S11[4]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],13) ) S11[5]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],14) ) S11[6]++;
  if ( bit(L2->GetTrigLevel2()->patterntrig[5],15) ) S11[7]++;


  //
  Int_t rj = 0;
  Float_t xs2x = var.xxvc;
  Float_t ys2x = var.yxvc + 0.36*var.sfy;
  Float_t xs2y = var.xyvc;
  Float_t ys2y = var.yyvc + 0.36*var.sfy;
  Float_t ws2 = 0.005;
  Float_t ws13 = 0.007;
  Int_t noadc;
  if ( var.bw ){
    noadc=12;
  } else {
    noadc=kRed;
  };
  //
  // S11  X-view
  //
  Float_t s11p = 0.051;
  TPolyLine *ftrg11x[8];
  for ( Int_t j=0; j<8; j++){
    Float_t nxc1[5]={ (s11p*j),       (s11p*j),               s11p*(j+1),     s11p*(j+1), (s11p*j)};
    Float_t nyc1[5]={ 0.,                       ws13,     ws13,   0.,  0.};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
      nxc[i]= xs2x + (-0.204+nxc1[i])*var.sfx;
      nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
    };
    ftrg11x[j] = new TPolyLine(5,nxc,nyc);
    ftrg11x[j]->SetLineColor(noadc);
    ftrg11x[j]->SetLineWidth(S11[j]);
    if ( S11[j] )  ftrg11x[j]->Draw();
  };
  //
  // S12  Y-view
  //
  Float_t s12p = 0.055;
  TPolyLine *ftrg12y[6];
  rj = 6;
  for ( Int_t j=0; j<6; j++){
    rj--;
    Float_t nxc1[5]={ (s12p*j),       (s12p*j),               s12p*(j+1), s12p*(j+1),    (s12p*j)};
    Float_t nyc1[5]={      -ws13,     0.,  0., -ws13, -ws13};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
      nxc[i]= xs2y + (-0.165+nxc1[i])*var.sfx;
      nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
    };
    ftrg12y[j] = new TPolyLine(5,nxc,nyc);
    ftrg12y[j]->SetLineColor(noadc);
    ftrg12y[j]->SetLineWidth(S12[rj]);
    if ( S12[rj] ) ftrg12y[j]->Draw();
  };

  
  //
  // S21  Y-view
  //
  Float_t s21p = 0.075;
  TPolyLine *ftrg21y[2];
  rj=2;
  for ( Int_t j=0; j<2; j++){
    rj--;
    Float_t nxc1[5]={ s21p*(j-1),       s21p*(j-1),               s21p*j,s21p*j,     s21p*(j-1)};
    Float_t nyc1[5]={ 0.,                ws2,     ws2,  0.,  0.};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
      nxc[i]= xs2y + nxc1[i]*var.sfx;
      nyc[i] = ys2y + nyc1[i]*var.sfy;
      //      printf(" TRG i %i x %f y %f \n",i,nxc[i],nyc[i]);
    };
    ftrg21y[j] = new TPolyLine(5,nxc,nyc);
    ftrg21y[j]->SetLineColor(noadc);
    ftrg21y[j]->SetLineWidth(S21[j]);
    if ( S21[j]) ftrg21y[j]->Draw();
  };

  //
  // S22  X-view
  //
  Float_t s22p = 0.090;
  TPolyLine *ftrg22x[2];
  for ( Int_t j=0; j<2; j++){
    Float_t nxc1[5]={ s22p*(j-1),       s22p*(j-1),               s22p*j, s22p*j,     s22p*(j-1)};
    Float_t nyc1[5]={                -ws2,   0., 0.,  -ws2,  -ws2};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
      nxc[i]= xs2x + nxc1[i]*var.sfx;
      nyc[i] = ys2x + nyc1[i]*var.sfy;
    };
    ftrg22x[j] = new TPolyLine(5,nxc,nyc);
    ftrg22x[j]->SetLineColor(noadc);
    ftrg22x[j]->SetLineWidth(S22[j]);
    if ( S22[j] ) ftrg22x[j]->Draw();
  };
  //
  // S31  X-view
  //
  Float_t s31p = 0.060;
  TPolyLine *ftrg31x[3];
  for ( Int_t j=0; j<3; j++){
    Float_t nxc1[5]={ (s31p*j),       (s31p*j),               s31p*(j+1), s31p*(j+1),       (s31p*j)};
    Float_t nyc1[5]={ 0.,                       ws13,     ws13,    0.,    0.};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
      nxc[i]= xs2x + (-0.090+nxc1[i])*var.sfx;
      nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
    };
    ftrg31x[j] = new TPolyLine(5,nxc,nyc);
    ftrg31x[j]->SetLineColor(noadc);
    ftrg31x[j]->SetLineWidth(S31[j]);
    if ( S31[j] ) ftrg31x[j]->Draw();
  };

  //
  // S32  Y-view
  //
  Float_t s32p = 0.050;
  TPolyLine *ftrg32y[3];
  rj = 3;
  for ( Int_t j=0; j<3; j++){
    rj--;
    Float_t nxc1[5]={ (s32p*j),       (s32p*j),               s32p*(j+1),s32p*(j+1),     (s32p*j)};
    Float_t nyc1[5]={     -ws13,     0.,    0., -ws13, -ws13};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
      nxc[i]= xs2y + (-0.075+nxc1[i])*var.sfx;
      nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
    };
    ftrg32y[j] = new TPolyLine(5,nxc,nyc);
    ftrg32y[j]->SetLineColor(noadc);
    ftrg32y[j]->SetLineWidth(S32[rj]);
    if ( S32[rj] ) ftrg32y[j]->Draw();
  }
}

void FEVdetector::DisplayEvent(){
  TLatex *text=new TLatex();
  stringstream testo;
  stringstream testo2;
  stringstream testo3;
  //
  //
  //
  thefigure->Clear();
  //
  // show TOF
  // 	
  thefigure->cd();	
  ShowTOF();
  //
  // show pattern trigger if the case
  //
  thefigure->cd();
  if ( var.PATTRIG ){
    ShowTRG();
    thefigure->Modified();
    thefigure->Update();
  }
  //
  // show anticounters
  //
  thefigure->cd();	
  ShowAC();		
  //
  // show S4
  //
  thefigure->cd();	
  ShowS4(true);		
  //
  // show neutron detector
  //
  thefigure->cd();	
  ShowND();
  //
  // show track
  //
  thefigure->cd();	
  ShowTrack();
  //
  // show tracker
  //
  thefigure->cd();	
  ShowTRK(true);
  //
  // show calorimeter
  //	
  thefigure->cd();	
  ShowCalo(true);
  //
  // SHOW INFOS
  //
  if ( var.INFOS ){
    thefigure->cd();
    text->SetTextAngle(0);
    text->SetTextFont(32);
    text->SetTextColor(1);
    text->SetTextSize(0.025); // 0.02
    text->SetTextAlign(12);
    Float_t txthi = 0.47;
    testo.str("");
    testo << "File: " << gSystem->BaseName(var.thefilename.Data());
    //		testo << "File: " << file;
    testo << " - Pkt_num: " << (int)headc;
    text->DrawLatex(0.33,txthi,testo.str().c_str());
    txthi -= 0.03;
    testo.str("");
    testo << "Progressive number: " << (thisentry+1);
    if ( s4pulser ){
      testo << "   - S4 trigger - ";
    };
    if ( calotrig ){
      testo << "   - CALO trigger - ";
    };
    text->DrawLatex(0.33,txthi,testo.str().c_str());
    txthi -= 0.03;
    testo2.str("");
    testo2 << "On Board Time: " << (unsigned int)OBT;
    if ( DOBT > 0 ) {		    
      testo2 << " (delta: " << (unsigned int)DOBT;
      testo2 << ")";
    };
    testo2 << " [ms]";
    text->DrawLatex(0.33,txthi,testo2.str().c_str());
    txthi -= 0.03;
    text->SetTextSize(0.020); // 0.015
    const char *trc2 = trcs;
    testo3.str("");
    testo3 << "TRIGGER: " << trc2;
    text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
    txthi -= 0.03;
    testo3.str("");
    testo3 << "AC: CARD hit = " << var.hcard;
    testo3 << "  CAT hit = " << var.hcat;
    testo3 << "  CAS hit = " << var.hcas;
    text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
    txthi -= 0.03;
    testo3.str("");
    if ( level.file == 2 ){
      testo3 << "TRK:  RIG = " << setprecision(3) << var.rig;
      testo3 << " [GV] CHI2 = " << setprecision(3) << var.chi2;
    } else {
      testo3 << "TRK:  NCLX = "<< var.nclx;
      testo3 << "  NCLY = "<<var.ncly;
    };
    text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
    txthi -= 0.03;
    testo3.str("");
    testo3 << "CALO: NSTRIP = " << var.nstrip;
    testo3 << "  QTOT = "<<var.qtot << " [MIP]";
    text->DrawLatex(0.33,txthi,testo3.str().c_str());
    txthi -= 0.03;
    testo3.str("");
    testo3 << "S4: ";// << setprecision(2);
    testo3 << var.s4sig << " [MIP]   TOF: #beta = ";
    testo3 << setprecision(3) << var.beta[4];
    if ( level.file == 2 ){
      testo3 << " SVL cutoff: ";
      testo3 << setprecision(3) << L2->GetOrbitalInfo()->GetCutoffSVL();//quiquiqui
    }
    text->DrawLatex(0.33,txthi,testo3.str().c_str());	    
    txthi -= 0.03;
    testo3.str("");
    testo3 << "ND: Trig: " << var.trup;
    testo3 << "  - Bckgr: upper = " << var.bkup;
    testo3 << " lower = " << var.bkbo;
    text->DrawLatex(0.33,txthi,testo3.str().c_str());
    txthi -= 0.03;
    text->SetTextSize(0.01);
    text->DrawLatex(var.xxvc-0.040*var.sfx,var.yxvc-0.519*var.sfy,"SATELLITE (CPU) SIDE");
    text->SetTextAngle(90);
    text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc+0.065*var.sfy,"SATELLITE (CPU) SIDE");
    text->DrawLatex(var.xyvc-0.17*var.sfx,var.yyvc+0.075*var.sfy,"VME SIDE");
    if ( var.AC ){
      text->SetTextAngle(90);
      text->DrawLatex(var.xcat-0.235*var.sfx,var.ycat-0.025*var.sfy,"VME SIDE");
      text->DrawLatex(var.xcat+0.235*var.sfx,var.ycat-0.025*var.sfy,"CPU SIDE");
      //
      text->SetTextAngle(0);
      text->SetTextSize(0.015);	    
      TEllipse *elli = new TEllipse(var.xcat+0.219*var.sfx,var.ycat-0.249*var.sfy,0.003,0.003);
      elli->Draw();
      text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.261*var.sfy,"z");
      TArrow *arr;
      arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.22*var.sfx,var.ycat-0.21*var.sfy);
      arr->SetArrowSize(0.005);
      arr->Draw();
      text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.21*var.sfy,"x");
      arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.18*var.sfx,var.ycat-0.25*var.sfy);
      arr->SetArrowSize(0.005);
      arr->Draw();
      text->DrawLatex(var.xcat+0.18*var.sfx,var.ycat-0.261*var.sfy,"y");
      text->SetTextSize(0.01);
    };
    //
    // coordinates systems and x/y view labels
    //
    thefigure->cd();
    text->SetTextAngle(0);
    text->SetTextFont(32);
    text->SetTextColor(1);	
    text->SetTextAlign(12);
    text->SetTextSize(0.01);
    text->DrawLatex(var.xxvc-0.025*var.sfx,var.yxvc+0.67*var.sfy,"X VIEW");
    text->DrawLatex(var.xyvc-0.025*var.sfx,var.yyvc+0.67*var.sfy,"Y VIEW");
    //
    text->SetTextSize(0.015);	    
    text->SetTextFont(2);
    DrawX(var.xxvc-0.25*var.sfx,var.yxvc-0.328*var.sfy,0.005,var); //508
    text->SetTextFont(32);
    text->DrawLatex(var.xxvc-0.266*var.sfx,var.yxvc-0.328*var.sfy,"y");
    TArrow *arr;
    arr = new TArrow(var.xxvc-0.25*var.sfx,var.yxvc-0.328*var.sfy,var.xxvc-0.21*var.sfx,var.yxvc-0.328*var.sfy);
    arr->SetArrowSize(0.005);
    arr->Draw();
    text->DrawLatex(var.xxvc-0.21*var.sfx,var.yxvc-0.335*var.sfy,"x");
    arr = new TArrow(var.xxvc-0.25*var.sfx,var.yxvc-0.328*var.sfy,var.xxvc-0.25*var.sfx,var.yxvc-0.288*var.sfy);
    arr->SetArrowSize(0.005);
    arr->Draw();
    text->DrawLatex(var.xxvc-0.266*var.sfx,var.yxvc-0.288*var.sfy,"z");
    //
    text->SetTextSize(0.015);	    
    text->SetTextFont(2);
    DrawX(var.xyvc+0.24*var.sfx,var.yyvc-0.328*var.sfy,0.005,var);
    text->SetTextFont(32);
    text->DrawLatex(var.xyvc+0.25*var.sfx,var.yyvc-0.328*var.sfy,"x");
    arr = new TArrow(var.xyvc+0.24*var.sfx,var.yyvc-0.328*var.sfy,var.xyvc+0.2*var.sfx,var.yyvc-0.328*var.sfy);
    arr->SetArrowSize(0.005);
    arr->Draw();
    text->DrawLatex(var.xyvc+0.19*var.sfx,var.yyvc-0.335*var.sfy,"y");
    arr = new TArrow(var.xyvc+0.24*var.sfx,var.yyvc-0.328*var.sfy,var.xyvc+0.24*var.sfx,var.yyvc-0.288*var.sfy);
    arr->SetArrowSize(0.005);
    arr->Draw();
    text->DrawLatex(var.xyvc+0.25*var.sfx,var.yyvc-0.288*var.sfy,"z");	    
    text->SetTextSize(0.01);
    //
  };
  //
  // SHOW PALETTE
  //
  thefigure->cd();
  if ( var.PALETTE ) ShowPalette();
  //
  // SHOW VERBOSE INFOS
  //
  if ( var.VINFOS ){
    thefigure->cd();
    text->SetTextAngle(0);
    text->SetTextFont(32);
    text->SetTextColor(1);
    text->SetTextSize(0.01);
    text->SetTextAlign(12);
    if ( var.AC ){
      //
      // Plane view
      //
      text->SetTextAngle(90);
      text->DrawLatex(var.xcat+0.1*var.sfx,var.ycat-0.015*var.sfy,"CARD4");
      text->SetTextAngle(-90);
      text->DrawLatex(var.xcat-0.1*var.sfx,var.ycat+0.015*var.sfy,"CARD1");
      text->SetTextAngle(0);
      text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat-0.116*var.sfy,"CARD2");
      text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat+0.116*var.sfy,"CARD3");		
      text->SetTextAngle(90);
      text->DrawLatex(var.xcat+0.13*var.sfx,var.ycat-0.015*var.sfy,"CAS3");
      text->SetTextAngle(-90);
      text->DrawLatex(var.xcat-0.13*var.sfx,var.ycat+0.015*var.sfy,"CAS4");
      text->SetTextAngle(0);
      text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat-0.140*var.sfy,"CAS2");
      text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat+0.140*var.sfy,"CAS1");	       
      text->DrawLatex(var.xcat+0.17*var.sfx,var.ycat,"CAT1");
      text->DrawLatex(var.xcat-0.2*var.sfx,var.ycat,"CAT2");
      text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat-0.198*var.sfy,"CAT3");
      text->DrawLatex(var.xcat-0.015*var.sfx,var.ycat+0.198*var.sfy,"CAT4");
      //
      // X and Y views
      //
      text->DrawLatex(var.xxvc-0.192*var.sfx,var.yxvc-0.08*var.sfy,"CAS2");
      text->DrawLatex(var.xxvc+0.17*var.sfx,var.yxvc-0.08*var.sfy,"CAS1");
      text->DrawLatex(var.xyvc-0.192*var.sfx,var.yyvc-0.08*var.sfy,"CAS4");
      text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc-0.08*var.sfy,"CAS3");
      text->DrawLatex(var.xxvc-0.222*var.sfx,var.yxvc+0.48*var.sfy,"CARD2");
      text->DrawLatex(var.xxvc+0.185*var.sfx,var.yxvc+0.48*var.sfy,"CARD3");
      text->DrawLatex(var.xyvc-0.190*var.sfx,var.yyvc+0.48*var.sfy,"CARD1");
      text->DrawLatex(var.xyvc+0.16*var.sfx,var.yyvc+0.48*var.sfy,"CARD4");
      text->DrawLatex(var.xxvc-0.192*var.sfx,var.yxvc+0.39*var.sfy,"CAT3");
      text->DrawLatex(var.xxvc+0.155*var.sfx,var.yxvc+0.39*var.sfy,"CAT4");
      text->DrawLatex(var.xyvc-0.170*var.sfx,var.yyvc+0.39*var.sfy,"CAT2");
      text->DrawLatex(var.xyvc+0.13*var.sfx,var.yyvc+0.39*var.sfy,"CAT1");
    };
    if  ( var.CALO ){
      text->SetTextSize(0.020);
      text->SetTextAngle(90);
      text->DrawLatex(var.xxvc-0.22*var.sfx,var.yxvc-0.290*var.sfy,"Calorimeter");		
      text->DrawLatex(var.xyvc+0.22*var.sfx,var.yyvc-0.290*var.sfy,"Calorimeter");		
      text->SetTextSize(0.01);
      text->SetTextAngle(0);
    };
    if  ( var.TRK ){
      text->SetTextSize(0.020);
      text->SetTextAngle(90);
      text->DrawLatex(var.xxvc-0.22*var.sfx,var.yxvc+0.080*var.sfy,"Tracker");		
      text->DrawLatex(var.xyvc+0.22*var.sfx,var.yyvc+0.080*var.sfy,"Tracker");		
      text->SetTextSize(0.01);
      text->SetTextAngle(0);
    };
    if  ( var.ND ){
      text->SetTextSize(0.020);
      //		    text->SetTextAngle(90);
      text->DrawLatex(var.xxvc-0.25*var.sfx,var.yxvc-0.530*var.sfy,"ND");		
      text->DrawLatex(var.xyvc+0.22*var.sfx,var.yyvc-0.530*var.sfy,"ND");		
      text->SetTextSize(0.01);
      text->SetTextAngle(0);
    };
    if  ( var.TOF ){
      text->SetTextSize(0.020);
      text->DrawLatex(var.xxvc-0.24*var.sfx,var.yxvc-0.130*var.sfy,"S3");		
      text->DrawLatex(var.xxvc-0.24*var.sfx,var.yxvc+0.350*var.sfy,"S2");		
      text->DrawLatex(var.xxvc-0.24*var.sfx,var.yxvc+0.653*var.sfy,"S1");		
      text->DrawLatex(var.xyvc+0.21*var.sfx,var.yyvc-0.130*var.sfy,"S3");		
      text->DrawLatex(var.xyvc+0.21*var.sfx,var.yyvc+0.350*var.sfy,"S2");		
      text->DrawLatex(var.xyvc+0.21*var.sfx,var.yyvc+0.653*var.sfy,"S1");		
      text->SetTextSize(0.01);
    };
    if  ( var.S4 ){
      text->SetTextSize(0.020);
      text->DrawLatex(var.xxvc-0.28*var.sfx,var.yxvc-0.350*var.sfy,"S4");		
      text->DrawLatex(var.xyvc+0.25*var.sfx,var.yyvc-0.350*var.sfy,"S4");		
      text->SetTextSize(0.01);
    };
    if ( !var.INFOS ){
      text->SetTextSize(0.01);
      text->DrawLatex(var.xxvc-0.040*var.sfx,var.yxvc-0.520*var.sfy,"SATELLITE (CPU) SIDE");
      text->SetTextAngle(90);
      text->DrawLatex(var.xyvc+0.17*var.sfx,var.yyvc+0.065*var.sfy,"SATELLITE (CPU) SIDE");
      text->DrawLatex(var.xyvc-0.17*var.sfx,var.yyvc+0.075*var.sfy,"VME SIDE");
      if ( var.AC ){
	text->SetTextAngle(90);
	text->DrawLatex(var.xcat-0.235*var.sfx,var.ycat-0.025*var.sfy,"VME SIDE");
	text->DrawLatex(var.xcat+0.235*var.sfx,var.ycat-0.025*var.sfy,"CPU SIDE");
	//
	text->SetTextAngle(0);
	text->SetTextSize(0.015);	    
	TEllipse *elli = new TEllipse(var.xcat+0.219*var.sfx,var.ycat-0.249*var.sfy,0.003,0.003);
	elli->Draw();
	text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.261*var.sfy,"z");
	TArrow *arr;
	arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.22*var.sfx,var.ycat-0.21*var.sfy);
	arr->SetArrowSize(0.005);
	arr->Draw();
	text->DrawLatex(var.xcat+0.229*var.sfx,var.ycat-0.21*var.sfy,"x");
	arr = new TArrow(var.xcat+0.22*var.sfx,var.ycat-0.25*var.sfy,var.xcat+0.18*var.sfx,var.ycat-0.25*var.sfy);
	arr->SetArrowSize(0.005);
	arr->Draw();
	text->DrawLatex(var.xcat+0.18*var.sfx,var.ycat-0.261*var.sfy,"y");
	text->SetTextSize(0.01);
      };
      //
      // coordinates systems and x/y view labels
      //
      thefigure->cd();
      text->SetTextAngle(0);
      text->SetTextFont(32);
      text->SetTextColor(1);	
      text->SetTextAlign(12);
      text->SetTextSize(0.01);
      text->DrawLatex(var.xxvc-0.025*var.sfx,var.yxvc+0.67*var.sfy,"X VIEW");
      text->DrawLatex(var.xyvc-0.025*var.sfx,var.yyvc+0.67*var.sfy,"Y VIEW");
      //
      text->SetTextSize(0.015);	    
      text->SetTextFont(2);
      DrawX(var.xxvc-0.25*var.sfx,var.yxvc-0.328*var.sfy,0.005,var); //508
      text->SetTextFont(32);
      text->DrawLatex(var.xxvc-0.266*var.sfx,var.yxvc-0.328*var.sfy,"y");
      TArrow *arr;
      arr = new TArrow(var.xxvc-0.25*var.sfx,var.yxvc-0.328*var.sfy,var.xxvc-0.21*var.sfx,var.yxvc-0.328*var.sfy);
      arr->SetArrowSize(0.005);
      arr->Draw();
      text->DrawLatex(var.xxvc-0.21*var.sfx,var.yxvc-0.335*var.sfy,"x");
      arr = new TArrow(var.xxvc-0.25*var.sfx,var.yxvc-0.328*var.sfy,var.xxvc-0.25*var.sfx,var.yxvc-0.288*var.sfy);
      arr->SetArrowSize(0.005);
      arr->Draw();
      text->DrawLatex(var.xxvc-0.266*var.sfx,var.yxvc-0.288*var.sfy,"z");
      //
      text->SetTextSize(0.015);	    
      text->SetTextFont(2);
      DrawX(var.xyvc+0.24*var.sfx,var.yyvc-0.328*var.sfy,0.005,var);
      text->SetTextFont(32);
      text->DrawLatex(var.xyvc+0.25*var.sfx,var.yyvc-0.328*var.sfy,"x");
      arr = new TArrow(var.xyvc+0.24*var.sfx,var.yyvc-0.328*var.sfy,var.xyvc+0.2*var.sfx,var.yyvc-0.328*var.sfy);
      arr->SetArrowSize(0.005);
      arr->Draw();
      text->DrawLatex(var.xyvc+0.19*var.sfx,var.yyvc-0.335*var.sfy,"y");
      arr = new TArrow(var.xyvc+0.24*var.sfx,var.yyvc-0.328*var.sfy,var.xyvc+0.24*var.sfx,var.yyvc-0.288*var.sfy);
      arr->SetArrowSize(0.005);
      arr->Draw();
      text->DrawLatex(var.xyvc+0.25*var.sfx,var.yyvc-0.288*var.sfy,"z");	    
      text->SetTextSize(0.01);
    };
  };
  //
  //
  // update figure
  //
  thefigure->cd();
  thefigure->Modified();
  thefigure->Update();
  thefigure->cd();
  thefigure->SetEditable(kFALSE);
  //
  // print infos on terminal
  //
  //  if ( !var.selex ){
  printf(" File: %s \n",var.thefilename.Data());	
  if ( !s4pulser && !calotrig ){
    printf(" Pkt_num: %i  - Progressive number: %i \n",(int)headc,thisentry+1);
  };
  if ( s4pulser ){
    printf(" Pkt_num: %i  - Progressive number: %i   - S4 trigger -\n",(int)headc,thisentry+1);
  };
  if ( calotrig ){
    printf(" Pkt_num: %i  - Progressive number: %i   - CALO trigger -\n",(int)headc,thisentry+1);
  };
  printf(" On Board Time: %u (delta %i) [ms]\n",OBT,DOBT);
  const char *trc2 = trcs;
  printf(" TRIGGER: %s \n",trc2);	
  printf(" AC: CARD hit = %i  CAT hit = %i  CAS hit = %i \n",var.hcard,var.hcat,var.hcas);	
  if ( level.file == 2 ){
    printf(" TRK:  NCLX = %i  NCLY = %i RIG = %f [GV] CHI2 = %f \n",var.nclx,var.ncly,var.rig,var.chi2);	
  } else {
    printf(" TRK:  NCLX = %i  NCLY = %i \n ",var.nclx,var.ncly);	
  };
  printf(" CALO: NSTRIP = %i  QTOT = %i [MIP]\n",var.nstrip,var.qtot);	
  printf(" S4: %.2f [MIP]   TOF: beta = %.2f \n",var.s4sig,var.beta[4]);	
  printf(" ND: Trigger: neutrons = %i - Background: upper = %i lower = %i \n",var.trup,var.bkup,var.bkbo);	
  //  };
  //
}

//
// THE PALETTE
//
void FEVdetector::ShowPalette(){
  Float_t xp = 0.40;
  Float_t yp = 0.02;
  Float_t xw = 0.2325;
  Float_t yh = 0.19;
  Double_t xx[5] = {xp, xp+xw, xp+xw, xp, xp};
  Double_t yy[5] = {yp, yp, yp+yh, yp+yh, yp};
  TPolyLine *fpale = new TPolyLine(5,xx,yy);
  fpale->SetLineColor(1);
  fpale->SetLineWidth(1);
  fpale->Draw();   
  TLatex *txt=new TLatex();
  txt->SetTextSize(0.01);
  txt->DrawLatex(xp+0.005,yp+yh-0.015,"PALETTE");
  if ( level.file == -1 ) txt->DrawLatex(xp+0.005,yp+yh-0.04,"TOF, CALO, S4 [MIP]:");
  if ( level.file == 2 ) txt->DrawLatex(xp+0.005,yp+yh-0.04,"TOF, TRK, CALO, S4 [MIP]:");
  Float_t xwc = (xw-0.01)/6.;
  Float_t axwc = xwc+0.02;
  Float_t yhc = 0.03;    
  Int_t colo = 0;
  Float_t yc = 0.135;
  TPolyLine *fc1[6];
  if ( var.bw ){
    if ( level.file != 0 ){
      for ( Int_t j=0; j<6; j++){
	Float_t xc = 0.005+xp+(j*xwc);
	Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	fc1[j] = new TPolyLine(5,xx,yy);
	fc1[j]->SetLineColor(1);
	if ( j == 0 ) {
	  colo = 10;
	};
	if ( j == 1 ) {
	  colo = 17;
	};
	if ( j == 2 ) {
	  colo = 15;
	};
	if ( j == 3 ) {
	  colo = 14;
	};
	if ( j == 4 ) {
	  colo = 13;
	};
	if ( j == 5 ) {
	  colo = 12;
	};
	fc1[j]->SetFillColor(colo);
	fc1[j]->SetLineWidth(1);
	fc1[j]->Draw("f");
	fc1[j]->Draw();
	if ( j == 0 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"0");
	};
	if ( j == 1 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"0 - 2");
	};
	if ( j == 2 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"2 - 10");
	};
	if ( j == 3 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"10 - 100");
	};
	if ( j == 4 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"100 - 500");
	};
	if ( j == 5 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"> 500");
	};
      };
    };
    txt->DrawLatex(xp+0.005,yp+yh-0.095,"ND [neutrons]:");
    Float_t yc = 0.08;
    TPolyLine *fc2[6];
    for ( Int_t j=0; j<6; j++){
      Float_t xc = 0.005+xp+(j*xwc);
      Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
      Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
      fc2[j] = new TPolyLine(5,xx,yy);
      fc2[j]->SetLineColor(1);
      if ( j == 0 ) {
	colo = 10;
      };
      if ( j == 1 ) {
	colo = 17;
      };
      if ( j == 2 ) {
	colo = 15;
      };
      if ( j == 3 ) {
	colo = 14;
      };
      if ( j == 4 ) {
	colo = 13;
      };
      if ( j == 5 ) {
	colo = 12;
      };
      fc2[j]->SetFillColor(colo);
      fc2[j]->SetLineWidth(1);
      fc2[j]->Draw("f");
      fc2[j]->Draw();
      if ( j == 0 ) {
	txt->DrawLatex(xc+0.005,yc+0.01,"0");
      };
      if ( j == 1 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 1 ");
      };
      if ( j == 2 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 2 ");
      };
      if ( j == 3 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 3 - 6 ");
      };
      if ( j == 4 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 7 - 14 ");
      };
      if ( j == 5 ) {
	txt->DrawLatex(xc+0.005,yc+0.01,"> 14");
      };
    };
    //	
    txt->DrawLatex(xp+0.005,yp+yh-0.15,"AC:");
    yc = 0.025;
    TPolyLine *fc3[3];
    for ( Int_t j=0; j<3; j++){
      Float_t xc = 0.005+xp+(j*axwc);
      Double_t xx[5] = {xc, xc+axwc, xc+axwc, xc, xc};
      Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
      fc3[j] = new TPolyLine(5,xx,yy);
      fc3[j]->SetLineColor(1);
      if ( j == 0 ) {
	colo = 10;
      };
      if ( j == 1 ) {
	colo = 13;
      };
      if ( j == 2 ) {
	colo = 12;
      };
      fc3[j]->SetFillColor(colo);
      fc3[j]->SetLineWidth(1);
      fc3[j]->Draw("f");
      fc3[j]->Draw();
      if ( j == 0 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," NOT HIT ");
      };
      if ( j == 1 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," HIT trigger");
      };
      if ( j == 2 ) {
	txt->SetTextSize(0.0095);
	txt->DrawLatex(xc+0.001,yc+0.011," HIT background");
	txt->SetTextSize(0.01);
      };
    };
  } else {
    if ( level.file != 0 ){
      for ( Int_t j=0; j<6; j++){
	Float_t xc = 0.005+xp+(j*xwc);
	Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
	Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
	fc1[j] = new TPolyLine(5,xx,yy);
	fc1[j]->SetLineColor(1);
	if ( j == 0 ) {
	  colo = 10;
	};
	if ( j == 1 ) {
	  colo = 38;
	};
	if ( j == 2 ) {
	  colo = 4;
	};
	if ( j == 3 ) {
	  colo = 3;
	};
	if ( j == 4 ) {
	  colo = 2;
	};
	if ( j == 5 ) {
	  colo = 6;
	};
	fc1[j]->SetFillColor(colo);
	fc1[j]->SetLineWidth(1);
	fc1[j]->Draw("f");
	fc1[j]->Draw();
	if ( j == 0 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"0");
	};
	if ( j == 1 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"0 - 2");
	};
	if ( j == 2 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"2 - 10");
	};
	if ( j == 3 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"10 - 100");
	};
	if ( j == 4 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"100 - 500");
	};
	if ( j == 5 ) {
	  txt->DrawLatex(xc+0.005,yc+0.01,"> 500");
	};
      };
    };
    txt->DrawLatex(xp+0.005,yp+yh-0.095,"ND [neutrons]:");
    Float_t yc = 0.08;
    TPolyLine *fc2[6];
    for ( Int_t j=0; j<6; j++){
      Float_t xc = 0.005+xp+(j*xwc);
      Double_t xx[5] = {xc, xc+xwc, xc+xwc, xc, xc};
      Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
      fc2[j] = new TPolyLine(5,xx,yy);
      fc2[j]->SetLineColor(1);
      if ( j == 0 ) {
	colo = 10;
      };
      if ( j == 1 ) {
	colo = 38;
      };
      if ( j == 2 ) {
	colo = 4;
      };
      if ( j == 3 ) {
	colo = 3;
      };
      if ( j == 4 ) {
	colo = 2;
      };
      if ( j == 5 ) {
	colo = 6;
      };
      fc2[j]->SetFillColor(colo);
      fc2[j]->SetLineWidth(1);
      fc2[j]->Draw("f");
      fc2[j]->Draw();
      if ( j == 0 ) {
	txt->DrawLatex(xc+0.005,yc+0.01,"0");
      };
      if ( j == 1 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 1 ");
      };
      if ( j == 2 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 2 ");
      };
      if ( j == 3 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 3 - 6 ");
      };
      if ( j == 4 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," 7 - 14 ");
      };
      if ( j == 5 ) {
	txt->DrawLatex(xc+0.005,yc+0.01,"> 14");
      };
    };
    //
    txt->DrawLatex(xp+0.005,yp+yh-0.15,"AC:");
    yc = 0.025;
    TPolyLine *fc3[3];
    for ( Int_t j=0; j<3; j++){
      Float_t xc = 0.005+xp+(j*axwc);
      Double_t xx[5] = {xc, xc+axwc, xc+axwc, xc, xc};
      Double_t yy[5] = {yc, yc, yc+yhc, yc+yhc, yc};
      fc3[j] = new TPolyLine(5,xx,yy);
      fc3[j]->SetLineColor(1);
      if ( j == 0 ) {
	colo = 10;
      };
      if ( j == 1 ) {
	colo = 2;
      };
      if ( j == 2 ) {
	colo = 42;
      };
      fc3[j]->SetFillColor(colo);
      fc3[j]->SetLineWidth(1);
      fc3[j]->Draw("f");
      fc3[j]->Draw();
      if ( j == 0 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," NOT HIT ");
      };
      if ( j == 1 ) {
	txt->DrawLatex(xc+0.005,yc+0.01," HIT trigger");
      };
      if ( j == 2 ) {
	txt->SetTextSize(0.0095);
	txt->DrawLatex(xc+0.001,yc+0.011," HIT background");
	txt->SetTextSize(0.01);
      };
    };
  };
}

//
// THE TOF
//
void FEVdetector::ShowTOF(){
  //
  //
  if ( !var.TOF ) return;
  //
  Int_t tt = 0;
  Int_t rj = 0;
  //
  // force level0, i.e. show patterntrig variable!
  //
  if ( level.file == 0 ){
    //
    // on day these variables will contain the MIP value for each paddle
    //
    Float_t ms11a[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12a[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21a[2] = {0.,0.};
    Float_t ms22a[2] = {0.,0.};
    Float_t ms31a[3] = {0.,0.,0.};
    Float_t ms32a[3] = {0.,0.,0.};
    Float_t ms11b[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
    Float_t ms12b[6] = {0.,0.,0.,0.,0.,0.};
    Float_t ms21b[2] = {0.,0.};
    Float_t ms22b[2] = {0.,0.};
    Float_t ms31b[3] = {0.,0.,0.};
    Float_t ms32b[3] = {0.,0.,0.};
    //
    // TDC info for each PMT
    //
    Float_t mt11[2][8];
    Float_t mt12[2][6];
    Float_t mt21[2][2];
    Float_t mt22[2][2];
    Float_t mt31[2][3];
    Float_t mt32[2][3];
    //
    memset(mt11,0,2*8*sizeof(Float_t));
    memset(mt12,0,2*6*sizeof(Float_t));
    memset(mt21,0,2*2*sizeof(Float_t));
    memset(mt22,0,2*2*sizeof(Float_t));
    memset(mt31,0,2*3*sizeof(Float_t));
    memset(mt32,0,2*3*sizeof(Float_t));
    //
    Int_t S3 = 0;
    Int_t S2 = 0;
    Int_t S12 = 0;
    Int_t S11 = 0;
    S3 = trigger->patterntrig[2];
    S2 = trigger->patterntrig[3];
    S12 = trigger->patterntrig[4];
    S11 = trigger->patterntrig[5];
    //
    for ( Int_t i = 0; i<8; i++ ) {
      if ( S11 & (1<<i) ){ 
	ms11a[i] = 1.;
      }
      if ( S11 & (1<<(i+8) ) ){ 
	ms11b[i] = 1.;
      }
    };
    for ( Int_t i = 0; i<6; i++ ) {
      if ( S12 & (1<<i) ) {
	ms12a[i] = 1.;
      }
      if ( S12 & (1<<(i+6)) ) {
	ms12b[i] = 1.;
      }
    };
    Int_t ii = 2;
    for ( Int_t i = 0; i<2; i++ ) {
      ii--;
      if ( S2 & (1<<i) ) {
	ms21a[ii] = 1.;
      }
      if ( S2 & (1<<(i+2)) ) {
	ms21b[ii] = 1.;
      }
    };
    for ( Int_t i = 4; i<6; i++ ) {
      if ( S2 & (1<<i) ) {
	ms22a[i-4] = 1.;
      }
      if ( S2 & (1<<(i+2)) ) {
	ms22b[i-4] = 1.;
      }
    };
    for ( Int_t i = 0; i<3; i++ ) {
      if ( S3 & (1<<i) ) {
	ms31a[i] = 1.;
      }
      if ( S3 & (1<<(i+3)) ) {
	ms31b[i] = 1.;
      }
    };
    for ( Int_t i = 6; i<9; i++ ) {
      if ( S3 & (1<<i) ) {
	ms32a[i-6] = 1.;
      }
      if ( S3 & (1<<(i+3)) ) {
	ms32b[i-6] = 1.;
      }
    };
    //
    Int_t colo;
    Int_t ocolo;
    Float_t xs2x = var.xxvc;
    Float_t ys2x = var.yxvc + 0.36*var.sfy;
    Float_t xs2y = var.xyvc;
    Float_t ys2y = var.yyvc + 0.36*var.sfy;
    Float_t ws2 = 0.005;
    Float_t ws13 = 0.007;
    Int_t noadc = 12;
    if ( var.bw ){
      noadc=12;
    } else {
      noadc=41;
    };
    //
    // S11  X-view
    //
    // A     
    Float_t s11p = 0.051;
    ocolo = 10;
    TPolyLine *ftof11xa[8];
    for ( Int_t j=0; j<8; j++){
      Float_t xc1[4]={ (s11p*j),       (s11p*j),               s11p*(j+1),     (s11p*j)};
      Float_t yc1[4]={ 0.,                       ws13,     ws13,    0.};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2x + (-0.204+xc1[i])*var.sfx;
	yc[i] = ys2x + (0.295+yc1[i])*var.sfy;
      };
      ftof11xa[j] = new TPolyLine(4,xc,yc);
      ftof11xa[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms11a[j],colo);	
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt11[0][j] == 4095. ) colo = noadc;
      //
      ftof11xa[j]->SetFillColor(colo);
      ftof11xa[j]->SetLineWidth(1);
      ftof11xa[j]->Draw("f");
      ftof11xa[j]->Draw();
    };
    // B
    s11p = 0.051;
    TPolyLine *ftof11xb[8];
    for ( Int_t j=0; j<8; j++){
      Float_t xc1[4]={ (s11p*j),       s11p*(j+1),               s11p*(j+1),     (s11p*j)};
      Float_t yc1[4]={ 0.,         0.,                ws13,      0.};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2x + (-0.204+xc1[i])*var.sfx;
	yc[i] = ys2x + (0.295+yc1[i])*var.sfy;
      };
      ftof11xb[j] = new TPolyLine(4,xc,yc);
      ftof11xb[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms11b[j],colo);	
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt11[1][j] == 4095. ) colo = noadc;
      //
      ftof11xb[j]->SetFillColor(colo);
      ftof11xb[j]->SetLineWidth(1);
      ftof11xb[j]->Draw("f");
      ftof11xb[j]->Draw();
    };

    //
    // S11  Y-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.165,       0.165,               0.165,     -0.165,    -0.165};
      Float_t nyc1[5]={ 0.,         0.,                ws13,    ws13,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + nxc1[i]*var.sfx;
	nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
      };
      TPolyLine *ftof11y = new TPolyLine(5,nxc,nyc);
      ftof11y->SetLineColor(1);
      ftof11y->SetFillColor(ocolo);
      ftof11y->SetLineWidth(1);
      ftof11y->Draw("f");
      ftof11y->Draw();
    };
    
    //
    // S12  Y-view
    //
    // A
    Float_t s12p = 0.055;
    ocolo = 10;
    TPolyLine *ftof12ya[6];
    rj=6;
    for ( Int_t j=0; j<6; j++){
      rj--;
      Float_t xc1[4]={ (s12p*j),       s12p*(j),               s12p*(j+1),     (s12p*j)};
      Float_t yc1[4]={      -ws13,     0.,  0., -ws13};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2y + (-0.165+xc1[i])*var.sfx;
	yc[i] = ys2y + (0.295+yc1[i])*var.sfy;
      };
      ftof12ya[j] = new TPolyLine(4,xc,yc);
      ftof12ya[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms12a[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt12[0][rj] == 4095. ) colo = noadc;
      //
      ftof12ya[j]->SetFillColor(colo);
      ftof12ya[j]->SetLineWidth(1);
      ftof12ya[j]->Draw("f");
      ftof12ya[j]->Draw();
    };
    // B
    s12p = 0.055;
    TPolyLine *ftof12yb[6];
    rj=6;
    for ( Int_t j=0; j<6; j++){
      rj--;
      Float_t xc1[4]={ (s12p*j),       s12p*(j+1),               s12p*(j+1),     (s12p*j)};
      Float_t yc1[4]={ -ws13,     -ws13,    0., -ws13};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2y + (-0.165+xc1[i])*var.sfx;
	yc[i] = ys2y + (0.295+yc1[i])*var.sfy;
      };
      ftof12yb[j] = new TPolyLine(4,xc,yc);
      ftof12yb[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms12b[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt12[1][rj] == 4095. ) colo = noadc;
      //
      ftof12yb[j]->SetFillColor(colo);
      ftof12yb[j]->SetLineWidth(1);
      ftof12yb[j]->Draw("f");
      ftof12yb[j]->Draw();
    };
    //
    // S12  X-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.204,       0.204,               0.204,     -0.204,    -0.204};
      Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + nxc1[i]*var.sfx;
	nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
      };
      TPolyLine *ftof12x = new TPolyLine(5,nxc,nyc);
      ftof12x->SetLineColor(1);
      ftof12x->SetFillColor(ocolo);
      ftof12x->SetLineWidth(1);
      ftof12x->Draw("f");
      ftof12x->Draw();
    };

    //
    // S21  Y-view
    //
    // A 
    Float_t s21p = 0.075;
    ocolo = 10;
    TPolyLine *ftof21ya[2];
    rj=2;
    for ( Int_t j=0; j<2; j++){
      rj--;
      Float_t xc1[4]={ s21p*(j-1),       s21p*(j-1),               s21p*j,     s21p*(j-1)};
      Float_t yc1[4]={ 0.,                ws2,     ws2,    0.};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2y + xc1[i]*var.sfx;
	yc[i] = ys2y + yc1[i]*var.sfy;
      };
      ftof21ya[j] = new TPolyLine(4,xc,yc);
      ftof21ya[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms21a[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt21[0][rj] == 4095. ) colo = noadc;
      //
      ftof21ya[j]->SetFillColor(colo);
      ftof21ya[j]->SetLineWidth(1);
      ftof21ya[j]->Draw("f");
      ftof21ya[j]->Draw();
    };
    // B
    s21p = 0.075;
    TPolyLine *ftof21yb[2];
    rj=2;
    for ( Int_t j=0; j<2; j++){
      rj--;
      Float_t xc1[4]={ s21p*(j-1),       s21p*j,               s21p*j,     s21p*(j-1)};
      Float_t yc1[4]={ 0.,         0.,                ws2,         0.};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2y + xc1[i]*var.sfx;
	yc[i] = ys2y + yc1[i]*var.sfy;
      };
      ftof21yb[j] = new TPolyLine(4,xc,yc);
      ftof21yb[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms21b[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt21[1][rj] == 4095. ) colo = noadc;
      //
      ftof21yb[j]->SetFillColor(colo);
      ftof21yb[j]->SetLineWidth(1);
      ftof21yb[j]->Draw("f");
      ftof21yb[j]->Draw();
    };
    //
    // S21  X-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
      Float_t nyc1[5]={ 0.,         0.,                ws2,    ws2,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + nxc1[i]*var.sfx;
	nyc[i] = ys2x + nyc1[i]*var.sfy;
      };
      TPolyLine *ftof21x = new TPolyLine(5,nxc,nyc);
      ftof21x->SetLineColor(1);
      ftof21x->SetFillColor(ocolo);
      ftof21x->SetLineWidth(1);
      ftof21x->Draw("f");
      ftof21x->Draw();
    };
    //
    // S22  X-view
    //
    // A 
    Float_t s22p = 0.090;
    ocolo = 10;
    TPolyLine *ftof22xa[2];
    for ( Int_t j=0; j<2; j++){
      Float_t xc1[4]={ s22p*(j-1),       s22p*(j-1),               s22p*j,     s22p*(j-1)};
      Float_t yc1[4]={                -ws2,   0., 0.,  -ws2};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2x + xc1[i]*var.sfx;
	yc[i] = ys2x + yc1[i]*var.sfy;
      };
      ftof22xa[j] = new TPolyLine(4,xc,yc);
      ftof22xa[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms22a[j],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt22[0][j] == 4095. ) colo = noadc;
      //
      ftof22xa[j]->SetFillColor(colo);
      ftof22xa[j]->SetLineWidth(1);
      ftof22xa[j]->Draw("f");
      ftof22xa[j]->Draw();
    };
    // B 
    s22p = 0.090;
    TPolyLine *ftof22xb[2];
    for ( Int_t j=0; j<2; j++){
      Float_t xc1[4]={ s22p*(j-1),       s22p*j,               s22p*j,     s22p*(j-1)};
      Float_t yc1[4]={ -ws2,     -ws2,    0., -ws2};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2x + xc1[i]*var.sfx;
	yc[i] = ys2x + yc1[i]*var.sfy;
      };
      ftof22xb[j] = new TPolyLine(4,xc,yc);
      ftof22xb[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms22b[j],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt22[1][j] == 4095. ) colo = noadc;
      //
      ftof22xb[j]->SetFillColor(colo);
      ftof22xb[j]->SetLineWidth(1);
      ftof22xb[j]->Draw("f");
      ftof22xb[j]->Draw();
    };
    //
    // S22  Y-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
      Float_t nyc1[5]={ 0.,         0.,                -ws2,    -ws2,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + nxc1[i]*var.sfx;
	nyc[i] = ys2y + nyc1[i]*var.sfy;
      };
      TPolyLine *ftof22y = new TPolyLine(5,nxc,nyc);
      ftof22y->SetLineColor(1);
      ftof22y->SetFillColor(ocolo);
      ftof22y->SetLineWidth(1);
      ftof22y->Draw("f");
      ftof22y->Draw();
    };

    //
    // S31  X-view
    //
    // A 
    Float_t s31p = 0.060;
    ocolo = 10;
    TPolyLine *ftof31xa[3];
    rj=3;
    for ( Int_t j=0; j<3; j++){
      rj--;
      Float_t xc1[4]={ (s31p*j),       (s31p*j),               s31p*(j+1),       (s31p*j)};
      Float_t yc1[4]={ 0.,                       ws13,     ws13,    0.};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2x + (-0.090+xc1[i])*var.sfx;
	yc[i] = ys2x + (-0.488+yc1[i])*var.sfy;
      };
      ftof31xa[j] = new TPolyLine(4,xc,yc);
      ftof31xa[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms31a[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt31[0][rj] == 4095. ) colo = noadc;
      //
      ftof31xa[j]->SetFillColor(colo);
      ftof31xa[j]->SetLineWidth(1);
      ftof31xa[j]->Draw("f");
      ftof31xa[j]->Draw();
    };
    // B 
    s31p = 0.060;
    TPolyLine *ftof31xb[3];
    rj=3;
    for ( Int_t j=0; j<3; j++){
      rj--;
      Float_t xc1[4]={ (s31p*j),       s31p*(j+1),               s31p*(j+1),     (s31p*j)};
      Float_t yc1[4]={ 0.,                        0.,     ws13,    0.};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2x + (-0.090+xc1[i])*var.sfx;
	yc[i] = ys2x + (-0.488+yc1[i])*var.sfy;
      };
      ftof31xb[j] = new TPolyLine(4,xc,yc);
      ftof31xb[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms31b[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt31[1][rj] == 4095. ) colo = noadc;
      //
      ftof31xb[j]->SetFillColor(colo);
      ftof31xb[j]->SetLineWidth(1);
      ftof31xb[j]->Draw("f");
      ftof31xb[j]->Draw();
    };
    //
    // S31  Y-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
      Float_t nyc1[5]={ 0.,         0.,                 ws13,    ws13,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + nxc1[i]*var.sfx;
	nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
      };
      TPolyLine *ftof31y = new TPolyLine(5,nxc,nyc);
      ftof31y->SetLineColor(1);
      ftof31y->SetFillColor(ocolo);
      ftof31y->SetLineWidth(1);
      ftof31y->Draw("f");
      ftof31y->Draw();
    };
    //
    // S32  Y-view
    //
    Float_t s32p = 0.050;
    ocolo = 10;
    TPolyLine *ftof32ya[3];
    rj=3;
    for ( Int_t j=0; j<3; j++){
      rj--;
      Float_t xc1[4]={ (s32p*j),       (s32p*j),               s32p*(j+1),     (s32p*j)};
      Float_t yc1[4]={     -ws13,     0.,    0., -ws13};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2y + (-0.075+xc1[i])*var.sfx;
	yc[i] = ys2y + (-0.488+yc1[i])*var.sfy;
      };
      ftof32ya[j] = new TPolyLine(4,xc,yc);
      ftof32ya[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms32a[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt32[0][rj] == 4095. ) colo = noadc;
      //
      ftof32ya[j]->SetFillColor(colo);
      ftof32ya[j]->SetLineWidth(1);
      ftof32ya[j]->Draw("f");
      ftof32ya[j]->Draw();
    };
    s32p = 0.050;
    TPolyLine *ftof32yb[3];
    rj=3;
    for ( Int_t j=0; j<3; j++){
      rj--;
      Float_t xc1[4]={ (s32p*j),       s32p*(j+1),               s32p*(j+1),     (s32p*j)};
      Float_t yc1[4]={ -ws13,   -ws13,    0., -ws13};
      Float_t xc[4];     
      Float_t yc[4];
      for (Int_t i = 0; i<4 ; i++) {
	xc[i]= xs2y + (-0.075+xc1[i])*var.sfx;
	yc[i] = ys2y + (-0.488+yc1[i])*var.sfy;
      };
      ftof32yb[j] = new TPolyLine(4,xc,yc);
      ftof32yb[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      ColorMIP(ms32b[rj],colo);
      //
      if ( colo != 10 ) ocolo = colo;
      if ( mt32[1][rj] == 4095. ) colo = noadc;
      //
      ftof32yb[j]->SetFillColor(colo);
      ftof32yb[j]->SetLineWidth(1);
      ftof32yb[j]->Draw("f");
      ftof32yb[j]->Draw();
    };
    //
    // S32  X-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
      Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + nxc1[i]*var.sfx;
	nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
      };
      TPolyLine *ftof32x = new TPolyLine(5,nxc,nyc);
      ftof32x->SetLineColor(1);
      ftof32x->SetFillColor(ocolo);
      ftof32x->SetLineWidth(1);
      ftof32x->Draw("f");
      ftof32x->Draw();
    };
    return;
  };
  //
  // CALIBRATED DATA (LEVEL -1 and 2)
  //
  // the channels MAP:
  //
  Int_t ch11a[8] = { 3, 3, 3, 3, 0, 0, 1, 1};
  Int_t hb11a[8] = { 0, 2, 4, 6, 9, 11, 1, 3};
  Int_t ch11b[8] = { 1, 1, 1, 1, 0, 0, 0, 0};
  Int_t hb11b[8] = { 5, 7, 11, 9, 7, 5, 3, 1};
  
  Int_t ch12a[6] = { 2, 2, 2, 2, 2, 2};
  Int_t hb12a[6] = { 1, 3, 5, 7, 9, 11};
  Int_t ch12b[6] = { 3, 3, 3, 3, 3, 3};
  Int_t hb12b[6] = { 11, 9, 7, 5, 3, 1};
  
  Int_t ch21a[2] = { 0, 0};
  Int_t hb21a[2] = { 0, 4};
  Int_t ch21b[2] = { 1, 0};
  Int_t hb21b[2] = { 8, 6};
  
  Int_t ch22a[2] = { 0, 0};
  Int_t hb22a[2] = { 2, 8};
  Int_t ch22b[2] = { 1, 0};
  Int_t hb22b[2] = { 10, 10};
  
  Int_t ch31a[3] = { 1, 2, 2};
  Int_t hb31a[3] = { 6, 8, 10};
  Int_t ch31b[3] = { 1, 1, 1};
  Int_t hb31b[3] = { 4, 2, 0};
  
  Int_t ch32a[3] = { 2, 2, 3};
  Int_t hb32a[3] = { 0, 4, 8};
  Int_t ch32b[3] = { 2, 2, 3};
  Int_t hb32b[3] = { 2, 6, 10};  
  //
  // ADC values
  //
  Float_t ms11a[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
  Float_t ms12a[6] = {0.,0.,0.,0.,0.,0.};
  Float_t ms21a[2] = {0.,0.};
  Float_t ms22a[2] = {0.,0.};
  Float_t ms31a[3] = {0.,0.,0.};
  Float_t ms32a[3] = {0.,0.,0.};
  Float_t ms11b[8] = {0.,0.,0.,0.,0.,0.,0.,0.};
  Float_t ms12b[6] = {0.,0.,0.,0.,0.,0.};
  Float_t ms21b[2] = {0.,0.};
  Float_t ms22b[2] = {0.,0.};
  Float_t ms31b[3] = {0.,0.,0.};
  Float_t ms32b[3] = {0.,0.,0.};
  //
  // default calibrations
  //
  Float_t xp11[8];
  Float_t A11[8] = {-19.,-9.6,-25.7,-13.1,-30.9,-21.1,-11.7,-15.9};
  Float_t B11[8] = {-2.6,-2.6,-2.3,-2.4,-2.4,-2.8,-2.75,-2.5};
  Float_t E11[8] = {2.6,2.6,2.6,2.6,2.6,2.6,2.6,2.6};
  Float_t xp12[6];
  Float_t A12[6] = {11.6,16.6,5.9,-22.2,-18.0,-14.2};
  Float_t B12[6] = {-2.309,-2.424,-1.958,-2.092,-2.241,-2.144};
  Float_t E12[6] = {2.6,2.6,2.6,2.6,2.6,2.6};
  Float_t xp21[2];
  Float_t A21[2] = {12.5, 21.7};
  Float_t B21[2] = {-1.492,-1.519};
  Float_t E21[2] = {2.2,2.2};
  Float_t xp22[2];
  Float_t A22[2] = {-27.0, -45.8};
  Float_t B22[2] = {-1.897,-1.477};
  Float_t E22[2] = {2.9,2.9};
  Float_t xp31[3];
  Float_t A31[3] = {-25.1, -41.4, -33.9};
  Float_t B31[3] = {-3.374,-3.793,-3.495};
  Float_t E31[3] = {1.2,1.2,1.2};
  Float_t xp32[3];
  Float_t A32[3] = {1.3, 3.9, -22.0};
  Float_t B32[3] = {-3.134,-3.526,-3.417};
  Float_t E32[3] = {2.3,2.3,2.3};
  //
  // TDC info for each PMT
  //
  Float_t mt11[2][8];
  Float_t mt12[2][6];
  Float_t mt21[2][2];
  Float_t mt22[2][2];
  Float_t mt31[2][3];
  Float_t mt32[2][3];
  Int_t noadc = 12;
  if ( var.bw ){
    noadc = 12;
  } else {
    noadc = 41;
  };
  //
  Int_t ii = 0;
  if ( level.file == -1 ){
    for ( Int_t i = 0; i<8; i++ ) {
      mt11[0][i] = tof->tdc[ch11a[i]][hb11a[i]];
      mt11[1][i] = tof->tdc[ch11b[i]][hb11b[i]];
      ms11a[i] = tof->adc[ch11a[i]][hb11a[i]];
      ms11b[i] = tof->adc[ch11b[i]][hb11b[i]];
      xp11[i] = ( -A11[i] + (mt11[0][i]-mt11[1][i]) / 2. ) / B11[i] ;
      if ( ms11a[i] == 4095. ) {
	ms11a[i] = 0.;
      } else {
	ms11a[i] = 1.;
      };
      if ( ms11b[i] == 4095. ) {
	ms11b[i] = 0.;
      } else {
	ms11b[i] = 1.;
      };
    };
    for ( Int_t i = 0; i<6; i++ ) {
      mt12[0][i] = tof->tdc[ch12a[i]][hb12a[i]];
      mt12[1][i] = tof->tdc[ch12b[i]][hb12b[i]];
      ms12a[i] = tof->adc[ch12a[i]][hb12a[i]];
      ms12b[i] = tof->adc[ch12b[i]][hb12b[i]];
      xp12[i] = ( -A12[i] + (mt12[0][i]-mt12[1][i]) / 2. ) / B12[i] ;
      if ( ms12a[i] == 4095. ){
	ms12a[i] = 0.;
      } else {
	ms12a[i] = 1.;
      };
      if ( ms12b[i] == 4095. ){
	ms12b[i] = 0.;
      } else {
	ms12b[i] = 1.;
      };
    };    
    ii = 2;
    for ( Int_t i = 0; i<2; i++ ) {
      ii--;
      mt21[0][ii] = tof->tdc[ch21a[i]][hb21a[i]];
      mt21[1][ii] = tof->tdc[ch21b[i]][hb21b[i]];
      ms21a[ii] = tof->adc[ch21a[i]][hb21a[i]];
      ms21b[ii] = tof->adc[ch21b[i]][hb21b[i]];
      xp21[ii] = ( -A21[ii] + (mt21[0][ii]-mt21[1][ii]) / 2. ) / B21[ii] ;
      if ( ms21a[ii] == 4095. ){
	ms21a[ii] = 0.;
      } else {
	ms21a[ii] = 1.;
      };
      if ( ms21b[ii] == 4095. ){
	ms21b[ii] = 0.;
      } else {
	ms21b[ii] = 1.;
      };
    };
    for ( Int_t i = 0; i<2; i++ ) {
      mt22[0][i] = tof->tdc[ch22a[i]][hb22a[i]];
      mt22[1][i] = tof->tdc[ch22b[i]][hb22b[i]];
      ms22a[i] = tof->adc[ch22a[i]][hb22a[i]];
      ms22b[i] = tof->adc[ch22b[i]][hb22b[i]];
      xp22[i] = ( -A22[i] + (mt22[0][i]-mt22[1][i]) / 2. ) / B22[i] ;
      if ( ms22a[i] == 4095. ){
	ms22a[i] = 0.;
      } else {
	ms22a[i] = 1.;
      };
      if ( ms22b[i] == 4095. ){
	ms22b[i] = 0.;
      } else {
	ms22b[i] = 1.;
      };
    };
    for ( Int_t i = 0; i<3; i++ ) {
      mt31[0][i] = tof->tdc[ch31a[i]][hb31a[i]];
      mt31[1][i] = tof->tdc[ch31b[i]][hb31b[i]];
      ms31a[i] = tof->adc[ch31a[i]][hb31a[i]];
      ms31b[i] = tof->adc[ch31b[i]][hb31b[i]];
      xp31[i] = ( -A31[i] + (mt31[0][i]-mt31[1][i]) / 2. ) / B31[i] ;
      if ( ms31a[i] == 4095. ){
	ms31a[i] = 0.;
      } else {
	ms31a[i] = 1.;
      };
      if ( ms31b[i] == 4095. ){
	ms31b[i] = 0.;
      } else {
	ms31b[i] = 1.;
      };
    };
    for ( Int_t i = 0; i<3; i++ ) {
      mt32[0][i] = tof->tdc[ch32a[i]][hb32a[i]];
      mt32[1][i] = tof->tdc[ch32b[i]][hb32b[i]];
      ms32a[i] = tof->adc[ch32a[i]][hb32a[i]];
      ms32b[i] = tof->adc[ch32b[i]][hb32b[i]];
      xp32[i] = ( -A32[i] + (mt32[0][i]-mt32[1][i]) / 2. ) / B32[i] ;
      if ( ms32a[i] == 4095. ){
	ms32a[i] = 0.;
      } else {
	ms32a[i] = 1.;
      };
      if ( ms32b[i] == 4095. ){
	ms32b[i] = 0.;
      } else {
	ms32b[i] = 1.;
      };
    };
  };
  //
  //
  //
  Bool_t repeat = true;
  //  Int_t numtr = 1;
  Int_t numtr = 0;
  Int_t repuntil = 0;
  Int_t repuntiltr = 0;
  //  
  //
  var.tofraw = 0;
  //
  if ( level.file == 2 ) repuntil = L2->GetToFLevel2()->ntrk();    
  //  printf("repuntil = %i \n",repuntil);
  if ( level.file == 2 ) repuntiltr = L2->GetTrkLevel2()->GetNTracks();    
  //  repuntiltr = L2->GetNTracks();    
  //
  while ( repeat ){
    //    printf("B repuntil = %i \n",repuntil);
    if ( level.file == 2 ){
      //
      //
      //
      ToFTrkVar *ptt = 0;
      PamTrack *ptrack = 0;
      Float_t adc[4][12];
      Float_t tdc[4][12];
      memset(adc,0,4*12*sizeof(Float_t));
      memset(tdc,0,4*12*sizeof(Float_t));
      //      
      //
      Int_t myseq = 0; 
      //      if ( repuntil == 0 || var.tofraw ){
      if ( repuntil == 1 || var.tofraw ){
	numtr = 0;
	ptt = L2->GetToFLevel2()->GetToFTrkVar(0); 
	repeat = false;
      } else {
	//
//        printf(" deH_ \n");
	//
        if ( numtr == 0 ){
//          printf(" ques \n");
          ptt = L2->GetToFLevel2()->GetToFTrkVar(0); 
          myseq = 0;
//          printf(" que \n");

        } else {
          if ( numtr >= (repuntiltr-1) ) repeat = false;
          //
          printf(" numtr is %i \n",numtr);
          // ptt = L2->GetToFLevel2()->GetToFTrkVar(numtr); 	
          ptrack = L2->GetTrack(numtr-1); 
          ptt = ptrack->GetToFTrack();
          myseq = ptt->trkseqno + 1;
        };
      };
      //
      xp11[0] = 0.;
      xp12[0] = 0.;
      xp21[0] = 0.;
      xp22[0] = 0.;
      xp31[0] = 0.;
      xp32[0] = 0.;
      //
      //
      //
      ii = 2;
      //
      //      Int_t myseq = ptt->trkseqno + 1;
      //
//      printf(" qui \n");
      L2->GetToFLevel2()->GetMatrix(myseq,adc,tdc);
      //
//      printf(" qua \n");
      //
      //       for ( Int_t i = 0; i<8; i++ ) {	
      // 	if ( adc[ch11a[i]][hb11a[i]] < 1000. ){
      // 	  ms11a[i] = adc[ch11a[i]][hb11a[i]];
      // 	};	
      // 	if ( adc[ch11b[i]][hb11b[i]] < 1000. ){
      // 	  ms11b[i] = adc[ch11b[i]][hb11b[i]];
      // 	};
      //	xp11[i] = 0.;
      //    };

      Int_t nmtof = 0;
      Float_t mtof = 0.;
      var.beta[4] = 0.;
      if (  ptt->beta[12] != 0. &&  ptt->beta[12] != 100. ){
	var.beta[4] = ptt->beta[12];
      } else {
	for (Int_t tf = 0; tf<12 ;tf++){
	  if ( ptt->beta[tf] != 0. &&  ptt->beta[tf] != 100.){
	    mtof += ptt->beta[tf];
	    nmtof++;
	  };
	};
	if ( nmtof ){
	  var.beta[4] = mtof/nmtof;
	} else {
	  var.beta[4] = 0.;
	};
      };
      ii = 2;
      //
      for ( Int_t i = 0; i<8; i++ ) {	
	if ( adc[ch11a[i]][hb11a[i]] < 1000. ){
	  ms11a[i] = adc[ch11a[i]][hb11a[i]];
	};	
	if ( adc[ch11b[i]][hb11b[i]] < 1000. ){
	  ms11b[i] = adc[ch11b[i]][hb11b[i]];
	};
	xp11[i] = 0.;
      };
      //
      xp11[0] = ptt->ytofpos[0];
      //
      for ( Int_t i = 0; i<6; i++ ) {
	if ( adc[ch12a[i]][hb12a[i]] < 1000. ) ms12a[i] = adc[ch12a[i]][hb12a[i]];
	if ( adc[ch12b[i]][hb12b[i]] < 1000. ) ms12b[i] = adc[ch12b[i]][hb12b[i]];
	xp12[i] = 0.;
      };    
      //
      xp12[0] = ptt->xtofpos[0];
      //
      ii = 2;
      for ( Int_t i = 0; i<2; i++ ) {
	ii--;
	if ( adc[ch21a[i]][hb21a[i]] < 1000. ) ms21a[ii] = adc[ch21a[i]][hb21a[i]];
	if ( adc[ch21b[i]][hb21b[i]] < 1000. ) ms21b[ii] = adc[ch21b[i]][hb21b[i]];
	xp21[i] = 0.;
      };
      xp21[0] = ptt->xtofpos[1];
      //
      for ( Int_t i = 0; i<2; i++ ) {
	if ( adc[ch22a[i]][hb22a[i]] < 1000. ) ms22a[i] = adc[ch22a[i]][hb22a[i]];
	if ( adc[ch22b[i]][hb22b[i]] < 1000. ) ms22b[i] = adc[ch22b[i]][hb22b[i]];
	xp22[i] = 0.;
      };
      xp22[0] = ptt->ytofpos[1];
      //
      for ( Int_t i = 0; i<3; i++ ) {
	if ( adc[ch31a[i]][hb31a[i]] < 1000. ) ms31a[i] = adc[ch31a[i]][hb31a[i]];
	if ( adc[ch31b[i]][hb31b[i]] < 1000. ) ms31b[i] = adc[ch31b[i]][hb31b[i]];
	xp31[i] = 0.;
      };
      xp31[0] = ptt->ytofpos[2];
      //
      for ( Int_t i = 0; i<3; i++ ) {
	if ( adc[ch32a[i]][hb32a[i]] < 1000. ) ms32a[i] = adc[ch32a[i]][hb32a[i]];
	if ( adc[ch32b[i]][hb32b[i]] < 1000. ) ms32b[i] = adc[ch32b[i]][hb32b[i]];
	xp32[i] = 0.;
      };
      xp32[0] = ptt->xtofpos[2];
      //
      numtr++;    
      //numtr = repuntil+10;    
      //      repeat = false;
      //      printf("pre drawingdrawing... %i %i\n",numtr,ptt->trkseqno);
      //
    }; // end if level2
    //
    //
    //  drawtof:
    //
    //    printf("drawingdrawing... %i \n",repuntil);
    //
    Int_t colo = 0;
    Int_t ocolo = 0;
    Float_t xs2x = var.xxvc;
    Float_t ys2x = var.yxvc + 0.36*var.sfy;
    Float_t xs2y = var.xyvc;
    Float_t ys2y = var.yyvc + 0.36*var.sfy;
    Float_t ws2 = 0.005;
    Float_t ws13 = 0.007;
    //
    // S11  X-view
    //
    Float_t s11p = 0.051;
    ocolo = 10;
    TPolyLine *ftof11x[8];
    for ( Int_t j=0; j<8; j++){
      Float_t nxc1[5]={ (s11p*j),       (s11p*j),               s11p*(j+1),     s11p*(j+1), (s11p*j)};
      Float_t nyc1[5]={ 0.,                       ws13,     ws13,   0.,  0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + (-0.204+nxc1[i])*var.sfx;
	nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
      };
      ftof11x[j] = new TPolyLine(5,nxc,nyc);
      ftof11x[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      if ( level.file == -1 ){
	ColorMIP(ms11a[j]+ms11b[j],colo);	
      } else {
	ColorTOFMIP((ms11a[j]+ms11b[j])/2.,colo);	
      };
      //
      if ( colo != 10 ) ocolo = colo;
      //
      ftof11x[j]->SetFillColor(colo);
      ftof11x[j]->SetLineWidth(1);
      ftof11x[j]->Draw("f");
      ftof11x[j]->Draw();
    };
    //
    // S11  Y-view
    //
    Float_t nxc1[5]={ -0.165,       0.165,               0.165,     -0.165,    -0.165};
    Float_t nyc1[5]={ 0.,         0.,                ws13,    ws13,    0.};
    Float_t nxc[5];     
    Float_t nyc[5];
    for (Int_t i = 0; i<5 ; i++) {
      nxc[i]= xs2y + nxc1[i]*var.sfx;
      nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
    };
    TPolyLine *ftof11y = new TPolyLine(5,nxc,nyc);
    ftof11y->SetFillStyle(4000);
    ftof11y->SetFillColor(0);
    ftof11y->SetLineColor(1);
    ftof11y->SetLineWidth(1);
    ftof11y->Draw("f");
    ftof11y->Draw();
    TPolyLine *sftof11[8];
    tt = 1;
    rj=1;
    if ( level.file == -1 ){
      tt = 8;
      rj = 8;
    };
    for ( Int_t j=0; j<tt; j++){
      rj--;
      if ( (mt11[0][rj]<4095. || mt11[1][rj]<4095.)){
	if ( ocolo == 10 ) ocolo = noadc;
	Float_t lowp = -(xp11[rj]+E11[rj])/100.;
	Float_t higp = -(xp11[rj]-E11[rj])/100.;
	if ( lowp < -0.164 ) lowp = -0.164;
	if ( higp > 0.164 ) higp = 0.164;
	if ( lowp < higp && ( level.file == -1 || (level.file == 2 && xp11[rj] != 0.))){
	  Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
	  Float_t nyc1[5]={ 0.0015,         0.0015,                (float)(ws13-0.0015),    (float)(ws13-0.0015),    0.0015};
	  Float_t nxc[5];     
	  Float_t nyc[5];
	  for (Int_t i = 0; i<5 ; i++) {
	    nxc[i]= xs2y + nxc1[i]*var.sfx;
	    nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
	  };
	  sftof11[j] = new TPolyLine(5,nxc,nyc);
	  sftof11[j]->SetLineColor(ocolo);
	  sftof11[j]->SetFillColor(ocolo);
	  sftof11[j]->SetLineWidth(1);
	  sftof11[j]->Draw("f");
	  sftof11[j]->Draw();
	};
      };
    };

    //
    // S12  Y-view
    //
    Float_t s12p = 0.055;
    ocolo = 10;
    TPolyLine *ftof12y[6];
    rj = 6;
    for ( Int_t j=0; j<6; j++){
      rj--;
      Float_t nxc1[5]={ (s12p*j),       (s12p*j),               s12p*(j+1), s12p*(j+1),    (s12p*j)};
      Float_t nyc1[5]={      -ws13,     0.,  0., -ws13, -ws13};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + (-0.165+nxc1[i])*var.sfx;
	nyc[i] = ys2y + (0.295+nyc1[i])*var.sfy;
      };
      ftof12y[j] = new TPolyLine(5,nxc,nyc);
      ftof12y[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      if ( level.file == -1 ){
	ColorMIP(ms12a[rj]+ms12b[rj],colo);
      } else {
	ColorTOFMIP((ms12a[rj]+ms12b[rj])/2.,colo);
      };
      //
      if ( colo != 10 ) ocolo = colo;
      //
      ftof12y[j]->SetFillColor(colo);
      ftof12y[j]->SetLineWidth(1);
      ftof12y[j]->Draw("f");
      ftof12y[j]->Draw();
    };
    //
    // S12  X-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.204,       0.204,               0.204,     -0.204,    -0.204};
      Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + nxc1[i]*var.sfx;
	nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
      };
      TPolyLine *ftof12x = new TPolyLine(5,nxc,nyc);
      ftof12x->SetLineColor(1);
      ftof12x->SetFillStyle(4000);
      ftof12x->SetFillColor(0);    
      ftof12x->SetLineWidth(1);
      ftof12x->Draw("f");
      ftof12x->Draw();
      TPolyLine *sftof12[6];
      tt = 1;
      if ( level.file == -1 ) tt = 6;
      for (Int_t j=0; j<tt; j++){
	//    for ( Int_t j=0; j<6; j++){
	if ( (mt12[0][j]<4095. || mt12[1][j]<4095.)  ){
	  if ( ocolo == 10 ) ocolo = noadc;
	  Float_t lowp = (xp12[j]-E12[j])/100.;
	  Float_t higp = (xp12[j]+E12[j])/100.;
	  if ( lowp < -0.203 ) lowp = -0.203;
	  if ( higp > 0.203 ) higp = 0.203;
	  if ( lowp < higp && ( level.file == -1 || (level.file == 2 && xp12[j] != 0.))){
	    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
	    Float_t nyc1[5]={ -0.0015,         -0.0015,                (float)(-ws13+0.0015),    (float)(-ws13+0.0015),    -0.0015};
	    Float_t nxc[5];     
	    Float_t nyc[5];
	    for (Int_t i = 0; i<5 ; i++) {
	      nxc[i]= xs2x + nxc1[i]*var.sfx;
	      nyc[i] = ys2x + (0.295+nyc1[i])*var.sfy;
	    };
	    sftof12[j] = new TPolyLine(5,nxc,nyc);
	    sftof12[j]->SetLineColor(ocolo);
	    sftof12[j]->SetFillColor(ocolo);
	    sftof12[j]->SetLineWidth(1);
	    sftof12[j]->Draw("f");
	    sftof12[j]->Draw();
	  };
	};
      };
    };
    //

    //
    // S21  Y-view
    //
    Float_t s21p = 0.075;
    ocolo = 10;
    TPolyLine *ftof21y[2];
    rj=2;
    for ( Int_t j=0; j<2; j++){
      rj--;
      Float_t nxc1[5]={ s21p*(j-1),       s21p*(j-1),               s21p*j,s21p*j,     s21p*(j-1)};
      Float_t nyc1[5]={ 0.,                ws2,     ws2,  0.,  0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + nxc1[i]*var.sfx;
	nyc[i] = ys2y + nyc1[i]*var.sfy;
        //        printf(" TOF i %i x %f y %f \n",i,nxc[i],nyc[i]);
      };
      ftof21y[j] = new TPolyLine(5,nxc,nyc);
      ftof21y[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      if ( level.file == -1 ){
	ColorMIP(ms21a[rj]+ms21b[rj],colo);
      } else {
	ColorTOFMIP((ms21a[rj]+ms21b[rj])/2.,colo);
      };
      //
      if ( colo != 10 ) ocolo = colo;
      //
      ftof21y[j]->SetFillColor(colo);
      ftof21y[j]->SetLineWidth(1);
      ftof21y[j]->Draw("f");
      ftof21y[j]->Draw();
    };
    //
    // S21  X-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
      Float_t nyc1[5]={ 0.,         0.,                ws2,    ws2,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + nxc1[i]*var.sfx;
	nyc[i] = ys2x + nyc1[i]*var.sfy;
      };
      TPolyLine *ftof21x = new TPolyLine(5,nxc,nyc);
      ftof21x->SetLineColor(1);
      ftof21x->SetFillStyle(4000);
      ftof21x->SetFillColor(0);
      ftof21x->SetLineWidth(1);
      ftof21x->Draw("f");
      ftof21x->Draw();
      TPolyLine *sftof21[2];
      tt = 1;
      if ( level.file == -1 ) tt = 2;
      for ( Int_t j=0; j<tt; j++){
	//    for ( Int_t j=0; j<2; j++){
	if ( (mt21[0][j]<4095. || mt21[1][j]<4095.) ){
	  if ( ocolo == 10 ) ocolo = noadc;
	  Float_t lowp = (xp21[j]-E21[j])/100.;
	  Float_t higp = (xp21[j]+E21[j])/100.;
	  if ( lowp < -0.089 ) lowp = -0.089;
	  if ( higp > 0.089 ) higp = 0.089;
	  if ( lowp < higp && ( level.file == -1 || (level.file == 2 && xp21[j] != 0.))){
	    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
	    Float_t nyc1[5]={ 0.0015,         0.0015,                (float)(ws2-0.0015),    (float)(ws2-0.0015),    0.};
	    Float_t nxc[5];     
	    Float_t nyc[5];
	    for (Int_t i = 0; i<5 ; i++) {
	      nxc[i]= xs2x + nxc1[i]*var.sfx;
	      nyc[i] = ys2x + nyc1[i]*var.sfy;
	    };
	    sftof21[j] = new TPolyLine(5,nxc,nyc);
	    sftof21[j]->SetLineColor(ocolo);
	    sftof21[j]->SetFillColor(ocolo);
	    sftof21[j]->SetLineWidth(1);
	    sftof21[j]->Draw("f");
	    sftof21[j]->Draw();
	  };
	};
      };
    };
    //

    //
    // S22  X-view
    //
    Float_t s22p = 0.090;
    ocolo = 10;
    TPolyLine *ftof22x[2];
    for ( Int_t j=0; j<2; j++){
      Float_t nxc1[5]={ s22p*(j-1),       s22p*(j-1),               s22p*j, s22p*j,     s22p*(j-1)};
      Float_t nyc1[5]={                -ws2,   0., 0.,  -ws2,  -ws2};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + nxc1[i]*var.sfx;
	nyc[i] = ys2x + nyc1[i]*var.sfy;
      };
      ftof22x[j] = new TPolyLine(5,nxc,nyc);
      ftof22x[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      if ( level.file == -1 ){
	ColorMIP(ms22a[j]+ms22b[j],colo);
      } else {
	ColorTOFMIP((ms22a[j]+ms22b[j])/2.,colo);
      };
      //
      if ( colo != 10 ) ocolo = colo;
      //
      ftof22x[j]->SetFillColor(colo);
      ftof22x[j]->SetLineWidth(1);
      ftof22x[j]->Draw("f");
      ftof22x[j]->Draw();
    };
    //
    // S22  Y-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
      Float_t nyc1[5]={ 0.,         0.,                -ws2,    -ws2,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + nxc1[i]*var.sfx;
	nyc[i] = ys2y + nyc1[i]*var.sfy;
      };
      TPolyLine *ftof22y = new TPolyLine(5,nxc,nyc);
      ftof22y->SetLineColor(1);
      ftof22y->SetFillStyle(4000);
      ftof22y->SetFillColor(0);
      ftof22y->SetLineWidth(1);
      ftof22y->Draw("f");
      ftof22y->Draw();
      TPolyLine *sftof22[2];
      tt = 1;
      rj = 1;
      if ( level.file == -1 ){
	tt = 2;
	rj = 2;
      };
      for (Int_t j=0; j<tt; j++){
	rj--;
	//    for ( Int_t j=0; j<2; j++){
	if ( (mt22[0][rj]<4095. || mt22[1][rj]<4095.) ){
	  if ( ocolo == 10 ) ocolo = noadc;
	  Float_t lowp = -(xp22[rj]+E22[rj])/100.;
	  Float_t higp = -(xp22[rj]-E22[rj])/100.;
	  if ( lowp < -0.074 ) lowp = -0.074;
	  if ( higp > 0.074 ) higp = 0.074;
	  if ( lowp < higp && ( level.file == -1 || (level.file == 2 && xp22[rj] != 0.))){
	    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
	    Float_t nyc1[5]={ -0.0015,         -0.0015,                (float)(-ws2+0.0015),    (float)(-ws2+0.0015),    -0.0015};
	    Float_t nxc[5];     
	    Float_t nyc[5];
	    for (Int_t i = 0; i<5 ; i++) {
	      nxc[i]= xs2y + nxc1[i]*var.sfx;
	      nyc[i] = ys2y + nyc1[i]*var.sfy;
	    };
	    sftof22[j] = new TPolyLine(5,nxc,nyc);
	    sftof22[j]->SetLineColor(ocolo);
	    sftof22[j]->SetFillColor(ocolo);
	    sftof22[j]->SetLineWidth(1);
	    sftof22[j]->Draw("f");
	    sftof22[j]->Draw();
	  };
	};
      };
    };
    //
    //daquiinbasso
    //
    // S31  X-view
    //
    Float_t s31p = 0.060;
    ocolo = 10;
    TPolyLine *ftof31x[3];
    for ( Int_t j=0; j<3; j++){
      Float_t nxc1[5]={ (s31p*j),       (s31p*j),               s31p*(j+1), s31p*(j+1),       (s31p*j)};
      Float_t nyc1[5]={ 0.,                       ws13,     ws13,    0.,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + (-0.090+nxc1[i])*var.sfx;
	nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
      };
      ftof31x[j] = new TPolyLine(5,nxc,nyc);
      ftof31x[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      if ( level.file == -1 ){
	ColorMIP(ms31a[j]+ms31b[j],colo);
      } else {
	ColorTOFMIP((ms31a[j]+ms31b[j])/2.,colo);
      };
      //
      if ( colo != 10 ) ocolo = colo;
      //
      ftof31x[j]->SetFillColor(colo);
      ftof31x[j]->SetLineWidth(1);
      ftof31x[j]->Draw("f");
      ftof31x[j]->Draw();
    };
    //
    // S31  Y-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.075,       0.075,               0.075,     -0.075,    -0.075};
      Float_t nyc1[5]={ 0.,         0.,                 ws13,    ws13,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + nxc1[i]*var.sfx;
	nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
      };
      TPolyLine *ftof31y = new TPolyLine(5,nxc,nyc);
      ftof31y->SetLineColor(1);
      ftof31y->SetFillStyle(4000);
      ftof31y->SetFillColor(0);
      ftof31y->SetLineWidth(1);
      ftof31y->Draw("f");
      ftof31y->Draw();
      TPolyLine *sftof31[3];
      tt = 1;
      rj = 1;
      if ( level.file == -1 ){
	tt = 3;
	rj = 3;
      };
      for (Int_t j=0; j<tt; j++){
	rj--;
	//    for ( Int_t j=0; j<3; j++){
	if ( (mt31[0][rj]<4095. || mt31[1][rj]<4095.)){
	  if ( ocolo == 10 ) ocolo = noadc;
	  Float_t lowp = -(xp31[rj]+E31[rj])/100.;
	  Float_t higp = -(xp31[rj]-E31[rj])/100.;
	  if ( lowp < -0.074 ) lowp = -0.074;
	  if ( higp > 0.074 ) higp = 0.074;
	  if ( lowp < higp && ( level.file == -1 || (level.file == 2 && xp31[rj] != 0.))){
	    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
	    Float_t nyc1[5]={ 0.0015,         0.0015,                (float)(ws13-0.0015),    (float)(ws13-0.0015),    0.0015};
	    Float_t nxc[5];     
	    Float_t nyc[5];
	    for (Int_t i = 0; i<5 ; i++) {
	      nxc[i]= xs2y + nxc1[i]*var.sfx;
	      nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
	    };
	    sftof31[j] = new TPolyLine(5,nxc,nyc);
	    sftof31[j]->SetLineColor(ocolo);
	    sftof31[j]->SetFillColor(ocolo);
	    sftof31[j]->SetLineWidth(1);
	    sftof31[j]->Draw("f");
	    sftof31[j]->Draw();
	  };
	};
      };
    };
    //

    //
    // S32  Y-view
    //
    Float_t s32p = 0.050;
    ocolo = 10;
    TPolyLine *ftof32y[3];
    rj = 3;
    for ( Int_t j=0; j<3; j++){
      rj--;
      Float_t nxc1[5]={ (s32p*j),       (s32p*j),               s32p*(j+1),s32p*(j+1),     (s32p*j)};
      Float_t nyc1[5]={     -ws13,     0.,    0., -ws13, -ws13};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2y + (-0.075+nxc1[i])*var.sfx;
	nyc[i] = ys2y + (-0.488+nyc1[i])*var.sfy;
      };
      ftof32y[j] = new TPolyLine(5,nxc,nyc);
      ftof32y[j]->SetLineColor(1);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };
      if ( level.file == -1 ){
	ColorMIP(ms32a[rj]+ms32b[rj],colo);
      } else {
	ColorTOFMIP((ms32a[rj]+ms32b[rj])/2.,colo);
      };
      //
      if ( colo != 10 ) ocolo = colo;
      //
      ftof32y[j]->SetFillColor(colo);
      ftof32y[j]->SetLineWidth(1);
      ftof32y[j]->Draw("f");
      ftof32y[j]->Draw();
    };
    //
    // S32  X-view
    //
    if ( true ){
      Float_t nxc1[5]={ -0.09,       0.09,               0.09,     -0.09,    -0.09};
      Float_t nyc1[5]={ 0.,         0.,                -ws13,    -ws13,    0.};
      Float_t nxc[5];     
      Float_t nyc[5];
      for (Int_t i = 0; i<5 ; i++) {
	nxc[i]= xs2x + nxc1[i]*var.sfx;
	nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
      };
      TPolyLine *ftof32x = new TPolyLine(5,nxc,nyc);
      ftof32x->SetLineColor(1);
      ftof32x->SetLineWidth(1);
      ftof32x->SetFillStyle(4000);
      ftof32x->SetFillColor(0);
      ftof32x->Draw("f");
      ftof32x->Draw();
      TPolyLine *sftof32[3];
      tt = 1;
      if ( level.file == -1 ) tt = 3;
      for (Int_t j=0; j<tt; j++){
	//    for ( Int_t j=0; j<3; j++){
	if ( (mt32[0][j]<4095. || mt32[1][j]<4095.) ){
	  if ( ocolo == 10 ) ocolo = noadc;
	  Float_t lowp = (xp32[j]-E32[j])/100.;
	  Float_t higp = (xp32[j]+E32[j])/100.;
	  if ( lowp < -0.089 ) lowp = -0.089;
	  if ( higp > 0.089 ) higp = 0.089;
	  if ( lowp < higp && ( level.file == -1 || (level.file == 2 && xp32[j] != 0.))){
	    Float_t nxc1[5]={ lowp, higp, higp, lowp, lowp};
	    Float_t nyc1[5]={ -0.0015,         -0.0015,                (float)(-ws13+0.0015),    (float)(-ws13+0.0015),    -0.0015};
	    Float_t nxc[5];     
	    Float_t nyc[5];
	    for (Int_t i = 0; i<5 ; i++) {
	      nxc[i]= xs2x + nxc1[i]*var.sfx;
	      nyc[i] = ys2x + (-0.488+nyc1[i])*var.sfy;
	    };
	    sftof32[j] = new TPolyLine(5,nxc,nyc);
	    sftof32[j]->SetLineColor(ocolo);
	    sftof32[j]->SetFillColor(ocolo);
	    sftof32[j]->SetLineWidth(1);
	    sftof32[j]->Draw("f");
	    sftof32[j]->Draw();
	  };
	};
      };
    };
    //
    if ( level.file == -1 || numtr >= repuntil ) repeat = false;
    //
  };
  //
}


void FEVdetector::ShowAC(){
  //
  //
  //
  if ( !var.AC ) return;
  //
  Int_t hitmapA = 0;
  Int_t hitmapB = 0;
  Int_t hitstatusA = 0;
  Int_t hitstatusB = 0;
  //
  // level0 and level-1 do not give infos about out of trigger events
  //
  if ( level.file == 0 || level.file == -1 ){
    hitmapA = ace->hitmap[0];
    hitmapB = ace->hitmap[1];
    hitstatusA = 65535;
    hitstatusB = 65535;
  };
  //
  // full infos from ac
  //
  if ( level.file == 2 ){
    hitmapA = L2->GetAcLevel2()->hitmap[0];
    hitmapB = L2->GetAcLevel2()->hitmap[1];
    hitstatusA = L2->GetAcLevel2()->hitstatus[0];
    hitstatusB = L2->GetAcLevel2()->hitstatus[1];
  };
  //
  //
  //
  Float_t cas1 = 0.;
  Float_t cas2 = 0.;
  Float_t cas3 = 0.;
  Float_t cas4 = 0.;
  Float_t cas1b = 0.;
  Float_t cas2b = 0.;
  Float_t cas3b = 0.;
  Float_t cas4b = 0.;
  //
  Float_t cat1 = 0.;
  Float_t cat2 = 0.;
  Float_t cat3 = 0.;
  Float_t cat4 = 0.;
  Float_t cat1b = 0.;
  Float_t cat2b = 0.;
  Float_t cat3b = 0.;
  Float_t cat4b = 0.;
  //
  Float_t card1 = 0.;
  Float_t card2 = 0.;
  Float_t card3 = 0.;
  Float_t card4 = 0.;
  Float_t card1b = 0.;
  Float_t card2b = 0.;
  Float_t card3b = 0.;
  Float_t card4b = 0.;
  //
  Float_t intime = -0.25;
  Float_t outtime = -0.375;
  if ( var.bw ){
    intime = -0.25;
    outtime = -0.375;
  } else {
    intime = 1.;
    outtime = -4.;
  };
  //
  // main board
  //
  if ( hitmapA & (1<<0) ) {
    card4 = intime;
    if ( !(hitstatusA & (1<<0)) ) card4 = outtime ;
    var.hcard++;
  }
  if ( hitmapA & (1<<1) ) {
    cat2 = intime;
    if ( !(hitstatusA & (1<<1)) ) cat2 = outtime ;
    var.hcat++;
  }
  if ( hitmapA & (1<<2) ) {
    cas1 = intime;
    if ( !(hitstatusA & (1<<2)) ) cas1 = outtime ;
    var.hcas++;
  }
  //
  if ( hitmapA & (1<<4) ) {
    card2 = intime;
    if ( !(hitstatusA & (1<<4)) ) card2 = outtime ;
    var.hcard++;
  }
  if ( hitmapA & (1<<5) ) {
    cat4 = intime;
    if ( !(hitstatusA & (1<<5)) ) cat4 = outtime ;
    var.hcat++;
  }
  if ( hitmapA & (1<<6) ) {
    cas4 = intime;
    if ( !(hitstatusA & (1<<6)) ) cas4 = outtime ;
    var.hcas++;
  }
  //
  if ( hitmapA & (1<<8) ) {
    card3 = intime;
    if ( !(hitstatusA & (1<<8)) ) card3 = outtime ;
    var.hcard++;
  }
  if ( hitmapA & (1<<9) ) {
    cat3 = intime;
    if ( !(hitstatusA & (1<<9)) ) cat3 = outtime ;
    var.hcat++;
  }
  if ( hitmapA & (1<<10) ) {
    cas3 = intime;
    if ( !(hitstatusA & (1<<10)) ) cas3 = outtime ;
    var.hcas++;
  }
  //
  if ( hitmapA & (1<<12) ) {
    card1 = intime;
    if ( !(hitstatusA & (1<<12)) ) card1 = outtime ;
    var.hcard++;
  }
  if ( hitmapA & (1<<13) ) { 
    cat1 = intime;
    if ( !(hitstatusA & (1<<13)) ) cat1 = outtime ;
    var.hcat++;
  }
  if ( hitmapA & (1<<14) ) { 
    cas2 = intime;
    if ( !(hitstatusA & (1<<14)) ) cas2 = outtime ;
    var.hcas++;
  }	    
  //
  // extra board
  //
  if ( hitmapB & (1<<0) ) {
    card4b = intime;
    if ( !(hitstatusB & (1<<0)) ) card4b = outtime ;
    var.hcard++;
  }
  if ( hitmapB & (1<<1) ) {
    cat2b = intime; 
    if ( !(hitstatusB & (1<<1)) ) cat2b = outtime ;
    var.hcat++;
  }
  if ( hitmapB & (1<<2) ) {
    cas1b = intime;
    if ( !(hitstatusB & (1<<2)) ) cas1b = outtime;
    var.hcas++;
  }
  //
  if ( hitmapB & (1<<4) ) {
    card2b = intime;
    if ( !(hitstatusB & (1<<4)) ) card2b = outtime ;
    var.hcard++;
  }
  if ( hitmapB & (1<<5) ) {
    cat4b = intime;
    if ( !(hitstatusB & (1<<5)) ) cat4b = outtime ;
    var.hcat++;
  }
  if ( hitmapB & (1<<6) ) {
    cas4b = intime;
    if ( !(hitstatusB & (1<<6)) ) cas4b = outtime ;
    var.hcas++;
  }
  //
  if ( hitmapB & (1<<8) ) {
    card3b = intime;
    if ( !(hitstatusB & (1<<8)) ) card3b = outtime ;
    var.hcard++;
  }
  if ( hitmapB & (1<<9) ) { 
    cat3b = intime;
    if ( !(hitstatusB & (1<<9)) ) cat3b = outtime ;
    var.hcat++;
  }
  if ( hitmapB & (1<<10) ) { 
    cas3b = intime;
    if ( !(hitstatusB & (1<<10)) ) cas3b = outtime ;
    var.hcas++;
  }
  //
  if ( hitmapB & (1<<12) ) { 
    card1b = intime;	
    if ( !(hitstatusB & (1<<12)) ) card1b = outtime ;
    var.hcard++;
  }
  if ( hitmapB & (1<<13) ) {
    cat1b = intime;
    if ( !(hitstatusB & (1<<13)) ) cat1b = outtime ;
    var.hcat++;
  }
  if ( hitmapB & (1<<14) ) {
    cas2b = intime;
    if ( !(hitstatusB & (1<<14)) ) cas2b = outtime ;
    var.hcas++;
  };
  Int_t colo = 0;
  //
  // CAS height and width
  //
  Float_t csh = 0.194*var.sfy;
  Float_t csw = 0.008*var.sfx;
  Float_t ctw = 0.008;

  //
  // CAS2 -0.039-0.081   |TRX     TRY
  //
  if ( true ){
    Float_t xofs = var.xxvc -(0.039+0.081+0.0273)*var.sfx;
    Float_t yofs = var.yxvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
    Double_t y[4] = {yofs-csh,yofs-csh,yofs+csh,yofs-csh};
    TPolyLine *fcas2 = new TPolyLine(4,x,y);
    fcas2->SetLineColor(1);
    colo = (int)(10. - cas2 * 8.);
    fcas2->SetFillColor(colo);
    fcas2->SetLineWidth(1);
    fcas2->Draw("f");
    fcas2->Draw();
  };
  if ( true ){
    Float_t xofs = var.xxvc -(0.039 +0.081 +0.0273)*var.sfx;
    Float_t yofs = var.yxvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
    Double_t y[4] = {yofs+csh,yofs-csh,yofs+csh,yofs+csh};
    TPolyLine *fcas2b = new TPolyLine(4,x,y);
    fcas2b->SetLineColor(1);
    colo = (int)(10. - cas2b * 8.);
    fcas2b->SetFillColor(colo);
    fcas2b->SetLineWidth(1);
    fcas2b->Draw("f");
    fcas2b->Draw();
  };
  //
  // CAS1 -0.039+0.081  TRX|  TRY
  //
  if ( true ){
    Float_t xofs = var.xxvc + (0.039 +0.081+0.0273)*var.sfx +csw;
    Float_t yofs = var.yxvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
    Double_t y[4] = {yofs-csh,yofs+csh,yofs-csh,yofs-csh};
    TPolyLine *fcas1 = new TPolyLine(4,x,y);
    fcas1->SetLineColor(1);
    colo = (int)(10. - cas1 * 8.);
    fcas1->SetFillColor(colo);
    fcas1->SetLineWidth(1);
    fcas1->Draw("f");
    fcas1->Draw();
  };
  if ( true ){
    Float_t xofs = var.xxvc + (0.039 +0.081+0.0273)*var.sfx +csw;
    Float_t yofs = var.yxvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
    Double_t y[4] = {yofs+csh,yofs+csh,yofs-csh,yofs+csh};
    TPolyLine *fcas1b = new TPolyLine(4,x,y);
    fcas1b->SetLineColor(1);
    colo = (int)(10. - cas1b * 8.);
    fcas1b->SetFillColor(colo);
    fcas1b->SetLineWidth(1);
    fcas1b->Draw("f");
    fcas1b->Draw();
  };
  //
  // CAS4 -0.039-0.081  TRX   |TRY
  //
  if ( true ){
    Float_t xofs = var.xyvc - (0.048 +0.066 +0.0273)*var.sfx;
    Float_t yofs = var.yyvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
    Double_t y[4] = {yofs-csh,yofs-csh,yofs+csh,yofs-csh};
    TPolyLine *fcas4 = new TPolyLine(4,x,y);
    fcas4->SetLineColor(1);
    colo = (int)(10. - cas4 * 8.);
    fcas4->SetFillColor(colo);
    fcas4->SetLineWidth(1);
    fcas4->Draw("f");
    fcas4->Draw();
  };
  if ( true ){
    Float_t xofs = var.xyvc - (0.048 +0.066 +0.0273)*var.sfx;
    Float_t yofs = var.yyvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
    Double_t y[4] = {yofs+csh,yofs-csh,yofs+csh,yofs+csh};
    TPolyLine *fcas4b = new TPolyLine(4,x,y);
    fcas4b->SetLineColor(1);
    colo = (int)(10. - cas4b * 8.);
    fcas4b->SetFillColor(colo);
    fcas4b->SetLineWidth(1);
    fcas4b->Draw("f");
    fcas4b->Draw();
  };

  //
  // CAS3 -0.039+0.081   TRX   TRY| 
  //
  if ( true ){
    Float_t xofs = var.xyvc + (0.048 +0.066+0.0273)*var.sfx +csw;
    Float_t yofs = var.yyvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs-csw,xofs,xofs-csw};
    Double_t y[4] = {yofs-csh,yofs+csh,yofs-csh,yofs-csh};
    TPolyLine *fcas3 = new TPolyLine(4,x,y);
    fcas3->SetLineColor(1);
    colo = (int)(10. - cas3 * 8.);
    fcas3->SetFillColor(colo);
    fcas3->SetLineWidth(1);
    fcas3->Draw("f");
    fcas3->Draw();
  };
  if ( true ){
    Float_t xofs = var.xyvc + (0.048 +0.066+0.0273)*var.sfx +csw;
    Float_t yofs = var.yyvc + 0.09*var.sfy ;
    Double_t x[4] = {xofs-csw,xofs,xofs,xofs-csw};
    Double_t y[4] = {yofs+csh,yofs+csh,yofs-csh,yofs+csh};
    TPolyLine *fcas3b = new TPolyLine(4,x,y);
    fcas3b->SetLineColor(1);
    colo = (int)(10. - cas3b * 8.);
    fcas3b->SetFillColor(colo);
    fcas3b->SetLineWidth(1);
    fcas3b->Draw("f");
    fcas3b->Draw();
  };

  //
  // CAT coordinate system
  //
  Float_t xcat = var.xcat;
  Float_t ycat = var.ycat;
  Float_t pmt1 = 0.0356;    
  Float_t pmt2 = 0.038;    
  Float_t xpmt1 = -0.149*var.sfx;
  Float_t ypmt1 = 0.251*var.sfy;
  Float_t apmt1 = atan((11.*var.sfy)/(14.*var.sfx));
  Float_t xpmt2 = -0.257*var.sfx;
  Float_t ypmt2 = 0.158*var.sfy;
  Float_t apmt2 = atan((11.*var.sfx)/(15.*var.sfy));
  //
  Int_t cattime = 13;
  Int_t catnoti = 12;
  if ( var.bw ){
    cattime = 13;
    catnoti = 12;
  } else {
    cattime = 2;
    catnoti = 42;
  };
  //
  if ( true ){
    // PMTs
    Float_t xc1[5]={ 0., (float)(0.014*var.sfx), (float)(0.014*var.sfx-var.sfx*var.sfx*pmt1*cos(apmt1)), (float)(-var.sfx*var.sfx*pmt1*cos(apmt1)), 0.};
    Float_t yc1[5]={ 0., (float)(0.011*var.sfy), (float)(0.011*var.sfy+var.sfy*var.sfy*pmt1*sin(apmt1)), (float)(var.sfy*var.sfy*pmt1*sin(apmt1)), 0.};
    Float_t xc2[5]={ 0., (float)(0.011*var.sfx), (float)(0.011*var.sfx-pmt2*var.sfx*var.sfx*cos(apmt2)), (float)(-pmt2*var.sfx*var.sfx*cos(apmt2)), 0.};
    Float_t yc2[5]={ 0., (float)(0.015*var.sfy), (float)(0.015*var.sfy+var.sfy*pmt2*var.sfy*sin(apmt2)), (float)(var.sfy*pmt2*var.sfy*sin(apmt2)), 0.};
    // SCINTs
    Float_t xcc1[10]={-0.149, -0.090165, -0.090165, -0.149, -0.242, -0.257, -0.212,   -0.257,   -0.242,   -0.149};
    Float_t ycc1[10]={ 0.169,  0.108165, -0.108165, -0.169, -0.169, -0.158, 0.,   0.158,    0.169,    0.169};
    Float_t xcc2[10]={-0.149,   -0.149,   -0.138,     0., 0.138, 0.149, 0.149, 0.090165,   -0.090165,   -0.149};
    Float_t ycc2[10]={ 0.169,    0.251,    0.265,  0.220, 0.265, 0.251, 0.169, 0.108165,    0.108165,    0.169};   
    //
    // CAT sections
    //
    if ( true ){
      Float_t xofs = var.xxvc -0.108165*var.sfx;
      Float_t yofs = var.yxvc + 0.3725*var.sfy ;
      Double_t xx[5] = {xofs,xofs-0.112*var.sfx,xofs-0.112*var.sfx,xofs,xofs};
      Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
      TPolyLine *fcat3 = new TPolyLine(5,xx,yy);
      fcat3->SetLineColor(1);
      if ( cat3 != 0. || cat3b != 0. ){
	if ( cat3 > 0 || cat3b > 0 || cat3 == -0.25 || cat3b == -0.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      } else {
	colo = 10;
      };
      fcat3->SetFillColor(colo);
      fcat3->SetLineWidth(1);
      fcat3->Draw("f");
      fcat3->Draw();
    };
    if ( true ){
      Float_t xofs = var.xxvc +0.108165*var.sfx;
      Float_t yofs = var.yxvc + 0.3725 *var.sfy;
      Double_t xx[5] = {xofs,xofs+0.112*var.sfx,xofs+0.112*var.sfx,xofs,xofs};
      Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
      TPolyLine *fcat4 = new TPolyLine(5,xx,yy);
      fcat4->SetLineColor(1);
      if ( cat4 != 0. || cat4b != 0. ){
	if ( cat4 > 0 || cat4b > 0 || cat4 == -.25 || cat4b == -.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      } else {
	colo = 10;
      };
      fcat4->SetFillColor(colo);
      fcat4->SetLineWidth(1);
      fcat4->Draw("f");
      fcat4->Draw();
    };
    if ( true ){
      Float_t xofs = var.xyvc + 0.090165*var.sfx;
      Float_t yofs = var.yyvc + 0.3725*var.sfy ;
      Double_t xx[5] = {xofs,xofs+0.122*var.sfx,xofs+0.122*var.sfx,xofs,xofs};
      Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
      TPolyLine *fcat1 = new TPolyLine(5,xx,yy);
      fcat1->SetLineColor(1);
      if ( cat1 != 0. || cat1b != 0. ){
	if ( cat1 > 0 || cat1b > 0 || cat1 ==-.25 || cat1b ==-.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      } else {
	colo = 10;
      };
      fcat1->SetFillColor(colo);
      fcat1->SetLineWidth(1);
      fcat1->Draw("f");
      fcat1->Draw();
    };
    if ( true ){
      Float_t xofs = var.xyvc - 0.090165*var.sfx;
      Float_t yofs = var.yyvc + 0.3725*var.sfy ;
      Double_t xx[5] = {xofs,xofs-0.122*var.sfx,xofs-0.122*var.sfx,xofs,xofs};
      Double_t yy[5] = {yofs,yofs,yofs+ctw,yofs+ctw,yofs};
      TPolyLine *fcat2 = new TPolyLine(5,xx,yy);
      fcat2->SetLineColor(1);
      if ( cat2 != 0. || cat2b != 0. ){
	if ( cat2 > 0 || cat2b > 0 || cat2 ==-.25 || cat2b ==-.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      } else {
	colo = 10;
      };
      fcat2->SetFillColor(colo);
      fcat2->SetLineWidth(1);
      fcat2->Draw("f");
      fcat2->Draw();
    };
    //
    // CAT1
    //
    Float_t xcc[10];     
    Float_t ycc[10];
    if ( true ){
      for (Int_t i = 0; i<10 ; i++) {
	xcc[i]= xcat - xcc1[i]*var.sfx;
	ycc[i] = ycat + ycc1[i]*var.sfy;
      };
      TPolyLine *fcat1 = new TPolyLine(10,xcc,ycc);
      fcat1->SetLineColor(1);
      colo = 10;
      if ( cat1 != 0. || cat1b != 0. ) {
	if ( cat1 > 0 || cat1b > 0 || cat1 ==-.25 || cat1b ==-.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      };
      fcat1->SetFillColor(colo);
      fcat1->SetLineWidth(1);
      fcat1->Draw("f");
      fcat1->Draw();
    };
    //
    // CAT2
    //
    if ( true ){
      for (Int_t i = 0; i<10 ; i++) {
	xcc[i]= xcat + xcc1[i]*var.sfx;
	ycc[i] = ycat + ycc1[i]*var.sfy;
      };
      TPolyLine *fcat2 = new TPolyLine(10,xcc,ycc);
      fcat2->SetLineColor(1);
      colo = 10;
      if ( cat2 != 0. || cat2b != 0. ) {
	if ( cat2 > 0 || cat2b > 0 || cat2 ==-.25 || cat2b ==-.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      };
      fcat2->SetFillColor(colo);
      fcat2->SetLineWidth(1);
      fcat2->Draw("f");
      fcat2->Draw();
    };
    //
    // CAT3
    //
    if ( true ){
      for (Int_t i = 0; i<10 ; i++) {
	xcc[i]= xcat + xcc2[i]*var.sfx;
	ycc[i] = ycat - ycc2[i]*var.sfy;
      };
      TPolyLine *fcat3 = new TPolyLine(10,xcc,ycc);
      fcat3->SetLineColor(1);
      colo = 10;
      if ( cat3 != 0. || cat3b != 0. ) {
	if ( cat3 > 0 || cat3b > 0 || cat3 == -.25  || cat3b ==-.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      }; 
      fcat3->SetFillColor(colo);
      fcat3->SetLineWidth(1);
      fcat3->Draw("f");
      fcat3->Draw();
    };
    //
    // CAT4
    //
    if ( true ){
      for (Int_t i = 0; i<10 ; i++) {
	xcc[i]= xcat + xcc2[i]*var.sfx;
	ycc[i] = ycat + ycc2[i]*var.sfy;
      };
      TPolyLine *fcat4 = new TPolyLine(10,xcc,ycc);
      fcat4->SetLineColor(1);
      colo = 10;
      if ( cat4 != 0. || cat4b != 0. ) {
	if ( cat4 > 0 || cat4b > 0 || cat4 == -.25  || cat4b ==-.25 ){
	  colo = cattime;
	} else {
	  colo = catnoti;
	};
      }; 
      fcat4->SetFillColor(colo);
      fcat4->SetLineWidth(1);
      fcat4->Draw("f");
      fcat4->Draw();
    };
    //
    // CAT1  PMTs
    //
    Float_t xc[5];     
    Float_t yc[5];
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat - xpmt2 - xc1[i];
	yc[i] = ycat + ypmt2 + yc1[i];
      };
      TPolyLine *fcat1 = new TPolyLine(5,xc,yc);
      fcat1->SetLineColor(1);
      colo = (int)(10. - cat1 * 8.);
      fcat1->SetFillColor(colo);
      fcat1->SetLineWidth(1);
      fcat1->Draw("f");
      fcat1->Draw();
    };
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat - xpmt2 - xc1[i];
	yc[i] = ycat - ypmt2 - yc1[i];
      };
      TPolyLine *fcat1b = new TPolyLine(5,xc,yc);
      fcat1b->SetLineColor(1);
      colo =  (int)(10. - cat1b * 8.);
      fcat1b->SetFillColor(colo);
      fcat1b->SetLineWidth(1);
      fcat1b->Draw("f");
      fcat1b->Draw();
    };
    //
    // CAT2  PMTs
    //
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat + xpmt2 + xc1[i];
	yc[i] = ycat + ypmt2 + yc1[i];
      };
      TPolyLine *fcat2 = new TPolyLine(5,xc,yc);
      fcat2->SetLineColor(1);
      colo =  (int)(10. - cat2 * 8.);
      fcat2->SetFillColor(colo);
      fcat2->SetLineWidth(1);
      fcat2->Draw("f");
      fcat2->Draw();
    };
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat + xpmt2 + xc1[i];
	yc[i] = ycat - ypmt2 - yc1[i];
      };
      TPolyLine *fcat2b = new TPolyLine(5,xc,yc);
      fcat2b->SetLineColor(1);
      colo = (int)(10. - cat2b * 8.);
      fcat2b->SetFillColor(colo);
      fcat2b->SetLineWidth(1);
      fcat2b->Draw("f");
      fcat2b->Draw();
    };
    //
    // CAT3  PMTs
    //
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat + xpmt1 + xc2[i];
	yc[i] = ycat - ypmt1 - yc2[i];
      };
      TPolyLine *fcat3b = new TPolyLine(5,xc,yc);
      fcat3b->SetLineColor(1);
      colo = (int)(10. - cat3b * 8.);
      fcat3b->SetFillColor(colo);
      fcat3b->SetLineWidth(1);
      fcat3b->Draw("f");
      fcat3b->Draw();
    };
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat - xpmt1 - xc2[i];
	yc[i] = ycat - ypmt1 - yc2[i];
      };
      TPolyLine *fcat3 = new TPolyLine(5,xc,yc);
      fcat3->SetLineColor(1);
      colo = (int)(10. - cat3 * 8.);
      fcat3->SetFillColor(colo);
      fcat3->SetLineWidth(1);
      fcat3->Draw("f");
      fcat3->Draw();
    };
    //
    // CAT4  PMTs
    //
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat + xpmt1 + xc2[i];
	yc[i] = ycat + ypmt1 + yc2[i];
      };
      TPolyLine *fcat4b = new TPolyLine(5,xc,yc);
      fcat4b->SetLineColor(1);
      colo = (int)(10. - cat4b * 8.);
      fcat4b->SetFillColor(colo);
      fcat4b->SetLineWidth(1);
      fcat4b->Draw("f");
      fcat4b->Draw();
    };
    if ( true ){
      for (Int_t i = 0; i<5 ; i++) {
	xc[i]= xcat - xpmt1 - xc2[i];
	yc[i] = ycat + ypmt1 + yc2[i];
      };
      TPolyLine *fcat4 = new TPolyLine(5,xc,yc);
      fcat4->SetLineColor(1);
      colo = (int)(10. - cat4 * 8.);
      fcat4->SetFillColor(colo);
      fcat4->SetLineWidth(1);
      fcat4->Draw("f");
      fcat4->Draw();
    };
  };
  if ( true ){
    //
    // CAS plane view:
    //
    Float_t xofs = -0.025;
    Float_t yofs = 0.039 +0.081+0.0273;
    Float_t csy = 0.33/2.;
    Float_t pmofs = 0.004;
    Float_t csw2 = 0.008;
    Float_t xc1[5] = { xofs-csy, xofs-csy, xofs+csy, xofs+csy, xofs-csy};
    Float_t yc1[5] = { yofs,     yofs+csw2, yofs+csw2, yofs,     yofs};

    Float_t xc2[5] = { xofs-csy-csw2, xofs-csy-csw2, xofs-csy, xofs-csy, xofs-csy-csw2};
    Float_t yc2[5] = { yofs+pmofs,     yofs+pmofs+csw2, yofs+pmofs+csw2, yofs+pmofs,     yofs+pmofs};
    Float_t xc3[5] = { xofs-csy-csw2, xofs-csy-csw2, xofs-csy, xofs-csy, xofs-csy-csw2};
    Float_t yc3[5] = { yofs+pmofs,     yofs+pmofs-csw2, yofs+pmofs-csw2, yofs+pmofs,     yofs+pmofs};

    //
    // CAS1 
    //
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc1[i]*var.sfx;
      yc[i] = ycat + yc1[i]*var.sfy;
    };
    TPolyLine *pcass1 = new TPolyLine(5,xc,yc);
    pcass1->SetLineColor(1);
    colo = 10;
    if ( cas1 != 0. || cas1b != 0. ) {
      if ( cas1 > 0 || cas1b > 0 || cas1 ==-.25  || cas1b ==-.25){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    if ( colo != 10 ) pcass1->SetFillStyle(3001);    
    pcass1->SetFillColor(colo);
    pcass1->SetLineWidth(1); 
    pcass1->SetLineStyle(2);
    pcass1->Draw("f");
    pcass1->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc2[i]*var.sfx;
      yc[i] = ycat + yc2[i]*var.sfy;
    };
    TPolyLine *pcasp1b = new TPolyLine(5,xc,yc);
    pcasp1b->SetLineColor(1);
    colo = (int)(10. - cas1b * 8.);
    if ( colo != 10 ) pcasp1b->SetFillStyle(3001);    
    pcasp1b->SetFillColor(colo);
    pcasp1b->SetLineWidth(1);
    pcasp1b->SetLineStyle(2);
    pcasp1b->Draw("f");
    pcasp1b->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc3[i]*var.sfx;
      yc[i] = ycat + yc3[i]*var.sfy;
    };
    TPolyLine *pcasp1 = new TPolyLine(5,xc,yc);
    pcasp1->SetLineColor(1);
    colo = (int)(10. - cas1 * 8.);
    if ( colo != 10 ) pcasp1->SetFillStyle(3001);    
    pcasp1->SetFillColor(colo);
    pcasp1->SetLineWidth(1);
    pcasp1->SetLineStyle(2);
    pcasp1->Draw("f");
    pcasp1->Draw();
    //
    // CAS2
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc1[i]*var.sfx;
      yc[i] = ycat - yc1[i]*var.sfy;
    };
    TPolyLine *pcass2 = new TPolyLine(5,xc,yc);
    pcass2->SetLineColor(1);
    colo = 10;
    if ( cas2 != 0. || cas2b != 0. ) {
      if ( cas2 > 0 || cas2b > 0 || cas2 ==-.25 || cas2b ==-.25 ){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    if ( colo != 10 ) pcass2->SetFillStyle(3001);    
    pcass2->SetFillColor(colo);
    pcass2->SetLineWidth(1); 
    pcass2->SetLineStyle(2);
    pcass2->Draw("f");
    pcass2->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc2[i]*var.sfx;
      yc[i] = ycat - yc2[i]*var.sfy;
    };
    TPolyLine *pcasp2b = new TPolyLine(5,xc,yc);
    pcasp2b->SetLineColor(1);
    colo = (int)(10. - cas2b * 8.);
    if ( colo != 10 ) pcasp2b->SetFillStyle(3001);    
    pcasp2b->SetFillColor(colo);
    pcasp2b->SetLineWidth(1);
    pcasp2b->SetLineStyle(2);
    pcasp2b->Draw("f");
    pcasp2b->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc3[i]*var.sfx;
      yc[i] = ycat - yc3[i]*var.sfy;
    };
    TPolyLine *pcasp2 = new TPolyLine(5,xc,yc);
    pcasp2->SetLineColor(1);
    colo = (int)(10. - cas2 * 8.);
    pcasp2->SetFillColor(colo);
    if ( colo != 10 ) pcasp2->SetFillStyle(3001);    
    pcasp2->SetLineWidth(1);
    pcasp2->SetLineStyle(2);
    pcasp2->Draw("f");
    pcasp2->Draw();

  };
  if ( true ){
    Float_t xofs = 0.048 +0.066+0.0273;
    Float_t yofs = 0.02;
    Float_t csy = 0.33/2.;
    Float_t pmofs = 0.004;
    Float_t csw2 = 0.008;
    Float_t xc1[5] = { xofs,     xofs+csw2, xofs+csw2, xofs,     xofs};
    Float_t yc1[5] = { yofs-csy, yofs-csy, yofs+csy, yofs+csy, yofs-csy};
    Float_t xc2[5] = { xofs+pmofs,     xofs+pmofs+csw2, xofs+pmofs+csw2, xofs+pmofs,     xofs+pmofs};
    Float_t yc2[5] = { yofs+csy+csw2, yofs+csy+csw2, yofs+csy, yofs+csy, yofs+csy+csw2};    
    Float_t xc3[5] = { xofs+pmofs,     xofs+pmofs-csw2, xofs+pmofs-csw2, xofs+pmofs,     xofs+pmofs};
    Float_t yc3[5] = { yofs+csy+csw2, yofs+csy+csw2, yofs+csy, yofs+csy, yofs+csy+csw2};
    //
    // CAS3
    //
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc1[i]*var.sfx;
      yc[i] = ycat + yc1[i]*var.sfy;
    };
    TPolyLine *pcass3 = new TPolyLine(5,xc,yc);
    pcass3->SetLineColor(1);
    colo = 10;
    if ( cas3 != 0. || cas3b != 0. ) {
      if ( cas3 > 0 || cas3b > 0 ||  cas3 ==-.25 || cas3b ==-.25){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    if ( colo != 10 ) pcass3->SetFillStyle(3001);    
    pcass3->SetFillColor(colo);
    pcass3->SetLineWidth(1); 
    pcass3->SetLineStyle(2);
    pcass3->Draw("f");
    pcass3->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc2[i]*var.sfx;
      yc[i] = ycat + yc2[i]*var.sfy;
    };
    TPolyLine *pcasp3b = new TPolyLine(5,xc,yc);
    pcasp3b->SetLineColor(1);
    colo = (int)(10. - cas3b * 8.);
    if ( colo != 10 ) pcasp3b->SetFillStyle(3001);    
    pcasp3b->SetFillColor(colo);
    pcasp3b->SetLineWidth(1);
    pcasp3b->SetLineStyle(2);
    pcasp3b->Draw("f");
    pcasp3b->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc3[i]*var.sfx;
      yc[i] = ycat + yc3[i]*var.sfy;
    };
    TPolyLine *pcasp3 = new TPolyLine(5,xc,yc);
    pcasp3->SetLineColor(1);
    colo = (int)(10. - cas3 * 8.);
    pcasp3->SetFillColor(colo); 
    if ( colo != 10 ) pcasp3->SetFillStyle(3001);    
    pcasp3->SetLineWidth(1);
    pcasp3->SetLineStyle(2);
    pcasp3->Draw("f");
    pcasp3->Draw();
    //
    // CAS4
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc1[i]*var.sfx;
      yc[i] = ycat - yc1[i]*var.sfy;
    };
    TPolyLine *pcass4 = new TPolyLine(5,xc,yc);
    pcass4->SetLineColor(1);
    colo = 10;
    if ( cas4 != 0. || cas4b != 0. ) {
      if ( cas4 > 0 || cas4b > 0 ||  cas4 ==-.25 || cas4b ==-.25 ){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    pcass4->SetFillColor(colo);
    if ( colo != 10 ) pcass4->SetFillStyle(3001);    
    pcass4->SetLineWidth(1); 
    pcass4->SetLineStyle(2);
    pcass4->Draw("f");
    pcass4->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc2[i]*var.sfx;
      yc[i] = ycat - yc2[i]*var.sfy;
    };
    TPolyLine *pcasp4 = new TPolyLine(5,xc,yc);
    pcasp4->SetLineColor(1);
    colo = (int)(10. - cas4 * 8.);
    pcasp4->SetFillColor(colo);
    if ( colo != 10 ) pcasp4->SetFillStyle(3001);    
    pcasp4->SetLineWidth(1);
    pcasp4->SetLineStyle(2);
    pcasp4->Draw("f");
    pcasp4->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc3[i]*var.sfx;
      yc[i] = ycat - yc3[i]*var.sfy;
    };
    TPolyLine *pcasp4b = new TPolyLine(5,xc,yc);
    pcasp4b->SetLineColor(1);
    colo = (int)(10. - cas4b * 8.);
    pcasp4b->SetFillColor(colo);
    if ( colo != 10 ) pcasp4b->SetFillStyle(3001);    
    pcasp4b->SetLineWidth(1);
    pcasp4b->SetLineStyle(2);
    pcasp4b->Draw("f");
    pcasp4b->Draw();
  };
  //  Float_t alfax = 1.2020334;
  Float_t alfax = 1.22157778;
  Float_t alfay = 1.27393111;
  Float_t lcrd = 0.1815/2.;
  Float_t wcrd = 0.008;
  if ( true ){
    //
    // CARD plane view:
    //
    Float_t xc1[5] = { -0.090165, -0.090165, -0.082165, -0.082165, -0.090165};
    Float_t yc1[5] = { -0.100, 0.092, 0.092, -0.100, -0.100};
    Float_t xc2[5] = { -0.094165, -0.094165, -0.086165, -0.086165, -0.094165};
    Float_t yc2[5] = { 0.092, 0.100, 0.100, 0.092, 0.092};
    Float_t xc3[5] = { -0.086165, -0.086165, -0.078165, -0.078165, -0.086165};
    Float_t yc3[5] = { 0.092, 0.100, 0.100, 0.092, 0.092};
    //
    // CARD1 
    //
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc1[i]*var.sfx;
      yc[i] = ycat + yc1[i]*var.sfy;
    };
    TPolyLine *pcars1 = new TPolyLine(5,xc,yc);
    pcars1->SetLineColor(1);
    colo = 10;
    if ( card1 != 0. || card1b != 0. ) {
      if ( card1 > 0 || card1b > 0 || card1 ==-.25  || card1b ==-.25 ){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    pcars1->SetFillColor(colo);
    pcars1->SetLineWidth(1);
    pcars1->Draw("f");
    pcars1->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + xc2[i]*var.sfx;
      yc[i] = ycat + yc2[i]*var.sfy;
    };
    TPolyLine *pcarp1b = new TPolyLine(5,xc,yc);
    pcarp1b->SetLineColor(1);
    colo = (int)(10. - card1b * 8.);
    pcarp1b->SetFillColor(colo);
    pcarp1b->SetLineWidth(1);
    pcarp1b->Draw("f");
    pcarp1b->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]		= xcat + xc3[i]*var.sfx;
      yc[i] 		= ycat + yc3[i]*var.sfy;
    };
    TPolyLine 	*pcarp1 = new TPolyLine(5,xc,yc);
    pcarp1->SetLineColor(1);
    colo 		= (int)(10. - card1 * 8.);
    pcarp1->SetFillColor(colo);
    pcarp1->SetLineWidth(1);
    pcarp1->Draw("f");
    pcarp1->Draw();
    //
    // CARD4
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc1[i]*var.sfx;
      yc[i] = ycat - yc1[i]*var.sfy;
    };
    TPolyLine *pcars4 = new TPolyLine(5,xc,yc);
    pcars4->SetLineColor(1);
    colo = 10;
    if ( card4 != 0. || card4b != 0. ) {
      if ( card4 > 0 || card4b > 0 ||  card4 ==-.25 || card4b ==-.25){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    pcars4->SetFillColor(colo);
    pcars4->SetLineWidth(1);
    pcars4->Draw("f");
    pcars4->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc2[i]*var.sfx;
      yc[i] = ycat - yc2[i]*var.sfy;
    };
    TPolyLine *pcarp4b = new TPolyLine(5,xc,yc);
    pcarp4b->SetLineColor(1);
    colo = (int)(10. - card4b * 8.);
    pcarp4b->SetFillColor(colo);
    pcarp4b->SetLineWidth(1);
    pcarp4b->Draw("f");
    pcarp4b->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - xc3[i]*var.sfx;
      yc[i] = ycat - yc3[i]*var.sfy;
    };
    TPolyLine *pcarp4 = new TPolyLine(5,xc,yc);
    pcarp4->SetLineColor(1);
    colo = (int)(10. - card4 * 8.);
    pcarp4->SetFillColor(colo);
    pcarp4->SetLineWidth(1);
    pcarp4->Draw("f");
    pcarp4->Draw();
  };
  if ( true ){
    Float_t xc1[5] = { -0.074, 0.074, 0.074, -0.074, -0.074};
    Float_t yc1[5] = {  0.108165, 0.108165, 0.100165, 0.100165, 0.108165};
    Float_t xc2[5] = { 0.074, 0.082, 0.082, 0.074, 0.074};
    Float_t yc2[5] = { 0.112165, 0.112165, 0.104165, 0.104165, 0.112165};
    Float_t xc3[5] = { 0.074, 0.082, 0.082, 0.074, 0.074};
    Float_t yc3[5] = { 0.104165, 0.104165, 0.096165, 0.096165, 0.104165};
    //
    // CARD2
    //
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - (xc1[i]-0.0025)*var.sfx;
      yc[i] = ycat - yc1[i]*var.sfy;
    };
    TPolyLine *pcars2 = new TPolyLine(5,xc,yc);
    pcars2->SetLineColor(1);
    colo = 10;
    if ( card2 != 0. || card2b != 0.) {
      if ( card2 > 0 || card2b > 0 ||  card2 ==-.25 || card2b ==-.25 ){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    pcars2->SetFillColor(colo);
    pcars2->SetLineWidth(1);
    pcars2->Draw("f");
    pcars2->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - (xc2[i]-0.0025)*var.sfx;
      yc[i] = ycat - yc2[i]*var.sfy;
    };
    TPolyLine *pcarp2 = new TPolyLine(5,xc,yc);
    pcarp2->SetLineColor(1);
    colo = (int)(10. - card2 * 8.);
    pcarp2->SetFillColor(colo);
    pcarp2->SetLineWidth(1);
    pcarp2->Draw("f");
    pcarp2->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat - (xc3[i]-0.0025)*var.sfx;
      yc[i] = ycat - yc3[i]*var.sfy;
    };
    TPolyLine *pcarp2b = new TPolyLine(5,xc,yc);
    pcarp2b->SetLineColor(1);
    colo = (int)(10. - card2b * 8.);
    pcarp2b->SetFillColor(colo);
    pcarp2b->SetLineWidth(1);
    pcarp2b->Draw("f");
    pcarp2b->Draw();
    //
    // CARD3
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + (xc1[i]-0.0025)*var.sfx;
      yc[i] = ycat + yc1[i]*var.sfy;
    };
    TPolyLine *pcars3 = new TPolyLine(5,xc,yc);
    pcars3->SetLineColor(1);
    colo = 10;
    if ( card3 != 0. || card3b != 0. ) {
      if ( card3 > 0 || card3b > 0 ||  card3==-.25 || card3b ==-.25){
	colo = cattime;
      } else {
	colo = catnoti;
      };
    }; 
    pcars3->SetFillColor(colo);
    pcars3->SetLineWidth(1);
    pcars3->Draw("f");
    pcars3->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + (xc2[i]-0.0025)*var.sfx;
      yc[i] = ycat + yc2[i]*var.sfy;
    };
    TPolyLine *pcarp3 = new TPolyLine(5,xc,yc);
    pcarp3->SetLineColor(1);
    colo = (int)(10. - card3 * 8.);
    pcarp3->SetFillColor(colo);
    pcarp3->SetLineWidth(1);
    pcarp3->Draw("f");
    pcarp3->Draw();
    //
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xcat + (xc3[i]-0.0025)*var.sfx;
      yc[i] = ycat + yc3[i]*var.sfy;
    };
    TPolyLine *pcarp3b = new TPolyLine(5,xc,yc);
    pcarp3b->SetLineColor(1);
    colo = (int)(10. - card3b * 8.);
    pcarp3b->SetFillColor(colo);
    pcarp3b->SetLineWidth(1);
    pcarp3b->Draw("f");
    pcarp3b->Draw();

    //
    // CARD - X-view
    //
    //    Float_t cardcx = 0.143168*var.sfx;
    //Float_t cardcy = 0.1475*var.sfy;
    //
    //    Float_t cardcx = 0.153168*var.sfx;
    //
    Float_t cardcx = (0.19123*(1.-lcrd*cos(alfax)))*var.sfx;
    //    Float_t cardcy = 0.1575*var.sfy;
    Float_t cardcy = (0.179212*(1.-lcrd*sin(alfax)))*var.sfy;
    Float_t acrdx[4] = {-lcrd*cos(alfax), lcrd*cos(alfax), -lcrd*cos(alfax)+wcrd*sin(alfax), -lcrd*cos(alfax)};
    Float_t acrdy[4] = {-lcrd*sin(alfax), lcrd*sin(alfax), -lcrd*sin(alfax)-wcrd*cos(alfax), -lcrd*sin(alfax)};
    Float_t bcrdx[4] = { lcrd*cos(alfax), lcrd*cos(alfax)+wcrd*sin(alfax), -lcrd*cos(alfax)+wcrd*sin(alfax), lcrd*cos(alfax)};
    Float_t bcrdy[4] = { lcrd*sin(alfax), lcrd*sin(alfax)-wcrd*cos(alfax), -lcrd*sin(alfax)-wcrd*cos(alfax), lcrd*sin(alfax)};

    //
    // CARD3  X/  Y
    //
    Float_t xcc[4];     
    Float_t ycc[4];
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = cardcx + var.xxvc + acrdx[i]*var.sfx;
      ycc[i] = cardcy + var.yxvc + (0.36 + acrdy[i])*var.sfy;
    };
    TPolyLine *fcard3 = new TPolyLine(4,xcc,ycc);
    fcard3->SetLineColor(1);
    colo = (int)(10. - card3 * 8.);
    fcard3->SetFillColor(colo);
    fcard3->SetLineWidth(1);
    fcard3->Draw("f");
    fcard3->Draw();
    //
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = cardcx + var.xxvc + bcrdx[i]*var.sfx;
      ycc[i] = cardcy + var.yxvc + (0.36 + bcrdy[i])*var.sfy;
    };
    TPolyLine *fcard3b = new TPolyLine(4,xcc,ycc);
    fcard3b->SetLineColor(1);
    colo = (int)(10. - card3b * 8.);
    fcard3b->SetFillColor(colo);
    fcard3b->SetLineWidth(1);
    fcard3b->Draw("f");
    fcard3b->Draw();

    //
    // CARD2  \X  Y
    //
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = -cardcx + var.xxvc - acrdx[i]*var.sfx;
      ycc[i] = cardcy + var.yxvc + (0.36 + acrdy[i])*var.sfy;
    };
    TPolyLine *fcard2 = new TPolyLine(4,xcc,ycc);
    fcard2->SetLineColor(1);
    colo = (int)(10. - card2 * 8.);
    fcard2->SetFillColor(colo);
    fcard2->SetLineWidth(1);
    fcard2->Draw("f");
    fcard2->Draw();
    //
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = -cardcx  + var.xxvc - bcrdx[i]*var.sfx;
      ycc[i] = cardcy  + var.yxvc + (0.36 + bcrdy[i])*var.sfy;
    };
    TPolyLine *fcard2b = new TPolyLine(4,xcc,ycc);
    fcard2b->SetLineColor(1);
    colo = (int)(10. - card2b * 8.);
    fcard2b->SetFillColor(colo);
    fcard2b->SetLineWidth(1);
    fcard2b->Draw("f");
    fcard2b->Draw();
  };

  if ( true ){
    Float_t acrdx[4] = {-lcrd*cos(alfay), lcrd*cos(alfay), -lcrd*cos(alfay)+wcrd*sin(alfay), -lcrd*cos(alfay)};
    Float_t acrdy[4] = {-lcrd*sin(alfay), lcrd*sin(alfay), -lcrd*sin(alfay)-wcrd*cos(alfay), -lcrd*sin(alfay)};
    Float_t bcrdx[4] = { lcrd*cos(alfay), lcrd*cos(alfay)+wcrd*sin(alfay), -lcrd*cos(alfay)+wcrd*sin(alfay), lcrd*cos(alfay)};
    Float_t bcrdy[4] = { lcrd*sin(alfay), lcrd*sin(alfay)-wcrd*cos(alfay), -lcrd*sin(alfay)-wcrd*cos(alfay), lcrd*sin(alfay)};
    //
    // CARD - Y-view
    //
    //    Float_t cardcx = 0.12*var.sfx;
    Float_t cardcx = (0.16014*(1.-lcrd*cos(alfay)))*var.sfx;
    //    Float_t cardcy = 0.178818*var.sfy;
    Float_t cardcy = (0.178818*(1.-lcrd*sin(alfay)))*var.sfy;
    //    Float_t cardcy = 0.1475*var.sfy;
    //
    // CARD4  X  Y/
    //
    Float_t xcc[4];     
    Float_t ycc[4];
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = cardcx + var.xyvc + acrdx[i]*var.sfx;
      ycc[i] = cardcy + var.yyvc + (0.36 + acrdy[i])*var.sfy;
    };
    TPolyLine *fcard4 = new TPolyLine(4,xcc,ycc);
    fcard4->SetLineColor(1);
    colo = (int)(10. - card4 * 8.);
    fcard4->SetFillColor(colo);
    fcard4->SetLineWidth(1);
    fcard4->Draw("f");
    fcard4->Draw();
    //
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = cardcx + var.xyvc + bcrdx[i]*var.sfx;
      ycc[i] = cardcy + var.yyvc + (0.36 + bcrdy[i])*var.sfy;
    };
    TPolyLine *fcard4b = new TPolyLine(4,xcc,ycc);
    fcard4b->SetLineColor(1);
    colo = (int)(10. - card4b * 8.);
    fcard4b->SetFillColor(colo);
    fcard4b->SetLineWidth(1);
    fcard4b->Draw("f");
    fcard4b->Draw();

    //
    // CARD1  X  \Y
    //
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = -cardcx + var.xyvc - acrdx[i]*var.sfx;
      ycc[i] = cardcy  + var.yyvc + (0.36 + acrdy[i])*var.sfy;
    };
    TPolyLine *fcard1 = new TPolyLine(4,xcc,ycc);
    fcard1->SetLineColor(1);
    colo = (int)(10. - card1 * 8.);
    fcard1->SetFillColor(colo);
    fcard1->SetLineWidth(1);
    fcard1->Draw("f");
    fcard1->Draw();
    //
    for (Int_t i = 0; i<4 ; i++) {
      xcc[i] = -cardcx + var.xyvc - bcrdx[i]*var.sfx;
      ycc[i] = cardcy + var.yyvc + (0.36 + bcrdy[i])*var.sfy;
    };
    TPolyLine *fcard1b = new TPolyLine(4,xcc,ycc);
    fcard1b->SetLineColor(1);
    colo = (int)(10. - card1b * 8.);
    fcard1b->SetFillColor(colo);
    fcard1b->SetLineWidth(1);
    fcard1b->Draw("f");
    fcard1b->Draw();
  };
}

void FEVdetector::ShowS4(Bool_t upd){
  //
  //
  //
  if ( !var.S4 ) return;
  //
  Float_t calibdata;
  Int_t data = 0;
  Float_t ms4[3] = {0.,0.,0.};
  Int_t S4 = 0;
  //
  //  Level0 data
  //
  if ( level.file == 0 ){
    S4 = trigger->patterntrig[1];
    //
    for ( Int_t i = 0; i<3; i++ ) {
      if ( S4 & (1<<0) ) ms4[i] = 1.;
    };
  };
  //
  // Rough calibration of data
  //
  if ( level.file == -1 ){
    if ( !s4->unpackError && data > 31 ){
      data = s4->S4_DATA;
      calibdata = ((Float_t)data - 32.) * 0.5;
    } else {
      calibdata = 0.;
    };
    //
    for ( Int_t j = 0; j<3; j++ ) {	    
      ms4[j] = calibdata;
    };    
  };
  //
  // Level2 data
  //
  if ( level.file == 2 ){
    for ( Int_t j = 0; j<3; j++ ) {	    
      if ( L2->GetS4Level2()->S4adc != 32. ) ms4[j] = L2->GetS4Level2()->S4calibrated;
    };        
  };
  //    
  var.s4sig = ms4[0];
  //
  if ( !upd ) return;
  //
  Int_t colo;
  Float_t xs4x = var.xxvc;
  Float_t ys4x = var.yxvc - 0.3250*var.sfy; 
  Float_t xs4y = var.xyvc;
  Float_t ys4y = var.yyvc - 0.3250*var.sfy;
  Float_t ws4 = 0.010;
  //
  // Y-view
  //
  Float_t s4p = 0.1606667;
  Int_t ocolo = 0;
  TPolyLine *fs4y[3];
  for ( Int_t j=0; j<3; j++){
    Float_t xc1[5]={ (s4p*j),       s4p*(j+1),               s4p*(j+1),     (s4p*j),    (s4p*j)};
    Float_t yc1[5]={ 0.,         0.,               ws4,     ws4,    0.};
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= xs4y + (-0.241+xc1[i])*var.nds4;
      yc[i] = ys4y + (yc1[i]-0.03)*var.sfy;
    };
    fs4y[j] = new TPolyLine(5,xc,yc);
    fs4y[j]->SetLineColor(1);
    if ( var.bw ){
      colo = -1;
    } else {
      colo = 1;
    };
    ColorMIP(ms4[j],colo);
    //
    if ( colo != 10 ) ocolo = colo;
    //
    fs4y[j]->SetFillColor(colo);
    fs4y[j]->SetLineWidth(1);
    fs4y[j]->Draw("f");
    fs4y[j]->Draw();
  };
  //
  // X-view
  //
  Float_t xc1[5]={ -0.241,       0.241,               0.241,     -0.241,    -0.241};
  Float_t yc1[5]={ 0.,         0.,                ws4,    ws4,    0.};
  Float_t xc[5];     
  Float_t yc[5];
  for (Int_t i = 0; i<5 ; i++) {
    xc[i]= xs4x + xc1[i]*var.nds4;
    yc[i] = ys4x + (yc1[i]-0.03)*var.sfy;
  };
  TPolyLine *fs4x = new TPolyLine(5,xc,yc);
  fs4x->SetLineColor(1);
  fs4x->SetFillColor(ocolo);
  fs4x->SetLineWidth(1);
  fs4x->Draw("f");
  fs4x->Draw();
}

void FEVdetector::ShowND(){
  //
  //
  //
  if ( !var.ND ) return;
  //
  Int_t tmpSize;    
  Int_t yUpperTrig = 0;
  Int_t yUpperBk = 0;
  Int_t yBottomBk = 0;
  if ( level.file == 0 || level.file == -1 ){
    //
    tmpSize = ne->Records->GetEntries();
    for (Int_t j = 0; j < tmpSize; j++){
      nr = (pamela::neutron::NeutronRecord*)ne->Records->At(j);	
      yUpperTrig        += (int)nr->trigPhysics;
      yUpperBk          += (int)nr->upperBack;
      yBottomBk         += (int)nr->bottomBack;
    };
  };
  if ( level.file == 2 ){
    yUpperTrig = (Int_t)L2->GetNDLevel2()->trigPhysics;
    yUpperBk = (Int_t)L2->GetNDLevel2()->upperBack;
    yBottomBk = (Int_t)L2->GetNDLevel2()->bottomBack;
  };
  //
  var.trup = yUpperTrig;
  var.bkup = yUpperBk;
  var.bkbo = yBottomBk;  
  //
  Int_t ucolo = 10;
  if  ( var.bw ){
    if ( yUpperTrig == 1 ){	    
      ucolo = 17;
    }
    if ( yUpperTrig == 2 ){
      ucolo = 15;
    }
    if ( yUpperTrig > 2 && yUpperTrig < 7 ){
      ucolo = 14;
    }
    if ( yUpperTrig > 6 && yUpperTrig < 15 ){
      ucolo = 13;
    }
    if ( yUpperTrig >= 14 ){
      ucolo = 12;
    };
  } else {
    if ( yUpperTrig == 1 ){	    
      ucolo = 38;
    }
    if ( yUpperTrig == 2 ){
      ucolo = 4;
    }
    if ( yUpperTrig > 2 && yUpperTrig < 7 ){
      ucolo = 3;
    }
    if ( yUpperTrig > 6 && yUpperTrig < 15 ){
      ucolo = 2;
    }
    if ( yUpperTrig >= 14 ){
      ucolo = 6;
    };
  };
  //
  // figures:
  //
  if ( true ){
    Float_t xc1[5]={ -0.300, 0.300, 0.300, -0.300, -0.300 };
    Float_t yc1[5]={ -0.47-0.04,  -0.47-0.04, -0.47+2.*0.075-0.04, -0.47+2.*0.075-0.04, -0.47-0.04};
    //
    // Upper X-view
    //
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= var.xxvc + xc1[i]*var.nds4;
      yc[i] = var.yxvc + yc1[i]*var.sfy;
    };
    TPolyLine *fnd2x = new TPolyLine(5,xc,yc);
    fnd2x->SetLineColor(1);
    fnd2x->SetFillColor(ucolo);
    fnd2x->SetLineWidth(1);
    fnd2x->Draw("f");
    fnd2x->Draw();
  };
  if ( true ){  
    Float_t xc1[5]={ -0.275, 0.275, 0.275, -0.275, -0.275 };
    Float_t yc1[5]={ -0.47-0.04-0.075,  -0.47-0.04-0.075, -0.47+0.075-0.04, -0.47+0.075-0.04, -0.47-0.04-0.075};
    //
    // Upper Y-view
    //
    Float_t xc[5];     
    Float_t yc[5];
    for (Int_t i = 0; i<5 ; i++) {
      xc[i]= var.xyvc + xc1[i]*var.nds4;
      yc[i] = var.yyvc + (yc1[i]+0.075)*var.sfy;
    };
    TPolyLine *fnd2y = new TPolyLine(5,xc,yc);
    fnd2y->SetLineColor(1);
    fnd2y->SetFillColor(ucolo);
    fnd2y->SetLineWidth(1);
    fnd2y->Draw("f");
    fnd2y->Draw();
  };
}


void FEVdetector::ShowTRK(Bool_t upd){
  //
  //
  //
  if ( !var.TRK ) return;
  //
  //  a matrix of pads for each view x and y
  //
  var.rig = 0.;
  var.chi2 = 0.;
  TPad *trkpad[12];
  for (Int_t n = 0; n<12; n++){
    stringstream spd;
    spd.str("");
    spd << "pd1" << n;
    gDirectory->Delete(spd.str().c_str());
    spd.str("");
    spd << "pd2" << n;
    gDirectory->Delete(spd.str().c_str());
    spd.str("");
    spd << "pd3" << n;
    gDirectory->Delete(spd.str().c_str());
    spd.str("");
    spd << "pd4" << n;
    gDirectory->Delete(spd.str().c_str());
    spd.str("");
    spd << "pd5" << n;
    gDirectory->Delete(spd.str().c_str());
    spd.str("");
    spd << "pd6" << n;
    gDirectory->Delete(spd.str().c_str());
    spd.str("");
    stringstream sbd;
    sbd.str("");
    Int_t magcol = 0;
    TPad *mag1 = 0;
    TPad *mag2 = 0;
    if ( n%2 ) {
      Float_t posx = var.xxvc;
      Float_t posy = var.yxvc + (0.29 - 0.089*((n/2.)-1.))*var.sfy;
      spd.str("");
      sbd.str("");
      spd << "pd1" << n;
      sbd << "bd1" << n;
      trkpad[n] = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-0.081*var.sfx,posy,posx+0.081*var.sfx,posy+0.089*var.sfy,10);
      trkpad[n]->SetFillStyle(4000);
      trkpad[n]->SetFillColor(0);
      trkpad[n]->SetFrameFillStyle(4000);	    
      if ( upd ) trkpad[n]->Draw();
      if ( n != 1 ) {
	if ( var.bw ) {
	  magcol = 1;
	} else {
	  magcol = 45;
	};
	spd.str("");
	sbd.str("");
	spd << "pd2" << n;
	sbd << "bd2" << n;
	mag1 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-(0.039+0.081)*var.sfx,posy+0.004*var.sfy,posx-0.081*var.sfx,posy+0.088*var.sfy,magcol);
	if ( var.bw ) mag1->SetFillStyle(3001);
	if ( upd ) mag1->Draw();
	spd.str("");
	sbd.str("");
	spd << "pd3" << n;
	sbd << "bd3" << n;
	mag2 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx+0.081*var.sfx,posy+0.004*var.sfy,posx+(0.081+0.039)*var.sfx,posy+0.088*var.sfy,magcol);
	if ( var.bw ) mag2->SetFillStyle(3001);
	if ( upd ) mag2->Draw();
      };
    } else {
      Float_t posx = var.xyvc;
      Float_t posy = var.yyvc + (0.29 - 0.089 * (((n+1.)/2.)-1.))*var.sfy;
      spd.str("");
      sbd.str("");
      spd << "pd4" << n;
      sbd << "bd4" << n;
      trkpad[n] = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-0.07*var.sfx,posy,posx+0.07*var.sfx,posy+0.089*var.sfy,10);
      trkpad[n]->SetFillStyle(4000);
      trkpad[n]->SetFillColor(0);
      trkpad[n]->SetFrameFillStyle(4000);
      if ( upd ) trkpad[n]->Draw();
      if ( n != 0 ) {
	if ( var.bw ) {
	  magcol = 1;
	} else {
	  magcol = 45;
	};
	spd.str("");
	sbd.str("");
	spd << "pd5" << n;
	sbd << "bd5" << n;
	mag1 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx-(0.048+0.066)*var.sfx,posy+0.004*var.sfy,posx-0.066*var.sfx,posy+0.088*var.sfy,magcol);
	if ( var.bw ) mag1->SetFillStyle(3001);
	if ( upd ) mag1->Draw();
	spd.str("");
	sbd.str("");
	spd << "pd6" << n;
	sbd << "bd6" << n;
	mag2 = new TPad(spd.str().c_str(),sbd.str().c_str(),posx+0.066*var.sfx,posy+0.004*var.sfy,posx+(0.066+0.048)*var.sfx,posy+0.088*var.sfy,magcol);
	if ( var.bw ) mag2->SetFillStyle(3001);
	if ( upd ) mag2->Draw();
      };
    };
  };
  TPad *trplv;
  gDirectory->Delete("trkplv");
  trplv = new TPad("trkplv","trkplv",var.xcat-0.066*var.sfx,var.ycat-0.081*var.sfy,var.xcat+0.066*var.sfx,var.ycat+0.081*var.sfy,10);
  trplv->SetFillStyle(4000);
  trplv->SetFillColor(0);
  trplv->SetFrameFillStyle(4000);
  if ( upd ) trplv->Draw();
  //
  Int_t sigcol1 = 17;
  Int_t sigcol2 = 15;
  Int_t linecol = 13;
  if ( var.bw ) {
    sigcol1 = 17;
    sigcol2 = 15;
    linecol = 13;
  } else {
    sigcol1 = 32;
    sigcol2 = 38;
    linecol = 42;
  };
  TLine *linea = 0;
  TLine *linea1x = 0;
  TLine *linea2x = 0;
  TLine *linea1y = 0;
  Float_t x = 0.;
  for (Int_t l = 0; l<12; l++){	
    trkpad[l]->cd();
    if ( l%2 ) { 
      if ( level.file == 2 ){
	trkpad[l]->Range(-8.1,0.,8.1,8.);
	linea = new TLine(-8.1,0.01,8.1,0.01);
	linea1x = new TLine(-2.7,0.01,-2.7,0.030);	    
	linea2x = new TLine(2.7,0.01,2.7,0.030);	    
      } else {
	trkpad[l]->Range(0.,0.,3100.,1.);
	linea = new TLine(0.,0.01,3100.,0.01);
	linea1x = new TLine(1033.,0.01,1033,0.030);	    
	linea2x = new TLine(2066.,0.01,2066,0.030);	    
      };
    } else {
      if ( level.file == 2 ){
	trkpad[l]->Range(-7.05,0.,7.05,8.);
	linea = new TLine(-7.05,0.01,7.05,0.01);
	linea1y = new TLine(0.,0.01,0.,0.030);	    
      } else {
	trkpad[l]->Range(0.,0.,2076.,1.);
	linea = new TLine(0.,0.01,2076.,0.01);
	linea1y = new TLine(1038.,0.01,1038,0.030);	    
      };
    };
    linea->SetLineWidth(2);
    linea->SetLineColor(linecol);
    if ( upd ) linea->Draw();
    if ( l%2 ) { 
      linea1x->SetLineWidth(1);
      linea1x->SetLineColor(1);
      if ( upd ) linea1x->Draw();
      linea2x->SetLineWidth(1);
      linea2x->SetLineColor(1);
      if ( upd ) linea2x->Draw();
    } else {
      linea1y->SetLineWidth(1);
      linea1y->SetLineColor(1);
      if ( upd ) linea1y->Draw();
    };
    //
    // LEVEL0 or LEVEL-1
    //
    if ( level.file == 0 || level.file == -1 ){
      Int_t planeno = trk->DSPnumber[l]-1;	
      if ( planeno < 0 || planeno > 11 ) planeno = 0;
      if ( planeno >= 0 && !var.nosig ) {
	if ( (planeno+1)%2 ){
	  trkpad[planeno]->cd();
	  trkpad[planeno]->Range(0.,0.,2076.,1.);
	  for (Int_t m = 0; m<3; m++){
	    if ( trk->signcluster[l][m] != 0. ){
	      if ( planeno == 10 ) {
		x = trk->addrcluster[l][m];
	      } else {
		x = 1024 - trk->addrcluster[l][m];
	      };
	      linea = new TLine(14.+x,0.01,14.+x,0.3);
	      linea->SetLineWidth(2);
	      linea->SetLineColor(sigcol1); 
	      if ( upd ) linea->Draw();			
	      x += 1024.;			
	      linea = new TLine(14.+x,0.01,14.+x,0.3);
	      linea->SetLineWidth(2);
	      linea->SetLineColor(sigcol2);
	      if ( upd ) linea->Draw();
	      var.ncly++;
	    };
	  };
	} else {
	  trkpad[planeno]->cd();
	  trkpad[planeno]->Range(0.,0.,3100.,1.);
	  for (Int_t m = 0; m<3; m++){
	    if ( trk->signcluster[l][m] != 0. ){
	      x = trk->addrcluster[l][m] + 1024. * m;
	      linea = new TLine(14.+x,0.01,14.+x,0.3);
	      linea->SetLineWidth(2);
	      linea->SetLineColor(sigcol2);
	      if ( upd ) linea->Draw();
	      var.nclx++;
	    };
	  };
	};
      };    
    };
    //
    if ( !upd ) return;
    //
    if ( level.file == 2 ){
      //
      // singlets X
      //
      for (Int_t sing = 0; sing < L2->GetTrkLevel2()->nclsx(); sing++){
	TClonesArray &t = *(L2->GetTrkLevel2()->SingletX);
	TrkSinglet *singlet = (TrkSinglet*)t[sing];
	x = (singlet->coord[0]+singlet->coord[1])/2.;			
	//
	Float_t xsig = singlet->sgnl;
	if ( xsig > 8. ) xsig = 8.;
	//
	Int_t planepad = (singlet->plane * 2) - 1;
	trkpad[planepad]->cd();
	trkpad[planepad]->Range(-8.1,0.,8.1,8.);
	if ( var.bw ){
	  sigcol2 = -1;
	} else {
	  sigcol2 = 1;
	};
	ColorTRKMIP(singlet->sgnl,sigcol2,0);
	linea = new TLine(x,0.01,x,xsig);
	linea->SetLineWidth(2);
	linea->SetLineColor(sigcol2);
	linea->Draw();
      };
      //
      // singlets Y
      //
      for (Int_t sing = 0; sing < L2->GetTrkLevel2()->nclsy(); sing++){
	TClonesArray &t = *(L2->GetTrkLevel2()->SingletY);
	TrkSinglet *singlet = (TrkSinglet*)t[sing];
	//
	Int_t planepad = (singlet->plane - 1)* 2;
	trkpad[planepad]->cd();
	trkpad[planepad]->Range(-7.05,0.,7.05,8.);
	for (Int_t img=0; img<2; img++){
	  x = -singlet->coord[img];
	  Float_t xsig = singlet->sgnl;
	  if ( xsig > 8. ) xsig = 8.;
	  //
	  if ( var.bw ){
	    sigcol2 = -1;
	  } else {
	    sigcol2 = 1;
	  };
	  Int_t coloimg = img;
	  //
	  // last Y plane is reversed!
	  //
	  if ( planepad == 10 ){
	    if ( img ){
	      coloimg = 0;
	    } else {
	      coloimg = 1;
	    };
	  };
	  ColorTRKMIP(singlet->sgnl,sigcol2,coloimg);
	  linea = new TLine(x,0.01,x,xsig);
	  linea->SetLineWidth(2);
	  linea->SetLineColor(sigcol2);
	  linea->Draw();
	};
      };
      //
      // Measured point relative to tracks and tracks
      // + dots on measured points
      //
      Int_t dcol;
      if ( var.bw ){
	dcol = 12;
      } else {
	dcol = 2;
      };
      //
      if ( L2->GetTrkLevel2()->GetNTracks() > 0 ){
	for (Int_t nt = 0; nt < L2->GetTrkLevel2()->GetNTracks(); nt++){
	  PamTrack *ptrack= L2->GetTrack(nt);
	  TrkTrack *track = ptrack->GetTrkTrack();  
	  if ( nt == 0 ){
	    var.rig = 0.;
	    if ( track->al[4] != 0. ) var.rig = 1./track->al[4];
	    var.chi2 = track->chi2;
	  };
	  for (Int_t plane = 0; plane<6; plane++){
	    //
	    // X view
	    //
	    Int_t planepad = (plane * 2) + 1;
	    trkpad[planepad]->cd();
	    trkpad[planepad]->Range(-8.1,0.,8.1,8.);
	    //
	    x = track->xm[plane];
	    Float_t xsig = fabs(track->dedx_x[plane]);
	    if ( track->XGood(plane) ){
	      //if ( x > -100 ){
	      if ( xsig > 8. ) xsig = 8.;
	      if ( var.bw ){
		sigcol2 = -1;
	      } else {
		sigcol2 = 1;
	      };
	      ColorTRKMIP(fabs(track->dedx_x[plane]),sigcol2,0);
	      linea = new TLine(x,0.01,x,xsig);
	      linea->SetLineWidth(2);
	      linea->SetLineColor(sigcol2);
	      linea->Draw();
	      Float_t tx[5] = {(float)(x-0.3), (float)(x+0.3), (float)(x+0.3), (float)(x-0.3), (float)(x-0.3)};
	      Float_t tz[5] = {0., 0., 0.5, 0.5, 0.};
	      TPolyLine *tlinea = new TPolyLine(5,tx,tz);
	      tlinea->SetLineWidth(1);
	      tlinea->SetLineColor(dcol);
	      tlinea->SetFillColor(dcol);
	      tlinea->Draw("f");
	      tlinea->Draw();
	    };
	    //
	    // Y view
	    //
	    planepad = plane * 2;
	    trkpad[planepad]->cd();
	    trkpad[planepad]->Range(-7.05,0.,7.05,8.);
	    x = -track->ym[plane];
	    xsig = fabs(track->dedx_y[plane]);
	    if ( track->YGood(plane) ){
	      //	    if ( x > -100 ){
	      if ( xsig > 8. ) xsig = 8.;
	      if ( var.bw ){
		sigcol2 = -1;
	      } else {
		sigcol2 = 1;
	      };
	      ColorTRKMIP(fabs(track->dedx_y[plane]),sigcol2,0);
	      linea = new TLine(x,0.01,x,xsig);
	      linea->SetLineWidth(2);
	      linea->SetLineColor(sigcol2);
	      linea->Draw();
	      Float_t tx[5] = {(float)(x-0.3), (float)(x+0.3), (float)(x+0.3), (float)(x-0.3), (float)(x-0.3)};
	      Float_t tz[5] = {0., 0., 0.5, 0.5, 0.};
	      TPolyLine *tlinea = new TPolyLine(5,tx,tz);
	      tlinea->SetLineColor(dcol);
	      tlinea->SetFillColor(dcol);
	      tlinea->SetLineWidth(1);
	      tlinea->Draw("f");
	      tlinea->Draw();
	    };
	  };
	};// loop on tracks
      };
    };
    //
  };
  //
  // Show track in the plane view!
  //
  if ( var.AC ){
    Float_t xh[6];
    Float_t yh1[6];
    Float_t yh2[6];    
    Float_t mag[6];
    for (Int_t l = 0; l<6; l++ ){
      xh[l] = 0.;
      yh1[l] = 0.;
      yh2[l] = 0.;
      mag[l] = 0.;
    };
    Int_t ncro = 0;
    //
    // LEVEL2
    //
    if ( level.file == 2 ){
      //
      // first of all plot crosses relatives to tracks
      //
      if ( L2->GetTrkLevel2()->GetNTracks() > 0 ){
// 	for (Int_t nt = 0; nt < L2->GetTrkLevel2()->GetNTracks(); nt++){
// 	  TrkTrack *track = L2->GetTrkLevel2()->GetTrack(nt);  
	for (Int_t nt = 0; nt < L2->GetTrkLevel2()->GetNTracks(); nt++){
	  PamTrack *ptrack= L2->GetTrack(nt);
	  TrkTrack *track = ptrack->GetTrkTrack();  
	  //
	  for (Int_t plane = 0; plane<6; plane++){
	    //
	    x = track->xm[plane];
	    Float_t y = -track->ym[plane];
	    Float_t xsig = fabs(track->dedx_x[plane]);
	    Float_t ysig = fabs(track->dedx_y[plane]);
	    //	  if ( x > -100 && y > -100. ){
	    if ( track->XGood(plane) && track->YGood(plane) ){
	      if ( var.bw ){
		sigcol1 = -1;
		sigcol2 = -1;
	      } else {
		sigcol1 = 1;
		sigcol2 = 1;
	      };
	      ColorTRKMIP(xsig,sigcol1,0);
	      ColorTRKMIP(ysig,sigcol2,0);
	      //
	      // Draw crosses
	      //
	      trplv->cd();
	      trplv->Range(-7.05,-8.1,7.05,8.1);
	      //
	      Float_t mg = ((float)plane+1.)/5.;
	      Float_t cdx = (0.55/mg)*var.sfx;
	      Float_t cdy = (0.55/mg)*var.sfy;
	      Float_t lwx = (0.019)*var.sfy;
	      Float_t lwy = (0.019)*var.sfx;
	      //
	      linea = new TLine(y-lwx/2.,x-cdy,y-lwx/2.,x+cdy);
	      linea->SetLineWidth(1);
	      linea->SetLineColor(sigcol1);
	      linea->Draw();
	      linea = new TLine(y-cdx,x-lwy/2.,y+cdx,x-lwy/2.);
	      linea->SetLineWidth(1);
	      linea->SetLineColor(sigcol2);
	      linea->Draw();
	      //
	    };
	  };
	};
      };
      //
      // try to plot crosses relative to singlets
      //
      if ( L2->GetTrkLevel2()->nclsx() > 0 && L2->GetTrkLevel2()->nclsy() > 0 ){
	for (Int_t plane = 1; plane<7; plane++){
	  //
	  // count how many singlet in the x and y view for this plane:
	  //
	  Int_t totsx = 0;
	  Int_t totsy = 0;
	  TArrayI *orderx = new TArrayI(5000);
	  TArrayI *ordery = new TArrayI(5000);
	  TArrayF *arrax = new TArrayF(5000);
	  TArrayF *array1 = new TArrayF(5000);
	  TArrayF *array2 = new TArrayF(5000);
	  TArrayF *sigarrax = new TArrayF(5000);
	  TArrayF *sigarray = new TArrayF(5000);
	  for (Int_t sing = 0; sing < L2->GetTrkLevel2()->nclsx(); sing++){
	    TClonesArray &t = *(L2->GetTrkLevel2()->SingletX);
	    TrkSinglet *singlet = (TrkSinglet*)t[sing];
	    if ( singlet->plane == plane ){
	      arrax->AddAt(((singlet->coord[0]+singlet->coord[1])/2.),totsx);
	      sigarrax->AddAt(singlet->sgnl,totsx);
	      if ( totsx == 0 || ( totsx > 0 && singlet->sgnl < sigarrax->At(orderx->At(totsx-1))) ){
		orderx->AddAt(totsx,totsx);
	      } else {
		for (Int_t ord = totsx-1; ord >= 0; ord--){		
		  if ( singlet->sgnl < sigarrax->At(orderx->At(ord)) || ord == 0){
		    if ( singlet->sgnl < sigarrax->At(orderx->At(ord)) ){
		      for (Int_t reord = totsx; reord>(ord+1); reord--){		      
			orderx->AddAt(orderx->At(reord-1),reord);		      
		      };
		      orderx->AddAt(totsx,ord+1);
		      break;
		    } else {
		      for (Int_t reord = totsx; reord>0; reord--){		      
			orderx->AddAt(orderx->At(reord-1),reord);		      
		      };
		      orderx->AddAt(totsx,0);
		      break;
		    };
		  };
		};
	      };
	      totsx++;	     
	    };
	  };
	  for (Int_t sing = 0; sing < L2->GetTrkLevel2()->nclsy(); sing++){
	    TClonesArray &t = *(L2->GetTrkLevel2()->SingletY);
	    TrkSinglet *singlet = (TrkSinglet*)t[sing];
	    if ( singlet->plane == plane ){
	      array1->AddAt(singlet->coord[0],totsy);
	      array2->AddAt(singlet->coord[1],totsy);
	      sigarray->AddAt(singlet->sgnl,totsy);
	      if ( totsy == 0 || ( totsy > 0 && singlet->sgnl < sigarray->At(ordery->At(totsy-1))) ){
		ordery->AddAt(totsy,totsy);
	      } else {
		for (Int_t ord = totsy-1; ord >= 0; ord--){		
		  if ( singlet->sgnl < sigarray->At(ordery->At(ord)) || ord == 0){
		    if ( singlet->sgnl < sigarray->At(ordery->At(ord)) ){
		      for (Int_t reord = totsy; reord>(ord+1); reord--){		      
			ordery->AddAt(ordery->At(reord-1),reord);		      
		      };
		      ordery->AddAt(totsy,ord+1);
		      break;
		    } else {
		      for (Int_t reord = totsy; reord>0; reord--){		      
			ordery->AddAt(ordery->At(reord-1),reord);		      
		      };
		      ordery->AddAt(totsy,0);
		      break;
		    };
		  };
		};
	      };
	      totsy++;	     
	    };
	  };
	  //
 	  if ( totsx && totsy ){
 	    for (Int_t sing = 0; sing < min(totsx,totsy); sing++){
	      //	      
	      x = arrax->At(orderx->At(sing));
	      Float_t y1 = -array1->At(ordery->At(sing));
	      Float_t y2 = -array2->At(ordery->At(sing));
	      Float_t xsig = sigarrax->At(orderx->At(sing)); 
	      Float_t ysig = sigarray->At(ordery->At(sing));
	      if ( x > -100 && y1 > -100. ){
		if ( var.bw ){
		  sigcol1 = -1;
		  sigcol2 = -1;
		} else {
		  sigcol1 = 1;
		  sigcol2 = 1;
		};
		Int_t img = 0;
		if ( plane == 6 ) img = 1;
		ColorTRKMIP(xsig,sigcol1,img);
		ColorTRKMIP(ysig,sigcol2,img);
		//
		// Draw crosses
		//
		trplv->cd();
		trplv->Range(-7.05,-8.1,7.05,8.1);
		//
		Float_t mg = ((float)plane)/5.;
		Float_t cdx = (0.55/mg)*var.sfx;
		Float_t cdy = (0.55/mg)*var.sfy;
		Float_t lwx = (0.019)*var.sfy;
		Float_t lwy = (0.019)*var.sfx;
		//
		linea = new TLine(y1-lwx/2.,x-cdy,y1-lwx/2.,x+cdy);
		linea->SetLineWidth(1);
		linea->SetLineColor(sigcol1);
		linea->Draw();
		linea = new TLine(y1-cdx,x-lwy/2.,y1+cdx,x-lwy/2.);
		linea->SetLineWidth(1);
		linea->SetLineColor(sigcol2);
		linea->Draw();
		//
	      };
	      if ( x > -100 && y2 > -100. ){
		if ( var.bw ){
		  sigcol1 = -1;
		  sigcol2 = -1;
		} else {
		  sigcol1 = 1;
		  sigcol2 = 1;
		};
		Int_t img = 1;
		if ( plane == 6 ) img = 0;
		ColorTRKMIP(xsig,sigcol1,img);
		ColorTRKMIP(ysig,sigcol2,img);
		//
		// Draw crosses
		//
		trplv->cd();
		trplv->Range(-7.05,-8.1,7.05,8.1);
		//
		Float_t mg = ((float)plane)/5.;
		Float_t cdx = (0.55/mg)*var.sfx;
		Float_t cdy = (0.55/mg)*var.sfy;
		Float_t lwx = (0.019)*var.sfy;
		Float_t lwy = (0.019)*var.sfx;
		// 	    
		linea = new TLine(y2-lwx/2.,x-cdy,y2-lwx/2.,x+cdy);
		linea->SetLineWidth(1);
		linea->SetLineColor(sigcol1);
		linea->Draw();
		linea = new TLine(y2-cdx,x-lwy/2.,y2+cdx,x-lwy/2.);
		linea->SetLineWidth(1);
		linea->SetLineColor(sigcol2);
		linea->Draw();
	      };
   	    };
 	  };
 	};
      };
    };
    //
    // LEVEL0 or LEVEL-1
    //
    if ( level.file == 0 || level.file == -1 ){
      for (Int_t l = 0; l<12; l++ ){	
	Float_t xsig = 0.;
	Float_t ysig = 0.;
	Int_t planeno = trk->DSPnumber[l]-1;	
	for (Int_t e = 0; e<12;e++){
	  Int_t planeno2 = trk->DSPnumber[e]-1;
	  if ( planeno == planeno2-1 ){		
	    if ( planeno < 0 || planeno > 11 ) planeno = 0;
	    if ( planeno >= 0 && !var.nosig ) {	
	      mag[ncro] = ((float)planeno+1.)/5.;
	      if ( (planeno+1)%2 ){
		for (Int_t m = 0; m<3; m++){			    
		  if ( trk->signcluster[l][m] != 0. ){
		    if ( planeno == 10 ) {
		      x = trk->addrcluster[l][m];
		    } else {
		      x = 1024 - trk->addrcluster[l][m];
		    };
		    x += 1024.;			
		    if ( trk->signcluster[l][m]> ysig  ){
		      ysig = trk->signcluster[l][m];
		      yh1[ncro] = x - 1024.;
		      yh2[ncro] = x;
		    };
		  };
		};
		for (Int_t m = 0; m<3; m++){
		  if ( trk->signcluster[e][m] != 0. ){
		    x = trk->addrcluster[e][m] + 1024. * m;
		    if ( trk->signcluster[e][m]> xsig ){
		      xsig = trk->signcluster[e][m];
		      xh[ncro] = x;
		    };
		  };
		};
	      } else {
		for (Int_t m = 0; m<3; m++){
		  if ( trk->signcluster[l][m] != 0. ){
		    x = trk->addrcluster[l][m] + 1024. * m;
		    if ( trk->signcluster[l][m]> xsig ){
		      xsig = trk->signcluster[l][m];
		      xh[ncro] = x;
		    };
		  };
		};
		if ( (planeno+1)%2 ){
		  for (Int_t m = 0; m<3; m++){
		    if ( trk->signcluster[e][m] != 0. ){
		      if ( planeno == 10 ) {
			x = trk->addrcluster[e][m];
		      } else {
			x = 1024 - trk->addrcluster[e][m];
		      };
		      x += 1024.;			
		      if ( trk->signcluster[e][m]> ysig  ){
			ysig = trk->signcluster[e][m];
			yh1[ncro] = x - 1024.;
			yh2[ncro] = x;
		      };
		    };
		  };
		};
	      };
	      if ( ysig > 0. && xsig > 0. ) {
		ncro++;
	      };
	    };    
	  };
	};
      };
      //
      // Draw crosses
      //    
      if ( ncro && var.AC ) {
	trplv->cd();
	trplv->Range(0.,0.,2076.,3100.);
	for ( Int_t i = 0; i<ncro; i++){
	  //
	  Float_t cdx = (55./mag[i])*var.sfx;
	  Float_t cdy = (55./mag[i])*var.sfy;
	  Float_t lwx = (1.9)*var.sfy;
	  Float_t lwy = (1.9)*var.sfx;
	  //
	  linea = new TLine(yh1[i]-lwx/2.,xh[i]-cdy,yh1[i]-lwx/2.,xh[i]+cdy);
	  linea->SetLineWidth((int)lwx);
	  linea->SetLineColor(sigcol1);
	  linea->Draw();
	  linea = new TLine(yh1[i]-cdx,xh[i]-lwy/2.,yh1[i]+cdx,xh[i]-lwy/2.);
	  linea->SetLineWidth((int)lwy);
	  linea->SetLineColor(sigcol1);
	  linea->Draw();
	  //
	  linea = new TLine(yh2[i]-lwx/2.,xh[i]-cdy,yh2[i]-lwx/2.,xh[i]+cdy);
	  linea->SetLineWidth((int)lwx);
	  linea->SetLineColor(sigcol2);
	  linea->Draw();
	  linea = new TLine(yh2[i]-cdy,xh[i]-lwy/2.,yh2[i]+cdx,xh[i]-lwy/2.);
	  linea->SetLineWidth((int)lwy);
	  linea->SetLineColor(sigcol2);
	  linea->Draw();
	};
      };
    };
  };
}

void FEVdetector::ShowTrack(){
  //
  if ( level.file != 2 ) return;
  //
  //
  //
  if ( var.CALO && var.CALOT ){
    if ( L2->GetCaloLevel2()->npcfit[0] > 0 && L2->GetCaloLevel2()->npcfit[1] > 0 ){
      Float_t calx[22];
      Float_t caly[22];
      Float_t calzx[22];
      Float_t calzy[22];
      Float_t zpiano[22];
      zpiano[0] = (CTZ+118.)*var.sfy/1000.;
      for (Int_t plane = 1; plane < 22; plane++){	
	if ( !(plane%2) ){
	  zpiano[plane] = zpiano[plane-1] - 8.09*var.sfy/1000.;
	}else {
	  zpiano[plane] = zpiano[plane-1] - 10.09*var.sfy/1000.;
	};
      };
      for (Int_t plane = 0; plane < 22; plane++){	
	calx[plane] = (L2->GetCaloLevel2()->cbar[plane][0]/100.)*var.sfx + var.xxvc;;
	caly[plane] = (-L2->GetCaloLevel2()->cbar[plane][1]/100.)*var.sfx + var.xyvc;
	//	calzx[plane] = zpiano[plane] -5.81*var.sfy/1000. + var.yxvc;
	calzx[plane] = zpiano[plane] + var.yxvc;
	calzy[plane] = zpiano[plane] + var.yyvc;
	//	printf(" calx %f caly %f calzx %f calzy %f \n",calx[plane],caly[plane],calzx[plane],calzy[plane]); 
      };
      //
      // Calorimeter track
      //
      Int_t trcol = 30;
      if ( var.bw ){
	trcol = 14;
      } else {
	trcol = 44;
      };
      thefigure->cd();
      TPolyLine *trakx = new TPolyLine(22,calx,calzx);
      trakx->SetLineColor(trcol);
      if ( L2->GetCaloLevel2()->fitmode[0] == 1 ) trakx->SetLineStyle(3);
      if ( L2->GetCaloLevel2()->fitmode[0] == 2 ) trakx->SetLineStyle(4);
      trakx->SetLineWidth(2);
      trakx->Draw();
      TPolyLine *traky = new TPolyLine(22,caly,calzy);
      traky->SetLineColor(trcol);
      if ( L2->GetCaloLevel2()->fitmode[1] == 1 ) traky->SetLineStyle(3);
      if ( L2->GetCaloLevel2()->fitmode[1] == 2 ) traky->SetLineStyle(4);
      traky->SetLineWidth(2);
      traky->Draw();      
    };
    if ( L2->GetCaloLevel2()->npcfit[2] > 0 ){
      Float_t calx[22];
      Float_t caly[22];
      Float_t calzx[22];
      Float_t calzy[22];
      Float_t zpiano[22];
      zpiano[0] = (CTZ+118.)*var.sfy/1000.;
      for (Int_t plane = 1; plane < 22; plane++){	
	if ( !(plane%2) ){
	  zpiano[plane] = zpiano[plane-1] - 8.09*var.sfy/1000.;
	}else {
	  zpiano[plane] = zpiano[plane-1] - 10.09*var.sfy/1000.;
	};
      };
      //
      //
      CaloTrkVar *ctra = L2->GetCaloStoredTrack(-1);
      //
      for (Int_t plane = 0; plane < 22; plane++){	
	calx[plane] = (ctra->tbar[plane][0]/100.)*var.sfx + var.xxvc;;
	caly[plane] = (-ctra->tbar[plane][1]/100.)*var.sfx + var.xyvc;
	//	calzx[plane] = zpiano[plane] -5.81*var.sfy/1000. + var.yxvc;
	calzx[plane] = zpiano[plane] + var.yxvc;
	calzy[plane] = zpiano[plane] + var.yyvc;
	//	printf(" calx %f caly %f calzx %f calzy %f \n",calx[plane],caly[plane],calzx[plane],calzy[plane]); 
      };
      //
      // Calorimeter track
      //
      Int_t trcol = 30;
      if ( var.bw ){
	trcol = 16;
      } else {
	trcol = 46;
      };
      thefigure->cd();
      TPolyLine *trakx = new TPolyLine(22,calx,calzx);
      trakx->SetLineColor(trcol);
      trakx->SetLineStyle(3);
      trakx->SetLineWidth(2);
      trakx->Draw();
      TPolyLine *traky = new TPolyLine(22,caly,calzy);
      traky->SetLineColor(trcol);
      traky->SetLineStyle(3);
      traky->SetLineWidth(2);
      traky->Draw();      
    };
  };
  //
  if ( !var.TRK ) return;
  //
  if ( L2->GetTrkLevel2()->GetNTracks() > 0 ){
    for (Int_t nt = 0; nt < L2->GetTrkLevel2()->GetNTracks(); nt++){

      //      TrkTrack *track = L2->GetTrkLevel2()->GetTrack(nt); 
      //      printf("qui \n");
      PamTrack *ptrack = L2->GetTrack(nt); 
      TrkTrack *track = ptrack->GetTrkTrack();
      //      printf("qua \n");
      Int_t npoint = 100;
      Float_t zin[100];
      //      Double_t xout[100];
      //      Double_t yout[100];
      Int_t ifail = 0;
      Int_t trcol = 10;
      //
      Float_t tx[100];
      Float_t ty[100];
      Float_t ptx1[50];
      Float_t pty1[50];
      Float_t ptx2[50];
      Float_t pty2[50];
      Float_t tx1[15];
      Float_t ty1[15];
      Float_t tzx[100];
      Float_t tzy[100];
      Float_t tzx1[15];
      Float_t tzy1[15];
      //
      for ( Int_t e = 0; e < 100 ; e++) {
        //	xout[e] = 0.;
        //	yout[e] = 0.;
	//
	tx[e] = 0.;
	ty[e] = 0.;
	tzx[e] = 0.;
	tzy[e] = 0.;
	if ( e < 50 ){
	  ptx1[e] = 0.;
	  pty1[e] = 0.;
	  ptx2[e] = 0.;
	  pty2[e] = 0.;
	  if ( e < 15 ){
	    tx1[e] = 0.;
	    ty1[e] = 0.;
	    tzx1[e] = 0.;
	    tzy1[e] = 0.;			
	  };
	};
	//
	zin[e] = 60. - (124./99.)*(float)e;
      };
      //
      zin[85] = -45.5;
      //
      Trajectory *tr = new Trajectory(npoint,zin);                               
      //
      //      ifail = track->DoTrack2(tr);
      ifail = track->DoTrack(tr);
      //
      if ( !ifail ){
	for ( Int_t e = 0; e < npoint ; e++) {
	  tx[e] = ((float)tr->x[e]/100.)*var.sfx + var.xxvc;
	  ty[e] = (-(float)tr->y[e]/100.)*var.sfx + var.xyvc;
	  if ( e < 50 ) {
	    ptx1[e] = (-(float)tr->y[e]/100.)*var.sfx + var.xcat;
	    pty1[e] = ((float)tr->x[e]/100.)*var.sfy + var.ycat;
	  } else {
	    ptx2[e-50] = (-(float)tr->y[e]/100.)*var.sfx + var.xcat;
	    pty2[e-50] = ((float)tr->x[e]/100.)*var.sfy + var.ycat;
	  };
	  if ( e > 84 ) {
	    tx1[e-85] = ((float)tr->x[e]/100.)*var.nds4 + var.xxvc;
	    ty1[e-85] = (-(float)tr->y[e]/100.)*var.nds4 + var.xyvc;	
	    tzx1[e-85] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yxvc;
	    tzy1[e-85] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yyvc;
	  };
	  tzx[e] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yxvc;		    
	  tzy[e] = (0.112)*var.sfy+((float)zin[e]/100.)*var.sfy + var.yyvc;
	  //	  printf("tx[e] %f ty [e] %f tzx %f tzy %f \n",tx[e],ty[e],tzx[e],tzy[e]);
	};
	//
	// From S1 to CALO
	//
	if ( var.bw ){
	  trcol = 17-nt;
	} else {
	  trcol = 50-nt;
	};
	thefigure->cd();
	TPolyLine *trackx = new TPolyLine(86,tx,tzx);
	trackx->SetLineColor(trcol);
	trackx->SetLineWidth(1);
	trackx->Draw();
	TPolyLine *tracky = new TPolyLine(86,ty,tzy);
	tracky->SetLineColor(trcol);
	tracky->SetLineWidth(1);
	tracky->Draw();
	//
	// ND and S4
	//
	if ( var.tracknds4 ){
	  TPolyLine *trackx1 = new TPolyLine(15,tx1,tzx1);
	  trackx1->SetLineColor(trcol);
	  trackx1->SetLineWidth(1);
	  trackx1->Draw();
	  TPolyLine *tracky1 = new TPolyLine(15,ty1,tzy1);
	  tracky1->SetLineColor(trcol);
	  tracky1->SetLineWidth(1);
	  tracky1->Draw();
	};
	//
	// Plane View
	//
	if ( var.AC ){
	  TPolyLine *trackp1 = new TPolyLine(50,ptx1,pty1);
	  trackp1->SetLineColor(trcol);
	  trackp1->SetLineWidth(1);
	  trackp1->Draw();
	  TPolyLine *trackp2 = new TPolyLine(50,ptx2,pty2);
	  trackp2->SetLineColor(trcol);
	  trackp2->SetLineWidth(1);
	  trackp2->SetLineStyle(3);
	  trackp2->Draw();
	};

      } else {
	pamgui->DIALOG(1," Failed in determining the track! ");
	printf(" WARNING: failed in determining the track! \n");
      };
    };
  };
}

void FEVdetector::ShowCalo(Bool_t upd){
  //
  //
  //
  if ( !var.CALO ) return;
  //
  var.qtot = 0;
  var.nstrip = 0;
  //
  if ( level.file == 0 ){
    //
    // Book the histograms:
    //
    //
    stringstream delex;
    delex.str("");
    delex << "x-view event " << (thisentry+1);
    stringstream deley;
    deley.str("");
    deley << "y-view event " << (thisentry+1);
    gDirectory->Delete(delex.str().c_str());
    gDirectory->Delete(deley.str().c_str());
    TH2F *Xview = new TH2F(delex.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
    TH2F *Yview = new TH2F(deley.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
    Xview->GetYaxis()->SetLabelColor(10); 
    Yview->GetYaxis()->SetLabelColor(10); 
    //
    // figures:
    //
    Int_t bgcolor = 10;
    TPad *pd1 = new TPad("calox","This is pad1",var.xxvc-0.154*var.sfx,var.yxvc-0.3645*var.sfy,var.xxvc+0.154*var.sfx,var.yxvc-0.1200*var.sfy,bgcolor);
    TPad *pd2 = new TPad("caloy","This is pad2",var.xyvc-0.154*var.sfx,var.yyvc-0.3645*var.sfy,var.xyvc+0.154*var.sfx,var.yyvc-0.1200*var.sfy,bgcolor);

    pd1->SetFillStyle(4000);
    pd1->SetFillColor(0);
    pd1->SetFrameFillStyle(4000);
    pd2->SetFillStyle(4000);
    pd2->SetFillColor(0);
    pd2->SetFrameFillStyle(4000);

    TLatex *t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.03);
    t->SetTextAlign(12);
    pd1->Range(0.,0.,1.,1.);
    pd2->Range(0.,0.,1.,1.);
    pd1->SetTicks();
    pd2->SetTicks();
    pd1->Draw();
    pd2->Draw();
    
    pd1->cd();	   
    gStyle->SetOptStat(0);
    Xview->GetYaxis()->SetTitleOffset(0.5);
    Xview->SetFillColor(bgcolor);	    
    Xview->Fill(1.,1.,1.);	    
    Xview->Draw("box");
    pd1->Update();
    pd2->cd();
    gStyle->SetOptStat(0);
    Yview->GetYaxis()->SetTitleOffset(0.5);	
    Yview->SetFillColor(bgcolor);	    
    Yview->Fill(1.,1.,1.);	    
    Yview->Draw("box");
    pd2->Update();

    //
    // run over views and planes
    //
    stringstream xevent;
    stringstream yevent;
    //    Float_t sdexy[2][22][96];
    //    Float_t sdexyc[2][22][96];
    //
    for (Int_t m = 0; m < 22; m++){
      for (Int_t l = 0; l < 2; l++){
	//
	// determine the section number
	//
	Int_t se = 5;
	if ( !l && m%2 == 0 ) se = 3;
	if ( !l && m%2 != 0 ) se = 2;
	if (  l && m%2 != 0 ) se = 1;
	if (  l && m%2 == 0 ) se = 0;
	//
	// determine what kind of event we are going to analyze
	//
        //	bool isCOMP = 0;
        //	bool isFULL = 0;
	bool isRAW = 0;
        //	if ( de->stwerr[se] & (1 << 16) ) isCOMP = 1; 
        //	if ( de->stwerr[se] & (1 << 17) ) isFULL = 1; 
	if ( de->stwerr[se] & (1 << 3) ) isRAW = 1; 	
	//
	// save the prevoius energy deposit and calibration in sbase, sdexy, sdexyc
	//
	Int_t pre = -1; 
	if ( isRAW ){
	  for (Int_t nn = 0; nn < 96; nn++){		    
	    if ( nn%16 == 0 ) pre++;		    
	    evento.base[l][m][pre] = calib.calbase[l][m][pre];
            //	    sdexy[l][m][nn] = evento.dexy[l][m][nn];
	    evento.dexy[l][m][nn] = de->dexy[l][m][nn] ; 
            //	    sdexyc[l][m][nn] = evento.dexy[l][m][nn];
	    evento.dexyc[l][m][nn] = de->dexy[l][m][nn] ; 
	  };
	};
	//
	// run over strips
	//
	Int_t done = 0;
	Int_t rdone = 0;
	Int_t fdone = 0;	    
	pre = -1;
	for (Int_t n =0 ; n < 96; n++){		    
	  if ( n%16 == 0 ) {
	    pre++;
	    done = 0;
	    rdone = 0;
	    fdone = 0;
	  };	
	  // 
	  // baseline check and calculation
	  //
	  if ( isRAW ) {
	    //
	    // if it is a raw event and we haven't checked yet, calculate the baseline. Then check that the baseline is fine,
	    // if not calculate it with relaxed algorithm.
	    //
	    if ( !rdone ){
	      CaloFindBaseRaw(l,m,pre);
	      rdone = 1;			
	    };
	    //
	    // no suitable new baseline, use old ones
	    //
	    if ( !done && (evento.base[l][m][pre] == 31000. || evento.base[l][m][pre] == 0.) ){
	      evento.base[l][m][pre] = calib.sbase[l][m][pre];
	      Int_t upnn = n+16;
	      if ( upnn > 96 ) upnn = 96;
	      for ( Int_t nn = n; nn<upnn; nn++ ){
		evento.dexyc[l][m][nn] = de->dexy[l][m][nn] ;
	      };
	      done = 1;			
	    };
	    if ( !fdone ){
	      CaloCompressData(l,m,pre);
	      fdone = 1;			
	    };
	  };					    
	  //
	  if ( de->dexyc[l][m][n] > 0. || ( isRAW && evento.dexyc[l][m][n] > 0. )){
	    xevent.str("");
	    yevent.str("");
	    xevent << "x-view event " << n;
	    xevent << " " << m;
	    xevent << " " << l;
	    yevent << "y-view event " << n;
	    yevent << " " << m;
	    yevent << " " << l;
	    gDirectory->Delete(xevent.str().c_str());
	    gDirectory->Delete(yevent.str().c_str());
	    TH2F *Xview = new TH2F(xevent.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
	    TH2F *Yview = new TH2F(yevent.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
	    Int_t colo;
	    if ( var.bw ){
	      colo = 17;
	    } else {
	      colo = 38;
	    };
	    Xview->SetFillColor(colo);
	    Yview->SetFillColor(colo);
	    if ( l == 0 ) {
	      Xview->Fill(n,21-m,1.);
	      pd1->cd();				    
	      Xview->Draw("box same");
	    };				    
	    if ( l == 1 ) {			    
	      Yview->Fill(95-n,21-m,1.);
	      pd2->cd();
	      Yview->Draw("box same");
	    };
	  };		    		
	};
      };
    };
    pd1->Update();
    pd2->Update();
    var.qtot=0;
    var.nstrip=0;
  };
  //
  if ( level.file == -1 ){
    Float_t qtot;
    Int_t nstrip;
    //
    // Define variables
    // 
    UInt_t etime = var.etime;
    Float_t estrip[2][22][96], ener, basel;//,sdexy[2][22][96],sdexyc[2][22][96];
    Int_t badstrip = 0;
    qtot = 0.;
    nstrip = 0;
    //
    // Book the histograms:
    //
    //
    stringstream xvev;
    stringstream yvev;
    xvev.str("");
    yvev.str("");
    xvev << "x-view event " << (thisentry+1);
    yvev << "y-view event " << (thisentry+1);
    gDirectory->Delete(xvev.str().c_str());
    gDirectory->Delete(yvev.str().c_str());
    TH2F *Xview = new TH2F(xvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
    TH2F *Yview = new TH2F(yvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
    Xview->GetYaxis()->SetLabelColor(10); 
    Yview->GetYaxis()->SetLabelColor(10); 
    //
    // figures:
    //
    Int_t bgcolor = 10;
    gDirectory->Delete("caloy");
    gDirectory->Delete("calox");
    TPad *pd1 = new TPad("calox","This is pad1",var.xxvc-0.154*var.sfx,var.yxvc-0.3645*var.sfy,var.xxvc+0.154*var.sfx,var.yxvc-0.1200*var.sfy,bgcolor);
    TPad *pd2 = new TPad("caloy","This is pad2",var.xyvc-0.154*var.sfx,var.yyvc-0.3645*var.sfy,var.xyvc+0.154*var.sfx,var.yyvc-0.1200*var.sfy,bgcolor);
    if ( upd ){

      pd1->SetFillStyle(4000);
      pd1->SetFillColor(0);
      pd1->SetFrameFillStyle(4000);
      pd2->SetFillStyle(4000);
      pd2->SetFillColor(0);
      pd2->SetFrameFillStyle(4000);

      TLatex *t=new TLatex();
      t->SetTextFont(32);
      t->SetTextColor(1);
      t->SetTextSize(0.03);
      t->SetTextAlign(12);
      pd1->Range(0.,0.,1.,1.);
      pd2->Range(0.,0.,1.,1.);
      pd1->SetTicks();
      pd2->SetTicks();
      pd1->Draw();
      pd2->Draw();
    
      pd1->cd();	   
      gStyle->SetOptStat(0);
      Xview->GetYaxis()->SetTitleOffset(0.5);
      Xview->SetFillColor(bgcolor);	    
      Xview->Fill(1.,1.,1.);	    
      Xview->Draw("box");
      pd1->Update();
      pd2->cd();
      gStyle->SetOptStat(0);
      Yview->GetYaxis()->SetTitleOffset(0.5);	
      Yview->SetFillColor(bgcolor);	    
      Yview->Fill(1.,1.,1.);	    
      Yview->Draw("box");
      pd2->Update();
    };
    //
    // for each event check that the calibration we are using are still within calibration limits, if not call the next calibration
    //
    for (Int_t s = 0; s < 4; s++){
      if ( calib.ttime[s][b[s]+1] && calib.time[s][b[s]] ){
	while ( etime > calib.time[s][b[s]] && calib.time[s][b[s]] != 0 ){				
	  printf(" CALORIMETER: \n" );
	  printf(" - Section %i, event at time %u while old calibration time limit at %u. Use new calibration at time %u -\n",s,(UInt_t)etime,(UInt_t)calib.time[s][b[s]],(UInt_t)calib.ttime[s][b[s]+1]);
	  printf(" END CALORIMETER. \n\n" );
	  b[s]++;
	  CaloPede(s);
	};
      };
    };
    //
    // run over views and planes
    //
    stringstream xve;
    stringstream yve;
    for (Int_t l = 0; l < 2; l++){
      for (Int_t m = 0; m < 22; m++){
	//
	// determine the section number
	//
	Int_t se = 5;
	if (l == 0 && m%2 == 0) se = 3;
	if (l == 0 && m%2 != 0) se = 2;
	if (l == 1 && m%2 != 0) se = 1;
	if (l == 1 && m%2 == 0) se = 0;		
	//
	// determine what kind of event we are going to analyze
	//
        //	bool isCOMP = 0;
        //	bool isFULL = 0;
	bool isRAW = 0;
        //	if ( de->stwerr[se] & (1 << 16) ) isCOMP = 1; 
        //	if ( de->stwerr[se] & (1 << 17) ) isFULL = 1; 
	if ( de->stwerr[se] & (1 << 3) ) isRAW = 1; 
	//
	// save the prevoius energy deposit and calibration in sbase, sdexy, sdexyc
	//
	Int_t pre = -1; 
	if ( isRAW ){
	  for (Int_t nn = 0; nn < 96; nn++){		    
	    if ( nn%16 == 0 ) pre++;		    
	    evento.base[l][m][pre] = calib.calbase[l][m][pre];
            //	    sdexy[l][m][nn] = evento.dexy[l][m][nn];
	    evento.dexy[l][m][nn] = de->dexy[l][m][nn] ; 
            //	    sdexyc[l][m][nn] = evento.dexy[l][m][nn];
	    evento.dexyc[l][m][nn] = de->dexy[l][m][nn] ; 
	  };
	};
	//
	// run over strips
	//
	Int_t done = 0;
	Int_t rdone = 0;
        //	Int_t fdone = 0;	    
	pre = -1;
	for (Int_t n =0 ; n < 96; n++){		    
	  if ( n%16 == 0 ) {
	    pre++;
	    done = 0;
	    rdone = 0;
            //	    fdone = 0;
	  };	
	  // 
	  // baseline check and calculation
	  //
	  if ( !isRAW ) {
	    //
	    // if it isn't raw and we haven't checked yet, check that the baseline is fine, if not calculate it with a relaxed algorithm.
	    //
	    if ( !done ){
	      evento.base[l][m][pre] = de->base[l][m][pre] ;   
	      evento.dexyc[l][m][n] = de->dexyc[l][m][n] ; 
	    };
	  } else {
	    //
	    // if it is a raw event and we haven't checked yet, calculate the baseline. Then check that the baseline is fine,
	    // if not calculate it with relaxed algorithm.
	    //
	    if ( !rdone ){
	      CaloFindBaseRaw(l,m,pre);
	      rdone = 1;			
	    };
	  };					    
	  //
	  // no suitable new baseline, use old ones
	  //
	  if ( !done && (evento.base[l][m][pre] == 31000. || evento.base[l][m][pre] == 0.) ){
	    evento.base[l][m][pre] = calib.sbase[l][m][pre];
	    Int_t upnn = n+16;
	    if ( upnn > 96 ) upnn = 96;
	    for ( Int_t nn = n; nn<upnn; nn++ ){
	      if ( !isRAW ){
		evento.dexyc[l][m][nn] = de->dexyc[l][m][nn] ;
	      } else {
		evento.dexyc[l][m][nn] = de->dexy[l][m][nn] ;
	      };
	    };
	    CaloCompressData(l,m,pre);
	    done = 1;			
	  };
	  //
	  // CALIBRATION ALGORITHM
	  // 
	  basel = evento.base[l][m][pre];		    
	  ener = evento.dexyc[l][m][n];
	  estrip[l][m][n] = 0.;
	  if ( basel>0 && basel < 30000. && ener > 0. ){
	    estrip[l][m][n] = (ener - calib.calped[l][m][n] - basel)/mip[l][m][n] ;
	    //
	    // OK, now in estrip we have the energy deposit in MIP of all the strips for this event (at the end of loops of course)
	    //
	    if ( upd ){
	      xve.str("");
	      yve.str("");
	      xve << "x-view event " << n;
	      xve << " " << m;
	      xve << " " << l;
	      yve << "y-view event " << n;
	      yve << " " << m;
	      yve << " " << l;
	      gDirectory->Delete(xve.str().c_str());
	      gDirectory->Delete(yve.str().c_str());
	      TH2F *Xview = new TH2F(xve.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
	      TH2F *Yview = new TH2F(yve.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
	      if ( estrip[l][m][n] > 0.7 && !var.nosig ){
		Int_t colo;
		if ( var.bw ){
		  colo = -1;
		} else {
		  colo = 1;
		};
		ColorMIP(estrip[l][m][n],colo);
		Xview->SetFillColor(colo);
		Yview->SetFillColor(colo);
		if ( l == 0 ) {
		  Xview->Fill(n,21-m,1.);
		  pd1->cd();				    
		  Xview->Draw("box same");
		};				    
		if ( l == 1 ) {			    
		  Yview->Fill(96-n,21-m,1.);
		  pd2->cd();
		  Yview->Draw("box same");
		};
	      };		
	    };	
	    if ( estrip[l][m][n] > 0.7 && calib.calgood[l][m][n] != 0  ) badstrip++;
	    if ( estrip[l][m][n] > 0.7 && calib.calgood[l][m][n] == 0 ) {			    
	      qtot += estrip[l][m][n];
	      nstrip++;
	    };
	  };		    	
	  calib.sbase[l][m][pre] = evento.base[l][m][pre];
	};		
      };
    };
    if ( upd ){
      pd1->Update();
      pd2->Update();
    };
    var.qtot=(int)qtot;
    var.nstrip=nstrip;
  };
  //
  if ( level.file == 2 ){
    //
    // Book the histograms:
    //
    //
    stringstream xview;
    stringstream yview;
    xview.str("");
    yview.str("");
    xview << "x-view event " << (thisentry+1);
    yview << "y-view event " << (thisentry+1);
    gDirectory->Delete(xview.str().c_str());
    gDirectory->Delete(yview.str().c_str());
    TH2F *Xview = new TH2F(xview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
    TH2F *Yview = new TH2F(yview.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);	
    Xview->GetYaxis()->SetLabelColor(10); 
    Yview->GetYaxis()->SetLabelColor(10); 
    //
    // figures:
    //
    Int_t bgcolor = 10;
    TPad *pd1 = new TPad("calox","This is pad1",var.xxvc-0.154*var.sfx,var.yxvc-0.3645*var.sfy,var.xxvc+0.154*var.sfx,var.yxvc-0.1200*var.sfy,bgcolor);
    TPad *pd2 = new TPad("caloy","This is pad2",var.xyvc-0.154*var.sfx,var.yyvc-0.3645*var.sfy,var.xyvc+0.154*var.sfx,var.yyvc-0.1200*var.sfy,bgcolor);

    pd1->SetFillStyle(4000);
    pd1->SetFillColor(0);
    pd1->SetFrameFillStyle(4000);
    pd2->SetFillStyle(4000);
    pd2->SetFillColor(0);
    pd2->SetFrameFillStyle(4000);

    TLatex *t=new TLatex();
    t->SetTextFont(32);
    t->SetTextColor(1);
    t->SetTextSize(0.03);
    t->SetTextAlign(12);
    pd1->Range(0.,0.,1.,1.);
    pd2->Range(0.,0.,1.,1.);
    pd1->SetTicks();
    pd2->SetTicks();
    pd1->Draw();
    pd2->Draw();
    
    pd1->cd();	   
    gStyle->SetOptStat(0);
    Xview->GetYaxis()->SetTitleOffset(0.5);
    Xview->SetFillColor(bgcolor);	    
    Xview->Fill(1.,1.,1.);	    
    Xview->Draw("box");
    pd1->Update();
    pd2->cd();
    gStyle->SetOptStat(0);
    Yview->GetYaxis()->SetTitleOffset(0.5);	
    Yview->SetFillColor(bgcolor);	    
    Yview->Fill(1.,1.,1.);	    
    Yview->Draw("box");
    pd2->Update();

    //
    // run over views and planes
    //
    stringstream xvev;
    stringstream yvev;    
    //    for (Int_t ii = 0; ii < L2->GetCaloLevel2()->nstrip; ii++){
    for (Int_t ii = 0; ii < L2->GetCaloLevel1()->istrip; ii++){
      Int_t colo;
      Int_t l;
      Int_t m;
      Int_t n;
      Bool_t satura = false;
      Float_t mip = L2->GetCaloLevel1()->DecodeEstrip(ii,l,m,n,satura);
      if ( var.bw ){
	colo = -1;
      } else {
	colo = 1;
      };      
      ColorMIP(mip,colo);
      if ( l == 0 ) {
	xvev.str("");
	xvev << "x-view event " << n;
	xvev << " " << m;
	xvev << " " << l;
	gDirectory->Delete(xvev.str().c_str());
	TH2F *Xview = new TH2F(xvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);
	if ( satura ){
	  Xview->SetFillColor(kBlack);
	} else {
	  Xview->SetFillColor(colo);
	};
	Xview->Fill(n,21-m,1.);
	pd1->cd();				    
	Xview->Draw("box same");
      };				    
      if ( l == 1 ) {			    
	yvev.str("");
	yvev << "y-view event " << n;
	yvev << " " << m;
	yvev << " " << l;
	gDirectory->Delete(yvev.str().c_str());
	TH2F *Yview = new TH2F(yvev.str().c_str(),"",96,-0.5,95.5,22,-0.5,21.5);		  
	if ( satura ){
	  Yview->SetFillColor(kBlack);
	} else {
	  Yview->SetFillColor(colo);
	};
	Yview->Fill(96-n,21-m,1.);
	pd2->cd();
	Yview->Draw("box same");
      };
    };
    pd1->Update();
    pd2->Update();
    var.qtot=(int)L2->GetCaloLevel2()->qtot;
    var.nstrip=(int)L2->GetCaloLevel2()->nstrip;
  };
}

void FEVdetector::Calo1stcalib(){
  //  Float_t estrip[2][22][96];
  //    
  // this is the value of the mip for each strip. To be changed when we will have the real values
  //
  for (Int_t s=0; s<4;s++){
    for (Int_t d = 0; d<50; d++){
      calib.ttime[s][d] = 0 ;
      if ( d < 49 ) calib.time[s][d] = 0 ;
    };
  };
  defcalib = false;
  //
 retry:
  //
  for (Int_t m = 0; m < 2 ; m++ ){
    for (Int_t k = 0; k < 22; k++ ){
      for (Int_t l = 0; l < 96; l++ ){
	calib.calped[m][k][l] = 0. ;
        //	estrip[m][k][l] = 0.;
      };
    };
  }
  //
  // first of all find the calibrations in the file 
  //
  OLDCaloFindCalibs();    
  //
  // print on the screen the results:   
  //
  printf(" ---------------------------------------------------------- \n \n");	
  Int_t calibex = 0;
  for (Int_t s=0; s<4;s++){
    Int_t stop = 0;
    for (Int_t d = 0; d<48; d++){
      if ( calib.ttime[s][d] != 0 ) calibex++;
      if ( calib.time[s][0] != 0 ){
	if ( d == 0 )  printf(" Section %i from time 0 to time %u use calibration at time %u \n",s,calib.time[s][d],calib.ttime[s][d]);
	if ( calib.time[s][d+1] != 0 ) {
	  printf(" Section %i from time %u to time %u use calibration at time %u \n",s,calib.time[s][d],calib.time[s][d+1],calib.ttime[s][d+1]);
	} else {
	  if ( !stop ){
	    printf(" Section %i from time %u use calibration at time %u \n",s,calib.time[s][d],calib.ttime[s][d+1]);		
	    stop = 1;
	  };
	};
      } else {
	if ( calib.ttime[s][d] != 0 ) printf(" Section %i from time 0 use calibration at time %u \n",s,calib.ttime[s][d]);
      };
    };
    printf("\n");	
  };
  printf(" ---------------------------------------------------------- \n");	
  if ( calibex < 1 ) {
    printf("No full calibration data in this file\n");
    printf(" Using default calibration \n");
    defcalib = true;
    goto retry;
  };
  //
  // calibrate before starting
  //
  for (Int_t s = 0; s < 4; s++){
      b[s]=0;
      CaloPede(s);
  };	    
}

int FEVdetector::OLDCaloFindCalibs(){
  for (Int_t s = 0; s < 4; s++){
    for (Int_t d = 1; d<50; d++){
      calib.ttime[s][d] = 0;
      if ( d < 49 ) calib.time[s][d] = 0;
    };
  };
  TString calibfile;
  if ( defcalib ){
    const char *pam_calib = pathtocalibration();
    stringstream calfile;
    calfile.str("");
    calfile << pam_calib << "/cal-param/FCaloDefaultCalib.root";
    calibfile = calfile.str().c_str();
  } else {
    calibfile = var.thefilename;
  }; 
  if ( !existfile(calibfile) ) return(1);
  //
  printf(" Using for calibrations file %s \n",calibfile.Data());
  //
  TFile *File = new TFile(calibfile.Data());
  TTree *tr = (TTree*)File->Get("CalibCalPed");
  pamela::CalibCalPedEvent *ce = 0;   
  pamela::PscuHeader *cph = 0;
  pamela::EventHeader *ceh = 0; 
  tr->SetBranchAddress("Header", &ceh);
  tr->SetBranchAddress("CalibCalPed", &ce);
  Long64_t ncalibs    = tr->GetEntries();
  Int_t inter;    	
  for (Int_t s = 0; s < 4; s++){
    for (Int_t d = 1; d<50; d++){
      calib.ttime[s][d] = 0;
      if ( d < 49 ) calib.time[s][d] = 0;
    };
  };
  for (Int_t s = 0; s < 4; s++){
    inter = 0;
    for (Int_t c = 0; c < ncalibs; c++){
      tr->GetEntry(c);
      cph = ceh->GetPscuHeader(); 
      calib.ttime[s][inter] = 0;
      if ( ce->cstwerr[s] != 0 && ce->cperror[s] == 0 ) {
	//calib.ttime[s][inter] = cph->GetOrbitalTime();
	calib.ttime[s][inter] = (UInt_t)cph->OrbitalTime;
	inter++;
      } else {
	if ( ce->cstwerr[s] != 0 && ce->cperror[s] != 0 ) {
	  printf(" ERROR: entry %i stwerr %X perror %f \n",c,ce->cstwerr[s],ce->cperror[s]);
	};
      };
    };
    if ( inter == 0 ){
      printf(" ERROR: no suitable calibration for section %i in this file!\n",s);
    };
    for (Int_t d = 1; d<50; d++){
      if ( calib.ttime[s][d] != 0 ) {
	calib.time[s][d-1] = calib.ttime[s][d-1] + (int)((calib.ttime[s][d] - calib.ttime[s][d-1])/2.);
      } else {
	if ( d == 1 ) {
	  calib.time[s][d-1] = 0;
	};
      };
    };
  };
  File->Close();
  return(0);
}

int FEVdetector::CaloPede(Int_t s){
  //
  UInt_t atime = calib.ttime[s][b[s]];
  TString calibfile;
  if ( defcalib ){
    const char *pam_calib = pathtocalibration();
    stringstream calfile;
    calfile.str("");
    calfile << pam_calib << "/cal-param/FCaloDefaultCalib.root";
    calibfile = calfile.str().c_str();
  } else {
    calibfile = var.thefilename;
  }; 
  if ( !existfile(calibfile) ) return(3);
  //
  TFile *File = new TFile(calibfile.Data());
  TTree *tr = (TTree*)File->Get("CalibCalPed");
  //
  pamela::CalibCalPedEvent *ce = 0;
  pamela::PscuHeader *cph = 0;
  pamela::EventHeader *ceh = 0;
  tr->SetBranchAddress("Header", &ceh);
  tr->SetBranchAddress("CalibCalPed", &ce);
  //
  Long64_t ncalibs    = tr->GetEntries();
  for (Int_t ci = 0; ci < ncalibs ; ci++){
    tr->GetEntry(ci);
    cph = ceh->GetPscuHeader(); 		
    //if ( atime == cph->GetOrbitalTime()){
    if ( atime == (UInt_t)cph->OrbitalTime){
      //      calib.iev = ce->iev;
      if (ce->cstwerr[s] != 0 && ce->cperror[s] == 0 ) {
	for ( Int_t d=0 ; d<11 ;d++  ){
	  Int_t pre = -1;
	  for ( Int_t j=0; j<96 ;j++){
	    if ( j%16 == 0 ) pre++;
	    if ( s == 2 ){
	      calib.calped[0][2*d+1][j] = ce->calped[3][d][j];
	      calib.cstwerr[3] = ce->cstwerr[3];
	      calib.cperror[3] = ce->cperror[3];
	      calib.calgood[0][2*d+1][j] = ce->calgood[3][d][j];
	      calib.calthr[0][2*d+1][pre] = ce->calthr[3][d][pre];
	      calib.calrms[0][2*d+1][j] = ce->calrms[3][d][j];
	      calib.calbase[0][2*d+1][pre] = ce->calbase[3][d][pre];
	      calib.calvar[0][2*d+1][pre] = ce->calvar[3][d][pre];
	    };
	    if ( s == 3 ){
	      calib.calped[0][2*d][j] = ce->calped[1][d][j];
	      calib.cstwerr[1] = ce->cstwerr[1];
	      calib.cperror[1] = ce->cperror[1];
	      calib.calgood[0][2*d][j] = ce->calgood[1][d][j];
	      calib.calthr[0][2*d][pre] = ce->calthr[1][d][pre];
	      calib.calrms[0][2*d][j] = ce->calrms[1][d][j];
	      calib.calbase[0][2*d][pre] = ce->calbase[1][d][pre];
	      calib.calvar[0][2*d][pre] = ce->calvar[1][d][pre];
	    };
	    if ( s == 0 ){
	      calib.calped[1][2*d][j] = ce->calped[0][d][j];
	      calib.cstwerr[0] = ce->cstwerr[0];
	      calib.cperror[0] = ce->cperror[0];
	      calib.calgood[1][2*d][j] = ce->calgood[0][d][j];
	      calib.calthr[1][2*d][pre] = ce->calthr[0][d][pre];
	      calib.calrms[1][2*d][j] = ce->calrms[0][d][j];
	      calib.calbase[1][2*d][pre] = ce->calbase[0][d][pre];
	      calib.calvar[1][2*d][pre] = ce->calvar[0][d][pre];
	    };
	    if ( s == 1 ){
	      calib.calped[1][2*d+1][j] = ce->calped[2][d][j];
	      calib.cstwerr[2] = ce->cstwerr[2];
	      calib.cperror[2] = ce->cperror[2];
	      calib.calgood[1][2*d+1][j] = ce->calgood[2][d][j];
	      calib.calthr[1][2*d+1][pre] = ce->calthr[2][d][pre];
	      calib.calrms[1][2*d+1][j] = ce->calrms[2][d][j];
	      calib.calbase[1][2*d+1][pre] = ce->calbase[2][d][pre];
	      calib.calvar[1][2*d+1][pre] = ce->calvar[2][d][pre];
	    };
	  };
	};
      };
    };
  };    	   
  File->Close();
  return(0);
}

void FEVdetector::CaloFindBaseRaw(Int_t l, Int_t m, Int_t pre){
  Float_t minstrip = 100000.;
  Float_t rms = 0.;
  evento.base[l][m][pre] = 0.;
  for (Int_t e = pre*16; e < (pre+1)*16 ; e++){
    if ( calib.calgood[l][m][e] == 0. &&  evento.dexy[l][m][e]-calib.calped[l][m][e] < minstrip &&  evento.dexy[l][m][e] > 0.) {
      minstrip = evento.dexy[l][m][e]-calib.calped[l][m][e];
      rms = calib.calthr[l][m][pre];
    };
  };
  if ( minstrip != 100000. ) {
    Float_t strip6s = 0.;
    for (Int_t e = pre*16; e < (pre+1)*16 ; e++){
      if ( (evento.dexy[l][m][e]-calib.calped[l][m][e]) >= minstrip && (evento.dexy[l][m][e]-calib.calped[l][m][e]) <= (minstrip+rms) ) {
	strip6s += 1.;
	evento.base[l][m][pre] += (evento.dexy[l][m][e] - calib.calped[l][m][e]);
      };
      //
      //  compression
      //
      if ( abs((int)(evento.dexy[l][m][e]-calib.calped[l][m][e])) <= (minstrip+rms) ) {
	evento.dexyc[l][m][e] = 0.;
      } else {
	evento.dexyc[l][m][e] = evento.dexy[l][m][e];
      };
    };
    if ( strip6s >= 9. ){	    
      Double_t arro = evento.base[l][m][pre]/strip6s;
      Float_t deci = 1000.*((float)arro - float(int(arro)));		      
      if ( deci < 500. ) {
	arro = double(int(arro));
      } else {
	arro = 1. + double(int(arro));
      };
      evento.base[l][m][pre] = arro;
    } else {
      evento.base[l][m][pre] = 31000.;
      for (Int_t e = pre*16; e < (pre+1)*16 ; e++){
	evento.dexyc[l][m][e] = evento.dexy[l][m][e];
      };
    };
  } else {
    evento.base[l][m][pre] = 31000.;
  };
}

void FEVdetector::CaloCompressData(Int_t l, Int_t m, Int_t pre){
  Float_t minstrip = 100000.;
  Float_t rms = 0.;
  for (Int_t e = pre*16; e < (pre+1)*16 ; e++){
    if ( calib.calgood[l][m][e] == 0. &&  evento.dexyc[l][m][e]-calib.calped[l][m][e] < minstrip &&  evento.dexyc[l][m][e] > 0.) {
      minstrip = evento.dexyc[l][m][e]-calib.calped[l][m][e];
      rms = calib.calthr[l][m][pre];
    };
  };
  //
  // compression
  //
  if ( minstrip < evento.base[l][m][pre] && minstrip != 100000.){
    for (Int_t e = pre*16; e < (pre+1)*16 ; e++){
      if ( evento.dexyc[l][m][e]-calib.calped[l][m][e] <= (minstrip+rms) ) evento.dexyc[l][m][e] = 0.;
    };
  };
}
