//
// EventViewer.cc -- standalone program to call the EventViewer macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/11/07)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TSystem.h>
//#include <caloclasses.h>
#include <iostream>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
//
extern void ShowEvent(TString, TString, Int_t, Int_t, Int_t, Int_t, TString);
extern void info();
using namespace std;
//
int main(int numinp, char *inps[]){
  TString name = "";
  TString selfile = "";
  TString outdir = "";
  int dl = -1;
  int figlay = 509;  
  bool beverbose = false;
  if ( numinp > 1 ){
    if ( !strcmp(inps[1],"--version") ){
      info();
      return(0);
    };
    if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") || numinp>7 ){
      printf("\nUsage:\n\n EventViewer [-v] file selection_file figure_layout data_level output_dir \n");
      printf("\n -v                be verbose and do not fork after launching the GUI\n");
      printf(  "  file             must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
      printf(  "  selection_file   selection file, empty if no selection is required \n");
      printf(  "  figure_layout    10 bit integer to control the figure layout. Each bit \n");
      printf(  "                   set to 1 activate the visualization of a detector or  \n");
      printf(  "                   a part of the figure. This is the association scheme: \n");
      printf(  "                  10    9    8    7     6    5     4    3      2     1  \n");
      printf(  "               special TOF  AC   TRK   CALO S4    ND   infos  names legenda \n");
      printf(  "                   The default value is 509 = 0111111101 that is all detectors\n");
      printf(  "                   and infos are shown, names are hidden. \n");
      printf(  "                   When the \"special\" bit is set NO SIGNAL will be shown in \n");
      printf(  "                   the detectors. It can be used to draw a draft of the PAMELA\n");
      printf(  "                   apparatus without any event.\n");
      printf(  "                   Other examples: \n");
      printf(  "                   505 = 0111111001 : don't print infos on figure \n");
      printf(  "                   507 = 0111111011 : show detector names+legenda (no infos) \n");
      printf(  "                   8   = 0000001000 : show only ND. \n");
      printf(  "  data_level       by default the program will try to display the highest level\n");
      printf(  "                   data available. This flag force the level0 visualization\n");
      printf(  "                   when it is set to 0. Default value is -1. \n");
      printf(  "  outDir           directory where to save figures\n");
      printf("\nExamples: \n\nEventViewer /home/pamela/filesfromyoda/dw_050301_00100/ \"\" 509 -1 /home/pamela/\n");
      printf(                "EventViewer -v /home/pamela/filesfromyoda/dw_050301_00100/ muselection.c 509 -1 \"\"\n\n");
      printf(                "EventViewer \n\n");
      printf(                "EventViewer -v \n\n");
      return(0);
    };
    if ( !strcmp(inps[1],"-v") || !strcmp(inps[1],"--verbose") ){
      beverbose = true;
      if ( numinp >= 3 ) name = (TString)inps[2];
      if ( numinp >= 4 ) selfile = (TString)inps[3];
      if ( numinp >= 5 ) figlay = atoi(inps[4]);
      if ( numinp >= 6 ) dl = atoi(inps[5]);
      if ( numinp == 7 ) outdir = (TString)inps[6];
    } else {
      name = (TString)inps[1];
      if ( numinp >= 3 ) selfile = (TString)inps[2];
      if ( numinp >= 4 ) figlay = atoi(inps[3]);
      if ( numinp >= 5 ) dl = atoi(inps[4]);
      if ( numinp >= 6 ) outdir = (TString)inps[5];
    };
  };
  if ( beverbose ){
    ShowEvent(name,selfile,figlay,dl,0,0,outdir);
  } else {
    //
    // redirect to dev/null the stdout
    //
    int nul;
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
    close(nul);
    //
    printf("\n Welcome to  the PAMELA event viewer! \n\n");
    //
    // fork process
    //
    pid_t pid;
    if( (pid=fork()) == -1 ){
      fprintf(stderr," Fork error. Exiting.\n"); 
      exit(1);        
    };
    if( !pid ) {
      ShowEvent(name,selfile,figlay,dl,0,0,outdir);
    };
  };
  //
  return(0);
}
