#ifndef __FEVdetector__
#define __FEVdetector__
#include <feventvstruct.h>
#include <TObjectTable.h>
#include <TGClient.h>
#include <TGButton.h>
#include <TGComboBox.h>
#include <TGLabel.h>
#include <TGTextEntry.h>
#include <TGFrame.h>
#include <TGButtonGroup.h>
#include <TGProgressBar.h>
#include <TGMsgBox.h>
#include <TGComboBox.h>
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TLine.h>
#include <TPolyLine.h>
#include <TChain.h>
#include <TApplication.h>
#include <TVirtualX.h>
#include <TGClient.h>
#include <TGWindow.h>
#include <TEllipse.h>
#include <TArrow.h>
#include <TStyle.h>
//
#include <PamLevel2.h>
#include <PamelaRun.h>
#include <physics/calorimeter/CalorimeterEvent.h>
#include <physics/trigger/TriggerEvent.h>
#include <physics/tof/TofEvent.h>
#include <physics/tracker/TrackerEvent.h>
#include <physics/anticounter/AnticounterEvent.h>
#include <physics/neutronDetector/NeutronEvent.h>
#include <physics/S4/S4Event.h>
#include <CalibCalPedEvent.h>

//
#include <OrbitalInfo.h>
#include <RunInfo.h>
#include <FEVpamevcontrol.h>
//
class FEVdetector : public TObject {

 private:
  TCanvas *thefigure;
  TFile *file;
  TTree *otr;
  PamLevel2 *L2;
  pamela::PscuHeader *ph;
  pamela::EventHeader *eh;
  pamela::calorimeter::CalorimeterEvent *de;
  pamela::tracker::TrackerEvent *trk;     
  pamela::neutron::NeutronEvent  *ne;
  pamela::neutron::NeutronRecord *nr;
  pamela::anticounter::AnticounterEvent  *ace;
  pamela::S4::S4Event  *s4;
  pamela::trigger::TriggerEvent *trigger;     
  pamela::tof::TofEvent  *tof;
  OrbitalInfo *oinfoL2;
  ItoRunInfo *runinfo;
  PAMevcontrol *pamgui;
  Int_t *ctrlword;
  Int_t thisentry;
  Int_t b[4];
  Float_t mip[2][22][96];
  Bool_t defcalib;
  struct Calib calib;
  struct Evento evento;
  void ColorMIP(Float_t mip, int& colo);
  void ColorTOFMIP(Float_t mip, int& colo);
  void ColorTRKMIP(Float_t mip, int& colo, Int_t img);
  void ShowPalette();
  void ShowCalo(Bool_t upd);
  void ShowTRK(Bool_t upd);
  void ShowTrack();
  void ShowTOF();
  void ShowAC();
  void ShowS4(Bool_t upd);
  void ShowND();
  void Calo1stcalib();
  int OLDCaloFindCalibs();
  int CaloPede(Int_t s);
  void CaloFindBaseRaw(Int_t l, Int_t m, Int_t pre);
  void CaloCompressData(Int_t l, Int_t m, Int_t pre);

 public:
  struct Levels level;
  struct Variables var;
  Int_t lastevno;
  Int_t firstevno;
  Int_t si;
  //  Int_t jumpto;
  Int_t maxevent;
  Int_t minevent;
  Int_t headc;
  Int_t headcold;
  Int_t OBT;
  Int_t OOBT;
  Int_t DOBT;
  Int_t calotrig;
  Int_t toftrig;
  Int_t s4pulser;
  //  Int_t selection;
  //  Int_t doflag;
  //  Int_t seldone;
  TString trcs;
  //
  FEVdetector(TString filename, TString selfile, Int_t &mainctrlword, TCanvas &figure);
  void SetGUIPtr(PAMevcontrol &mainpamgui);
  void checkctrlword();
  void add(TString name);
  void Load(TTree &mainotr, TFile &mainfile);
  void GetWindow();
  void ClearVariables();
  void GetEntry(Int_t i);
  void SetEntry(Int_t i);
  void GetGeneralInfo();
  void DisplayEvent();
  void DrawX(Float_t cx, Float_t cy, Float_t si, Variables & var);
  int GetThisEntry(){return (thisentry);};
  int GetCounter();
  int SelectEvent();
};

#endif
