*************************************************************************
*     
*     Common common_B_inner.f
*     
*     to be included in:
*     - ../magnet/read_B_inner.f
*     - ../magnet/inter_B.f
*     - ../magnet/inter_B_inner.f
*     
*************************************************************************

c      implicit double precision (a-h,o-z)


      parameter (nx=29, ny=23, nz=101) !number of measures along X, Y and Z axes

c     coordinates in m of the edges of the volume in which the field
c     is interpolated according to the inner maps
      parameter (edgexmin=-0.085,edgexmax=0.085
     $     ,edgeymin=-0.07,edgeymax=0.07
     $     ,edgezmin=-0.26,edgezmax=0.26)

************
c     first map
      double precision px1(nx,3),py1(ny,3),pz1(nz,3) !coordinates of measure points:
c     e.g. py1(ny,1) = Y coordinates of Bx (=1) component of magnetic field

      double precision b1(nx,ny,nz,3)     !magnetic field values:
c     e.g. b1(nx,ny,nz,2) = By (=2) component of magnetic field measured in (nx, ny, nz)

      double precision px1max(3),px1min(3),py1max(3),
     &     py1min(3),pz1max(3),pz1min(3) !grid edges

      common/interpolation1/px1,py1,pz1,b1
     &     ,px1max,px1min,py1max,py1min,pz1max,pz1min
      save/interpolation1/
      
************
c     second map
      double precision px2(nx,3),py2(ny,3),pz2(nz,3)
      double precision b2(nx,ny,nz,3)
      double precision px2max(3),px2min(3),py2max(3),
     &     py2min(3),pz2max(3),pz2min(3)

      common/interpolation2/px2,py2,pz2,b2
     &     ,px2max,px2min,py2max,py2min,pz2max,pz2min
      save/interpolation2/
