#ifndef fevstruct_h
#define fevstruct_h

typedef struct Levels {
  Int_t file;
} level;

typedef struct Variables {
    Bool_t selex;
    Bool_t alrforc;
    Bool_t jumprog;
    Bool_t waitforever;
    Bool_t restart;
    Bool_t goon;
    Bool_t refresh;
    Bool_t fl0;
    Bool_t jumpen;
    Int_t tofraw;
    Int_t tofbest;
    Float_t sfx;  // scale factor x
    Float_t sfy;  // scale factor y
    Float_t xxvc; // x coordinate of the x-view
    Float_t yxvc; // y coordinate of the x-view
    Float_t xyvc; // x coordinate of the y-view
    Float_t yyvc; // y coordinate of the y-view
    Float_t xcat; // x coordinate of the cat view
    Float_t ycat; // y coordinate of the cat view
    Float_t nds4; // scaling factor for ND and S4
    Float_t rig;  // rigidity from the tracker (track number 1)
    Float_t chi2; // chi2 of the fitted track (track number 1)
    Float_t sbase[2][22][96]; // calorimeter old baselines
    Float_t DSPsig_par[12][3072]; //tracker sigma calibration data
    Float_t s4sig; // S4 calibrated signal
    Float_t beta[5]; // TOF beta infos    
    Int_t   bw; // black and white flag
    Int_t   nosig; // flag to show only detectors and no signals
    Int_t   etime; // time of the event (OBT)
    Int_t   headc; // event number 
    Int_t   nstrip; // strip hit, info from CALO
    Int_t   qtot; // total energy (MIP), info from CALO
    Int_t   nclx; // number of cluster in the x view, info from TRK
    Int_t   ncly; // number of cluster in the y view, info from TRK
    Int_t   trup; // number of neutron upper half, info from ND
    Int_t   bkup; // number of background neutron upper half, info from ND 
    Int_t   bkbo; // number of background neutron lower half, info from ND  
    Int_t   hcas; // number of hit in cas, info from AC
    Int_t   hcat; // number of hit in cat, info from AC
    Int_t   hcard;// number of hit in card, info from AC    
    Int_t tracknds4; // flag to display the track in ND and S4
    Int_t i; // event number
    Int_t doflag; //going forward or backward?
    Int_t jumpto; // event number to jump to
    Int_t lastevno; // last event number
    Int_t firstevno; // first event number
    Int_t SHOWDEC;
    Int_t TOF;
    Int_t AC;
    Int_t TRK;
    Int_t CALO;
    Int_t S4;
    Int_t ND;
    Int_t INFOS;
    Int_t VINFOS;
    Int_t PALETTE;
    Long64_t nevents; // number of events in the ntuple    
    TString thefilename;
    TString thefilter;
    TString svas;
} var;

typedef struct Evento {
    Float_t   dexy[2][22][96];
    Float_t   dexyc[2][22][96];
    Double_t  base[2][22][6];
} evento;    

typedef struct Calib {
    Int_t time[4][51];
    Int_t ttime[4][51];
    Int_t fcode[4][51];
    Int_t cstwerr[4];
    Float_t cperror[4];
    Float_t mip[2][22][96];
    Float_t calped[2][22][96];
    Float_t calgood[2][22][96];
    Float_t calthr[2][22][6];
    Float_t calrms[2][22][96];
    Float_t calbase[2][22][6];
    Float_t calvar[2][22][6];
    Float_t calpuls[2][22][96];
    Double_t sbase[2][22][6];
} calib;


#endif
