#ifndef __PAMevcontrolfun__
#define __PAMevcontrolfun__
#include <feventvstruct.h>
#include <TObjectTable.h>
#include <TGClient.h>
#include <TGButton.h>
#include <TGComboBox.h>
#include <TGLabel.h>
#include <TGTextEntry.h>
#include <TGFrame.h>
#include <TGButtonGroup.h>
#include <TGProgressBar.h>
#include <TGMsgBox.h>
#include <TGComboBox.h>
#include <TTree.h>
#include <TClassEdit.h>
#include <TObject.h>
#include <TList.h>
#include <TSystem.h>
#include <TSystemDirectory.h>
#include <TString.h>
#include <TFile.h>
#include <TClass.h>
#include <TCanvas.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2D.h>
#include <TLatex.h>
#include <TPad.h>
#include <TPaveLabel.h>
#include <TLine.h>
#include <TPolyLine.h>
#include <TChain.h>
#include <TApplication.h>
#include <TVirtualX.h>
#include <TGClient.h>
#include <TGWindow.h>
#include <TEllipse.h>
#include <TArrow.h>
#include <TStyle.h>
//
class CalorimeterCalibration : public TObject {
 public:
    CalorimeterCalibration();
    Int_t  status;
    TString fname;
    Float_t mip[2][22][96];  
    Float_t ermip[2][22][96];      
    Float_t fp[4][2][22][96]; 
    Float_t fpe[4][2][22][96]; 
    Float_t chi2[2][22][96];      
    Float_t ndf[2][22][96];      
    Float_t mask[2][22][96];
    ClassDef(CalorimeterCalibration,1);
};

//
// GUI
//
class PAMevcontrol : public TGMainFrame {

 private:
  TGHProgressBar *fHProg1;
  TGCheckButton *ffl0;
  TGCheckButton *ftrks4;
  TGTextButton *bstop;
  TGTextEntry *fText2;
  TGTextEntry *fText4;
  TGComboBox *fCombo;
  TCanvas *thefigure;
  struct Variables *cvar;
  struct Levels *clev;

 public:
  PAMevcontrol(const TGWindow *p,UInt_t w,UInt_t h,struct Variables & var, struct Levels & level, TCanvas &figure);
  virtual ~PAMevcontrol();
  void StopSearching();
  void SetSearching();
  void CheckLevel();
  void chktof();
  void chkac();
  void chktrk();
  void chkcalo();
  void chks4();
  void chknd();
  void chkinfo();
  void chknames();
  void chkpalette();
  void radiocolor();
  void radiobw();
  void radiotrack();
  void forcel0();
  void next();
  void prev();
  void stop();
  void SetFilename();
  void SetFilter();
  void jumpto();
  void radioevent();
  void radioprog();
  void saveas();
  void CompleteText();
  //  void Close();
  void increment(float val);
  void DIALOG(Int_t ty, TString warn);
  void clearselfi();
  void upgrnamfi();
  void Terminate();
  ClassDef(PAMevcontrol,1);
};

#endif
