*************************************************************************
*     
*     Subroutine read_B.f
*     
*     it calls the subroutines which read the magnetic field maps for
*     the PAMELA spectrometer
*     
*     needs:
*     - ./read_B_inner.f inner map reading subroutine
*     - ./read_B_outer.f outer map reading subroutine
*     
*     to be called before ./inter_B.f (interpolation subroutine)
*     
*************************************************************************

      function readb2maps(idata_dir)
c      subroutine read_B(idata_dir)
      CHARACTER*250 idata_dir
      integer lastnb2
c      integer lung
      parameter(NWPAWC=8500000)
      common/pawc/hmem(NWPAWC)
      save/pawc/
      common/quest/iquest(100)
      save/quest/
      call hlimit(nwpawc)
c
      lastnb2 = length(idata_dir)+1
c     call the subroutine which reads the maps of the measurements taken
c     inside the magnetic cavity
      call read_B_inner(idata_dir(1:lastnb2))

c     call the subroutine which reads the maps of the measurements taken
c     outside the magnetic cavity
cc      call read_B_outer(idata_dir(1:lastnb2))        

      return
      end

      include './read_B_inner.for'
c      include './read_B_outer.for' 

      
      integer function length(str)
c     return the string length without the blanks characters

      implicit integer (k-l)
      character *(*) str    
      
      lmax=len(str)      
       
c     search the last non blank character
      do i = 1, lmax
         if( str(i:i).eq.'.' )then
            length=i
            return
         endif
      enddo

      length=lmax

      return
      end     
      
