/** @file
 * $Source: /repository/event/tmtc/TmtcEvent.h,v $
 * $Id: TmtcEvent.h,v 1.1 2008-01-11 17:14:19 messineo Exp $
 * $Author: messineo $
 * 
 * Header file for the TmtcEvent class.
 */
#ifndef TMTC_EVENT_H
#define TMTC_EVENT_H


#include "TmtcRecord.h"
#include <TClonesArray.h>

using namespace std;

namespace pamela {
  /**
   * TmtcEvent data Wrapper.
   *
   * The TmtcEvent represents the "TmtcEvent" packet generated by the PAMELA CPU software
   * and is a collection of several requests to the PAMELA TMTC board.
   */
  class TmtcEvent: public pamela::SubPacket {
  private:
    static TClonesArray *fgRecords;
  public:
    
    TClonesArray* Records;
    
    TmtcEvent(void);
    ~TmtcEvent(void);
    
    ClassDef(TmtcEvent, 1)
  };
}

#endif /* TMTC_EVENT_H */

