/** @file
 * $Source: /repository/event/physics/anticounter/AnticounterEvent.h,v $
 * $Id: AnticounterEvent.h,v 1.1 2008-01-11 17:14:22 messineo Exp $
 * $Author: messineo $
 * 
 * Header file for the raw anticoincidence events
 */
#ifndef ANTICOUNTER_EVENT_H
#define ANTICOUNTER_EVENT_H

#include "../../SubPacket.h"
namespace pamela {
  /**
   * Namespace for all code related to the anticoincidence unit.
   */
  namespace anticounter {
    /**
     * Techmodel anticounter subpacket
     */
    class AnticounterEvent: public pamela::SubPacket {
    private:
 
    public:

      UINT16 header[2][2];
      UINT16 status[2];
      UINT16 hitmap[2];      
      UINT16 regist[2][6];   
      UINT16 shift[2][16];     
      UINT16 counters[2][16];  
      UINT16 coinc[2][8];
      UINT16 trigg[2];    
      UINT16 clock[2][2];        
      UINT16 temp[2][2];    
      UINT16 DAC[2][8];
      UINT16 CRC[2];
      UINT16 CRCcheck[2];
      UINT8  unpackError;
      

    AnticounterEvent(void);
      ~AnticounterEvent(void);

      ClassDef(AnticounterEvent, 2)
    };
  }
}
#endif /* ANTICOUNTER_EVENT_H */
