/** @file
 * $Source: /repository/event/physics/calorimeter/CalorimeterEvent.h,v $
 * $Id: CalorimeterEvent.h,v 1.1 2008-01-11 17:14:22 messineo Exp $
 * $Author: messineo $
 * 
 * Header file for the raw calorimeter events
 */
#ifndef CALORIMETER_EVENT_H
#define CALORIMETER_EVENT_H

#include "../../SubPacket.h"

namespace pamela {
  /** 
   * Namespace for all calorimeter related code.
   */
  namespace calorimeter {
    /**
     * Techmodel calorimeter data.
     */
    class CalorimeterEvent: public pamela::SubPacket {
    private:

    public:
      CalorimeterEvent(void);
      ~CalorimeterEvent(void);
        int iev;
        int stwerr[4];
        float perror[4];
        float dexy[2][22][96];
        float dexyc[2][22][96];
        float base[2][22][6];
        float calselftrig[4][7];
        float calIItrig[4];
        float calstriphit[4];
        float calDSPtaberr[4];
        float calevnum[4];

    /**
     * The data validity (to be defined).
     * 
     * Description:         <BR>
     */
        UINT8 unpackError;
      ClassDef(CalorimeterEvent, 2)
    };
  }
}
#endif /* CALORIMETER_EVENT_H */
