/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/event/mcmd/McmdRecord.h,v $
 * $Id: McmdRecord.h,v 1.1.1.1 2008/09/23 07:20:02 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Header file for the McmdRecord class.
 */
#ifndef MCMD_RECORD_H
#define MCMD_RECORD_H

#include <TArrayC.h>
#include "../SubPacket.h"
namespace pamela {
  /**
   * McmdRecord data Wrapper
   *
   * 
   * PAMELA CPU software collect several pamela::McmdRecord(s) writing
   * them on the MassMemory as a unique packet.
   */
  class McmdRecord: public TObject {

  public:
    /**
     * The On-Board-Time of the Record.
     */
    UINT32 MCMD_RECORD_OBT;
    
    /**
     * The Mcmd crc result.
     *
     * It specifies if the  Mcmd was transmitted correctly: <br>
     * 1 = Mcmd correctly transmitted <br>
     * 0 = Mcmd  not correctly transmitted
     */
    int  Mcmd_Block_crc_ok;

    /**
     * The Sequential ID of the MCMD.
     */
    UINT16         SeqID;

    /**
     * Identify if the Mcmd is a Tagged one or not.
     */
    UINT8          Tbit;

    /**
     * The MCMD identifier.
     */
    UINT8          ID1;

    /**
     * The Mcmd length.
     */
    UINT16         McmdLength;

    /**
     * The On-Board-Time for start the Mcmd if it is TimeTagged.
     */
    UINT32         TimeTag;

    /**
     * An array of chars containing the Mcmd data area.
     */
    TArrayC       *McmdData;

    /**
     * Modulo 256 sum of all bytes except the endID
     */
    UINT8          endID;


    McmdRecord(void);
        
    /*void setMcmdData(const BYTE val[]) {
      if (McmdLength > 0){
	McmdData = new BYTE[McmdLength];
	memcpy(McmdData, val, McmdLength);
      }
    };*/
    
    ClassDef(McmdRecord, 2)
  };
}

#endif /* MCMD_RECORD_H */

