/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/event/Exception.h,v $
 * $Id: Exception.h,v 1.1.1.1 2008/09/23 07:19:52 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Header file for the exceptions of Pamela.
 */
#ifndef EXCEPTION_H
#define EXCEPTION_H
#include <exception>
#include <stdio.h>

#define  UINT32 unsigned int
#define  UINT16 unsigned short
#define  UINT8  unsigned char

using namespace std;
namespace pamela {

  class Exception: public exception {
    
  private:
    
  protected:
    const char *message;
    char buff [100];
  public:
    Exception(const char *msg = "message"): message(msg){ }
    virtual ~Exception () throw(){ }
    virtual const char* print () const throw () { return message; }
  };

  //marco:
  class CalibException: public Exception {
  public:
	  CalibException(const char* msg):  Exception(msg) {}
	  ~CalibException () throw(){ }
  };
  
  //marco:
  class WrongCRCException_PKTUsed: public Exception {
  public:
	  WrongCRCException_PKTUsed(const char* msg):  Exception(msg) {}
	  ~WrongCRCException_PKTUsed () throw(){ }
  };

  //marco:  
  class FatalException: public Exception {
  public:
	  FatalException(const char* msg):  Exception(msg) {}
	  ~FatalException () throw(){ }
  };
  
  class NotFoundEnvironmentVarException: public Exception {
    public:
      NotFoundEnvironmentVarException(const char* msg):  Exception(msg) {}
      ~NotFoundEnvironmentVarException () throw(){ }
    };

  class UnidentifiedPacketException: public Exception {
  private:
    UINT8     pktId;
  public:
    UnidentifiedPacketException(UINT8 id): 
    Exception("Unidentified PacketType - Id: ") {
        pktId = id;
    }
    ~UnidentifiedPacketException () throw(){ }
    const char* print () const throw () { 
        sprintf((char*)buff," %s 0x%x", message, pktId);
        return buff;
    }
  };

  class WrongCRCException: public Exception {
  public:
    WrongCRCException(const char* msg):  Exception(msg) {}
    ~WrongCRCException () throw(){ }
  };

  class WrongCRCHeaderException: public Exception {
  public:
    WrongCRCHeaderException(const char* msg):  Exception(msg) {}
    ~WrongCRCHeaderException () throw(){ }
  };


  class LengthException: public Exception {
  public:
    LengthException(const char* msg):  Exception(msg) { }
    ~LengthException () throw(){ }
  };


  class NotExistingAlgorithmException: public Exception {
  public:
    NotExistingAlgorithmException(const char *msg):  Exception(msg) { }
    ~NotExistingAlgorithmException () throw(){ }
  };
  
  class NotExistingCounterException: public Exception {
  public:
    NotExistingCounterException(const char *msg):  Exception(msg) { }
    ~NotExistingCounterException () throw(){ }
  };

  class BackwardCounterException: public Exception {
  public:
    BackwardCounterException(const char *msg):  Exception(msg) { }
    ~BackwardCounterException () throw(){ }
  };
}
#endif /* EXCEPTION_H */
