/**     @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/chewbacca/event/EventCounter.h,v $
 * $Id: EventCounter.h,v 1.5 2010/02/11 09:02:15 mocchiut Exp $
 * $Author: mocchiut $
 * 
 * Header file for the EventCounter class.
 */
#ifndef EVENTCOUNTER_H
#define EVENTCOUNTER_H

#include "Exception.h"
#include "PacketType.h"
#include <TObject.h>
#include <TClonesArray.h>

namespace pamela {

    class mapval: public TObject {
    private:
	
    public:
	mapval();
	~mapval(){this->Clear();};
	mapval(TString n, Int_t *i);
	mapval(const mapval &val);	
	//	Int_t fN; //
	Int_t *count; //!
	TString name; //!
	void Clear(Option_t *t="") { name.Clear(); name.Resize(0); count=0;};
	mapval* GetMapVal(){return this;};
	ClassDef(mapval, 1);
    };
    
    class mappa: public TObject {
    private:
	Bool_t fend;
	Int_t entries;
	TClonesArray *val;
	
    public:
	mappa();
	~mappa(){this->Clear();};
	void Clear(Option_t *t="");
	void Delete(Option_t *t="");
	//
	int GetEntries(){ return val->GetEntries();};
	void Insert(TString, Int_t *);
	mapval* Find(TString);
	mapval* Get(Int_t i){ return ((mapval*)val->At(i));};
	Bool_t end(){ return fend;};
	void Set();
	ClassDef(mappa, 2);
    };


  /**
   * Event counter. Contains the event numbers of the last read event of 
   * each event type.
   */
  class EventCounter : public TObject {
  private:
 
    int RunNumber;    /**< Run number */
    int Pscu;
    int PhysEndRun;
    int CalibCalPulse1;
    int CalibCalPulse2;
    int Physics;
    int CalibTrkBoth;
    int CalibTrk1;
    int CalibTrk2;
    int CalibCal;
    int CalibTof;
    int CalibS4;
    int CalibCalPed;
    int Calib1_Ac1;
    int Calib1_Ac2;
    int Calib2_Ac1;
    int Calib2_Ac2;
    int RunHeader;
    int RunTrailer;
    int CalibHeader;
    int CalibTrailer;
    int InitHeader;
    int InitTrailer;
    int EventTrk;
    int Log;
    int VarDump;
    int ArrDump;
    int TabDump;
    int Tmtc;
    int Mcmd;
    int ForcedFECmd;
    int Ac1Init;
    int CalInit;
    int TrkInit;
    int TofInit;
    int TrgInit;
    int NdInit;
    int S4Init;
    int Ac2Init;
    int CalAlarm;
    int Ac1Alarm;
    int TrkAlarm;
    int TrgAlarm;
    int TofAlarm;
    int S4Alarm;
    int Ac2Alarm;
    int TsbT;
    int TsbB;

    mappa CMap;

  public:
    EventCounter(int = 0);
    ~EventCounter(){this->Clear();};
    /** Get the run number for the last read event of this type. */
    int getPscu() const { return Pscu; };
    /** Get the run number for the last read event of this type. */
    int Get(pamela::PacketType const *) throw (NotExistingCounterException);
    /** Get the run number for the next event of this type. */
    int Next(pamela::PacketType const *) throw (NotExistingCounterException);
    int GetRunNumber(void) const { return RunNumber; }
    void Increment(pamela::PacketType const *) throw (NotExistingCounterException);
    void PrintCounters();
    void Clear(Option_t *t=""){CMap.Clear();};
    ClassDef(EventCounter, 10)
  };
}

#endif /* EVENTCOUNTER_H */


