#ifndef CALIBCALPED_EVENT_H
#define CALIBCALPED_EVENT_H

#include "SubPacket.h"

namespace pamela {
  /**
   * CalibCalPed data Wrapper.
   *
   * The pamela::CalibCalPed packet is the answer to a calibration session of the Tracker.
   * It is the result of the mean over ~1000 events without particles (how this is done, is out of the 
   * scope of the document, but mostly should be executed at an high rate while PAMELA is passing over 
   * the Earth Equator). 
   */
  class CalibCalPedEvent: public pamela::SubPacket {
  private:
   
  public:
    CalibCalPedEvent(void);

    /**
     * A Counter.
     */   
    int   iev;

    /**
     * The Status Word of each section.
     */   
    int   cstwerr[4];

    /**
     * The Error Code for each section.
     */   
    float cperror[4];

    /**
     * The pedestal value (ADC) for each strip in the calorimeter.
     * The array represent the 4 sections x 11 layers x 96 strips composing the calorimeter.
     */   
    float calped[4][11][96];

    /**
     * Define if the strip is used or not in the baseline calculation.
     * The array represent the 4 sections x 11 layers x 96 strips composing the calorimeter.
     * Description:                  <BR>
     * 0x00: The strip was used.     <BR>
     * 0xFF: The strip was NOT used. <BR>
     */       
    float calgood[4][11][96];

    /**
     * The hardware ADC thresholds for the preamplifiers.
     * The array represent the 4 sections x 11 layers x 6 amplifiers composing the calorimeter.
     */   
    float calthr[4][11][6];

    /**
     * The pedestal RMS value for each strip in the calorimeter.
     * The array represent the 4 sections x 11 layers x 96 strips composing the calorimeter.
     */   
    float calrms[4][11][96];

    /**
     * The hardware ADC baseline for the preamplifiers.
     * The array represent the 4 sections x 11 layers x 6 amplifiers composing the calorimeter.
     */
    float calbase[4][11][6];

    /**
     * The variance of the baselines for the preamplifiers.
     * The array represent the 4 sections x 11 layers x 6 amplifiers composing the calorimeter.
     */
    float calvar[4][11][6];


    //float calpuls[4][11][96];
    UINT8 unpackError;

    ClassDef(CalibCalPedEvent, 2)
  };
}

#endif /* CALIBCALPED_EVENT_H */

