/** @file
 * $Author: messineo $
 * $Date: 2008-01-11 17:14:21 $
 * $Version: 1.1 $
 * 
 * Header file for the SubPacket class.
 */

////#include <log4cxx/logger.h>

#include "SubPacket.h"

////static log4cxx::LoggerPtr logger = log4cxx::Logger::getLogger(_T("pamela.techmodel.EventCounter"));

using namespace pamela;

/**
 * Constructor for the SubPacket.
 * @param name Name of the SubPacket.
 * @param type Packet type.
 * @param detector SubDetector, if the SubPacket is detector specific.
 */
SubPacket::SubPacket(std::string name, const PacketType* type, 
		     const SubDetector* detector): 
    SubPacketName(name), Type(type), Detector(detector) {
}

/**
 * Default constructor. Note that this should never be used; it is here 
 * just for some thumb requirements of ROOT.
 */
SubPacket::SubPacket(void): SubPacketName("ERROR"), Type(0), Detector(0) {
}

ClassImp(SubPacket)
