/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: CRC.c,v 1.1 2008-01-11 17:14:19 messineo Exp $
 *  $Revision: 1.1 $
 *  $Date: 2008-01-11 17:14:19 $
 *  $RCSfile: CRC.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: messineo $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          
 
 *****************************************************************************/


/*============================= Include File ================================*/
//marco
//#include <CRC.h>
#include "CRC.h"


/*============================ Global define ================================*/


/*============================== global types  ==============================*/



/*****************************************************************************/
/*=========================== Structure define ==============================*/


/*****************************************************************************/
/*============================ Enumerate define =============================*/

/*****************************************************************************/

/*=== Common   I N T E R N A L   ==*/

/*****************************************************************************/

/*************************************************************************/
/* @Constant: Ccrc_lookup                                                */
/* @Purpose :                                                            */
/*   CRC-TABLE CRCINIT=0x0000 POLY=0x1021 CCITT V.41                     */
/*                                                                       */
/* @@                                                                    */
/*************************************************************************/

static const unsigned int Crc_lookup[256] = {
    0x0000,0x1021,0x2042,0x3063,0x4084,0x50A5,0x60C6,0x70E7,
    0x8108,0x9129,0xA14A,0xB16B,0xC18C,0xD1AD,0xE1CE,0xF1EF,
    0x1231,0x0210,0x3273,0x2252,0x52B5,0x4294,0x72F7,0x62D6,
    0x9339,0x8318,0xB37B,0xA35A,0xD3BD,0xC39C,0xF3FF,0xE3DE,
    0x2462,0x3443,0x0420,0x1401,0x64E6,0x74C7,0x44A4,0x5485,
    0xA56A,0xB54B,0x8528,0x9509,0xE5EE,0xF5CF,0xC5AC,0xD58D,
    0x3653,0x2672,0x1611,0x0630,0x76D7,0x66F6,0x5695,0x46B4,
    0xB75B,0xA77A,0x9719,0x8738,0xF7DF,0xE7FE,0xD79D,0xC7BC,
    0x48C4,0x58E5,0x6886,0x78A7,0x0840,0x1861,0x2802,0x3823,
    0xC9CC,0xD9ED,0xE98E,0xF9AF,0x8948,0x9969,0xA90A,0xB92B,
    0x5AF5,0x4AD4,0x7AB7,0x6A96,0x1A71,0x0A50,0x3A33,0x2A12,
    0xDBFD,0xCBDC,0xFBBF,0xEB9E,0x9B79,0x8B58,0xBB3B,0xAB1A,
    0x6CA6,0x7C87,0x4CE4,0x5CC5,0x2C22,0x3C03,0x0C60,0x1C41,
    0xEDAE,0xFD8F,0xCDEC,0xDDCD,0xAD2A,0xBD0B,0x8D68,0x9D49,
    0x7E97,0x6EB6,0x5ED5,0x4EF4,0x3E13,0x2E32,0x1E51,0x0E70,
    0xFF9F,0xEFBE,0xDFDD,0xCFFC,0xBF1B,0xAF3A,0x9F59,0x8F78,
    0x9188,0x81A9,0xB1CA,0xA1EB,0xD10C,0xC12D,0xF14E,0xE16F,
    0x1080,0x00A1,0x30C2,0x20E3,0x5004,0x4025,0x7046,0x6067,
    0x83B9,0x9398,0xA3FB,0xB3DA,0xC33D,0xD31C,0xE37F,0xF35E,
    0x02B1,0x1290,0x22F3,0x32D2,0x4235,0x5214,0x6277,0x7256,
    0xB5EA,0xA5CB,0x95A8,0x8589,0xF56E,0xE54F,0xD52C,0xC50D,
    0x34E2,0x24C3,0x14A0,0x0481,0x7466,0x6447,0x5424,0x4405,
    0xA7DB,0xB7FA,0x8799,0x97B8,0xE75F,0xF77E,0xC71D,0xD73C,
    0x26D3,0x36F2,0x0691,0x16B0,0x6657,0x7676,0x4615,0x5634,
    0xD94C,0xC96D,0xF90E,0xE92F,0x99C8,0x89E9,0xB98A,0xA9AB,
    0x5844,0x4865,0x7806,0x6827,0x18C0,0x08E1,0x3882,0x28A3,
    0xCB7D,0xDB5C,0xEB3F,0xFB1E,0x8BF9,0x9BD8,0xABBB,0xBB9A,
    0x4A75,0x5A54,0x6A37,0x7A16,0x0AF1,0x1AD0,0x2AB3,0x3A92,
    0xFD2E,0xED0F,0xDD6C,0xCD4D,0xBDAA,0xAD8B,0x9DE8,0x8DC9,
    0x7C26,0x6C07,0x5C64,0x4C45,0x3CA2,0x2C83,0x1CE0,0x0CC1,
    0xEF1F,0xFF3E,0xCF5D,0xDF7C,0xAF9B,0xBFBA,0x8FD9,0x9FF8,
    0x6E17,0x7E36,0x4E55,0x5E74,0x2E93,0x3EB2,0x0ED1,0x1EF0
    };








/*****************************************************************************/
/*  
 *  TRK_crc8_8
 *
 *  calculate single 8 bit crc  
 *
 *  Input parameters: 
 *                   old  = old value 
 *                   data = new value   
 *                   outcrc = pointer to calculated crc  
 *                 
 *  Output parameters: status_code
 *
 */
/*****************************************************************************/

typedef union  {
  BYTE word;

//#ifdef ERC32
  /* ERC 32 arch is BIG endian */
/*  struct bit_field_w 
  {
    unsigned b7:1;
    unsigned b6:1;
    unsigned b5:1;
    unsigned b4:1;
    unsigned b3:1;
    unsigned b2:1;
    unsigned b1:1;
    unsigned b0:1;
  } bit; 
#else*/
  /* IA32 arch is LITTLE endian */
  struct bit_field_w 
  {
    unsigned b0:1;
    unsigned b1:1;
    unsigned b2:1;
    unsigned b3:1;
    unsigned b4:1;
    unsigned b5:1;
    unsigned b6:1;
    unsigned b7:1;
  } bit;
//#endif
} CM_crc8_8_word ;


#define CM_CRC8_8(old,data,crc,c,d,r) do { \
  c.word = (old);   \
  d.word = (data);  \
  r.bit.b0  = c.bit.b0  ^ c.bit.b6 ^ c.bit.b7 ^ d.bit.b0  ^ d.bit.b6 ^ d.bit.b7;                       \
  r.bit.b1  = c.bit.b0  ^ c.bit.b1 ^ c.bit.b6 ^ d.bit.b0  ^ d.bit.b1 ^ d.bit.b6;                       \
  r.bit.b2  = c.bit.b0  ^ c.bit.b1 ^ c.bit.b2 ^ c.bit.b6  ^ d.bit.b0 ^ d.bit.b1 ^d.bit.b2 ^ d.bit.b6;  \
  r.bit.b3  = c.bit.b1  ^ c.bit.b2 ^ c.bit.b3 ^ c.bit.b7  ^ d.bit.b1 ^ d.bit.b2 ^d.bit.b3 ^ d.bit.b7;  \
  r.bit.b4  = c.bit.b2  ^ c.bit.b3 ^ c.bit.b4 ^ d.bit.b2  ^ d.bit.b3 ^ d.bit.b4;                       \
  r.bit.b5  = c.bit.b3  ^ c.bit.b4 ^ c.bit.b5 ^ d.bit.b3  ^ d.bit.b4 ^ d.bit.b5;                       \
  r.bit.b6  = c.bit.b4  ^ c.bit.b5 ^ c.bit.b6 ^ d.bit.b4  ^ d.bit.b5 ^ d.bit.b6;                       \
  r.bit.b7  = c.bit.b5  ^ c.bit.b6 ^ c.bit.b7 ^ d.bit.b5  ^ d.bit.b6 ^ d.bit.b7;                       \
  crc = r.word; \
} while(0)


BYTE CM_crc8_8(BYTE old,BYTE data) {
  CM_crc8_8_word c,d,r;
  BYTE Crc;

  CM_CRC8_8(old,data,Crc,c,d,r);

  return Crc;
} 

/**
   Compute a 8 CRC based over a \a buffer data of length \a length, whith a starting crc of \a oldcrc
   and returns the 32 bit crc on the whole buffer
 */ 
UINT32 CM_Compute_CRC8_8(UINT32 oldcrc /** the starting CRC value. changing this value also change the returning value. usually 0. */
			 ,BYTE *buffer /** the starting pointer to start crc computing */
			 ,UINT32 length  /** the length in byte of the buffer */
			 )
{
  int i;
  BYTE tmpcrc,crc = oldcrc;
  CM_crc8_8_word c,d,r;

  for (i=0; i < length; i++) {
    tmpcrc=crc;
    CM_CRC8_8(tmpcrc,*buffer,crc,c,d,r);
    buffer++;
  }
  return crc;
}


/*****************************************************************************/
/* @Function: CM_Crc16                                                       */
/* @Purpose :                                                                */
/*  This function calculates the CRC.                                        */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/* @@                                                                        */
/*****************************************************************************/

/* adrs_ptr: is BYTE*
 * crc     : is UINT16
 */
#define CM_MACRO_CRC16(Crc16,adrs_ptr) do { \
  Crc16 = \
    (UINT32)(Crc16 << 8) ^ \
    (UINT32)(Crc_lookup[ (UINT32) ( ((Crc16 >> 8) & 0xFF) ^ *adrs_ptr) ]); \
} while(0)

UINT16 CM_CRC16(BYTE* adrs, UINT16 Crc)
{
  UINT32 Crc16Value=Crc;
  // Calculating the CRC16 by using a LookUp table
  CM_MACRO_CRC16(Crc16Value,adrs);
  return ((UINT16)Crc16Value);
}

UINT16 CM_Compute_CRC16(UINT16 oldcrc,BYTE *buffer,UINT32 length) {
  unsigned int i;
  UINT32 Crc16Value=oldcrc;
  for (i=0; i < length; i++) {
    CM_MACRO_CRC16(Crc16Value,buffer);
    buffer++;
  }
  return ((UINT16)Crc16Value);
}

BYTE* charToUnsignedChar(char *buffer, UINT32 length){
    BYTE buff[length];
    unsigned int i;
    for (i=0; i < length; i++){
        buff[i] = (BYTE)buffer[i];
    }
    
}

