/** @file
 * $Source: /repository/event/RunInfoYoda.h,v $
 * $Id: RunInfoYoda.h,v 1.1 2008-03-11 14:26:19 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the default functions of the Algorithm class.
 */
#ifndef RUN_INFO_YODA_H
#define RUN_INFO_YODA_H

//#include "root/TObject.h"
//#include "root/TString.h"

#include <TObject.h> //Substituted by Maurizio 05 Feb 2004
#include <TString.h> //Substituted by Maurizio 05 Feb 2004

namespace pamela {
  class PamelaRun;
  /**
   * Information about a data processing run: Who did it, where did he it,
   * when the data were processed etc.
   */
  class RunInfoYoda: public TObject {
  private:
    TString UserName;
    TString HostName;
    TString DataPath;
    TString Time;
    int RunNumber;
  public:
    RunInfoYoda(pamela::PamelaRun*);
    RunInfoYoda(void);
    virtual ~RunInfoYoda(void);
    ClassDef(RunInfoYoda, 1)
  };
}

#endif /* RUN_INFO_YODA_H */
