DROP DATABASE IF EXISTS dbname;

CREATE DATABASE dbname;

USE dbname;

SET time_zone='+0:00';

CREATE TABLE `_RUNID_GEN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  PRIMARY KEY  (`ID`)
);

CREATE TABLE `GL_RAW` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `BOOT_NUMBER` smallint(5) unsigned default NULL,
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PATH_index` (`PATH`)
) ;

INSERT INTO GL_RAW VALUES(0,'$PAM_L2','level2 files',NULL,NULL);

CREATE TABLE `GL_ROOT` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `PATH_index` (`PATH`)
) ;

CREATE TABLE `GL_RESURS_OFFSET` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `FROM_ORBIT` int(10) unsigned NOT NULL default '0' COMMENT 'if dwlimit = dworbit the file takes the OLD resurs 0 -- SELECT YEAR(OFFSET_DATE),MONTH(OFFSET_DATE),DAY(OFFSET_DATE),HOUR(OFFSET_DATE),MINUTE(OFFSET_DATE),SECOND(OFFSET_DATE),ID FROM GL_RESURS_OFFSET WHERE FROM_ORBIT< "  << dworbit << " AND SPECIAL_FILE="" order by FROM_ORBIT desc limit 1;',
  `SPECIAL_FILE` varchar(255) NOT NULL default '',
  `OFFSET_DATE` timestamp default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ;

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','','2006-06-14 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'1619','','2006-09-28 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'2797','','2006-12-12 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'3221','','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_002_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_003_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_002_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_003_001_cln1.pam','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'4576','','2007-04-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'5960','','2007-07-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','07408_003_001_cln1.pam','2007-07-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'7382','','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'8580','','2007-12-25 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_002_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_003_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_001_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_003_cln1.pam','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'9908','','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_003_001_cln1.pam','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_002_001_cln1.pam','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_001_002_cln1.pam','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'11300','','2008-06-19 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'12634','','2008-09-18 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14033_201_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14034_001_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'14044','','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_002_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_003_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_002_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_003_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_504_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15445_002_001_cln1.pam','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'15430','','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_001_cln1.pam','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'16740','','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18156_072_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_072_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_073_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_122_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_123_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_132_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_133_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_152_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_153_001_cln1.pam','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'18150','','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19526_072_001_cln1.pam','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19539_073_001_cln1.pam','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'19525','','2009-12-08 21:00:00',NULL);




CREATE TABLE `GL_TIMESYNC` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RAW` int(10) unsigned NOT NULL default '0',
  `ID_RESURS_OFFSET` int(10) unsigned NOT NULL default '0',
  `OBT0` int(10) unsigned NOT NULL default '0',
  `TIMESYNC` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_RAW_index` (`ID_RAW`),
  KEY `TYPE_index` (`TYPE`)
) ;

CREATE TABLE `GL_PARAM` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `PATH` varchar(255) NOT NULL default '',
  `NAME` varchar(255) NOT NULL default '',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `TYPE` smallint(5) unsigned NOT NULL default '0',
  `DESCR` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `PATH_index` (`PATH`),
  KEY `NAME_index` (`NAME`),
  KEY `TYPE_index` (`TYPE`),
  KEY `DESCR_index` (`DESCR`)
) ;

insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","field_param-0/",0,0,1,"field",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mip_param-0/",0,0,2,"trk mip",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","charge_param-1/",0,0,3,"trk charge",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","eta_param-2/",0,0,4,"trk pfa",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","align_param-080805-GL1from7/",0,0,5,"trk alignment",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-id0/",1,         1150876185,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID0/",1150876185,1152619600,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID1/",1152619600,1153273957,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID2/",1153273957,1153307807,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID3/",1153307807,1153439464,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID4/",1153439464,1153447067,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID3/",1153447067,1154385336,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID5/",1154385336,1154390143,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID6/",1154390143,1154746486,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID7/",1154746486,1155728075,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID8/",1155728075,1155987238,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID9/",1155987238,1156179269,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID10/",1156179269,1156184911,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID11/",1156184911,1156438857,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID12/",1156438857,1156591164,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID13/",1156591164,1156833624,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID14/",1156833624,1156839268,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID13/",1156839268,1157165000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID15/",1157165000,1158610519,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID16/",1158610519,1158659245,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID17/",1158659245,1158661285,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID18/",1158661285,1158666824,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID16/",1158666824,1159135000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID19/",1159135000,1160246000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20/",1160246000,1160454893,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID21/",1160454893,1160578979,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID22/",1160578979,1161554748,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20/",1161554748,1161605509,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID23/",1161605509,1161639348,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID20/",1161639348,1161955293,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24/",1161955293,1161994774,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID25/",1161994774,1162000413,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24/",1162000413,1162022874,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID26/",1162022874,1162232000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID27/",1162232000,1162338713,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID28/",1162338713,1162434592,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29/",1162434592,1162550280,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID30/",1162550280,1162682748,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID29/",1162682748,1162987298,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID31/",1162987298,1163184789,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID24/",1163184789,1163280464,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID31/",1163280464,1163387718,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID32/",1163387718,1163568187,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID33/",1163568187,1164585000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID34/",1164585000,1164622760,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID35/",1164622760,1164791492,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID36/",1164791492,1165011869,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID37/",1165011869,1165137732,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38/",1165137732,1165141973,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID39/",1165141973,1165152773,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID40/",1165152773,1165158487,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38/",1165158487,1165840826,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID41/",1165840826,1165950000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID38/",1165950000,1166308856,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID42/",1166308856,1166703576,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID43/",1166703576,1166815000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1166815000,1166912110,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45/",1166912110,1166934766,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1166934766,1166951682,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45/",1166951682,1166957219,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1166957219,1167053100,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID45/",1167053100,1167058739,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID44/",1167058739,1167075633,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167075633,1167081271,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47/",1167081271,1167109565,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167109565,1167115205,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47/",1167115205,1167126481,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167126481,1167137661,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID47/",1167137661,1167154577,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID46/",1167154577,1167234541,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID48/",1167234541,1167256073,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID49/",1167256073,1167335114,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID50/",1167335114,1167728734,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID51/",1167728734,1167730650,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID50/",1167730650,1167735462,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID52/",1167735462,1168051125,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID53/",1168051125,1168118888,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID54/",1168118888,1168124527,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID55/",1168124527,1168502207,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID56/",1168502207,1168609440,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID57/",1168609440,1168660085,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID58/",1168660085,1168727846,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID59/",1168727846,1168795408,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID60/",1168795408,1168874446,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID61/",1168874446,1168891360,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID62/",1168891360,1168896898,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID61/",1168896898,1168959022,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID63/",1168959022,1168970298,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID64/",1168970298,1169060513,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID65/",1169060513,1169534050,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID66/",1169534050,1169861044,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID67/",1169861044,1169996460,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID68/",1169996460,1170019014,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID69/",1170019014,1170126038,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID70/",1170126038,1170408039,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID71/",1170408039,1170419316,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID72/",1170419316,1170892804,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID73/",1170892804,1170937907,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID74/",1170937907,1171265004,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID75/",1171265004,1171366385,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID76/",1171366385,1171890799,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID77/",1171890799,1171997816,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID78/",1171997816,1172009092,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID77/",1172009092,1172088119,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID78/",1172088119,1172093656,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID79/",1172093656,1172217685,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID80/",1172217685,1172257150,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID81/",1172257150,1172268426,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID82/",1172268426,1172291075,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID83/",1172291075,1172403831,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID84/",1172403831,1172482657,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID85/",1172482657,1172561584,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID86/",1172561584,1172668700,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID87/",1172668700,1172674438,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID88/",1172674438,1172809741,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID87/",1172809741,1172821015,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID89/",1172821015,1172860479,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID90/",1172860479,1172995781,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID91/",1172995781,1173164908,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID92/",1173164908,1173305830,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID93/",1173305830,1173700366,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID94/",1173700366,1173739829,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID95/",1173739829,1173754000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID96/",1173754000,1174241650,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID97/",1174241650,1174280000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID98/",1174280000,1174309299,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID97/",1174309299,1174399494,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID96/",1174399494,1174489791,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID99/",1174489791,1174574249,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID100/",1174574249,1174613709,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID101/",1174613709,1174675617,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID102/",1174675617,1174799735,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID103/",1174799735,1175732000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID104/",1175732000,1175741113,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID105/",1175741113,1175746750,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID106/",1175746750,1176141323,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID102/",1176141323,1177110000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID107/",1177110000,1177477096,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID108/",1177477096,1177634000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID109/",1177634000,1177883026,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID108/",1177883026,1177977924,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID102/",1177977924,1178012562,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID101/",1178012562,1178159210,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID110/",1178159210,1178204299,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID111/",1178204299,1178677657,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID110/",1178677657,1178767838,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID112/",1178767838,1178875029,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID113/",1178875029,1178942564,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID114/",1178942564,1179179291,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID110/",1179179291,1179325936,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID115/",1179325936,1179511934,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID116/",1179511934,1180143195,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID117/",1180143195,1180154367,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID118/",1180154367,1180160105,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID117/",1180160105,1180537730,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID119/",1180537730,1180734994,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID120/",1180734994,1180746267,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID119/",1180746267,1180904079,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121/",1180904079,1181022438,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID122/",1181022438,1181033709,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121/",1181033709,1181264790,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID122/",1181264790,1181315515,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID121/",1181315515,1181326687,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID123/",1181326687,1181349331,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181349331,1181411329,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181411329,1181416964,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181416964,1181422599,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181422599,1181445044,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181445044,1181462053,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID123/",1181462053,1181484599,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181484599,1181620531,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181620531,1181625399,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181625399,1181681759,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181681759,1181715576,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID124/",1181715576,1181839668,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID125/",1181839668,1182902310,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID126/",1182902310,1182933051,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID127/",1182933051,1182949959,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID128/",1182949959,1183034397,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID129/",1183034397,1183389563,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1183389563,1183406472,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID131/",1183406472,1183474101,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1183474101,1183780000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID132/",1183780000,1183784078,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID133/",1183784078,1183795351,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID132/",1183795351,1183834700,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1183834700,1184009516,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID134/",1184009516,1184026424,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID135/",1184026424,1184032059,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID134/",1184032059,1184657543,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID130/",1184657543,1185460000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID136/",1185460000,1185829897,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID137/",1185829897,1185874903,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID138/",1185874903,1185926530,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID139/",1185926530,1186049691,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID140/",1186049691,1187216272,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID139/",1187216272,1187221908,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID141/",1187221908,1187695189,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID142/",1187695189,1187892528,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID143/",1187892528,1187942554,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID144/",1187942554,1188106675,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID145/",1188106675,1188117846,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID146/",1188117846,1188247457,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID147/",1188247457,1188292642,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID148/",1188292642,1188315181,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID149/",1188315181,1188422151,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID150/",1188422151,1188433423,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID151/",1188433423,1188605269,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID152/",1188605269,1188827890,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID153/",1188827890,1189188641,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID154/",1189188641,1189273170,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID155/",1189273170,1189335155,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID156/",1189335155,1189498572,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID157/",1189498572,1189510000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID158/",1189510000,1189532383,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID159/",1189532383,1189583101,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID160/",1189583101,1189616912,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID159/",1189616912,1189639372,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID161/",1189639372,1189892950,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID162/",1189892950,1190135238,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID163/",1190135238,1190676197,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID164/",1190676197,1190721379,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID163/",1190721379,1190760823,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID164/",1190760823,1190850882,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID165/",1190850882,1190969216,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID164/",1190969216,1191160802,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID163/",1191160802,1191205882,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID166/",1191205882,1191307310,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1191307310,1191955315,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID168/",1191955315,1192287786,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1192287786,1193285094,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID169/",1193285094,1193583719,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID170/",1193583719,1193611891,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID171/",1193611891,1193837267,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID170/",1193837267,1193875588,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID172/",1193875588,1193882442,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173/",1193882442,1194062742,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID174/",1194062742,1194090814,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID173/",1194090814,1194254208,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID166/",1194254208,1194259943,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1194259943,1194648710,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID175/",1194648710,1195031838,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1195031838,1195212133,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID176/",1195212133,1195437399,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID167/",1195437399,1195945000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID177/",1195945000,1196090956,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID178/",1196090956,1196243076,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID179/",1196243076,1196260078,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID180/",1196260078,1196305050,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID181/",1196305050,1196383927,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID182/",1196383927,1196688264,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID183/",1196688264,1196902358,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID184/",1196902358,1196941796,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID185/",1196941796,1198276949,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID186/",1198276949,1198282684,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID185/",1198282684,1198423431,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1198423431,1198462967,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID185/",1198462967,1198694001,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1198694001,1198958741,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID188/",1198958741,1199550280,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1199550280,1199612249,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID189/",1199612249,1199871295,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID190/",1199871295,1200048000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID189/",1200048000,1200070000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1200070000,1200367144,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID188/",1200367144,1200860000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID187/",1200860000,1201544421,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID191/",1201544421,1201769754,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID192/",1201769754,1201786753,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID193/",1201786753,1201978287,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID194/",1201978287,1202040000,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID195/",1202040000,1202062786,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID194/",1202062786,1202107850,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID196/",1202107850,1202141651,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID197/",1202141651,1202214782,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID198/",1202214782,1202502178,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID196/",1202502178,1202868235,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID199/",1202868235,1203054231,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID200/",1203054231,1203127758,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID201/",1203127758,1203285187,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID202/",1203285187,1203470979,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID203/",1203470979,1203600640,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID204/",1203600640,1203713302,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID201/",1203713302,1206326783,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID205/",1206326783,1206383107,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID206/",1206383107,1206563444,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-ID207/",1206563444,1206579876,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","mask_param-1/",    1206579876,4294967295,6,"trk mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/trk-param/","default_calib/",0,0,7,"default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP-dws2000.dat",1,1,101,"Calorimeter ADC to MIP from flight data dw serie 2000",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIP.dat",1,1,101,"Calorimeter ADC to MIP from ground data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloADC2MIPfc.dat",2,4294967295,101,"Calorimeter ADC to MIP from flight, relativistic particles",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_adc2mip_special0.dat",1,1172976488,110,"Calorimeter ADC to MIP from flight, special cases",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_adc2mip_special1.dat",1172976488,1190000000,110,"Calorimeter ADC to MIP from flight, special cases",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_adc2mip_special2.dat",1190000000,4294967295,110,"Calorimeter ADC to MIP from flight, special cases",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign.dat",1,1,102,"Calorimeter alignement",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flight.dat",1,1,102,"Calorimeter alignement with flight data",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flightEMS.dat",1,1,102,"Calorimeter alignement with flight data EM showers",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloAlign-flightINCp.dat",2,4294967295,102,"Calorimeter alignement with flight data, protons, Z alignment changed",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadMask.dat",1,1,103,"Calorimeter bad strip offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadMask18Xgood.dat",2,4294967295,103,"Calorimeter bad strip offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloDefaultCalib.root",0,0,104,"Calorimeter default calibration",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadPulsePre0.dat",1,1169000000,105," <0701 Calorimeter bad pre-amplifiers when pulsing offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","FCaloBadPulsePre1.dat",1169000001,4294967295,105," >0701 Calorimeter bad pre-amplifiers when pulsing offline mask",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_pre_neighbour.dat",1,4294967295,106," Calorimeter pre-amply neighbour correction table",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_pre_IIneighbour.dat",1,4294967295,107," Calorimeter pre-amply second neighbour correction table",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_si0.dat",1,1167619688,108,"Calorimeter cross-talk silicon effect",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_crosstalk_param_si1.dat",1167619689,4294967295,108,"Calorimeter cross-talk silicon effect",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_maxrms_plane0.dat",1,4294967295,109,"Calorimeter 4*rms threshold for each plane (default 26)",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_emin_strip0.dat",1,1167619688,111,"Calorimeter Emin threshold for each strip (default 0.7)",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/cal-param/","calo_emin_strip1.dat",1167619689,4294967295,111,"Calorimeter Emin threshold for each strip (default 0.7)",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_1.rz",1,1153660000,201," 0 - 07-23      -                       A       A       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_2.rz",1153660001,1154375000,201," 07-23 - 07-31   HV_D problems           B       B       july            Parameters_jul24-31.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_3.rz",1154375001,1155850000,201," 07-31 - 08-17   -                       C       C       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_4.rz",1155850001,1156280000,201," 08-17 - 08-22   HV_H&HV_N problems      D       D       august          Parameters_aug18-22.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_5.rz",1156280001,1158700000,201," 08-22 - 09-18  S115B failure	          E       E       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_5B.rz",1158700001,1165400000,201," 09-18 - 12-06                           5B       5B       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_6.rz",1165400001,1168490000,201," 12-06 - 01-11   December Tracker off/on F       F       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_7.rz",1168490001,1168940000,201," 01-11 - 01-16   HV_D problems           G       G       january         calper02.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_8.rz",1168940001,1169580000,201," 01-16 - 01-23   HV_F & HV_M problems    G       G       january         calper03.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_9.rz",1169580001,1170200000,201," 01-23 - 01-30                           H       H       .               calper04.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_10.rz",1170200001,1171000000,201," 01-30 - 02-09   30.1. Threshold changed I       I       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_11.rz",1171000001,1174665000,201," 02-09 - 03-23   09.2. Threshold changed J       J       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_12.rz",1174665001,1175000000,201," 03-23 - 03-27   HV_B problems           K       K       .               calper05.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_13.rz",1175000001,1176120000,201," 03-27 - 04-09                           L       L       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_14.rz",1176120001,1176800000,201," 04-09 - 04-17   HV_H problems           M       M       .               calper06.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_15.rz",1176800001,1178330000,201," 04-17 - 05-05   HV_E problems           N       N       .               calper08.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_16.rz",1178330001,1181322000,201," 05-05 - 06-08   HV_H problems           O       O       .               calper09.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_17.rz",1181322001,1182100000,201," 06-08 - 06-17                           P       P       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_18.rz",1182100001,1183030000,201," 06-17 - 06-28   HV_A problems (~2 days) Q       Q       ?",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_19.rz",1183030001,1184000000,201," 06-28 - 07-09                           R       R       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_20.rz",1184000001,1184570000,201," 07-09 - 07-16   HV_H problems           S       S       .               calper10.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_21.rz",1184570001,1185090000,201," 07-16 - 07-22                           T       T       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_22.rz",1185090001,1185212000,201," 07-22 - 07-23   HV_D problems           U       U       .               calper11.txt",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_23.rz",1185212001,1191100000,201," 07-23 - 09-29                           V       V       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_24.rz",1191100001,1191940000,201," 09-23 - 10-09   HV_D problems          24      24       standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_25.rz",1191940001,1195200000,201," 10-09 - 11-16                          25      25      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_26.rz",1195200001,1196230000,201," 11-16 - 11-28   Timing changes         26      26      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_27.rz",1196230001,1196280000,201," 11-28 - 11-28   HV_D problems          27      27      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_28.rz",1196280001,1206100000,201," 11-29 - 03-21                          28      28      standard",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_29.rz",1206100001,1206375600,201," 03-21 - 03-24   HV_C problems          29      29 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_30.rz",1206375601,1217989200,201," 03-24 - 08-06   good                    30      30      calper_30 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_31.rz",1217989201,1218550000,201," 08-06 - 08-12   HV_E problems ?         31      31      calper_31",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_32.rz",1218550001,1225789200,201," 08-12 - 11-04   good                    32      32      calper_32",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_33.rz",1225789201,1226566800,201," 11-04 - 11-13   HV_E problems ?         33      33      calper_33 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_34.rz",1226566801,1229400000,201," 11-13 - 12-16   good                    34      34      calper_34",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_35.rz",1229400001,1229470000,201," 12-16 - 12-17   HV_F probl. + HV_E (?)  35      35      calper_35",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_36.rz",1229470001,1229730000,201," 12-17 - 12-19   HV_E problems (?)       36      36      calper_36",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_37.rz",1229730001,1230318000,201," 12-19 - 12-26   good                    37      37      calper_37",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_38.rz",1230318001,1230410000,201," 12-26 - 12-27   HV_H problems           38      38      calper_38",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_39.rz",1230410001,1230768000,201," 12-27 - 12-31   good                    39      39      calper_39",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_41.rz",1230768001,1232496000,201," 09-01-01 09-01-20         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_42.rz",1232496001,1235347200,201," 09-01-21 09-02-22         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_43.rz",1235347201,1238544000,201," 09-02-23 09-03-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_44.rz",1238544001,1241136000,201," 09-04-01 09-04-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_45.rz",1241136001,1243814400,201," 09-05-01 09-05-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_46.rz",1243814401,1246406400,201," 09-06-01 09-06-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_47.rz",1246406401,1249084800,201," 09-07-01 09-07-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_48.rz",1249084801,1251763200,201," 09-08-01 09-08-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_49.rz",1251763201,1254355200,201," 09-09-01 09-09-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_50.rz",1254355201,1257033600,201," 09-10-01 09-10-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_51.rz",1257033601,1259625600,201," 09-11-01 09-11-30         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_52.rz",1259625601,1262304000,201," 09-12-01 09-12-31         good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","tofcalib_53.rz",1262304001,4294967295,201," >10-01-01        good",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","ToFCalibParam.txt",1,4294967295,202," GP ToF parameters ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","adcmonitor.100k.cut.dat",1,1,203," ToF dE/dx II order correction parameters ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","dedxmonitor.C.5d.8th.all.dat",1,1,203," ToF dE/dx II order correction parameters ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","dedxmonitor.He.8th.all.dat",1,1,203," ToF dE/dx II order correction parameters based on He",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","dedxmonitor.He.9th.all.dat",1,4294967295,203," ToF dE/dx II order correction parameters based on He 9th data reduction",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","attenuation.txt",1,4294967295,204," ToF attenuation parameter file ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","desaturation_position.txt",1,4294967295,205," ToF desaturation on position parameter file ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","BetheBloch.txt",1,4294967295,206," ToF BetheBloch parameter file ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","BetheBloch_betagt1.txt",1,4294967295,207," ToF Bethe-Bloch parameter file for beta gt1 ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/tof-param/","desaturation_beta.txt",1,4294967295,208," ToF desaturation on beta parameter file ",NULL);
insert into GL_PARAM values(0,"","",1182100001,1183030000,210," A connector ",NULL);
insert into GL_PARAM values(0,"","",1174665001,1175000000,211," B connector ",NULL);
insert into GL_PARAM values(0,"","",1206100001,1206375600,212," C connector ",NULL);
insert into GL_PARAM values(0,"","",1153660001,1154375000,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1168490001,1168940000,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1185090001,1185212000,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1191100001,1191940000,213," D connector ",NULL);
insert into GL_PARAM values(0,"","",1176800001,1178330000,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1217989201,1218547800,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1225789201,1226566800,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1229400901,1229700000,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1230318001,1230415200,214," E connector ",NULL);
insert into GL_PARAM values(0,"","",1168940001,1169580000,215," F connector ",NULL);
insert into GL_PARAM values(0,"","",1155850001,1156280000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1176120001,1176800000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1178330001,1181322000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1184000001,1184570000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1196230001,1196280000,217," H connector ",NULL);
insert into GL_PARAM values(0,"","",1168940001,1169580000,220," M connector ",NULL);
insert into GL_PARAM values(0,"","",1155850001,1156280000,221," N connector ",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05.dat",0,0,301,"igrf 2005",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","igrf05s.dat",0,0,302,"igrf 2010",NULL);
insert into GL_PARAM values(0,"$PAM_CALIB/orb-param/","SortQuat.txt",0,0,303,"Quaternion from Resurs",NULL);

CREATE TABLE `GL_TLE` (
  `ID` int(10) NOT NULL auto_increment,
  `TLE1` varchar(255) NOT NULL default '',
  `TLE2` varchar(255) NOT NULL default '',
  `TLE3` varchar(255) NOT NULL default '',
  `FROM_TIME` datetime NOT NULL default '0000-00-00 00:00:00',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`)
) ;

CREATE TABLE `GL_RUN` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S3S2S12` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S11CRC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `ID_ROOT_L2_index` (`ID_ROOT_L2`),
  KEY `COMPILATIONTS_index` (`COMPILATIONTIMESTAMP`),
  KEY `VALID_index` (`VALIDATION`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `CALDSPMASK_index` (`CAL_DSP_MASK`),
  KEY `EFF_WS_index` (`EFF_WRK_SCHEDULE`),
  KEY `FAV_WS_index` (`FAV_WRK_SCHEDULE`),
  KEY `RM_ACQ_AFTER_CALIB_index` (`RM_ACQ_AFTER_CALIB`),
  KEY `RM_ACQ_SETTING_MODE_index` (`RM_ACQ_SETTING_MODE`),
  KEY `ACQ_VAR_INFO_index` (`ACQ_VAR_INFO`),
  KEY `TRG_MODE_A_index` (`PRH_VAR_TRG_MODE_A`),
  KEY `TRG_MODE_B_index` (`PRH_VAR_TRG_MODE_B`),
  KEY `NEVENTS_index` (`NEVENTS`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `ID_RUN_fk_constraint` (`ID_ROOT_L0`),
  KEY `ID_RUN_L2_fk_constraint` (`ID_ROOT_L2`)
) ;

CREATE TABLE `GL_RUN_FRAGMENTS` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S3S2S12` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S11CRC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID`),
  KEY `ID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `ID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `NID_RUN_fk_constraint` (`ID_ROOT_L0`)
) ;

CREATE TABLE `GL_RUN_TRASH` (
  `ID_TRASH` int(10) unsigned NOT NULL auto_increment,
  `ID` int(10) unsigned NOT NULL default '0',
  `ID_RUN_FRAG` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `ID_ROOT_L2` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_TIME` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_OBT` int(10) unsigned NOT NULL default '0',
  `RUNHEADER_PKT` int(10) unsigned NOT NULL default '0',
  `RUNTRAILER_PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `EV_FROM` int(10) unsigned NOT NULL default '0',
  `EV_TO` int(10) unsigned NOT NULL default '0',
  `NEVENTS` int(10) unsigned NOT NULL default '0',
  `PKT_COUNTER` int(10) unsigned NOT NULL default '0',
  `PKT_READY_COUNTER` int(10) unsigned NOT NULL default '0',
  `COMPILATIONTIMESTAMP` int(10) unsigned NOT NULL default '0',
  `FAV_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `EFF_WRK_SCHEDULE` tinyint(3) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_A` int(10) unsigned NOT NULL default '0',
  `PRH_VAR_TRG_MODE_B` int(10) unsigned NOT NULL default '0',
  `ACQ_BUILD_INFO` int(10) unsigned NOT NULL default '0',
  `ACQ_VAR_INFO` smallint(5) unsigned NOT NULL default '0',
  `RM_ACQ_AFTER_CALIB` tinyint(3) NOT NULL default '0',	  
  `RM_ACQ_SETTING_MODE` tinyint(3) NOT NULL default '0',
  `TRK_CALIB_USED` int(10) unsigned NOT NULL default '0',
  `CAL_DSP_MASK` tinyint(3) unsigned NOT NULL default '0',
  `LAST_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `OBT_TIMESYNC` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S3S2S12` int(10) unsigned NOT NULL default '0',
  `PHYSENDRUN_MASK_S11CRC` int(10) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  `FILENAMEL0` varchar(255) NOT NULL default '',
  `FILENAMEL2` varchar(255) NOT NULL default '',
  `BELONGED_TO` varchar(255) NOT NULL default '',
  `INSERT_TIME` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID_TRASH`),
  KEY `TID_RUN_FRAG_index` (`ID_RUN_FRAG`),
  KEY `TID_ROOT_L0_index` (`ID_ROOT_L0`),
  KEY `TBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `TTRKCALIB_index` (`TRK_CALIB_USED`),
  KEY `TFNAME0_index` (`FILENAMEL0`),
  KEY `TFNAME2_index` (`FILENAMEL2`),
  KEY `TBELONG_index` (`BELONGED_TO`)
) ;

CREATE TABLE `GL_CALO_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `SECTION_index` (`SECTION`),
  KEY `EV_ROOT_index` (`EV_ROOT`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID1_index` (`VALIDATION`)
) ;

CREATE TABLE `GL_CALOPULSE_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `SECTION` tinyint(3) unsigned NOT NULL default '0',
  `PULSED_STRIP` tinyint(3) unsigned default NULL,
  `PULSE_AMPLITUDE` tinyint(3) unsigned default NULL,
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `PSECTION_index` (`SECTION`),
  KEY `PULSEDSTRIP_index` (`PULSED_STRIP`),
  KEY `PULSEAMPL_index` (`PULSE_AMPLITUDE`),
  KEY `PEV_ROOT_index` (`EV_ROOT`),
  KEY `PID_ROOT_index` (`ID_ROOT_L0`),
  KEY `PBOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `PVALID1_index` (`VALIDATION`)
) ;


CREATE TABLE `GL_TRK_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT_CALIBTRK1` int(10) unsigned default NULL,
  `EV_ROOT_CALIBTRK2` int(10) unsigned default NULL,
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT1` int(10) unsigned NOT NULL default '0',
  `PKT1` int(10) unsigned NOT NULL default '0',
  `OBT2` int(10) unsigned NOT NULL default '0',
  `PKT2` int(10) unsigned NOT NULL default '0',
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  `VALIDATION` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `EV_ROOT_CALIBTRK1index` (`EV_ROOT_CALIBTRK1`),
  KEY `EV_ROOT_CALIBTRK2index` (`EV_ROOT_CALIBTRK2`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`),
  KEY `VALID2_index` (`VALIDATION`)
) ;

CREATE TABLE `GL_S4_CALIB` (
  `ID` int(10) unsigned NOT NULL auto_increment,
  `ID_ROOT_L0` int(10) unsigned NOT NULL default '0',
  `EV_ROOT` int(10) unsigned NOT NULL default '0',
  `FROM_TIME` int(10) unsigned NOT NULL default '0',
  `TO_TIME` int(10) unsigned NOT NULL default '0',
  `OBT` int(10) unsigned NOT NULL default '0',
  `PKT` int(10) unsigned NOT NULL default '0',  
  `BOOT_NUMBER` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ID_ROOT_index` (`ID_ROOT_L0`),
  KEY `BOOTNUMBER_index` (`BOOT_NUMBER`)
) ;


drop table if exists dbname.ROOT_TABLE ;

CREATE TABLE `dbname`.`ROOT_TABLE` (
  `ID_N`  int unsigned NOT NULL auto_increment COMMENT 'It is the internal table ID (SERIAL)',
  `FOLDER_NAME` varchar(255)  default '.'  COMMENT 'It is the folder containing the ROOT files', 
  `FILE_NAME` varchar(255) NOT NULL  default 'yoda_nnnnn_mmm_ppp_0' COMMENT 'It is the ROOT filename.',
  `PKT_NUMBER_INIT` int unsigned NOT NULL default '0' COMMENT 'The counter value of the first packet ',
  `PKT_NUMBER_FINAL` int unsigned NOT NULL default '0' COMMENT 'The counter value of the last packet ',
  `PKT_OBT_INIT` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the first packet (ms)',
  `PKT_OBT_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the last packet (ms)',
  `OBT_TIME_SYNC` int unsigned  default '0' COMMENT 'The TIMESYNC used to compute the real time (s)',
  `LAST_TIME_SYNC_INFO` int unsigned  default '0' COMMENT 'The LAST SYNC used to compute the real time (s)',
  `REAL_TIME_INIT` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time of the first packet (s)', 
  `REAL_TIME_LAST` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time of the last packet (s)',
  `BOOT_NUMBER` int unsigned default '0' COMMENT 'The Boot Number',	
  `TIME_OFFSET` int unsigned default '0' COMMENT 'The time offset used (s)',	
  `BAD_PKT` int  default '0' COMMENT 'The number of packet that could have problems. Due to the fact that one or more cadres did not pass the vrl check.',
  `BAD_PKT_READ` int  default '0' COMMENT 'The number of packet that could have problems. In general CRC errors detected in the Packet Reader part',
  `BAD_PKT_CALREAD` int  default '0' COMMENT 'The number of Calibration packet that could have problems.',
  `NUM_PKT_SAVED` int  default '0' COMMENT 'The total number of packet saved in the ROOT file',
  `INPUT_NAME` varchar(255) default './nnnnmmm.pam' COMMENT 'It is the filename of the input file',  
  `TIME_IS_ESTIMATED` tinyint(1) unsigned NOT NULL default '0' COMMENT 'No timesync was found for this entry, we use a timesync from the same download',
  `INSERT_TIME` timestamp default CURRENT_TIMESTAMP, 
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  `ON_DISK` varchar(3) NOT NULL default 'YES' COMMENT 'The file is on disk (no deleted)',
 PRIMARY KEY  (`ID_N`)
) 
;

drop table if exists dbname.ROOT_TABLE_BAD ;
CREATE TABLE `dbname`.`ROOT_TABLE_BAD` (
  `ID_N` int unsigned NOT NULL auto_increment COMMENT 'It is the internal table ID',
  `FOLDER_NAME` varchar(255) default '.'  COMMENT 'It is the folder containing the ROOT files', 
  `FILE_NAME` varchar(255) NOT NULL  default 'yoda_nnnnn_mmm_ppp_0' COMMENT 'It is the ROOT filename.',
  `PKT_NUMBER_INIT` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the first packet ',
  `PKT_NUMBER_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the last packet ',
  `PKT_OBT_INIT` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the first packet ',
  `PKT_OBT_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the last packet ',
  `OBT_TIME_SYNC` int unsigned  default '0' COMMENT 'The TIMESYNC used to compute the real time',
  `LAST_TIME_SYNC_INFO` int unsigned default '0' COMMENT 'The LAST SYNC used to compute the real time',
  `REAL_TIME_INIT` int unsigned  NOT NULL default '0' COMMENT 'The Absolute real time of the first packet',
  `REAL_TIME_LAST` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time of the last packet (s)',
  `BOOT_NUMBER` int unsigned default '0' COMMENT 'The Boot Number',	 
  `TIME_OFFSET` int unsigned  default '0' COMMENT 'The time offset us	ed (s)',	
  `BAD_PKT` int  default '0' COMMENT 'The number of packet that could have problems. Due to the fact that one or more cadres did not pass the vrl check.',
  `BAD_PKT_READ` int  default '0' COMMENT 'The number of packet that could have problems. In general CRC errors detected in the EventReader part',
  `BAD_PKT_CALREAD` int  default '0' COMMENT 'The number of Calibration packet that could have problems.',
  `NUM_PKT_SAVED` int  default '0' COMMENT 'The number of packet saved in the ROOT file',
  `INPUT_NAME` varchar(255) default './nnnnmmm.pam' COMMENT 'It is the filename of the input file',  
  `TIME_IS_ESTIMATED` tinyint(1) unsigned NOT NULL default '0' COMMENT 'No timesync was found for this entry, we use a timesync from the same download',
  `INSERT_TIME` timestamp default CURRENT_TIMESTAMP, 
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  `ON_DISK` varchar(3) NOT NULL default 'YES' COMMENT 'The file is on disk (no deleted)',
  PRIMARY KEY  (`ID_N`)
) 
;


INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_002_001','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_002_002','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_003_002','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04584_003_001','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_002_001','2007-01-08 21:00:00',NULL); 
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_002_002','2007-01-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','04586_003_001','2007-01-08 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_002_001','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_003_002','2007-10-08 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08591_003_001','2007-10-08 21:00:00',NULL); 
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_002','2007-10-08 21:00:00',NULL); 
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','08592_004_003','2007-10-08 21:00:00',NULL); 

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_001_002','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_001_003','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_002_001','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_002_002','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_003_001','2008-03-20 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','11310_003_002','2008-03-20 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14033_201_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14034_001_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','14044_001_001','2008-12-15 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_002_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_002_002','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15441_003_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_002_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_003_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_003_002','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_504_001','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15442_504_002','2008-12-15 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','15445_002_001','2008-12-15 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_001','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_002','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_003','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_004','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_005','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_006','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_007','2009-03-16 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','16760_002_008','2009-03-16 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18156_072_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18156_072_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_072_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_072_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_073_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18157_073_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_032_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_032_002','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_033_001','2009-06-10 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','18160_033_002','2009-06-10 21:00:00',NULL);

INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19526_072_001','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19526_072_002','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19539_073_001','2009-09-09 21:00:00',NULL);
INSERT INTO GL_RESURS_OFFSET VALUES(0,'0','19539_073_002','2009-09-09 21:00:00',NULL);

drop table if exists dbname.ROOT_TABLE_MERGING ;
CREATE TABLE `dbname`.`ROOT_TABLE_MERGING` (
  `ID_N` int unsigned NOT NULL auto_increment COMMENT 'It is the internal table ID',
  `ROOT_ID_N` int unsigned NOT NULL  COMMENT 'It is the ID of the ROOT file in table ROOT_TABLE',
  `PKT_NUMBER_INIT` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the first packet ',
  `PKT_NUMBER_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The counter value of the last packet ',
  `PKT_OBT_INIT` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the first packet ',
  `PKT_OBT_FINAL` int unsigned NOT NULL  default '0' COMMENT 'The obt value of the last packet ',
  `REAL_TIME_INIT` int unsigned  NOT NULL default '0' COMMENT 'The Absolute real time from where I want to start',
  `REAL_TIME_LAST` int unsigned NOT NULL  default '0' COMMENT 'The Absolute real time when I want to stop using this ROOT file (s)',
  `BOOT_NUMBER` int unsigned default '0' COMMENT 'The Boot Number',	
  `BAD_PKT_PERCENTAGE` double  default '0' COMMENT 'The percentage of bad packets',
  `GOOD` tinyint(1) unsigned NOT NULL default '1' COMMENT 'The entry must be used if and only if GOOD=1',
  `INSERTED_BY` varchar(4) NOT NULL default 'NONE' COMMENT 'The owner of the file',
  `INSERT_TIME` timestamp default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`ID_N`)
) 
; 

