/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:31 $
 * $Revision: 1.4 $
 * 
 * Implementation of the TofInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
TofInitReader::TofInitReader(void): 
  TechmodelAlgorithm(PacketType::TofInit, "TechmodelTofInitReader") { 
  tofInit = new TofInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TofInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TofInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TofInitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &tofInit, tofInit->Class());
}

/**
 * Unpack the TofInit event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TofInitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
    tofInit->tofInitData        = new TArrayC(dataLength, subData);
}
