/** @file
 * $Author: mocchiut $
 * $Date: 2008/09/23 07:20:25 $
 * $Revision: 1.1.1.1 $
 * 
 * Implementation of the TrkInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
TrkInitReader::TrkInitReader(void): 
  TechmodelAlgorithm(PacketType::TrkInit, "TechmodelTrkInitReader") { 
  trkInit = new TrkInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string TrkInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/TrkInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void TrkInitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &trkInit, trkInit->Class());
}

/**
 * Unpack the TrkInit event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void TrkInitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
    trkInit->trkInitData        = new TArrayC(dataLength, subData);
}
