/** @file
 * $Source: /repository/PamOffLineSW/techmodel/CalibTofReader.cpp,v $
 * $Id: CalibTofReader.cpp,v 1.5 2008-03-04 18:09:30 messineo Exp $
 * $Author: messineo $
 * 
 * Implementation of the LogReader class.
* ToBeDone:
* Control the CRC for the entire data Packet not just for single records
 */


#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
CalibTofReader::CalibTofReader(void): 
  TechmodelAlgorithm(PacketType::Log, "TechmodelCalibTofReader") { 
  calibTof = new CalibTofEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalibTofReader::GetVersionInfo(void) const {
  return 
    "$Header: /repository/PamOffLineSW/techmodel/CalibTofReader.cpp,v 1.5 2008-03-04 18:09:30 messineo Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalibTofReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calibTof, calibTof->Class());
}

/**
 * Unpack the CalibTof event from an input file.
 */
void CalibTofReader::PKT_RunEvent(char* subData, long int dataLength) throw (Exception){
	calibTof->calibTofData        = new TArrayC(dataLength, subData);
}
