/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:31 $
 * $Revision: 1.4 $
 * 
 * Implementation of the CalInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;

/**
 * Constructor. 
 */
CalInitReader::CalInitReader(void): 
  TechmodelAlgorithm(PacketType::CalInit, "TechmodelCalInitReader") { 
  calInit = new CalInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string CalInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/CalInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void CalInitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &calInit, calInit->Class());
}

/**
 * Unpack the CalInit event
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void CalInitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
    calInit->calInitData        = new TArrayC(dataLength, subData);
}
