/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:30 $
 * $Revision: 1.4 $
 * 
 * Implementation of the NdInitReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
NdInitReader::NdInitReader(void): 
  TechmodelAlgorithm(PacketType::NdInit, "TechmodelAcInitReader") { 
  ndInit = new NdInitEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string NdInitReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/NdInitReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void NdInitReader::Init(PamelaRun *run) {
  run->WriteSubPacket(this, &ndInit, ndInit->Class());
}

/**
 * Unpack the NdInit event, which is a dummy packet, from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void NdInitReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
    ndInit->ndInitData        = new TArrayC(dataLength, subData);
}
