/** @file
 * $Author: messineo $
 * $Date: 2008-03-04 18:09:30 $
 * $Revision: 1.5 $
 * 
 * Implementation of the ForcedFECmdReader class.
 */

#include "ReaderAlgorithms.h"

using namespace pamela::techmodel;


/**
 * Constructor. 
 */
ForcedFECmdReader::ForcedFECmdReader(void): 
  TechmodelAlgorithm(PacketType::ForcedFECmd, "TechmodelForcedFECmdReader") { 
  forcedFECmd = new ForcedFECmdEvent();
}

/**
 * Get a string with the version info of the algorithm.
 */
std::string ForcedFECmdReader::GetVersionInfo(void) const {
  return 
    "$Trailer: /home/cvsmanager/yoda/techmodel/ForcedFECmdReader.cpp,v 1.1.1.1 2004/07/06 12:20:23 Maurizio Nagni Exp $\n";
}

/**
 * Initialize the algorithm with a special run. This will initialize the
 * event reader routines for all packet types.
 */
void ForcedFECmdReader::Init(PamelaRun *run) {
   run->WriteSubPacket(this, &forcedFECmd, forcedFECmd->Class());
}

/**
 * Unpack the ForcedFECmd event from an input file.
 * The CPU does not add any CRC control at the packet end.
 * @param EventNumber 
 * @param dataLength 
 */
void ForcedFECmdReader::PKT_RunEvent(char* subData, long int dataLength) throw (WrongCRCException){
       forcedFECmd->forcedFECmdData   = new TArrayC(dataLength, subData);
}
